// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// source: buf/registry/module/v1/label.proto
/**
 * @fileoverview
 * @enhanceable
 * @suppress {missingRequire} reports error on implicit type usages.
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!
/* eslint-disable */
// @ts-nocheck

var jspb = require('google-protobuf');
var goog = jspb;
var global =
    (typeof globalThis !== 'undefined' && globalThis) ||
    (typeof window !== 'undefined' && window) ||
    (typeof global !== 'undefined' && global) ||
    (typeof self !== 'undefined' && self) ||
    (function () { return this; }).call(null) ||
    Function('return this')();

var buf_registry_priv_extension_v1beta1_extension_pb = require('../../../../buf/registry/priv/extension/v1beta1/extension_pb.js');
goog.object.extend(proto, buf_registry_priv_extension_v1beta1_extension_pb);
var buf_validate_validate_pb = require('../../../../buf/validate/validate_pb.js');
goog.object.extend(proto, buf_validate_validate_pb);
var google_protobuf_timestamp_pb = require('google-protobuf/google/protobuf/timestamp_pb.js');
goog.object.extend(proto, google_protobuf_timestamp_pb);
goog.exportSymbol('proto.buf.registry.module.v1.CommitCheckState', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.CommitCheckStatus', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.Label', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.LabelRef', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.LabelRef.Name', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.LabelRef.ValueCase', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.ScopedLabelRef', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.ScopedLabelRef.ValueCase', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.Label = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.module.v1.Label, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.Label.displayName = 'proto.buf.registry.module.v1.Label';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.CommitCheckState = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.module.v1.CommitCheckState, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.CommitCheckState.displayName = 'proto.buf.registry.module.v1.CommitCheckState';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.LabelRef = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, proto.buf.registry.module.v1.LabelRef.oneofGroups_);
};
goog.inherits(proto.buf.registry.module.v1.LabelRef, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.LabelRef.displayName = 'proto.buf.registry.module.v1.LabelRef';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.LabelRef.Name = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.module.v1.LabelRef.Name, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.LabelRef.Name.displayName = 'proto.buf.registry.module.v1.LabelRef.Name';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.ScopedLabelRef = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, proto.buf.registry.module.v1.ScopedLabelRef.oneofGroups_);
};
goog.inherits(proto.buf.registry.module.v1.ScopedLabelRef, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.ScopedLabelRef.displayName = 'proto.buf.registry.module.v1.ScopedLabelRef';
}



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.Label.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.Label.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.Label} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.Label.toObject = function(includeInstance, msg) {
  var f, obj = {
id: jspb.Message.getFieldWithDefault(msg, 1, ""),
createTime: (f = msg.getCreateTime()) && google_protobuf_timestamp_pb.Timestamp.toObject(includeInstance, f),
updateTime: (f = msg.getUpdateTime()) && google_protobuf_timestamp_pb.Timestamp.toObject(includeInstance, f),
archiveTime: (f = msg.getArchiveTime()) && google_protobuf_timestamp_pb.Timestamp.toObject(includeInstance, f),
name: jspb.Message.getFieldWithDefault(msg, 5, ""),
ownerId: jspb.Message.getFieldWithDefault(msg, 6, ""),
moduleId: jspb.Message.getFieldWithDefault(msg, 7, ""),
commitId: jspb.Message.getFieldWithDefault(msg, 8, ""),
updatedByUserId: jspb.Message.getFieldWithDefault(msg, 9, ""),
commitCheckState: (f = msg.getCommitCheckState()) && proto.buf.registry.module.v1.CommitCheckState.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.Label}
 */
proto.buf.registry.module.v1.Label.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.Label;
  return proto.buf.registry.module.v1.Label.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.Label} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.Label}
 */
proto.buf.registry.module.v1.Label.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setId(value);
      break;
    case 2:
      var value = new google_protobuf_timestamp_pb.Timestamp;
      reader.readMessage(value,google_protobuf_timestamp_pb.Timestamp.deserializeBinaryFromReader);
      msg.setCreateTime(value);
      break;
    case 3:
      var value = new google_protobuf_timestamp_pb.Timestamp;
      reader.readMessage(value,google_protobuf_timestamp_pb.Timestamp.deserializeBinaryFromReader);
      msg.setUpdateTime(value);
      break;
    case 4:
      var value = new google_protobuf_timestamp_pb.Timestamp;
      reader.readMessage(value,google_protobuf_timestamp_pb.Timestamp.deserializeBinaryFromReader);
      msg.setArchiveTime(value);
      break;
    case 5:
      var value = /** @type {string} */ (reader.readString());
      msg.setName(value);
      break;
    case 6:
      var value = /** @type {string} */ (reader.readString());
      msg.setOwnerId(value);
      break;
    case 7:
      var value = /** @type {string} */ (reader.readString());
      msg.setModuleId(value);
      break;
    case 8:
      var value = /** @type {string} */ (reader.readString());
      msg.setCommitId(value);
      break;
    case 9:
      var value = /** @type {string} */ (reader.readString());
      msg.setUpdatedByUserId(value);
      break;
    case 10:
      var value = new proto.buf.registry.module.v1.CommitCheckState;
      reader.readMessage(value,proto.buf.registry.module.v1.CommitCheckState.deserializeBinaryFromReader);
      msg.setCommitCheckState(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.Label.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.Label.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.Label} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.Label.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getId();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getCreateTime();
  if (f != null) {
    writer.writeMessage(
      2,
      f,
      google_protobuf_timestamp_pb.Timestamp.serializeBinaryToWriter
    );
  }
  f = message.getUpdateTime();
  if (f != null) {
    writer.writeMessage(
      3,
      f,
      google_protobuf_timestamp_pb.Timestamp.serializeBinaryToWriter
    );
  }
  f = message.getArchiveTime();
  if (f != null) {
    writer.writeMessage(
      4,
      f,
      google_protobuf_timestamp_pb.Timestamp.serializeBinaryToWriter
    );
  }
  f = message.getName();
  if (f.length > 0) {
    writer.writeString(
      5,
      f
    );
  }
  f = message.getOwnerId();
  if (f.length > 0) {
    writer.writeString(
      6,
      f
    );
  }
  f = message.getModuleId();
  if (f.length > 0) {
    writer.writeString(
      7,
      f
    );
  }
  f = message.getCommitId();
  if (f.length > 0) {
    writer.writeString(
      8,
      f
    );
  }
  f = message.getUpdatedByUserId();
  if (f.length > 0) {
    writer.writeString(
      9,
      f
    );
  }
  f = message.getCommitCheckState();
  if (f != null) {
    writer.writeMessage(
      10,
      f,
      proto.buf.registry.module.v1.CommitCheckState.serializeBinaryToWriter
    );
  }
};


/**
 * optional string id = 1;
 * @return {string}
 */
proto.buf.registry.module.v1.Label.prototype.getId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.Label} returns this
 */
proto.buf.registry.module.v1.Label.prototype.setId = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional google.protobuf.Timestamp create_time = 2;
 * @return {?proto.google.protobuf.Timestamp}
 */
proto.buf.registry.module.v1.Label.prototype.getCreateTime = function() {
  return /** @type{?proto.google.protobuf.Timestamp} */ (
    jspb.Message.getWrapperField(this, google_protobuf_timestamp_pb.Timestamp, 2));
};


/**
 * @param {?proto.google.protobuf.Timestamp|undefined} value
 * @return {!proto.buf.registry.module.v1.Label} returns this
*/
proto.buf.registry.module.v1.Label.prototype.setCreateTime = function(value) {
  return jspb.Message.setWrapperField(this, 2, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1.Label} returns this
 */
proto.buf.registry.module.v1.Label.prototype.clearCreateTime = function() {
  return this.setCreateTime(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1.Label.prototype.hasCreateTime = function() {
  return jspb.Message.getField(this, 2) != null;
};


/**
 * optional google.protobuf.Timestamp update_time = 3;
 * @return {?proto.google.protobuf.Timestamp}
 */
proto.buf.registry.module.v1.Label.prototype.getUpdateTime = function() {
  return /** @type{?proto.google.protobuf.Timestamp} */ (
    jspb.Message.getWrapperField(this, google_protobuf_timestamp_pb.Timestamp, 3));
};


/**
 * @param {?proto.google.protobuf.Timestamp|undefined} value
 * @return {!proto.buf.registry.module.v1.Label} returns this
*/
proto.buf.registry.module.v1.Label.prototype.setUpdateTime = function(value) {
  return jspb.Message.setWrapperField(this, 3, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1.Label} returns this
 */
proto.buf.registry.module.v1.Label.prototype.clearUpdateTime = function() {
  return this.setUpdateTime(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1.Label.prototype.hasUpdateTime = function() {
  return jspb.Message.getField(this, 3) != null;
};


/**
 * optional google.protobuf.Timestamp archive_time = 4;
 * @return {?proto.google.protobuf.Timestamp}
 */
proto.buf.registry.module.v1.Label.prototype.getArchiveTime = function() {
  return /** @type{?proto.google.protobuf.Timestamp} */ (
    jspb.Message.getWrapperField(this, google_protobuf_timestamp_pb.Timestamp, 4));
};


/**
 * @param {?proto.google.protobuf.Timestamp|undefined} value
 * @return {!proto.buf.registry.module.v1.Label} returns this
*/
proto.buf.registry.module.v1.Label.prototype.setArchiveTime = function(value) {
  return jspb.Message.setWrapperField(this, 4, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1.Label} returns this
 */
proto.buf.registry.module.v1.Label.prototype.clearArchiveTime = function() {
  return this.setArchiveTime(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1.Label.prototype.hasArchiveTime = function() {
  return jspb.Message.getField(this, 4) != null;
};


/**
 * optional string name = 5;
 * @return {string}
 */
proto.buf.registry.module.v1.Label.prototype.getName = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 5, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.Label} returns this
 */
proto.buf.registry.module.v1.Label.prototype.setName = function(value) {
  return jspb.Message.setProto3StringField(this, 5, value);
};


/**
 * optional string owner_id = 6;
 * @return {string}
 */
proto.buf.registry.module.v1.Label.prototype.getOwnerId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 6, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.Label} returns this
 */
proto.buf.registry.module.v1.Label.prototype.setOwnerId = function(value) {
  return jspb.Message.setProto3StringField(this, 6, value);
};


/**
 * optional string module_id = 7;
 * @return {string}
 */
proto.buf.registry.module.v1.Label.prototype.getModuleId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 7, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.Label} returns this
 */
proto.buf.registry.module.v1.Label.prototype.setModuleId = function(value) {
  return jspb.Message.setProto3StringField(this, 7, value);
};


/**
 * optional string commit_id = 8;
 * @return {string}
 */
proto.buf.registry.module.v1.Label.prototype.getCommitId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 8, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.Label} returns this
 */
proto.buf.registry.module.v1.Label.prototype.setCommitId = function(value) {
  return jspb.Message.setProto3StringField(this, 8, value);
};


/**
 * optional string updated_by_user_id = 9;
 * @return {string}
 */
proto.buf.registry.module.v1.Label.prototype.getUpdatedByUserId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 9, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.Label} returns this
 */
proto.buf.registry.module.v1.Label.prototype.setUpdatedByUserId = function(value) {
  return jspb.Message.setProto3StringField(this, 9, value);
};


/**
 * optional CommitCheckState commit_check_state = 10;
 * @return {?proto.buf.registry.module.v1.CommitCheckState}
 */
proto.buf.registry.module.v1.Label.prototype.getCommitCheckState = function() {
  return /** @type{?proto.buf.registry.module.v1.CommitCheckState} */ (
    jspb.Message.getWrapperField(this, proto.buf.registry.module.v1.CommitCheckState, 10));
};


/**
 * @param {?proto.buf.registry.module.v1.CommitCheckState|undefined} value
 * @return {!proto.buf.registry.module.v1.Label} returns this
*/
proto.buf.registry.module.v1.Label.prototype.setCommitCheckState = function(value) {
  return jspb.Message.setWrapperField(this, 10, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1.Label} returns this
 */
proto.buf.registry.module.v1.Label.prototype.clearCommitCheckState = function() {
  return this.setCommitCheckState(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1.Label.prototype.hasCommitCheckState = function() {
  return jspb.Message.getField(this, 10) != null;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.CommitCheckState.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.CommitCheckState.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.CommitCheckState} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.CommitCheckState.toObject = function(includeInstance, msg) {
  var f, obj = {
status: jspb.Message.getFieldWithDefault(msg, 1, 0),
updateTime: (f = msg.getUpdateTime()) && google_protobuf_timestamp_pb.Timestamp.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.CommitCheckState}
 */
proto.buf.registry.module.v1.CommitCheckState.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.CommitCheckState;
  return proto.buf.registry.module.v1.CommitCheckState.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.CommitCheckState} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.CommitCheckState}
 */
proto.buf.registry.module.v1.CommitCheckState.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {!proto.buf.registry.module.v1.CommitCheckStatus} */ (reader.readEnum());
      msg.setStatus(value);
      break;
    case 3:
      var value = new google_protobuf_timestamp_pb.Timestamp;
      reader.readMessage(value,google_protobuf_timestamp_pb.Timestamp.deserializeBinaryFromReader);
      msg.setUpdateTime(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.CommitCheckState.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.CommitCheckState.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.CommitCheckState} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.CommitCheckState.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getStatus();
  if (f !== 0.0) {
    writer.writeEnum(
      1,
      f
    );
  }
  f = message.getUpdateTime();
  if (f != null) {
    writer.writeMessage(
      3,
      f,
      google_protobuf_timestamp_pb.Timestamp.serializeBinaryToWriter
    );
  }
};


/**
 * optional CommitCheckStatus status = 1;
 * @return {!proto.buf.registry.module.v1.CommitCheckStatus}
 */
proto.buf.registry.module.v1.CommitCheckState.prototype.getStatus = function() {
  return /** @type {!proto.buf.registry.module.v1.CommitCheckStatus} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {!proto.buf.registry.module.v1.CommitCheckStatus} value
 * @return {!proto.buf.registry.module.v1.CommitCheckState} returns this
 */
proto.buf.registry.module.v1.CommitCheckState.prototype.setStatus = function(value) {
  return jspb.Message.setProto3EnumField(this, 1, value);
};


/**
 * optional google.protobuf.Timestamp update_time = 3;
 * @return {?proto.google.protobuf.Timestamp}
 */
proto.buf.registry.module.v1.CommitCheckState.prototype.getUpdateTime = function() {
  return /** @type{?proto.google.protobuf.Timestamp} */ (
    jspb.Message.getWrapperField(this, google_protobuf_timestamp_pb.Timestamp, 3));
};


/**
 * @param {?proto.google.protobuf.Timestamp|undefined} value
 * @return {!proto.buf.registry.module.v1.CommitCheckState} returns this
*/
proto.buf.registry.module.v1.CommitCheckState.prototype.setUpdateTime = function(value) {
  return jspb.Message.setWrapperField(this, 3, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1.CommitCheckState} returns this
 */
proto.buf.registry.module.v1.CommitCheckState.prototype.clearUpdateTime = function() {
  return this.setUpdateTime(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1.CommitCheckState.prototype.hasUpdateTime = function() {
  return jspb.Message.getField(this, 3) != null;
};



/**
 * Oneof group definitions for this message. Each group defines the field
 * numbers belonging to that group. When of these fields' value is set, all
 * other fields in the group are cleared. During deserialization, if multiple
 * fields are encountered for a group, only the last value seen will be kept.
 * @private {!Array<!Array<number>>}
 * @const
 */
proto.buf.registry.module.v1.LabelRef.oneofGroups_ = [[1,2]];

/**
 * @enum {number}
 */
proto.buf.registry.module.v1.LabelRef.ValueCase = {
  VALUE_NOT_SET: 0,
  ID: 1,
  NAME: 2
};

/**
 * @return {proto.buf.registry.module.v1.LabelRef.ValueCase}
 */
proto.buf.registry.module.v1.LabelRef.prototype.getValueCase = function() {
  return /** @type {proto.buf.registry.module.v1.LabelRef.ValueCase} */(jspb.Message.computeOneofCase(this, proto.buf.registry.module.v1.LabelRef.oneofGroups_[0]));
};



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.LabelRef.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.LabelRef.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.LabelRef} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.LabelRef.toObject = function(includeInstance, msg) {
  var f, obj = {
id: (f = jspb.Message.getField(msg, 1)) == null ? undefined : f,
name: (f = msg.getName()) && proto.buf.registry.module.v1.LabelRef.Name.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.LabelRef}
 */
proto.buf.registry.module.v1.LabelRef.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.LabelRef;
  return proto.buf.registry.module.v1.LabelRef.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.LabelRef} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.LabelRef}
 */
proto.buf.registry.module.v1.LabelRef.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setId(value);
      break;
    case 2:
      var value = new proto.buf.registry.module.v1.LabelRef.Name;
      reader.readMessage(value,proto.buf.registry.module.v1.LabelRef.Name.deserializeBinaryFromReader);
      msg.setName(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.LabelRef.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.LabelRef.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.LabelRef} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.LabelRef.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {string} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getName();
  if (f != null) {
    writer.writeMessage(
      2,
      f,
      proto.buf.registry.module.v1.LabelRef.Name.serializeBinaryToWriter
    );
  }
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.LabelRef.Name.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.LabelRef.Name.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.LabelRef.Name} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.LabelRef.Name.toObject = function(includeInstance, msg) {
  var f, obj = {
owner: jspb.Message.getFieldWithDefault(msg, 1, ""),
module: jspb.Message.getFieldWithDefault(msg, 2, ""),
label: jspb.Message.getFieldWithDefault(msg, 3, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.LabelRef.Name}
 */
proto.buf.registry.module.v1.LabelRef.Name.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.LabelRef.Name;
  return proto.buf.registry.module.v1.LabelRef.Name.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.LabelRef.Name} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.LabelRef.Name}
 */
proto.buf.registry.module.v1.LabelRef.Name.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setOwner(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setModule(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setLabel(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.LabelRef.Name.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.LabelRef.Name.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.LabelRef.Name} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.LabelRef.Name.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getOwner();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getModule();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getLabel();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
};


/**
 * optional string owner = 1;
 * @return {string}
 */
proto.buf.registry.module.v1.LabelRef.Name.prototype.getOwner = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.LabelRef.Name} returns this
 */
proto.buf.registry.module.v1.LabelRef.Name.prototype.setOwner = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string module = 2;
 * @return {string}
 */
proto.buf.registry.module.v1.LabelRef.Name.prototype.getModule = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.LabelRef.Name} returns this
 */
proto.buf.registry.module.v1.LabelRef.Name.prototype.setModule = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional string label = 3;
 * @return {string}
 */
proto.buf.registry.module.v1.LabelRef.Name.prototype.getLabel = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.LabelRef.Name} returns this
 */
proto.buf.registry.module.v1.LabelRef.Name.prototype.setLabel = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};


/**
 * optional string id = 1;
 * @return {string}
 */
proto.buf.registry.module.v1.LabelRef.prototype.getId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.LabelRef} returns this
 */
proto.buf.registry.module.v1.LabelRef.prototype.setId = function(value) {
  return jspb.Message.setOneofField(this, 1, proto.buf.registry.module.v1.LabelRef.oneofGroups_[0], value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.buf.registry.module.v1.LabelRef} returns this
 */
proto.buf.registry.module.v1.LabelRef.prototype.clearId = function() {
  return jspb.Message.setOneofField(this, 1, proto.buf.registry.module.v1.LabelRef.oneofGroups_[0], undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1.LabelRef.prototype.hasId = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional Name name = 2;
 * @return {?proto.buf.registry.module.v1.LabelRef.Name}
 */
proto.buf.registry.module.v1.LabelRef.prototype.getName = function() {
  return /** @type{?proto.buf.registry.module.v1.LabelRef.Name} */ (
    jspb.Message.getWrapperField(this, proto.buf.registry.module.v1.LabelRef.Name, 2));
};


/**
 * @param {?proto.buf.registry.module.v1.LabelRef.Name|undefined} value
 * @return {!proto.buf.registry.module.v1.LabelRef} returns this
*/
proto.buf.registry.module.v1.LabelRef.prototype.setName = function(value) {
  return jspb.Message.setOneofWrapperField(this, 2, proto.buf.registry.module.v1.LabelRef.oneofGroups_[0], value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1.LabelRef} returns this
 */
proto.buf.registry.module.v1.LabelRef.prototype.clearName = function() {
  return this.setName(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1.LabelRef.prototype.hasName = function() {
  return jspb.Message.getField(this, 2) != null;
};



/**
 * Oneof group definitions for this message. Each group defines the field
 * numbers belonging to that group. When of these fields' value is set, all
 * other fields in the group are cleared. During deserialization, if multiple
 * fields are encountered for a group, only the last value seen will be kept.
 * @private {!Array<!Array<number>>}
 * @const
 */
proto.buf.registry.module.v1.ScopedLabelRef.oneofGroups_ = [[1,2]];

/**
 * @enum {number}
 */
proto.buf.registry.module.v1.ScopedLabelRef.ValueCase = {
  VALUE_NOT_SET: 0,
  ID: 1,
  NAME: 2
};

/**
 * @return {proto.buf.registry.module.v1.ScopedLabelRef.ValueCase}
 */
proto.buf.registry.module.v1.ScopedLabelRef.prototype.getValueCase = function() {
  return /** @type {proto.buf.registry.module.v1.ScopedLabelRef.ValueCase} */(jspb.Message.computeOneofCase(this, proto.buf.registry.module.v1.ScopedLabelRef.oneofGroups_[0]));
};



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.ScopedLabelRef.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.ScopedLabelRef.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.ScopedLabelRef} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.ScopedLabelRef.toObject = function(includeInstance, msg) {
  var f, obj = {
id: (f = jspb.Message.getField(msg, 1)) == null ? undefined : f,
name: (f = jspb.Message.getField(msg, 2)) == null ? undefined : f
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.ScopedLabelRef}
 */
proto.buf.registry.module.v1.ScopedLabelRef.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.ScopedLabelRef;
  return proto.buf.registry.module.v1.ScopedLabelRef.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.ScopedLabelRef} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.ScopedLabelRef}
 */
proto.buf.registry.module.v1.ScopedLabelRef.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setId(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setName(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.ScopedLabelRef.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.ScopedLabelRef.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.ScopedLabelRef} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.ScopedLabelRef.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {string} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeString(
      1,
      f
    );
  }
  f = /** @type {string} */ (jspb.Message.getField(message, 2));
  if (f != null) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional string id = 1;
 * @return {string}
 */
proto.buf.registry.module.v1.ScopedLabelRef.prototype.getId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.ScopedLabelRef} returns this
 */
proto.buf.registry.module.v1.ScopedLabelRef.prototype.setId = function(value) {
  return jspb.Message.setOneofField(this, 1, proto.buf.registry.module.v1.ScopedLabelRef.oneofGroups_[0], value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.buf.registry.module.v1.ScopedLabelRef} returns this
 */
proto.buf.registry.module.v1.ScopedLabelRef.prototype.clearId = function() {
  return jspb.Message.setOneofField(this, 1, proto.buf.registry.module.v1.ScopedLabelRef.oneofGroups_[0], undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1.ScopedLabelRef.prototype.hasId = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional string name = 2;
 * @return {string}
 */
proto.buf.registry.module.v1.ScopedLabelRef.prototype.getName = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.ScopedLabelRef} returns this
 */
proto.buf.registry.module.v1.ScopedLabelRef.prototype.setName = function(value) {
  return jspb.Message.setOneofField(this, 2, proto.buf.registry.module.v1.ScopedLabelRef.oneofGroups_[0], value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.buf.registry.module.v1.ScopedLabelRef} returns this
 */
proto.buf.registry.module.v1.ScopedLabelRef.prototype.clearName = function() {
  return jspb.Message.setOneofField(this, 2, proto.buf.registry.module.v1.ScopedLabelRef.oneofGroups_[0], undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1.ScopedLabelRef.prototype.hasName = function() {
  return jspb.Message.getField(this, 2) != null;
};


/**
 * @enum {number}
 */
proto.buf.registry.module.v1.CommitCheckStatus = {
  COMMIT_CHECK_STATUS_UNSPECIFIED: 0,
  COMMIT_CHECK_STATUS_DISABLED: 1,
  COMMIT_CHECK_STATUS_PASSED: 2,
  COMMIT_CHECK_STATUS_PENDING: 3,
  COMMIT_CHECK_STATUS_REJECTED: 4,
  COMMIT_CHECK_STATUS_APPROVED: 5
};

goog.object.extend(exports, proto.buf.registry.module.v1);
