// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// source: buf/registry/module/v1/graph_service.proto
/**
 * @fileoverview
 * @enhanceable
 * @suppress {missingRequire} reports error on implicit type usages.
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!
/* eslint-disable */
// @ts-nocheck

var jspb = require('google-protobuf');
var goog = jspb;
var global =
    (typeof globalThis !== 'undefined' && globalThis) ||
    (typeof window !== 'undefined' && window) ||
    (typeof global !== 'undefined' && global) ||
    (typeof self !== 'undefined' && self) ||
    (function () { return this; }).call(null) ||
    Function('return this')();

var buf_registry_module_v1_graph_pb = require('../../../../buf/registry/module/v1/graph_pb.js');
goog.object.extend(proto, buf_registry_module_v1_graph_pb);
var buf_registry_module_v1_resource_pb = require('../../../../buf/registry/module/v1/resource_pb.js');
goog.object.extend(proto, buf_registry_module_v1_resource_pb);
var buf_validate_validate_pb = require('../../../../buf/validate/validate_pb.js');
goog.object.extend(proto, buf_validate_validate_pb);
goog.exportSymbol('proto.buf.registry.module.v1.GetGraphRequest', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.GetGraphResponse', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.GetGraphRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1.GetGraphRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1.GetGraphRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.GetGraphRequest.displayName = 'proto.buf.registry.module.v1.GetGraphRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.GetGraphResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.module.v1.GetGraphResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.GetGraphResponse.displayName = 'proto.buf.registry.module.v1.GetGraphResponse';
}

/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1.GetGraphRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.GetGraphRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.GetGraphRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.GetGraphRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.GetGraphRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
resourceRefsList: jspb.Message.toObjectList(msg.getResourceRefsList(),
    buf_registry_module_v1_resource_pb.ResourceRef.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.GetGraphRequest}
 */
proto.buf.registry.module.v1.GetGraphRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.GetGraphRequest;
  return proto.buf.registry.module.v1.GetGraphRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.GetGraphRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.GetGraphRequest}
 */
proto.buf.registry.module.v1.GetGraphRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1_resource_pb.ResourceRef;
      reader.readMessage(value,buf_registry_module_v1_resource_pb.ResourceRef.deserializeBinaryFromReader);
      msg.addResourceRefs(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.GetGraphRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.GetGraphRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.GetGraphRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.GetGraphRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getResourceRefsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_module_v1_resource_pb.ResourceRef.serializeBinaryToWriter
    );
  }
};


/**
 * repeated ResourceRef resource_refs = 1;
 * @return {!Array<!proto.buf.registry.module.v1.ResourceRef>}
 */
proto.buf.registry.module.v1.GetGraphRequest.prototype.getResourceRefsList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1.ResourceRef>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_module_v1_resource_pb.ResourceRef, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1.ResourceRef>} value
 * @return {!proto.buf.registry.module.v1.GetGraphRequest} returns this
*/
proto.buf.registry.module.v1.GetGraphRequest.prototype.setResourceRefsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1.ResourceRef=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1.ResourceRef}
 */
proto.buf.registry.module.v1.GetGraphRequest.prototype.addResourceRefs = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1.ResourceRef, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1.GetGraphRequest} returns this
 */
proto.buf.registry.module.v1.GetGraphRequest.prototype.clearResourceRefsList = function() {
  return this.setResourceRefsList([]);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.GetGraphResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.GetGraphResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.GetGraphResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.GetGraphResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
graph: (f = msg.getGraph()) && buf_registry_module_v1_graph_pb.Graph.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.GetGraphResponse}
 */
proto.buf.registry.module.v1.GetGraphResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.GetGraphResponse;
  return proto.buf.registry.module.v1.GetGraphResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.GetGraphResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.GetGraphResponse}
 */
proto.buf.registry.module.v1.GetGraphResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1_graph_pb.Graph;
      reader.readMessage(value,buf_registry_module_v1_graph_pb.Graph.deserializeBinaryFromReader);
      msg.setGraph(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.GetGraphResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.GetGraphResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.GetGraphResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.GetGraphResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getGraph();
  if (f != null) {
    writer.writeMessage(
      1,
      f,
      buf_registry_module_v1_graph_pb.Graph.serializeBinaryToWriter
    );
  }
};


/**
 * optional Graph graph = 1;
 * @return {?proto.buf.registry.module.v1.Graph}
 */
proto.buf.registry.module.v1.GetGraphResponse.prototype.getGraph = function() {
  return /** @type{?proto.buf.registry.module.v1.Graph} */ (
    jspb.Message.getWrapperField(this, buf_registry_module_v1_graph_pb.Graph, 1));
};


/**
 * @param {?proto.buf.registry.module.v1.Graph|undefined} value
 * @return {!proto.buf.registry.module.v1.GetGraphResponse} returns this
*/
proto.buf.registry.module.v1.GetGraphResponse.prototype.setGraph = function(value) {
  return jspb.Message.setWrapperField(this, 1, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1.GetGraphResponse} returns this
 */
proto.buf.registry.module.v1.GetGraphResponse.prototype.clearGraph = function() {
  return this.setGraph(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1.GetGraphResponse.prototype.hasGraph = function() {
  return jspb.Message.getField(this, 1) != null;
};


goog.object.extend(exports, proto.buf.registry.module.v1);
