// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// @generated by protoc-gen-es v2.2.2 with parameter "target=ts"
// @generated from file buf/registry/owner/v1/user_service.proto (package buf.registry.owner.v1, syntax proto3)
/* eslint-disable */

import type { GenEnum, GenFile, GenMessage, GenService } from "@bufbuild/protobuf/codegenv1";
import { enumDesc, fileDesc, messageDesc, serviceDesc } from "@bufbuild/protobuf/codegenv1";
import type { OrganizationRef } from "./organization_pb";
import { file_buf_registry_owner_v1_organization } from "./organization_pb";
import type { User, UserRef, UserState, UserType, UserVerificationStatus } from "./user_pb";
import { file_buf_registry_owner_v1_user } from "./user_pb";
import { file_buf_validate_validate } from "../../../validate/validate_pb";
import type { Message } from "@bufbuild/protobuf";

/**
 * Describes the file buf/registry/owner/v1/user_service.proto.
 */
export const file_buf_registry_owner_v1_user_service: GenFile = /*@__PURE__*/
  fileDesc("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", [file_buf_registry_owner_v1_organization, file_buf_registry_owner_v1_user, file_buf_validate_validate]);

/**
 * @generated from message buf.registry.owner.v1.GetUsersRequest
 */
export type GetUsersRequest = Message<"buf.registry.owner.v1.GetUsersRequest"> & {
  /**
   * The Users to request.
   *
   * @generated from field: repeated buf.registry.owner.v1.UserRef user_refs = 1;
   */
  userRefs: UserRef[];
};

/**
 * Describes the message buf.registry.owner.v1.GetUsersRequest.
 * Use `create(GetUsersRequestSchema)` to create a new message.
 */
export const GetUsersRequestSchema: GenMessage<GetUsersRequest> = /*@__PURE__*/
  messageDesc(file_buf_registry_owner_v1_user_service, 0);

/**
 * @generated from message buf.registry.owner.v1.GetUsersResponse
 */
export type GetUsersResponse = Message<"buf.registry.owner.v1.GetUsersResponse"> & {
  /**
   * The retrieved Users in the same order as requested.
   *
   * @generated from field: repeated buf.registry.owner.v1.User users = 1;
   */
  users: User[];
};

/**
 * Describes the message buf.registry.owner.v1.GetUsersResponse.
 * Use `create(GetUsersResponseSchema)` to create a new message.
 */
export const GetUsersResponseSchema: GenMessage<GetUsersResponse> = /*@__PURE__*/
  messageDesc(file_buf_registry_owner_v1_user_service, 1);

/**
 * @generated from message buf.registry.owner.v1.ListUsersRequest
 */
export type ListUsersRequest = Message<"buf.registry.owner.v1.ListUsersRequest"> & {
  /**
   * The maximum number of items to return.
   *
   * The default value is 10.
   *
   * @generated from field: uint32 page_size = 1;
   */
  pageSize: number;

  /**
   * The page to start from.
   *
   * If empty, the first page is returned,
   *
   * @generated from field: string page_token = 2;
   */
  pageToken: string;

  /**
   * The specific Organizations to list Users for.
   *
   * If this is empty, all Users for all Organizations are listed, but this functionality
   * is limited to Users with the necessary permissions.
   *
   * @generated from field: repeated buf.registry.owner.v1.OrganizationRef organization_refs = 3;
   */
  organizationRefs: OrganizationRef[];

  /**
   * The order to return the Users.
   *
   * If not specified, defaults to ORDER_CREATE_TIME_DESC.
   *
   * @generated from field: buf.registry.owner.v1.ListUsersRequest.Order order = 4;
   */
  order: ListUsersRequest_Order;

  /**
   * Only return Users of these types.
   *
   * @generated from field: repeated buf.registry.owner.v1.UserType has_types = 5;
   */
  hasTypes: UserType[];

  /**
   * Only return Users of these states.
   *
   * @generated from field: repeated buf.registry.owner.v1.UserState has_states = 6;
   */
  hasStates: UserState[];
};

/**
 * Describes the message buf.registry.owner.v1.ListUsersRequest.
 * Use `create(ListUsersRequestSchema)` to create a new message.
 */
export const ListUsersRequestSchema: GenMessage<ListUsersRequest> = /*@__PURE__*/
  messageDesc(file_buf_registry_owner_v1_user_service, 2);

/**
 * The list order.
 *
 * @generated from enum buf.registry.owner.v1.ListUsersRequest.Order
 */
export enum ListUsersRequest_Order {
  /**
   * @generated from enum value: ORDER_UNSPECIFIED = 0;
   */
  UNSPECIFIED = 0,

  /**
   * Order by create_time newest to oldest.
   *
   * @generated from enum value: ORDER_CREATE_TIME_DESC = 1;
   */
  CREATE_TIME_DESC = 1,

  /**
   * Order by create_time oldest to newest.
   *
   * @generated from enum value: ORDER_CREATE_TIME_ASC = 2;
   */
  CREATE_TIME_ASC = 2,
}

/**
 * Describes the enum buf.registry.owner.v1.ListUsersRequest.Order.
 */
export const ListUsersRequest_OrderSchema: GenEnum<ListUsersRequest_Order> = /*@__PURE__*/
  enumDesc(file_buf_registry_owner_v1_user_service, 2, 0);

/**
 * @generated from message buf.registry.owner.v1.ListUsersResponse
 */
export type ListUsersResponse = Message<"buf.registry.owner.v1.ListUsersResponse"> & {
  /**
   * The next page token.
   *
   * If empty, there are no more pages.
   *
   * @generated from field: string next_page_token = 1;
   */
  nextPageToken: string;

  /**
   * The list of Users.
   *
   * @generated from field: repeated buf.registry.owner.v1.User users = 2;
   */
  users: User[];
};

/**
 * Describes the message buf.registry.owner.v1.ListUsersResponse.
 * Use `create(ListUsersResponseSchema)` to create a new message.
 */
export const ListUsersResponseSchema: GenMessage<ListUsersResponse> = /*@__PURE__*/
  messageDesc(file_buf_registry_owner_v1_user_service, 3);

/**
 * @generated from message buf.registry.owner.v1.CreateUsersRequest
 */
export type CreateUsersRequest = Message<"buf.registry.owner.v1.CreateUsersRequest"> & {
  /**
   * The Users to create.
   *
   * @generated from field: repeated buf.registry.owner.v1.CreateUsersRequest.Value values = 1;
   */
  values: CreateUsersRequest_Value[];
};

/**
 * Describes the message buf.registry.owner.v1.CreateUsersRequest.
 * Use `create(CreateUsersRequestSchema)` to create a new message.
 */
export const CreateUsersRequestSchema: GenMessage<CreateUsersRequest> = /*@__PURE__*/
  messageDesc(file_buf_registry_owner_v1_user_service, 4);

/**
 * An individual request to create a User.
 *
 * @generated from message buf.registry.owner.v1.CreateUsersRequest.Value
 */
export type CreateUsersRequest_Value = Message<"buf.registry.owner.v1.CreateUsersRequest.Value"> & {
  /**
   * The name of the User.
   *
   * @generated from field: string name = 1;
   */
  name: string;

  /**
   * The type of the User.
   *
   * If not set, the default USER_TYPE_STANDARD is used.
   *
   * @generated from field: buf.registry.owner.v1.UserType type = 2;
   */
  type: UserType;

  /**
   * The configurable description of the User.
   *
   * @generated from field: string description = 3;
   */
  description: string;

  /**
   * The configurable URL that represents the homepage for a User.
   *
   * @generated from field: string url = 4;
   */
  url: string;

  /**
   * The verification status of the User.
   *
   * If not set, the User will default to VERIFICATION_STATUS_UNVERIFIED.
   *
   * @generated from field: buf.registry.owner.v1.UserVerificationStatus verification_status = 5;
   */
  verificationStatus: UserVerificationStatus;
};

/**
 * Describes the message buf.registry.owner.v1.CreateUsersRequest.Value.
 * Use `create(CreateUsersRequest_ValueSchema)` to create a new message.
 */
export const CreateUsersRequest_ValueSchema: GenMessage<CreateUsersRequest_Value> = /*@__PURE__*/
  messageDesc(file_buf_registry_owner_v1_user_service, 4, 0);

/**
 * @generated from message buf.registry.owner.v1.CreateUsersResponse
 */
export type CreateUsersResponse = Message<"buf.registry.owner.v1.CreateUsersResponse"> & {
  /**
   * The created Users in the same order as given on the request.
   *
   * @generated from field: repeated buf.registry.owner.v1.User users = 1;
   */
  users: User[];
};

/**
 * Describes the message buf.registry.owner.v1.CreateUsersResponse.
 * Use `create(CreateUsersResponseSchema)` to create a new message.
 */
export const CreateUsersResponseSchema: GenMessage<CreateUsersResponse> = /*@__PURE__*/
  messageDesc(file_buf_registry_owner_v1_user_service, 5);

/**
 * @generated from message buf.registry.owner.v1.UpdateUsersRequest
 */
export type UpdateUsersRequest = Message<"buf.registry.owner.v1.UpdateUsersRequest"> & {
  /**
   * The Users to update.
   *
   * @generated from field: repeated buf.registry.owner.v1.UpdateUsersRequest.Value values = 1;
   */
  values: UpdateUsersRequest_Value[];
};

/**
 * Describes the message buf.registry.owner.v1.UpdateUsersRequest.
 * Use `create(UpdateUsersRequestSchema)` to create a new message.
 */
export const UpdateUsersRequestSchema: GenMessage<UpdateUsersRequest> = /*@__PURE__*/
  messageDesc(file_buf_registry_owner_v1_user_service, 6);

/**
 * An individual request to update a User.
 *
 * @generated from message buf.registry.owner.v1.UpdateUsersRequest.Value
 */
export type UpdateUsersRequest_Value = Message<"buf.registry.owner.v1.UpdateUsersRequest.Value"> & {
  /**
   * The User to update.
   *
   * @generated from field: buf.registry.owner.v1.UserRef user_ref = 1;
   */
  userRef?: UserRef;

  /**
   * The state of the User.
   *
   * @generated from field: optional buf.registry.owner.v1.UserState state = 2;
   */
  state?: UserState;

  /**
   * The configurable description of the User.
   *
   * @generated from field: optional string description = 3;
   */
  description?: string;

  /**
   * The configurable URL that represents the homepage for a User.
   *
   * @generated from field: optional string url = 4;
   */
  url?: string;

  /**
   * The verification status of the User.
   *
   * @generated from field: optional buf.registry.owner.v1.UserVerificationStatus verification_status = 5;
   */
  verificationStatus?: UserVerificationStatus;
};

/**
 * Describes the message buf.registry.owner.v1.UpdateUsersRequest.Value.
 * Use `create(UpdateUsersRequest_ValueSchema)` to create a new message.
 */
export const UpdateUsersRequest_ValueSchema: GenMessage<UpdateUsersRequest_Value> = /*@__PURE__*/
  messageDesc(file_buf_registry_owner_v1_user_service, 6, 0);

/**
 * @generated from message buf.registry.owner.v1.UpdateUsersResponse
 */
export type UpdateUsersResponse = Message<"buf.registry.owner.v1.UpdateUsersResponse"> & {
  /**
   * The updated Users in the same order as given on the request.
   *
   * @generated from field: repeated buf.registry.owner.v1.User users = 1;
   */
  users: User[];
};

/**
 * Describes the message buf.registry.owner.v1.UpdateUsersResponse.
 * Use `create(UpdateUsersResponseSchema)` to create a new message.
 */
export const UpdateUsersResponseSchema: GenMessage<UpdateUsersResponse> = /*@__PURE__*/
  messageDesc(file_buf_registry_owner_v1_user_service, 7);

/**
 * @generated from message buf.registry.owner.v1.DeleteUsersRequest
 */
export type DeleteUsersRequest = Message<"buf.registry.owner.v1.DeleteUsersRequest"> & {
  /**
   * The Users to delete.
   *
   * @generated from field: repeated buf.registry.owner.v1.UserRef user_refs = 1;
   */
  userRefs: UserRef[];
};

/**
 * Describes the message buf.registry.owner.v1.DeleteUsersRequest.
 * Use `create(DeleteUsersRequestSchema)` to create a new message.
 */
export const DeleteUsersRequestSchema: GenMessage<DeleteUsersRequest> = /*@__PURE__*/
  messageDesc(file_buf_registry_owner_v1_user_service, 8);

/**
 * @generated from message buf.registry.owner.v1.DeleteUsersResponse
 */
export type DeleteUsersResponse = Message<"buf.registry.owner.v1.DeleteUsersResponse"> & {
};

/**
 * Describes the message buf.registry.owner.v1.DeleteUsersResponse.
 * Use `create(DeleteUsersResponseSchema)` to create a new message.
 */
export const DeleteUsersResponseSchema: GenMessage<DeleteUsersResponse> = /*@__PURE__*/
  messageDesc(file_buf_registry_owner_v1_user_service, 9);

/**
 * Operate on Users.
 *
 * @generated from service buf.registry.owner.v1.UserService
 */
export const UserService: GenService<{
  /**
   * Get Users by id or name.
   *
   * @generated from rpc buf.registry.owner.v1.UserService.GetUsers
   */
  getUsers: {
    methodKind: "unary";
    input: typeof GetUsersRequestSchema;
    output: typeof GetUsersResponseSchema;
  },
  /**
   * List Users, usually by Organization.
   *
   * @generated from rpc buf.registry.owner.v1.UserService.ListUsers
   */
  listUsers: {
    methodKind: "unary";
    input: typeof ListUsersRequestSchema;
    output: typeof ListUsersResponseSchema;
  },
  /**
   * Create new Users.
   *
   * This operation is atomic. Either all Users are created or an error is returned.
   *
   * @generated from rpc buf.registry.owner.v1.UserService.CreateUsers
   */
  createUsers: {
    methodKind: "unary";
    input: typeof CreateUsersRequestSchema;
    output: typeof CreateUsersResponseSchema;
  },
  /**
   * Update existing Users.
   *
   * This operation is atomic. Either all Users are updated or an error is returned.
   *
   * @generated from rpc buf.registry.owner.v1.UserService.UpdateUsers
   */
  updateUsers: {
    methodKind: "unary";
    input: typeof UpdateUsersRequestSchema;
    output: typeof UpdateUsersResponseSchema;
  },
  /**
   * Delete existing Users.
   *
   * This operation is atomic. Either all Users are deleted or an error is returned.
   * Duplicate UserRefs are allowed, and only one User will be deleted. Likewise,
   * duplicate UserRefs belonging to the same User, by id or name, are allowed, and
   * only one User will be deleted.
   *
   * @generated from rpc buf.registry.owner.v1.UserService.DeleteUsers
   */
  deleteUsers: {
    methodKind: "unary";
    input: typeof DeleteUsersRequestSchema;
    output: typeof DeleteUsersResponseSchema;
  },
}> = /*@__PURE__*/
  serviceDesc(file_buf_registry_owner_v1_user_service, 0);

