// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// @generated by protoc-gen-es v2.2.2 with parameter "target=ts"
// @generated from file buf/registry/module/v1beta1/resource_service.proto (package buf.registry.module.v1beta1, syntax proto3)
/* eslint-disable */

import type { GenFile, GenMessage, GenService } from "@bufbuild/protobuf/codegenv1";
import { fileDesc, messageDesc, serviceDesc } from "@bufbuild/protobuf/codegenv1";
import type { DigestType } from "./digest_pb";
import { file_buf_registry_module_v1beta1_digest } from "./digest_pb";
import type { Resource, ResourceRef } from "./resource_pb";
import { file_buf_registry_module_v1beta1_resource } from "./resource_pb";
import { file_buf_validate_validate } from "../../../validate/validate_pb";
import type { Message } from "@bufbuild/protobuf";

/**
 * Describes the file buf/registry/module/v1beta1/resource_service.proto.
 */
export const file_buf_registry_module_v1beta1_resource_service: GenFile = /*@__PURE__*/
  fileDesc("CjJidWYvcmVnaXN0cnkvbW9kdWxlL3YxYmV0YTEvcmVzb3VyY2Vfc2VydmljZS5wcm90bxIbYnVmLnJlZ2lzdHJ5Lm1vZHVsZS52MWJldGExIqsBChNHZXRSZXNvdXJjZXNSZXF1ZXN0EkwKDXJlc291cmNlX3JlZnMYASADKAsyKC5idWYucmVnaXN0cnkubW9kdWxlLnYxYmV0YTEuUmVzb3VyY2VSZWZCC7pICJIBBQgBEPoBEkYKC2RpZ2VzdF90eXBlGAIgASgOMicuYnVmLnJlZ2lzdHJ5Lm1vZHVsZS52MWJldGExLkRpZ2VzdFR5cGVCCLpIBYIBAhABIloKFEdldFJlc291cmNlc1Jlc3BvbnNlEkIKCXJlc291cmNlcxgBIAMoCzIlLmJ1Zi5yZWdpc3RyeS5tb2R1bGUudjFiZXRhMS5SZXNvdXJjZUIIukgFkgECCAEyiwEKD1Jlc291cmNlU2VydmljZRJ4CgxHZXRSZXNvdXJjZXMSMC5idWYucmVnaXN0cnkubW9kdWxlLnYxYmV0YTEuR2V0UmVzb3VyY2VzUmVxdWVzdBoxLmJ1Zi5yZWdpc3RyeS5tb2R1bGUudjFiZXRhMS5HZXRSZXNvdXJjZXNSZXNwb25zZSIDkAIBQlNaUWJ1Zi5idWlsZC9nZW4vZ28vYnVmYnVpbGQvcmVnaXN0cnkvcHJvdG9jb2xidWZmZXJzL2dvL2J1Zi9yZWdpc3RyeS9tb2R1bGUvdjFiZXRhMWIGcHJvdG8z", [file_buf_registry_module_v1beta1_digest, file_buf_registry_module_v1beta1_resource, file_buf_validate_validate]);

/**
 * @generated from message buf.registry.module.v1beta1.GetResourcesRequest
 */
export type GetResourcesRequest = Message<"buf.registry.module.v1beta1.GetResourcesRequest"> & {
  /**
   * References to request a Resource for.
   *
   * See the documentation on ResourceRef for resource resolution details.
   *
   * @generated from field: repeated buf.registry.module.v1beta1.ResourceRef resource_refs = 1;
   */
  resourceRefs: ResourceRef[];

  /**
   * The DigestType to use for Digests returned on Commits.
   *
   * If this DigestType is not available, an error is returned.
   * Note that certain DigestTypes may be deprecated over time.
   *
   * If not set, the latest DigestType is used, currently B5.
   *
   * @generated from field: buf.registry.module.v1beta1.DigestType digest_type = 2;
   */
  digestType: DigestType;
};

/**
 * Describes the message buf.registry.module.v1beta1.GetResourcesRequest.
 * Use `create(GetResourcesRequestSchema)` to create a new message.
 */
export const GetResourcesRequestSchema: GenMessage<GetResourcesRequest> = /*@__PURE__*/
  messageDesc(file_buf_registry_module_v1beta1_resource_service, 0);

/**
 * @generated from message buf.registry.module.v1beta1.GetResourcesResponse
 */
export type GetResourcesResponse = Message<"buf.registry.module.v1beta1.GetResourcesResponse"> & {
  /**
   * The found Resources in the same order as requested.
   *
   * @generated from field: repeated buf.registry.module.v1beta1.Resource resources = 1;
   */
  resources: Resource[];
};

/**
 * Describes the message buf.registry.module.v1beta1.GetResourcesResponse.
 * Use `create(GetResourcesResponseSchema)` to create a new message.
 */
export const GetResourcesResponseSchema: GenMessage<GetResourcesResponse> = /*@__PURE__*/
  messageDesc(file_buf_registry_module_v1beta1_resource_service, 1);

/**
 * Operate on Resources.
 *
 * @generated from service buf.registry.module.v1beta1.ResourceService
 */
export const ResourceService: GenService<{
  /**
   * Get Resources.
   *
   * @generated from rpc buf.registry.module.v1beta1.ResourceService.GetResources
   */
  getResources: {
    methodKind: "unary";
    input: typeof GetResourcesRequestSchema;
    output: typeof GetResourcesResponseSchema;
  },
}> = /*@__PURE__*/
  serviceDesc(file_buf_registry_module_v1beta1_resource_service, 0);

