// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// @generated by protoc-gen-es v2.2.2 with parameter "target=ts"
// @generated from file buf/registry/module/v1beta1/graph_service.proto (package buf.registry.module.v1beta1, syntax proto3)
/* eslint-disable */

import type { GenFile, GenMessage, GenService } from "@bufbuild/protobuf/codegenv1";
import { fileDesc, messageDesc, serviceDesc } from "@bufbuild/protobuf/codegenv1";
import type { DigestType } from "./digest_pb";
import { file_buf_registry_module_v1beta1_digest } from "./digest_pb";
import type { Graph } from "./graph_pb";
import { file_buf_registry_module_v1beta1_graph } from "./graph_pb";
import type { ResourceRef } from "./resource_pb";
import { file_buf_registry_module_v1beta1_resource } from "./resource_pb";
import { file_buf_validate_validate } from "../../../validate/validate_pb";
import type { Message } from "@bufbuild/protobuf";

/**
 * Describes the file buf/registry/module/v1beta1/graph_service.proto.
 */
export const file_buf_registry_module_v1beta1_graph_service: GenFile = /*@__PURE__*/
  fileDesc("Ci9idWYvcmVnaXN0cnkvbW9kdWxlL3YxYmV0YTEvZ3JhcGhfc2VydmljZS5wcm90bxIbYnVmLnJlZ2lzdHJ5Lm1vZHVsZS52MWJldGExIqgCCg9HZXRHcmFwaFJlcXVlc3QSXAoNcmVzb3VyY2VfcmVmcxgBIAMoCzI4LmJ1Zi5yZWdpc3RyeS5tb2R1bGUudjFiZXRhMS5HZXRHcmFwaFJlcXVlc3QuUmVzb3VyY2VSZWZCC7pICJIBBQgBEPoBEkYKC2RpZ2VzdF90eXBlGAIgASgOMicuYnVmLnJlZ2lzdHJ5Lm1vZHVsZS52MWJldGExLkRpZ2VzdFR5cGVCCLpIBYIBAhABGm8KC1Jlc291cmNlUmVmEkYKDHJlc291cmNlX3JlZhgBIAEoCzIoLmJ1Zi5yZWdpc3RyeS5tb2R1bGUudjFiZXRhMS5SZXNvdXJjZVJlZkIGukgDyAEBEhgKCHJlZ2lzdHJ5GAIgASgJQga6SAPIAQEiTQoQR2V0R3JhcGhSZXNwb25zZRI5CgVncmFwaBgBIAEoCzIiLmJ1Zi5yZWdpc3RyeS5tb2R1bGUudjFiZXRhMS5HcmFwaEIGukgDyAEBMnwKDEdyYXBoU2VydmljZRJsCghHZXRHcmFwaBIsLmJ1Zi5yZWdpc3RyeS5tb2R1bGUudjFiZXRhMS5HZXRHcmFwaFJlcXVlc3QaLS5idWYucmVnaXN0cnkubW9kdWxlLnYxYmV0YTEuR2V0R3JhcGhSZXNwb25zZSIDkAIBQlNaUWJ1Zi5idWlsZC9nZW4vZ28vYnVmYnVpbGQvcmVnaXN0cnkvcHJvdG9jb2xidWZmZXJzL2dvL2J1Zi9yZWdpc3RyeS9tb2R1bGUvdjFiZXRhMWIGcHJvdG8z", [file_buf_registry_module_v1beta1_digest, file_buf_registry_module_v1beta1_graph, file_buf_registry_module_v1beta1_resource, file_buf_validate_validate]);

/**
 * @generated from message buf.registry.module.v1beta1.GetGraphRequest
 */
export type GetGraphRequest = Message<"buf.registry.module.v1beta1.GetGraphRequest"> & {
  /**
   * The references to resolve to Commits to include in the graph.
   *
   * See the documentation on ResourceRef for resource resolution details.
   *
   * Once the resource is resolved, the following Commit is included:
   *   - If a Module is referenced, the Commit of the default Label is included.
   *   - If a Label is referenced, the Commit of this Label is included.
   *   - If a Commit is referenced, the Commit is included.
   *
   * The specified ResourceRefs must reference unique Modules, that is no two ResourceRefs
   * may resolve to the same Module.
   *
   * @generated from field: repeated buf.registry.module.v1beta1.GetGraphRequest.ResourceRef resource_refs = 1;
   */
  resourceRefs: GetGraphRequest_ResourceRef[];

  /**
   * The DigestType to return for Commit nodes.
   *
   * If this DigestType is not available, an error is returned.
   * Note that certain DigestTypes may be deprecated over time.
   *
   * If not set, the latest DigestType is used.
   *
   * @generated from field: buf.registry.module.v1beta1.DigestType digest_type = 2;
   */
  digestType: DigestType;
};

/**
 * Describes the message buf.registry.module.v1beta1.GetGraphRequest.
 * Use `create(GetGraphRequestSchema)` to create a new message.
 */
export const GetGraphRequestSchema: GenMessage<GetGraphRequest> = /*@__PURE__*/
  messageDesc(file_buf_registry_module_v1beta1_graph_service, 0);

/**
 * A ResourceRef to reference a Commit to include in the Graph.
 *
 * This wraps the top-level ResourceRef.
 *
 * @generated from message buf.registry.module.v1beta1.GetGraphRequest.ResourceRef
 */
export type GetGraphRequest_ResourceRef = Message<"buf.registry.module.v1beta1.GetGraphRequest.ResourceRef"> & {
  /**
   * The top-level ResourceRef.
   *
   * @generated from field: buf.registry.module.v1beta1.ResourceRef resource_ref = 1;
   */
  resourceRef?: ResourceRef;

  /**
   * The registry hostname of the Resourceref.
   *
   * @generated from field: string registry = 2;
   */
  registry: string;
};

/**
 * Describes the message buf.registry.module.v1beta1.GetGraphRequest.ResourceRef.
 * Use `create(GetGraphRequest_ResourceRefSchema)` to create a new message.
 */
export const GetGraphRequest_ResourceRefSchema: GenMessage<GetGraphRequest_ResourceRef> = /*@__PURE__*/
  messageDesc(file_buf_registry_module_v1beta1_graph_service, 0, 0);

/**
 * See the package documentation for more details. You should likely use buf.registry.module.v1beta1
 * and not this package.
 *
 * @generated from message buf.registry.module.v1beta1.GetGraphResponse
 */
export type GetGraphResponse = Message<"buf.registry.module.v1beta1.GetGraphResponse"> & {
  /**
   * The Graph calculated for the Commits.
   *
   * @generated from field: buf.registry.module.v1beta1.Graph graph = 1;
   */
  graph?: Graph;
};

/**
 * Describes the message buf.registry.module.v1beta1.GetGraphResponse.
 * Use `create(GetGraphResponseSchema)` to create a new message.
 */
export const GetGraphResponseSchema: GenMessage<GetGraphResponse> = /*@__PURE__*/
  messageDesc(file_buf_registry_module_v1beta1_graph_service, 1);

/**
 * Get dependency graphs.
 *
 * @generated from service buf.registry.module.v1beta1.GraphService
 */
export const GraphService: GenService<{
  /**
   * Get a dependency graph that includes the given Commits.
   *
   * Commits will be resolved via the given ResourceRefs, and all Commits will be included in the
   * graph, along with their dependencies.
   *
   * A dependency graph is a directed acyclic graph.
   *
   * @generated from rpc buf.registry.module.v1beta1.GraphService.GetGraph
   */
  getGraph: {
    methodKind: "unary";
    input: typeof GetGraphRequestSchema;
    output: typeof GetGraphResponseSchema;
  },
}> = /*@__PURE__*/
  serviceDesc(file_buf_registry_module_v1beta1_graph_service, 0);

