// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// @generated by protoc-gen-es v2.2.2 with parameter "target=ts"
// @generated from file buf/registry/module/v1beta1/graph.proto (package buf.registry.module.v1beta1, syntax proto3)
/* eslint-disable */

import type { GenFile, GenMessage } from "@bufbuild/protobuf/codegenv1";
import { fileDesc, messageDesc } from "@bufbuild/protobuf/codegenv1";
import type { Commit } from "./commit_pb";
import { file_buf_registry_module_v1beta1_commit } from "./commit_pb";
import { file_buf_registry_priv_extension_v1beta1_extension } from "../../priv/extension/v1beta1/extension_pb";
import { file_buf_validate_validate } from "../../../validate/validate_pb";
import type { Message } from "@bufbuild/protobuf";

/**
 * Describes the file buf/registry/module/v1beta1/graph.proto.
 */
export const file_buf_registry_module_v1beta1_graph: GenFile = /*@__PURE__*/
  fileDesc("CididWYvcmVnaXN0cnkvbW9kdWxlL3YxYmV0YTEvZ3JhcGgucHJvdG8SG2J1Zi5yZWdpc3RyeS5tb2R1bGUudjFiZXRhMSK/AwoFR3JhcGgSRAoHY29tbWl0cxgBIAMoCzIpLmJ1Zi5yZWdpc3RyeS5tb2R1bGUudjFiZXRhMS5HcmFwaC5Db21taXRCCLpIBZIBAggBEjYKBWVkZ2VzGAIgAygLMicuYnVmLnJlZ2lzdHJ5Lm1vZHVsZS52MWJldGExLkdyYXBoLkVkZ2UaXwoGQ29tbWl0EjsKBmNvbW1pdBgBIAEoCzIjLmJ1Zi5yZWdpc3RyeS5tb2R1bGUudjFiZXRhMS5Db21taXRCBrpIA8gBARIYCghyZWdpc3RyeRgCIAEoCUIGukgDyAEBGkAKBE5vZGUSHgoJY29tbWl0X2lkGAEgASgJQgu6SAjIAQFyA4gCARIYCghyZWdpc3RyeRgCIAEoCUIGukgDyAEBGowBCgRFZGdlEkIKCWZyb21fbm9kZRgBIAEoCzInLmJ1Zi5yZWdpc3RyeS5tb2R1bGUudjFiZXRhMS5HcmFwaC5Ob2RlQga6SAPIAQESQAoHdG9fbm9kZRgCIAEoCzInLmJ1Zi5yZWdpc3RyeS5tb2R1bGUudjFiZXRhMS5HcmFwaC5Ob2RlQga6SAPIAQE6BurFKwIQAUJTWlFidWYuYnVpbGQvZ2VuL2dvL2J1ZmJ1aWxkL3JlZ2lzdHJ5L3Byb3RvY29sYnVmZmVycy9nby9idWYvcmVnaXN0cnkvbW9kdWxlL3YxYmV0YTFiBnByb3RvMw", [file_buf_registry_module_v1beta1_commit, file_buf_registry_priv_extension_v1beta1_extension, file_buf_validate_validate]);

/**
 * A dependency graph.
 *
 * @generated from message buf.registry.module.v1beta1.Graph
 */
export type Graph = Message<"buf.registry.module.v1beta1.Graph"> & {
  /**
   * The nodes of the graph, each of which are Commits.
   *
   * @generated from field: repeated buf.registry.module.v1beta1.Graph.Commit commits = 1;
   */
  commits: Graph_Commit[];

  /**
   * The edges of the graph.
   *
   * @generated from field: repeated buf.registry.module.v1beta1.Graph.Edge edges = 2;
   */
  edges: Graph_Edge[];
};

/**
 * Describes the message buf.registry.module.v1beta1.Graph.
 * Use `create(GraphSchema)` to create a new message.
 */
export const GraphSchema: GenMessage<Graph> = /*@__PURE__*/
  messageDesc(file_buf_registry_module_v1beta1_graph, 0);

/**
 * A Commit in the dependency graph.
 *
 * This wraps the top-level Commit.
 *
 * @generated from message buf.registry.module.v1beta1.Graph.Commit
 */
export type Graph_Commit = Message<"buf.registry.module.v1beta1.Graph.Commit"> & {
  /**
   * The top-level Commit.
   *
   * @generated from field: buf.registry.module.v1beta1.Commit commit = 1;
   */
  commit?: Commit;

  /**
   * The registry hostname of the Commit.
   *
   * @generated from field: string registry = 2;
   */
  registry: string;
};

/**
 * Describes the message buf.registry.module.v1beta1.Graph.Commit.
 * Use `create(Graph_CommitSchema)` to create a new message.
 */
export const Graph_CommitSchema: GenMessage<Graph_Commit> = /*@__PURE__*/
  messageDesc(file_buf_registry_module_v1beta1_graph, 0, 0);

/**
 * A node in the dependency graph.
 *
 * @generated from message buf.registry.module.v1beta1.Graph.Node
 */
export type Graph_Node = Message<"buf.registry.module.v1beta1.Graph.Node"> & {
  /**
   * The commit of the node.
   *
   * @generated from field: string commit_id = 1;
   */
  commitId: string;

  /**
   * The registry hostname of the Node.
   *
   * @generated from field: string registry = 2;
   */
  registry: string;
};

/**
 * Describes the message buf.registry.module.v1beta1.Graph.Node.
 * Use `create(Graph_NodeSchema)` to create a new message.
 */
export const Graph_NodeSchema: GenMessage<Graph_Node> = /*@__PURE__*/
  messageDesc(file_buf_registry_module_v1beta1_graph, 0, 1);

/**
 * An edge in the dependency graph.
 *
 * @generated from message buf.registry.module.v1beta1.Graph.Edge
 */
export type Graph_Edge = Message<"buf.registry.module.v1beta1.Graph.Edge"> & {
  /**
   * The Node of the start of the edge.
   *
   * @generated from field: buf.registry.module.v1beta1.Graph.Node from_node = 1;
   */
  fromNode?: Graph_Node;

  /**
   * The Node of the end of the edge.
   *
   * @generated from field: buf.registry.module.v1beta1.Graph.Node to_node = 2;
   */
  toNode?: Graph_Node;
};

/**
 * Describes the message buf.registry.module.v1beta1.Graph.Edge.
 * Use `create(Graph_EdgeSchema)` to create a new message.
 */
export const Graph_EdgeSchema: GenMessage<Graph_Edge> = /*@__PURE__*/
  messageDesc(file_buf_registry_module_v1beta1_graph, 0, 2);

