// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// @generated by protoc-gen-es v2.2.2 with parameter "target=ts"
// @generated from file buf/registry/module/v1/graph_service.proto (package buf.registry.module.v1, syntax proto3)
/* eslint-disable */

import type { GenFile, GenMessage, GenService } from "@bufbuild/protobuf/codegenv1";
import { fileDesc, messageDesc, serviceDesc } from "@bufbuild/protobuf/codegenv1";
import type { Graph } from "./graph_pb";
import { file_buf_registry_module_v1_graph } from "./graph_pb";
import type { ResourceRef } from "./resource_pb";
import { file_buf_registry_module_v1_resource } from "./resource_pb";
import { file_buf_validate_validate } from "../../../validate/validate_pb";
import type { Message } from "@bufbuild/protobuf";

/**
 * Describes the file buf/registry/module/v1/graph_service.proto.
 */
export const file_buf_registry_module_v1_graph_service: GenFile = /*@__PURE__*/
  fileDesc("CipidWYvcmVnaXN0cnkvbW9kdWxlL3YxL2dyYXBoX3NlcnZpY2UucHJvdG8SFmJ1Zi5yZWdpc3RyeS5tb2R1bGUudjEiWgoPR2V0R3JhcGhSZXF1ZXN0EkcKDXJlc291cmNlX3JlZnMYASADKAsyIy5idWYucmVnaXN0cnkubW9kdWxlLnYxLlJlc291cmNlUmVmQgu6SAiSAQUIARD6ASJIChBHZXRHcmFwaFJlc3BvbnNlEjQKBWdyYXBoGAEgASgLMh0uYnVmLnJlZ2lzdHJ5Lm1vZHVsZS52MS5HcmFwaEIGukgDyAEBMnIKDEdyYXBoU2VydmljZRJiCghHZXRHcmFwaBInLmJ1Zi5yZWdpc3RyeS5tb2R1bGUudjEuR2V0R3JhcGhSZXF1ZXN0GiguYnVmLnJlZ2lzdHJ5Lm1vZHVsZS52MS5HZXRHcmFwaFJlc3BvbnNlIgOQAgFCTlpMYnVmLmJ1aWxkL2dlbi9nby9idWZidWlsZC9yZWdpc3RyeS9wcm90b2NvbGJ1ZmZlcnMvZ28vYnVmL3JlZ2lzdHJ5L21vZHVsZS92MWIGcHJvdG8z", [file_buf_registry_module_v1_graph, file_buf_registry_module_v1_resource, file_buf_validate_validate]);

/**
 * @generated from message buf.registry.module.v1.GetGraphRequest
 */
export type GetGraphRequest = Message<"buf.registry.module.v1.GetGraphRequest"> & {
  /**
   * The references to resolve to Commits to include in the graph.
   *
   * See the documentation on ResourceRef for resource resolution details.
   *
   * Once the resource is resolved, the following Commit is included:
   *   - If a Module is referenced, the Commit of the default Label is included.
   *   - If a Label is referenced, the Commit of this Label is included.
   *   - If a Commit is referenced, the Commit is included.
   *
   * The specified ResourceRefs must reference unique Modules, that is no two ResourceRefs
   * may resolve to the same Module.
   *
   * @generated from field: repeated buf.registry.module.v1.ResourceRef resource_refs = 1;
   */
  resourceRefs: ResourceRef[];
};

/**
 * Describes the message buf.registry.module.v1.GetGraphRequest.
 * Use `create(GetGraphRequestSchema)` to create a new message.
 */
export const GetGraphRequestSchema: GenMessage<GetGraphRequest> = /*@__PURE__*/
  messageDesc(file_buf_registry_module_v1_graph_service, 0);

/**
 * @generated from message buf.registry.module.v1.GetGraphResponse
 */
export type GetGraphResponse = Message<"buf.registry.module.v1.GetGraphResponse"> & {
  /**
   * The Graph calculated for the Commits.
   *
   * @generated from field: buf.registry.module.v1.Graph graph = 1;
   */
  graph?: Graph;
};

/**
 * Describes the message buf.registry.module.v1.GetGraphResponse.
 * Use `create(GetGraphResponseSchema)` to create a new message.
 */
export const GetGraphResponseSchema: GenMessage<GetGraphResponse> = /*@__PURE__*/
  messageDesc(file_buf_registry_module_v1_graph_service, 1);

/**
 * Get dependency graphs.
 *
 * @generated from service buf.registry.module.v1.GraphService
 */
export const GraphService: GenService<{
  /**
   * Get a dependency graph that includes the given Commits.
   *
   * Commits will be resolved via the given ResourceRefs, and all Commits will be included in the
   * graph, along with their dependencies.
   *
   * A dependency graph is a directed acyclic graph.
   *
   * @generated from rpc buf.registry.module.v1.GraphService.GetGraph
   */
  getGraph: {
    methodKind: "unary";
    input: typeof GetGraphRequestSchema;
    output: typeof GetGraphResponseSchema;
  },
}> = /*@__PURE__*/
  serviceDesc(file_buf_registry_module_v1_graph_service, 0);

