// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// @generated by protoc-gen-es v2.0.0 with parameter "target=ts,import_extension=.js"
// @generated from file connectrpc/conformance/v1/service.proto (package connectrpc.conformance.v1, syntax proto3)
/* eslint-disable */

import type {
  GenFile,
  GenMessage,
  GenService,
} from "@bufbuild/protobuf/codegenv1";
import {
  fileDesc,
  messageDesc,
  serviceDesc,
} from "@bufbuild/protobuf/codegenv1";
import type { Code, Compression } from "./config_pb.js";
import { file_connectrpc_conformance_v1_config } from "./config_pb.js";
import type { Any } from "@bufbuild/protobuf/wkt";
import { file_google_protobuf_any } from "@bufbuild/protobuf/wkt";
import type { Message } from "@bufbuild/protobuf";

/**
 * Describes the file connectrpc/conformance/v1/service.proto.
 */
export const file_connectrpc_conformance_v1_service: GenFile =
  /*@__PURE__*/
  fileDesc(
    "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",
    [file_connectrpc_conformance_v1_config, file_google_protobuf_any],
  );

/**
 * A definition of a response to be sent from a single-response endpoint.
 * Can be used to define a response for unary or client-streaming calls.
 *
 * @generated from message connectrpc.conformance.v1.UnaryResponseDefinition
 */
export type UnaryResponseDefinition =
  Message<"connectrpc.conformance.v1.UnaryResponseDefinition"> & {
    /**
     * Response headers to send
     *
     * @generated from field: repeated connectrpc.conformance.v1.Header response_headers = 1;
     */
    responseHeaders: Header[];

    /**
     * @generated from oneof connectrpc.conformance.v1.UnaryResponseDefinition.response
     */
    response:
      | {
          /**
           * Response data to send
           *
           * @generated from field: bytes response_data = 2;
           */
          value: Uint8Array;
          case: "responseData";
        }
      | {
          /**
           * Error to raise instead of response message
           * Servers should build a RequestInfo and append it to the details of the
           * requested error.
           *
           * @generated from field: connectrpc.conformance.v1.Error error = 3;
           */
          value: Error;
          case: "error";
        }
      | { case: undefined; value?: undefined };

    /**
     * Response trailers to send - together with the error if present
     *
     * @generated from field: repeated connectrpc.conformance.v1.Header response_trailers = 4;
     */
    responseTrailers: Header[];

    /**
     * Wait this many milliseconds before sending a response message
     *
     * @generated from field: uint32 response_delay_ms = 6;
     */
    responseDelayMs: number;

    /**
     * This field is only used by the reference server. If you are implementing a
     * server under test, you can ignore this field or respond with an error if the
     * server receives a request where it is set.
     *
     * For test definitions, this field should be used instead of the above fields.
     *
     * @generated from field: connectrpc.conformance.v1.RawHTTPResponse raw_response = 5;
     */
    rawResponse?: RawHTTPResponse;
  };

/**
 * Describes the message connectrpc.conformance.v1.UnaryResponseDefinition.
 * Use `create(UnaryResponseDefinitionSchema)` to create a new message.
 */
export const UnaryResponseDefinitionSchema: GenMessage<UnaryResponseDefinition> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 0);

/**
 * A definition of responses to be sent from a streaming endpoint.
 * Can be used to define responses for server-streaming or bidi-streaming calls.
 *
 * @generated from message connectrpc.conformance.v1.StreamResponseDefinition
 */
export type StreamResponseDefinition =
  Message<"connectrpc.conformance.v1.StreamResponseDefinition"> & {
    /**
     * Response headers to send
     *
     * @generated from field: repeated connectrpc.conformance.v1.Header response_headers = 1;
     */
    responseHeaders: Header[];

    /**
     * Response data to send
     *
     * @generated from field: repeated bytes response_data = 2;
     */
    responseData: Uint8Array[];

    /**
     * Wait this many milliseconds before sending each response message
     *
     * @generated from field: uint32 response_delay_ms = 3;
     */
    responseDelayMs: number;

    /**
     * Optional error to raise, but only after sending any response messages.
     * In the event an immediate error is thrown before any responses are sent,
     * (i.e. the equivalent of a trailers-only response), then servers should
     * build a RequestInfo message with available information and append that to
     * the error details.
     *
     * @generated from field: connectrpc.conformance.v1.Error error = 4;
     */
    error?: Error;

    /**
     * Response trailers to send - together with the error if present
     *
     * @generated from field: repeated connectrpc.conformance.v1.Header response_trailers = 5;
     */
    responseTrailers: Header[];

    /**
     * This field is only used by the reference server. If you are implementing a
     * server under test, you can ignore this field or respond with an error if the
     * server receives a request where it is set.
     *
     * For test definitions, this field should be used instead of the above fields.
     *
     * @generated from field: connectrpc.conformance.v1.RawHTTPResponse raw_response = 6;
     */
    rawResponse?: RawHTTPResponse;
  };

/**
 * Describes the message connectrpc.conformance.v1.StreamResponseDefinition.
 * Use `create(StreamResponseDefinitionSchema)` to create a new message.
 */
export const StreamResponseDefinitionSchema: GenMessage<StreamResponseDefinition> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 1);

/**
 * @generated from message connectrpc.conformance.v1.UnaryRequest
 */
export type UnaryRequest = Message<"connectrpc.conformance.v1.UnaryRequest"> & {
  /**
   * The response definition which should be returned in the conformance payload
   *
   * @generated from field: connectrpc.conformance.v1.UnaryResponseDefinition response_definition = 1;
   */
  responseDefinition?: UnaryResponseDefinition;

  /**
   * Additional data. Only used to pad the request size to test large request messages.
   *
   * @generated from field: bytes request_data = 2;
   */
  requestData: Uint8Array;
};

/**
 * Describes the message connectrpc.conformance.v1.UnaryRequest.
 * Use `create(UnaryRequestSchema)` to create a new message.
 */
export const UnaryRequestSchema: GenMessage<UnaryRequest> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 2);

/**
 * @generated from message connectrpc.conformance.v1.UnaryResponse
 */
export type UnaryResponse =
  Message<"connectrpc.conformance.v1.UnaryResponse"> & {
    /**
     * The conformance payload to respond with.
     *
     * @generated from field: connectrpc.conformance.v1.ConformancePayload payload = 1;
     */
    payload?: ConformancePayload;
  };

/**
 * Describes the message connectrpc.conformance.v1.UnaryResponse.
 * Use `create(UnaryResponseSchema)` to create a new message.
 */
export const UnaryResponseSchema: GenMessage<UnaryResponse> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 3);

/**
 * @generated from message connectrpc.conformance.v1.IdempotentUnaryRequest
 */
export type IdempotentUnaryRequest =
  Message<"connectrpc.conformance.v1.IdempotentUnaryRequest"> & {
    /**
     * The response definition which should be returned in the conformance payload
     *
     * @generated from field: connectrpc.conformance.v1.UnaryResponseDefinition response_definition = 1;
     */
    responseDefinition?: UnaryResponseDefinition;

    /**
     * Additional data. Only used to pad the request size to test large request messages.
     *
     * @generated from field: bytes request_data = 2;
     */
    requestData: Uint8Array;
  };

/**
 * Describes the message connectrpc.conformance.v1.IdempotentUnaryRequest.
 * Use `create(IdempotentUnaryRequestSchema)` to create a new message.
 */
export const IdempotentUnaryRequestSchema: GenMessage<IdempotentUnaryRequest> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 4);

/**
 * @generated from message connectrpc.conformance.v1.IdempotentUnaryResponse
 */
export type IdempotentUnaryResponse =
  Message<"connectrpc.conformance.v1.IdempotentUnaryResponse"> & {
    /**
     * The conformance payload to respond with.
     *
     * @generated from field: connectrpc.conformance.v1.ConformancePayload payload = 1;
     */
    payload?: ConformancePayload;
  };

/**
 * Describes the message connectrpc.conformance.v1.IdempotentUnaryResponse.
 * Use `create(IdempotentUnaryResponseSchema)` to create a new message.
 */
export const IdempotentUnaryResponseSchema: GenMessage<IdempotentUnaryResponse> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 5);

/**
 * @generated from message connectrpc.conformance.v1.ServerStreamRequest
 */
export type ServerStreamRequest =
  Message<"connectrpc.conformance.v1.ServerStreamRequest"> & {
    /**
     * The response definition which should be returned in the conformance payload.
     *
     * @generated from field: connectrpc.conformance.v1.StreamResponseDefinition response_definition = 1;
     */
    responseDefinition?: StreamResponseDefinition;

    /**
     * Additional data. Only used to pad the request size to test large request messages.
     *
     * @generated from field: bytes request_data = 2;
     */
    requestData: Uint8Array;
  };

/**
 * Describes the message connectrpc.conformance.v1.ServerStreamRequest.
 * Use `create(ServerStreamRequestSchema)` to create a new message.
 */
export const ServerStreamRequestSchema: GenMessage<ServerStreamRequest> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 6);

/**
 * @generated from message connectrpc.conformance.v1.ServerStreamResponse
 */
export type ServerStreamResponse =
  Message<"connectrpc.conformance.v1.ServerStreamResponse"> & {
    /**
     * The conformance payload to respond with
     *
     * @generated from field: connectrpc.conformance.v1.ConformancePayload payload = 1;
     */
    payload?: ConformancePayload;
  };

/**
 * Describes the message connectrpc.conformance.v1.ServerStreamResponse.
 * Use `create(ServerStreamResponseSchema)` to create a new message.
 */
export const ServerStreamResponseSchema: GenMessage<ServerStreamResponse> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 7);

/**
 * @generated from message connectrpc.conformance.v1.ClientStreamRequest
 */
export type ClientStreamRequest =
  Message<"connectrpc.conformance.v1.ClientStreamRequest"> & {
    /**
     * Tells the server how to reply once all client messages are
     * complete. Required in the first message in the stream, but
     * should be ignored in subsequent messages.
     *
     * @generated from field: connectrpc.conformance.v1.UnaryResponseDefinition response_definition = 1;
     */
    responseDefinition?: UnaryResponseDefinition;

    /**
     * Additional data for subsequent messages in the stream. Also
     * used to pad the request size to test large request messages.
     *
     * @generated from field: bytes request_data = 2;
     */
    requestData: Uint8Array;
  };

/**
 * Describes the message connectrpc.conformance.v1.ClientStreamRequest.
 * Use `create(ClientStreamRequestSchema)` to create a new message.
 */
export const ClientStreamRequestSchema: GenMessage<ClientStreamRequest> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 8);

/**
 * @generated from message connectrpc.conformance.v1.ClientStreamResponse
 */
export type ClientStreamResponse =
  Message<"connectrpc.conformance.v1.ClientStreamResponse"> & {
    /**
     * The conformance payload to respond with
     *
     * @generated from field: connectrpc.conformance.v1.ConformancePayload payload = 1;
     */
    payload?: ConformancePayload;
  };

/**
 * Describes the message connectrpc.conformance.v1.ClientStreamResponse.
 * Use `create(ClientStreamResponseSchema)` to create a new message.
 */
export const ClientStreamResponseSchema: GenMessage<ClientStreamResponse> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 9);

/**
 * @generated from message connectrpc.conformance.v1.BidiStreamRequest
 */
export type BidiStreamRequest =
  Message<"connectrpc.conformance.v1.BidiStreamRequest"> & {
    /**
     * Tells the server how to reply; required in the first message
     * in the stream. Should be ignored in subsequent messages.
     *
     * @generated from field: connectrpc.conformance.v1.StreamResponseDefinition response_definition = 1;
     */
    responseDefinition?: StreamResponseDefinition;

    /**
     * Tells the server whether it should wait for each request
     * before sending a response.
     *
     * If true, it indicates the server should effectively interleave the
     * stream so messages are sent in request->response pairs.
     *
     * If false, then the response stream will be sent once all request messages
     * are finished sending with the only delays between messages
     * being the optional fixed milliseconds defined in the response
     * definition.
     *
     * This field is only relevant in the first message in the stream
     * and should be ignored in subsequent messages.
     *
     * @generated from field: bool full_duplex = 2;
     */
    fullDuplex: boolean;

    /**
     * Additional data for subsequent messages in the stream. Also
     * used to pad the request size to test large request messages.
     *
     * @generated from field: bytes request_data = 3;
     */
    requestData: Uint8Array;
  };

/**
 * Describes the message connectrpc.conformance.v1.BidiStreamRequest.
 * Use `create(BidiStreamRequestSchema)` to create a new message.
 */
export const BidiStreamRequestSchema: GenMessage<BidiStreamRequest> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 10);

/**
 * @generated from message connectrpc.conformance.v1.BidiStreamResponse
 */
export type BidiStreamResponse =
  Message<"connectrpc.conformance.v1.BidiStreamResponse"> & {
    /**
     * The conformance payload to respond with
     *
     * @generated from field: connectrpc.conformance.v1.ConformancePayload payload = 1;
     */
    payload?: ConformancePayload;
  };

/**
 * Describes the message connectrpc.conformance.v1.BidiStreamResponse.
 * Use `create(BidiStreamResponseSchema)` to create a new message.
 */
export const BidiStreamResponseSchema: GenMessage<BidiStreamResponse> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 11);

/**
 * @generated from message connectrpc.conformance.v1.UnimplementedRequest
 */
export type UnimplementedRequest =
  Message<"connectrpc.conformance.v1.UnimplementedRequest"> & {};

/**
 * Describes the message connectrpc.conformance.v1.UnimplementedRequest.
 * Use `create(UnimplementedRequestSchema)` to create a new message.
 */
export const UnimplementedRequestSchema: GenMessage<UnimplementedRequest> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 12);

/**
 * @generated from message connectrpc.conformance.v1.UnimplementedResponse
 */
export type UnimplementedResponse =
  Message<"connectrpc.conformance.v1.UnimplementedResponse"> & {};

/**
 * Describes the message connectrpc.conformance.v1.UnimplementedResponse.
 * Use `create(UnimplementedResponseSchema)` to create a new message.
 */
export const UnimplementedResponseSchema: GenMessage<UnimplementedResponse> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 13);

/**
 * @generated from message connectrpc.conformance.v1.ConformancePayload
 */
export type ConformancePayload =
  Message<"connectrpc.conformance.v1.ConformancePayload"> & {
    /**
     * Any response data specified in the response definition to the server should be
     * echoed back here.
     *
     * @generated from field: bytes data = 1;
     */
    data: Uint8Array;

    /**
     * Echoes back information about the request stream observed so far.
     *
     * @generated from field: connectrpc.conformance.v1.ConformancePayload.RequestInfo request_info = 2;
     */
    requestInfo?: ConformancePayload_RequestInfo;
  };

/**
 * Describes the message connectrpc.conformance.v1.ConformancePayload.
 * Use `create(ConformancePayloadSchema)` to create a new message.
 */
export const ConformancePayloadSchema: GenMessage<ConformancePayload> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 14);

/**
 * @generated from message connectrpc.conformance.v1.ConformancePayload.RequestInfo
 */
export type ConformancePayload_RequestInfo =
  Message<"connectrpc.conformance.v1.ConformancePayload.RequestInfo"> & {
    /**
     * The server echos back the request headers it observed here.
     *
     * @generated from field: repeated connectrpc.conformance.v1.Header request_headers = 1;
     */
    requestHeaders: Header[];

    /**
     * The timeout observed that was included in the request. Other timeouts use a
     * type of uint32, but we want to be lenient here to allow whatever value the RPC
     * server observes, even if it's outside the range of uint32.
     *
     * @generated from field: optional int64 timeout_ms = 2;
     */
    timeoutMs?: bigint;

    /**
     * The server should echo back all requests received.
     * For unary and server-streaming requests, this should always contain a single request
     * For client-streaming and half-duplex bidi-streaming, this should contain
     * all client requests in the order received and be present in each response.
     * For full-duplex bidirectional-streaming, this should contain all requests in the order
     * they were received since the last sent response.
     *
     * @generated from field: repeated google.protobuf.Any requests = 3;
     */
    requests: Any[];

    /**
     * If present, the request used the Connect protocol and a GET method. This
     * captures other relevant information about the request. If a server implementation
     * is unable to populate this (due to the server framework not exposing all of these
     * details to application code), it may be an empty message. This implies that the
     * server framework, at a minimum, at least expose to application code whether the
     * request used GET vs. POST.
     *
     * @generated from field: connectrpc.conformance.v1.ConformancePayload.ConnectGetInfo connect_get_info = 4;
     */
    connectGetInfo?: ConformancePayload_ConnectGetInfo;
  };

/**
 * Describes the message connectrpc.conformance.v1.ConformancePayload.RequestInfo.
 * Use `create(ConformancePayload_RequestInfoSchema)` to create a new message.
 */
export const ConformancePayload_RequestInfoSchema: GenMessage<ConformancePayload_RequestInfo> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 14, 0);

/**
 * @generated from message connectrpc.conformance.v1.ConformancePayload.ConnectGetInfo
 */
export type ConformancePayload_ConnectGetInfo =
  Message<"connectrpc.conformance.v1.ConformancePayload.ConnectGetInfo"> & {
    /**
     * The query params observed in the request URL.
     *
     * @generated from field: repeated connectrpc.conformance.v1.Header query_params = 1;
     */
    queryParams: Header[];
  };

/**
 * Describes the message connectrpc.conformance.v1.ConformancePayload.ConnectGetInfo.
 * Use `create(ConformancePayload_ConnectGetInfoSchema)` to create a new message.
 */
export const ConformancePayload_ConnectGetInfoSchema: GenMessage<ConformancePayload_ConnectGetInfo> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 14, 1);

/**
 * An error definition used for specifying a desired error response
 *
 * @generated from message connectrpc.conformance.v1.Error
 */
export type Error = Message<"connectrpc.conformance.v1.Error"> & {
  /**
   * The error code.
   * For a list of Connect error codes see: https://connectrpc.com/docs/protocol#error-codes
   *
   * @generated from field: connectrpc.conformance.v1.Code code = 1;
   */
  code: Code;

  /**
   * If this value is absent in a test case response definition, the contents of the
   * actual error message will not be checked. This is useful for certain kinds of
   * error conditions where the exact message to be used is not specified, only the
   * code.
   *
   * @generated from field: optional string message = 2;
   */
  message?: string;

  /**
   * Errors in Connect and gRPC protocols can have arbitrary messages
   * attached to them, which are known as error details.
   *
   * @generated from field: repeated google.protobuf.Any details = 3;
   */
  details: Any[];
};

/**
 * Describes the message connectrpc.conformance.v1.Error.
 * Use `create(ErrorSchema)` to create a new message.
 */
export const ErrorSchema: GenMessage<Error> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 15);

/**
 * A tuple of name and values (ASCII) for a header or trailer entry.
 *
 * @generated from message connectrpc.conformance.v1.Header
 */
export type Header = Message<"connectrpc.conformance.v1.Header"> & {
  /**
   * Header/trailer name (key).
   *
   * @generated from field: string name = 1;
   */
  name: string;

  /**
   * Header/trailer value. This is repeated to explicitly support headers and
   * trailers where a key is repeated. In such a case, these values must be in
   * the same order as which values appeared in the header or trailer block.
   *
   * @generated from field: repeated string value = 2;
   */
  value: string[];
};

/**
 * Describes the message connectrpc.conformance.v1.Header.
 * Use `create(HeaderSchema)` to create a new message.
 */
export const HeaderSchema: GenMessage<Header> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 16);

/**
 * RawHTTPRequest models a raw HTTP request. This can be used to craft
 * custom requests with odd properties (including certain kinds of
 * malformed requests) to test edge cases in servers.
 *
 * @generated from message connectrpc.conformance.v1.RawHTTPRequest
 */
export type RawHTTPRequest =
  Message<"connectrpc.conformance.v1.RawHTTPRequest"> & {
    /**
     * The HTTP verb (i.e. GET , POST).
     *
     * @generated from field: string verb = 1;
     */
    verb: string;

    /**
     * The URI to send the request to.
     *
     * @generated from field: string uri = 2;
     */
    uri: string;

    /**
     * Any headers to set on the request.
     *
     * @generated from field: repeated connectrpc.conformance.v1.Header headers = 3;
     */
    headers: Header[];

    /**
     * These query params will be encoded and added to the uri before
     * the request is sent.
     *
     * @generated from field: repeated connectrpc.conformance.v1.Header raw_query_params = 4;
     */
    rawQueryParams: Header[];

    /**
     * This provides an easier way to define a complex binary query param
     * than having to write literal base64-encoded bytes in raw_query_params.
     *
     * @generated from field: repeated connectrpc.conformance.v1.RawHTTPRequest.EncodedQueryParam encoded_query_params = 5;
     */
    encodedQueryParams: RawHTTPRequest_EncodedQueryParam[];

    /**
     * @generated from oneof connectrpc.conformance.v1.RawHTTPRequest.body
     */
    body:
      | {
          /**
           * The body is a single message.
           *
           * @generated from field: connectrpc.conformance.v1.MessageContents unary = 6;
           */
          value: MessageContents;
          case: "unary";
        }
      | {
          /**
           * The body is a stream, encoded using a five-byte
           * prefix before each item in the stream.
           *
           * @generated from field: connectrpc.conformance.v1.StreamContents stream = 7;
           */
          value: StreamContents;
          case: "stream";
        }
      | { case: undefined; value?: undefined };
  };

/**
 * Describes the message connectrpc.conformance.v1.RawHTTPRequest.
 * Use `create(RawHTTPRequestSchema)` to create a new message.
 */
export const RawHTTPRequestSchema: GenMessage<RawHTTPRequest> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 17);

/**
 * @generated from message connectrpc.conformance.v1.RawHTTPRequest.EncodedQueryParam
 */
export type RawHTTPRequest_EncodedQueryParam =
  Message<"connectrpc.conformance.v1.RawHTTPRequest.EncodedQueryParam"> & {
    /**
     * Query param name.
     *
     * @generated from field: string name = 1;
     */
    name: string;

    /**
     * Query param value.
     *
     * @generated from field: connectrpc.conformance.v1.MessageContents value = 2;
     */
    value?: MessageContents;

    /**
     * If true, the message contents will be base64-encoded and the
     * resulting string used as the query parameter value.
     *
     * @generated from field: bool base64_encode = 3;
     */
    base64Encode: boolean;
  };

/**
 * Describes the message connectrpc.conformance.v1.RawHTTPRequest.EncodedQueryParam.
 * Use `create(RawHTTPRequest_EncodedQueryParamSchema)` to create a new message.
 */
export const RawHTTPRequest_EncodedQueryParamSchema: GenMessage<RawHTTPRequest_EncodedQueryParam> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 17, 0);

/**
 * MessageContents represents a message in a request body.
 *
 * @generated from message connectrpc.conformance.v1.MessageContents
 */
export type MessageContents =
  Message<"connectrpc.conformance.v1.MessageContents"> & {
    /**
     * The message data can be defined in one of three ways.
     *
     * @generated from oneof connectrpc.conformance.v1.MessageContents.data
     */
    data:
      | {
          /**
           * Arbitrary bytes.
           *
           * @generated from field: bytes binary = 1;
           */
          value: Uint8Array;
          case: "binary";
        }
      | {
          /**
           * Arbitrary text.
           *
           * @generated from field: string text = 2;
           */
          value: string;
          case: "text";
        }
      | {
          /**
           * An actual message. The message inside the Any will be
           * serialized to the protobuf binary formats, and the
           * resulting bytes will be the contents.
           *
           * @generated from field: google.protobuf.Any binary_message = 3;
           */
          value: Any;
          case: "binaryMessage";
        }
      | { case: undefined; value?: undefined };

    /**
     * If specified and not identity, the above data will be
     * compressed using the given algorithm.
     *
     * @generated from field: connectrpc.conformance.v1.Compression compression = 4;
     */
    compression: Compression;
  };

/**
 * Describes the message connectrpc.conformance.v1.MessageContents.
 * Use `create(MessageContentsSchema)` to create a new message.
 */
export const MessageContentsSchema: GenMessage<MessageContents> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 18);

/**
 * StreamContents represents a sequence of messages in a request body.
 *
 * @generated from message connectrpc.conformance.v1.StreamContents
 */
export type StreamContents =
  Message<"connectrpc.conformance.v1.StreamContents"> & {
    /**
     * The messages in the stream.
     *
     * @generated from field: repeated connectrpc.conformance.v1.StreamContents.StreamItem items = 1;
     */
    items: StreamContents_StreamItem[];
  };

/**
 * Describes the message connectrpc.conformance.v1.StreamContents.
 * Use `create(StreamContentsSchema)` to create a new message.
 */
export const StreamContentsSchema: GenMessage<StreamContents> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 19);

/**
 * @generated from message connectrpc.conformance.v1.StreamContents.StreamItem
 */
export type StreamContents_StreamItem =
  Message<"connectrpc.conformance.v1.StreamContents.StreamItem"> & {
    /**
     * must be in the range 0 to 255.
     *
     * @generated from field: uint32 flags = 1;
     */
    flags: number;

    /**
     * if absent use actual length of payload
     *
     * @generated from field: optional uint32 length = 2;
     */
    length?: number;

    /**
     * @generated from field: connectrpc.conformance.v1.MessageContents payload = 3;
     */
    payload?: MessageContents;
  };

/**
 * Describes the message connectrpc.conformance.v1.StreamContents.StreamItem.
 * Use `create(StreamContents_StreamItemSchema)` to create a new message.
 */
export const StreamContents_StreamItemSchema: GenMessage<StreamContents_StreamItem> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 19, 0);

/**
 * RawHTTPResponse models a raw HTTP response. This can be used to craft
 * custom responses with odd properties (including certain kinds of
 * malformed responses) to test edge cases in clients.
 *
 * @generated from message connectrpc.conformance.v1.RawHTTPResponse
 */
export type RawHTTPResponse =
  Message<"connectrpc.conformance.v1.RawHTTPResponse"> & {
    /**
     * If status code is not specified, it will default to a 200 response code.
     *
     * @generated from field: uint32 status_code = 1;
     */
    statusCode: number;

    /**
     * Headers to be set on the response.
     *
     * @generated from field: repeated connectrpc.conformance.v1.Header headers = 2;
     */
    headers: Header[];

    /**
     * @generated from oneof connectrpc.conformance.v1.RawHTTPResponse.body
     */
    body:
      | {
          /**
           * The body is a single message.
           *
           * @generated from field: connectrpc.conformance.v1.MessageContents unary = 3;
           */
          value: MessageContents;
          case: "unary";
        }
      | {
          /**
           * The body is a stream, encoded using a five-byte
           * prefix before each item in the stream.
           *
           * @generated from field: connectrpc.conformance.v1.StreamContents stream = 4;
           */
          value: StreamContents;
          case: "stream";
        }
      | { case: undefined; value?: undefined };

    /**
     * Trailers to be set on the response.
     *
     * @generated from field: repeated connectrpc.conformance.v1.Header trailers = 5;
     */
    trailers: Header[];
  };

/**
 * Describes the message connectrpc.conformance.v1.RawHTTPResponse.
 * Use `create(RawHTTPResponseSchema)` to create a new message.
 */
export const RawHTTPResponseSchema: GenMessage<RawHTTPResponse> =
  /*@__PURE__*/
  messageDesc(file_connectrpc_conformance_v1_service, 20);

/**
 * The service implemented by conformance test servers. This is implemented by
 * the reference servers, used to test clients, and is expected to be implemented
 * by test servers, since this is the service used by reference clients.
 *
 * Test servers must implement the service as described.
 *
 * @generated from service connectrpc.conformance.v1.ConformanceService
 */
export const ConformanceService: GenService<{
  /**
   * A unary operation. The request indicates the response headers and trailers
   * and also indicates either a response message or an error to send back.
   *
   * Response message data is specified as bytes. The service should echo back
   * request properties in the ConformancePayload and then include the message
   * data in the data field.
   *
   * If the response_delay_ms duration is specified, the server should wait the
   * given duration after reading the request before sending the corresponding
   * response.
   *
   * Servers should allow the response definition to be unset in the request and
   * if it is, set no response headers or trailers and return no response data.
   * The returned payload should only contain the request info.
   *
   * @generated from rpc connectrpc.conformance.v1.ConformanceService.Unary
   */
  unary: {
    methodKind: "unary";
    input: typeof UnaryRequestSchema;
    output: typeof UnaryResponseSchema;
  };
  /**
   * A server-streaming operation. The request indicates the response headers,
   * response messages, trailers, and an optional error to send back. The
   * response data should be sent in the order indicated, and the server should
   * wait between sending response messages as indicated.
   *
   * Response message data is specified as bytes. The service should echo back
   * request properties in the first ConformancePayload, and then include the
   * message data in the data field. Subsequent messages after the first one
   * should contain only the data field.
   *
   * Servers should immediately send response headers on the stream before sleeping
   * for any specified response delay and/or sending the first message so that
   * clients can be unblocked reading response headers.
   *
   * If a response definition is not specified OR is specified, but response data
   * is empty, the server should skip sending anything on the stream. When there
   * are no responses to send, servers should throw an error if one is provided
   * and return without error if one is not. Stream headers and trailers should
   * still be set on the stream if provided regardless of whether a response is
   * sent or an error is thrown.
   *
   * @generated from rpc connectrpc.conformance.v1.ConformanceService.ServerStream
   */
  serverStream: {
    methodKind: "server_streaming";
    input: typeof ServerStreamRequestSchema;
    output: typeof ServerStreamResponseSchema;
  };
  /**
   * A client-streaming operation. The first request indicates the response
   * headers and trailers and also indicates either a response message or an
   * error to send back.
   *
   * Response message data is specified as bytes. The service should echo back
   * request properties, including all request messages in the order they were
   * received, in the ConformancePayload and then include the message data in
   * the data field.
   *
   * If the input stream is empty, the server's response will include no data,
   * only the request properties (headers, timeout).
   *
   * Servers should only read the response definition from the first message in
   * the stream and should ignore any definition set in subsequent messages.
   *
   * Servers should allow the response definition to be unset in the request and
   * if it is, set no response headers or trailers and return no response data.
   * The returned payload should only contain the request info.
   *
   * @generated from rpc connectrpc.conformance.v1.ConformanceService.ClientStream
   */
  clientStream: {
    methodKind: "client_streaming";
    input: typeof ClientStreamRequestSchema;
    output: typeof ClientStreamResponseSchema;
  };
  /**
   * A bidirectional-streaming operation. The first request indicates the response
   * headers, response messages, trailers, and an optional error to send back.
   * The response data should be sent in the order indicated, and the server
   * should wait between sending response messages as indicated.
   *
   * Response message data is specified as bytes and should be included in the
   * data field of the ConformancePayload in each response.
   *
   * Servers should send responses indicated according to the rules of half duplex
   * vs. full duplex streams. Once all responses are sent, the server should either
   * return an error if specified or close the stream without error.
   *
   * Servers should immediately send response headers on the stream before sleeping
   * for any specified response delay and/or sending the first message so that
   * clients can be unblocked reading response headers.
   *
   * If a response definition is not specified OR is specified, but response data
   * is empty, the server should skip sending anything on the stream. Stream
   * headers and trailers should always be set on the stream if provided
   * regardless of whether a response is sent or an error is thrown.
   *
   * If the full_duplex field is true:
   * - the handler should read one request and then send back one response, and
   *   then alternate, reading another request and then sending back another response, etc.
   *
   * - if the server receives a request and has no responses to send, it
   *   should throw the error specified in the request.
   *
   * - the service should echo back all request properties in the first response
   *   including the last received request. Subsequent responses should only
   *   echo back the last received request.
   *
   * - if the response_delay_ms duration is specified, the server should wait the given
   *   duration after reading the request before sending the corresponding
   *   response.
   *
   * If the full_duplex field is false:
   * - the handler should read all requests until the client is done sending.
   *   Once all requests are read, the server should then send back any responses
   *   specified in the response definition.
   *
   * - the server should echo back all request properties, including all request
   *   messages in the order they were received, in the first response. Subsequent
   *   responses should only include the message data in the data field.
   *
   * - if the response_delay_ms duration is specified, the server should wait that
   *   long in between sending each response message.
   *
   *
   * @generated from rpc connectrpc.conformance.v1.ConformanceService.BidiStream
   */
  bidiStream: {
    methodKind: "bidi_streaming";
    input: typeof BidiStreamRequestSchema;
    output: typeof BidiStreamResponseSchema;
  };
  /**
   * A unary endpoint that the server should not implement and should instead
   * return an unimplemented error when invoked.
   *
   * @generated from rpc connectrpc.conformance.v1.ConformanceService.Unimplemented
   */
  unimplemented: {
    methodKind: "unary";
    input: typeof UnimplementedRequestSchema;
    output: typeof UnimplementedResponseSchema;
  };
  /**
   * A unary endpoint denoted as having no side effects (i.e. idempotent).
   * Implementations should use an HTTP GET when invoking this endpoint and
   * leverage query parameters to send data.
   *
   * @generated from rpc connectrpc.conformance.v1.ConformanceService.IdempotentUnary
   */
  idempotentUnary: {
    methodKind: "unary";
    input: typeof IdempotentUnaryRequestSchema;
    output: typeof IdempotentUnaryResponseSchema;
  };
}> = /*@__PURE__*/ serviceDesc(file_connectrpc_conformance_v1_service, 0);
