# Contributing to AgentStudio

Thank you for considering contributing to AgentStudio!
We believe in open source and welcome contributions from everyone, no matter the scale.

There are many ways to contribute: you could introduce new tasks, improve our infrastructure, better the documentation, or fix bugs.

A great way to support AgentStudio is by promoting it. You can share it in your blog posts, illustrate how AgentStudio drives your amazing projects, mention us on Twitter, or simply star our repository.

## Contributing Guidelines

### Setup for Development

```bash
pip install -e ".[dev]"
pip install pre-commit
pre-commit install
apt-get install jq  # to validate JSON files
```

### Issue Reporting

Should you come across any bugs or wish to suggest a feature, kindly first visit our issues page to see if it's already been mentioned. If not, feel free to open a new issue and provide relevant information.

### Coding Style Guide

Please use the provided script [`scripts/format.sh`](scripts/format.sh) for code formatting. Additionally, Git pre-commit hooks are used to maintain the code style.

### Pull Requests

When opening a pull request:

1. Ensure your code is up to date with the latest main branch commit.
2. Format the code by running [`scripts/format.sh`](scripts/format.sh).
3. Provide a detailed description of your changes in the pull request. If your pull request fixes an open issue, please reference it.

### Running Tests

```bash
pytest test/
```

### Thank You

We sincerely appreciate the time you've taken to read these guidelines and your interest in contributing to AgentStudio. Your involvement is what makes AgentStudio a great project for everyone!
