import { Component, OnDestroy, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { Subscription } from 'rxjs';
import {
  faUsers,
  faBuilding,
  faCalendar,
  faPenToSquare,
  faPoll,
  faFileLines,
  faHashtag,
  faMessage,
  faBars,
} from '@fortawesome/free-solid-svg-icons';
import { SidebarService } from 'apps/shared-components/sidebar/service/sidebar.service';
import { ICommunityGroup } from '@commudle/shared-models';
import { SeoService } from '@commudle/shared-services';
import { ESidebarWidth } from 'apps/shared-components/sidebar/enum/sidebar.enum';
import { FooterService } from 'apps/commudle-admin/src/app/services/footer.service';

@Component({
  selector: 'app-dashboard',
  templateUrl: './dashboard.component.html',
  styleUrls: ['./dashboard.component.scss'],
})
export class DashboardComponent implements OnInit, OnDestroy {
  communityGroup: ICommunityGroup;
  subscriptions: Subscription[] = [];

  sidebarExpanded = true;
  showSideBar = false;

  //font-awesome
  icons = {
    faCalendar,
    faUsers,
    faPenToSquare,
    faBuilding,
    faPoll,
    faFileLines,
    faHashtag,
    faMessage,
    faBars,
  };
  ESidebarWidth = ESidebarWidth;
  sidebarEventName = 'communityGroup';

  constructor(
    private activatedRoute: ActivatedRoute,
    private seoService: SeoService,
    private footerService: FooterService,
    public sidebarService: SidebarService,
  ) {}

  ngOnInit() {
    this.footerService.changeMiniFooterStatus(false);

    this.seoService.noIndex(true);
    this.subscriptions.push(
      this.activatedRoute.data.subscribe((data) => {
        this.communityGroup = data.community_group;
        this.setMeta();
      }),
    );
    this.sidebarService.setSidebarVisibility(this.sidebarEventName, true);

    // eslint-disable-next-line no-prototype-builtins
    if (this.sidebarService.setSidebar$.hasOwnProperty(this.sidebarEventName)) {
      this.sidebarService.setSidebar$[this.sidebarEventName].subscribe((data) => {
        this.sidebarExpanded = data;
      });
    }
  }

  ngOnDestroy(): void {
    this.subscriptions.forEach((sub) => sub.unsubscribe());
    this.seoService.noIndex(false);
  }

  toggleSidebar() {
    this.sidebarService.toggleSidebarVisibility(this.sidebarEventName);
  }

  setMeta() {
    this.seoService.setTags(
      `Dashboard - Admin - ${this.communityGroup.name}`,
      this.communityGroup.mini_description,
      this.communityGroup.logo.i350,
    );
  }
}
