# Contribution Guidelines

(Borrowed heavily from [awesome-gbdev](https://github.com/gbdev/awesome-gbdev))

Before sending a Pull Request or opening an Issue, ensure it adheres to the following guidelines and policies.

Search previous suggestions and open issues before making a new one, as yours may be a duplicate.

Here's how you can contribute:

- Look at open [Issues](https://github.com/commandtab/awesome-n64-development/issues) and provide help or feedback 
- [Add a resource](#adding-a-resource)
- [Correct and improve existing entries](#correcting-and-improving-resources)
- [Fix broken links and unavailable resources](#removing-unavailable-resources)

If you are unsure about something, it's okay to open an [Issue](https://github.com/commandtab/awesome-n64-development/issues).

## Adding a Resource

### Is it "awesome"?

For a resource to be added to the list, it must:

- Be in English
- Be in a minimal working state
- Have a clear purpose (implementation reference is okay, too) and/or provide something interesting
- Provide a minimal documentation briefly describing what is the project and how to make use of it

### Pull Request

- Make an individual pull request for each suggestion
- Use the following format: `[resource](link) - Description`
- Additions should be added to the bottom of the relevant category
- New categories or improvements to the existing categorization are appreciated. You're welcome to discuss discrimination and categorization criteria in Issues/PRs
- Keep descriptions short and simple, but descriptive, pointing out the particularities or major features of the resource
- Check your spelling and grammar

If you are not confident in forking the repository, making the change and sending the PR, don't hesitate to open an Issue describing the addition (or the change you want to make/discuss).

## Removing an Unavailable Resource

You're welcome to remove any broken link in the repository, but first try to find a reliable mirror and replace it:

- Check on [Archive.org](https://archive.org/) and Google Cache
- Try the GitHub search

Then, **open an Issue** with any useful details.

You can then proceed to remove the broken link (or wait for someone to do it).

If you have some old and unavailable resource (not necessarly listed in the missing list) archived in your hard disk that maybe in the interest (even historical!) of the Nintendo 64 development community, please open an Issue attaching or linking the resource.

#### Thank you!
