import { vars, VisuallyHidden } from '@strum/react';
import * as React from 'react';
import { headerLogoStyle } from './Logo.css';

const Logo: React.FC = () => {
  return (
    <>
      <VisuallyHidden>
        The Strum logo: two oscillating strings from an instrument next to the
        word Strum
      </VisuallyHidden>
      <svg
        className={headerLogoStyle}
        id="prefix__Layer_1"
        xmlns="http://www.w3.org/2000/svg"
        viewBox="0 0 1404.02 238.97"
      >
        <path
          className="prefix__cls-3"
          d="M495.76 74.59c.35-8.71-2.2-15.43-7.63-20.17-5.44-4.74-13.55-7.11-24.35-7.11s-19.93 2.25-26.55 6.74c-6.62 4.49-10.52 10.23-11.71 17.19-1.53 7.6.78 13.4 6.95 17.4 6.17 4.01 13.67 7.05 22.52 9.15l18.4 4.6c11.91 2.79 22.26 6.83 31.04 12.12 8.78 5.3 15.26 12.11 19.44 20.43 4.18 8.33 5.26 18.45 3.24 30.36-3.28 19.58-13.15 35.17-29.63 46.77-16.48 11.6-37.82 17.4-64.02 17.4s-45.57-5.94-59.16-17.82c-13.59-11.88-18.74-29.35-15.47-52.41h43.79c-1.12 10.73 1.76 18.8 8.62 24.2 6.86 5.4 16.18 8.1 27.96 8.1s21.27-2.44 28.9-7.32c7.63-4.88 12.07-11.22 13.33-19.02 1.25-7.18-.96-12.75-6.64-16.72-5.68-3.97-14.13-7.32-25.35-10.03l-22.37-5.85c-17.21-4.39-30.26-11.27-39.14-20.64-8.88-9.37-12.07-21.93-9.56-37.68 2.23-13.03 7.65-24.39 16.25-34.07s19.47-17.23 32.61-22.63c13.13-5.4 27.5-8.1 43.11-8.1s29.3 2.74 40.24 8.21c10.94 5.47 18.92 13.08 23.93 22.84 5.02 9.76 6.55 21.11 4.6 34.07h-43.37ZM559.3 49.72l6.27-37.31h175.8l-6.27 37.31h-65.53l-29.26 176.74h-44.73l29.27-176.74h-65.53ZM726.68 226.46l35.54-214.05h84.45c24.32 0 42.12 6.34 53.41 19.02s15.19 29.65 11.71 50.9c-2.37 14.63-7.7 27.14-15.99 37.52-8.29 10.38-18.95 18.19-31.98 23.41l31.67 83.2h-49.96l-28.01-75.88H784.6l-12.65 75.88h-45.26Zm63.96-112.25h30.73c25.71 0 40.31-10.63 43.79-31.88 3.55-21.95-7.49-32.92-33.13-32.92h-30.52l-10.87 64.8ZM1087.61 12.41h45.26l-22.99 139.01c-2.58 15.61-8.56 29.26-17.93 40.97-9.37 11.71-21.25 20.82-35.64 27.33-14.39 6.52-30.47 9.77-48.24 9.77s-32.75-3.26-44.94-9.77c-12.2-6.51-21.01-15.62-26.44-27.33s-6.86-25.36-4.29-40.97l22.99-139.01h45.26l-22.47 135.14c-1.95 12.19.4 22.26 7.06 30.21 6.65 7.94 16.5 11.92 29.53 11.92s24.37-3.97 33.6-11.92c9.23-7.94 14.82-18.01 16.77-30.21l22.47-135.14ZM1171.99 12.41h55.81l35.22 143.82h2.51l82.68-143.82h55.81l-35.54 214.05h-43.9l23.2-139.32h-1.88l-78.18 138.28h-30l-32.19-138.8h-1.78l-23.41 139.84h-43.9l35.54-214.05Z"
          style={{
            fill: vars.neutral.neutral12,
          }}
        />
        <path
          d="M0 205.76c49.05 0 83.3-174.14 132.36-174.14s14.8 174.14 63.86 174.14 83.3-174.14 132.35-174.14"
          style={{
            fill: 'none',
            strokeMiterlimit: 10,
            stroke: vars.neutral.neutral12,
            strokeWidth: 15,
          }}
        />
        <path
          d="M33.39 15c49.05 0 14.8 208.97 63.85 208.97S180.54 15 229.6 15s14.8 208.97 63.86 208.97"
          style={{
            stroke: vars.accent.accent9,
            strokeWidth: 30,
            fill: 'none',
            strokeMiterlimit: 10,
          }}
        />
      </svg>
    </>
  );
};

export default Logo;
