create table address (address_id integer generated by default as identity (start with 1), city varchar(15) not null, country varchar(20) not null, house_flat_no integer not null check (house_flat_no>=1), postcode varchar(8) not null, street varchar(255) not null, primary key (address_id))
create table customer (customer_id integer generated by default as identity (start with 1), customer_date_of_birth timestamp not null, customer_email_address clob(255) not null, customer_firstname varchar(50) not null, customer_lastname varchar(50) not null, customer_address_id integer, primary key (customer_id))
create table customer_payment_details (customer_payment_details_id integer generated by default as identity (start with 1), customer_card_expiry_date timestamp not null, customer_card_number varchar(16) not null, customer_reference varchar(20) not null, customer_id integer not null, primary key (customer_payment_details_id))
create table items (item_id integer generated by default as identity (start with 1), item_name varchar(255) not null, item_price numeric(19,2) not null, primary key (item_id))
create table orders (order_id integer generated by default as identity (start with 1), customer_id integer not null, primary key (order_id))
create table orders_items (order_id integer not null, item_id integer not null, primary key (order_id, item_id))
alter table customer add constraint FK_b95lvfwqwswe6953ms7i58koj foreign key (customer_address_id) references address
alter table customer_payment_details add constraint FK_45wvux3gqtvc2s8k4r1312c0j foreign key (customer_id) references customer
alter table orders add constraint FK_astys1dv61mdlp0n0wx0574r2 foreign key (customer_id) references customer
alter table orders_items add constraint FK_erdocw5fhr37d4mkjg3d568pd foreign key (item_id) references items
alter table orders_items add constraint FK_sbml7tdyps7g2gbfj9ul40yas foreign key (order_id) references orders
