# Productivity

## Flash Cards

### Toolbox
* [Firebase](https://firebase.google.com/) (firebase.google.com)

### Tutorials
* [React Firebase Flashcards App Tutorial](https://www.youtube.com/watch?v=pKCAtlsn1Eo) (youtube.com)
* [How To Build A Flashcard Quiz With React](https://youtu.be/hEtZ040fsD8) (youtube.com)

### Inspiration
* [Pure CSS - Sticky-Stacked Cards](https://codepen.io/enbee81/full/MWKxrvP) (codepen.io)
* [@dolearning and @colbyfayock Stream with Next.js and Tailwind](https://www.youtube.com/watch?v=5yIBAeGphTw) (youtube.com)
* [Flash Cards using Next.js Starter Tailwind](https://github.com/doingandlearning/flash-cards) (github.com)

## Mood Board

### Toolbox
* [Cloudinary](https://cloudinary.com/) (cloudinary.com)
* [use-cloudinary](https://github.com/domitriusclark/use-cloudinary#readme) (github.com)

### Tutorials
* [Leveraging React for Easy Image Management with Cloudinary](https://scotch.io/tutorials/leveraging-react-for-easy-image-management-with-cloudinary) (scotch.io)

### Inspiration
* [How to create mood boards that inspire: 20 pro tips](https://www.creativebloq.com/graphic-design/mood-boards-812470) (creativebloq.com)

## Bookmark Manager

### Toolbox
* [FaunaDB](https://fauna.com/) (fauna.com)
* [useFauna](https://github.com/ryancharris/use-fauna) (github.com)

### Tutorials
* [Build a dynamic JAMstack app with GatsbyJS and FaunaDB](https://css-tricks.com/build-a-dynamic-jamstack-app-with-gatsbyjs-and-faunadb/) (css-tricks.com)
* [Use bookmarklets to quickly perform common web page tasks](https://support.mozilla.org/en-US/kb/bookmarklets-perform-common-web-page-tasks) (support.mozilla.org)
* [Create a bookmark manager app using FaunaDB and Netlify](https://dev.to/myogeshchavan97/create-a-bookmark-manager-app-using-faunadb-and-netlify-serverless-functions-4cp0) (dev.to)

### Inspiration
Know of any good examples? Submit a Pull Request!

## Budget Manager

### Toolbox
* [Google Sheets API](https://developers.google.com/sheets/api) (developers.google.com)
* [sheet2api](https://sheet2api.com/) (sheet2api.com)

### Tutorials
* [Build an Expense Tracker | React Hooks & Context API](https://www.youtube.com/watch?v=XuFDcZABiDQ) (youtube.com)
* [The complete guide on how to use Google sheets as a database](https://codingislove.com/google-sheets-database/) (codingislove.com)

### Inspiration
* [Budgeting](https://shashiirk.github.io/budgeting) (shashiirk.github.io)

## Habit Reminder

### Toolbox
* [TypeORM](https://typeorm.io/) (typeorm.io)

### Tutorials
* [Build a Health Tracking App with React, GraphQL, and User Authentication](https://scotch.io/tutorials/build-a-health-tracking-app-with-react-graphql-and-user-authentication) (scotch.io)

### Inspiration
Know of any good examples? Submit a Pull Request!

## Shopping List

### Toolbox
* [Firebase](https://firebase.google.com/) (firebase.google.com)

### Tutorials
* [Beginning our React todo list](https://developer.mozilla.org/en-US/docs/Learn/Tools_and_testing/Client-side_JavaScript_frameworks/React_todo_list_beginning)
* [How to Build a TodoApp using ReactJS and Firebase](https://www.freecodecamp.org/news/how-to-build-a-todo-application-using-reactjs-and-firebase/)

### Inspiration
* [Todos](https://shashiirk.github.io/todos) (shashiirk.github.io)

## Notebook

### Toolbox
* [Gatsby Brain Theme](https://github.com/aengusmcmillin/gatsby-theme-brain) (github.com)
* [Fuse.js](https://fusejs.io/) (fusejs.io)

### Tutorials
* [How to Add Search to a React App with Fuse.js](https://www.freecodecamp.org/news/how-to-add-search-to-a-react-app-with-fuse-js/) (freecodecamp.org)

### Inspiration
* [Foam](https://foambubble.github.io/foam/) (foambubble.github.io)
* [Roam Research](https://roamresearch.com/) (roamresearch.com)
* [Gatsby Garden Theme](https://github.com/mathieudutour/gatsby-digital-garden) (github.com)

---

## Know of any other good resources?
If you know of a great tutorial or another tool that can help others, open a pull request with a link!
