# Contributing
This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!

## Issues

### Creating an Issue
If you find a bug, problem, or maybe the documentation just doesn't make sense, please create an Issue to document the concern.

### Description
Please be description in your Issue, the more info you provide, the more likely someone will be able to help.

### Code Examples
If you're experiencing an issue with the code, the most helpful thing you can do is create an example where you can reproduce the problem. This can be an open source Github repo, a private repo you can share with the maintainers, a [CodeSandbox](https://codesandbox.io/), or really anything to show the issue live with code along side of it.

## Pull Requests

### Creating a Pull Request
If you're able to fix an active Issue, feel free to create a new Pull Request addressing the problem. There are no gaurantees that the code will be merged in "as is", but chances are, if you're willing to work with the maintainers, everyone will be able to come up with a solution everyone can be happy with.

### Description
Please be description in your Pull Request. Whether big or small, it's important to be able to see the context of a change throughout the history of a project.

### Linking Fixed Issues
If the Pull Request is addressing an Issue, please link that issue by specifying the `Fixes [Issue #]` syntax within the Pull Request.

### Getting Added to All Contributors in the README.md
Once your Pull Request is successfully merged, feel free to tag yourself using the [All Conributors syntax](https://allcontributors.org/docs/en/bot/usage), which will create a new Pull Request requesting to add you in.

```
@all-contributors please add <username> for <contributions>
```

If your Pull Request is merged in and you're not added, please let someone know if you don't want to tag yourself, as we want to recognize everyone for their help.
