This repository contains the source code for the [Good1stIssue Github App](https://github.com/apps/good1stissue) and [good1stissue.codinasion.org](https://good1stissue.codinasion.org/)

## Table of Contents

- [Table of Contents](#table-of-contents)
- [New contributor guide](#new-contributor-guide)
  - [Update the GitHub App](#update-the-github-app)
  - [Update the website](#update-the-website)
  - [Improve the documentation](#improve-the-documentation)
  - [Report a bug](#report-a-bug)
  - [Suggest an improvement](#suggest-an-improvement)
  - [Ask a question](#ask-a-question)
- [License](#license)
  

## New contributor guide

To get an overview of the project, read the [README](README.md). Here are some resources to help you get started with open source contributions:

- [Finding ways to contribute to open source on GitHub][2]
- [Set up Git][3]
- [GitHub flow][4]
- [Collaborating with pull requests][5]

### Update the GitHub App

If you want to update the GitHub App, you can do so by following these steps:

1. [Fork this repository][1]
2. Create a new branch for your changes
3. Make your changes in the [`app/index.ts`](app/index.ts) file
4. Run `yarn build-app` to make sure that your changes are transpiled correctly
5. Create a pull request. Please make sure that you `allow edits from maintainers`, for easier merging.
6. Wait for your pull request to be reviewed and merged
7. :partying_face: Celebrate, as your changes will be deployed to the GitHub App and will help awesome Open Source developers!

### Update the website

If you want to update the website, you can do so by following these steps:

1. [Fork this repository][1]
2. Create a new branch for your changes
3. Make your changes in the [`pages`](pages)\ [`src`](src) \ [`styles`](styles) folders
4. Create a pull request. Please make sure that you `allow edits from maintainers`, for easier merging.
5. Wait for your pull request to be reviewed and merged
6. :partying_face: Celebrate, as your changes will be deployed to the website and will help awesome Open Source developers!

### Improve the documentation

If you want to improve the documentation, you can do so by following these steps:

1. Fork this repository
2. Create a new branch
3. Make your changes to the documentation
4. Create a pull request
5. Wait for your pull request to be reviewed and merged
6. :partying_face: Celebrate, as you have made the documentation better for everyone!

### Report a bug

If you want to report a bug, you can do so by creating a new issue using [the bug report template][6].

### Suggest an improvement

If you want to suggest an improvement, you can do so by creating a new issue using [the feature request template][7].

### Ask a question

If you want to ask a question, you can do so by creating a [new Discussion][8]. Please make sure that your question hasn't already been answered in the [Discussions][8].

## License

This project is licensed under the MIT License - see the [LICENSE.md](LICENSE.md) file for details.

---

[1]: https://docs.github.com/en/get-started/quickstart/fork-a-repo 'How to fork a GitHub repository'
[2]: https://docs.github.com/en/get-started/exploring-projects-on-github/finding-ways-to-contribute-to-open-source-on-github 'Finding ways to contribute to open source on GitHub'
[3]: https://docs.github.com/en/get-started/quickstart/set-up-git 'Set up Git'
[4]: https://docs.github.com/en/get-started/quickstart/github-flow 'GitHub flow'
[5]: https://docs.github.com/en/get-started/quickstart/collaborating-with-issues-and-pull-requests 'Collaborating with pull requests'
[6]: https://github.com/codinasion/good-1st-issue/issues/new?assignees=&labels=bug&template=bug.yml 'Bug report template'
[7]: https://github.com/codinasion/good-1st-issue/issues/new?assignees=&labels=bug&template=feature_request.yml 'Feature request template'
[8]: https://github.com/codinasion/good-1st-issue/discussions 'Discussions'
