export default {
  defaultTheme: "light",
  themes: {
    light: {
      colors: {
        dark: "#1e293b",
        light: "#f1f5f9",
        white: "#ffffff",
        primary: "#624bff",
        "on-primary": "#fff",
        secondary: "#475569",
        "on-secondary": "#fff",
        success: "#198754",
        "on-success": "#fff",
        info: "#0dcaf0",
        "on-info": "#1e293b",
        warning: "#ffc107",
        "on-warning": "#1e293b",
        error: "#dc3545",
        background: "#f1f5f9",
        "on-background": "#1e293b",
        surface: "#ffffff",
        "on-surface": "#1e293b",
        grey200: "#e2e8f0",
        grey300: "#cbd5e1",
        grey600: "#475569",
        grey400: "#94a3b8",
        "grey-50": "#f8f8f9",
        "grey-100": "#f1f5f9",
        "grey-200": "#e2e8f0",
        "grey-300": "#cbd5e1",
        "grey-400": "#94a3b8",
        "grey-500": "#64748b",
        "grey-600": "#475569",
        "grey-700": "#334155",
        "grey-800": "#1e293b",
        "grey-900": "#0f172a",
        "perfect-scrollbar-thumb": "#4A5072",
        "skin-bordered-background": "#2f3349",
        "skin-bordered-surface": "#2f3349",
      },

      variables: {
        apexChartFontFamily: '"Inter", "sans-serif"',
        apexChatFontWeight: 400,
        apexChatFontSize: "12px",
        vectorMapFontSize: 13,
        vectorMapFontWeight: 600,
        vectorMapFontFamily: '"Inter", "sans-serif"',
        "code-color": "#d63384",
        "overlay-scrim-background": "#101121",
        "overlay-scrim-opacity": 0.6,
        "tooltip-background": "#1e293b",
        "hover-opacity": 0.1,
        "focus-opacity": 0.12,
        "selected-opacity": 0.06,
        "activated-opacity": 0.16,
        "pressed-opacity": 0.14,
        "dragged-opacity": 0.1,
        "disabled-opacity": 0.42,
        "border-color": "#1e293b",
        "border-opacity": 0.16,
        "high-emphasis-opacity": 0.78,
        "medium-emphasis-opacity": 0.688,
        "switch-opacity": 0.5,
        "switch-disabled-track-opacity": 0.4,
        "switch-disabled-thumb-opacity": 0.8,
        "switch-checked-disabled-opacity": 0.3,
        // Shadows
        "shadow-key-umbra-color": "#0F1422",
        "shadow-key-umbra-opacity": "rgba(var(--v-theme-on-surface), 0.06)",
        "shadow-key-penumbra-opacity": "rgba(var(--v-theme-on-surface), 0.04)",
        "shadow-key-ambient-opacity": "rgba(var(--v-theme-on-surface), 0.02)",
      },
    },

    dark: {
      colors: {
        dark: "#f1f5f9",
        light: "#1e293b",
        white: "#ffffff",
        primary: "#624bff",
        "on-primary": "#fff",
        secondary: "#f3f5f7",
        "on-secondary": "#1e293b",
        success: "#198754",
        "on-success": "#fff",
        info: "#0dcaf0",
        "on-info": "#1e293b",
        warning: "#ffc107",
        "on-warning": "#1e293b",
        error: "#dc3545",
        background: "#000000",
        "on-background": "#f1f5f9",
        surface: "#1e293b",
        "on-surface": "#fff",
        grey200: "#26293A",
        grey300: "#4A5072",
        grey400: "#5E6692",
        grey600: "#AAB3DE",
        "grey-50": "#26293A",
        "grey-100": "#2F3349",
        "grey-200": "#26293A",
        "grey-300": "#4A5072",
        "grey-400": "#5E6692",
        "grey-500": "#7983BB",
        "grey-600": "#AAB3DE",
        "grey-700": "#B6BEE3",
        "grey-800": "#CFD3EC",
        "grey-900": "#E7E9F6",
        "perfect-scrollbar-thumb": "#4A5072",
        "skin-bordered-background": "#2f3349",
        "skin-bordered-surface": "#2f3349",
      },

      variables: {
        apexChartFontFamily: '"Inter", "sans-serif"',
        apexChatFontWeight: 400,
        apexChatFontSize: "12px",
        vectorMapFontSize: 13,
        vectorMapFontWeight: 600,
        vectorMapFontFamily: '"Inter", "sans-serif"',
        "code-color": "#d63384",
        "overlay-scrim-background": "#32475C",
        "overlay-scrim-opacity": 0.5,
        "tooltip-background": "#f1f5f9",
        "hover-opacity": 0.1,
        "focus-opacity": 0.12,
        "selected-opacity": 0.06,
        "activated-opacity": 0.16,
        "pressed-opacity": 0.14,
        "dragged-opacity": 0.1,
        "disabled-opacity": 0.42,
        "border-color": "#f1f5f9",
        "border-opacity": 0.16,
        "high-emphasis-opacity": 0.78,
        "medium-emphasis-opacity": 0.68,
        "switch-opacity": 0.2,
        "switch-disabled-track-opacity": 0.3,
        "switch-disabled-thumb-opacity": 0.4,
        "switch-checked-disabled-opacity": 0.3,
        // Shadows
        "shadow-key-umbra-color": "#2F2B3D",
        "shadow-key-umbra-opacity": "rgba(var(--v-theme-on-surface), 0.06)",
        "shadow-key-penumbra-opacity": "rgba(var(--v-theme-on-surface), 0.04)",
        "shadow-key-ambient-opacity": "rgba(var(--v-theme-on-surface), 0.02)",
      },
    },
  },
};
