import React from "react";

import styles from "./Provider.module.css";

const ProviderIllustration: React.FC<{ isActive: boolean }> = ({
  isActive,
}) => {
  return (
    <div className={isActive ? styles.active : ""}>
      <svg
        className={styles.svg}
        fill="none"
        height="699"
        viewBox="0 0 1020 699"
        width="1020"
        xmlns="http://www.w3.org/2000/svg"
      >
        <g className={styles.code1} clipPath="url(#clip1_945_4450)">
          <rect
            fill="#1B1B1B"
            height="394"
            rx="10"
            transform="matrix(0.866025 -0.5 0.866025 0.5 0 413.562)"
            width="722.543"
          />
          <path
            d="M67.5662 411.521L74.7369 415.661L77.0518 414.324L78.0884 414.923L71.931 418.478L70.8943 417.879L73.4275 416.417L67.2934 412.875L64.8382 414.293L63.8016 413.694L67.5662 411.521ZM62.6792 409.905C62.9702 409.737 63.2898 409.655 63.6379 409.658C63.9912 409.658 64.2952 409.731 64.5498 409.878C64.8148 410.031 64.9499 410.211 64.9551 410.418C64.9603 410.619 64.8174 410.804 64.5265 410.972C64.2511 411.131 63.9367 411.21 63.5833 411.21C63.2248 411.207 62.913 411.129 62.648 410.976C62.3934 410.829 62.2661 410.654 62.2661 410.45C62.2661 410.246 62.4038 410.064 62.6792 409.905ZM77.9966 405.301C78.2616 405.148 78.5708 405.036 78.9241 404.964C79.2826 404.889 79.7035 404.901 80.1868 405C80.67 405.099 81.226 405.33 81.8547 405.693L87.9654 409.221L86.7495 409.923L80.8493 406.516C80.3349 406.219 79.9322 406.023 79.6412 405.927C79.3502 405.831 79.0566 405.868 78.7604 406.039C78.5162 406.18 78.3499 406.366 78.2616 406.597C78.1733 406.822 78.1888 407.101 78.3084 407.434L84.684 411.115L83.4603 411.822L77.5601 408.415C77.0457 408.118 76.643 407.922 76.352 407.826C76.061 407.73 75.7674 407.767 75.4713 407.938C75.2166 408.085 75.0478 408.273 74.9646 408.501C74.8815 408.723 74.8997 409 75.0192 409.333L81.3949 413.014L80.1868 413.712L71.9794 408.973L73.0083 408.379L74.0371 408.883C73.9436 408.571 73.928 408.274 73.9903 407.992C74.0527 407.704 74.2891 407.442 74.6996 407.205C75.0114 407.025 75.3803 406.899 75.8064 406.827C76.2273 406.752 76.7157 406.8 77.2717 406.971C77.173 406.656 77.1652 406.36 77.2483 406.084C77.3263 405.805 77.5757 405.544 77.9966 405.301ZM85.6055 400.908C86.3329 400.488 87.089 400.256 87.8736 400.211C88.6634 400.163 89.4766 400.269 90.3132 400.53C91.1446 400.788 91.9889 401.165 92.8463 401.66C93.6725 402.137 94.2934 402.63 94.7091 403.14C95.1248 403.644 95.2833 404.138 95.1846 404.621C95.0858 405.104 94.6805 405.551 93.9687 405.962C93.0697 406.481 92.0305 406.715 90.851 406.664L94.7637 408.923L93.6179 409.773L82.1058 403.127L83.2204 402.483L84.4753 403.082C84.3558 402.665 84.3896 402.27 84.5766 401.898C84.7689 401.523 85.1118 401.193 85.6055 400.908ZM86.3459 401.696C85.8938 401.957 85.6314 402.267 85.5587 402.627C85.4859 402.981 85.5041 403.319 85.6132 403.64L89.6818 405.989C90.2118 406.049 90.7315 406.04 91.2407 405.962C91.7499 405.878 92.1994 405.723 92.5891 405.498C93.2698 405.105 93.5218 404.66 93.3451 404.162C93.1685 403.664 92.5319 403.098 91.4355 402.465C90.7185 402.051 90.056 401.747 89.448 401.552C88.8349 401.354 88.2737 401.267 87.7645 401.291C87.25 401.312 86.7772 401.447 86.3459 401.696ZM94.4068 395.827C95.1811 395.38 96.0047 395.108 96.8776 395.012C97.7506 394.91 98.6365 394.969 99.5354 395.188C100.44 395.404 101.326 395.762 102.193 396.263C103.03 396.746 103.635 397.252 104.009 397.78C104.383 398.308 104.493 398.83 104.337 399.346C104.181 399.856 103.718 400.333 102.949 400.777C102.18 401.221 101.357 401.492 100.479 401.591C99.6004 401.69 98.7067 401.633 97.7973 401.42C96.888 401.201 96.0047 400.844 95.1473 400.349C94.3003 399.86 93.6898 399.352 93.3157 398.824C92.9415 398.296 92.8376 397.777 93.0039 397.267C93.1702 396.751 93.6378 396.271 94.4068 395.827ZM95.4747 396.443C94.768 396.851 94.4952 397.312 94.6563 397.825C94.8173 398.332 95.4487 398.903 96.5503 399.539C97.6311 400.163 98.6105 400.525 99.4887 400.624C100.372 400.72 101.167 400.564 101.874 400.156C102.58 399.748 102.848 399.29 102.677 398.783C102.51 398.273 101.882 397.703 100.79 397.073C99.6991 396.443 98.7171 396.08 97.8441 395.984C96.966 395.885 96.1761 396.038 95.4747 396.443ZM109.085 397.027L108.08 396.447L109.358 395.709L103.161 392.131L101.883 392.869L100.878 392.289L103.154 390.975L105.336 391.956C104.978 391.383 104.84 390.859 104.923 390.385C105.006 389.911 105.419 389.46 106.162 389.031C106.391 388.899 106.612 388.792 106.825 388.711C107.038 388.624 107.264 388.542 107.503 388.464L108.29 389.359C108.072 389.431 107.882 389.502 107.721 389.571C107.555 389.637 107.381 389.722 107.199 389.827C106.57 390.19 106.253 390.631 106.248 391.15C106.243 391.669 106.557 392.268 107.191 392.946L110.667 394.953L112.335 393.99L113.341 394.57L109.085 397.027ZM109.015 390.795L107.23 389.764L106.373 389.116L107.503 388.464L110.091 390.174L109.015 390.795ZM124.457 387.675C124.363 387.945 124.169 388.226 123.872 388.517C123.576 388.808 123.236 389.064 122.851 389.286C121.968 389.796 121.056 390.056 120.116 390.065C119.175 390.074 118.341 389.868 117.614 389.448L112.719 386.622L110.833 387.711L109.819 387.126L111.706 386.037L109.843 384.962L110.996 384.116L113.015 385.281L115.852 383.643L116.71 384.318L114.028 385.866L118.908 388.683C119.365 388.947 119.832 389.079 120.31 389.079C120.794 389.076 121.316 388.913 121.877 388.589C122.184 388.412 122.431 388.227 122.618 388.035C122.805 387.843 122.953 387.65 123.062 387.455L124.457 387.675ZM279.772 284.999C280.214 284.744 280.653 284.535 281.089 284.373C281.526 284.211 281.975 284.078 282.438 283.973L282.991 284.778C282.612 284.865 282.245 284.978 281.892 285.116C281.539 285.254 281.204 285.414 280.887 285.597C280.315 285.927 279.996 286.241 279.928 286.538C279.866 286.832 280.066 287.112 280.528 287.379L282.196 288.342L284.979 286.736L285.867 287.411L283.225 288.936L289.764 292.712L288.455 293.468L281.916 289.692L279.959 290.822L278.93 290.228L280.887 289.098L279.25 288.153C278.741 287.859 278.432 287.531 278.322 287.168C278.218 286.802 278.294 286.431 278.548 286.056C278.798 285.678 279.206 285.326 279.772 284.999ZM296.025 289.097L295.019 288.517L296.298 287.779L290.101 284.201L288.823 284.939L287.817 284.359L290.093 283.045L292.276 284.026C291.917 283.453 291.78 282.929 291.863 282.455C291.946 281.981 292.359 281.53 293.102 281.101C293.331 280.969 293.551 280.862 293.764 280.781C293.978 280.694 294.204 280.612 294.443 280.534L295.23 281.429C295.012 281.501 294.822 281.572 294.661 281.641C294.495 281.707 294.32 281.792 294.139 281.897C293.51 282.26 293.193 282.701 293.188 283.22C293.183 283.739 293.497 284.338 294.131 285.016L297.607 287.023L299.275 286.06L300.28 286.64L296.025 289.097ZM295.955 282.865L294.17 281.834L293.312 281.186L294.443 280.534L297.03 282.244L295.955 282.865ZM300.041 277.104C300.815 276.657 301.638 276.385 302.511 276.289C303.384 276.187 304.27 276.246 305.169 276.465C306.073 276.681 306.959 277.039 307.827 277.54C308.664 278.023 309.269 278.529 309.643 279.057C310.017 279.585 310.126 280.107 309.97 280.623C309.814 281.133 309.352 281.61 308.583 282.054C307.814 282.498 306.99 282.769 306.112 282.868C305.234 282.967 304.34 282.91 303.431 282.697C302.522 282.478 301.638 282.121 300.781 281.626C299.934 281.137 299.323 280.629 298.949 280.101C298.575 279.573 298.471 279.054 298.638 278.544C298.804 278.028 299.271 277.548 300.041 277.104ZM301.108 277.72C300.402 278.128 300.129 278.589 300.29 279.102C300.451 279.609 301.082 280.18 302.184 280.816C303.265 281.44 304.244 281.802 305.122 281.901C306.006 281.997 306.801 281.841 307.507 281.433C308.214 281.025 308.482 280.567 308.31 280.06C308.144 279.55 307.515 278.98 306.424 278.35C305.333 277.72 304.351 277.357 303.478 277.261C302.6 277.162 301.81 277.315 301.108 277.72ZM311.671 270.389C311.936 270.236 312.245 270.123 312.599 270.051C312.957 269.976 313.378 269.988 313.861 270.087C314.345 270.186 314.901 270.417 315.529 270.78L321.64 274.308L320.424 275.01L314.524 271.604C314.009 271.307 313.607 271.11 313.316 271.014C313.025 270.918 312.731 270.956 312.435 271.127C312.191 271.268 312.025 271.454 311.936 271.685C311.848 271.91 311.863 272.189 311.983 272.522L318.359 276.203L317.135 276.909L311.235 273.503C310.72 273.206 310.318 273.009 310.027 272.913C309.736 272.817 309.442 272.855 309.146 273.026C308.891 273.173 308.722 273.36 308.639 273.588C308.556 273.81 308.574 274.088 308.694 274.421L315.07 278.102L313.861 278.799L305.654 274.061L306.683 273.467L307.712 273.971C307.618 273.659 307.603 273.362 307.665 273.08C307.727 272.792 307.964 272.529 308.374 272.292C308.686 272.112 309.055 271.986 309.481 271.914C309.902 271.839 310.39 271.887 310.946 272.058C310.848 271.743 310.84 271.448 310.923 271.172C311.001 270.893 311.25 270.632 311.671 270.389ZM128.072 446.967C128.482 446.73 128.797 446.47 129.015 446.188C129.238 445.903 129.397 445.614 129.49 445.32L130.987 445.446C130.935 445.83 130.745 446.218 130.418 446.611C130.091 447.004 129.685 447.34 129.202 447.619C128.386 448.09 127.516 448.392 126.591 448.524C125.666 448.65 124.736 448.617 123.801 448.425C122.86 448.23 121.961 447.885 121.104 447.39C120.283 446.916 119.698 446.404 119.35 445.855C119.002 445.3 118.927 444.75 119.124 444.204C119.327 443.655 119.839 443.143 120.66 442.669C121.184 442.366 121.756 442.129 122.374 441.958C122.993 441.781 123.653 441.673 124.354 441.634L124.588 442.507C123.996 442.567 123.463 442.665 122.99 442.8C122.517 442.929 122.099 443.098 121.735 443.308C121.029 443.716 120.712 444.205 120.784 444.775C120.857 445.345 121.436 445.944 122.522 446.571C123.25 446.991 123.949 447.274 124.619 447.421C125.289 447.562 125.916 447.591 126.497 447.507C127.079 447.417 127.604 447.237 128.072 446.967ZM129.406 437.62C130.181 437.173 131.004 436.901 131.877 436.805C132.75 436.703 133.636 436.762 134.535 436.981C135.439 437.197 136.325 437.555 137.193 438.056C138.029 438.539 138.635 439.045 139.009 439.573C139.383 440.101 139.492 440.623 139.336 441.139C139.18 441.649 138.718 442.126 137.949 442.57C137.18 443.014 136.356 443.285 135.478 443.384C134.6 443.483 133.706 443.426 132.797 443.213C131.888 442.994 131.004 442.637 130.147 442.142C129.3 441.653 128.689 441.145 128.315 440.617C127.941 440.089 127.837 439.57 128.003 439.06C128.17 438.544 128.637 438.064 129.406 437.62ZM130.474 438.236C129.768 438.644 129.495 439.105 129.656 439.618C129.817 440.125 130.448 440.696 131.55 441.332C132.631 441.956 133.61 442.318 134.488 442.417C135.372 442.513 136.167 442.357 136.873 441.949C137.58 441.541 137.848 441.083 137.676 440.576C137.51 440.066 136.881 439.496 135.79 438.866C134.699 438.236 133.717 437.873 132.844 437.777C131.966 437.678 131.176 437.831 130.474 438.236ZM144.007 438.865L135.799 434.127L136.914 433.483L138.153 434.082C138.065 433.647 138.158 433.221 138.434 432.804C138.709 432.381 139.083 432.033 139.556 431.76C140.362 431.295 141.159 431.08 141.949 431.116C142.744 431.149 143.521 431.385 144.28 431.823L150.242 435.265L148.933 436.021L143.937 433.137C143.375 432.813 142.892 432.57 142.487 432.408C142.076 432.243 141.694 432.172 141.341 432.196C140.983 432.217 140.595 432.348 140.18 432.588C139.858 432.774 139.624 432.99 139.478 433.236C139.338 433.479 139.263 433.726 139.252 433.978C139.242 434.224 139.27 434.451 139.338 434.658L145.316 438.109L144.007 438.865ZM155.24 431.336C155.869 430.973 156.248 430.619 156.378 430.274C156.508 429.923 156.375 429.633 155.98 429.405C155.731 429.261 155.469 429.164 155.193 429.113C154.923 429.059 154.575 429.071 154.149 429.149C153.723 429.227 153.146 429.392 152.418 429.644C151.712 429.89 151.057 430.082 150.454 430.22C149.852 430.352 149.285 430.4 148.755 430.364C148.23 430.325 147.731 430.169 147.259 429.896C146.796 429.629 146.529 429.324 146.456 428.982C146.383 428.634 146.492 428.274 146.783 427.902C147.069 427.527 147.521 427.161 148.139 426.804C148.799 426.423 149.462 426.143 150.127 425.963C150.792 425.777 151.423 425.658 152.021 425.607L152.333 426.453C151.808 426.51 151.291 426.608 150.782 426.746C150.267 426.881 149.745 427.101 149.215 427.407C148.571 427.779 148.215 428.102 148.147 428.375C148.074 428.645 148.197 428.871 148.514 429.054C148.753 429.192 149.018 429.27 149.309 429.288C149.6 429.3 149.968 429.252 150.415 429.144C150.857 429.033 151.431 428.861 152.138 428.627C152.813 428.399 153.447 428.228 154.04 428.114C154.637 427.997 155.209 427.967 155.754 428.024C156.3 428.081 156.827 428.256 157.337 428.55C157.919 428.886 158.225 429.255 158.256 429.657C158.282 430.056 158.113 430.457 157.75 430.859C157.386 431.255 156.91 431.622 156.323 431.961C155.58 432.39 154.84 432.695 154.102 432.875C153.364 433.049 152.665 433.149 152.005 433.176L151.888 432.245C152.476 432.212 153.06 432.123 153.642 431.979C154.224 431.829 154.757 431.615 155.24 431.336ZM168.804 424.072C168.71 424.342 168.515 424.622 168.219 424.913C167.923 425.204 167.583 425.461 167.198 425.683C166.315 426.193 165.403 426.452 164.462 426.461C163.522 426.47 162.688 426.265 161.96 425.845L157.065 423.019L155.179 424.108L154.166 423.523L156.052 422.434L154.189 421.358L155.343 420.512L157.362 421.678L160.199 420.04L161.056 420.715L158.375 422.263L163.254 425.08C163.711 425.344 164.179 425.476 164.657 425.476C165.14 425.473 165.663 425.309 166.224 424.985C166.53 424.808 166.777 424.624 166.964 424.432C167.151 424.24 167.299 424.046 167.408 423.851L168.804 424.072ZM173.613 451.674C174.023 451.437 174.338 451.178 174.556 450.896C174.779 450.611 174.938 450.321 175.031 450.027L176.528 450.153C176.476 450.537 176.286 450.926 175.959 451.319C175.631 451.712 175.226 452.048 174.743 452.327C173.927 452.798 173.057 453.099 172.132 453.231C171.207 453.357 170.277 453.324 169.341 453.132C168.401 452.937 167.502 452.592 166.645 452.097C165.824 451.623 165.239 451.112 164.891 450.563C164.543 450.008 164.467 449.457 164.665 448.911C164.868 448.362 165.379 447.851 166.2 447.377C166.725 447.074 167.297 446.837 167.915 446.666C168.533 446.489 169.193 446.381 169.895 446.342L170.129 447.215C169.536 447.275 169.004 447.372 168.531 447.507C168.058 447.636 167.64 447.806 167.276 448.016C166.569 448.424 166.252 448.913 166.325 449.483C166.398 450.053 166.977 450.651 168.063 451.278C168.791 451.698 169.49 451.982 170.16 452.129C170.83 452.27 171.456 452.298 172.038 452.214C172.62 452.124 173.145 451.944 173.613 451.674ZM174.947 442.327C175.721 441.88 176.545 441.608 177.418 441.512C178.291 441.41 179.177 441.469 180.076 441.688C180.98 441.904 181.866 442.262 182.734 442.763C183.57 443.246 184.176 443.752 184.55 444.28C184.924 444.808 185.033 445.33 184.877 445.846C184.721 446.356 184.259 446.833 183.49 447.277C182.721 447.721 181.897 447.992 181.019 448.091C180.141 448.19 179.247 448.133 178.338 447.92C177.428 447.701 176.545 447.344 175.688 446.849C174.841 446.36 174.23 445.852 173.856 445.324C173.482 444.796 173.378 444.277 173.544 443.767C173.711 443.251 174.178 442.771 174.947 442.327ZM176.015 442.943C175.308 443.351 175.036 443.812 175.197 444.325C175.358 444.832 175.989 445.403 177.091 446.039C178.171 446.663 179.151 447.025 180.029 447.124C180.912 447.22 181.707 447.064 182.414 446.656C183.121 446.248 183.388 445.79 183.217 445.283C183.051 444.773 182.422 444.203 181.331 443.573C180.239 442.943 179.257 442.58 178.384 442.484C177.506 442.385 176.716 442.538 176.015 442.943ZM189.548 443.572L181.34 438.834L182.455 438.19L183.694 438.789C183.606 438.354 183.699 437.928 183.975 437.511C184.25 437.088 184.624 436.74 185.097 436.467C185.902 436.002 186.7 435.787 187.49 435.823C188.285 435.856 189.062 436.092 189.82 436.53L195.783 439.972L194.473 440.728L189.477 437.844C188.916 437.52 188.433 437.277 188.028 437.115C187.617 436.95 187.235 436.879 186.882 436.903C186.523 436.924 186.136 437.055 185.721 437.295C185.398 437.481 185.165 437.697 185.019 437.943C184.879 438.186 184.803 438.433 184.793 438.685C184.783 438.931 184.811 439.158 184.879 439.365L190.857 442.816L189.548 443.572ZM200.781 436.043C201.409 435.68 201.789 435.326 201.919 434.981C202.049 434.63 201.916 434.34 201.521 434.112C201.272 433.968 201.009 433.871 200.734 433.82C200.464 433.766 200.116 433.778 199.689 433.856C199.263 433.934 198.687 434.099 197.959 434.351C197.253 434.597 196.598 434.789 195.995 434.927C195.392 435.059 194.826 435.107 194.296 435.071C193.771 435.032 193.272 434.876 192.799 434.603C192.337 434.336 192.069 434.031 191.997 433.689C191.924 433.341 192.033 432.981 192.324 432.609C192.61 432.234 193.062 431.868 193.68 431.511C194.34 431.13 195.003 430.85 195.668 430.67C196.333 430.484 196.964 430.365 197.562 430.314L197.873 431.16C197.349 431.217 196.832 431.315 196.322 431.453C195.808 431.588 195.286 431.808 194.756 432.114C194.111 432.486 193.755 432.809 193.688 433.082C193.615 433.352 193.737 433.578 194.054 433.761C194.293 433.899 194.558 433.977 194.849 433.995C195.14 434.007 195.509 433.959 195.956 433.851C196.398 433.74 196.972 433.568 197.679 433.334C198.354 433.106 198.988 432.935 199.58 432.821C200.178 432.704 200.75 432.674 201.295 432.731C201.841 432.788 202.368 432.963 202.877 433.257C203.459 433.593 203.766 433.962 203.797 434.364C203.823 434.763 203.654 435.164 203.29 435.566C202.927 435.962 202.451 436.329 201.864 436.668C201.121 437.097 200.381 437.402 199.643 437.582C198.905 437.756 198.206 437.856 197.546 437.883L197.429 436.952C198.016 436.919 198.601 436.83 199.183 436.686C199.765 436.536 200.297 436.322 200.781 436.043ZM214.344 428.779C214.251 429.049 214.056 429.329 213.76 429.62C213.464 429.911 213.123 430.168 212.739 430.39C211.855 430.9 210.943 431.159 210.003 431.168C209.062 431.177 208.228 430.972 207.501 430.552L202.606 427.726L200.72 428.815L199.707 428.23L201.593 427.141L199.73 426.065L200.884 425.219L202.902 426.385L205.74 424.747L206.597 425.422L203.916 426.97L208.795 429.787C209.252 430.051 209.72 430.183 210.198 430.183C210.681 430.18 211.203 430.016 211.764 429.692C212.071 429.515 212.318 429.331 212.505 429.139C212.692 428.947 212.84 428.753 212.949 428.558L214.344 428.779ZM200.459 467.174C200.87 466.937 201.184 466.678 201.403 466.396C201.626 466.111 201.784 465.821 201.878 465.527L203.375 465.653C203.323 466.037 203.133 466.426 202.806 466.819C202.478 467.212 202.073 467.548 201.59 467.827C200.774 468.298 199.903 468.599 198.979 468.731C198.054 468.857 197.124 468.824 196.188 468.632C195.248 468.437 194.349 468.092 193.491 467.597C192.67 467.123 192.086 466.612 191.738 466.063C191.39 465.508 191.314 464.957 191.512 464.411C191.714 463.862 192.226 463.351 193.047 462.877C193.572 462.574 194.144 462.337 194.762 462.166C195.38 461.989 196.04 461.881 196.742 461.842L196.975 462.715C196.383 462.775 195.85 462.872 195.378 463.007C194.905 463.136 194.486 463.306 194.123 463.516C193.416 463.924 193.099 464.413 193.172 464.983C193.245 465.553 193.824 466.151 194.91 466.778C195.637 467.198 196.336 467.482 197.007 467.629C197.677 467.77 198.303 467.798 198.885 467.714C199.467 467.624 199.992 467.444 200.459 467.174ZM201.794 457.827C202.568 457.38 203.392 457.108 204.265 457.012C205.138 456.91 206.024 456.969 206.923 457.188C207.827 457.404 208.713 457.762 209.58 458.263C210.417 458.746 211.022 459.252 211.396 459.78C211.771 460.308 211.88 460.83 211.724 461.346C211.568 461.856 211.105 462.333 210.336 462.777C209.567 463.221 208.744 463.492 207.866 463.591C206.988 463.69 206.094 463.633 205.184 463.42C204.275 463.201 203.392 462.844 202.534 462.349C201.687 461.86 201.077 461.352 200.703 460.824C200.329 460.296 200.225 459.777 200.391 459.267C200.557 458.751 201.025 458.271 201.794 457.827ZM202.862 458.443C202.155 458.851 201.882 459.312 202.043 459.825C202.204 460.332 202.836 460.903 203.937 461.539C205.018 462.163 205.998 462.525 206.876 462.624C207.759 462.72 208.554 462.564 209.261 462.156C209.968 461.748 210.235 461.29 210.064 460.783C209.897 460.273 209.269 459.703 208.177 459.073C207.086 458.443 206.104 458.08 205.231 457.984C204.353 457.885 203.563 458.038 202.862 458.443ZM216.394 459.072L208.187 454.334L209.302 453.69L210.541 454.289C210.452 453.854 210.546 453.428 210.821 453.011C211.097 452.588 211.471 452.24 211.944 451.967C212.749 451.502 213.547 451.287 214.337 451.323C215.132 451.356 215.908 451.592 216.667 452.03L222.63 455.472L221.32 456.228L216.324 453.344C215.763 453.02 215.28 452.777 214.874 452.615C214.464 452.45 214.082 452.379 213.729 452.403C213.37 452.424 212.983 452.555 212.567 452.795C212.245 452.981 212.011 453.197 211.866 453.443C211.726 453.686 211.65 453.933 211.64 454.185C211.629 454.431 211.658 454.658 211.726 454.865L217.704 458.316L216.394 459.072ZM227.627 451.543C228.256 451.18 228.636 450.826 228.765 450.481C228.895 450.13 228.763 449.84 228.368 449.612C228.119 449.468 227.856 449.371 227.581 449.32C227.311 449.266 226.962 449.278 226.536 449.356C226.11 449.434 225.533 449.599 224.806 449.851C224.099 450.097 223.445 450.289 222.842 450.427C222.239 450.559 221.673 450.607 221.143 450.571C220.618 450.532 220.119 450.376 219.646 450.103C219.184 449.836 218.916 449.531 218.843 449.189C218.771 448.841 218.88 448.481 219.171 448.109C219.457 447.734 219.909 447.368 220.527 447.011C221.187 446.63 221.849 446.35 222.514 446.17C223.18 445.984 223.811 445.865 224.408 445.814L224.72 446.66C224.195 446.717 223.678 446.815 223.169 446.953C222.655 447.088 222.133 447.308 221.603 447.614C220.958 447.986 220.602 448.309 220.535 448.582C220.462 448.852 220.584 449.078 220.901 449.261C221.14 449.399 221.405 449.477 221.696 449.495C221.987 449.507 222.356 449.459 222.803 449.351C223.245 449.24 223.819 449.068 224.525 448.834C225.201 448.606 225.835 448.435 226.427 448.321C227.025 448.204 227.596 448.174 228.142 448.231C228.687 448.288 229.215 448.463 229.724 448.757C230.306 449.093 230.613 449.462 230.644 449.864C230.67 450.263 230.501 450.664 230.137 451.066C229.773 451.462 229.298 451.829 228.711 452.168C227.968 452.597 227.227 452.902 226.49 453.082C225.752 453.256 225.053 453.356 224.393 453.383L224.276 452.452C224.863 452.419 225.448 452.33 226.03 452.186C226.612 452.036 227.144 451.822 227.627 451.543ZM241.191 444.279C241.098 444.549 240.903 444.829 240.607 445.12C240.31 445.411 239.97 445.668 239.586 445.89C238.702 446.4 237.79 446.659 236.85 446.668C235.909 446.677 235.075 446.472 234.348 446.052L229.453 443.226L227.567 444.315L226.554 443.73L228.44 442.641L226.577 441.565L227.731 440.719L229.749 441.885L232.586 440.247L233.444 440.922L230.762 442.47L235.642 445.287C236.099 445.551 236.567 445.683 237.045 445.683C237.528 445.68 238.05 445.516 238.611 445.192C238.918 445.015 239.165 444.831 239.352 444.639C239.539 444.447 239.687 444.253 239.796 444.058L241.191 444.279ZM254.153 498.174C254.564 497.937 254.878 497.678 255.096 497.396C255.32 497.111 255.478 496.821 255.572 496.527L257.068 496.653C257.016 497.037 256.826 497.426 256.499 497.819C256.172 498.212 255.766 498.548 255.283 498.827C254.467 499.298 253.597 499.599 252.672 499.731C251.747 499.857 250.817 499.824 249.882 499.632C248.941 499.437 248.042 499.092 247.185 498.597C246.364 498.123 245.779 497.612 245.431 497.063C245.083 496.508 245.008 495.957 245.205 495.411C245.408 494.862 245.92 494.351 246.741 493.877C247.266 493.574 247.837 493.337 248.455 493.166C249.074 492.989 249.734 492.881 250.435 492.842L250.669 493.715C250.077 493.775 249.544 493.872 249.071 494.007C248.598 494.136 248.18 494.306 247.816 494.516C247.11 494.924 246.793 495.413 246.865 495.983C246.938 496.553 247.518 497.151 248.604 497.778C249.331 498.198 250.03 498.482 250.7 498.629C251.371 498.77 251.997 498.798 252.579 498.714C253.161 498.624 253.685 498.444 254.153 498.174ZM255.488 488.827C256.262 488.38 257.085 488.108 257.958 488.012C258.831 487.91 259.717 487.969 260.616 488.188C261.52 488.404 262.406 488.762 263.274 489.263C264.111 489.746 264.716 490.252 265.09 490.78C265.464 491.308 265.573 491.83 265.417 492.346C265.262 492.856 264.799 493.333 264.03 493.777C263.261 494.221 262.437 494.492 261.559 494.591C260.681 494.69 259.787 494.633 258.878 494.42C257.969 494.201 257.085 493.844 256.228 493.349C255.381 492.86 254.77 492.352 254.396 491.824C254.022 491.296 253.918 490.777 254.085 490.267C254.251 489.751 254.719 489.271 255.488 488.827ZM256.555 489.443C255.849 489.851 255.576 490.312 255.737 490.825C255.898 491.332 256.529 491.903 257.631 492.539C258.712 493.163 259.691 493.525 260.569 493.624C261.453 493.72 262.248 493.564 262.954 493.156C263.661 492.748 263.929 492.29 263.757 491.783C263.591 491.273 262.962 490.703 261.871 490.073C260.78 489.443 259.798 489.08 258.925 488.984C258.047 488.885 257.257 489.038 256.555 489.443ZM270.088 490.072L261.881 485.334L262.995 484.69L264.234 485.289C264.146 484.854 264.24 484.428 264.515 484.011C264.79 483.588 265.165 483.24 265.637 482.967C266.443 482.502 267.24 482.287 268.03 482.323C268.825 482.356 269.602 482.592 270.361 483.03L276.323 486.472L275.014 487.228L270.018 484.344C269.457 484.02 268.973 483.777 268.568 483.615C268.157 483.45 267.776 483.379 267.422 483.403C267.064 483.424 266.677 483.555 266.261 483.795C265.939 483.981 265.705 484.197 265.559 484.443C265.419 484.686 265.344 484.933 265.333 485.185C265.323 485.431 265.352 485.658 265.419 485.865L271.397 489.316L270.088 490.072ZM281.321 482.543C281.95 482.18 282.329 481.826 282.459 481.481C282.589 481.13 282.456 480.84 282.062 480.612C281.812 480.468 281.55 480.371 281.274 480.32C281.004 480.266 280.656 480.278 280.23 480.356C279.804 480.434 279.227 480.599 278.5 480.851C277.793 481.097 277.138 481.289 276.535 481.427C275.933 481.559 275.366 481.607 274.836 481.571C274.311 481.532 273.813 481.376 273.34 481.103C272.877 480.836 272.61 480.531 272.537 480.189C272.464 479.841 272.573 479.481 272.864 479.109C273.15 478.734 273.602 478.368 274.221 478.011C274.88 477.63 275.543 477.35 276.208 477.17C276.873 476.984 277.504 476.865 278.102 476.814L278.414 477.66C277.889 477.717 277.372 477.815 276.863 477.953C276.348 478.088 275.826 478.308 275.296 478.614C274.652 478.986 274.296 479.309 274.228 479.582C274.156 479.852 274.278 480.078 274.595 480.261C274.834 480.399 275.099 480.477 275.39 480.495C275.681 480.507 276.05 480.459 276.496 480.351C276.938 480.24 277.512 480.068 278.219 479.834C278.894 479.606 279.528 479.435 280.121 479.321C280.718 479.204 281.29 479.174 281.835 479.231C282.381 479.288 282.908 479.463 283.418 479.757C284 480.093 284.306 480.462 284.337 480.864C284.363 481.263 284.195 481.664 283.831 482.066C283.467 482.462 282.992 482.829 282.404 483.168C281.661 483.597 280.921 483.902 280.183 484.082C279.445 484.256 278.746 484.356 278.086 484.383L277.97 483.452C278.557 483.419 279.141 483.33 279.723 483.186C280.305 483.036 280.838 482.822 281.321 482.543ZM294.885 475.279C294.791 475.549 294.596 475.829 294.3 476.12C294.004 476.411 293.664 476.668 293.279 476.89C292.396 477.4 291.484 477.659 290.543 477.668C289.603 477.677 288.769 477.472 288.041 477.052L283.147 474.226L281.26 475.315L280.247 474.73L282.133 473.641L280.271 472.565L281.424 471.719L283.443 472.885L286.28 471.247L287.137 471.922L284.456 473.47L289.335 476.287C289.792 476.551 290.26 476.683 290.738 476.683C291.221 476.68 291.744 476.516 292.305 476.192C292.611 476.015 292.858 475.831 293.045 475.639C293.232 475.447 293.38 475.253 293.49 475.058L294.885 475.279ZM278.319 516.32L277.313 515.74L278.591 515.002L272.395 511.424L271.117 512.162L270.111 511.582L272.387 510.268L274.57 511.249C274.211 510.676 274.073 510.152 274.157 509.678C274.24 509.204 274.653 508.753 275.396 508.324C275.624 508.192 275.845 508.085 276.058 508.004C276.271 507.917 276.497 507.835 276.736 507.757L277.524 508.652C277.305 508.724 277.116 508.795 276.955 508.864C276.788 508.93 276.614 509.015 276.432 509.12C275.804 509.483 275.487 509.924 275.482 510.443C275.476 510.962 275.791 511.561 276.425 512.239L279.901 514.246L281.569 513.283L282.574 513.863L278.319 516.32ZM278.248 510.088L276.464 509.057L275.606 508.409L276.736 507.757L279.324 509.467L278.248 510.088ZM284.977 508.273C285.637 508.624 286.278 508.854 286.902 508.962C287.52 509.067 288.105 509.071 288.655 508.975C289.201 508.876 289.684 508.705 290.105 508.462C290.526 508.219 290.843 507.964 291.056 507.697C291.274 507.427 291.441 507.118 291.555 506.77L293.036 506.914C292.953 507.31 292.75 507.7 292.428 508.084C292.111 508.465 291.695 508.804 291.181 509.101C290.386 509.56 289.528 509.848 288.609 509.965C287.689 510.082 286.761 510.042 285.826 509.844C284.891 509.64 284 509.293 283.153 508.804C282.321 508.324 281.732 507.813 281.383 507.27C281.035 506.727 280.944 506.194 281.111 505.672C281.277 505.15 281.724 504.679 282.451 504.259C283.142 503.86 283.901 503.611 284.727 503.512C285.548 503.41 286.393 503.457 287.26 503.652C288.128 503.841 288.978 504.175 289.809 504.655C289.949 504.736 290.079 504.814 290.199 504.889C290.313 504.961 290.412 505.027 290.495 505.087L284.977 508.273ZM283.542 504.871C282.935 505.222 282.641 505.641 282.662 506.127C282.688 506.61 283.124 507.129 283.971 507.684L288.25 505.213C287.356 504.715 286.504 504.445 285.694 504.403C284.878 504.358 284.161 504.514 283.542 504.871ZM303.038 501.572C302.944 501.842 302.749 502.122 302.453 502.413C302.157 502.704 301.816 502.961 301.432 503.183C300.549 503.693 299.637 503.952 298.696 503.961C297.756 503.97 296.922 503.765 296.194 503.345L291.299 500.519L289.413 501.608L288.4 501.023L290.286 499.934L288.423 498.858L289.577 498.012L291.596 499.178L294.433 497.54L295.29 498.215L292.609 499.763L297.488 502.58C297.945 502.844 298.413 502.976 298.891 502.976C299.374 502.973 299.896 502.809 300.458 502.485C300.764 502.308 301.011 502.124 301.198 501.932C301.385 501.74 301.533 501.546 301.642 501.351L303.038 501.572ZM299.384 494.681L305.198 498.038C305.739 498.35 306.24 498.511 306.703 498.52C307.165 498.529 307.633 498.397 308.105 498.124C308.558 497.863 308.856 497.543 309.002 497.165C309.147 496.781 309.155 496.423 309.025 496.09L302.985 492.602L304.294 491.846L312.501 496.585L311.387 497.228L310.171 496.652C310.264 497.078 310.187 497.492 309.937 497.894C309.683 498.293 309.314 498.632 308.83 498.911C308.035 499.37 307.23 499.592 306.414 499.577C305.598 499.556 304.809 499.325 304.045 498.884L298.074 495.437L299.384 494.681ZM315.707 494.734L314.701 494.154L315.979 493.416L309.783 489.838L308.505 490.576L307.499 489.996L309.775 488.682L311.958 489.663C311.599 489.09 311.461 488.566 311.544 488.092C311.628 487.618 312.041 487.167 312.784 486.738C313.012 486.606 313.233 486.499 313.446 486.418C313.659 486.331 313.885 486.249 314.124 486.171L314.912 487.066C314.693 487.138 314.504 487.209 314.343 487.278C314.176 487.344 314.002 487.429 313.82 487.534C313.192 487.897 312.875 488.338 312.869 488.857C312.864 489.376 313.179 489.975 313.813 490.653L317.289 492.66L318.957 491.697L319.962 492.277L315.707 494.734ZM315.636 488.502L313.852 487.471L312.994 486.823L314.124 486.171L316.712 487.881L315.636 488.502ZM324.976 489.383L316.768 484.644L317.883 484.001L319.122 484.599C319.034 484.164 319.127 483.738 319.403 483.321C319.678 482.898 320.052 482.55 320.525 482.277C321.331 481.812 322.128 481.598 322.918 481.634C323.713 481.667 324.49 481.902 325.248 482.34L331.211 485.783L329.902 486.539L324.905 483.654C324.344 483.33 323.861 483.087 323.456 482.925C323.045 482.76 322.663 482.69 322.31 482.714C321.951 482.735 321.564 482.865 321.149 483.105C320.826 483.291 320.593 483.507 320.447 483.753C320.307 483.996 320.232 484.244 320.221 484.496C320.211 484.742 320.239 484.968 320.307 485.175L326.285 488.627L324.976 489.383Z"
            fill="#98FF87"
          />
          <path
            d="M129.495 370.204L130.524 370.798C130.145 371.017 129.838 371.239 129.605 371.464C129.371 371.683 129.259 371.895 129.269 372.099C129.285 372.3 129.464 372.484 129.807 372.652L133.33 374.308C133.813 374.533 134.149 374.757 134.336 374.979C134.523 375.201 134.58 375.426 134.507 375.654C134.44 375.879 134.26 376.114 133.969 376.36C134.395 376.186 134.803 376.077 135.193 376.032C135.578 375.984 135.96 376.015 136.339 376.126C136.713 376.234 137.108 376.435 137.524 376.729L140.392 378.763C140.688 378.964 141.01 379.069 141.358 379.078C141.706 379.087 142.073 379.023 142.457 378.885C142.842 378.747 143.224 378.568 143.603 378.349L144.632 378.943C144.195 379.195 143.738 379.414 143.26 379.6C142.787 379.789 142.307 379.92 141.818 379.992C141.33 380.064 140.849 380.053 140.376 379.96C139.909 379.87 139.462 379.672 139.036 379.366L136.386 377.476C136.069 377.245 135.733 377.091 135.38 377.013C135.032 376.932 134.619 376.957 134.141 377.089C133.663 377.215 133.076 377.479 132.379 377.881L131.335 377.278C132.031 376.876 132.491 376.539 132.715 376.266C132.943 375.99 132.987 375.751 132.847 375.55C132.712 375.346 132.447 375.154 132.052 374.974L128.763 373.435C128.233 373.189 127.89 372.931 127.734 372.661C127.573 372.388 127.552 372.112 127.672 371.833C127.796 371.551 128.022 371.274 128.35 371.001C128.677 370.722 129.059 370.456 129.495 370.204ZM148.844 364.595L154.659 367.952C155.199 368.264 155.7 368.425 156.163 368.434C156.625 368.443 157.093 368.311 157.566 368.038C158.018 367.777 158.317 367.457 158.462 367.079C158.608 366.695 158.616 366.337 158.486 366.004L152.445 362.516L153.755 361.76L161.962 366.499L160.847 367.142L159.631 366.566C159.725 366.992 159.647 367.406 159.398 367.808C159.143 368.207 158.774 368.546 158.291 368.825C157.496 369.284 156.69 369.506 155.875 369.491C155.059 369.47 154.269 369.239 153.505 368.798L147.535 365.351L148.844 364.595ZM166.975 362.56C167.604 362.197 167.983 361.843 168.113 361.498C168.243 361.147 168.111 360.858 167.716 360.63C167.466 360.486 167.204 360.388 166.928 360.337C166.658 360.283 166.31 360.295 165.884 360.373C165.458 360.451 164.881 360.616 164.154 360.868C163.447 361.114 162.792 361.306 162.19 361.444C161.587 361.576 161.02 361.624 160.49 361.588C159.966 361.549 159.467 361.393 158.994 361.12C158.532 360.853 158.264 360.549 158.191 360.207C158.118 359.859 158.228 359.499 158.519 359.127C158.804 358.752 159.256 358.386 159.875 358.029C160.535 357.648 161.197 357.367 161.862 357.187C162.527 357.001 163.159 356.883 163.756 356.832L164.068 357.678C163.543 357.735 163.026 357.832 162.517 357.97C162.003 358.105 161.48 358.326 160.95 358.632C160.306 359.004 159.95 359.326 159.883 359.599C159.81 359.869 159.932 360.096 160.249 360.279C160.488 360.417 160.753 360.495 161.044 360.513C161.335 360.525 161.704 360.477 162.151 360.369C162.592 360.258 163.166 360.085 163.873 359.851C164.549 359.623 165.183 359.452 165.775 359.338C166.373 359.221 166.944 359.191 167.49 359.248C168.035 359.305 168.563 359.481 169.072 359.775C169.654 360.111 169.96 360.48 169.992 360.882C170.018 361.281 169.849 361.681 169.485 362.083C169.121 362.479 168.646 362.847 168.059 363.186C167.316 363.615 166.575 363.919 165.837 364.099C165.099 364.273 164.401 364.374 163.741 364.401L163.624 363.469C164.211 363.436 164.795 363.348 165.377 363.204C165.959 363.054 166.492 362.839 166.975 362.56ZM171.825 356.601C172.485 356.952 173.127 357.182 173.75 357.29C174.368 357.395 174.953 357.399 175.504 357.303C176.049 357.204 176.533 357.033 176.954 356.79C177.374 356.547 177.691 356.292 177.904 356.025C178.123 355.755 178.289 355.446 178.403 355.098L179.884 355.242C179.801 355.638 179.598 356.028 179.276 356.412C178.959 356.793 178.544 357.132 178.029 357.429C177.234 357.888 176.377 358.176 175.457 358.293C174.537 358.41 173.61 358.37 172.675 358.172C171.739 357.968 170.848 357.621 170.001 357.132C169.17 356.652 168.58 356.141 168.232 355.598C167.884 355.055 167.793 354.522 167.959 354C168.125 353.478 168.572 353.007 169.3 352.587C169.991 352.188 170.749 351.939 171.576 351.84C172.397 351.738 173.241 351.785 174.109 351.98C174.976 352.169 175.826 352.503 176.657 352.983C176.798 353.064 176.928 353.142 177.047 353.217C177.161 353.289 177.26 353.355 177.343 353.415L171.825 356.601ZM170.391 353.199C169.783 353.55 169.489 353.969 169.51 354.455C169.536 354.938 169.973 355.457 170.82 356.012L175.099 353.541C174.205 353.043 173.353 352.773 172.542 352.731C171.726 352.686 171.009 352.842 170.391 353.199ZM187.61 348.262C188.223 348.616 188.615 349.019 188.787 349.472C188.953 349.922 188.88 350.393 188.569 350.885C188.252 351.374 187.675 351.86 186.838 352.343C186.054 352.796 185.222 353.138 184.344 353.369C183.471 353.597 182.591 353.716 181.702 353.725L181.601 352.739C182.323 352.724 183.03 352.637 183.721 352.478C184.407 352.316 185.074 352.048 185.724 351.673C186.16 351.421 186.498 351.145 186.737 350.845C186.971 350.542 187.059 350.239 187.002 349.936C186.94 349.63 186.682 349.346 186.23 349.085C185.882 348.884 185.519 348.752 185.139 348.689C184.76 348.626 184.305 348.64 183.775 348.73C183.24 348.817 182.575 348.985 181.78 349.234C180.865 349.522 180.018 349.741 179.239 349.891C178.46 350.035 177.735 350.078 177.064 350.021C176.399 349.961 175.784 349.768 175.217 349.441C174.682 349.132 174.355 348.772 174.235 348.361C174.116 347.95 174.199 347.527 174.485 347.092C174.77 346.651 175.254 346.234 175.934 345.841C176.677 345.412 177.428 345.101 178.187 344.909C178.945 344.711 179.746 344.597 180.587 344.567L180.673 345.535C179.946 345.559 179.286 345.655 178.693 345.823C178.096 345.988 177.568 346.202 177.111 346.466C176.721 346.691 176.423 346.933 176.215 347.191C176.007 347.443 175.921 347.693 175.958 347.942C175.994 348.185 176.191 348.41 176.55 348.617C176.857 348.794 177.205 348.899 177.594 348.932C177.984 348.965 178.47 348.922 179.052 348.802C179.629 348.679 180.359 348.479 181.242 348.203C181.959 347.975 182.676 347.795 183.393 347.663C184.11 347.525 184.822 347.492 185.529 347.564C186.23 347.633 186.924 347.866 187.61 348.262ZM197.214 344.076C197.542 344.265 197.835 344.371 198.095 344.395C198.355 344.419 198.635 344.386 198.937 344.296L199.537 345.012C199.137 345.189 198.716 345.303 198.274 345.354C197.827 345.402 197.362 345.355 196.879 345.214C196.962 345.604 196.882 345.984 196.637 346.353C196.388 346.719 195.996 347.056 195.46 347.365C194.639 347.839 193.761 348.079 192.826 348.085C191.891 348.091 191.041 347.874 190.277 347.433C189.43 346.944 189.111 346.378 189.319 345.736C189.526 345.094 190.254 344.413 191.501 343.693L192.709 342.996L192.023 342.6C191.431 342.258 190.839 342.117 190.246 342.177C189.654 342.231 189.051 342.435 188.438 342.789C188.168 342.945 187.884 343.147 187.588 343.396C187.287 343.642 186.999 343.932 186.723 344.265L185.39 343.891C185.707 343.492 186.048 343.143 186.411 342.843C186.775 342.543 187.157 342.277 187.557 342.046C188.581 341.455 189.586 341.151 190.574 341.133C191.561 341.109 192.462 341.332 193.278 341.803L197.214 344.076ZM194.798 346.596C195.203 346.362 195.489 346.08 195.655 345.75C195.816 345.417 195.835 345.076 195.71 344.728L193.598 343.509L192.413 344.193C191.509 344.715 191.026 345.174 190.963 345.57C190.906 345.963 191.14 346.311 191.665 346.614C192.174 346.908 192.691 347.056 193.216 347.059C193.741 347.056 194.268 346.902 194.798 346.596ZM202.477 343.107L194.27 338.369L195.384 337.725L196.624 338.324C196.535 337.889 196.629 337.463 196.904 337.046C197.18 336.623 197.554 336.275 198.026 336.002C198.832 335.537 199.63 335.322 200.419 335.358C201.214 335.391 201.991 335.627 202.75 336.065L208.712 339.507L207.403 340.263L202.407 337.379C201.846 337.055 201.362 336.812 200.957 336.65C200.547 336.485 200.165 336.414 199.811 336.438C199.453 336.459 199.066 336.59 198.65 336.83C198.328 337.016 198.094 337.232 197.949 337.478C197.808 337.721 197.733 337.968 197.723 338.22C197.712 338.466 197.741 338.693 197.808 338.9L203.786 342.351L202.477 343.107ZM205.059 328.135L206.532 327.473L218.044 334.12L216.898 334.781L215.69 334.228C215.82 334.657 215.786 335.045 215.589 335.393C215.396 335.738 215.074 336.041 214.622 336.302C213.91 336.713 213.144 336.949 212.323 337.009C211.502 337.069 210.66 336.979 209.797 336.739C208.93 336.496 208.072 336.13 207.225 335.641C206.404 335.167 205.799 334.67 205.409 334.151C205.014 333.629 204.872 333.124 204.981 332.635C205.09 332.14 205.482 331.697 206.158 331.307C206.63 331.034 207.129 330.842 207.654 330.731C208.174 330.617 208.73 330.572 209.322 330.596L205.059 328.135ZM207.553 331.717C206.867 332.113 206.607 332.572 206.773 333.094C206.94 333.616 207.566 334.19 208.652 334.817C209.358 335.225 210.026 335.524 210.655 335.713C211.284 335.902 211.863 335.981 212.393 335.951C212.928 335.918 213.409 335.779 213.835 335.533C214.303 335.263 214.568 334.957 214.63 334.615C214.697 334.27 214.674 333.938 214.56 333.62L210.46 331.253C209.904 331.19 209.377 331.198 208.878 331.276C208.374 331.351 207.932 331.498 207.553 331.717ZM216.463 325.357C217.191 324.937 217.947 324.705 218.731 324.66C219.521 324.612 220.334 324.718 221.171 324.979C222.002 325.237 222.847 325.614 223.704 326.109C224.53 326.586 225.151 327.079 225.567 327.589C225.983 328.093 226.141 328.587 226.042 329.07C225.944 329.553 225.538 330 224.826 330.411C223.928 330.93 222.888 331.164 221.709 331.113L225.621 333.372L224.476 334.222L212.964 327.576L214.078 326.932L215.333 327.531C215.214 327.114 215.247 326.719 215.434 326.347C215.627 325.972 215.97 325.642 216.463 325.357ZM217.204 326.145C216.752 326.406 216.489 326.716 216.416 327.076C216.344 327.43 216.362 327.768 216.471 328.089L220.54 330.438C221.07 330.498 221.589 330.489 222.098 330.411C222.608 330.327 223.057 330.172 223.447 329.947C224.128 329.554 224.38 329.109 224.203 328.611C224.026 328.113 223.39 327.547 222.293 326.914C221.576 326.5 220.914 326.196 220.306 326.001C219.693 325.803 219.131 325.716 218.622 325.74C218.108 325.761 217.635 325.896 217.204 326.145ZM234.602 322.49C234.929 322.679 235.223 322.785 235.483 322.809C235.743 322.833 236.023 322.8 236.325 322.71L236.925 323.426C236.525 323.603 236.104 323.717 235.662 323.768C235.215 323.816 234.75 323.769 234.267 323.628C234.35 324.018 234.27 324.398 234.025 324.767C233.776 325.133 233.384 325.47 232.848 325.779C232.027 326.253 231.149 326.493 230.214 326.499C229.279 326.505 228.429 326.288 227.665 325.847C226.818 325.358 226.499 324.792 226.707 324.15C226.914 323.508 227.642 322.827 228.889 322.107L230.097 321.41L229.411 321.014C228.819 320.672 228.226 320.531 227.634 320.591C227.042 320.645 226.439 320.849 225.826 321.203C225.556 321.359 225.272 321.561 224.976 321.81C224.675 322.056 224.386 322.346 224.111 322.679L222.778 322.305C223.095 321.906 223.436 321.557 223.799 321.257C224.163 320.957 224.545 320.691 224.945 320.46C225.969 319.869 226.974 319.565 227.961 319.547C228.949 319.523 229.85 319.746 230.666 320.217L234.602 322.49ZM232.186 325.01C232.591 324.776 232.877 324.494 233.043 324.164C233.204 323.831 233.223 323.49 233.098 323.142L230.986 321.923L229.801 322.607C228.897 323.129 228.414 323.588 228.351 323.984C228.294 324.377 228.528 324.725 229.053 325.028C229.562 325.322 230.079 325.47 230.604 325.473C231.129 325.47 231.656 325.316 232.186 325.01ZM242.624 318.83C243.035 318.593 243.349 318.334 243.567 318.052C243.791 317.767 243.949 317.477 244.043 317.183L245.539 317.309C245.487 317.693 245.298 318.082 244.97 318.475C244.643 318.868 244.238 319.204 243.754 319.483C242.938 319.954 242.068 320.255 241.143 320.387C240.218 320.513 239.288 320.48 238.353 320.288C237.412 320.093 236.513 319.748 235.656 319.253C234.835 318.779 234.25 318.268 233.902 317.719C233.554 317.164 233.479 316.613 233.676 316.067C233.879 315.518 234.391 315.007 235.212 314.533C235.737 314.23 236.308 313.993 236.927 313.822C237.545 313.645 238.205 313.537 238.906 313.498L239.14 314.371C238.548 314.431 238.015 314.528 237.542 314.663C237.069 314.792 236.651 314.962 236.287 315.172C235.581 315.58 235.264 316.069 235.336 316.639C235.409 317.209 235.989 317.807 237.075 318.434C237.802 318.854 238.501 319.138 239.171 319.285C239.842 319.426 240.468 319.454 241.05 319.37C241.632 319.28 242.156 319.1 242.624 318.83ZM247.879 307.417L247.879 311.683L256.515 311.908L254.793 312.903L246.274 312.646L246.18 308.398L247.879 307.417ZM238.931 308.578L250.607 315.319L249.298 316.075L237.786 309.429L238.931 308.578ZM255.63 297.38C256.066 297.128 256.524 296.909 257.002 296.723C257.475 296.534 257.955 296.404 258.444 296.332C258.932 296.26 259.413 296.27 259.886 296.363C260.358 296.45 260.805 296.648 261.226 296.957L263.892 298.856C264.204 299.084 264.547 299.231 264.921 299.297C265.3 299.36 265.729 299.326 266.207 299.194C266.685 299.062 267.243 298.811 267.883 298.442L268.927 299.045C268.293 299.411 267.862 299.735 267.633 300.017C267.404 300.293 267.345 300.541 267.454 300.76C267.568 300.976 267.825 301.175 268.225 301.358L271.499 302.888C272.029 303.134 272.372 303.392 272.528 303.662C272.689 303.935 272.707 304.213 272.582 304.495C272.463 304.774 272.237 305.051 271.904 305.327C271.582 305.603 271.203 305.867 270.766 306.119L269.738 305.525C270.117 305.306 270.423 305.087 270.657 304.868C270.896 304.646 271.011 304.433 271 304.229C270.99 304.025 270.808 303.839 270.455 303.671L266.932 302.015C266.422 301.775 266.077 301.546 265.895 301.327C265.708 301.105 265.666 300.877 265.77 300.643C265.879 300.406 266.116 300.149 266.48 299.873C266.007 300.068 265.557 300.193 265.131 300.247C264.71 300.298 264.305 300.271 263.915 300.166C263.526 300.061 263.133 299.87 262.738 299.594L259.87 297.56C259.584 297.359 259.265 297.256 258.911 297.25C258.558 297.244 258.192 297.308 257.812 297.443C257.428 297.575 257.043 297.752 256.659 297.974L255.63 297.38Z"
            fill="#DFDFDF"
          />
          <path
            d="M327.107 262.539L322.805 260.343L324.449 259.393L328.261 261.873L327.107 262.539ZM329.71 261.036L325.424 258.831L327.06 257.886L330.864 260.37L329.71 261.036ZM588.823 111.437L584.52 109.241L586.165 108.292L589.976 110.771L588.823 111.437ZM591.426 109.934L587.139 107.729L588.776 106.784L592.58 109.268L591.426 109.934ZM604.912 107.782C605.276 107.572 605.702 107.47 606.19 107.476C606.678 107.476 607.092 107.574 607.429 107.769C607.622 107.88 607.79 108.004 607.936 108.142C608.087 108.277 608.227 108.451 608.357 108.664L609.994 111.067L608.809 111.751L606.463 109.533C605.881 109.593 605.364 109.492 604.912 109.231C604.564 109.03 604.387 108.79 604.382 108.511C604.382 108.229 604.558 107.986 604.912 107.782ZM599.526 104.673C599.89 104.463 600.313 104.359 600.796 104.362C601.285 104.362 601.703 104.463 602.051 104.664C602.394 104.862 602.571 105.105 602.581 105.393C602.592 105.675 602.415 105.921 602.051 106.131C601.698 106.335 601.274 106.435 600.781 106.432C600.287 106.423 599.869 106.32 599.526 106.122C599.178 105.921 599.001 105.681 598.996 105.402C598.996 105.12 599.173 104.877 599.526 104.673ZM355.277 310.588C356.358 311.212 357.416 311.681 358.45 311.996C359.489 312.308 360.58 312.509 361.723 312.599C362.866 312.689 364.137 312.709 365.535 312.658L365.566 313.468C364.033 313.555 362.604 313.564 361.279 313.495C359.959 313.423 358.694 313.223 357.483 312.896C356.278 312.566 355.085 312.061 353.906 311.38C352.721 310.696 351.843 310.006 351.271 309.31C350.705 308.611 350.359 307.88 350.234 307.118C350.115 306.353 350.133 305.53 350.289 304.648L351.692 304.666C351.63 305.278 351.63 305.845 351.692 306.367C351.754 306.883 351.913 307.373 352.167 307.838C352.417 308.3 352.794 308.758 353.298 309.211C353.802 309.658 354.462 310.117 355.277 310.588ZM367.352 303.616C366.537 303.145 365.739 302.766 364.959 302.478C364.18 302.184 363.39 301.965 362.59 301.821C361.785 301.674 360.932 301.584 360.034 301.551C359.135 301.512 358.155 301.51 357.095 301.546L357.064 300.736C358.597 300.643 360.023 300.633 361.343 300.705C362.663 300.777 363.925 300.978 365.131 301.308C366.342 301.635 367.539 302.14 368.724 302.824C369.904 303.505 370.777 304.195 371.343 304.894C371.915 305.59 372.263 306.319 372.387 307.081C372.512 307.843 372.497 308.668 372.341 309.556L370.938 309.538C371.026 308.731 370.992 307.998 370.836 307.338C370.68 306.678 370.33 306.049 369.784 305.452C369.244 304.852 368.433 304.24 367.352 303.616ZM407.517 271.688L408.546 272.282C408.166 272.501 407.86 272.723 407.626 272.948C407.392 273.167 407.28 273.379 407.291 273.583C407.306 273.784 407.486 273.968 407.828 274.136L411.351 275.792C411.835 276.017 412.17 276.241 412.357 276.463C412.544 276.685 412.601 276.91 412.528 277.138C412.461 277.363 412.282 277.598 411.991 277.844C412.417 277.67 412.825 277.561 413.214 277.516C413.599 277.468 413.981 277.499 414.36 277.61C414.734 277.718 415.129 277.919 415.545 278.213L418.413 280.247C418.709 280.448 419.031 280.553 419.38 280.562C419.728 280.571 420.094 280.507 420.479 280.369C420.863 280.231 421.245 280.052 421.624 279.833L422.653 280.427C422.217 280.679 421.759 280.898 421.281 281.084C420.808 281.273 420.328 281.404 419.839 281.476C419.351 281.548 418.87 281.537 418.397 281.444C417.93 281.354 417.483 281.156 417.057 280.85L414.407 278.96C414.09 278.729 413.755 278.575 413.401 278.497C413.053 278.416 412.64 278.441 412.162 278.573C411.684 278.699 411.097 278.963 410.401 279.365L409.356 278.762C410.052 278.36 410.512 278.023 410.736 277.75C410.964 277.474 411.009 277.235 410.868 277.034C410.733 276.83 410.468 276.638 410.073 276.458L406.784 274.919C406.254 274.673 405.911 274.415 405.755 274.145C405.594 273.872 405.573 273.596 405.693 273.317C405.818 273.035 406.044 272.758 406.371 272.485C406.698 272.206 407.08 271.94 407.517 271.688ZM219.383 411.308L220.412 411.902C220.032 412.121 219.726 412.343 219.492 412.568C219.258 412.787 219.146 412.998 219.157 413.202C219.172 413.403 219.352 413.588 219.695 413.756L223.218 415.412C223.701 415.637 224.036 415.86 224.223 416.082C224.41 416.304 224.467 416.529 224.395 416.757C224.327 416.982 224.148 417.218 223.857 417.464C224.283 417.29 224.691 417.18 225.08 417.135C225.465 417.087 225.847 417.119 226.226 417.23C226.6 417.338 226.995 417.539 227.411 417.833L230.279 419.867C230.575 420.068 230.898 420.173 231.246 420.182C231.594 420.191 231.96 420.126 232.345 419.988C232.729 419.85 233.111 419.672 233.49 419.453L234.519 420.047C234.083 420.299 233.625 420.518 233.147 420.704C232.675 420.893 232.194 421.023 231.706 421.095C231.217 421.167 230.736 421.157 230.264 421.064C229.796 420.974 229.349 420.776 228.923 420.47L226.273 418.58C225.956 418.349 225.621 418.194 225.267 418.116C224.919 418.035 224.506 418.061 224.028 418.193C223.55 418.319 222.963 418.583 222.267 418.985L221.222 418.382C221.919 417.98 222.378 417.642 222.602 417.369C222.83 417.093 222.875 416.855 222.734 416.654C222.599 416.45 222.334 416.258 221.939 416.078L218.65 414.539C218.12 414.293 217.777 414.035 217.621 413.765C217.46 413.492 217.439 413.216 217.559 412.937C217.684 412.655 217.91 412.377 218.237 412.104C218.564 411.825 218.946 411.56 219.383 411.308ZM247.516 409.06C248.144 408.697 248.524 408.343 248.654 407.998C248.783 407.647 248.651 407.358 248.256 407.13C248.007 406.986 247.744 406.888 247.469 406.837C247.199 406.783 246.851 406.795 246.424 406.873C245.998 406.951 245.422 407.116 244.694 407.368C243.987 407.614 243.333 407.806 242.73 407.944C242.127 408.076 241.561 408.124 241.031 408.088C240.506 408.049 240.007 407.893 239.534 407.62C239.072 407.353 238.804 407.049 238.732 406.707C238.659 406.359 238.768 405.999 239.059 405.627C239.345 405.252 239.797 404.886 240.415 404.529C241.075 404.148 241.737 403.867 242.403 403.687C243.068 403.501 243.699 403.383 244.297 403.332L244.608 404.178C244.084 404.235 243.567 404.332 243.057 404.47C242.543 404.605 242.021 404.826 241.491 405.132C240.846 405.504 240.49 405.826 240.423 406.099C240.35 406.369 240.472 406.596 240.789 406.779C241.028 406.917 241.293 406.995 241.584 407.013C241.875 407.025 242.244 406.977 242.691 406.869C243.133 406.758 243.707 406.585 244.414 406.351C245.089 406.123 245.723 405.952 246.315 405.838C246.913 405.721 247.484 405.691 248.03 405.748C248.576 405.805 249.103 405.981 249.612 406.275C250.194 406.611 250.501 406.98 250.532 407.382C250.558 407.781 250.389 408.181 250.025 408.583C249.662 408.979 249.186 409.347 248.599 409.686C247.856 410.115 247.116 410.419 246.378 410.599C245.64 410.773 244.941 410.874 244.281 410.901L244.164 409.969C244.751 409.936 245.336 409.848 245.918 409.704C246.5 409.554 247.032 409.339 247.516 409.06ZM259.061 401.369C259.388 401.558 259.682 401.664 259.941 401.688C260.201 401.712 260.482 401.679 260.783 401.589L261.383 402.305C260.983 402.482 260.562 402.596 260.121 402.647C259.674 402.695 259.209 402.648 258.725 402.507C258.809 402.897 258.728 403.277 258.484 403.646C258.234 404.012 257.842 404.349 257.307 404.658C256.486 405.132 255.608 405.372 254.672 405.378C253.737 405.384 252.888 405.167 252.124 404.726C251.277 404.237 250.957 403.671 251.165 403.029C251.373 402.387 252.1 401.706 253.347 400.986L254.556 400.289L253.87 399.893C253.277 399.551 252.685 399.41 252.093 399.47C251.5 399.524 250.897 399.728 250.284 400.082C250.014 400.238 249.731 400.44 249.435 400.689C249.133 400.935 248.845 401.225 248.57 401.558L247.237 401.184C247.554 400.785 247.894 400.436 248.258 400.136C248.622 399.836 249.003 399.57 249.404 399.339C250.427 398.748 251.433 398.444 252.42 398.426C253.407 398.402 254.309 398.625 255.124 399.096L259.061 401.369ZM256.644 403.889C257.05 403.655 257.335 403.373 257.502 403.043C257.663 402.71 257.681 402.369 257.556 402.021L255.444 400.802L254.259 401.486C253.355 402.008 252.872 402.467 252.81 402.863C252.752 403.256 252.986 403.604 253.511 403.907C254.02 404.201 254.537 404.349 255.062 404.352C255.587 404.349 256.114 404.195 256.644 403.889ZM264.323 400.4L256.116 395.662L257.231 395.018L258.47 395.617C258.382 395.182 258.475 394.756 258.751 394.339C259.026 393.916 259.4 393.568 259.873 393.295C260.678 392.83 261.476 392.615 262.266 392.651C263.061 392.684 263.838 392.92 264.596 393.358L270.559 396.8L269.249 397.556L264.253 394.672C263.692 394.348 263.209 394.105 262.804 393.943C262.393 393.778 262.011 393.707 261.658 393.731C261.299 393.752 260.912 393.883 260.496 394.123C260.174 394.309 259.94 394.525 259.795 394.771C259.655 395.014 259.579 395.261 259.569 395.513C259.559 395.759 259.587 395.986 259.655 396.193L265.633 399.644L264.323 400.4ZM266.905 385.428L268.378 384.766L279.89 391.413L278.744 392.074L277.536 391.521C277.666 391.95 277.632 392.338 277.435 392.686C277.243 393.031 276.921 393.334 276.469 393.595C275.757 394.006 274.99 394.242 274.169 394.302C273.348 394.362 272.506 394.272 271.644 394.032C270.776 393.789 269.919 393.423 269.072 392.934C268.251 392.46 267.645 391.963 267.256 391.444C266.861 390.922 266.718 390.417 266.827 389.928C266.936 389.433 267.328 388.99 268.004 388.6C268.477 388.327 268.976 388.135 269.5 388.024C270.02 387.91 270.576 387.865 271.168 387.889L266.905 385.428ZM269.399 389.01C268.713 389.406 268.453 389.865 268.62 390.387C268.786 390.909 269.412 391.483 270.498 392.11C271.205 392.518 271.873 392.817 272.501 393.006C273.13 393.195 273.709 393.274 274.239 393.244C274.775 393.211 275.255 393.072 275.681 392.826C276.149 392.556 276.414 392.25 276.476 391.908C276.544 391.563 276.52 391.231 276.406 390.913L272.306 388.546C271.75 388.483 271.223 388.491 270.724 388.569C270.22 388.644 269.778 388.791 269.399 389.01ZM278.31 382.65C279.037 382.23 279.793 381.998 280.578 381.953C281.368 381.905 282.181 382.011 283.017 382.272C283.849 382.53 284.693 382.907 285.55 383.402C286.377 383.879 286.998 384.372 287.413 384.882C287.829 385.386 287.987 385.88 287.889 386.363C287.79 386.846 287.385 387.293 286.673 387.704C285.774 388.223 284.735 388.457 283.555 388.406L287.468 390.665L286.322 391.515L274.81 384.869L275.925 384.225L277.179 384.824C277.06 384.407 277.094 384.012 277.281 383.64C277.473 383.265 277.816 382.935 278.31 382.65ZM279.05 383.438C278.598 383.699 278.336 384.009 278.263 384.369C278.19 384.723 278.208 385.061 278.317 385.382L282.386 387.731C282.916 387.791 283.436 387.782 283.945 387.704C284.454 387.62 284.904 387.465 285.293 387.24C285.974 386.847 286.226 386.402 286.049 385.904C285.873 385.406 285.236 384.84 284.14 384.207C283.423 383.793 282.76 383.489 282.152 383.294C281.539 383.096 280.978 383.009 280.469 383.033C279.954 383.054 279.481 383.189 279.05 383.438ZM296.449 379.783C296.776 379.972 297.069 380.078 297.329 380.102C297.589 380.126 297.87 380.093 298.171 380.003L298.771 380.719C298.371 380.896 297.95 381.01 297.509 381.061C297.062 381.109 296.597 381.062 296.113 380.921C296.197 381.311 296.116 381.691 295.872 382.06C295.622 382.426 295.23 382.763 294.695 383.072C293.874 383.546 292.996 383.786 292.06 383.792C291.125 383.798 290.275 383.581 289.512 383.14C288.665 382.651 288.345 382.085 288.553 381.443C288.761 380.801 289.488 380.12 290.735 379.4L291.943 378.703L291.258 378.307C290.665 377.965 290.073 377.824 289.48 377.884C288.888 377.938 288.285 378.142 287.672 378.496C287.402 378.652 287.119 378.854 286.823 379.103C286.521 379.349 286.233 379.639 285.957 379.972L284.625 379.598C284.942 379.199 285.282 378.85 285.646 378.55C286.009 378.25 286.391 377.984 286.791 377.753C287.815 377.162 288.821 376.858 289.808 376.84C290.795 376.816 291.697 377.039 292.512 377.51L296.449 379.783ZM294.032 382.303C294.438 382.069 294.723 381.787 294.89 381.457C295.051 381.124 295.069 380.783 294.944 380.435L292.832 379.216L291.647 379.9C290.743 380.422 290.26 380.881 290.198 381.277C290.14 381.67 290.374 382.018 290.899 382.321C291.408 382.615 291.925 382.763 292.45 382.766C292.975 382.763 293.502 382.609 294.032 382.303ZM304.47 376.123C304.881 375.886 305.195 375.627 305.414 375.345C305.637 375.06 305.796 374.77 305.889 374.476L307.386 374.602C307.334 374.986 307.144 375.375 306.817 375.768C306.489 376.161 306.084 376.497 305.601 376.776C304.785 377.247 303.914 377.548 302.99 377.68C302.065 377.806 301.135 377.773 300.199 377.581C299.259 377.386 298.36 377.041 297.502 376.546C296.681 376.072 296.097 375.561 295.749 375.012C295.401 374.457 295.325 373.906 295.523 373.36C295.725 372.811 296.237 372.3 297.058 371.826C297.583 371.523 298.155 371.286 298.773 371.115C299.391 370.938 300.051 370.83 300.753 370.791L300.986 371.664C300.394 371.724 299.861 371.821 299.389 371.956C298.916 372.085 298.498 372.255 298.134 372.465C297.427 372.873 297.11 373.362 297.183 373.932C297.256 374.502 297.835 375.1 298.921 375.727C299.648 376.147 300.347 376.431 301.018 376.578C301.688 376.719 302.314 376.747 302.896 376.663C303.478 376.573 304.003 376.393 304.47 376.123ZM309.726 364.71L309.726 368.976L318.362 369.201L316.639 370.196L308.12 369.939L308.026 365.691L309.726 364.71ZM300.778 365.871L312.453 372.612L311.144 373.368L299.632 366.722L300.778 365.871ZM317.476 354.673C317.913 354.421 318.37 354.202 318.848 354.016C319.321 353.827 319.802 353.697 320.29 353.625C320.779 353.553 321.259 353.563 321.732 353.656C322.205 353.743 322.652 353.941 323.073 354.25L325.738 356.149C326.05 356.377 326.393 356.524 326.767 356.59C327.146 356.653 327.575 356.619 328.053 356.487C328.531 356.355 329.09 356.104 329.729 355.735L330.773 356.338C330.139 356.704 329.708 357.028 329.479 357.31C329.251 357.586 329.191 357.834 329.3 358.053C329.415 358.269 329.672 358.468 330.072 358.651L333.345 360.181C333.875 360.427 334.218 360.685 334.374 360.955C334.535 361.228 334.554 361.506 334.429 361.788C334.309 362.067 334.083 362.344 333.751 362.62C333.429 362.896 333.049 363.16 332.613 363.412L331.584 362.818C331.963 362.599 332.27 362.38 332.504 362.161C332.743 361.939 332.857 361.726 332.847 361.522C332.836 361.318 332.654 361.132 332.301 360.964L328.778 359.308C328.269 359.068 327.923 358.839 327.741 358.62C327.554 358.398 327.513 358.17 327.617 357.936C327.726 357.699 327.962 357.442 328.326 357.166C327.853 357.361 327.404 357.486 326.978 357.54C326.557 357.591 326.151 357.564 325.762 357.459C325.372 357.354 324.98 357.163 324.585 356.887L321.716 354.853C321.431 354.652 321.111 354.549 320.758 354.543C320.404 354.537 320.038 354.601 319.659 354.736C319.274 354.868 318.89 355.045 318.505 355.267L317.476 354.673ZM466.247 277.52C467.328 278.144 468.385 278.613 469.419 278.928C470.458 279.24 471.55 279.441 472.693 279.531C473.836 279.621 475.106 279.641 476.504 279.59L476.535 280.4C475.003 280.487 473.574 280.496 472.249 280.427C470.929 280.355 469.663 280.155 468.453 279.828C467.247 279.498 466.055 278.993 464.875 278.312C463.691 277.628 462.812 276.938 462.241 276.242C461.674 275.543 461.329 274.812 461.204 274.05C461.085 273.285 461.103 272.462 461.259 271.58L462.662 271.598C462.599 272.21 462.599 272.777 462.662 273.299C462.724 273.815 462.883 274.305 463.137 274.77C463.387 275.232 463.763 275.69 464.267 276.143C464.771 276.59 465.431 277.049 466.247 277.52ZM478.322 270.548C477.506 270.077 476.709 269.698 475.929 269.41C475.15 269.116 474.36 268.897 473.56 268.753C472.754 268.606 471.902 268.516 471.003 268.483C470.104 268.444 469.125 268.442 468.065 268.478L468.034 267.668C469.566 267.575 470.993 267.565 472.313 267.637C473.632 267.709 474.895 267.91 476.101 268.24C477.311 268.567 478.509 269.072 479.694 269.756C480.873 270.437 481.746 271.127 482.313 271.826C482.884 272.522 483.232 273.251 483.357 274.013C483.482 274.775 483.466 275.6 483.31 276.488L481.907 276.47C481.996 275.663 481.962 274.93 481.806 274.27C481.65 273.61 481.299 272.981 480.754 272.384C480.213 271.784 479.403 271.172 478.322 270.548ZM489.165 267.609C489.529 267.399 489.955 267.297 490.444 267.303C490.932 267.303 491.345 267.4 491.683 267.595C491.875 267.706 492.044 267.831 492.19 267.969C492.34 268.104 492.481 268.278 492.611 268.491L494.247 270.894L493.063 271.578L490.717 269.359C490.135 269.419 489.618 269.319 489.165 269.058C488.817 268.857 488.641 268.617 488.635 268.338C488.635 268.056 488.812 267.813 489.165 267.609ZM483.78 264.499C484.143 264.289 484.567 264.186 485.05 264.189C485.539 264.189 485.957 264.289 486.305 264.49C486.648 264.688 486.825 264.931 486.835 265.219C486.845 265.501 486.669 265.747 486.305 265.957C485.952 266.161 485.528 266.262 485.035 266.259C484.541 266.25 484.123 266.146 483.78 265.948C483.432 265.747 483.255 265.507 483.25 265.228C483.25 264.946 483.426 264.703 483.78 264.499ZM246.23 426.808L247.258 427.402C246.879 427.621 246.573 427.843 246.339 428.068C246.105 428.287 245.993 428.498 246.004 428.702C246.019 428.903 246.198 429.088 246.541 429.256L250.064 430.912C250.548 431.137 250.883 431.36 251.07 431.582C251.257 431.804 251.314 432.029 251.241 432.257C251.174 432.482 250.994 432.718 250.704 432.964C251.13 432.79 251.537 432.68 251.927 432.635C252.312 432.587 252.694 432.619 253.073 432.73C253.447 432.838 253.842 433.039 254.258 433.333L257.126 435.367C257.422 435.568 257.744 435.673 258.092 435.682C258.441 435.691 258.807 435.626 259.191 435.488C259.576 435.35 259.958 435.172 260.337 434.953L261.366 435.547C260.93 435.799 260.472 436.018 259.994 436.204C259.521 436.393 259.041 436.523 258.552 436.595C258.064 436.667 257.583 436.657 257.11 436.564C256.643 436.474 256.196 436.276 255.77 435.97L253.12 434.08C252.803 433.849 252.468 433.694 252.114 433.616C251.766 433.535 251.353 433.561 250.875 433.693C250.397 433.819 249.81 434.083 249.113 434.485L248.069 433.882C248.765 433.48 249.225 433.142 249.449 432.869C249.677 432.593 249.721 432.355 249.581 432.154C249.446 431.95 249.181 431.758 248.786 431.578L245.497 430.039C244.967 429.793 244.624 429.535 244.468 429.265C244.307 428.992 244.286 428.716 244.406 428.437C244.53 428.155 244.757 427.877 245.084 427.604C245.411 427.325 245.793 427.06 246.23 426.808ZM265.648 417.153C266.09 416.898 266.529 416.69 266.966 416.528C267.402 416.366 267.852 416.232 268.314 416.127L268.867 416.933C268.488 417.02 268.122 417.132 267.768 417.27C267.415 417.408 267.08 417.569 266.763 417.752C266.191 418.082 265.872 418.395 265.804 418.692C265.742 418.986 265.942 419.267 266.404 419.534L268.072 420.497L270.855 418.89L271.744 419.565L269.101 421.091L275.641 424.866L274.331 425.622L267.792 421.847L265.836 422.976L264.807 422.382L266.763 421.253L265.126 420.308C264.617 420.014 264.308 419.685 264.199 419.322C264.095 418.956 264.17 418.586 264.425 418.211C264.674 417.833 265.082 417.48 265.648 417.153ZM277.77 414.16L284.941 418.3L287.256 416.963L288.292 417.562L282.135 421.117L281.098 420.518L283.631 419.056L277.497 415.514L275.042 416.932L274.006 416.333L277.77 414.16ZM272.883 412.544C273.174 412.376 273.494 412.294 273.842 412.297C274.195 412.297 274.499 412.37 274.754 412.517C275.019 412.67 275.154 412.85 275.159 413.057C275.164 413.258 275.021 413.443 274.73 413.611C274.455 413.77 274.141 413.849 273.787 413.849C273.429 413.846 273.117 413.768 272.852 413.615C272.597 413.468 272.47 413.293 272.47 413.089C272.47 412.885 272.608 412.703 272.883 412.544ZM282.854 407.409L292.339 412.885C292.745 413.119 293.158 413.214 293.579 413.169C293.999 413.118 294.41 412.977 294.81 412.746C295.059 412.602 295.27 412.45 295.441 412.291C295.613 412.132 295.766 411.963 295.901 411.783L297.211 412.134C297.096 412.326 296.915 412.542 296.665 412.782C296.426 413.022 296.099 413.262 295.683 413.502C294.956 413.922 294.166 414.147 293.314 414.177C292.456 414.204 291.672 414.012 290.96 413.601L282.581 408.763L280.063 410.217L279.027 409.618L282.854 407.409ZM297.906 407.808C298.566 408.159 299.208 408.389 299.831 408.497C300.45 408.602 301.034 408.606 301.585 408.51C302.131 408.411 302.614 408.24 303.035 407.997C303.456 407.754 303.773 407.499 303.986 407.232C304.204 406.962 304.37 406.653 304.484 406.305L305.965 406.449C305.882 406.845 305.68 407.235 305.357 407.619C305.04 408 304.625 408.339 304.11 408.636C303.315 409.095 302.458 409.383 301.538 409.5C300.618 409.617 299.691 409.577 298.756 409.379C297.82 409.175 296.929 408.828 296.082 408.339C295.251 407.859 294.661 407.348 294.313 406.805C293.965 406.262 293.874 405.729 294.04 405.207C294.206 404.685 294.653 404.214 295.381 403.794C296.072 403.395 296.83 403.146 297.657 403.047C298.478 402.945 299.322 402.992 300.19 403.187C301.058 403.376 301.907 403.71 302.739 404.19C302.879 404.271 303.009 404.349 303.128 404.424C303.243 404.496 303.341 404.562 303.424 404.622L297.906 407.808ZM296.472 404.406C295.864 404.757 295.57 405.176 295.591 405.662C295.617 406.145 296.054 406.664 296.901 407.219L301.18 404.748C300.286 404.25 299.434 403.98 298.623 403.938C297.807 403.893 297.09 404.049 296.472 404.406ZM311.75 402.974C312.379 402.611 312.758 402.257 312.888 401.912C313.018 401.561 312.886 401.272 312.491 401.044C312.241 400.9 311.979 400.802 311.704 400.751C311.433 400.697 311.085 400.709 310.659 400.787C310.233 400.865 309.656 401.03 308.929 401.282C308.222 401.528 307.567 401.72 306.965 401.858C306.362 401.99 305.796 402.038 305.266 402.002C304.741 401.963 304.242 401.807 303.769 401.534C303.307 401.267 303.039 400.963 302.966 400.621C302.894 400.273 303.003 399.913 303.294 399.541C303.579 399.166 304.031 398.8 304.65 398.443C305.31 398.062 305.972 397.781 306.637 397.601C307.302 397.415 307.934 397.297 308.531 397.246L308.843 398.092C308.318 398.149 307.801 398.246 307.292 398.384C306.778 398.519 306.255 398.74 305.725 399.046C305.081 399.418 304.725 399.74 304.658 400.013C304.585 400.283 304.707 400.51 305.024 400.693C305.263 400.831 305.528 400.909 305.819 400.927C306.11 400.939 306.479 400.891 306.926 400.783C307.367 400.672 307.942 400.499 308.648 400.265C309.324 400.037 309.958 399.866 310.55 399.752C311.148 399.635 311.719 399.605 312.265 399.662C312.81 399.719 313.338 399.895 313.847 400.189C314.429 400.525 314.736 400.894 314.767 401.296C314.793 401.695 314.624 402.095 314.26 402.497C313.896 402.893 313.421 403.261 312.834 403.6C312.091 404.029 311.35 404.333 310.612 404.513C309.875 404.687 309.176 404.788 308.516 404.815L308.399 403.883C308.986 403.85 309.571 403.762 310.153 403.618C310.735 403.468 311.267 403.253 311.75 402.974ZM319.757 396.435C320.115 396.228 320.536 396.126 321.019 396.129C321.508 396.129 321.924 396.228 322.266 396.426C322.454 396.534 322.62 396.657 322.765 396.795C322.916 396.93 323.056 397.101 323.186 397.308L324.815 399.706L323.63 400.39L321.3 398.181C321.03 398.205 320.757 398.191 320.482 398.14C320.206 398.083 319.965 397.995 319.757 397.875C319.409 397.674 319.235 397.435 319.235 397.159C319.229 396.88 319.403 396.639 319.757 396.435ZM341.989 384.49C342.317 384.679 342.61 384.785 342.87 384.809C343.13 384.833 343.41 384.8 343.712 384.71L344.312 385.426C343.912 385.603 343.491 385.717 343.049 385.768C342.602 385.816 342.137 385.769 341.654 385.628C341.737 386.018 341.657 386.398 341.413 386.767C341.163 387.133 340.771 387.47 340.236 387.779C339.415 388.253 338.536 388.493 337.601 388.499C336.666 388.505 335.816 388.288 335.052 387.847C334.205 387.358 333.886 386.792 334.094 386.15C334.302 385.508 335.029 384.827 336.276 384.107L337.484 383.41L336.798 383.014C336.206 382.672 335.614 382.531 335.021 382.591C334.429 382.645 333.826 382.849 333.213 383.203C332.943 383.359 332.66 383.561 332.363 383.81C332.062 384.056 331.774 384.346 331.498 384.679L330.165 384.305C330.482 383.906 330.823 383.557 331.186 383.257C331.55 382.957 331.932 382.691 332.332 382.46C333.356 381.869 334.361 381.565 335.349 381.547C336.336 381.523 337.237 381.746 338.053 382.217L341.989 384.49ZM339.573 387.01C339.978 386.776 340.264 386.494 340.43 386.164C340.592 385.831 340.61 385.49 340.485 385.142L338.373 383.923L337.188 384.607C336.284 385.129 335.801 385.588 335.738 385.984C335.681 386.377 335.915 386.725 336.44 387.028C336.949 387.322 337.466 387.47 337.991 387.473C338.516 387.47 339.043 387.316 339.573 387.01ZM350.011 380.83C350.422 380.593 350.736 380.334 350.954 380.052C351.178 379.767 351.336 379.477 351.43 379.183L352.926 379.309C352.874 379.693 352.685 380.082 352.357 380.475C352.03 380.868 351.625 381.204 351.141 381.483C350.326 381.954 349.455 382.255 348.53 382.387C347.605 382.513 346.675 382.48 345.74 382.288C344.8 382.093 343.901 381.748 343.043 381.253C342.222 380.779 341.638 380.268 341.29 379.719C340.941 379.164 340.866 378.613 341.063 378.067C341.266 377.518 341.778 377.007 342.599 376.533C343.124 376.23 343.695 375.993 344.314 375.822C344.932 375.645 345.592 375.537 346.293 375.498L346.527 376.371C345.935 376.431 345.402 376.528 344.929 376.663C344.457 376.792 344.038 376.962 343.675 377.172C342.968 377.58 342.651 378.069 342.724 378.639C342.796 379.209 343.376 379.807 344.462 380.434C345.189 380.854 345.888 381.138 346.558 381.285C347.229 381.426 347.855 381.454 348.437 381.37C349.019 381.28 349.544 381.1 350.011 380.83ZM362.702 374.124C362.608 374.394 362.414 374.675 362.117 374.966C361.821 375.257 361.481 375.513 361.096 375.735C360.213 376.245 359.301 376.505 358.361 376.514C357.42 376.523 356.586 376.317 355.859 375.897L350.964 373.071L349.078 374.16L348.064 373.575L349.951 372.486L348.088 371.411L349.241 370.565L351.26 371.73L354.097 370.092L354.954 370.767L352.273 372.315L357.152 375.132C357.61 375.396 358.077 375.528 358.555 375.528C359.039 375.525 359.561 375.362 360.122 375.038C360.429 374.861 360.675 374.676 360.863 374.484C361.05 374.292 361.198 374.099 361.307 373.904L362.702 374.124ZM361.893 365.591L369.064 369.731L371.379 368.395L372.415 368.993L366.258 372.548L365.221 371.95L367.754 370.487L361.62 366.946L359.165 368.363L358.128 367.765L361.893 365.591ZM357.006 363.976C357.297 363.808 357.617 363.725 357.965 363.728C358.318 363.728 358.622 363.802 358.877 363.949C359.142 364.102 359.277 364.282 359.282 364.489C359.287 364.69 359.144 364.874 358.853 365.042C358.578 365.201 358.264 365.281 357.91 365.281C357.552 365.278 357.24 365.2 356.975 365.047C356.72 364.9 356.593 364.724 356.593 364.52C356.593 364.316 356.731 364.135 357.006 363.976ZM373.929 358.642L379.151 365.104L377.631 365.982L366.462 362.953L367.85 362.152L377.242 364.83L372.573 359.425L373.929 358.642ZM382.029 359.24C382.689 359.591 383.331 359.82 383.954 359.928C384.572 360.033 385.157 360.038 385.708 359.942C386.253 359.843 386.737 359.672 387.158 359.429C387.578 359.186 387.895 358.931 388.108 358.664C388.327 358.394 388.493 358.085 388.607 357.737L390.088 357.881C390.005 358.277 389.802 358.667 389.48 359.051C389.163 359.432 388.748 359.771 388.233 360.068C387.438 360.527 386.581 360.815 385.661 360.932C384.741 361.049 383.814 361.008 382.879 360.81C381.943 360.606 381.052 360.26 380.205 359.771C379.374 359.291 378.784 358.779 378.436 358.236C378.088 357.693 377.997 357.161 378.163 356.639C378.329 356.117 378.776 355.646 379.504 355.226C380.195 354.827 380.953 354.578 381.78 354.479C382.601 354.377 383.445 354.423 384.313 354.618C385.18 354.807 386.03 355.142 386.861 355.622C387.002 355.703 387.132 355.781 387.251 355.856C387.365 355.928 387.464 355.994 387.547 356.054L382.029 359.24ZM380.595 355.838C379.987 356.189 379.693 356.607 379.714 357.093C379.74 357.576 380.177 358.095 381.024 358.65L385.303 356.18C384.409 355.682 383.557 355.412 382.746 355.37C381.93 355.325 381.213 355.481 380.595 355.838ZM392.233 348.983C391.677 348.662 391.129 348.472 390.589 348.412C390.043 348.349 389.511 348.386 388.991 348.524C388.466 348.659 387.959 348.868 387.471 349.15L385.92 350.045L390.503 352.691L391.999 351.827C392.504 351.536 392.88 351.241 393.13 350.941C393.374 350.638 393.439 350.324 393.325 350C393.205 349.673 392.841 349.334 392.233 348.983ZM393.667 348.137C394.504 348.62 394.995 349.111 395.141 349.609C395.291 350.104 395.169 350.597 394.774 351.089C394.379 351.581 393.777 352.061 392.966 352.529L391.594 353.321L395.577 355.621L394.221 356.404L383.488 350.207L386.232 348.623C387.51 347.885 388.788 347.459 390.067 347.345C391.345 347.225 392.545 347.489 393.667 348.137ZM407.418 346.714C407.746 346.903 408.039 347.01 408.299 347.034C408.559 347.058 408.839 347.025 409.141 346.935L409.741 347.65C409.341 347.827 408.92 347.941 408.478 347.992C408.031 348.04 407.566 347.994 407.083 347.853C407.166 348.243 407.086 348.622 406.841 348.991C406.592 349.357 406.2 349.695 405.664 350.004C404.843 350.478 403.965 350.718 403.03 350.724C402.095 350.73 401.245 350.512 400.481 350.071C399.634 349.582 399.315 349.017 399.523 348.375C399.73 347.733 400.458 347.052 401.705 346.332L402.913 345.634L402.227 345.238C401.635 344.896 401.042 344.755 400.45 344.815C399.858 344.869 399.255 345.073 398.642 345.427C398.372 345.583 398.088 345.786 397.792 346.035C397.491 346.281 397.203 346.57 396.927 346.903L395.594 346.53C395.911 346.131 396.252 345.781 396.615 345.481C396.979 345.181 397.361 344.916 397.761 344.685C398.785 344.094 399.79 343.789 400.777 343.771C401.765 343.747 402.666 343.971 403.482 344.442L407.418 346.714ZM405.002 349.234C405.407 349 405.693 348.718 405.859 348.388C406.02 348.055 406.039 347.715 405.914 347.367L403.802 346.147L402.617 346.831C401.713 347.353 401.23 347.812 401.167 348.208C401.11 348.601 401.344 348.949 401.869 349.252C402.378 349.546 402.895 349.695 403.42 349.698C403.945 349.695 404.472 349.54 405.002 349.234ZM418.784 341.745C418.69 342.015 418.495 342.296 418.199 342.587C417.903 342.878 417.563 343.134 417.178 343.356C416.295 343.866 415.383 344.126 414.442 344.135C413.502 344.144 412.668 343.938 411.941 343.518L407.046 340.692L405.16 341.781L404.146 341.196L406.033 340.107L404.17 339.032L405.323 338.186L407.342 339.351L410.179 337.713L411.036 338.388L408.355 339.936L413.234 342.753C413.692 343.017 414.159 343.149 414.637 343.149C415.121 343.146 415.643 342.983 416.204 342.659C416.511 342.482 416.757 342.297 416.944 342.105C417.131 341.913 417.28 341.72 417.389 341.525L418.784 341.745ZM411.701 332.875L416.252 335.503C416.143 335.068 416.216 334.654 416.471 334.261C416.725 333.862 417.094 333.523 417.577 333.244C418.378 332.782 419.175 332.567 419.97 332.6C420.765 332.633 421.542 332.869 422.301 333.307L428.263 336.749L426.954 337.505L421.023 334.081C420.529 333.796 420.056 333.655 419.604 333.658C419.147 333.658 418.674 333.799 418.185 334.081C417.874 334.261 417.648 334.472 417.507 334.715C417.367 334.958 417.289 335.204 417.273 335.453C417.258 335.702 417.286 335.932 417.359 336.142L423.337 339.593L422.028 340.349L410.531 333.712L411.701 332.875ZM428.446 321.605C428.883 321.353 429.34 321.134 429.818 320.948C430.291 320.759 430.771 320.628 431.26 320.556C431.748 320.484 432.229 320.495 432.702 320.588C433.175 320.675 433.621 320.873 434.042 321.182L436.708 323.081C437.02 323.309 437.363 323.456 437.737 323.522C438.116 323.585 438.545 323.55 439.023 323.418C439.501 323.286 440.059 323.036 440.699 322.667L441.743 323.27C441.109 323.636 440.678 323.96 440.449 324.242C440.221 324.518 440.161 324.765 440.27 324.984C440.384 325.2 440.641 325.4 441.042 325.583L444.315 327.113C444.845 327.359 445.188 327.617 445.344 327.887C445.505 328.16 445.523 328.437 445.398 328.719C445.279 328.998 445.053 329.276 444.72 329.552C444.398 329.828 444.019 330.092 443.582 330.344L442.554 329.75C442.933 329.531 443.239 329.312 443.473 329.093C443.712 328.871 443.827 328.658 443.816 328.454C443.806 328.25 443.624 328.064 443.271 327.896L439.748 326.24C439.238 326 438.893 325.77 438.711 325.551C438.524 325.329 438.482 325.101 438.586 324.867C438.695 324.63 438.932 324.374 439.296 324.098C438.823 324.293 438.373 324.417 437.947 324.471C437.526 324.522 437.121 324.495 436.731 324.39C436.342 324.285 435.949 324.095 435.554 323.819L432.686 321.785C432.4 321.584 432.081 321.48 431.727 321.474C431.374 321.468 431.008 321.533 430.628 321.668C430.244 321.8 429.859 321.977 429.475 322.199L428.446 321.605ZM479.996 305.837C480.625 305.474 481.004 305.12 481.134 304.775C481.264 304.424 481.131 304.135 480.737 303.907C480.487 303.763 480.225 303.665 479.949 303.614C479.679 303.56 479.331 303.572 478.905 303.65C478.479 303.728 477.902 303.893 477.175 304.145C476.468 304.391 475.813 304.583 475.21 304.721C474.608 304.853 474.041 304.901 473.511 304.865C472.986 304.826 472.488 304.67 472.015 304.397C471.552 304.13 471.285 303.826 471.212 303.484C471.139 303.136 471.248 302.776 471.539 302.404C471.825 302.029 472.277 301.663 472.896 301.306C473.555 300.925 474.218 300.644 474.883 300.464C475.548 300.278 476.18 300.16 476.777 300.109L477.089 300.955C476.564 301.012 476.047 301.109 475.538 301.247C475.023 301.382 474.501 301.603 473.971 301.909C473.327 302.281 472.971 302.603 472.903 302.876C472.831 303.146 472.953 303.373 473.27 303.556C473.509 303.694 473.774 303.772 474.065 303.79C474.356 303.802 474.725 303.754 475.171 303.646C475.613 303.535 476.187 303.362 476.894 303.128C477.569 302.9 478.203 302.729 478.796 302.615C479.393 302.498 479.965 302.468 480.511 302.525C481.056 302.582 481.584 302.758 482.093 303.052C482.675 303.388 482.981 303.757 483.012 304.159C483.038 304.558 482.87 304.958 482.506 305.36C482.142 305.756 481.667 306.124 481.079 306.463C480.336 306.892 479.596 307.196 478.858 307.376C478.12 307.55 477.421 307.651 476.761 307.678L476.645 306.746C477.232 306.713 477.816 306.625 478.398 306.481C478.98 306.331 479.513 306.116 479.996 305.837ZM491.541 298.146C491.868 298.335 492.162 298.442 492.422 298.466C492.682 298.49 492.962 298.457 493.264 298.367L493.864 299.082C493.464 299.259 493.043 299.373 492.601 299.424C492.154 299.472 491.689 299.426 491.206 299.285C491.289 299.675 491.208 300.054 490.964 300.423C490.715 300.789 490.323 301.127 489.787 301.436C488.966 301.91 488.088 302.15 487.153 302.156C486.218 302.162 485.368 301.944 484.604 301.503C483.757 301.014 483.438 300.449 483.645 299.807C483.853 299.165 484.581 298.484 485.828 297.764L487.036 297.066L486.35 296.67C485.758 296.328 485.165 296.187 484.573 296.247C483.981 296.301 483.378 296.505 482.765 296.859C482.495 297.015 482.211 297.218 481.915 297.467C481.614 297.713 481.325 298.002 481.05 298.335L479.717 297.962C480.034 297.563 480.375 297.213 480.738 296.913C481.102 296.613 481.484 296.348 481.884 296.117C482.908 295.526 483.913 295.221 484.9 295.203C485.888 295.179 486.789 295.403 487.605 295.874L491.541 298.146ZM489.125 300.666C489.53 300.432 489.816 300.15 489.982 299.82C490.143 299.487 490.161 299.147 490.037 298.799L487.925 297.579L486.74 298.263C485.836 298.785 485.352 299.244 485.29 299.64C485.233 300.033 485.467 300.381 485.992 300.684C486.501 300.978 487.018 301.127 487.543 301.13C488.067 301.127 488.595 300.972 489.125 300.666ZM496.804 297.178L488.597 292.439L489.711 291.796L490.95 292.394C490.862 291.959 490.956 291.533 491.231 291.116C491.506 290.693 491.881 290.345 492.353 290.072C493.159 289.607 493.956 289.393 494.746 289.429C495.541 289.462 496.318 289.697 497.077 290.135L503.039 293.578L501.73 294.334L496.734 291.449C496.173 291.125 495.689 290.882 495.284 290.72C494.873 290.555 494.492 290.485 494.138 290.509C493.78 290.53 493.393 290.66 492.977 290.9C492.655 291.086 492.421 291.302 492.275 291.548C492.135 291.791 492.06 292.039 492.049 292.291C492.039 292.537 492.068 292.763 492.135 292.97L498.113 296.422L496.804 297.178ZM499.385 282.205L500.859 281.544L512.371 288.19L511.225 288.852L510.017 288.298C510.147 288.727 510.113 289.116 509.915 289.464C509.723 289.809 509.401 290.112 508.949 290.373C508.237 290.784 507.471 291.019 506.65 291.079C505.829 291.139 504.987 291.049 504.124 290.809C503.257 290.566 502.399 290.2 501.552 289.711C500.731 289.237 500.126 288.741 499.736 288.222C499.341 287.7 499.198 287.194 499.308 286.705C499.417 286.21 499.809 285.768 500.484 285.378C500.957 285.105 501.456 284.913 501.981 284.802C502.501 284.688 503.057 284.643 503.649 284.667L499.385 282.205ZM501.88 285.787C501.194 286.183 500.934 286.642 501.1 287.164C501.266 287.686 501.893 288.261 502.979 288.888C503.685 289.296 504.353 289.594 504.982 289.783C505.61 289.972 506.19 290.052 506.72 290.022C507.255 289.989 507.736 289.849 508.162 289.603C508.629 289.333 508.894 289.027 508.957 288.685C509.024 288.34 509.001 288.009 508.887 287.691L504.787 285.324C504.231 285.261 503.703 285.268 503.205 285.346C502.701 285.421 502.259 285.568 501.88 285.787ZM510.79 279.428C511.518 279.008 512.274 278.775 513.058 278.73C513.848 278.682 514.661 278.789 515.498 279.05C516.329 279.308 517.174 279.684 518.031 280.179C518.857 280.656 519.478 281.15 519.894 281.66C520.309 282.164 520.468 282.657 520.369 283.14C520.27 283.623 519.865 284.07 519.153 284.481C518.254 285 517.215 285.234 516.036 285.183L519.948 287.442L518.803 288.293L507.291 281.646L508.405 281.003L509.66 281.601C509.54 281.184 509.574 280.79 509.761 280.418C509.954 280.043 510.296 279.713 510.79 279.428ZM511.531 280.215C511.079 280.476 510.816 280.787 510.743 281.147C510.671 281.501 510.689 281.838 510.798 282.159L514.866 284.508C515.397 284.568 515.916 284.559 516.425 284.481C516.935 284.397 517.384 284.243 517.774 284.018C518.454 283.625 518.706 283.179 518.53 282.681C518.353 282.183 517.717 281.618 516.62 280.985C515.903 280.571 515.241 280.266 514.633 280.071C514.02 279.873 513.458 279.786 512.949 279.81C512.435 279.831 511.962 279.966 511.531 280.215ZM528.929 276.56C529.256 276.749 529.55 276.856 529.81 276.88C530.07 276.904 530.35 276.871 530.652 276.781L531.252 277.496C530.852 277.673 530.431 277.787 529.989 277.838C529.542 277.886 529.077 277.84 528.594 277.699C528.677 278.089 528.596 278.468 528.352 278.837C528.103 279.203 527.71 279.541 527.175 279.85C526.354 280.324 525.476 280.564 524.541 280.57C523.606 280.576 522.756 280.358 521.992 279.917C521.145 279.428 520.826 278.863 521.033 278.221C521.241 277.579 521.969 276.898 523.216 276.178L524.424 275.48L523.738 275.084C523.146 274.742 522.553 274.601 521.961 274.661C521.369 274.715 520.766 274.919 520.153 275.273C519.882 275.429 519.599 275.632 519.303 275.881C519.002 276.127 518.713 276.416 518.438 276.749L517.105 276.376C517.422 275.977 517.762 275.627 518.126 275.327C518.49 275.027 518.872 274.762 519.272 274.531C520.296 273.94 521.301 273.635 522.288 273.617C523.276 273.593 524.177 273.817 524.993 274.288L528.929 276.56ZM526.513 279.08C526.918 278.846 527.204 278.564 527.37 278.234C527.531 277.901 527.549 277.561 527.425 277.213L525.312 275.993L524.128 276.677C523.224 277.199 522.74 277.658 522.678 278.054C522.621 278.447 522.855 278.795 523.379 279.098C523.889 279.392 524.406 279.541 524.931 279.544C525.455 279.541 525.983 279.386 526.513 279.08ZM536.951 272.901C537.361 272.664 537.676 272.404 537.894 272.122C538.117 271.837 538.276 271.548 538.37 271.254L539.866 271.38C539.814 271.764 539.624 272.152 539.297 272.545C538.97 272.938 538.564 273.274 538.081 273.553C537.265 274.024 536.395 274.326 535.47 274.458C534.545 274.584 533.615 274.551 532.68 274.359C531.739 274.164 530.84 273.819 529.983 273.324C529.162 272.85 528.577 272.338 528.229 271.789C527.881 271.234 527.806 270.684 528.003 270.138C528.206 269.589 528.718 269.077 529.539 268.603C530.063 268.3 530.635 268.063 531.253 267.892C531.872 267.715 532.532 267.607 533.233 267.568L533.467 268.441C532.875 268.501 532.342 268.599 531.869 268.734C531.396 268.863 530.978 269.032 530.614 269.242C529.908 269.65 529.591 270.139 529.663 270.709C529.736 271.279 530.315 271.878 531.401 272.505C532.129 272.925 532.828 273.208 533.498 273.355C534.168 273.496 534.795 273.525 535.377 273.441C535.958 273.351 536.483 273.171 536.951 272.901ZM542.206 261.488L542.206 265.754L550.842 265.979L549.119 266.973L540.6 266.717L540.507 262.469L542.206 261.488ZM533.258 262.649L544.934 269.39L543.625 270.146L532.112 263.499L533.258 262.649ZM553.4 261.523C553.764 261.313 554.19 261.211 554.678 261.217C555.167 261.217 555.58 261.314 555.918 261.509C556.11 261.62 556.279 261.745 556.424 261.883C556.575 262.018 556.715 262.192 556.845 262.405L558.482 264.808L557.297 265.492L554.951 263.273C554.369 263.333 553.852 263.233 553.4 262.972C553.052 262.771 552.875 262.531 552.87 262.252C552.87 261.97 553.047 261.727 553.4 261.523ZM548.014 258.413C548.378 258.203 548.802 258.1 549.285 258.103C549.773 258.103 550.192 258.203 550.54 258.404C550.883 258.602 551.059 258.845 551.07 259.133C551.08 259.415 550.903 259.661 550.54 259.871C550.186 260.075 549.763 260.176 549.269 260.173C548.776 260.164 548.357 260.06 548.014 259.862C547.666 259.661 547.49 259.421 547.484 259.142C547.484 258.86 547.661 258.617 548.014 258.413ZM310.235 465.795C310.645 465.558 310.96 465.299 311.178 465.017C311.401 464.732 311.56 464.442 311.654 464.148L313.15 464.274C313.098 464.658 312.908 465.047 312.581 465.44C312.254 465.833 311.848 466.169 311.365 466.448C310.549 466.919 309.679 467.22 308.754 467.352C307.829 467.478 306.899 467.445 305.964 467.253C305.023 467.058 304.124 466.713 303.267 466.218C302.446 465.744 301.861 465.233 301.513 464.684C301.165 464.129 301.09 463.578 301.287 463.032C301.49 462.483 302.002 461.972 302.823 461.498C303.347 461.195 303.919 460.958 304.537 460.787C305.156 460.61 305.816 460.502 306.517 460.463L306.751 461.336C306.159 461.396 305.626 461.493 305.153 461.628C304.68 461.757 304.262 461.927 303.898 462.137C303.192 462.545 302.875 463.034 302.947 463.604C303.02 464.174 303.599 464.772 304.685 465.399C305.413 465.819 306.112 466.103 306.782 466.25C307.452 466.391 308.079 466.419 308.661 466.335C309.242 466.245 309.767 466.065 310.235 465.795ZM311.569 456.448C312.344 456.001 313.167 455.729 314.04 455.633C314.913 455.531 315.799 455.59 316.698 455.809C317.602 456.025 318.488 456.383 319.356 456.884C320.192 457.367 320.798 457.873 321.172 458.401C321.546 458.929 321.655 459.451 321.499 459.967C321.343 460.477 320.881 460.954 320.112 461.398C319.343 461.842 318.519 462.113 317.641 462.212C316.763 462.311 315.869 462.254 314.96 462.041C314.051 461.822 313.167 461.465 312.31 460.97C311.463 460.481 310.852 459.973 310.478 459.445C310.104 458.917 310 458.398 310.167 457.888C310.333 457.372 310.8 456.892 311.569 456.448ZM312.637 457.064C311.931 457.472 311.658 457.933 311.819 458.446C311.98 458.953 312.611 459.524 313.713 460.16C314.794 460.784 315.773 461.146 316.651 461.245C317.535 461.341 318.33 461.185 319.036 460.777C319.743 460.369 320.011 459.911 319.839 459.404C319.673 458.894 319.044 458.324 317.953 457.694C316.862 457.064 315.88 456.701 315.007 456.605C314.129 456.506 313.339 456.659 312.637 457.064ZM319.404 448.117L320.877 447.456L332.39 454.102L331.244 454.764L330.036 454.21C330.166 454.639 330.132 455.028 329.934 455.376C329.742 455.721 329.42 456.024 328.968 456.285C328.256 456.696 327.49 456.931 326.669 456.991C325.848 457.051 325.006 456.961 324.143 456.721C323.276 456.478 322.418 456.112 321.571 455.623C320.75 455.149 320.145 454.653 319.755 454.134C319.36 453.612 319.217 453.106 319.326 452.617C319.436 452.122 319.828 451.68 320.503 451.29C320.976 451.017 321.475 450.825 322 450.714C322.519 450.6 323.075 450.555 323.668 450.579L319.404 448.117ZM321.899 451.699C321.213 452.095 320.953 452.554 321.119 453.076C321.285 453.598 321.912 454.173 322.998 454.8C323.704 455.208 324.372 455.506 325.001 455.695C325.629 455.884 326.209 455.964 326.739 455.934C327.274 455.901 327.755 455.761 328.181 455.515C328.648 455.245 328.913 454.939 328.976 454.597C329.043 454.252 329.02 453.921 328.906 453.603L324.806 451.236C324.25 451.173 323.722 451.18 323.224 451.258C322.72 451.333 322.278 451.48 321.899 451.699ZM332.906 449.601C333.566 449.952 334.207 450.182 334.831 450.29C335.449 450.395 336.034 450.399 336.585 450.303C337.13 450.204 337.613 450.033 338.034 449.79C338.455 449.547 338.772 449.292 338.985 449.025C339.203 448.755 339.37 448.446 339.484 448.098L340.965 448.242C340.882 448.638 340.679 449.028 340.357 449.412C340.04 449.793 339.624 450.132 339.11 450.429C338.315 450.888 337.458 451.176 336.538 451.293C335.618 451.41 334.691 451.37 333.755 451.172C332.82 450.968 331.929 450.621 331.082 450.132C330.25 449.652 329.661 449.141 329.313 448.598C328.964 448.055 328.873 447.522 329.04 447C329.206 446.478 329.653 446.007 330.38 445.587C331.071 445.188 331.83 444.939 332.656 444.84C333.477 444.738 334.322 444.785 335.189 444.98C336.057 445.169 336.907 445.503 337.738 445.983C337.878 446.064 338.008 446.142 338.128 446.217C338.242 446.289 338.341 446.355 338.424 446.415L332.906 449.601ZM331.472 446.199C330.864 446.55 330.57 446.969 330.591 447.455C330.617 447.938 331.053 448.457 331.9 449.012L336.179 446.541C335.286 446.043 334.433 445.773 333.623 445.731C332.807 445.686 332.09 445.842 331.472 446.199ZM366.077 421.171C366.519 420.916 366.958 420.707 367.394 420.545C367.831 420.383 368.28 420.25 368.743 420.145L369.296 420.95C368.917 421.037 368.55 421.15 368.197 421.288C367.844 421.426 367.509 421.586 367.192 421.769C366.62 422.099 366.3 422.413 366.233 422.71C366.17 423.004 366.371 423.284 366.833 423.551L368.501 424.514L371.284 422.908L372.172 423.583L369.53 425.108L376.069 428.884L374.76 429.64L368.22 425.864L366.264 426.994L365.235 426.4L367.192 425.27L365.555 424.325C365.046 424.031 364.736 423.703 364.627 423.34C364.523 422.974 364.599 422.603 364.853 422.228C365.103 421.85 365.511 421.498 366.077 421.171ZM378.199 418.177L385.369 422.317L387.684 420.981L388.721 421.579L382.563 425.134L381.527 424.536L384.06 423.073L377.926 419.532L375.471 420.949L374.434 420.351L378.199 418.177ZM373.312 416.562C373.603 416.394 373.922 416.311 374.27 416.314C374.624 416.314 374.928 416.388 375.182 416.535C375.447 416.688 375.582 416.868 375.588 417.075C375.593 417.276 375.45 417.46 375.159 417.628C374.884 417.787 374.569 417.867 374.216 417.867C373.857 417.864 373.546 417.786 373.281 417.633C373.026 417.486 372.899 417.31 372.899 417.106C372.899 416.902 373.036 416.721 373.312 416.562ZM383.282 411.426L392.768 416.903C393.173 417.137 393.586 417.231 394.007 417.186C394.428 417.135 394.838 416.994 395.239 416.763C395.488 416.619 395.698 416.468 395.87 416.309C396.041 416.15 396.195 415.98 396.33 415.8L397.639 416.151C397.525 416.343 397.343 416.559 397.094 416.799C396.855 417.039 396.527 417.279 396.112 417.519C395.384 417.939 394.594 418.164 393.742 418.194C392.885 418.221 392.1 418.029 391.388 417.618L383.009 412.781L380.492 414.234L379.455 413.636L383.282 411.426ZM398.335 411.826C398.995 412.177 399.636 412.406 400.26 412.514C400.878 412.619 401.463 412.624 402.013 412.528C402.559 412.429 403.042 412.258 403.463 412.015C403.884 411.772 404.201 411.517 404.414 411.25C404.632 410.98 404.799 410.671 404.913 410.323L406.394 410.467C406.311 410.863 406.108 411.253 405.786 411.637C405.469 412.018 405.053 412.357 404.539 412.654C403.744 413.113 402.886 413.401 401.967 413.518C401.047 413.635 400.119 413.594 399.184 413.396C398.249 413.192 397.358 412.846 396.511 412.357C395.679 411.877 395.09 411.365 394.741 410.822C394.393 410.279 394.302 409.747 394.469 409.225C394.635 408.703 395.082 408.232 395.809 407.812C396.5 407.413 397.259 407.164 398.085 407.065C398.906 406.963 399.751 407.009 400.618 407.204C401.486 407.393 402.336 407.728 403.167 408.208C403.307 408.289 403.437 408.367 403.557 408.442C403.671 408.514 403.77 408.58 403.853 408.64L398.335 411.826ZM396.9 408.424C396.293 408.775 395.999 409.193 396.02 409.679C396.046 410.162 396.482 410.681 397.329 411.236L401.608 408.766C400.714 408.268 399.862 407.998 399.052 407.956C398.236 407.911 397.519 408.067 396.9 408.424ZM412.179 406.992C412.808 406.629 413.187 406.275 413.317 405.93C413.447 405.579 413.314 405.289 412.919 405.061C412.67 404.917 412.407 404.82 412.132 404.769C411.862 404.715 411.514 404.727 411.088 404.805C410.662 404.883 410.085 405.048 409.357 405.3C408.651 405.546 407.996 405.738 407.393 405.876C406.79 406.008 406.224 406.056 405.694 406.02C405.169 405.981 404.67 405.825 404.198 405.552C403.735 405.285 403.468 404.98 403.395 404.638C403.322 404.29 403.431 403.93 403.722 403.558C404.008 403.183 404.46 402.817 405.078 402.46C405.738 402.079 406.401 401.799 407.066 401.619C407.731 401.433 408.362 401.314 408.96 401.263L409.272 402.109C408.747 402.166 408.23 402.264 407.721 402.402C407.206 402.537 406.684 402.757 406.154 403.063C405.51 403.435 405.154 403.758 405.086 404.031C405.013 404.301 405.135 404.527 405.452 404.71C405.691 404.848 405.956 404.926 406.247 404.944C406.538 404.956 406.907 404.908 407.354 404.8C407.796 404.689 408.37 404.517 409.077 404.283C409.752 404.055 410.386 403.884 410.979 403.77C411.576 403.653 412.148 403.623 412.693 403.68C413.239 403.737 413.766 403.912 414.275 404.206C414.857 404.542 415.164 404.911 415.195 405.313C415.221 405.712 415.052 406.113 414.689 406.515C414.325 406.911 413.849 407.278 413.262 407.617C412.519 408.046 411.779 408.351 411.041 408.531C410.303 408.705 409.604 408.805 408.944 408.832L408.827 407.901C409.414 407.868 409.999 407.779 410.581 407.635C411.163 407.485 411.696 407.271 412.179 406.992ZM422.742 404.016L408.229 395.637L412.134 393.383L413.264 394.035L410.598 395.574L422.866 402.657L425.532 401.118L426.647 401.762L422.742 404.016ZM433.071 393.904C433.398 394.093 433.692 394.199 433.952 394.223C434.211 394.247 434.492 394.214 434.793 394.124L435.393 394.84C434.993 395.017 434.572 395.131 434.131 395.182C433.684 395.23 433.219 395.183 432.736 395.042C432.819 395.432 432.738 395.812 432.494 396.181C432.245 396.547 431.852 396.884 431.317 397.193C430.496 397.667 429.618 397.907 428.683 397.913C427.747 397.919 426.898 397.702 426.134 397.261C425.287 396.772 424.967 396.206 425.175 395.564C425.383 394.922 426.111 394.241 427.358 393.521L428.566 392.824L427.88 392.428C427.287 392.086 426.695 391.945 426.103 392.005C425.51 392.059 424.908 392.263 424.294 392.617C424.024 392.773 423.741 392.975 423.445 393.224C423.144 393.47 422.855 393.76 422.58 394.093L421.247 393.719C421.564 393.32 421.904 392.971 422.268 392.671C422.632 392.371 423.014 392.105 423.414 391.874C424.437 391.283 425.443 390.979 426.43 390.961C427.417 390.937 428.319 391.16 429.135 391.631L433.071 393.904ZM430.655 396.424C431.06 396.19 431.346 395.908 431.512 395.578C431.673 395.245 431.691 394.904 431.567 394.556L429.454 393.337L428.27 394.021C427.365 394.543 426.882 395.002 426.82 395.398C426.763 395.791 426.996 396.139 427.521 396.442C428.031 396.736 428.548 396.884 429.072 396.887C429.597 396.884 430.125 396.73 430.655 396.424ZM441.093 390.244C441.503 390.007 441.818 389.748 442.036 389.466C442.259 389.181 442.418 388.891 442.511 388.597L444.008 388.723C443.956 389.107 443.766 389.496 443.439 389.889C443.111 390.282 442.706 390.618 442.223 390.897C441.407 391.368 440.537 391.669 439.612 391.801C438.687 391.927 437.757 391.894 436.822 391.702C435.881 391.507 434.982 391.162 434.125 390.667C433.304 390.193 432.719 389.682 432.371 389.133C432.023 388.578 431.948 388.027 432.145 387.481C432.348 386.932 432.859 386.421 433.68 385.947C434.205 385.644 434.777 385.407 435.395 385.236C436.014 385.059 436.673 384.951 437.375 384.912L437.609 385.785C437.016 385.845 436.484 385.942 436.011 386.077C435.538 386.206 435.12 386.376 434.756 386.586C434.049 386.994 433.732 387.483 433.805 388.053C433.878 388.623 434.457 389.221 435.543 389.848C436.271 390.268 436.97 390.552 437.64 390.699C438.31 390.84 438.936 390.868 439.518 390.784C440.1 390.694 440.625 390.514 441.093 390.244ZM453.783 383.538C453.69 383.808 453.495 384.089 453.199 384.38C452.903 384.671 452.562 384.927 452.178 385.149C451.295 385.659 450.383 385.919 449.442 385.928C448.502 385.937 447.668 385.731 446.94 385.311L442.045 382.485L440.159 383.574L439.146 382.989L441.032 381.9L439.169 380.825L440.323 379.979L442.342 381.144L445.179 379.506L446.036 380.181L443.355 381.729L448.234 384.546C448.691 384.81 449.159 384.942 449.637 384.942C450.12 384.939 450.642 384.776 451.204 384.452C451.51 384.275 451.757 384.09 451.944 383.898C452.131 383.706 452.279 383.513 452.388 383.318L453.783 383.538ZM452.975 375.005L460.145 379.145L462.46 377.809L463.497 378.407L457.339 381.962L456.303 381.364L458.836 379.901L452.702 376.36L450.247 377.777L449.21 377.179L452.975 375.005ZM448.088 373.39C448.379 373.222 448.698 373.139 449.046 373.142C449.4 373.142 449.704 373.216 449.958 373.363C450.223 373.516 450.358 373.696 450.364 373.903C450.369 374.104 450.226 374.288 449.935 374.456C449.659 374.615 449.345 374.695 448.992 374.695C448.633 374.692 448.321 374.614 448.056 374.461C447.802 374.314 447.675 374.138 447.675 373.934C447.675 373.73 447.812 373.549 448.088 373.39ZM465.011 368.056L470.233 374.518L468.713 375.396L457.544 372.367L458.931 371.566L468.323 374.244L463.654 368.839L465.011 368.056ZM473.11 368.654C473.77 369.005 474.412 369.234 475.036 369.342C475.654 369.447 476.239 369.452 476.789 369.356C477.335 369.257 477.818 369.086 478.239 368.843C478.66 368.6 478.977 368.345 479.19 368.078C479.408 367.808 479.574 367.499 479.689 367.151L481.17 367.295C481.087 367.691 480.884 368.081 480.562 368.465C480.245 368.846 479.829 369.185 479.315 369.482C478.52 369.941 477.662 370.229 476.743 370.346C475.823 370.463 474.895 370.422 473.96 370.224C473.025 370.02 472.134 369.674 471.287 369.185C470.455 368.705 469.865 368.193 469.517 367.65C469.169 367.107 469.078 366.575 469.245 366.053C469.411 365.531 469.858 365.06 470.585 364.64C471.276 364.241 472.035 363.992 472.861 363.893C473.682 363.791 474.526 363.837 475.394 364.032C476.262 364.221 477.112 364.556 477.943 365.036C478.083 365.117 478.213 365.195 478.333 365.27C478.447 365.342 478.546 365.408 478.629 365.468L473.11 368.654ZM471.676 365.252C471.068 365.603 470.775 366.021 470.796 366.507C470.822 366.99 471.258 367.509 472.105 368.064L476.384 365.594C475.49 365.096 474.638 364.826 473.828 364.784C473.012 364.739 472.295 364.895 471.676 365.252ZM483.315 358.397C482.759 358.076 482.211 357.886 481.67 357.826C481.125 357.763 480.592 357.8 480.072 357.938C479.548 358.073 479.041 358.282 478.553 358.564L477.002 359.459L481.585 362.105L483.081 361.241C483.585 360.95 483.962 360.655 484.211 360.355C484.455 360.052 484.52 359.738 484.406 359.414C484.287 359.087 483.923 358.748 483.315 358.397ZM484.749 357.551C485.586 358.034 486.077 358.525 486.222 359.023C486.373 359.518 486.251 360.011 485.856 360.503C485.461 360.995 484.858 361.475 484.047 361.943L482.676 362.735L486.659 365.035L485.302 365.818L474.57 359.621L477.313 358.037C478.592 357.299 479.87 356.873 481.148 356.759C482.426 356.639 483.627 356.903 484.749 357.551ZM498.5 356.128C498.827 356.317 499.121 356.424 499.38 356.448C499.64 356.472 499.921 356.439 500.222 356.349L500.822 357.064C500.422 357.241 500.001 357.355 499.56 357.406C499.113 357.454 498.648 357.408 498.165 357.267C498.248 357.657 498.167 358.036 497.923 358.405C497.674 358.771 497.281 359.109 496.746 359.418C495.925 359.892 495.047 360.132 494.112 360.138C493.176 360.144 492.327 359.926 491.563 359.485C490.716 358.996 490.396 358.431 490.604 357.789C490.812 357.147 491.539 356.466 492.787 355.746L493.995 355.048L493.309 354.652C492.716 354.31 492.124 354.169 491.532 354.229C490.939 354.283 490.337 354.487 489.723 354.841C489.453 354.997 489.17 355.2 488.874 355.449C488.572 355.695 488.284 355.984 488.009 356.317L486.676 355.944C486.993 355.545 487.333 355.195 487.697 354.895C488.061 354.595 488.443 354.33 488.843 354.099C489.866 353.508 490.872 353.203 491.859 353.185C492.846 353.161 493.748 353.385 494.564 353.856L498.5 356.128ZM496.083 358.648C496.489 358.414 496.775 358.132 496.941 357.802C497.102 357.469 497.12 357.129 496.995 356.781L494.883 355.561L493.698 356.245C492.794 356.767 492.311 357.226 492.249 357.622C492.192 358.015 492.425 358.363 492.95 358.666C493.459 358.96 493.976 359.109 494.501 359.112C495.026 359.109 495.553 358.954 496.083 358.648ZM509.865 351.159C509.772 351.429 509.577 351.71 509.281 352.001C508.985 352.292 508.644 352.548 508.26 352.77C507.376 353.28 506.465 353.54 505.524 353.549C504.583 353.558 503.75 353.352 503.022 352.932L498.127 350.106L496.241 351.195L495.228 350.61L497.114 349.521L495.251 348.446L496.405 347.6L498.423 348.765L501.261 347.127L502.118 347.802L499.437 349.35L504.316 352.167C504.773 352.431 505.241 352.563 505.719 352.563C506.202 352.56 506.724 352.397 507.285 352.073C507.592 351.896 507.839 351.711 508.026 351.519C508.213 351.327 508.361 351.134 508.47 350.939L509.865 351.159ZM502.782 342.289L507.334 344.917C507.225 344.482 507.298 344.068 507.552 343.675C507.807 343.276 508.176 342.937 508.659 342.658C509.459 342.196 510.257 341.981 511.052 342.014C511.847 342.047 512.624 342.283 513.382 342.721L519.345 346.163L518.035 346.919L512.104 343.495C511.61 343.21 511.138 343.069 510.685 343.072C510.228 343.072 509.755 343.213 509.267 343.495C508.955 343.675 508.729 343.886 508.589 344.129C508.449 344.372 508.371 344.618 508.355 344.867C508.339 345.116 508.368 345.346 508.441 345.556L514.419 349.007L513.109 349.763L501.613 343.126L502.782 342.289ZM514.662 334.188L529.175 342.567L525.27 344.821L524.163 344.182L526.829 342.643L514.553 335.556L511.888 337.095L510.757 336.442L514.662 334.188ZM532.333 337.278C532.079 337.131 531.91 336.965 531.827 336.779C531.739 336.59 531.736 336.402 531.819 336.216C531.902 336.024 532.074 335.853 532.333 335.703C532.598 335.55 532.897 335.45 533.23 335.402C533.557 335.351 533.885 335.351 534.212 335.402C534.534 335.45 534.822 335.547 535.077 335.694C535.332 335.841 535.506 336.011 535.599 336.203C535.688 336.392 535.69 336.582 535.607 336.774C535.519 336.963 535.342 337.134 535.077 337.287C534.817 337.437 534.524 337.538 534.196 337.589C533.869 337.634 533.542 337.631 533.214 337.58C532.882 337.526 532.588 337.425 532.333 337.278ZM579.053 308.712C579.417 308.502 579.843 308.4 580.331 308.406C580.819 308.406 581.233 308.504 581.57 308.699C581.763 308.81 581.931 308.934 582.077 309.072C582.228 309.207 582.368 309.381 582.498 309.594L584.135 311.997L582.95 312.681L580.604 310.463C580.022 310.523 579.505 310.422 579.053 310.161C578.705 309.96 578.528 309.72 578.523 309.441C578.523 309.159 578.699 308.916 579.053 308.712ZM573.667 305.603C574.031 305.393 574.454 305.289 574.937 305.292C575.426 305.292 575.844 305.393 576.192 305.594C576.535 305.792 576.712 306.035 576.722 306.323C576.733 306.605 576.556 306.851 576.192 307.061C575.839 307.265 575.416 307.365 574.922 307.362C574.428 307.353 574.01 307.25 573.667 307.052C573.319 306.851 573.142 306.611 573.137 306.332C573.137 306.05 573.314 305.807 573.667 305.603ZM382.852 440.929L383.881 441.523C383.501 441.742 383.195 441.964 382.961 442.189C382.727 442.408 382.615 442.619 382.626 442.823C382.641 443.024 382.821 443.209 383.164 443.377L386.687 445.033C387.17 445.258 387.505 445.481 387.692 445.703C387.879 445.925 387.936 446.15 387.864 446.378C387.796 446.603 387.617 446.839 387.326 447.085C387.752 446.911 388.16 446.801 388.549 446.756C388.934 446.708 389.316 446.74 389.695 446.851C390.069 446.959 390.464 447.16 390.88 447.454L393.748 449.488C394.044 449.689 394.367 449.794 394.715 449.803C395.063 449.812 395.429 449.747 395.814 449.609C396.198 449.471 396.58 449.293 396.959 449.074L397.988 449.668C397.552 449.92 397.095 450.139 396.617 450.325C396.144 450.514 395.663 450.644 395.175 450.716C394.686 450.788 394.205 450.778 393.733 450.685C393.265 450.595 392.818 450.397 392.392 450.091L389.742 448.201C389.425 447.97 389.09 447.815 388.737 447.737C388.388 447.656 387.975 447.682 387.497 447.814C387.019 447.94 386.432 448.204 385.736 448.606L384.691 448.003C385.388 447.601 385.847 447.263 386.071 446.99C386.3 446.714 386.344 446.476 386.203 446.275C386.068 446.071 385.803 445.879 385.408 445.699L382.119 444.16C381.589 443.914 381.246 443.656 381.09 443.386C380.929 443.113 380.909 442.837 381.028 442.558C381.153 442.276 381.379 441.998 381.706 441.725C382.034 441.446 382.415 441.181 382.852 440.929ZM402.511 443.52C402.921 443.283 403.236 443.023 403.454 442.741C403.677 442.456 403.836 442.167 403.929 441.873L405.426 441.999C405.374 442.383 405.184 442.771 404.857 443.164C404.529 443.557 404.124 443.893 403.641 444.172C402.825 444.643 401.955 444.945 401.03 445.077C400.105 445.203 399.175 445.17 398.239 444.978C397.299 444.783 396.4 444.438 395.543 443.943C394.722 443.469 394.137 442.957 393.789 442.408C393.441 441.853 393.365 441.303 393.563 440.757C393.766 440.208 394.277 439.696 395.098 439.222C395.623 438.919 396.195 438.682 396.813 438.511C397.431 438.334 398.091 438.226 398.793 438.187L399.027 439.06C398.434 439.12 397.902 439.218 397.429 439.353C396.956 439.482 396.538 439.651 396.174 439.861C395.467 440.269 395.15 440.758 395.223 441.328C395.296 441.898 395.875 442.497 396.961 443.124C397.689 443.544 398.388 443.827 399.058 443.974C399.728 444.115 400.354 444.144 400.936 444.06C401.518 443.97 402.043 443.79 402.511 443.52ZM403.845 434.172C404.619 433.725 405.443 433.454 406.316 433.358C407.189 433.256 408.075 433.314 408.974 433.533C409.878 433.749 410.764 434.108 411.632 434.609C412.468 435.092 413.074 435.597 413.448 436.125C413.822 436.653 413.931 437.175 413.775 437.691C413.619 438.201 413.157 438.678 412.388 439.122C411.619 439.566 410.795 439.838 409.917 439.937C409.039 440.036 408.145 439.979 407.236 439.766C406.326 439.547 405.443 439.19 404.586 438.695C403.739 438.206 403.128 437.697 402.754 437.169C402.38 436.641 402.276 436.122 402.442 435.612C402.608 435.096 403.076 434.616 403.845 434.172ZM404.913 434.789C404.206 435.197 403.934 435.657 404.095 436.17C404.256 436.677 404.887 437.249 405.989 437.885C407.069 438.509 408.049 438.87 408.927 438.969C409.81 439.065 410.605 438.909 411.312 438.501C412.019 438.093 412.286 437.636 412.115 437.129C411.949 436.619 411.32 436.049 410.229 435.419C409.137 434.789 408.155 434.426 407.282 434.33C406.404 434.231 405.614 434.384 404.913 434.789ZM411.68 425.842L413.153 425.18L424.665 431.827L423.52 432.488L422.311 431.935C422.441 432.364 422.408 432.752 422.21 433.1C422.018 433.445 421.696 433.748 421.244 434.009C420.532 434.42 419.765 434.656 418.944 434.716C418.123 434.776 417.282 434.686 416.419 434.446C415.551 434.203 414.694 433.837 413.847 433.348C413.026 432.874 412.421 432.377 412.031 431.858C411.636 431.336 411.493 430.831 411.602 430.342C411.711 429.847 412.104 429.404 412.779 429.014C413.252 428.741 413.751 428.549 414.276 428.438C414.795 428.324 415.351 428.279 415.944 428.303L411.68 425.842ZM414.174 429.424C413.488 429.82 413.229 430.279 413.395 430.801C413.561 431.323 414.187 431.897 415.273 432.524C415.98 432.932 416.648 433.231 417.276 433.42C417.905 433.609 418.484 433.688 419.014 433.658C419.55 433.625 420.03 433.486 420.456 433.24C420.924 432.97 421.189 432.664 421.251 432.322C421.319 431.977 421.296 431.645 421.181 431.327L417.081 428.96C416.525 428.897 415.998 428.905 415.499 428.983C414.995 429.058 414.554 429.205 414.174 429.424ZM425.181 427.326C425.841 427.677 426.483 427.906 427.107 428.014C427.725 428.119 428.309 428.124 428.86 428.028C429.406 427.929 429.889 427.758 430.31 427.515C430.731 427.272 431.048 427.017 431.261 426.75C431.479 426.48 431.645 426.171 431.76 425.823L433.241 425.967C433.157 426.363 432.955 426.753 432.633 427.137C432.316 427.518 431.9 427.857 431.386 428.154C430.591 428.613 429.733 428.901 428.813 429.018C427.894 429.135 426.966 429.094 426.031 428.896C425.096 428.692 424.205 428.346 423.358 427.857C422.526 427.377 421.936 426.865 421.588 426.322C421.24 425.779 421.149 425.247 421.315 424.725C421.482 424.203 421.929 423.732 422.656 423.312C423.347 422.913 424.106 422.664 424.932 422.565C425.753 422.463 426.597 422.509 427.465 422.704C428.333 422.893 429.182 423.228 430.014 423.708C430.154 423.789 430.284 423.867 430.404 423.942C430.518 424.014 430.617 424.08 430.7 424.14L425.181 427.326ZM423.747 423.924C423.139 424.275 422.846 424.693 422.866 425.179C422.892 425.662 423.329 426.181 424.176 426.736L428.455 424.266C427.561 423.768 426.709 423.498 425.898 423.456C425.083 423.411 424.366 423.567 423.747 423.924ZM424.864 416.673C425.3 416.421 425.757 416.202 426.235 416.016C426.708 415.827 427.189 415.697 427.677 415.625C428.166 415.553 428.646 415.563 429.119 415.656C429.592 415.743 430.039 415.941 430.46 416.25L433.125 418.149C433.437 418.377 433.78 418.524 434.154 418.59C434.534 418.653 434.962 418.619 435.44 418.487C435.918 418.355 436.477 418.104 437.116 417.735L438.16 418.338C437.527 418.704 437.095 419.028 436.867 419.31C436.638 419.586 436.578 419.834 436.687 420.053C436.802 420.269 437.059 420.468 437.459 420.651L440.733 422.181C441.263 422.427 441.606 422.685 441.761 422.955C441.922 423.228 441.941 423.506 441.816 423.788C441.696 424.067 441.47 424.344 441.138 424.62C440.816 424.896 440.436 425.16 440 425.412L438.971 424.818C439.35 424.599 439.657 424.38 439.891 424.161C440.13 423.939 440.244 423.726 440.234 423.522C440.223 423.318 440.041 423.132 439.688 422.964L436.165 421.308C435.656 421.068 435.31 420.839 435.129 420.62C434.941 420.398 434.9 420.17 435.004 419.936C435.113 419.699 435.349 419.442 435.713 419.166C435.24 419.361 434.791 419.486 434.365 419.54C433.944 419.591 433.539 419.564 433.149 419.459C432.759 419.354 432.367 419.163 431.972 418.887L429.104 416.853C428.818 416.652 428.498 416.549 428.145 416.543C427.792 416.537 427.425 416.601 427.046 416.736C426.661 416.868 426.277 417.045 425.892 417.267L424.864 416.673ZM503.083 383.573C503.446 383.363 503.873 383.261 504.361 383.267C504.849 383.267 505.263 383.365 505.6 383.56C505.793 383.671 505.961 383.795 506.107 383.933C506.258 384.068 506.398 384.242 506.528 384.455L508.165 386.858L506.98 387.542L504.634 385.324C504.052 385.384 503.535 385.283 503.083 385.022C502.735 384.821 502.558 384.581 502.553 384.302C502.553 384.02 502.729 383.777 503.083 383.573ZM497.697 380.464C498.061 380.254 498.484 380.15 498.967 380.153C499.456 380.153 499.874 380.254 500.222 380.455C500.565 380.653 500.742 380.896 500.752 381.184C500.763 381.466 500.586 381.712 500.222 381.922C499.869 382.126 499.445 382.226 498.952 382.223C498.458 382.214 498.04 382.111 497.697 381.913C497.349 381.712 497.172 381.472 497.167 381.193C497.167 380.911 497.344 380.668 497.697 380.464ZM274.118 534.706C274.554 534.454 275.011 534.235 275.489 534.049C275.962 533.86 276.443 533.73 276.931 533.658C277.42 533.586 277.9 533.596 278.373 533.689C278.846 533.776 279.293 533.974 279.714 534.283L282.379 536.182C282.691 536.41 283.034 536.557 283.408 536.623C283.788 536.686 284.216 536.652 284.694 536.52C285.172 536.388 285.731 536.137 286.37 535.768L287.415 536.371C286.781 536.737 286.349 537.061 286.121 537.343C285.892 537.619 285.832 537.867 285.941 538.086C286.056 538.302 286.313 538.501 286.713 538.684L289.987 540.214C290.517 540.46 290.86 540.718 291.015 540.988C291.177 541.261 291.195 541.539 291.07 541.821C290.951 542.1 290.724 542.377 290.392 542.653C290.07 542.93 289.69 543.194 289.254 543.446L288.225 542.851C288.604 542.633 288.911 542.413 289.145 542.194C289.384 541.972 289.498 541.759 289.488 541.555C289.477 541.351 289.296 541.165 288.942 540.997L285.419 539.341C284.91 539.101 284.564 538.872 284.383 538.653C284.196 538.431 284.154 538.203 284.258 537.969C284.367 537.732 284.603 537.475 284.967 537.199C284.494 537.394 284.045 537.519 283.619 537.573C283.198 537.624 282.793 537.597 282.403 537.492C282.013 537.387 281.621 537.196 281.226 536.92L278.358 534.886C278.072 534.685 277.752 534.582 277.399 534.576C277.046 534.57 276.679 534.634 276.3 534.769C275.915 534.901 275.531 535.078 275.146 535.3L274.118 534.706ZM296.255 533.986C296.619 533.776 297.045 533.674 297.533 533.68C298.022 533.68 298.435 533.777 298.772 533.972C298.965 534.083 299.134 534.208 299.279 534.346C299.43 534.481 299.57 534.655 299.7 534.868L301.337 537.271L300.152 537.955L297.806 535.736C297.224 535.796 296.707 535.696 296.255 535.435C295.907 535.234 295.73 534.994 295.725 534.715C295.725 534.433 295.902 534.19 296.255 533.986ZM290.869 530.876C291.233 530.666 291.656 530.563 292.14 530.566C292.628 530.566 293.046 530.666 293.394 530.867C293.737 531.065 293.914 531.308 293.924 531.596C293.935 531.878 293.758 532.124 293.394 532.334C293.041 532.538 292.618 532.639 292.124 532.636C291.63 532.627 291.212 532.523 290.869 532.325C290.521 532.124 290.344 531.884 290.339 531.605C290.339 531.323 290.516 531.08 290.869 530.876Z"
            fill="#DFDFDF"
          />
          <path
            d="M334.63 254.217C335.436 253.752 336.236 253.431 337.031 253.254C337.826 253.071 338.608 253.001 339.377 253.043C340.151 253.082 340.91 253.208 341.653 253.421C342.396 253.628 343.116 253.89 343.812 254.208C344.503 254.523 345.168 254.865 345.807 255.234C347.117 255.99 348.143 256.655 348.886 257.228C349.629 257.795 350.05 258.296 350.149 258.731C350.253 259.169 349.99 259.569 349.361 259.932C349.039 260.118 348.683 260.234 348.294 260.279C347.904 260.324 347.514 260.321 347.124 260.27C346.74 260.222 346.389 260.145 346.072 260.04C345.75 259.932 345.498 259.823 345.316 259.712L345.254 259.748C345.399 259.94 345.501 260.154 345.558 260.391C345.615 260.622 345.579 260.862 345.449 261.111C345.324 261.363 345.054 261.609 344.638 261.849C344.072 262.176 343.461 262.352 342.806 262.376C342.157 262.397 341.484 262.296 340.788 262.074C340.091 261.852 339.4 261.543 338.715 261.147C337.358 260.364 336.62 259.626 336.501 258.933C336.376 258.237 336.792 257.613 337.748 257.061C338.112 256.851 338.499 256.673 338.909 256.526C339.32 256.379 339.86 256.247 340.531 256.13L345.137 258.789C345.698 259.113 346.176 259.332 346.571 259.446C346.961 259.557 347.293 259.596 347.569 259.563C347.844 259.53 348.083 259.455 348.286 259.338C348.53 259.197 348.598 259.017 348.488 258.798C348.379 258.579 348.135 258.327 347.756 258.042C347.377 257.757 346.904 257.445 346.337 257.106C345.766 256.764 345.147 256.401 344.482 256.017C343.739 255.588 343.004 255.212 342.276 254.888C341.544 254.561 340.816 254.324 340.094 254.177C339.372 254.03 338.652 254.004 337.935 254.1C337.218 254.196 336.501 254.451 335.784 254.865C335.28 255.156 334.823 255.528 334.412 255.981C334.002 256.428 333.757 257.013 333.679 257.736L332.058 257.664C332.147 256.911 332.425 256.25 332.892 255.68C333.36 255.104 333.939 254.616 334.63 254.217ZM338.777 257.583C338.065 257.994 337.836 258.423 338.091 258.87C338.346 259.317 338.977 259.832 339.985 260.414C340.494 260.708 340.98 260.946 341.442 261.129C341.905 261.306 342.339 261.407 342.744 261.431C343.144 261.452 343.5 261.372 343.812 261.192C344.176 260.982 344.378 260.769 344.42 260.553C344.467 260.334 344.438 260.132 344.334 259.946C344.23 259.754 344.134 259.596 344.046 259.473L340.008 257.142C339.546 257.229 339.135 257.376 338.777 257.583ZM354.788 254.072C355.198 253.835 355.513 253.576 355.731 253.294C355.954 253.009 356.113 252.719 356.206 252.425L357.703 252.551C357.651 252.935 357.461 253.324 357.134 253.717C356.807 254.11 356.401 254.446 355.918 254.725C355.102 255.196 354.232 255.497 353.307 255.629C352.382 255.755 351.452 255.722 350.517 255.53C349.576 255.335 348.677 254.99 347.82 254.495C346.999 254.021 346.414 253.51 346.066 252.961C345.718 252.406 345.643 251.855 345.84 251.309C346.043 250.76 346.555 250.249 347.376 249.775C347.9 249.472 348.472 249.235 349.09 249.064C349.709 248.887 350.369 248.779 351.07 248.74L351.304 249.613C350.712 249.673 350.179 249.77 349.706 249.905C349.233 250.034 348.815 250.204 348.451 250.414C347.745 250.822 347.428 251.311 347.5 251.881C347.573 252.451 348.152 253.049 349.238 253.676C349.966 254.096 350.665 254.38 351.335 254.527C352.005 254.668 352.632 254.696 353.213 254.612C353.795 254.522 354.32 254.342 354.788 254.072ZM356.122 244.725C356.897 244.278 357.72 244.006 358.593 243.91C359.466 243.808 360.352 243.867 361.251 244.086C362.155 244.302 363.041 244.66 363.909 245.161C364.745 245.644 365.351 246.15 365.725 246.678C366.099 247.206 366.208 247.728 366.052 248.244C365.896 248.754 365.434 249.231 364.665 249.675C363.896 250.119 363.072 250.39 362.194 250.489C361.316 250.588 360.422 250.531 359.513 250.318C358.604 250.099 357.72 249.742 356.863 249.247C356.016 248.758 355.405 248.25 355.031 247.722C354.657 247.194 354.553 246.675 354.719 246.165C354.886 245.649 355.353 245.169 356.122 244.725ZM357.19 245.341C356.484 245.749 356.211 246.21 356.372 246.723C356.533 247.23 357.164 247.801 358.266 248.437C359.347 249.061 360.326 249.423 361.204 249.522C362.088 249.618 362.883 249.462 363.589 249.054C364.296 248.646 364.564 248.188 364.392 247.681C364.226 247.171 363.597 246.601 362.506 245.971C361.415 245.341 360.433 244.978 359.56 244.882C358.682 244.783 357.892 244.936 357.19 245.341ZM363.957 236.394L365.43 235.733L376.943 242.379L375.797 243.041L374.589 242.487C374.719 242.916 374.685 243.305 374.487 243.653C374.295 243.998 373.973 244.301 373.521 244.562C372.809 244.973 372.043 245.208 371.222 245.268C370.401 245.328 369.559 245.238 368.696 244.998C367.828 244.755 366.971 244.389 366.124 243.9C365.303 243.426 364.698 242.93 364.308 242.411C363.913 241.889 363.77 241.383 363.879 240.894C363.989 240.399 364.381 239.957 365.056 239.567C365.529 239.294 366.028 239.102 366.553 238.991C367.072 238.877 367.628 238.832 368.221 238.856L363.957 236.394ZM366.452 239.976C365.766 240.372 365.506 240.831 365.672 241.353C365.838 241.875 366.464 242.45 367.55 243.077C368.257 243.485 368.925 243.783 369.554 243.972C370.182 244.161 370.762 244.241 371.292 244.211C371.827 244.178 372.308 244.038 372.734 243.792C373.201 243.522 373.466 243.216 373.529 242.874C373.596 242.529 373.573 242.198 373.459 241.88L369.359 239.513C368.803 239.45 368.275 239.457 367.777 239.535C367.272 239.61 366.831 239.757 366.452 239.976ZM377.459 237.879C378.119 238.23 378.76 238.459 379.384 238.567C380.002 238.672 380.587 238.677 381.138 238.581C381.683 238.482 382.166 238.311 382.587 238.068C383.008 237.825 383.325 237.57 383.538 237.303C383.756 237.033 383.923 236.724 384.037 236.376L385.518 236.52C385.435 236.916 385.232 237.306 384.91 237.69C384.593 238.071 384.177 238.41 383.663 238.707C382.868 239.166 382.01 239.454 381.091 239.571C380.171 239.688 379.244 239.647 378.308 239.449C377.373 239.245 376.482 238.899 375.635 238.41C374.803 237.93 374.214 237.418 373.866 236.875C373.517 236.332 373.426 235.8 373.593 235.278C373.759 234.756 374.206 234.285 374.933 233.865C375.624 233.466 376.383 233.217 377.209 233.118C378.03 233.016 378.875 233.062 379.742 233.257C380.61 233.446 381.46 233.781 382.291 234.261C382.431 234.342 382.561 234.42 382.681 234.495C382.795 234.567 382.894 234.633 382.977 234.693L377.459 237.879ZM376.025 234.477C375.417 234.828 375.123 235.246 375.144 235.732C375.17 236.215 375.606 236.734 376.453 237.289L380.732 234.819C379.838 234.321 378.986 234.051 378.176 234.009C377.36 233.964 376.643 234.12 376.025 234.477ZM391.303 233.045C391.932 232.682 392.311 232.328 392.441 231.983C392.571 231.632 392.438 231.342 392.043 231.114C391.794 230.97 391.532 230.873 391.256 230.822C390.986 230.768 390.638 230.78 390.212 230.858C389.786 230.936 389.209 231.101 388.481 231.353C387.775 231.599 387.12 231.791 386.517 231.929C385.915 232.061 385.348 232.109 384.818 232.073C384.293 232.034 383.794 231.878 383.322 231.605C382.859 231.338 382.592 231.033 382.519 230.691C382.446 230.343 382.555 229.983 382.846 229.611C383.132 229.236 383.584 228.87 384.202 228.513C384.862 228.132 385.525 227.852 386.19 227.672C386.855 227.486 387.486 227.367 388.084 227.316L388.396 228.162C387.871 228.219 387.354 228.317 386.845 228.455C386.33 228.59 385.808 228.81 385.278 229.116C384.634 229.488 384.278 229.811 384.21 230.084C384.137 230.354 384.26 230.58 384.576 230.763C384.816 230.901 385.081 230.979 385.372 230.997C385.662 231.009 386.031 230.961 386.478 230.853C386.92 230.742 387.494 230.57 388.201 230.336C388.876 230.108 389.51 229.937 390.103 229.823C390.7 229.706 391.272 229.676 391.817 229.733C392.363 229.79 392.89 229.965 393.4 230.259C393.982 230.595 394.288 230.964 394.319 231.366C394.345 231.765 394.176 232.166 393.813 232.568C393.449 232.964 392.973 233.331 392.386 233.67C391.643 234.099 390.903 234.404 390.165 234.584C389.427 234.758 388.728 234.858 388.068 234.885L387.951 233.954C388.539 233.921 389.123 233.832 389.705 233.688C390.287 233.538 390.82 233.324 391.303 233.045ZM402.848 225.353C403.175 225.542 403.469 225.649 403.729 225.673C403.988 225.697 404.269 225.664 404.57 225.574L405.171 226.289C404.77 226.466 404.35 226.58 403.908 226.631C403.461 226.679 402.996 226.633 402.513 226.492C402.596 226.882 402.515 227.261 402.271 227.63C402.022 227.996 401.629 228.334 401.094 228.643C400.273 229.117 399.395 229.357 398.46 229.363C397.524 229.369 396.675 229.151 395.911 228.71C395.064 228.221 394.744 227.656 394.952 227.014C395.16 226.372 395.888 225.691 397.135 224.971L398.343 224.273L397.657 223.877C397.065 223.535 396.472 223.394 395.88 223.454C395.287 223.508 394.685 223.712 394.072 224.066C393.801 224.222 393.518 224.425 393.222 224.674C392.921 224.92 392.632 225.209 392.357 225.542L391.024 225.169C391.341 224.77 391.681 224.42 392.045 224.12C392.409 223.82 392.791 223.555 393.191 223.324C394.214 222.733 395.22 222.428 396.207 222.41C397.194 222.386 398.096 222.61 398.912 223.081L402.848 225.353ZM400.432 227.873C400.837 227.639 401.123 227.357 401.289 227.027C401.45 226.694 401.468 226.354 401.344 226.006L399.231 224.786L398.047 225.47C397.142 225.992 396.659 226.451 396.597 226.847C396.54 227.24 396.774 227.588 397.298 227.891C397.808 228.185 398.325 228.334 398.849 228.337C399.374 228.334 399.902 228.179 400.432 227.873ZM408.111 224.385L399.903 219.646L401.018 219.003L402.257 219.601C402.169 219.166 402.262 218.74 402.538 218.323C402.813 217.9 403.187 217.552 403.66 217.279C404.466 216.814 405.263 216.6 406.053 216.636C406.848 216.669 407.625 216.904 408.383 217.342L414.346 220.785L413.037 221.541L408.041 218.656C407.479 218.332 406.996 218.089 406.591 217.927C406.18 217.762 405.798 217.692 405.445 217.716C405.087 217.737 404.699 217.867 404.284 218.107C403.962 218.293 403.728 218.509 403.582 218.755C403.442 218.998 403.367 219.246 403.356 219.498C403.346 219.744 403.374 219.97 403.442 220.177L409.42 223.629L408.111 224.385ZM410.692 209.412L412.165 208.751L423.677 215.397L422.532 216.059L421.324 215.505C421.454 215.934 421.42 216.323 421.222 216.671C421.03 217.016 420.708 217.319 420.256 217.58C419.544 217.991 418.777 218.226 417.956 218.286C417.136 218.346 416.294 218.256 415.431 218.016C414.563 217.773 413.706 217.407 412.859 216.918C412.038 216.444 411.433 215.948 411.043 215.429C410.648 214.907 410.505 214.401 410.614 213.912C410.723 213.417 411.116 212.975 411.791 212.585C412.264 212.312 412.763 212.12 413.288 212.009C413.807 211.895 414.363 211.85 414.956 211.874L410.692 209.412ZM413.186 212.994C412.501 213.39 412.241 213.849 412.407 214.371C412.573 214.893 413.199 215.468 414.285 216.095C414.992 216.503 415.66 216.801 416.289 216.99C416.917 217.179 417.497 217.259 418.027 217.229C418.562 217.196 419.042 217.056 419.469 216.81C419.936 216.54 420.201 216.234 420.264 215.892C420.331 215.547 420.308 215.216 420.193 214.898L416.094 212.531C415.538 212.468 415.01 212.475 414.511 212.553C414.007 212.628 413.566 212.775 413.186 212.994ZM420.975 208.714C420.881 208.312 420.923 207.937 421.099 207.589C421.276 207.235 421.601 206.921 422.074 206.648C422.806 206.225 423.575 205.985 424.381 205.928C425.186 205.871 426.015 205.969 426.867 206.221C427.714 206.47 428.566 206.842 429.424 207.337C430.25 207.814 430.863 208.312 431.263 208.831C431.658 209.347 431.798 209.851 431.684 210.343C431.575 210.832 431.167 211.28 430.46 211.688C429.509 212.237 428.421 212.47 427.194 212.386L427.95 212.93L426.805 213.592L415.293 206.945L416.438 206.095L420.975 208.714ZM429.088 211.256C429.774 210.86 430.037 210.403 429.876 209.884C429.714 209.365 429.086 208.789 427.989 208.156C427.272 207.742 426.605 207.44 425.986 207.251C425.363 207.059 424.789 206.98 424.264 207.013C423.739 207.04 423.266 207.175 422.845 207.418C422.388 207.682 422.123 207.994 422.05 208.354C421.977 208.708 421.996 209.045 422.105 209.366L426.173 211.715C426.709 211.778 427.233 211.772 427.748 211.697C428.267 211.619 428.714 211.472 429.088 211.256ZM430.898 201.553C431.673 201.106 432.496 200.835 433.369 200.739C434.242 200.637 435.128 200.695 436.027 200.914C436.931 201.13 437.817 201.489 438.685 201.99C439.521 202.473 440.127 202.978 440.501 203.506C440.875 204.034 440.984 204.556 440.828 205.072C440.672 205.582 440.21 206.059 439.441 206.503C438.672 206.947 437.848 207.219 436.97 207.318C436.092 207.417 435.198 207.36 434.289 207.147C433.379 206.928 432.496 206.571 431.639 206.076C430.792 205.587 430.181 205.078 429.807 204.55C429.433 204.022 429.329 203.503 429.495 202.993C429.662 202.477 430.129 201.997 430.898 201.553ZM431.966 202.17C431.259 202.578 430.987 203.038 431.148 203.551C431.309 204.058 431.94 204.63 433.042 205.266C434.123 205.89 435.102 206.251 435.98 206.35C436.864 206.446 437.659 206.29 438.365 205.882C439.072 205.474 439.339 205.017 439.168 204.51C439.002 204 438.373 203.43 437.282 202.8C436.191 202.17 435.209 201.807 434.336 201.711C433.457 201.612 432.668 201.765 431.966 202.17ZM446.294 202.34L444.797 203.204L443.496 198.951L436.964 198.249L438.515 197.354L443.472 198.02L442.342 195.144L443.838 194.28L445.008 198.015L452.42 198.803L450.814 199.73L445.047 198.992L446.294 202.34ZM456.763 198.149L455.235 198.491L448.15 186.697L449.709 186.391L456.763 198.149ZM466.079 189.873C466.708 189.51 467.087 189.156 467.217 188.811C467.347 188.46 467.214 188.17 466.819 187.942C466.57 187.798 466.307 187.701 466.032 187.65C465.762 187.596 465.414 187.608 464.988 187.686C464.562 187.764 463.985 187.929 463.257 188.181C462.551 188.427 461.896 188.619 461.293 188.757C460.69 188.889 460.124 188.937 459.594 188.901C459.069 188.862 458.57 188.706 458.098 188.433C457.635 188.166 457.367 187.861 457.295 187.519C457.222 187.171 457.331 186.811 457.622 186.439C457.908 186.064 458.36 185.698 458.978 185.341C459.638 184.96 460.301 184.68 460.966 184.5C461.631 184.314 462.262 184.195 462.86 184.144L463.172 184.99C462.647 185.047 462.13 185.145 461.62 185.283C461.106 185.418 460.584 185.638 460.054 185.944C459.41 186.316 459.054 186.639 458.986 186.912C458.913 187.182 459.035 187.408 459.352 187.591C459.591 187.729 459.856 187.807 460.147 187.825C460.438 187.837 460.807 187.789 461.254 187.681C461.696 187.57 462.27 187.398 462.977 187.164C463.652 186.936 464.286 186.765 464.878 186.651C465.476 186.534 466.048 186.504 466.593 186.561C467.139 186.618 467.666 186.793 468.175 187.087C468.757 187.423 469.064 187.792 469.095 188.194C469.121 188.593 468.952 188.994 468.589 189.396C468.225 189.792 467.749 190.159 467.162 190.498C466.419 190.927 465.679 191.232 464.941 191.412C464.203 191.586 463.504 191.686 462.844 191.713L462.727 190.782C463.314 190.749 463.899 190.66 464.481 190.516C465.063 190.366 465.596 190.152 466.079 189.873ZM477.624 182.181C477.951 182.37 478.245 182.477 478.505 182.501C478.764 182.525 479.045 182.492 479.346 182.402L479.946 183.117C479.546 183.294 479.125 183.408 478.684 183.459C478.237 183.507 477.772 183.461 477.289 183.32C477.372 183.71 477.291 184.089 477.047 184.458C476.798 184.824 476.405 185.162 475.87 185.471C475.049 185.945 474.171 186.185 473.236 186.191C472.3 186.197 471.451 185.979 470.687 185.538C469.84 185.049 469.52 184.484 469.728 183.842C469.936 183.2 470.664 182.519 471.911 181.799L473.119 181.101L472.433 180.705C471.84 180.363 471.248 180.222 470.656 180.282C470.063 180.336 469.461 180.54 468.847 180.894C468.577 181.05 468.294 181.253 467.998 181.502C467.697 181.748 467.408 182.037 467.133 182.37L465.8 181.997C466.117 181.598 466.457 181.248 466.821 180.948C467.185 180.648 467.567 180.383 467.967 180.152C468.99 179.561 469.996 179.256 470.983 179.238C471.97 179.214 472.872 179.438 473.688 179.909L477.624 182.181ZM475.208 184.701C475.613 184.467 475.899 184.185 476.065 183.855C476.226 183.522 476.244 183.182 476.119 182.834L474.007 181.614L472.823 182.298C471.918 182.82 471.435 183.279 471.373 183.675C471.316 184.068 471.549 184.416 472.074 184.719C472.583 185.013 473.101 185.162 473.625 185.165C474.15 185.162 474.678 185.007 475.208 184.701ZM482.887 181.213L474.679 176.474L475.794 175.831L477.033 176.429C476.945 175.994 477.038 175.568 477.314 175.151C477.589 174.728 477.963 174.38 478.436 174.107C479.241 173.642 480.039 173.428 480.829 173.464C481.624 173.497 482.401 173.732 483.159 174.17L489.122 177.613L487.813 178.369L482.816 175.484C482.255 175.16 481.772 174.917 481.367 174.755C480.956 174.59 480.574 174.52 480.221 174.544C479.862 174.565 479.475 174.695 479.06 174.935C478.737 175.121 478.504 175.337 478.358 175.583C478.218 175.826 478.142 176.074 478.132 176.326C478.122 176.572 478.15 176.798 478.218 177.005L484.196 180.457L482.887 181.213ZM485.468 166.24L486.941 165.579L498.453 172.225L497.308 172.887L496.099 172.333C496.229 172.762 496.196 173.151 495.998 173.499C495.806 173.844 495.484 174.147 495.032 174.408C494.32 174.819 493.553 175.054 492.732 175.114C491.911 175.174 491.07 175.084 490.207 174.844C489.339 174.601 488.482 174.235 487.635 173.746C486.814 173.272 486.209 172.776 485.819 172.257C485.424 171.735 485.281 171.229 485.39 170.74C485.499 170.245 485.892 169.803 486.567 169.413C487.04 169.14 487.539 168.948 488.064 168.837C488.583 168.723 489.139 168.678 489.732 168.702L485.468 166.24ZM487.962 169.822C487.276 170.218 487.017 170.677 487.183 171.199C487.349 171.721 487.975 172.296 489.061 172.923C489.768 173.331 490.436 173.629 491.064 173.818C491.693 174.007 492.273 174.087 492.803 174.057C493.338 174.024 493.818 173.884 494.244 173.638C494.712 173.368 494.977 173.062 495.039 172.72C495.107 172.375 495.084 172.044 494.969 171.726L490.87 169.359C490.314 169.296 489.786 169.303 489.287 169.381C488.783 169.456 488.342 169.603 487.962 169.822ZM496.873 163.463C497.6 163.043 498.356 162.81 499.141 162.765C499.931 162.717 500.744 162.824 501.581 163.085C502.412 163.343 503.256 163.719 504.114 164.214C504.94 164.691 505.561 165.185 505.976 165.695C506.392 166.199 506.551 166.692 506.452 167.175C506.353 167.658 505.948 168.105 505.236 168.516C504.337 169.035 503.298 169.269 502.118 169.218L506.031 171.477L504.885 172.328L493.373 165.681L494.488 165.038L495.743 165.636C495.623 165.219 495.657 164.825 495.844 164.453C496.036 164.078 496.379 163.748 496.873 163.463ZM497.613 164.25C497.161 164.511 496.899 164.822 496.826 165.182C496.753 165.536 496.771 165.873 496.881 166.194L500.949 168.543C501.479 168.603 501.999 168.594 502.508 168.516C503.017 168.432 503.467 168.278 503.856 168.053C504.537 167.66 504.789 167.214 504.612 166.716C504.436 166.218 503.799 165.653 502.703 165.02C501.986 164.606 501.323 164.301 500.715 164.106C500.102 163.908 499.541 163.821 499.032 163.845C498.517 163.866 498.045 164.001 497.613 164.25ZM515.012 160.595C515.339 160.784 515.633 160.891 515.892 160.915C516.152 160.939 516.433 160.906 516.734 160.816L517.334 161.531C516.934 161.708 516.513 161.822 516.072 161.873C515.625 161.921 515.16 161.875 514.677 161.734C514.76 162.124 514.679 162.503 514.435 162.872C514.186 163.238 513.793 163.576 513.258 163.885C512.437 164.359 511.559 164.599 510.624 164.605C509.688 164.611 508.839 164.393 508.075 163.952C507.228 163.463 506.908 162.898 507.116 162.256C507.324 161.614 508.051 160.933 509.299 160.213L510.507 159.515L509.821 159.119C509.228 158.777 508.636 158.636 508.044 158.696C507.451 158.75 506.849 158.954 506.235 159.308C505.965 159.464 505.682 159.667 505.386 159.916C505.084 160.162 504.796 160.451 504.521 160.784L503.188 160.411C503.505 160.012 503.845 159.662 504.209 159.362C504.573 159.062 504.955 158.797 505.355 158.566C506.378 157.975 507.384 157.67 508.371 157.652C509.358 157.628 510.26 157.852 511.076 158.323L515.012 160.595ZM512.595 163.115C513.001 162.881 513.287 162.599 513.453 162.269C513.614 161.936 513.632 161.596 513.507 161.248L511.395 160.028L510.21 160.712C509.306 161.234 508.823 161.693 508.761 162.089C508.704 162.482 508.937 162.83 509.462 163.133C509.971 163.427 510.488 163.576 511.013 163.579C511.538 163.576 512.065 163.421 512.595 163.115ZM523.034 156.936C523.444 156.699 523.759 156.439 523.977 156.157C524.2 155.872 524.359 155.583 524.452 155.289L525.949 155.415C525.897 155.799 525.707 156.187 525.38 156.58C525.052 156.973 524.647 157.309 524.164 157.588C523.348 158.059 522.478 158.361 521.553 158.493C520.628 158.619 519.698 158.586 518.762 158.394C517.822 158.199 516.923 157.854 516.066 157.359C515.245 156.885 514.66 156.373 514.312 155.824C513.964 155.269 513.888 154.719 514.086 154.173C514.289 153.624 514.8 153.112 515.621 152.638C516.146 152.335 516.718 152.098 517.336 151.927C517.954 151.75 518.614 151.642 519.316 151.603L519.55 152.476C518.957 152.536 518.425 152.634 517.952 152.769C517.479 152.898 517.061 153.067 516.697 153.277C515.99 153.685 515.673 154.174 515.746 154.744C515.819 155.314 516.398 155.913 517.484 156.54C518.212 156.96 518.911 157.243 519.581 157.39C520.251 157.531 520.877 157.56 521.459 157.476C522.041 157.386 522.566 157.206 523.034 156.936ZM528.289 145.523L528.289 149.789L536.925 150.014L535.202 151.008L526.683 150.752L526.59 146.504L528.289 145.523ZM519.341 146.684L531.017 153.425L529.707 154.181L518.195 147.534L519.341 146.684ZM535.266 146.714L534.128 146.057L540.379 142.448L541.517 143.105L535.266 146.714ZM548.393 143.392L547.388 142.812L548.666 142.074L542.47 138.496L541.192 139.234L540.186 138.654L542.462 137.34L544.644 138.321C544.286 137.748 544.148 137.224 544.231 136.75C544.314 136.276 544.728 135.825 545.471 135.396C545.699 135.264 545.92 135.157 546.133 135.076C546.346 134.989 546.572 134.907 546.811 134.829L547.598 135.724C547.38 135.796 547.19 135.867 547.029 135.936C546.863 136.002 546.689 136.087 546.507 136.192C545.878 136.555 545.562 136.996 545.556 137.515C545.551 138.034 545.865 138.633 546.499 139.311L549.976 141.318L551.644 140.355L552.649 140.935L548.393 143.392ZM548.323 137.16L546.538 136.129L545.681 135.481L546.811 134.829L549.399 136.539L548.323 137.16ZM555.051 135.345C555.711 135.696 556.353 135.926 556.977 136.034C557.595 136.139 558.179 136.143 558.73 136.047C559.276 135.948 559.759 135.777 560.18 135.534C560.601 135.291 560.918 135.036 561.131 134.769C561.349 134.499 561.515 134.19 561.63 133.842L563.111 133.986C563.027 134.382 562.825 134.772 562.503 135.156C562.186 135.537 561.77 135.876 561.256 136.173C560.461 136.632 559.603 136.92 558.683 137.037C557.764 137.154 556.836 137.114 555.901 136.916C554.966 136.712 554.075 136.365 553.228 135.876C552.396 135.396 551.806 134.885 551.458 134.342C551.11 133.799 551.019 133.266 551.185 132.744C551.352 132.222 551.799 131.751 552.526 131.331C553.217 130.932 553.976 130.683 554.802 130.584C555.623 130.482 556.467 130.529 557.335 130.724C558.203 130.913 559.052 131.247 559.884 131.727C560.024 131.808 560.154 131.886 560.274 131.961C560.388 132.033 560.487 132.099 560.57 132.159L555.051 135.345ZM553.617 131.943C553.009 132.294 552.716 132.713 552.736 133.199C552.762 133.682 553.199 134.201 554.046 134.756L558.325 132.285C557.431 131.787 556.579 131.517 555.768 131.475C554.953 131.43 554.236 131.586 553.617 131.943ZM571.094 128.216C571.421 128.405 571.715 128.512 571.974 128.536C572.234 128.56 572.515 128.527 572.816 128.437L573.416 129.152C573.016 129.329 572.595 129.443 572.154 129.494C571.707 129.542 571.242 129.496 570.758 129.355C570.842 129.745 570.761 130.124 570.517 130.493C570.267 130.859 569.875 131.197 569.34 131.506C568.519 131.98 567.641 132.22 566.705 132.226C565.77 132.232 564.921 132.014 564.157 131.573C563.31 131.084 562.99 130.519 563.198 129.877C563.406 129.235 564.133 128.554 565.38 127.834L566.589 127.136L565.903 126.74C565.31 126.398 564.718 126.257 564.126 126.317C563.533 126.371 562.93 126.575 562.317 126.929C562.047 127.085 561.764 127.288 561.468 127.537C561.166 127.783 560.878 128.072 560.603 128.405L559.27 128.032C559.587 127.633 559.927 127.283 560.291 126.983C560.655 126.683 561.036 126.418 561.437 126.187C562.46 125.596 563.466 125.291 564.453 125.273C565.44 125.249 566.342 125.473 567.158 125.944L571.094 128.216ZM568.677 130.736C569.083 130.502 569.368 130.22 569.535 129.89C569.696 129.557 569.714 129.217 569.589 128.869L567.477 127.649L566.292 128.333C565.388 128.855 564.905 129.314 564.843 129.71C564.785 130.103 565.019 130.451 565.544 130.754C566.053 131.048 566.57 131.197 567.095 131.2C567.62 131.197 568.147 131.042 568.677 130.736ZM579.116 124.557C579.526 124.32 579.84 124.06 580.059 123.778C580.282 123.493 580.441 123.204 580.534 122.91L582.031 123.036C581.979 123.42 581.789 123.808 581.462 124.201C581.134 124.594 580.729 124.93 580.246 125.209C579.43 125.68 578.56 125.982 577.635 126.114C576.71 126.24 575.78 126.207 574.844 126.015C573.904 125.82 573.005 125.475 572.148 124.98C571.327 124.506 570.742 123.994 570.394 123.445C570.046 122.89 569.97 122.34 570.168 121.794C570.37 121.245 570.882 120.733 571.703 120.259C572.228 119.956 572.8 119.719 573.418 119.548C574.036 119.371 574.696 119.263 575.398 119.224L575.632 120.097C575.039 120.157 574.507 120.255 574.034 120.39C573.561 120.519 573.143 120.688 572.779 120.898C572.072 121.306 571.755 121.795 571.828 122.365C571.901 122.935 572.48 123.534 573.566 124.161C574.294 124.581 574.992 124.864 575.663 125.011C576.333 125.152 576.959 125.181 577.541 125.097C578.123 125.007 578.648 124.827 579.116 124.557ZM591.806 117.851C591.713 118.121 591.518 118.401 591.222 118.692C590.926 118.983 590.585 119.24 590.201 119.462C589.317 119.972 588.405 120.231 587.465 120.24C586.524 120.249 585.69 120.044 584.963 119.624L580.068 116.798L578.182 117.887L577.169 117.302L579.055 116.213L577.192 115.137L578.346 114.291L580.364 115.457L583.201 113.819L584.059 114.494L581.378 116.042L586.257 118.859C586.714 119.123 587.182 119.255 587.66 119.255C588.143 119.252 588.665 119.088 589.226 118.764C589.533 118.587 589.78 118.403 589.967 118.211C590.154 118.019 590.302 117.825 590.411 117.63L591.806 117.851ZM339.545 318.015L340.675 318.667L334.611 322.168L333.481 321.516L339.545 318.015ZM342.499 319.72L343.637 320.377L337.573 323.878L336.435 323.221L342.499 319.72ZM394.131 286.5L395.261 287.152L381.668 295L380.537 294.348L394.131 286.5ZM397.085 288.205L398.223 288.862L384.629 296.71L383.491 296.053L397.085 288.205ZM389.197 286.225L398.184 286.518L398.69 291.706L396.898 291.787L396.796 290.604C396.775 290.454 396.77 290.301 396.781 290.145C396.796 289.986 396.856 289.801 396.96 289.591L396.625 288.471L396.547 287.463L394.801 287.418L392.868 287.229C392.499 287.286 392.174 287.317 391.894 287.323C391.613 287.323 391.345 287.319 391.091 287.31L389.057 287.26L389.197 286.225ZM347.698 344.308L348.828 344.96L342.764 348.461L341.634 347.809L347.698 344.308ZM350.652 346.013L351.79 346.67L345.726 350.171L344.588 349.514L350.652 346.013ZM458.668 311.239L459.798 311.892L453.734 315.393L452.604 314.74L458.668 311.239ZM461.622 312.945L462.76 313.602L456.696 317.103L455.558 316.446L461.622 312.945ZM353.462 433.98L354.593 434.632L348.529 438.133L347.399 437.481L353.462 433.98ZM356.417 435.685L357.554 436.342L351.491 439.843L350.353 439.186L356.417 435.685ZM543.91 330.883C544.32 330.646 544.634 330.387 544.853 330.105C545.076 329.82 545.235 329.53 545.328 329.236L546.825 329.362C546.773 329.746 546.583 330.135 546.256 330.528C545.928 330.921 545.523 331.257 545.04 331.536C544.224 332.007 543.354 332.308 542.429 332.44C541.504 332.566 540.574 332.533 539.638 332.341C538.698 332.146 537.799 331.801 536.942 331.306C536.121 330.832 535.536 330.321 535.188 329.772C534.84 329.217 534.764 328.666 534.962 328.12C535.164 327.571 535.676 327.06 536.497 326.586C537.022 326.283 537.594 326.046 538.212 325.875C538.83 325.698 539.49 325.59 540.192 325.551L540.426 326.424C539.833 326.484 539.301 326.581 538.828 326.716C538.355 326.845 537.937 327.015 537.573 327.225C536.866 327.633 536.549 328.122 536.622 328.692C536.695 329.262 537.274 329.86 538.36 330.487C539.088 330.907 539.786 331.191 540.457 331.338C541.127 331.479 541.753 331.507 542.335 331.423C542.917 331.333 543.442 331.153 543.91 330.883ZM545.244 321.536C546.018 321.089 546.842 320.817 547.715 320.721C548.588 320.619 549.474 320.678 550.373 320.897C551.277 321.113 552.163 321.471 553.031 321.972C553.867 322.455 554.472 322.961 554.847 323.489C555.221 324.017 555.33 324.539 555.174 325.055C555.018 325.565 554.556 326.042 553.787 326.486C553.018 326.93 552.194 327.201 551.316 327.3C550.438 327.399 549.544 327.342 548.635 327.129C547.725 326.91 546.842 326.553 545.985 326.058C545.138 325.569 544.527 325.061 544.153 324.533C543.779 324.005 543.675 323.486 543.841 322.976C544.007 322.46 544.475 321.98 545.244 321.536ZM546.312 322.152C545.605 322.56 545.332 323.021 545.494 323.534C545.655 324.041 546.286 324.612 547.388 325.248C548.468 325.872 549.448 326.234 550.326 326.333C551.209 326.429 552.004 326.273 552.711 325.865C553.418 325.457 553.685 324.999 553.514 324.492C553.348 323.982 552.719 323.412 551.628 322.782C550.536 322.152 549.554 321.789 548.681 321.693C547.803 321.594 547.013 321.747 546.312 322.152ZM553.079 313.205L554.552 312.544L566.064 319.19L564.918 319.852L563.71 319.298C563.84 319.727 563.806 320.116 563.609 320.464C563.417 320.809 563.095 321.112 562.643 321.373C561.931 321.784 561.164 322.019 560.343 322.079C559.522 322.139 558.68 322.049 557.818 321.809C556.95 321.566 556.093 321.2 555.246 320.711C554.425 320.237 553.819 319.741 553.43 319.222C553.035 318.7 552.892 318.194 553.001 317.705C553.11 317.21 553.503 316.768 554.178 316.378C554.651 316.105 555.15 315.913 555.675 315.802C556.194 315.688 556.75 315.643 557.342 315.667L553.079 313.205ZM555.573 316.787C554.887 317.183 554.627 317.642 554.794 318.164C554.96 318.686 555.586 319.261 556.672 319.888C557.379 320.296 558.047 320.594 558.675 320.783C559.304 320.972 559.883 321.052 560.413 321.022C560.949 320.989 561.429 320.849 561.855 320.603C562.323 320.333 562.588 320.027 562.65 319.685C562.718 319.34 562.695 319.009 562.58 318.691L558.48 316.324C557.924 316.261 557.397 316.268 556.898 316.346C556.394 316.421 555.952 316.568 555.573 316.787ZM566.58 314.689C567.24 315.04 567.882 315.27 568.506 315.378C569.124 315.483 569.708 315.487 570.259 315.391C570.805 315.292 571.288 315.121 571.709 314.878C572.13 314.635 572.447 314.38 572.66 314.113C572.878 313.843 573.044 313.534 573.159 313.186L574.64 313.33C574.556 313.726 574.354 314.116 574.032 314.5C573.715 314.881 573.299 315.22 572.785 315.517C571.99 315.976 571.132 316.264 570.212 316.381C569.293 316.498 568.365 316.458 567.43 316.26C566.495 316.056 565.603 315.709 564.756 315.22C563.925 314.74 563.335 314.229 562.987 313.686C562.639 313.143 562.548 312.61 562.714 312.088C562.881 311.566 563.328 311.095 564.055 310.675C564.746 310.276 565.505 310.027 566.331 309.928C567.152 309.826 567.996 309.873 568.864 310.068C569.732 310.257 570.581 310.591 571.413 311.071C571.553 311.152 571.683 311.23 571.802 311.305C571.917 311.377 572.016 311.443 572.099 311.503L566.58 314.689ZM565.146 311.287C564.538 311.638 564.245 312.057 564.265 312.543C564.291 313.026 564.728 313.545 565.575 314.1L569.854 311.629C568.96 311.131 568.108 310.861 567.297 310.819C566.482 310.774 565.765 310.93 565.146 311.287ZM340.209 469.896L341.846 470.112L339.718 475.237L348.627 474.027L348.884 474.985L339.258 476.268L337.917 475.494L340.209 469.896ZM372.234 451.406L381.93 450.083L383.271 450.857L381.058 456.41L379.382 456.261L381.486 451.122L372.593 452.342L372.234 451.406ZM443.02 410.538L444.656 410.754L442.529 415.879L454.719 414.214L454.976 415.173L442.069 416.91L440.728 416.136L443.02 410.538ZM456.558 416.086L455.023 416.424L447.579 404.026L449.138 403.72L456.558 416.086ZM484.398 386.648L494.094 385.325L495.435 386.099L493.221 391.652L491.546 391.503L493.65 386.364L484.757 387.584L484.398 386.648Z"
            fill="#EFFFAE"
          />
          <path
            d="M185.222 411.641C185.835 411.995 186.227 412.398 186.399 412.851C186.565 413.301 186.492 413.772 186.18 414.264C185.863 414.753 185.287 415.239 184.45 415.722C183.665 416.175 182.834 416.517 181.956 416.748C181.083 416.976 180.202 417.095 179.314 417.104L179.212 416.118C179.935 416.103 180.641 416.016 181.332 415.857C182.018 415.695 182.686 415.427 183.335 415.052C183.772 414.8 184.11 414.524 184.349 414.224C184.583 413.921 184.671 413.618 184.614 413.315C184.551 413.009 184.294 412.725 183.842 412.464C183.494 412.263 183.13 412.131 182.751 412.068C182.372 412.005 181.917 412.019 181.387 412.109C180.852 412.196 180.187 412.364 179.392 412.613C178.477 412.901 177.63 413.12 176.851 413.27C176.071 413.414 175.346 413.457 174.676 413.4C174.011 413.34 173.395 413.147 172.829 412.82C172.294 412.511 171.966 412.151 171.847 411.74C171.727 411.329 171.81 410.906 172.096 410.471C172.382 410.03 172.865 409.613 173.546 409.22C174.289 408.791 175.04 408.48 175.798 408.288C176.557 408.09 177.357 407.976 178.199 407.946L178.285 408.914C177.557 408.938 176.897 409.034 176.305 409.202C175.707 409.367 175.18 409.581 174.723 409.845C174.333 410.07 174.034 410.312 173.826 410.57C173.619 410.822 173.533 411.072 173.569 411.321C173.606 411.564 173.803 411.789 174.162 411.996C174.468 412.173 174.816 412.278 175.206 412.311C175.596 412.344 176.082 412.301 176.664 412.181C177.24 412.058 177.97 411.858 178.854 411.582C179.571 411.354 180.288 411.174 181.005 411.042C181.722 410.904 182.434 410.871 183.141 410.943C183.842 411.012 184.536 411.245 185.222 411.641ZM186.689 404.746L193.859 408.886L196.174 407.549L197.211 408.148L191.053 411.703L190.017 411.104L192.55 409.642L186.416 406.1L183.961 407.518L182.924 406.919L186.689 404.746ZM181.802 403.13C182.093 402.962 182.412 402.88 182.76 402.883C183.114 402.883 183.418 402.956 183.672 403.103C183.937 403.256 184.072 403.436 184.078 403.643C184.083 403.844 183.94 404.029 183.649 404.197C183.374 404.356 183.059 404.435 182.706 404.435C182.347 404.432 182.036 404.354 181.771 404.201C181.516 404.054 181.389 403.879 181.389 403.675C181.389 403.471 181.526 403.289 181.802 403.13ZM197.119 398.526C197.384 398.373 197.693 398.26 198.047 398.188C198.405 398.113 198.826 398.125 199.309 398.224C199.792 398.323 200.348 398.554 200.977 398.917L207.088 402.445L205.872 403.147L199.972 399.741C199.457 399.444 199.055 399.247 198.764 399.151C198.473 399.055 198.179 399.093 197.883 399.264C197.639 399.405 197.472 399.591 197.384 399.822C197.296 400.047 197.311 400.326 197.431 400.659L203.807 404.34L202.583 405.046L196.683 401.64C196.168 401.343 195.765 401.146 195.474 401.05C195.183 400.954 194.89 400.992 194.594 401.163C194.339 401.31 194.17 401.497 194.087 401.725C194.004 401.947 194.022 402.225 194.142 402.558L200.517 406.239L199.309 406.936L191.102 402.198L192.131 401.604L193.16 402.108C193.066 401.796 193.05 401.499 193.113 401.217C193.175 400.929 193.412 400.666 193.822 400.429C194.134 400.249 194.503 400.123 194.929 400.051C195.35 399.976 195.838 400.024 196.394 400.195C196.295 399.88 196.288 399.585 196.371 399.309C196.449 399.03 196.698 398.769 197.119 398.526ZM204.728 394.133C205.455 393.713 206.211 393.48 206.996 393.435C207.786 393.387 208.599 393.494 209.436 393.755C210.267 394.013 211.111 394.389 211.969 394.884C212.795 395.361 213.416 395.855 213.832 396.365C214.247 396.869 214.406 397.362 214.307 397.845C214.208 398.328 213.803 398.775 213.091 399.186C212.192 399.705 211.153 399.939 209.973 399.888L213.886 402.147L212.74 402.998L201.228 396.351L202.343 395.708L203.598 396.306C203.478 395.889 203.512 395.495 203.699 395.123C203.891 394.748 204.234 394.418 204.728 394.133ZM205.468 394.92C205.016 395.181 204.754 395.492 204.681 395.852C204.608 396.206 204.627 396.543 204.736 396.864L208.804 399.213C209.334 399.273 209.854 399.264 210.363 399.186C210.872 399.102 211.322 398.948 211.712 398.723C212.392 398.33 212.644 397.884 212.468 397.386C212.291 396.888 211.654 396.323 210.558 395.69C209.841 395.276 209.178 394.971 208.57 394.776C207.957 394.578 207.396 394.491 206.887 394.515C206.373 394.536 205.9 394.671 205.468 394.92ZM210.466 387.202L219.952 392.678C220.357 392.912 220.77 393.007 221.191 392.962C221.612 392.911 222.022 392.77 222.423 392.539C222.672 392.395 222.882 392.243 223.054 392.084C223.225 391.925 223.379 391.756 223.514 391.576L224.823 391.927C224.709 392.119 224.527 392.335 224.278 392.575C224.039 392.815 223.711 393.055 223.295 393.295C222.568 393.715 221.778 393.94 220.926 393.97C220.069 393.997 219.284 393.805 218.572 393.394L210.193 388.556L207.676 390.01L206.639 389.411L210.466 387.202ZM225.519 387.601C226.178 387.952 226.82 388.182 227.444 388.29C228.062 388.395 228.647 388.399 229.197 388.303C229.743 388.204 230.226 388.033 230.647 387.79C231.068 387.547 231.385 387.292 231.598 387.025C231.816 386.755 231.983 386.446 232.097 386.098L233.578 386.242C233.495 386.638 233.292 387.028 232.97 387.412C232.653 387.793 232.237 388.132 231.723 388.429C230.928 388.888 230.07 389.176 229.151 389.293C228.231 389.41 227.303 389.37 226.368 389.172C225.433 388.968 224.542 388.621 223.695 388.132C222.863 387.652 222.274 387.141 221.925 386.598C221.577 386.055 221.486 385.522 221.653 385C221.819 384.478 222.266 384.007 222.993 383.587C223.684 383.188 224.443 382.939 225.269 382.84C226.09 382.738 226.934 382.785 227.802 382.98C228.67 383.169 229.52 383.503 230.351 383.983C230.491 384.064 230.621 384.142 230.741 384.217C230.855 384.289 230.954 384.355 231.037 384.415L225.519 387.601ZM224.084 384.199C223.476 384.55 223.183 384.969 223.204 385.455C223.23 385.938 223.666 386.457 224.513 387.012L228.792 384.541C227.898 384.043 227.046 383.773 226.236 383.731C225.42 383.686 224.703 383.842 224.084 384.199ZM230.587 376.287C231.288 375.882 231.963 375.594 232.613 375.423C233.263 375.252 233.972 375.143 234.741 375.095L234.866 376.04C234.242 376.07 233.681 376.16 233.182 376.31C232.683 376.454 232.228 376.644 231.818 376.881C231.231 377.22 230.828 377.615 230.61 378.065C230.386 378.512 230.444 379.01 230.781 379.559C231.119 380.102 231.836 380.69 232.933 381.323C233.998 381.938 234.995 382.349 235.926 382.556C236.861 382.76 237.718 382.802 238.498 382.682C239.277 382.562 239.971 382.326 240.579 381.975C241.181 381.627 241.584 381.29 241.787 380.963C241.995 380.633 242.125 380.318 242.177 380.018L243.767 380.126C243.756 380.498 243.605 380.903 243.314 381.341C243.018 381.776 242.488 382.214 241.724 382.655C240.857 383.156 239.856 383.487 238.724 383.649C237.596 383.808 236.417 383.769 235.185 383.532C233.948 383.292 232.73 382.826 231.53 382.133C230.324 381.437 229.519 380.732 229.113 380.018C228.713 379.301 228.651 378.62 228.926 377.975C229.207 377.327 229.76 376.764 230.587 376.287ZM241.57 372.862C242.345 372.415 243.168 372.143 244.041 372.047C244.914 371.945 245.8 372.004 246.699 372.223C247.603 372.439 248.489 372.797 249.357 373.298C250.193 373.781 250.799 374.287 251.173 374.815C251.547 375.343 251.656 375.865 251.5 376.381C251.344 376.891 250.882 377.368 250.113 377.812C249.344 378.256 248.52 378.527 247.642 378.626C246.764 378.725 245.87 378.668 244.961 378.455C244.051 378.236 243.168 377.879 242.311 377.384C241.464 376.895 240.853 376.387 240.479 375.859C240.105 375.331 240.001 374.812 240.167 374.302C240.334 373.786 240.801 373.306 241.57 372.862ZM242.638 373.478C241.931 373.886 241.659 374.347 241.82 374.86C241.981 375.367 242.612 375.938 243.714 376.574C244.794 377.198 245.774 377.56 246.652 377.659C247.535 377.755 248.33 377.599 249.037 377.191C249.744 376.783 250.011 376.325 249.84 375.818C249.674 375.308 249.045 374.738 247.954 374.108C246.863 373.478 245.88 373.115 245.008 373.019C244.129 372.92 243.34 373.073 242.638 373.478ZM249.405 364.531L250.878 363.87L262.39 370.516L261.245 371.178L260.037 370.624C260.166 371.053 260.133 371.442 259.935 371.79C259.743 372.135 259.421 372.438 258.969 372.699C258.257 373.11 257.49 373.345 256.669 373.405C255.848 373.465 255.007 373.375 254.144 373.135C253.276 372.892 252.419 372.526 251.572 372.037C250.751 371.563 250.146 371.067 249.756 370.548C249.361 370.026 249.218 369.52 249.327 369.031C249.436 368.536 249.829 368.094 250.504 367.704C250.977 367.431 251.476 367.239 252.001 367.128C252.52 367.014 253.076 366.969 253.669 366.993L249.405 364.531ZM251.899 368.113C251.213 368.509 250.954 368.968 251.12 369.49C251.286 370.012 251.912 370.587 252.998 371.214C253.705 371.622 254.373 371.92 255.001 372.109C255.63 372.298 256.21 372.378 256.74 372.348C257.275 372.315 257.755 372.175 258.181 371.929C258.649 371.659 258.914 371.353 258.976 371.011C259.044 370.666 259.021 370.335 258.906 370.017L254.807 367.65C254.251 367.587 253.723 367.594 253.224 367.672C252.72 367.747 252.279 367.894 251.899 368.113ZM262.906 366.015C263.566 366.366 264.208 366.596 264.832 366.704C265.45 366.809 266.035 366.813 266.585 366.717C267.131 366.618 267.614 366.447 268.035 366.204C268.456 365.961 268.773 365.706 268.986 365.439C269.204 365.169 269.371 364.86 269.485 364.512L270.966 364.656C270.883 365.052 270.68 365.442 270.358 365.826C270.041 366.207 269.625 366.546 269.111 366.843C268.316 367.302 267.458 367.59 266.539 367.707C265.619 367.824 264.691 367.784 263.756 367.586C262.821 367.382 261.93 367.035 261.083 366.546C260.251 366.066 259.661 365.555 259.313 365.012C258.965 364.469 258.874 363.936 259.041 363.414C259.207 362.892 259.654 362.421 260.381 362.001C261.072 361.602 261.831 361.353 262.657 361.254C263.478 361.152 264.322 361.199 265.19 361.394C266.058 361.583 266.908 361.917 267.739 362.397C267.879 362.478 268.009 362.556 268.129 362.631C268.243 362.703 268.342 362.769 268.425 362.829L262.906 366.015ZM261.472 362.613C260.864 362.964 260.571 363.383 260.592 363.869C260.618 364.352 261.054 364.871 261.901 365.426L266.18 362.955C265.286 362.457 264.434 362.187 263.624 362.145C262.808 362.1 262.091 362.256 261.472 362.613ZM276.47 360.614L270.172 353.63L271.536 352.843L278.676 361.114L277.273 361.924L262.947 357.802L264.405 356.96L276.47 360.614ZM280.159 350.781L287.329 354.921L289.644 353.584L290.681 354.183L284.523 357.738L283.487 357.139L286.02 355.677L279.886 352.135L277.431 353.553L276.394 352.954L280.159 350.781ZM275.272 349.165C275.563 348.997 275.882 348.915 276.23 348.918C276.584 348.918 276.888 348.991 277.142 349.138C277.407 349.291 277.542 349.471 277.547 349.678C277.553 349.879 277.41 350.064 277.119 350.232C276.843 350.391 276.529 350.47 276.176 350.47C275.817 350.467 275.505 350.389 275.24 350.236C274.986 350.089 274.858 349.914 274.858 349.71C274.858 349.506 274.996 349.324 275.272 349.165ZM290.947 349.826C291.607 350.177 292.249 350.406 292.873 350.514C293.491 350.619 294.076 350.624 294.626 350.528C295.172 350.429 295.655 350.258 296.076 350.015C296.497 349.772 296.814 349.517 297.027 349.25C297.245 348.98 297.411 348.671 297.526 348.323L299.007 348.467C298.924 348.863 298.721 349.253 298.399 349.637C298.082 350.018 297.666 350.357 297.152 350.654C296.357 351.113 295.499 351.401 294.58 351.518C293.66 351.635 292.732 351.594 291.797 351.396C290.862 351.192 289.971 350.846 289.124 350.357C288.292 349.877 287.702 349.365 287.354 348.822C287.006 348.279 286.915 347.747 287.082 347.225C287.248 346.703 287.695 346.232 288.422 345.812C289.113 345.413 289.872 345.164 290.698 345.065C291.519 344.963 292.363 345.009 293.231 345.204C294.099 345.393 294.948 345.728 295.78 346.208C295.92 346.289 296.05 346.367 296.17 346.442C296.284 346.514 296.383 346.58 296.466 346.64L290.947 349.826ZM289.513 346.424C288.905 346.775 288.612 347.193 288.633 347.679C288.659 348.162 289.095 348.681 289.942 349.236L294.221 346.766C293.327 346.268 292.475 345.998 291.665 345.956C290.849 345.911 290.132 346.067 289.513 346.424ZM308.985 343.615L307.13 344.686L300.045 341.819L304.916 345.964L303.108 347.008L293.404 343.133L294.745 342.359L303.186 346.027L298.143 341.603L299.694 340.708L307.286 343.66L300.934 338.786L302.212 338.048L308.985 343.615ZM309.641 339.033C310.301 339.384 310.943 339.613 311.567 339.721C312.185 339.826 312.77 339.831 313.32 339.735C313.866 339.636 314.349 339.465 314.77 339.222C315.191 338.979 315.508 338.724 315.721 338.457C315.939 338.187 316.105 337.878 316.22 337.53L317.701 337.674C317.618 338.07 317.415 338.46 317.093 338.844C316.776 339.225 316.36 339.564 315.846 339.861C315.051 340.32 314.193 340.608 313.274 340.725C312.354 340.842 311.426 340.801 310.491 340.603C309.556 340.399 308.665 340.053 307.818 339.564C306.986 339.084 306.396 338.572 306.048 338.029C305.7 337.486 305.609 336.954 305.775 336.432C305.942 335.91 306.389 335.439 307.116 335.019C307.807 334.62 308.566 334.371 309.392 334.272C310.213 334.17 311.057 334.216 311.925 334.411C312.793 334.6 313.642 334.935 314.474 335.415C314.614 335.496 314.744 335.574 314.864 335.649C314.978 335.721 315.077 335.787 315.16 335.847L309.641 339.033ZM308.207 335.631C307.599 335.982 307.306 336.4 307.327 336.886C307.353 337.369 307.789 337.888 308.636 338.443L312.915 335.973C312.021 335.475 311.169 335.205 310.358 335.163C309.543 335.118 308.826 335.274 308.207 335.631ZM321.677 336.287L320.672 335.706L321.95 334.968L315.754 331.391L314.476 332.129L313.47 331.548L315.746 330.234L317.928 331.215C317.57 330.642 317.432 330.119 317.515 329.645C317.598 329.171 318.012 328.719 318.755 328.29C318.983 328.158 319.204 328.052 319.417 327.971C319.63 327.884 319.856 327.801 320.095 327.723L320.882 328.619C320.664 328.691 320.475 328.761 320.313 328.83C320.147 328.896 319.973 328.982 319.791 329.087C319.162 329.45 318.846 329.891 318.84 330.41C318.835 330.929 319.149 331.527 319.783 332.205L323.26 334.212L324.928 333.249L325.933 333.83L321.677 336.287ZM321.607 330.054L319.822 329.024L318.965 328.376L320.095 327.723L322.683 329.433L321.607 330.054Z"
            fill="#90C687"
          />
          <path
            d="M360.242 335.544L366.057 338.901C366.597 339.213 367.099 339.374 367.561 339.383C368.024 339.392 368.491 339.26 368.964 338.987C369.416 338.726 369.715 338.406 369.86 338.028C370.006 337.644 370.014 337.286 369.884 336.953L363.843 333.465L365.153 332.709L373.36 337.448L372.245 338.091L371.03 337.515C371.123 337.941 371.045 338.355 370.796 338.757C370.541 339.156 370.172 339.495 369.689 339.774C368.894 340.233 368.089 340.455 367.273 340.44C366.457 340.419 365.667 340.188 364.903 339.747L358.933 336.3L360.242 335.544ZM378.373 333.509C379.002 333.146 379.381 332.792 379.511 332.447C379.641 332.096 379.509 331.807 379.114 331.579C378.864 331.435 378.602 331.337 378.327 331.286C378.056 331.232 377.708 331.244 377.282 331.322C376.856 331.4 376.279 331.565 375.552 331.817C374.845 332.063 374.191 332.255 373.588 332.393C372.985 332.525 372.419 332.573 371.889 332.537C371.364 332.498 370.865 332.342 370.392 332.069C369.93 331.802 369.662 331.498 369.589 331.156C369.517 330.808 369.626 330.448 369.917 330.076C370.202 329.701 370.655 329.335 371.273 328.978C371.933 328.597 372.595 328.316 373.26 328.136C373.926 327.95 374.557 327.832 375.154 327.781L375.466 328.627C374.941 328.684 374.424 328.781 373.915 328.919C373.401 329.054 372.878 329.275 372.348 329.581C371.704 329.953 371.348 330.275 371.281 330.548C371.208 330.818 371.33 331.045 371.647 331.228C371.886 331.366 372.151 331.444 372.442 331.462C372.733 331.474 373.102 331.426 373.549 331.318C373.99 331.207 374.565 331.034 375.271 330.8C375.947 330.572 376.581 330.401 377.173 330.287C377.771 330.17 378.342 330.14 378.888 330.197C379.433 330.254 379.961 330.43 380.47 330.724C381.052 331.06 381.359 331.429 381.39 331.831C381.416 332.23 381.247 332.63 380.883 333.032C380.519 333.428 380.044 333.796 379.457 334.135C378.714 334.564 377.973 334.868 377.235 335.048C376.498 335.222 375.799 335.323 375.139 335.35L375.022 334.418C375.609 334.385 376.194 334.297 376.776 334.153C377.358 334.003 377.89 333.788 378.373 333.509ZM383.223 327.55C383.883 327.901 384.525 328.131 385.148 328.239C385.767 328.344 386.351 328.348 386.902 328.252C387.448 328.153 387.931 327.982 388.352 327.739C388.773 327.496 389.09 327.241 389.303 326.974C389.521 326.704 389.687 326.395 389.801 326.047L391.282 326.191C391.199 326.587 390.997 326.977 390.674 327.361C390.357 327.742 389.942 328.081 389.427 328.378C388.632 328.837 387.775 329.125 386.855 329.242C385.936 329.359 385.008 329.319 384.073 329.121C383.137 328.917 382.246 328.57 381.399 328.081C380.568 327.601 379.978 327.09 379.63 326.547C379.282 326.004 379.191 325.471 379.357 324.949C379.523 324.427 379.97 323.956 380.698 323.536C381.389 323.137 382.148 322.888 382.974 322.789C383.795 322.687 384.639 322.734 385.507 322.929C386.375 323.118 387.224 323.452 388.056 323.932C388.196 324.013 388.326 324.091 388.445 324.166C388.56 324.238 388.658 324.304 388.741 324.364L383.223 327.55ZM381.789 324.148C381.181 324.499 380.887 324.918 380.908 325.404C380.934 325.887 381.371 326.406 382.218 326.961L386.497 324.49C385.603 323.992 384.751 323.722 383.94 323.68C383.124 323.635 382.407 323.791 381.789 324.148ZM399.008 319.211C399.621 319.565 400.014 319.968 400.185 320.421C400.351 320.871 400.279 321.342 399.967 321.834C399.65 322.323 399.073 322.809 398.237 323.292C397.452 323.745 396.621 324.087 395.742 324.318C394.869 324.546 393.989 324.665 393.1 324.674L392.999 323.688C393.721 323.673 394.428 323.586 395.119 323.427C395.805 323.265 396.472 322.997 397.122 322.622C397.558 322.37 397.896 322.094 398.135 321.794C398.369 321.491 398.457 321.188 398.4 320.885C398.338 320.579 398.081 320.295 397.629 320.034C397.28 319.833 396.917 319.701 396.537 319.638C396.158 319.575 395.703 319.589 395.173 319.679C394.638 319.766 393.973 319.934 393.178 320.183C392.264 320.471 391.417 320.69 390.637 320.84C389.858 320.984 389.133 321.027 388.463 320.97C387.797 320.91 387.182 320.717 386.615 320.39C386.08 320.081 385.753 319.721 385.633 319.31C385.514 318.899 385.597 318.476 385.883 318.041C386.168 317.6 386.652 317.183 387.332 316.79C388.075 316.361 388.826 316.05 389.585 315.858C390.344 315.66 391.144 315.546 391.986 315.516L392.071 316.484C391.344 316.508 390.684 316.604 390.092 316.772C389.494 316.937 388.967 317.151 388.509 317.415C388.12 317.64 387.821 317.882 387.613 318.14C387.405 318.392 387.319 318.642 387.356 318.891C387.392 319.134 387.59 319.359 387.948 319.566C388.255 319.743 388.603 319.848 388.993 319.881C389.382 319.914 389.868 319.871 390.45 319.751C391.027 319.628 391.757 319.428 392.64 319.152C393.357 318.924 394.074 318.744 394.791 318.612C395.509 318.474 396.22 318.441 396.927 318.513C397.629 318.582 398.322 318.815 399.008 319.211ZM408.612 315.025C408.94 315.214 409.233 315.32 409.493 315.344C409.753 315.368 410.033 315.335 410.335 315.245L410.935 315.961C410.535 316.138 410.114 316.252 409.672 316.303C409.225 316.351 408.76 316.304 408.277 316.163C408.36 316.553 408.28 316.933 408.036 317.302C407.786 317.668 407.394 318.005 406.859 318.314C406.038 318.788 405.16 319.028 404.224 319.034C403.289 319.04 402.439 318.823 401.675 318.382C400.829 317.893 400.509 317.327 400.717 316.685C400.925 316.043 401.652 315.362 402.899 314.642L404.107 313.945L403.421 313.549C402.829 313.207 402.237 313.066 401.644 313.126C401.052 313.18 400.449 313.384 399.836 313.738C399.566 313.894 399.283 314.096 398.986 314.345C398.685 314.591 398.397 314.881 398.121 315.214L396.789 314.84C397.105 314.441 397.446 314.092 397.81 313.792C398.173 313.492 398.555 313.226 398.955 312.995C399.979 312.404 400.984 312.1 401.972 312.082C402.959 312.058 403.86 312.281 404.676 312.752L408.612 315.025ZM406.196 317.545C406.601 317.311 406.887 317.029 407.054 316.699C407.215 316.366 407.233 316.025 407.108 315.677L404.996 314.458L403.811 315.142C402.907 315.664 402.424 316.123 402.361 316.519C402.304 316.912 402.538 317.26 403.063 317.563C403.572 317.857 404.089 318.005 404.614 318.008C405.139 318.005 405.666 317.851 406.196 317.545ZM413.875 314.056L405.668 309.318L406.782 308.674L408.022 309.273C407.933 308.838 408.027 308.412 408.302 307.995C408.578 307.572 408.952 307.224 409.425 306.951C410.23 306.486 411.028 306.271 411.817 306.307C412.612 306.34 413.389 306.576 414.148 307.014L420.111 310.456L418.801 311.212L413.805 308.328C413.244 308.004 412.761 307.761 412.355 307.599C411.945 307.434 411.563 307.363 411.21 307.387C410.851 307.408 410.464 307.539 410.048 307.779C409.726 307.965 409.492 308.181 409.347 308.427C409.206 308.67 409.131 308.917 409.121 309.169C409.11 309.415 409.139 309.642 409.206 309.849L415.185 313.3L413.875 314.056ZM416.457 299.084L417.93 298.422L429.442 305.069L428.296 305.73L427.088 305.177C427.218 305.606 427.184 305.994 426.987 306.342C426.794 306.687 426.472 306.99 426.02 307.251C425.308 307.662 424.542 307.898 423.721 307.958C422.9 308.018 422.058 307.928 421.196 307.688C420.328 307.445 419.471 307.079 418.624 306.59C417.803 306.116 417.197 305.619 416.807 305.1C416.413 304.578 416.27 304.073 416.379 303.584C416.488 303.089 416.88 302.646 417.556 302.256C418.029 301.983 418.527 301.791 419.052 301.68C419.572 301.566 420.128 301.521 420.72 301.545L416.457 299.084ZM418.951 302.666C418.265 303.062 418.005 303.521 418.171 304.043C418.338 304.565 418.964 305.139 420.05 305.766C420.757 306.174 421.424 306.473 422.053 306.662C422.682 306.851 423.261 306.93 423.791 306.9C424.326 306.867 424.807 306.728 425.233 306.482C425.701 306.212 425.966 305.906 426.028 305.564C426.096 305.219 426.072 304.887 425.958 304.569L421.858 302.202C421.302 302.139 420.775 302.147 420.276 302.225C419.772 302.3 419.33 302.447 418.951 302.666ZM427.861 296.306C428.589 295.886 429.345 295.654 430.13 295.609C430.919 295.561 431.733 295.667 432.569 295.928C433.401 296.186 434.245 296.563 435.102 297.058C435.928 297.535 436.549 298.028 436.965 298.538C437.381 299.042 437.539 299.536 437.441 300.019C437.342 300.502 436.936 300.949 436.225 301.36C435.326 301.879 434.286 302.113 433.107 302.062L437.02 304.321L435.874 305.171L424.362 298.525L425.476 297.881L426.731 298.48C426.612 298.063 426.646 297.668 426.833 297.296C427.025 296.921 427.368 296.591 427.861 296.306ZM428.602 297.094C428.15 297.355 427.887 297.665 427.815 298.025C427.742 298.379 427.76 298.717 427.869 299.038L431.938 301.387C432.468 301.447 432.987 301.438 433.497 301.36C434.006 301.276 434.455 301.121 434.845 300.896C435.526 300.503 435.778 300.058 435.601 299.56C435.424 299.062 434.788 298.496 433.691 297.863C432.974 297.449 432.312 297.145 431.704 296.95C431.091 296.752 430.53 296.665 430.02 296.689C429.506 296.71 429.033 296.845 428.602 297.094ZM446 293.439C446.328 293.628 446.621 293.734 446.881 293.758C447.141 293.782 447.421 293.749 447.723 293.659L448.323 294.375C447.923 294.552 447.502 294.666 447.06 294.717C446.613 294.765 446.148 294.718 445.665 294.577C445.748 294.967 445.668 295.347 445.424 295.716C445.174 296.082 444.782 296.419 444.247 296.728C443.426 297.202 442.547 297.442 441.612 297.448C440.677 297.454 439.827 297.237 439.063 296.796C438.216 296.307 437.897 295.741 438.105 295.099C438.313 294.457 439.04 293.776 440.287 293.056L441.495 292.359L440.809 291.963C440.217 291.621 439.625 291.48 439.032 291.54C438.44 291.594 437.837 291.798 437.224 292.152C436.954 292.308 436.671 292.51 436.374 292.759C436.073 293.005 435.785 293.295 435.509 293.628L434.176 293.254C434.493 292.855 434.834 292.506 435.197 292.206C435.561 291.906 435.943 291.64 436.343 291.409C437.367 290.818 438.372 290.514 439.36 290.496C440.347 290.472 441.248 290.695 442.064 291.166L446 293.439ZM443.584 295.959C443.989 295.725 444.275 295.443 444.441 295.113C444.603 294.78 444.621 294.439 444.496 294.091L442.384 292.872L441.199 293.556C440.295 294.078 439.812 294.537 439.749 294.933C439.692 295.326 439.926 295.674 440.451 295.977C440.96 296.271 441.477 296.419 442.002 296.422C442.527 296.419 443.054 296.265 443.584 295.959ZM454.022 289.779C454.433 289.542 454.747 289.283 454.965 289.001C455.189 288.716 455.347 288.426 455.441 288.132L456.937 288.259C456.885 288.642 456.696 289.031 456.368 289.424C456.041 289.817 455.636 290.153 455.152 290.432C454.337 290.903 453.466 291.204 452.541 291.336C451.616 291.462 450.686 291.429 449.751 291.237C448.811 291.042 447.912 290.697 447.054 290.202C446.233 289.728 445.649 289.217 445.301 288.668C444.952 288.113 444.877 287.562 445.074 287.016C445.277 286.467 445.789 285.956 446.61 285.482C447.135 285.179 447.706 284.942 448.325 284.771C448.943 284.594 449.603 284.486 450.304 284.447L450.538 285.32C449.946 285.38 449.413 285.477 448.94 285.612C448.468 285.741 448.049 285.911 447.686 286.121C446.979 286.529 446.662 287.018 446.735 287.588C446.807 288.158 447.387 288.756 448.473 289.383C449.2 289.803 449.899 290.087 450.569 290.234C451.24 290.375 451.866 290.403 452.448 290.319C453.03 290.229 453.555 290.049 454.022 289.779ZM459.277 278.367L459.277 282.633L467.913 282.858L466.191 283.852L457.672 283.596L457.578 279.348L459.277 278.367ZM450.329 279.528L462.005 286.269L460.696 287.025L449.184 280.378L450.329 279.528Z"
            fill="#CC94EF"
          />
          <path
            d="M348.309 466.236C349.036 465.816 349.792 465.584 350.577 465.539C351.367 465.491 352.18 465.597 353.017 465.858C353.848 466.116 354.692 466.493 355.55 466.988C356.376 467.465 356.997 467.958 357.413 468.468C357.828 468.972 357.987 469.466 357.888 469.949C357.789 470.432 357.384 470.879 356.672 471.29C355.773 471.809 354.734 472.043 353.554 471.992L357.467 474.251L356.321 475.101L344.809 468.455L345.924 467.811L347.179 468.41C347.059 467.993 347.093 467.598 347.28 467.226C347.472 466.851 347.815 466.521 348.309 466.236ZM349.049 467.024C348.597 467.285 348.335 467.595 348.262 467.955C348.189 468.309 348.208 468.647 348.317 468.968L352.385 471.317C352.915 471.377 353.435 471.368 353.944 471.29C354.453 471.206 354.903 471.051 355.292 470.826C355.973 470.433 356.225 469.988 356.049 469.49C355.872 468.992 355.235 468.426 354.139 467.793C353.422 467.379 352.759 467.075 352.151 466.88C351.538 466.682 350.977 466.595 350.468 466.619C349.953 466.64 349.481 466.775 349.049 467.024ZM362.441 467.752L361.436 467.171L362.714 466.433L356.518 462.856L355.24 463.594L354.234 463.013L356.51 461.699L358.692 462.68C358.334 462.107 358.196 461.584 358.279 461.11C358.363 460.636 358.776 460.184 359.519 459.755C359.747 459.623 359.968 459.517 360.181 459.436C360.394 459.349 360.62 459.266 360.859 459.188L361.646 460.084C361.428 460.156 361.239 460.226 361.078 460.295C360.911 460.361 360.737 460.447 360.555 460.552C359.927 460.915 359.61 461.356 359.604 461.875C359.599 462.394 359.914 462.992 360.547 463.67L364.024 465.677L365.692 464.714L366.697 465.295L362.441 467.752ZM362.371 461.519L360.586 460.489L359.729 459.841L360.859 459.188L363.447 460.898L362.371 461.519ZM369.099 459.705C369.759 460.056 370.401 460.285 371.025 460.393C371.643 460.498 372.228 460.503 372.778 460.407C373.324 460.308 373.807 460.137 374.228 459.894C374.649 459.651 374.966 459.396 375.179 459.129C375.397 458.859 375.563 458.55 375.678 458.202L377.159 458.346C377.076 458.742 376.873 459.132 376.551 459.516C376.234 459.897 375.818 460.236 375.304 460.533C374.509 460.992 373.651 461.28 372.732 461.397C371.812 461.514 370.884 461.473 369.949 461.275C369.014 461.071 368.123 460.725 367.276 460.236C366.444 459.756 365.854 459.244 365.506 458.701C365.158 458.158 365.067 457.626 365.234 457.104C365.4 456.582 365.847 456.111 366.574 455.691C367.265 455.292 368.024 455.043 368.85 454.944C369.671 454.842 370.515 454.888 371.383 455.083C372.251 455.272 373.101 455.607 373.932 456.087C374.072 456.168 374.202 456.246 374.322 456.321C374.436 456.393 374.535 456.459 374.618 456.519L369.099 459.705ZM367.665 456.303C367.057 456.654 366.764 457.072 366.785 457.558C366.811 458.041 367.247 458.56 368.094 459.115L372.373 456.645C371.479 456.147 370.627 455.877 369.817 455.835C369.001 455.79 368.284 455.946 367.665 456.303ZM460.473 401.478C461.2 401.058 461.956 400.826 462.741 400.781C463.531 400.733 464.344 400.839 465.18 401.1C466.012 401.358 466.856 401.735 467.714 402.23C468.54 402.707 469.161 403.2 469.576 403.71C469.992 404.214 470.151 404.708 470.052 405.191C469.953 405.674 469.548 406.121 468.836 406.532C467.937 407.051 466.898 407.285 465.718 407.234L469.631 409.493L468.485 410.343L456.973 403.697L458.088 403.053L459.343 403.652C459.223 403.235 459.257 402.84 459.444 402.468C459.636 402.093 459.979 401.763 460.473 401.478ZM461.213 402.266C460.761 402.527 460.499 402.837 460.426 403.197C460.353 403.551 460.371 403.889 460.48 404.21L464.549 406.559C465.079 406.619 465.599 406.61 466.108 406.532C466.617 406.448 467.067 406.293 467.456 406.068C468.137 405.675 468.389 405.23 468.212 404.732C468.036 404.234 467.399 403.668 466.303 403.035C465.586 402.621 464.923 402.317 464.315 402.122C463.702 401.924 463.141 401.837 462.632 401.861C462.117 401.882 461.644 402.017 461.213 402.266ZM474.605 402.994L473.6 402.413L474.878 401.675L468.682 398.098L467.403 398.836L466.398 398.255L468.674 396.941L470.856 397.922C470.498 397.349 470.36 396.826 470.443 396.352C470.526 395.878 470.939 395.426 471.682 394.997C471.911 394.865 472.132 394.759 472.345 394.678C472.558 394.591 472.784 394.508 473.023 394.43L473.81 395.326C473.592 395.398 473.402 395.468 473.241 395.537C473.075 395.603 472.901 395.689 472.719 395.794C472.09 396.157 471.773 396.598 471.768 397.117C471.763 397.636 472.077 398.234 472.711 398.912L476.188 400.919L477.856 399.956L478.861 400.537L474.605 402.994ZM474.535 396.761L472.75 395.731L471.893 395.083L473.023 394.43L475.611 396.14L474.535 396.761ZM481.263 394.947C481.923 395.298 482.565 395.527 483.188 395.635C483.807 395.74 484.391 395.745 484.942 395.649C485.488 395.55 485.971 395.379 486.392 395.136C486.813 394.893 487.13 394.638 487.343 394.371C487.561 394.101 487.727 393.792 487.842 393.444L489.323 393.588C489.239 393.984 489.037 394.374 488.715 394.758C488.398 395.139 487.982 395.478 487.468 395.775C486.672 396.234 485.815 396.522 484.895 396.639C483.976 396.756 483.048 396.715 482.113 396.517C481.178 396.313 480.286 395.967 479.439 395.478C478.608 394.998 478.018 394.486 477.67 393.943C477.322 393.4 477.231 392.868 477.397 392.346C477.564 391.824 478.011 391.353 478.738 390.933C479.429 390.534 480.188 390.285 481.014 390.186C481.835 390.084 482.679 390.13 483.547 390.325C484.415 390.514 485.264 390.849 486.096 391.329C486.236 391.41 486.366 391.488 486.485 391.563C486.6 391.635 486.698 391.701 486.782 391.761L481.263 394.947ZM479.829 391.545C479.221 391.896 478.928 392.314 478.948 392.8C478.974 393.283 479.411 393.802 480.258 394.357L484.537 391.887C483.643 391.389 482.791 391.119 481.98 391.077C481.165 391.032 480.447 391.188 479.829 391.545Z"
            fill="#C1D960"
          />
        </g>
        <path
          className={styles.line1}
          d="M177.058 289.045L235.616 255.237L352.732 187.62L578.303 57.3863C583.086 54.6249 590.841 54.6249 595.624 57.3863L980.808 279.772C985.591 282.534 985.591 287.011 980.808 289.772L372.918 640.738C368.135 643.499 360.381 643.499 355.598 640.738L163.006 529.545L62.3796 471.448"
          stroke="#888888"
          strokeOpacity="0.5"
        />
        <g className={styles.button}>
          <rect
            fill="#EAEAEA"
            height="45.1466"
            rx="9.02931"
            transform="matrix(0.866025 -0.5 0.866025 0.5 755 137.574)"
            width="45.1466"
          />
          <path
            clipRule="evenodd"
            d="M801.054 134.836C803.558 136.872 803.309 139.662 800.252 141.427C796.827 143.404 791.174 143.347 787.627 141.299C784.079 139.251 783.98 135.987 787.405 134.01C789.864 132.59 793.471 132.219 796.622 132.88L794.272 134.238L795.947 135.205L798.82 133.547L799.183 133.337L800.185 132.758L800.801 132.403L795.215 129.178L793.597 130.112L796.27 131.655C792.678 131.107 788.755 131.618 786.009 133.204C781.839 135.611 781.96 139.584 786.279 142.077C790.597 144.571 797.478 144.64 801.648 142.233C805.452 140.037 805.685 136.538 802.419 134.048L801.054 134.836Z"
            fill="#313131"
            fillRule="evenodd"
          />
        </g>
        <g className={styles.navbar}>
          <rect
            fill="#2B2B2B"
            height="40"
            rx="10"
            transform="matrix(0.866025 -0.5 0.866025 0.5 529 412.062)"
            width="479"
          />
          <path
            d="M571.417 412.573L566.071 405.638L567.309 404.923L579.54 407.883L578.231 408.639L574.59 407.706L570.961 409.801L572.637 411.869L571.417 412.573ZM570.358 409.069L573.3 407.371L569.991 406.506C568.984 406.244 568.179 406.016 567.575 405.822C568.021 406.207 568.418 406.616 568.765 407.049L570.358 409.069ZM582.731 408.823L574.034 403.802L575.005 403.242L575.822 403.713C575.731 403.397 575.751 403.11 575.881 402.852C576.007 402.592 576.276 402.344 576.686 402.107C577.223 401.797 577.835 401.603 578.521 401.526C579.208 401.448 579.909 401.495 580.623 401.666C581.333 401.835 581.989 402.092 582.589 402.438C583.232 402.81 583.696 403.212 583.98 403.645C584.264 404.073 584.323 404.495 584.157 404.91C583.992 405.32 583.666 405.665 583.181 405.945C582.825 406.15 582.431 406.292 581.997 406.369C581.566 406.444 581.146 406.468 580.736 406.441L583.796 408.208L582.731 408.823ZM578.178 405.081C578.987 405.548 579.749 405.798 580.463 405.833C581.178 405.867 581.768 405.749 582.233 405.48C582.707 405.207 582.912 404.858 582.849 404.435C582.786 404.006 582.334 403.549 581.493 403.064C580.692 402.601 579.926 402.351 579.196 402.312C578.47 402.271 577.878 402.383 577.42 402.647C576.966 402.909 576.777 403.264 576.852 403.713C576.927 404.158 577.369 404.613 578.178 405.081ZM589.48 404.927L580.783 399.906L581.754 399.345L582.571 399.817C582.48 399.5 582.5 399.213 582.63 398.956C582.756 398.696 583.025 398.447 583.435 398.21C583.972 397.901 584.584 397.707 585.27 397.629C585.957 397.552 586.658 397.599 587.372 397.77C588.082 397.938 588.738 398.196 589.337 398.542C589.981 398.913 590.445 399.316 590.729 399.749C591.013 400.177 591.072 400.598 590.906 401.013C590.741 401.423 590.415 401.769 589.929 402.049C589.574 402.254 589.18 402.395 588.745 402.473C588.315 402.548 587.895 402.572 587.484 402.544L590.545 404.312L589.48 404.927ZM584.927 401.184C585.736 401.651 586.498 401.902 587.212 401.936C587.927 401.97 588.517 401.853 588.982 401.584C589.456 401.311 589.661 400.962 589.598 400.538C589.535 400.11 589.083 399.653 588.242 399.167C587.441 398.705 586.675 398.454 585.945 398.416C585.219 398.375 584.627 398.486 584.169 398.75C583.715 399.013 583.526 399.368 583.601 399.817C583.676 400.261 584.118 400.717 584.927 401.184ZM594.121 399.465L592.907 398.764L594.121 398.063L595.335 398.764L594.121 399.465ZM589.746 393.398L588.509 392.684L589.574 392.068L590.812 392.783L589.746 393.398ZM598.277 399.882L597.572 399.243C597.841 399.152 598.036 399.071 598.158 399C598.375 398.875 598.464 398.739 598.425 398.593C598.389 398.45 598.083 398.212 597.507 397.879L590.9 394.064L591.966 393.449L598.596 397.277C599.37 397.724 599.808 398.093 599.911 398.385C600.049 398.761 599.82 399.121 599.224 399.465C598.936 399.631 598.62 399.77 598.277 399.882ZM597.59 395.295L598.478 394.591C598.96 394.8 599.447 394.893 599.94 394.868C600.438 394.84 600.929 394.687 601.414 394.406C601.904 394.124 602.168 393.857 602.208 393.606C602.243 393.354 602.127 393.15 601.858 392.995C601.618 392.856 601.324 392.807 600.976 392.848C600.736 392.877 600.252 393.017 599.526 393.268C598.547 393.605 597.835 393.821 597.389 393.914C596.943 394.003 596.515 394.02 596.104 393.965C595.694 393.906 595.335 393.788 595.027 393.61C594.746 393.448 594.551 393.262 594.441 393.053C594.33 392.839 594.306 392.622 594.37 392.403C594.413 392.237 594.535 392.048 594.737 391.836C594.938 391.619 595.202 391.417 595.53 391.228C596.023 390.943 596.526 390.734 597.04 390.602C597.557 390.468 598.026 390.42 598.448 390.458C598.867 390.495 599.313 390.611 599.786 390.807L598.887 391.491C598.516 391.331 598.125 391.265 597.714 391.292C597.308 391.318 596.897 391.45 596.483 391.689C595.994 391.972 595.725 392.22 595.678 392.434C595.631 392.648 595.715 392.818 595.932 392.943C596.071 393.023 596.238 393.07 596.436 393.083C596.637 393.099 596.868 393.076 597.128 393.012C597.274 392.973 597.679 392.844 598.342 392.625C599.297 392.306 599.988 392.099 600.414 392.003C600.84 391.903 601.261 391.875 601.675 391.918C602.089 391.961 602.478 392.088 602.841 392.297C603.196 392.502 603.427 392.757 603.534 393.06C603.64 393.358 603.585 393.67 603.368 393.996C603.147 394.32 602.79 394.624 602.297 394.909C601.48 395.38 600.686 395.642 599.917 395.695C599.151 395.745 598.375 395.612 597.59 395.295Z"
            fill="#6FEC5B"
          />
          <path
            d="M612.418 380.294L611.193 379.587L612.258 378.972L613.484 379.679L612.418 380.294ZM619.872 384.598L613.584 380.968L614.65 380.353L620.937 383.982L619.872 384.598ZM622.565 383.042L616.278 379.413L617.237 378.859L618.131 379.375C617.902 378.71 618.224 378.125 619.096 377.622C619.475 377.403 619.891 377.242 620.345 377.14C620.799 377.033 621.215 376.997 621.594 377.034C621.973 377.07 622.346 377.158 622.713 377.297C622.95 377.388 623.315 377.576 623.808 377.861L627.674 380.093L626.609 380.708L622.784 378.5C622.35 378.249 621.985 378.086 621.689 378.011C621.389 377.934 621.069 377.92 620.73 377.97C620.391 378.016 620.079 378.121 619.795 378.285C619.341 378.547 619.092 378.857 619.049 379.214C619.009 379.57 619.392 379.98 620.197 380.445L623.631 382.427L622.565 383.042ZM633.393 376.791L632.6 376.333C632.825 376.923 632.55 377.442 631.777 377.888C631.276 378.178 630.676 378.364 629.977 378.449C629.283 378.531 628.572 378.497 627.846 378.346C627.12 378.191 626.435 377.928 625.792 377.557C625.164 377.194 624.7 376.806 624.4 376.391C624.097 375.974 624.018 375.566 624.164 375.167C624.31 374.769 624.641 374.42 625.158 374.122C625.537 373.903 625.955 373.755 626.413 373.677C626.867 373.597 627.315 373.578 627.757 373.619L624.643 371.821L625.703 371.209L634.382 376.22L633.393 376.791ZM626.887 376.924C627.692 377.389 628.464 377.639 629.202 377.673C629.94 377.707 630.54 377.591 631.001 377.324C631.467 377.055 631.672 376.718 631.617 376.312C631.562 375.902 631.143 375.472 630.362 375.021C629.502 374.524 628.704 374.255 627.97 374.214C627.236 374.173 626.626 374.292 626.141 374.573C625.667 374.846 625.464 375.187 625.531 375.595C625.602 376 626.054 376.444 626.887 376.924ZM638.342 371.596L639.58 371.039C640.049 371.51 640.227 371.984 640.112 372.46C639.998 372.937 639.576 373.386 638.845 373.807C637.926 374.338 636.914 374.597 635.808 374.583C634.703 374.565 633.64 374.261 632.618 373.67C631.56 373.06 631.011 372.429 630.972 371.777C630.932 371.125 631.347 370.549 632.215 370.047C633.056 369.562 634.028 369.331 635.134 369.354C636.239 369.376 637.31 369.687 638.348 370.287C638.411 370.323 638.504 370.379 638.626 370.454L633.938 373.161C634.668 373.537 635.392 373.73 636.11 373.739C636.829 373.748 637.45 373.601 637.975 373.298C638.366 373.072 638.597 372.82 638.668 372.542C638.739 372.264 638.63 371.949 638.342 371.596ZM633.121 372.621L636.631 370.594C636.055 370.316 635.524 370.165 635.039 370.14C634.289 370.099 633.644 370.234 633.103 370.546C632.614 370.829 632.365 371.162 632.357 371.544C632.353 371.925 632.608 372.284 633.121 372.621ZM642.102 371.763L641.131 368.55L635.986 368.034L637.318 367.265L639.757 367.559C640.219 367.616 640.6 367.667 640.9 367.713C640.813 367.462 640.742 367.237 640.687 367.036L640.26 365.566L641.533 364.832L642.321 367.795L647.986 368.366L646.678 369.121L643.434 368.738L642.563 368.632L643.392 371.018L642.102 371.763ZM649.176 367.679L647.962 366.978L649.176 366.277L650.39 366.978L649.176 367.679ZM644.801 361.612L643.564 360.897L644.629 360.282L645.867 360.997L644.801 361.612ZM653.332 368.096L652.627 367.457C652.896 367.365 653.091 367.285 653.214 367.214C653.431 367.089 653.519 366.953 653.48 366.807C653.444 366.664 653.139 366.425 652.562 366.093L645.956 362.278L647.021 361.663L653.652 365.491C654.425 365.938 654.863 366.307 654.966 366.599C655.104 366.975 654.875 367.335 654.279 367.679C653.991 367.845 653.675 367.984 653.332 368.096ZM652.645 363.509L653.533 362.805C654.015 363.014 654.502 363.107 654.995 363.082C655.493 363.054 655.984 362.9 656.47 362.62C656.959 362.338 657.223 362.071 657.263 361.82C657.298 361.567 657.182 361.363 656.914 361.208C656.673 361.069 656.379 361.021 656.032 361.062C655.791 361.091 655.307 361.231 654.581 361.482C653.602 361.819 652.89 362.035 652.444 362.128C651.998 362.217 651.57 362.234 651.159 362.179C650.749 362.12 650.39 362.001 650.082 361.824C649.802 361.662 649.606 361.476 649.496 361.267C649.385 361.052 649.362 360.836 649.425 360.617C649.468 360.451 649.59 360.262 649.792 360.05C649.993 359.833 650.257 359.631 650.585 359.441C651.078 359.157 651.582 358.948 652.095 358.816C652.612 358.681 653.081 358.634 653.504 358.672C653.922 358.709 654.368 358.825 654.842 359.021L653.942 359.705C653.571 359.545 653.18 359.479 652.77 359.506C652.363 359.531 651.953 359.664 651.538 359.903C651.049 360.185 650.78 360.434 650.733 360.648C650.686 360.862 650.771 361.032 650.988 361.157C651.126 361.237 651.293 361.284 651.491 361.297C651.692 361.313 651.923 361.289 652.183 361.226C652.329 361.187 652.734 361.058 653.397 360.839C654.352 360.52 655.043 360.313 655.469 360.217C655.895 360.117 656.316 360.089 656.73 360.132C657.144 360.175 657.533 360.302 657.896 360.511C658.252 360.716 658.482 360.97 658.589 361.273C658.696 361.572 658.64 361.884 658.423 362.21C658.202 362.534 657.845 362.838 657.352 363.123C656.535 363.594 655.741 363.856 654.972 363.909C654.206 363.959 653.431 363.826 652.645 363.509Z"
            fill="#757678"
          />
          <path
            d="M672.122 352.264L673.01 351.56C673.492 351.769 673.979 351.861 674.473 351.836C674.97 351.809 675.461 351.655 675.947 351.375C676.436 351.092 676.701 350.826 676.74 350.575C676.775 350.322 676.659 350.118 676.391 349.963C676.15 349.824 675.856 349.775 675.509 349.816C675.268 349.846 674.784 349.986 674.058 350.237C673.079 350.574 672.367 350.789 671.921 350.883C671.475 350.972 671.047 350.989 670.636 350.934C670.226 350.875 669.867 350.756 669.559 350.579C669.279 350.417 669.083 350.231 668.973 350.021C668.862 349.807 668.839 349.591 668.902 349.372C668.945 349.206 669.068 349.017 669.269 348.805C669.47 348.588 669.735 348.385 670.062 348.196C670.555 347.911 671.059 347.703 671.572 347.571C672.089 347.436 672.558 347.389 672.981 347.427C673.399 347.464 673.845 347.58 674.319 347.776L673.419 348.459C673.048 348.3 672.657 348.234 672.247 348.261C671.84 348.286 671.43 348.418 671.015 348.658C670.526 348.94 670.257 349.189 670.21 349.403C670.163 349.617 670.248 349.787 670.465 349.912C670.603 349.992 670.771 350.039 670.968 350.052C671.169 350.068 671.4 350.044 671.661 349.98C671.807 349.942 672.211 349.813 672.874 349.594C673.829 349.275 674.52 349.068 674.946 348.972C675.372 348.872 675.793 348.843 676.207 348.887C676.622 348.93 677.01 349.056 677.373 349.266C677.729 349.471 677.96 349.725 678.066 350.028C678.173 350.327 678.117 350.639 677.9 350.965C677.679 351.288 677.322 351.593 676.829 351.877C676.012 352.349 675.219 352.611 674.449 352.664C673.683 352.714 672.908 352.58 672.122 352.264ZM681.861 347.708L682.956 348.162C682.719 348.372 682.482 348.545 682.246 348.682C681.859 348.905 681.498 349.043 681.162 349.095C680.827 349.148 680.517 349.142 680.233 349.078C679.945 349.012 679.481 348.794 678.842 348.425L675.224 346.337L674.443 346.788L673.614 346.31L674.396 345.858L672.839 344.959L673.259 343.979L675.455 345.247L676.527 344.628L677.356 345.106L676.284 345.725L679.961 347.848C680.264 348.023 680.478 348.126 680.6 348.155C680.726 348.183 680.856 348.187 680.991 348.169C681.129 348.148 681.277 348.093 681.435 348.001C681.553 347.933 681.695 347.835 681.861 347.708ZM686.236 349.078L685.117 348.569C685.413 348.471 685.648 348.372 685.821 348.271C686.058 348.135 686.208 348.003 686.271 347.875C686.334 347.747 686.34 347.616 686.289 347.482C686.25 347.382 686.094 347.166 685.821 346.836C685.782 346.79 685.727 346.722 685.656 346.631L676.971 344.372L678.119 343.708L683.069 345.055C683.7 345.224 684.337 345.416 684.981 345.633C684.614 345.28 684.282 344.92 683.986 344.553L681.665 341.661L682.731 341.046L686.733 346.118C687.167 346.665 687.444 347.055 687.562 347.287C687.724 347.599 687.763 347.873 687.68 348.107C687.601 348.344 687.392 348.561 687.053 348.757C686.848 348.875 686.575 348.982 686.236 349.078ZM689.9 344.167L681.221 339.156L682.287 338.541L690.966 343.551L689.9 344.167ZM694.903 338.94L696.14 338.383C696.61 338.855 696.787 339.329 696.673 339.805C696.558 340.281 696.136 340.73 695.406 341.152C694.486 341.683 693.474 341.941 692.369 341.928C691.264 341.91 690.2 341.605 689.178 341.015C688.12 340.404 687.572 339.773 687.532 339.122C687.493 338.47 687.907 337.893 688.776 337.392C689.616 336.907 690.589 336.675 691.694 336.698C692.799 336.721 693.871 337.032 694.909 337.631C694.972 337.668 695.065 337.724 695.187 337.799L690.498 340.506C691.228 340.882 691.953 341.074 692.671 341.083C693.389 341.093 694.011 340.946 694.536 340.643C694.927 340.417 695.157 340.165 695.228 339.887C695.299 339.609 695.191 339.294 694.903 338.94ZM689.681 339.966L693.192 337.939C692.616 337.661 692.085 337.509 691.599 337.484C690.85 337.443 690.204 337.579 689.664 337.891C689.174 338.174 688.926 338.506 688.918 338.889C688.914 339.27 689.168 339.629 689.681 339.966ZM697.07 337.86L697.958 337.156C698.439 337.366 698.927 337.458 699.42 337.433C699.917 337.406 700.409 337.252 700.894 336.972C701.383 336.689 701.648 336.423 701.687 336.172C701.723 335.919 701.606 335.715 701.338 335.56C701.097 335.421 700.803 335.372 700.456 335.413C700.215 335.443 699.732 335.583 699.005 335.833C698.027 336.171 697.314 336.386 696.868 336.479C696.422 336.568 695.994 336.585 695.584 336.531C695.173 336.472 694.814 336.353 694.506 336.175C694.226 336.014 694.031 335.828 693.92 335.618C693.81 335.404 693.786 335.188 693.849 334.969C693.892 334.802 694.015 334.613 694.216 334.401C694.417 334.185 694.682 333.982 695.009 333.793C695.503 333.508 696.006 333.3 696.519 333.167C697.036 333.033 697.506 332.985 697.928 333.024C698.346 333.06 698.792 333.177 699.266 333.373L698.366 334.056C697.995 333.897 697.604 333.831 697.194 333.858C696.787 333.883 696.377 334.015 695.963 334.254C695.473 334.537 695.205 334.785 695.157 335C695.11 335.214 695.195 335.383 695.412 335.509C695.55 335.589 695.718 335.635 695.915 335.649C696.116 335.665 696.347 335.641 696.608 335.577C696.754 335.538 697.158 335.41 697.821 335.191C698.777 334.872 699.467 334.665 699.893 334.569C700.32 334.469 700.74 334.44 701.154 334.483C701.569 334.527 701.958 334.653 702.321 334.863C702.676 335.068 702.907 335.322 703.013 335.625C703.12 335.924 703.065 336.236 702.848 336.562C702.627 336.885 702.269 337.189 701.776 337.474C700.959 337.946 700.166 338.208 699.396 338.26C698.631 338.31 697.855 338.177 697.07 337.86ZM705.737 335.023L704.523 334.323L705.737 333.622L706.95 334.323L705.737 335.023ZM710.609 329.551L711.793 329.025C712.401 329.508 712.673 330.005 712.61 330.515C712.547 331.021 712.172 331.472 711.485 331.869C710.625 332.365 709.652 332.604 708.566 332.583C707.481 332.558 706.413 332.242 705.364 331.636C704.685 331.244 704.203 330.836 703.919 330.413C703.635 329.989 703.596 329.572 703.801 329.162C704.006 328.747 704.379 328.383 704.92 328.071C705.602 327.677 706.335 327.455 707.116 327.405C707.893 327.352 708.661 327.474 709.419 327.771L708.543 328.461C708.022 328.274 707.528 328.192 707.063 328.215C706.601 328.235 706.192 328.348 705.837 328.553C705.3 328.863 705.058 329.227 705.109 329.644C705.156 330.058 705.596 330.506 706.429 330.987C707.274 331.474 708.049 331.735 708.756 331.77C709.462 331.804 710.076 331.67 710.597 331.37C711.015 331.128 711.236 330.852 711.26 330.542C711.284 330.233 711.067 329.902 710.609 329.551ZM712.568 328.912L713.456 328.208C713.938 328.418 714.425 328.51 714.919 328.485C715.416 328.458 715.907 328.304 716.393 328.023C716.882 327.741 717.147 327.474 717.186 327.224C717.222 326.971 717.105 326.767 716.837 326.612C716.596 326.473 716.302 326.424 715.955 326.465C715.714 326.494 715.23 326.635 714.504 326.885C713.525 327.222 712.813 327.438 712.367 327.531C711.921 327.62 711.493 327.637 711.082 327.583C710.672 327.523 710.313 327.405 710.005 327.227C709.725 327.065 709.529 326.88 709.419 326.67C709.308 326.456 709.285 326.239 709.348 326.021C709.391 325.854 709.514 325.665 709.715 325.453C709.916 325.237 710.181 325.034 710.508 324.845C711.002 324.56 711.505 324.351 712.018 324.219C712.535 324.085 713.005 324.037 713.427 324.076C713.845 324.112 714.291 324.228 714.765 324.424L713.865 325.108C713.494 324.948 713.103 324.882 712.693 324.91C712.286 324.935 711.876 325.067 711.461 325.306C710.972 325.589 710.704 325.837 710.656 326.051C710.609 326.265 710.694 326.435 710.911 326.561C711.049 326.64 711.217 326.687 711.414 326.701C711.615 326.717 711.846 326.693 712.107 326.629C712.253 326.59 712.657 326.461 713.32 326.243C714.275 325.924 714.966 325.716 715.392 325.621C715.819 325.52 716.239 325.492 716.653 325.535C717.068 325.578 717.456 325.705 717.82 325.915C718.175 326.12 718.406 326.374 718.512 326.677C718.619 326.975 718.563 327.287 718.346 327.613C718.125 327.937 717.768 328.241 717.275 328.526C716.458 328.998 715.665 329.26 714.895 329.312C714.129 329.362 713.354 329.229 712.568 328.912ZM718.631 325.412L719.519 324.708C720 324.918 720.488 325.01 720.981 324.985C721.478 324.958 721.97 324.804 722.455 324.523C722.944 324.241 723.209 323.974 723.248 323.724C723.284 323.471 723.167 323.267 722.899 323.112C722.658 322.973 722.364 322.924 722.017 322.965C721.776 322.994 721.293 323.135 720.566 323.385C719.588 323.722 718.875 323.938 718.429 324.031C717.983 324.12 717.555 324.137 717.145 324.083C716.734 324.023 716.375 323.905 716.067 323.727C715.787 323.565 715.592 323.38 715.481 323.17C715.371 322.956 715.347 322.739 715.41 322.521C715.453 322.354 715.576 322.165 715.777 321.953C715.978 321.737 716.243 321.534 716.57 321.345C717.064 321.06 717.567 320.851 718.08 320.719C718.597 320.585 719.067 320.537 719.489 320.576C719.907 320.612 720.353 320.728 720.827 320.924L719.927 321.608C719.556 321.448 719.165 321.382 718.755 321.41C718.348 321.435 717.938 321.567 717.524 321.806C717.034 322.089 716.766 322.337 716.718 322.551C716.671 322.765 716.756 322.935 716.973 323.061C717.111 323.14 717.279 323.187 717.476 323.201C717.677 323.217 717.908 323.193 718.169 323.129C718.315 323.09 718.719 322.961 719.382 322.743C720.338 322.424 721.028 322.216 721.454 322.121C721.881 322.02 722.301 321.992 722.715 322.035C723.13 322.078 723.519 322.205 723.882 322.415C724.237 322.62 724.468 322.874 724.574 323.177C724.681 323.475 724.626 323.787 724.409 324.113C724.188 324.437 723.83 324.741 723.337 325.026C722.52 325.498 721.727 325.76 720.957 325.812C720.192 325.862 719.416 325.729 718.631 325.412Z"
            fill="#757678"
          />
          <path
            d="M733.662 310.294L732.436 309.587L733.502 308.972L734.727 309.679L733.662 310.294ZM741.115 314.598L734.828 310.968L735.894 310.353L742.181 313.982L741.115 314.598ZM743.809 313.042L737.522 309.413L738.481 308.859L739.375 309.375C739.146 308.71 739.467 308.125 740.34 307.622C740.719 307.403 741.135 307.242 741.589 307.14C742.043 307.033 742.459 306.997 742.838 307.034C743.217 307.07 743.59 307.158 743.957 307.297C744.194 307.388 744.559 307.576 745.052 307.861L748.918 310.093L747.852 310.708L744.028 308.5C743.594 308.249 743.229 308.086 742.933 308.011C742.633 307.934 742.313 307.92 741.974 307.97C741.634 308.016 741.322 308.121 741.038 308.285C740.584 308.547 740.336 308.857 740.292 309.214C740.253 309.57 740.636 309.98 741.441 310.445L744.874 312.427L743.809 313.042ZM754.637 306.791L753.843 306.333C754.068 306.923 753.794 307.442 753.021 307.888C752.519 308.178 751.919 308.364 751.221 308.449C750.526 308.531 749.816 308.497 749.09 308.346C748.363 308.191 747.679 307.928 747.035 307.557C746.408 307.194 745.944 306.806 745.644 306.391C745.34 305.974 745.261 305.566 745.407 305.167C745.553 304.769 745.885 304.42 746.402 304.122C746.781 303.903 747.199 303.755 747.657 303.677C748.111 303.597 748.559 303.578 749.001 303.619L745.887 301.821L746.947 301.209L755.625 306.22L754.637 306.791ZM748.131 306.924C748.936 307.389 749.707 307.639 750.445 307.673C751.183 307.707 751.783 307.591 752.245 307.324C752.711 307.055 752.916 306.718 752.861 306.312C752.805 305.902 752.387 305.472 751.606 305.021C750.745 304.524 749.948 304.255 749.214 304.214C748.48 304.173 747.87 304.292 747.385 304.573C746.911 304.846 746.708 305.187 746.775 305.595C746.846 306 747.298 306.444 748.131 306.924ZM759.586 301.596L760.823 301.039C761.293 301.51 761.47 301.984 761.356 302.46C761.242 302.937 760.819 303.386 760.089 303.807C759.17 304.338 758.157 304.597 757.052 304.583C755.947 304.565 754.883 304.261 753.861 303.67C752.803 303.06 752.255 302.429 752.215 301.777C752.176 301.125 752.59 300.549 753.459 300.047C754.299 299.562 755.272 299.331 756.377 299.354C757.482 299.376 758.554 299.687 759.592 300.287C759.655 300.323 759.748 300.379 759.87 300.454L755.181 303.161C755.912 303.537 756.636 303.73 757.354 303.739C758.072 303.748 758.694 303.601 759.219 303.298C759.61 303.072 759.84 302.82 759.912 302.542C759.983 302.264 759.874 301.949 759.586 301.596ZM754.364 302.621L757.875 300.594C757.299 300.316 756.768 300.165 756.283 300.14C755.533 300.099 754.887 300.234 754.347 300.546C753.857 300.829 753.609 301.162 753.601 301.544C753.597 301.925 753.851 302.284 754.364 302.621ZM763.345 301.763L762.374 298.55L757.23 298.034L758.562 297.265L761.001 297.559C761.463 297.616 761.843 297.667 762.143 297.713C762.057 297.462 761.986 297.237 761.93 297.036L761.504 295.566L762.777 294.832L763.564 297.795L769.23 298.366L767.921 299.121L764.677 298.738L763.807 298.632L764.636 301.018L763.345 301.763ZM770.42 297.679L769.206 296.978L770.42 296.277L771.633 296.978L770.42 297.679ZM773.492 295.905L764.813 290.894L765.879 290.279L768.993 292.077C768.914 291.457 769.253 290.928 770.011 290.491C770.477 290.222 770.974 290.042 771.503 289.951C772.028 289.857 772.525 289.862 772.995 289.964C773.469 290.065 774.013 290.292 774.629 290.648L778.613 292.948L777.547 293.563L773.563 291.263C773.03 290.956 772.527 290.799 772.054 290.795C771.58 290.786 771.132 290.903 770.71 291.147C770.394 291.329 770.179 291.549 770.064 291.807C769.95 292.06 769.974 292.301 770.136 292.531C770.297 292.761 770.625 293.019 771.118 293.304L774.558 295.29L773.492 295.905ZM781.615 290.115L782.71 290.569C782.473 290.779 782.236 290.952 781.999 291.089C781.613 291.312 781.251 291.45 780.916 291.502C780.581 291.555 780.271 291.549 779.987 291.485C779.698 291.419 779.235 291.202 778.595 290.833L774.978 288.744L774.197 289.195L773.368 288.717L774.149 288.266L772.592 287.367L773.013 286.386L775.209 287.654L776.281 287.035L777.109 287.514L776.038 288.132L779.714 290.255C780.018 290.43 780.231 290.533 780.354 290.562C780.48 290.59 780.61 290.594 780.744 290.576C780.882 290.556 781.03 290.5 781.188 290.409C781.307 290.34 781.449 290.242 781.615 290.115ZM783.616 290.06L777.328 286.43L778.282 285.88L779.164 286.389C779.053 286.097 779.069 285.804 779.211 285.507C779.349 285.209 779.627 284.939 780.046 284.697C780.511 284.428 780.989 284.264 781.478 284.205C781.972 284.144 782.453 284.178 782.923 284.308C782.686 283.597 782.966 283.011 783.764 282.551C784.387 282.191 785.04 282.014 785.723 282.021C786.402 282.026 787.101 282.235 787.819 282.65L792.135 285.142L791.075 285.753L787.114 283.467C786.688 283.221 786.347 283.065 786.09 282.999C785.834 282.928 785.557 282.912 785.261 282.951C784.965 282.989 784.695 283.079 784.45 283.221C784.008 283.476 783.789 283.773 783.793 284.113C783.793 284.45 784.117 284.806 784.764 285.179L788.417 287.288L787.351 287.903L783.266 285.545C782.793 285.271 782.351 285.117 781.94 285.08C781.53 285.044 781.127 285.139 780.733 285.367C780.433 285.54 780.233 285.747 780.135 285.986C780.04 286.223 780.087 286.462 780.277 286.704C780.466 286.945 780.847 287.231 781.419 287.562L784.681 289.445L783.616 290.06ZM793.692 284.243L785.013 279.232L786.078 278.617L794.757 283.627L793.692 284.243Z"
            fill="#757678"
          />
          <path d="M577.498 424.062L625.129 396.563" stroke="#6FEC5B" />
        </g>
        <path
          className={styles.line2}
          d="M833.712 302.561L869.219 282.061C874.002 279.299 874.002 274.822 869.219 272.061L669.167 156.561"
          stroke="#888888"
          strokeOpacity="0.5"
        />
        <path
          className={styles.line3}
          d="M107.304 367.812L30.6603 323.563C25.8773 320.801 25.8773 316.324 30.6603 313.562L329.382 141.096"
          stroke="#888888"
          strokeOpacity="0.5"
        />
        <g className={styles.code2}>
          <rect
            fill="#282828"
            height="124.628"
            rx="10"
            transform="matrix(0.866025 -0.5 0.866025 0.5 36 279.637)"
            width="437.275"
          />
          <path
            d="M97.4787 285.265C97.8066 285.076 98.0577 284.868 98.232 284.643C98.4104 284.416 98.537 284.184 98.6117 283.95L99.807 284.05C99.7655 284.357 99.614 284.667 99.3525 284.981C99.0911 285.295 98.7674 285.563 98.3814 285.786C97.7298 286.162 97.0347 286.403 96.2959 286.509C95.5572 286.609 94.8143 286.583 94.0673 286.429C93.3161 286.274 92.5981 285.998 91.9133 285.603C91.2576 285.224 90.7907 284.816 90.5126 284.377C90.2346 283.934 90.1744 283.494 90.3321 283.058C90.494 282.62 90.9028 282.211 91.5585 281.833C91.9777 281.591 92.4342 281.401 92.9281 281.265C93.4219 281.123 93.949 281.037 94.5093 281.006L94.696 281.703C94.2229 281.751 93.7975 281.829 93.4198 281.937C93.0422 282.04 92.7081 282.175 92.4176 282.343C91.8532 282.669 91.6 283.059 91.6581 283.515C91.7162 283.97 92.1789 284.448 93.0463 284.949C93.6274 285.284 94.1856 285.511 94.7209 285.628C95.2563 285.741 95.7564 285.763 96.2212 285.696C96.686 285.624 97.1052 285.481 97.4787 285.265ZM98.5446 277.799C99.163 277.442 99.8208 277.225 100.518 277.149C101.215 277.067 101.923 277.114 102.641 277.289C103.363 277.461 104.071 277.748 104.764 278.148C105.432 278.534 105.915 278.937 106.214 279.359C106.513 279.781 106.6 280.198 106.476 280.61C106.351 281.017 105.982 281.398 105.368 281.753C104.753 282.107 104.095 282.324 103.394 282.403C102.693 282.482 101.979 282.437 101.253 282.267C100.526 282.092 99.8208 281.807 99.136 281.411C98.4595 281.021 97.9719 280.615 97.6731 280.193C97.3743 279.771 97.2913 279.357 97.4241 278.949C97.5569 278.537 97.9304 278.154 98.5446 277.799ZM99.3975 278.292C98.8331 278.617 98.6152 278.985 98.7438 279.395C98.8725 279.8 99.3767 280.256 100.257 280.764C101.12 281.263 101.902 281.551 102.603 281.63C103.309 281.707 103.944 281.583 104.508 281.257C105.073 280.931 105.287 280.565 105.15 280.16C105.017 279.753 104.515 279.298 103.643 278.795C102.772 278.292 101.987 278.002 101.29 277.925C100.589 277.846 99.9578 277.968 99.3975 278.292ZM110.206 278.794L103.651 275.009L104.541 274.495L105.531 274.973C105.46 274.626 105.535 274.286 105.755 273.953C105.975 273.615 106.274 273.337 106.651 273.119C107.295 272.747 107.932 272.576 108.562 272.605C109.197 272.631 109.818 272.819 110.424 273.169L115.186 275.919L114.14 276.522L110.15 274.219C109.702 273.96 109.316 273.766 108.992 273.636C108.664 273.505 108.359 273.448 108.077 273.467C107.791 273.484 107.481 273.588 107.149 273.78C106.892 273.929 106.705 274.101 106.589 274.298C106.477 274.492 106.417 274.689 106.408 274.891C106.4 275.087 106.423 275.268 106.477 275.433L111.252 278.19L110.206 278.794ZM119.178 272.78C119.68 272.49 119.983 272.207 120.087 271.932C120.191 271.652 120.085 271.42 119.769 271.238C119.57 271.123 119.361 271.045 119.141 271.005C118.925 270.961 118.647 270.971 118.306 271.033C117.966 271.096 117.505 271.227 116.924 271.429C116.36 271.625 115.837 271.779 115.356 271.889C114.874 271.994 114.422 272.033 113.998 272.004C113.579 271.973 113.181 271.848 112.803 271.63C112.434 271.417 112.22 271.173 112.162 270.9C112.104 270.622 112.191 270.335 112.423 270.038C112.652 269.738 113.013 269.446 113.507 269.161C114.034 268.856 114.563 268.632 115.094 268.489C115.625 268.34 116.13 268.245 116.607 268.205L116.856 268.88C116.437 268.926 116.024 269.004 115.617 269.114C115.206 269.222 114.789 269.398 114.366 269.642C113.851 269.94 113.567 270.197 113.513 270.415C113.455 270.631 113.552 270.812 113.805 270.958C113.996 271.068 114.208 271.13 114.44 271.145C114.673 271.154 114.968 271.116 115.324 271.03C115.677 270.941 116.136 270.803 116.7 270.616C117.24 270.434 117.746 270.298 118.219 270.207C118.696 270.113 119.153 270.089 119.589 270.135C120.025 270.18 120.446 270.32 120.852 270.555C121.317 270.824 121.562 271.118 121.587 271.439C121.608 271.758 121.473 272.078 121.182 272.399C120.892 272.715 120.512 273.009 120.043 273.28C119.45 273.622 118.858 273.866 118.269 274.009C117.68 274.148 117.121 274.229 116.594 274.25L116.501 273.506C116.97 273.48 117.437 273.409 117.902 273.294C118.367 273.174 118.792 273.003 119.178 272.78ZM130.011 266.978C129.937 267.194 129.781 267.418 129.544 267.65C129.308 267.883 129.036 268.088 128.729 268.265C128.023 268.672 127.295 268.88 126.544 268.887C125.793 268.894 125.126 268.73 124.545 268.394L120.636 266.137L119.129 267.007L118.32 266.54L119.827 265.67L118.339 264.811L119.26 264.135L120.873 265.066L123.139 263.758L123.823 264.297L121.682 265.533L125.579 267.783C125.944 267.994 126.318 268.1 126.699 268.1C127.085 268.097 127.502 267.967 127.951 267.708C128.196 267.567 128.393 267.419 128.542 267.266C128.691 267.113 128.81 266.958 128.897 266.802L130.011 266.978Z"
            fill="#C798E3"
          />
          <path
            d="M142.272 259.404C142.599 259.215 142.85 259.007 143.025 258.782C143.203 258.554 143.33 258.323 143.405 258.088L144.6 258.189C144.558 258.496 144.407 258.806 144.145 259.12C143.884 259.434 143.56 259.702 143.174 259.925C142.523 260.301 141.827 260.542 141.089 260.647C140.35 260.748 139.607 260.722 138.86 260.568C138.109 260.413 137.391 260.137 136.706 259.742C136.05 259.363 135.584 258.955 135.305 258.516C135.027 258.073 134.967 257.633 135.125 257.197C135.287 256.759 135.696 256.35 136.351 255.971C136.77 255.729 137.227 255.54 137.721 255.404C138.215 255.262 138.742 255.176 139.302 255.145L139.489 255.842C139.016 255.89 138.59 255.968 138.213 256.076C137.835 256.179 137.501 256.314 137.21 256.482C136.646 256.808 136.393 257.198 136.451 257.653C136.509 258.109 136.972 258.587 137.839 259.088C138.42 259.423 138.978 259.649 139.514 259.767C140.049 259.879 140.549 259.902 141.014 259.835C141.479 259.763 141.898 259.619 142.272 259.404ZM143.337 251.938C143.956 251.581 144.614 251.364 145.311 251.287C146.008 251.206 146.716 251.253 147.434 251.428C148.156 251.6 148.863 251.886 149.556 252.287C150.225 252.672 150.708 253.076 151.007 253.498C151.306 253.92 151.393 254.336 151.268 254.749C151.144 255.156 150.775 255.537 150.16 255.892C149.546 256.246 148.888 256.463 148.187 256.542C147.486 256.621 146.772 256.576 146.045 256.406C145.319 256.231 144.614 255.945 143.929 255.55C143.252 255.16 142.765 254.753 142.466 254.332C142.167 253.91 142.084 253.495 142.217 253.088C142.35 252.676 142.723 252.293 143.337 251.938ZM144.19 252.43C143.626 252.756 143.408 253.124 143.537 253.534C143.665 253.939 144.17 254.395 145.049 254.903C145.913 255.402 146.695 255.69 147.396 255.769C148.102 255.846 148.737 255.721 149.301 255.396C149.866 255.07 150.079 254.704 149.942 254.299C149.81 253.892 149.307 253.437 148.436 252.934C147.564 252.43 146.78 252.14 146.083 252.064C145.381 251.985 144.751 252.107 144.19 252.43ZM149.595 245.284L150.772 244.756L159.966 250.065L159.051 250.593L158.086 250.151C158.19 250.494 158.163 250.804 158.006 251.082C157.852 251.357 157.595 251.599 157.234 251.808C156.665 252.136 156.053 252.324 155.397 252.372C154.741 252.42 154.069 252.348 153.38 252.156C152.687 251.962 152.002 251.67 151.326 251.279C150.67 250.901 150.187 250.504 149.875 250.09C149.56 249.673 149.446 249.269 149.533 248.879C149.62 248.483 149.933 248.13 150.473 247.818C150.851 247.6 151.249 247.447 151.668 247.358C152.083 247.267 152.527 247.231 153 247.25L149.595 245.284ZM151.587 248.145C151.039 248.462 150.832 248.828 150.965 249.245C151.098 249.662 151.598 250.121 152.465 250.622C153.029 250.948 153.563 251.186 154.065 251.337C154.567 251.488 155.03 251.551 155.453 251.527C155.881 251.501 156.265 251.39 156.605 251.193C156.978 250.978 157.19 250.733 157.24 250.46C157.294 250.184 157.275 249.92 157.184 249.666L153.909 247.775C153.465 247.725 153.044 247.731 152.646 247.793C152.243 247.853 151.89 247.97 151.587 248.145ZM160.379 246.47C160.906 246.75 161.418 246.933 161.916 247.02C162.41 247.103 162.877 247.107 163.317 247.03C163.753 246.951 164.139 246.815 164.475 246.621C164.811 246.427 165.064 246.223 165.234 246.01C165.409 245.794 165.542 245.547 165.633 245.269L166.816 245.384C166.749 245.701 166.587 246.012 166.33 246.319C166.077 246.623 165.745 246.894 165.334 247.131C164.699 247.498 164.014 247.728 163.28 247.821C162.545 247.915 161.804 247.882 161.057 247.724C160.31 247.561 159.598 247.284 158.922 246.894C158.258 246.51 157.787 246.102 157.509 245.668C157.231 245.234 157.158 244.809 157.291 244.392C157.424 243.975 157.781 243.599 158.362 243.264C158.914 242.945 159.52 242.746 160.18 242.667C160.835 242.586 161.51 242.623 162.203 242.778C162.896 242.929 163.574 243.197 164.238 243.58C164.35 243.645 164.454 243.707 164.55 243.767C164.641 243.824 164.72 243.877 164.786 243.925L160.379 246.47ZM159.233 243.752C158.748 244.033 158.513 244.367 158.53 244.755C158.551 245.141 158.899 245.556 159.576 245.999L162.993 244.026C162.28 243.628 161.599 243.412 160.951 243.379C160.3 243.343 159.727 243.467 159.233 243.752Z"
            fill="#6FEC5B"
          />
          <path
            d="M176.797 233.993L177.7 234.514L172.857 237.31L171.954 236.789L176.797 233.993ZM179.157 235.355L180.066 235.88L175.223 238.676L174.314 238.151L179.157 235.355Z"
            fill="#CFCFCF"
          />
          <path
            d="M188.143 224.855L184.47 225.638L184.14 224.801L187.906 224.323L188.143 224.855ZM197.706 224.919C198.233 225.199 198.746 225.382 199.244 225.469C199.738 225.553 200.204 225.556 200.644 225.479C201.08 225.4 201.466 225.264 201.802 225.07C202.138 224.876 202.392 224.672 202.562 224.459C202.736 224.243 202.869 223.996 202.96 223.718L204.143 223.833C204.077 224.15 203.915 224.461 203.657 224.768C203.404 225.072 203.072 225.343 202.661 225.58C202.026 225.947 201.342 226.177 200.607 226.27C199.872 226.364 199.132 226.331 198.385 226.173C197.638 226.01 196.926 225.733 196.249 225.343C195.585 224.959 195.114 224.551 194.836 224.117C194.558 223.684 194.486 223.258 194.618 222.841C194.751 222.424 195.108 222.048 195.689 221.713C196.241 221.394 196.847 221.195 197.507 221.116C198.163 221.035 198.837 221.072 199.53 221.228C200.223 221.378 200.902 221.646 201.566 222.029C201.678 222.094 201.782 222.156 201.877 222.216C201.968 222.273 202.047 222.326 202.114 222.374L197.706 224.919ZM196.561 222.202C196.075 222.482 195.841 222.816 195.857 223.204C195.878 223.59 196.227 224.005 196.903 224.448L200.321 222.475C199.607 222.077 198.926 221.861 198.279 221.828C197.627 221.792 197.054 221.916 196.561 222.202ZM207.892 222.395L206.697 223.085L205.657 219.688L200.44 219.128L201.679 218.413L205.638 218.944L204.736 216.648L205.931 215.958L206.865 218.941L212.785 219.57L211.503 220.31L206.896 219.721L207.892 222.395ZM210.962 212.895C211.543 212.559 212.147 212.374 212.774 212.338C213.405 212.299 214.054 212.384 214.722 212.593C215.386 212.799 216.061 213.1 216.746 213.495C217.406 213.876 217.901 214.27 218.234 214.677C218.566 215.08 218.692 215.474 218.613 215.86C218.534 216.246 218.211 216.603 217.642 216.931C216.924 217.345 216.094 217.532 215.152 217.492L218.277 219.296L217.362 219.975L208.167 214.667L209.057 214.153L210.06 214.631C209.964 214.298 209.991 213.983 210.141 213.685C210.294 213.386 210.568 213.122 210.962 212.895ZM211.554 213.524C211.193 213.732 210.983 213.98 210.925 214.268C210.867 214.55 210.881 214.82 210.969 215.076L214.218 216.952C214.642 217 215.057 216.993 215.463 216.931C215.87 216.864 216.229 216.74 216.54 216.561C217.084 216.247 217.285 215.891 217.144 215.493C217.003 215.096 216.495 214.644 215.619 214.138C215.046 213.808 214.517 213.564 214.031 213.409C213.542 213.251 213.094 213.181 212.687 213.2C212.276 213.217 211.898 213.325 211.554 213.524ZM217.992 208.836C218.61 208.479 219.268 208.262 219.965 208.186C220.663 208.104 221.37 208.151 222.088 208.326C222.81 208.498 223.518 208.785 224.211 209.185C224.879 209.57 225.363 209.974 225.662 210.396C225.96 210.818 226.048 211.235 225.923 211.647C225.799 212.054 225.429 212.435 224.815 212.79C224.201 213.144 223.543 213.361 222.842 213.44C222.14 213.519 221.426 213.474 220.7 213.304C219.974 213.129 219.268 212.844 218.583 212.448C217.907 212.058 217.419 211.652 217.121 211.23C216.822 210.808 216.739 210.394 216.872 209.986C217.004 209.574 217.378 209.191 217.992 208.836ZM218.845 209.328C218.281 209.654 218.063 210.022 218.191 210.432C218.32 210.837 218.824 211.293 219.704 211.801C220.567 212.3 221.35 212.588 222.051 212.667C222.756 212.744 223.391 212.62 223.956 212.294C224.52 211.968 224.734 211.602 224.597 211.197C224.464 210.79 223.962 210.335 223.091 209.832C222.219 209.328 221.435 209.039 220.737 208.962C220.036 208.883 219.405 209.005 218.845 209.328ZM229.716 209.795L228.913 209.331L229.934 208.742L224.984 205.884L223.963 206.474L223.16 206.01L224.978 204.961L226.721 205.744C226.435 205.287 226.325 204.869 226.391 204.49C226.458 204.111 226.788 203.751 227.381 203.408C227.564 203.303 227.74 203.218 227.91 203.153C228.08 203.083 228.261 203.018 228.452 202.955L229.081 203.67C228.906 203.728 228.755 203.784 228.626 203.839C228.493 203.892 228.354 203.96 228.209 204.044C227.707 204.334 227.454 204.686 227.45 205.101C227.445 205.515 227.697 205.994 228.203 206.535L230.979 208.138L232.312 207.369L233.115 207.833L229.716 209.795ZM229.66 204.817L228.234 203.994L227.549 203.476L228.452 202.955L230.519 204.321L229.66 204.817ZM241.993 202.325C241.919 202.541 241.763 202.765 241.526 202.998C241.29 203.23 241.018 203.435 240.711 203.612C240.005 204.02 239.277 204.227 238.526 204.234C237.775 204.241 237.108 204.077 236.527 203.742L232.618 201.484L231.111 202.354L230.302 201.887L231.809 201.017L230.321 200.158L231.242 199.483L232.855 200.413L235.121 199.105L235.805 199.644L233.664 200.881L237.561 203.131C237.926 203.341 238.3 203.447 238.681 203.447C239.067 203.444 239.484 203.314 239.933 203.055C240.178 202.914 240.375 202.766 240.524 202.613C240.673 202.46 240.792 202.305 240.879 202.149L241.993 202.325ZM246.646 189.252L247.823 188.724L257.018 194.032L256.102 194.561L255.138 194.118C255.241 194.461 255.214 194.771 255.057 195.049C254.903 195.325 254.646 195.567 254.285 195.775C253.716 196.104 253.104 196.292 252.448 196.34C251.792 196.388 251.12 196.316 250.431 196.124C249.738 195.93 249.053 195.638 248.377 195.247C247.721 194.868 247.238 194.472 246.926 194.057C246.611 193.64 246.497 193.237 246.584 192.846C246.671 192.451 246.984 192.097 247.524 191.786C247.902 191.568 248.3 191.414 248.719 191.326C249.134 191.235 249.578 191.199 250.051 191.218L246.646 189.252ZM248.638 192.113C248.091 192.429 247.883 192.796 248.016 193.213C248.149 193.63 248.649 194.088 249.516 194.589C250.081 194.915 250.614 195.154 251.116 195.305C251.618 195.455 252.081 195.519 252.504 195.495C252.932 195.469 253.316 195.357 253.656 195.161C254.029 194.945 254.241 194.701 254.291 194.428C254.345 194.152 254.326 193.887 254.235 193.633L250.96 191.743C250.516 191.692 250.095 191.698 249.697 191.761C249.294 191.821 248.941 191.938 248.638 192.113ZM257.43 190.437C257.957 190.718 258.469 190.901 258.967 190.987C259.461 191.071 259.928 191.075 260.368 190.998C260.804 190.919 261.19 190.782 261.526 190.588C261.862 190.394 262.115 190.19 262.286 189.977C262.46 189.762 262.593 189.515 262.684 189.237L263.867 189.352C263.8 189.668 263.638 189.98 263.381 190.286C263.128 190.591 262.796 190.861 262.385 191.099C261.75 191.465 261.065 191.695 260.331 191.789C259.596 191.882 258.855 191.85 258.108 191.692C257.361 191.529 256.65 191.252 255.973 190.861C255.309 190.478 254.838 190.069 254.56 189.636C254.282 189.202 254.209 188.777 254.342 188.36C254.475 187.943 254.832 187.567 255.413 187.231C255.965 186.913 256.571 186.714 257.231 186.635C257.886 186.553 258.561 186.59 259.254 186.746C259.947 186.897 260.625 187.164 261.289 187.548C261.402 187.612 261.505 187.675 261.601 187.734C261.692 187.792 261.771 187.845 261.837 187.893L257.43 190.437ZM256.284 187.72C255.799 188 255.564 188.335 255.581 188.723C255.602 189.109 255.95 189.523 256.627 189.966L260.044 187.993C259.331 187.595 258.65 187.38 258.003 187.346C257.351 187.31 256.778 187.435 256.284 187.72ZM261.527 180.66C261.88 180.457 262.231 180.29 262.579 180.161C262.928 180.031 263.287 179.925 263.656 179.841L264.098 180.484C263.795 180.554 263.503 180.644 263.221 180.754C262.938 180.864 262.671 180.992 262.418 181.138C261.961 181.402 261.706 181.652 261.652 181.89C261.602 182.124 261.762 182.348 262.131 182.562L263.463 183.331L265.686 182.048L266.396 182.587L264.285 183.805L269.508 186.821L268.462 187.425L263.239 184.409L261.677 185.311L260.855 184.837L262.418 183.935L261.11 183.18C260.704 182.945 260.457 182.683 260.369 182.393C260.286 182.1 260.347 181.804 260.55 181.505C260.749 181.203 261.075 180.921 261.527 180.66ZM277.708 180.433C277.97 180.584 278.204 180.669 278.412 180.688C278.619 180.707 278.843 180.681 279.084 180.609L279.563 181.181C279.244 181.322 278.908 181.413 278.555 181.454C278.198 181.492 277.827 181.455 277.441 181.342C277.507 181.654 277.443 181.957 277.248 182.252C277.048 182.544 276.735 182.814 276.308 183.06C275.652 183.439 274.95 183.631 274.203 183.635C273.456 183.64 272.778 183.467 272.168 183.114C271.491 182.724 271.236 182.272 271.402 181.759C271.568 181.247 272.149 180.703 273.145 180.128L274.11 179.57L273.562 179.254C273.089 178.981 272.616 178.868 272.143 178.916C271.67 178.959 271.188 179.122 270.699 179.405C270.483 179.53 270.257 179.691 270.02 179.89C269.779 180.087 269.549 180.318 269.329 180.584L268.264 180.286C268.518 179.967 268.789 179.688 269.08 179.448C269.371 179.209 269.676 178.997 269.995 178.812C270.813 178.34 271.616 178.097 272.404 178.083C273.193 178.063 273.913 178.242 274.564 178.618L277.708 180.433ZM275.778 182.446C276.102 182.259 276.33 182.034 276.463 181.77C276.592 181.504 276.606 181.232 276.507 180.954L274.82 179.98L273.873 180.527C273.151 180.943 272.765 181.31 272.716 181.626C272.67 181.94 272.857 182.218 273.276 182.46C273.683 182.695 274.096 182.814 274.515 182.816C274.934 182.814 275.355 182.69 275.778 182.446ZM276.402 175.271L281.046 177.952C281.478 178.202 281.878 178.33 282.248 178.337C282.617 178.344 282.991 178.239 283.368 178.021C283.729 177.812 283.968 177.557 284.084 177.255C284.2 176.948 284.207 176.662 284.103 176.396L279.278 173.611L280.324 173.007L286.879 176.791L285.989 177.305L285.018 176.845C285.093 177.186 285.031 177.516 284.831 177.837C284.628 178.156 284.333 178.427 283.947 178.65C283.312 179.016 282.669 179.194 282.017 179.182C281.366 179.165 280.735 178.98 280.125 178.628L275.356 175.875L276.402 175.271ZM282.735 168.567L290.311 172.941C290.635 173.128 290.965 173.204 291.301 173.168C291.637 173.127 291.965 173.014 292.284 172.83C292.484 172.715 292.652 172.594 292.789 172.467C292.926 172.34 293.048 172.204 293.156 172.061L294.202 172.341C294.11 172.494 293.965 172.667 293.766 172.859C293.575 173.05 293.314 173.242 292.982 173.434C292.401 173.769 291.77 173.949 291.089 173.973C290.404 173.994 289.778 173.841 289.209 173.513L282.517 169.649L280.506 170.81L279.678 170.332L282.735 168.567ZM301.717 167.844C301.642 168.06 301.487 168.284 301.25 168.516C301.014 168.749 300.742 168.953 300.435 169.131C299.729 169.538 299.001 169.745 298.25 169.752C297.498 169.76 296.832 169.596 296.251 169.26L292.342 167.003L290.835 167.873L290.026 167.405L291.532 166.536L290.045 165.677L290.966 165.001L292.578 165.932L294.844 164.624L295.529 165.163L293.388 166.399L297.285 168.649C297.65 168.86 298.023 168.965 298.405 168.965C298.791 168.963 299.208 168.832 299.656 168.574C299.901 168.432 300.098 168.285 300.248 168.132C300.397 167.978 300.516 167.824 300.603 167.668L301.717 167.844ZM306.32 154.799C306.673 154.596 307.024 154.429 307.372 154.3C307.721 154.17 308.08 154.064 308.449 153.98L308.891 154.623C308.588 154.693 308.296 154.782 308.013 154.893C307.731 155.003 307.464 155.131 307.21 155.277C306.754 155.541 306.499 155.791 306.445 156.028C306.395 156.263 306.555 156.487 306.924 156.7L308.256 157.47L310.479 156.187L311.188 156.726L309.078 157.944L314.301 160.96L313.255 161.563L308.032 158.548L306.47 159.45L305.648 158.976L307.21 158.073L305.903 157.319C305.496 157.084 305.249 156.821 305.162 156.532C305.079 156.239 305.139 155.943 305.343 155.644C305.542 155.342 305.868 155.06 306.32 154.799ZM313.73 153.72L318.374 156.401C318.805 156.651 319.206 156.779 319.575 156.786C319.945 156.793 320.318 156.688 320.696 156.47C321.057 156.261 321.295 156.006 321.412 155.704C321.528 155.397 321.534 155.111 321.43 154.845L316.606 152.06L317.652 151.456L324.207 155.24L323.317 155.754L322.345 155.294C322.42 155.635 322.358 155.965 322.159 156.286C321.955 156.605 321.661 156.876 321.275 157.099C320.64 157.465 319.996 157.643 319.345 157.631C318.693 157.614 318.062 157.429 317.452 157.077L312.684 154.324L313.73 153.72ZM326.704 153.798L320.149 150.014L321.039 149.5L322.029 149.978C321.959 149.63 322.033 149.29 322.253 148.957C322.473 148.619 322.772 148.341 323.15 148.123C323.793 147.752 324.43 147.581 325.061 147.609C325.696 147.636 326.316 147.824 326.922 148.174L331.685 150.923L330.639 151.527L326.648 149.223C326.2 148.964 325.814 148.77 325.491 148.641C325.163 148.509 324.858 148.453 324.575 148.472C324.289 148.489 323.98 148.593 323.648 148.785C323.391 148.933 323.204 149.106 323.088 149.302C322.976 149.496 322.915 149.694 322.907 149.895C322.899 150.092 322.922 150.273 322.976 150.438L327.75 153.195L326.704 153.798ZM336.374 147.339C336.702 147.15 336.953 146.942 337.127 146.717C337.305 146.49 337.432 146.258 337.507 146.023L338.702 146.124C338.66 146.431 338.509 146.741 338.247 147.055C337.986 147.369 337.662 147.637 337.276 147.86C336.625 148.236 335.93 148.477 335.191 148.583C334.452 148.683 333.709 148.657 332.962 148.503C332.211 148.348 331.493 148.072 330.808 147.677C330.153 147.298 329.686 146.89 329.408 146.451C329.13 146.008 329.069 145.568 329.227 145.132C329.389 144.694 329.798 144.285 330.453 143.906C330.873 143.664 331.329 143.475 331.823 143.339C332.317 143.197 332.844 143.111 333.404 143.08L333.591 143.777C333.118 143.825 332.692 143.903 332.315 144.011C331.937 144.114 331.603 144.249 331.313 144.417C330.748 144.743 330.495 145.133 330.553 145.589C330.611 146.044 331.074 146.522 331.941 147.023C332.522 147.358 333.081 147.585 333.616 147.702C334.151 147.815 334.651 147.837 335.116 147.77C335.581 147.698 336 147.555 336.374 147.339ZM346.51 141.983C346.435 142.198 346.279 142.423 346.043 142.655C345.806 142.887 345.535 143.092 345.227 143.27C344.522 143.677 343.794 143.884 343.042 143.891C342.291 143.899 341.625 143.734 341.044 143.399L337.135 141.142L335.628 142.012L334.819 141.544L336.325 140.675L334.837 139.816L335.759 139.14L337.371 140.071L339.637 138.762L340.322 139.302L338.18 140.538L342.077 142.788C342.443 142.999 342.816 143.104 343.198 143.104C343.584 143.102 344.001 142.971 344.449 142.712C344.694 142.571 344.891 142.424 345.041 142.27C345.19 142.117 345.308 141.962 345.395 141.807L346.51 141.983ZM345.864 135.168L351.591 138.474L353.44 137.407L354.268 137.885L349.35 140.724L348.522 140.246L350.545 139.078L345.646 136.249L343.685 137.382L342.857 136.903L345.864 135.168ZM341.96 133.877C342.193 133.743 342.448 133.677 342.726 133.68C343.008 133.68 343.251 133.738 343.455 133.856C343.666 133.978 343.774 134.122 343.778 134.287C343.782 134.447 343.668 134.595 343.436 134.729C343.216 134.856 342.965 134.92 342.683 134.92C342.396 134.917 342.147 134.855 341.936 134.733C341.732 134.615 341.631 134.475 341.631 134.312C341.631 134.149 341.741 134.004 341.96 133.877ZM352.371 131.253C352.989 130.896 353.647 130.679 354.344 130.602C355.041 130.521 355.749 130.567 356.467 130.742C357.189 130.915 357.896 131.201 358.59 131.601C359.258 131.987 359.741 132.391 360.04 132.813C360.339 133.234 360.426 133.651 360.302 134.063C360.177 134.471 359.808 134.852 359.193 135.206C358.579 135.561 357.921 135.778 357.22 135.857C356.519 135.936 355.805 135.89 355.078 135.72C354.352 135.545 353.647 135.26 352.962 134.865C352.285 134.474 351.798 134.068 351.499 133.646C351.2 133.225 351.117 132.81 351.25 132.403C351.383 131.991 351.756 131.607 352.371 131.253ZM353.223 131.745C352.659 132.071 352.441 132.439 352.57 132.848C352.698 133.253 353.203 133.71 354.082 134.218C354.946 134.716 355.728 135.005 356.429 135.084C357.135 135.161 357.77 135.036 358.334 134.71C358.899 134.384 359.112 134.019 358.976 133.614C358.843 133.207 358.341 132.751 357.469 132.248C356.597 131.745 355.813 131.455 355.116 131.378C354.414 131.299 353.784 131.422 353.223 131.745ZM364.032 132.247L357.477 128.463L358.367 127.949L359.357 128.427C359.286 128.079 359.361 127.739 359.581 127.406C359.801 127.068 360.099 126.79 360.477 126.572C361.12 126.201 361.757 126.03 362.388 126.058C363.023 126.085 363.644 126.273 364.25 126.623L369.012 129.372L367.966 129.976L363.976 127.672C363.528 127.413 363.142 127.219 362.818 127.09C362.49 126.958 362.185 126.902 361.903 126.921C361.616 126.938 361.307 127.042 360.975 127.234C360.718 127.382 360.531 127.555 360.415 127.751C360.303 127.945 360.243 128.143 360.234 128.344C360.226 128.541 360.249 128.722 360.303 128.887L365.078 131.644L364.032 132.247ZM380.924 119.972L377.531 121.931L379.031 123.588L377.967 124.202L372.183 117.643L373.565 116.845L384.927 120.184L383.794 120.838L380.924 119.972ZM376.915 121.251L379.747 119.616L373.758 117.783L376.915 121.251ZM382.668 113.76C383.249 113.425 383.853 113.239 384.48 113.203C385.111 113.165 385.76 113.25 386.428 113.458C387.092 113.664 387.767 113.965 388.451 114.361C389.111 114.742 389.607 115.136 389.939 115.543C390.271 115.946 390.398 116.34 390.319 116.726C390.24 117.111 389.916 117.468 389.348 117.797C388.63 118.211 387.8 118.398 386.858 118.357L389.983 120.162L389.068 120.841L379.873 115.532L380.763 115.018L381.765 115.496C381.67 115.163 381.697 114.848 381.846 114.551C382 114.252 382.274 113.988 382.668 113.76ZM383.26 114.389C382.898 114.598 382.689 114.846 382.631 115.133C382.573 115.416 382.587 115.686 382.674 115.942L385.924 117.818C386.347 117.866 386.762 117.859 387.169 117.797C387.576 117.729 387.935 117.606 388.246 117.426C388.79 117.112 388.991 116.757 388.85 116.359C388.709 115.961 388.2 115.509 387.325 115.004C386.752 114.673 386.223 114.43 385.737 114.274C385.247 114.116 384.799 114.047 384.393 114.066C383.982 114.083 383.604 114.19 383.26 114.389ZM390.134 109.45C390.715 109.115 391.318 108.929 391.945 108.893C392.576 108.855 393.225 108.94 393.894 109.148C394.558 109.354 395.232 109.655 395.917 110.05C396.577 110.431 397.073 110.826 397.405 111.233C397.737 111.635 397.863 112.03 397.784 112.415C397.706 112.801 397.382 113.158 396.813 113.486C396.095 113.901 395.265 114.088 394.323 114.047L397.448 115.851L396.533 116.531L387.338 111.222L388.229 110.708L389.231 111.186C389.135 110.853 389.162 110.538 389.312 110.241C389.465 109.941 389.739 109.678 390.134 109.45ZM390.725 110.079C390.364 110.288 390.154 110.536 390.096 110.823C390.038 111.106 390.053 111.375 390.14 111.632L393.389 113.508C393.813 113.556 394.228 113.549 394.634 113.486C395.041 113.419 395.4 113.296 395.711 113.116C396.255 112.802 396.456 112.446 396.315 112.049C396.174 111.651 395.666 111.199 394.79 110.694C394.217 110.363 393.688 110.12 393.203 109.964C392.713 109.806 392.265 109.736 391.858 109.756C391.447 109.772 391.069 109.88 390.725 110.079ZM398.396 107.376C399.259 107.874 400.104 108.249 400.93 108.5C401.76 108.75 402.631 108.91 403.544 108.982C404.457 109.054 405.472 109.07 406.588 109.029L406.613 109.676C405.389 109.745 404.248 109.752 403.189 109.697C402.135 109.64 401.125 109.481 400.158 109.219C399.195 108.956 398.242 108.552 397.3 108.008C396.354 107.462 395.653 106.911 395.196 106.355C394.744 105.796 394.468 105.213 394.368 104.604C394.273 103.993 394.287 103.336 394.412 102.631L395.532 102.646C395.482 103.134 395.482 103.587 395.532 104.004C395.582 104.416 395.709 104.808 395.912 105.179C396.111 105.548 396.412 105.914 396.815 106.276C397.217 106.633 397.744 106.999 398.396 107.376ZM408.04 101.807C407.389 101.431 406.752 101.128 406.129 100.898C405.507 100.663 404.876 100.488 404.237 100.373C403.593 100.256 402.913 100.184 402.195 100.158C401.477 100.127 400.694 100.125 399.848 100.154L399.823 99.5071C401.047 99.4328 402.186 99.4244 403.241 99.4819C404.295 99.5395 405.303 99.7 406.266 99.9636C407.233 100.225 408.19 100.628 409.136 101.175C410.078 101.719 410.775 102.27 411.228 102.828C411.684 103.384 411.962 103.966 412.062 104.575C412.161 105.183 412.149 105.842 412.024 106.552L410.904 106.537C410.974 105.893 410.947 105.307 410.823 104.78C410.698 104.253 410.418 103.751 409.983 103.274C409.551 102.795 408.903 102.306 408.04 101.807ZM417.723 89.237L418.545 89.7114C418.242 89.8864 417.997 90.0637 417.81 90.2434C417.624 90.4183 417.534 90.5872 417.543 90.7502C417.555 90.9107 417.698 91.0581 417.972 91.1922L420.786 92.5149C421.172 92.6946 421.44 92.8731 421.589 93.0504C421.739 93.2277 421.784 93.4074 421.726 93.5895C421.672 93.7693 421.529 93.9573 421.297 94.1538C421.637 94.0149 421.963 93.9274 422.274 93.8915C422.581 93.8531 422.886 93.8783 423.189 93.9669C423.488 94.0532 423.803 94.2137 424.135 94.4485L426.426 96.0731C426.663 96.2336 426.92 96.3175 427.198 96.3247C427.476 96.3319 427.769 96.2804 428.076 96.1702C428.383 96.0599 428.688 95.9174 428.991 95.7424L429.813 96.2169C429.464 96.4181 429.099 96.5931 428.717 96.7416C428.339 96.8926 427.956 96.9968 427.565 97.0543C427.175 97.1118 426.791 97.1034 426.414 97.0292C426.04 96.9573 425.683 96.7991 425.343 96.5547L423.226 95.0452C422.973 94.8607 422.706 94.7373 422.423 94.675C422.145 94.6103 421.815 94.6307 421.434 94.7361C421.052 94.8367 420.583 95.0476 420.027 95.3687L419.192 94.887C419.749 94.566 420.116 94.2964 420.294 94.0783C420.477 93.8579 420.512 93.6674 420.4 93.5069C420.292 93.3439 420.081 93.1906 419.765 93.0468L417.138 91.8176C416.715 91.6211 416.441 91.4151 416.316 91.1994C416.188 90.9814 416.171 90.7609 416.267 90.5381C416.366 90.3129 416.547 90.0912 416.808 89.8732C417.07 89.6503 417.375 89.4383 417.723 89.237ZM131.053 290.758L130.25 290.294L131.271 289.705L126.322 286.848L125.301 287.437L124.498 286.973L126.315 285.924L128.058 286.707C127.772 286.25 127.662 285.832 127.728 285.453C127.795 285.074 128.125 284.714 128.718 284.371C128.901 284.266 129.077 284.181 129.247 284.116C129.418 284.046 129.598 283.981 129.789 283.918L130.418 284.634C130.243 284.691 130.092 284.747 129.963 284.802C129.831 284.855 129.692 284.923 129.546 285.007C129.044 285.297 128.791 285.649 128.787 286.064C128.783 286.479 129.034 286.957 129.54 287.498L132.317 289.101L133.649 288.332L134.452 288.796L131.053 290.758ZM130.997 285.78L129.571 284.957L128.886 284.439L129.789 283.918L131.856 285.284L130.997 285.78ZM136.371 284.331C136.898 284.611 137.41 284.794 137.908 284.881C138.402 284.965 138.869 284.968 139.309 284.892C139.745 284.812 140.131 284.676 140.467 284.482C140.803 284.288 141.056 284.084 141.226 283.871C141.401 283.655 141.533 283.408 141.625 283.13L142.807 283.245C142.741 283.562 142.579 283.873 142.322 284.18C142.069 284.484 141.737 284.755 141.326 284.992C140.691 285.359 140.006 285.589 139.272 285.682C138.537 285.776 137.796 285.743 137.049 285.585C136.302 285.422 135.59 285.145 134.914 284.755C134.25 284.372 133.779 283.963 133.501 283.529C133.223 283.096 133.15 282.67 133.283 282.253C133.416 281.836 133.773 281.46 134.354 281.125C134.906 280.806 135.511 280.607 136.171 280.528C136.827 280.447 137.501 280.484 138.195 280.64C138.888 280.791 139.566 281.058 140.23 281.441C140.342 281.506 140.446 281.568 140.541 281.628C140.633 281.686 140.712 281.738 140.778 281.786L136.371 284.331ZM135.225 281.614C134.74 281.894 134.505 282.228 134.522 282.616C134.542 283.002 134.891 283.417 135.567 283.86L138.985 281.887C138.271 281.489 137.591 281.273 136.943 281.24C136.292 281.204 135.719 281.328 135.225 281.614ZM150.796 278.978C150.721 279.194 150.566 279.418 150.329 279.65C150.092 279.883 149.821 280.088 149.513 280.265C148.808 280.672 148.08 280.88 147.328 280.887C146.577 280.894 145.911 280.73 145.33 280.394L141.421 278.137L139.914 279.007L139.105 278.54L140.611 277.67L139.123 276.811L140.045 276.135L141.657 277.066L143.923 275.758L144.608 276.297L142.466 277.533L146.363 279.783C146.729 279.994 147.102 280.1 147.484 280.1C147.87 280.097 148.287 279.967 148.735 279.708C148.98 279.567 149.177 279.419 149.327 279.266C149.476 279.113 149.594 278.958 149.682 278.802L150.796 278.978ZM147.878 273.475L152.522 276.156C152.953 276.405 153.354 276.534 153.723 276.541C154.092 276.548 154.466 276.442 154.844 276.224C155.205 276.016 155.443 275.761 155.56 275.459C155.676 275.152 155.682 274.866 155.578 274.6L150.754 271.814L151.799 271.211L158.355 274.995L157.464 275.509L156.493 275.049C156.568 275.389 156.506 275.72 156.307 276.041C156.103 276.36 155.809 276.631 155.423 276.853C154.788 277.22 154.144 277.397 153.493 277.385C152.841 277.369 152.21 277.184 151.6 276.832L146.832 274.079L147.878 273.475ZM160.915 273.517L160.112 273.054L161.133 272.464L156.183 269.607L155.162 270.196L154.359 269.733L156.177 268.683L157.92 269.467C157.634 269.009 157.524 268.591 157.59 268.212C157.657 267.834 157.987 267.473 158.58 267.13C158.763 267.025 158.939 266.94 159.109 266.875C159.279 266.806 159.46 266.74 159.651 266.678L160.28 267.393C160.105 267.45 159.954 267.507 159.825 267.562C159.692 267.614 159.553 267.683 159.408 267.767C158.906 268.056 158.653 268.409 158.649 268.823C158.644 269.238 158.896 269.716 159.402 270.257L162.178 271.86L163.511 271.091L164.314 271.555L160.915 273.517ZM160.859 268.539L159.433 267.716L158.748 267.199L159.651 266.678L161.718 268.043L160.859 268.539ZM168.318 269.243L161.763 265.458L162.653 264.944L163.643 265.422C163.572 265.075 163.647 264.735 163.867 264.402C164.087 264.064 164.386 263.786 164.763 263.568C165.407 263.196 166.044 263.025 166.674 263.054C167.309 263.08 167.93 263.268 168.536 263.618L173.298 266.368L172.252 266.971L168.262 264.668C167.814 264.409 167.428 264.215 167.104 264.085C166.776 263.954 166.471 263.897 166.189 263.916C165.902 263.933 165.593 264.037 165.261 264.229C165.004 264.378 164.817 264.55 164.701 264.747C164.589 264.941 164.529 265.138 164.52 265.34C164.512 265.536 164.535 265.717 164.589 265.882L169.364 268.639L168.318 269.243ZM180.485 253.679L181.792 253.851L180.093 257.945L187.208 256.978L187.414 257.744L179.725 258.768L178.655 258.15L180.485 253.679ZM182.466 250.342L186.101 252.441C186.014 252.094 186.072 251.763 186.276 251.449C186.479 251.131 186.774 250.86 187.16 250.637C187.799 250.268 188.436 250.097 189.071 250.123C189.706 250.15 190.326 250.338 190.932 250.688L195.694 253.437L194.649 254.041L189.911 251.306C189.517 251.078 189.139 250.965 188.778 250.968C188.413 250.968 188.035 251.08 187.645 251.306C187.396 251.449 187.216 251.618 187.104 251.813C186.992 252.007 186.929 252.203 186.917 252.402C186.904 252.601 186.927 252.784 186.985 252.952L191.76 255.709L190.714 256.312L181.532 251.011L182.466 250.342ZM193.007 245.091L201.33 249.896L200.284 250.5L193.094 246.349L192.322 248.174L191.12 248.005L192.091 245.619L193.007 245.091ZM202.519 248.512L203.372 249.005L198.423 251.862L197.57 251.37L202.519 248.512ZM198.598 243.221L206.342 242.164L207.413 242.782L205.645 247.218L204.307 247.099L205.988 242.994L198.885 243.968L198.598 243.221ZM217.213 241.013L213.148 238.666L209.911 240.535L213.976 242.882L212.899 243.504L204.327 238.555L205.404 237.933L209.027 240.025L212.264 238.156L208.641 236.064L209.718 235.442L218.29 240.391L217.213 241.013ZM218.491 236.919C219.018 237.199 219.53 237.382 220.028 237.469C220.522 237.553 220.989 237.556 221.429 237.479C221.865 237.4 222.251 237.264 222.587 237.07C222.923 236.876 223.176 236.672 223.346 236.459C223.521 236.243 223.653 235.996 223.745 235.718L224.928 235.833C224.861 236.15 224.699 236.461 224.442 236.768C224.189 237.072 223.857 237.343 223.446 237.58C222.811 237.947 222.126 238.177 221.392 238.27C220.657 238.364 219.916 238.331 219.169 238.173C218.422 238.01 217.71 237.733 217.034 237.343C216.37 236.959 215.899 236.551 215.621 236.117C215.343 235.684 215.27 235.258 215.403 234.841C215.536 234.424 215.893 234.048 216.474 233.713C217.026 233.394 217.632 233.195 218.291 233.116C218.947 233.035 219.622 233.072 220.315 233.228C221.008 233.378 221.686 233.646 222.35 234.029C222.462 234.094 222.566 234.156 222.662 234.216C222.753 234.273 222.832 234.326 222.898 234.374L218.491 236.919ZM217.345 234.202C216.86 234.482 216.625 234.816 216.642 235.204C216.663 235.59 217.011 236.005 217.688 236.448L221.105 234.475C220.391 234.077 219.711 233.861 219.063 233.828C218.412 233.792 217.839 233.916 217.345 234.202ZM221.399 227.979L228.975 232.353C229.299 232.54 229.629 232.616 229.965 232.58C230.301 232.539 230.629 232.426 230.949 232.242C231.148 232.127 231.316 232.006 231.453 231.879C231.59 231.752 231.712 231.617 231.82 231.473L232.866 231.753C232.775 231.906 232.63 232.079 232.43 232.271C232.24 232.462 231.978 232.654 231.646 232.846C231.065 233.181 230.434 233.361 229.754 233.385C229.069 233.406 228.442 233.253 227.874 232.925L221.181 229.061L219.171 230.222L218.343 229.744L221.399 227.979ZM228.865 223.669L236.441 228.043C236.765 228.23 237.095 228.306 237.431 228.27C237.767 228.229 238.095 228.116 238.414 227.932C238.613 227.817 238.782 227.696 238.919 227.569C239.055 227.442 239.178 227.306 239.286 227.163L240.332 227.443C240.24 227.596 240.095 227.769 239.896 227.961C239.705 228.152 239.444 228.344 239.111 228.536C238.53 228.871 237.9 229.051 237.219 229.075C236.534 229.096 235.908 228.943 235.339 228.615L228.647 224.751L226.636 225.912L225.808 225.434L228.865 223.669ZM238.777 220.836C239.395 220.479 240.053 220.262 240.75 220.186C241.447 220.104 242.155 220.151 242.873 220.326C243.595 220.498 244.303 220.785 244.996 221.185C245.664 221.57 246.147 221.974 246.446 222.396C246.745 222.818 246.832 223.235 246.708 223.647C246.583 224.054 246.214 224.435 245.6 224.79C244.985 225.144 244.328 225.361 243.626 225.44C242.925 225.519 242.211 225.474 241.485 225.304C240.758 225.129 240.053 224.844 239.368 224.448C238.692 224.058 238.204 223.652 237.905 223.23C237.606 222.808 237.523 222.394 237.656 221.986C237.789 221.574 238.162 221.191 238.777 220.836ZM239.63 221.328C239.065 221.654 238.847 222.022 238.976 222.432C239.105 222.837 239.609 223.293 240.489 223.801C241.352 224.3 242.134 224.588 242.836 224.667C243.541 224.744 244.176 224.62 244.741 224.294C245.305 223.968 245.519 223.602 245.382 223.197C245.249 222.79 244.747 222.335 243.875 221.832C243.004 221.328 242.219 221.039 241.522 220.962C240.821 220.883 240.19 221.005 239.63 221.328ZM252.4 210.641C252.961 210.318 253.5 210.088 254.019 209.951C254.538 209.815 255.104 209.727 255.718 209.689L255.818 210.444C255.32 210.468 254.872 210.54 254.473 210.659C254.075 210.774 253.712 210.927 253.384 211.116C252.915 211.387 252.593 211.702 252.419 212.061C252.241 212.418 252.286 212.816 252.556 213.254C252.826 213.688 253.398 214.158 254.274 214.663C255.125 215.155 255.922 215.483 256.665 215.648C257.412 215.811 258.096 215.845 258.719 215.749C259.342 215.653 259.896 215.465 260.381 215.184C260.863 214.907 261.184 214.637 261.346 214.376C261.512 214.112 261.616 213.861 261.657 213.621L262.927 213.707C262.919 214.004 262.799 214.328 262.566 214.678C262.33 215.025 261.906 215.375 261.296 215.727C260.603 216.127 259.804 216.392 258.9 216.522C257.999 216.649 257.057 216.617 256.073 216.428C255.085 216.236 254.112 215.864 253.154 215.31C252.191 214.754 251.547 214.191 251.224 213.621C250.904 213.048 250.854 212.504 251.074 211.989C251.298 211.472 251.74 211.022 252.4 210.641ZM261.173 207.906C261.791 207.549 262.449 207.332 263.147 207.255C263.844 207.174 264.551 207.22 265.269 207.395C265.991 207.568 266.699 207.854 267.392 208.254C268.06 208.64 268.544 209.044 268.843 209.465C269.141 209.887 269.229 210.304 269.104 210.716C268.98 211.123 268.61 211.504 267.996 211.859C267.382 212.214 266.724 212.431 266.023 212.51C265.321 212.589 264.607 212.543 263.881 212.373C263.155 212.198 262.449 211.913 261.764 211.518C261.088 211.127 260.6 210.721 260.302 210.299C260.003 209.878 259.92 209.463 260.053 209.056C260.185 208.644 260.559 208.26 261.173 207.906ZM262.026 208.398C261.462 208.724 261.244 209.092 261.372 209.501C261.501 209.906 262.005 210.363 262.885 210.871C263.748 211.369 264.531 211.658 265.232 211.737C265.938 211.814 266.572 211.689 267.137 211.363C267.701 211.037 267.915 210.672 267.778 210.267C267.645 209.86 267.143 209.404 266.272 208.901C265.4 208.398 264.616 208.108 263.918 208.031C263.217 207.952 262.586 208.074 262.026 208.398ZM267.431 201.252L268.607 200.724L277.802 206.032L276.887 206.561L275.922 206.118C276.026 206.461 275.999 206.771 275.841 207.049C275.688 207.325 275.43 207.567 275.069 207.775C274.501 208.104 273.889 208.292 273.233 208.34C272.577 208.388 271.905 208.316 271.216 208.124C270.523 207.93 269.838 207.638 269.161 207.247C268.506 206.868 268.022 206.472 267.711 206.057C267.396 205.64 267.281 205.237 267.369 204.846C267.456 204.451 267.769 204.097 268.309 203.786C268.686 203.568 269.085 203.414 269.504 203.326C269.919 203.235 270.363 203.199 270.836 203.218L267.431 201.252ZM269.423 204.113C268.875 204.429 268.668 204.796 268.8 205.213C268.933 205.63 269.433 206.088 270.301 206.589C270.865 206.915 271.398 207.154 271.901 207.305C272.403 207.455 272.866 207.519 273.289 207.495C273.716 207.469 274.1 207.357 274.441 207.161C274.814 206.945 275.026 206.701 275.076 206.428C275.129 206.152 275.111 205.887 275.019 205.633L271.745 203.743C271.301 203.692 270.88 203.698 270.481 203.761C270.079 203.821 269.726 203.938 269.423 204.113ZM278.214 202.437C278.741 202.718 279.254 202.901 279.752 202.987C280.246 203.071 280.713 203.075 281.153 202.998C281.589 202.919 281.974 202.782 282.311 202.588C282.647 202.394 282.9 202.19 283.07 201.977C283.244 201.762 283.377 201.515 283.469 201.237L284.651 201.352C284.585 201.668 284.423 201.98 284.166 202.286C283.913 202.591 283.581 202.861 283.17 203.099C282.535 203.465 281.85 203.695 281.115 203.789C280.381 203.882 279.64 203.85 278.893 203.692C278.146 203.529 277.434 203.252 276.758 202.861C276.094 202.478 275.623 202.069 275.345 201.636C275.066 201.202 274.994 200.777 275.127 200.36C275.259 199.943 275.616 199.567 276.197 199.231C276.749 198.913 277.355 198.714 278.015 198.635C278.671 198.553 279.345 198.59 280.038 198.746C280.731 198.897 281.41 199.164 282.074 199.548C282.186 199.612 282.29 199.675 282.385 199.734C282.477 199.792 282.555 199.845 282.622 199.893L278.214 202.437ZM277.069 199.72C276.583 200 276.349 200.335 276.365 200.723C276.386 201.109 276.735 201.523 277.411 201.966L280.829 199.993C280.115 199.595 279.435 199.38 278.787 199.346C278.136 199.31 277.563 199.435 277.069 199.72ZM290.822 195.776C291.312 196.059 291.625 196.381 291.762 196.743C291.895 197.103 291.837 197.479 291.588 197.872C291.334 198.262 290.874 198.651 290.206 199.036C289.579 199.398 288.915 199.671 288.214 199.856C287.516 200.038 286.813 200.133 286.103 200.14L286.022 199.353C286.599 199.341 287.164 199.271 287.716 199.144C288.263 199.015 288.797 198.8 289.315 198.501C289.664 198.3 289.934 198.079 290.125 197.84C290.311 197.597 290.382 197.355 290.336 197.113C290.287 196.869 290.081 196.643 289.72 196.434C289.442 196.274 289.151 196.168 288.849 196.118C288.546 196.068 288.182 196.078 287.759 196.15C287.332 196.22 286.8 196.354 286.165 196.553C285.435 196.783 284.759 196.958 284.136 197.078C283.513 197.193 282.935 197.227 282.399 197.182C281.868 197.134 281.376 196.979 280.924 196.718C280.496 196.471 280.235 196.184 280.139 195.856C280.044 195.527 280.11 195.189 280.339 194.842C280.567 194.49 280.953 194.157 281.496 193.843C282.09 193.5 282.69 193.252 283.296 193.099C283.902 192.941 284.541 192.85 285.213 192.826L285.281 193.598C284.7 193.618 284.173 193.694 283.7 193.828C283.223 193.96 282.802 194.132 282.437 194.342C282.125 194.522 281.887 194.715 281.721 194.921C281.555 195.122 281.486 195.322 281.515 195.521C281.544 195.715 281.702 195.895 281.988 196.06C282.233 196.202 282.511 196.286 282.822 196.312C283.134 196.338 283.522 196.304 283.987 196.208C284.447 196.11 285.03 195.95 285.736 195.73C286.309 195.548 286.881 195.404 287.454 195.298C288.027 195.188 288.595 195.162 289.16 195.219C289.72 195.274 290.274 195.46 290.822 195.776ZM298.493 192.433C298.754 192.584 298.989 192.669 299.196 192.688C299.404 192.707 299.628 192.681 299.869 192.609L300.348 193.181C300.028 193.322 299.692 193.413 299.339 193.454C298.983 193.492 298.611 193.455 298.225 193.342C298.292 193.654 298.227 193.957 298.032 194.252C297.833 194.544 297.52 194.814 297.092 195.06C296.436 195.439 295.735 195.631 294.988 195.635C294.241 195.64 293.562 195.467 292.952 195.114C292.276 194.724 292.021 194.272 292.187 193.759C292.353 193.247 292.934 192.703 293.93 192.128L294.895 191.57L294.347 191.254C293.874 190.981 293.401 190.868 292.927 190.916C292.454 190.959 291.973 191.122 291.483 191.405C291.267 191.53 291.041 191.691 290.805 191.89C290.564 192.087 290.334 192.318 290.114 192.584L289.049 192.286C289.302 191.967 289.574 191.688 289.865 191.448C290.155 191.209 290.46 190.997 290.78 190.812C291.597 190.34 292.4 190.097 293.189 190.083C293.977 190.063 294.698 190.242 295.349 190.618L298.493 192.433ZM296.563 194.446C296.887 194.259 297.115 194.034 297.248 193.77C297.376 193.504 297.391 193.232 297.291 192.954L295.604 191.98L294.658 192.527C293.936 192.943 293.55 193.31 293.5 193.626C293.455 193.94 293.641 194.218 294.06 194.46C294.467 194.695 294.88 194.814 295.299 194.816C295.718 194.814 296.14 194.69 296.563 194.446ZM302.696 191.66L296.141 187.875L297.031 187.361L298.021 187.839C297.951 187.492 298.025 187.151 298.245 186.818C298.465 186.48 298.764 186.202 299.142 185.984C299.785 185.613 300.422 185.442 301.053 185.47C301.688 185.497 302.308 185.685 302.914 186.035L307.676 188.784L306.631 189.388L302.64 187.084C302.192 186.825 301.806 186.631 301.482 186.502C301.154 186.37 300.849 186.314 300.567 186.333C300.281 186.35 299.972 186.454 299.64 186.646C299.382 186.794 299.196 186.967 299.079 187.163C298.967 187.357 298.907 187.555 298.899 187.756C298.891 187.953 298.913 188.134 298.967 188.299L303.742 191.056L302.696 191.66ZM304.758 179.701L305.935 179.173L315.13 184.481L314.214 185.01L313.249 184.567C313.353 184.91 313.326 185.22 313.169 185.498C313.015 185.774 312.758 186.016 312.397 186.224C311.828 186.553 311.216 186.741 310.56 186.789C309.904 186.837 309.232 186.765 308.543 186.573C307.85 186.379 307.165 186.087 306.489 185.696C305.833 185.317 305.35 184.921 305.038 184.506C304.723 184.089 304.609 183.686 304.696 183.295C304.783 182.9 305.096 182.546 305.636 182.235C306.014 182.017 306.412 181.863 306.831 181.775C307.246 181.684 307.69 181.648 308.163 181.667L304.758 179.701ZM306.75 182.562C306.202 182.878 305.995 183.245 306.128 183.662C306.261 184.079 306.761 184.538 307.628 185.038C308.192 185.364 308.726 185.603 309.228 185.754C309.73 185.905 310.193 185.968 310.616 185.944C311.044 185.918 311.428 185.806 311.768 185.61C312.141 185.394 312.353 185.15 312.403 184.877C312.457 184.601 312.438 184.336 312.347 184.082L309.072 182.192C308.628 182.141 308.207 182.147 307.809 182.21C307.406 182.27 307.053 182.387 306.75 182.562ZM312.971 179.143C312.896 178.822 312.929 178.523 313.07 178.245C313.211 177.962 313.471 177.711 313.848 177.493C314.434 177.156 315.048 176.964 315.691 176.918C316.334 176.873 316.996 176.951 317.677 177.152C318.353 177.351 319.034 177.648 319.719 178.043C320.379 178.424 320.868 178.822 321.188 179.237C321.503 179.649 321.616 180.051 321.524 180.444C321.437 180.835 321.111 181.193 320.547 181.519C319.787 181.957 318.918 182.143 317.938 182.076L318.542 182.511L317.627 183.039L308.432 177.731L309.348 177.051L312.971 179.143ZM319.451 181.174C319.999 180.858 320.209 180.492 320.08 180.078C319.951 179.663 319.449 179.203 318.573 178.697C318.001 178.367 317.467 178.126 316.974 177.975C316.476 177.822 316.017 177.758 315.598 177.785C315.179 177.806 314.801 177.914 314.465 178.108C314.1 178.319 313.888 178.568 313.83 178.856C313.772 179.138 313.786 179.408 313.873 179.664L317.123 181.54C317.55 181.591 317.97 181.586 318.38 181.526C318.795 181.464 319.152 181.346 319.451 181.174ZM320.897 173.424C321.515 173.067 322.173 172.85 322.87 172.773C323.567 172.692 324.275 172.739 324.993 172.914C325.715 173.086 326.423 173.372 327.116 173.773C327.784 174.158 328.268 174.562 328.566 174.984C328.865 175.406 328.952 175.823 328.828 176.235C328.703 176.642 328.334 177.023 327.72 177.378C327.106 177.732 326.448 177.949 325.746 178.028C325.045 178.107 324.331 178.062 323.605 177.892C322.879 177.717 322.173 177.431 321.488 177.036C320.812 176.646 320.324 176.239 320.025 175.818C319.726 175.396 319.643 174.981 319.776 174.574C319.909 174.162 320.283 173.779 320.897 173.424ZM321.75 173.916C321.185 174.242 320.967 174.61 321.096 175.02C321.225 175.425 321.729 175.881 322.609 176.389C323.472 176.888 324.254 177.176 324.956 177.255C325.661 177.332 326.296 177.207 326.861 176.882C327.425 176.556 327.639 176.19 327.502 175.785C327.369 175.378 326.867 174.923 325.995 174.42C325.124 173.916 324.339 173.626 323.642 173.55C322.941 173.471 322.31 173.593 321.75 173.916ZM333.193 174.052L331.998 174.742L330.958 171.346L325.741 170.785L326.98 170.07L330.94 170.602L330.037 168.305L331.232 167.615L332.166 170.598L338.086 171.227L336.804 171.968L332.197 171.378L333.193 174.052ZM337.255 163.168L338.562 163.34L336.863 167.434L346.599 166.104L346.804 166.869L336.495 168.257L335.424 167.639L337.255 163.168ZM348.068 167.599L346.842 167.869L340.896 157.967L342.142 157.722L348.068 167.599ZM346.706 155.518L350.342 157.617C350.254 157.27 350.313 156.939 350.516 156.625C350.719 156.307 351.014 156.036 351.4 155.813C352.039 155.444 352.676 155.273 353.311 155.299C353.946 155.325 354.566 155.514 355.172 155.863L359.935 158.613L358.889 159.217L354.151 156.482C353.757 156.254 353.38 156.141 353.018 156.144C352.653 156.144 352.276 156.256 351.885 156.482C351.636 156.625 351.456 156.794 351.344 156.988C351.232 157.182 351.17 157.379 351.157 157.578C351.145 157.777 351.167 157.96 351.226 158.128L356 160.884L354.955 161.488L345.772 156.187L346.706 155.518ZM357.247 150.266L365.57 155.072L364.524 155.676L357.334 151.524L356.562 153.35L355.361 153.181L356.332 150.795L357.247 150.266ZM366.759 153.688L367.612 154.181L362.663 157.038L361.81 156.545L366.759 153.688ZM362.838 148.397L370.583 147.34L371.653 147.958L369.885 152.393L368.547 152.275L370.228 148.17L363.125 149.144L362.838 148.397ZM127.039 305.063C127.388 304.862 127.753 304.687 128.135 304.539C128.513 304.388 128.897 304.283 129.287 304.226C129.677 304.168 130.061 304.177 130.438 304.251C130.816 304.321 131.173 304.479 131.509 304.726L133.638 306.242C133.887 306.424 134.161 306.542 134.46 306.595C134.763 306.645 135.105 306.617 135.487 306.512C135.869 306.406 136.315 306.206 136.826 305.912L137.66 306.393C137.153 306.686 136.809 306.944 136.626 307.17C136.444 307.39 136.396 307.588 136.483 307.763C136.574 307.935 136.78 308.094 137.099 308.241L139.714 309.463C140.137 309.659 140.411 309.865 140.536 310.081C140.664 310.299 140.679 310.521 140.579 310.746C140.484 310.969 140.303 311.19 140.038 311.411C139.78 311.631 139.477 311.842 139.129 312.043L138.307 311.569C138.61 311.394 138.855 311.219 139.042 311.044C139.233 310.867 139.324 310.697 139.316 310.534C139.307 310.371 139.162 310.222 138.88 310.088L136.066 308.765C135.659 308.574 135.383 308.39 135.238 308.215C135.089 308.038 135.055 307.856 135.138 307.669C135.226 307.48 135.414 307.275 135.705 307.055C135.327 307.21 134.968 307.31 134.628 307.353C134.292 307.394 133.968 307.372 133.657 307.288C133.346 307.204 133.032 307.052 132.717 306.832L130.426 305.207C130.198 305.047 129.942 304.964 129.66 304.959C129.378 304.954 129.085 305.006 128.782 305.114C128.475 305.219 128.168 305.361 127.861 305.538L127.039 305.063ZM140.126 300.577L136.453 301.361L136.123 300.523L139.89 300.045L140.126 300.577ZM152.186 300.177C152.477 300.01 152.817 299.928 153.207 299.933C153.597 299.933 153.927 300.011 154.197 300.167C154.35 300.255 154.485 300.355 154.601 300.465C154.722 300.573 154.834 300.712 154.938 300.882L156.245 302.801L155.299 303.347L153.425 301.575C152.96 301.623 152.547 301.543 152.186 301.335C151.908 301.174 151.767 300.982 151.763 300.76C151.763 300.534 151.904 300.34 152.186 300.177ZM147.884 297.694C148.175 297.526 148.513 297.443 148.899 297.446C149.289 297.446 149.623 297.526 149.901 297.687C150.175 297.845 150.316 298.039 150.325 298.269C150.333 298.494 150.192 298.691 149.901 298.858C149.619 299.021 149.281 299.102 148.887 299.099C148.492 299.092 148.158 299.009 147.884 298.851C147.606 298.691 147.465 298.499 147.461 298.276C147.461 298.051 147.602 297.857 147.884 297.694Z"
            fill="#E8E8E8"
          />
        </g>

        <defs>
          <clipPath id="clip1_945_4450">
            <rect
              fill="white"
              height="558.272"
              transform="translate(0 52.291)"
              width="966.955"
            />
          </clipPath>
          <clipPath id="clip2_945_4450">
            <rect
              fill="white"
              height="45.1466"
              transform="matrix(0.866025 -0.5 0.866025 0.5 755 137.562)"
              width="45.1466"
            />
          </clipPath>
          <clipPath id="clip3_945_4450">
            <rect
              fill="white"
              height="40"
              rx="10"
              transform="matrix(0.866025 -0.5 0.866025 0.5 529 412.062)"
              width="479"
            />
          </clipPath>
          <clipPath id="clip4_945_4450">
            <rect
              fill="white"
              height="124.628"
              transform="matrix(0.866025 -0.5 0.866025 0.5 36 279.637)"
              width="437.275"
            />
          </clipPath>
        </defs>
      </svg>
    </div>
  );
};

export default ProviderIllustration;
