import React from "react";

import styles from "./Components.module.css";

const ComponentsIllustration: React.FC<{ isActive: boolean }> = ({
  isActive,
}) => {
  return (
    <div className={isActive ? styles.active : ""}>
      <svg
        className={styles.svg}
        fill="none"
        height="650"
        viewBox="0 0 987 650"
        width="987"
        xmlns="http://www.w3.org/2000/svg"
      >
        <g className={styles.movement}>
          <g className={styles.navbar}>
            <rect
              fill="#191919"
              height="40"
              rx="10"
              transform="matrix(0.866025 -0.5 0.866025 0.5 0 459.5)"
              width="479"
            />
            <path
              d="M42.4173 460.01L37.0715 453.075L38.3088 452.361L50.5397 455.321L49.2314 456.076L45.5905 455.143L41.9615 457.238L43.6369 459.306L42.4173 460.01ZM41.3576 456.507L44.2999 454.808L40.9906 453.943C39.9842 453.681 39.179 453.453 38.5752 453.26C39.0212 453.645 39.4178 454.054 39.7651 454.487L41.3576 456.507ZM53.7306 456.261L45.034 451.24L46.0049 450.679L46.8219 451.151C46.7311 450.834 46.7508 450.547 46.8811 450.29C47.0074 450.03 47.2758 449.781 47.6862 449.544C48.223 449.235 48.8347 449.041 49.5214 448.963C50.2082 448.886 50.9087 448.933 51.6231 449.104C52.3335 449.272 52.9886 449.53 53.5885 449.876C54.2319 450.247 54.6956 450.65 54.9798 451.083C55.2639 451.511 55.3231 451.932 55.1574 452.347C54.9916 452.757 54.666 453.103 54.1806 453.383C53.8254 453.588 53.4307 453.729 52.9965 453.807C52.5663 453.882 52.146 453.906 51.7356 453.878L54.7962 455.646L53.7306 456.261ZM49.1781 452.518C49.9872 452.985 50.7489 453.236 51.4632 453.27C52.1776 453.304 52.7676 453.187 53.2333 452.918C53.707 452.645 53.9122 452.296 53.849 451.872C53.7859 451.444 53.334 450.987 52.4933 450.501C51.6921 450.039 50.9265 449.788 50.1963 449.75C49.4701 449.708 48.8781 449.82 48.4203 450.084C47.9664 450.347 47.777 450.702 47.852 451.151C47.927 451.595 48.369 452.051 49.1781 452.518ZM60.4795 452.364L51.7829 447.343L52.7538 446.783L53.5708 447.254C53.48 446.938 53.4997 446.651 53.63 446.393C53.7563 446.133 54.0247 445.885 54.4351 445.648C54.9719 445.338 55.5836 445.144 56.2704 445.067C56.9571 444.989 57.6576 445.036 58.372 445.207C59.0824 445.376 59.7376 445.633 60.3375 445.979C60.9808 446.351 61.4445 446.753 61.7287 447.186C62.0128 447.614 62.072 448.036 61.9063 448.451C61.7405 448.861 61.4149 449.206 60.9295 449.486C60.5743 449.691 60.1796 449.833 59.7454 449.91C59.3153 449.985 58.8949 450.009 58.4845 449.982L61.5452 451.749L60.4795 452.364ZM55.927 448.622C56.7361 449.089 57.4978 449.339 58.2121 449.374C58.9265 449.408 59.5165 449.29 59.9823 449.021C60.4559 448.748 60.6611 448.399 60.5979 447.976C60.5348 447.547 60.0829 447.09 59.2422 446.605C58.4411 446.142 57.6754 445.892 56.9452 445.853C56.219 445.812 55.627 445.924 55.1692 446.188C54.7153 446.45 54.5259 446.806 54.6009 447.254C54.6759 447.699 55.1179 448.154 55.927 448.622ZM65.1209 446.902L63.9073 446.202L65.1209 445.501L66.3345 446.202L65.1209 446.902ZM60.7459 440.835L59.5086 440.121L60.5743 439.506L61.8116 440.22L60.7459 440.835ZM69.2768 447.319L68.5723 446.68C68.8407 446.589 69.0361 446.508 69.1584 446.438C69.3755 446.312 69.4643 446.177 69.4248 446.031C69.3893 445.887 69.0834 445.649 68.5072 445.316L61.9004 441.502L62.966 440.887L69.5965 444.715C70.37 445.161 70.8081 445.531 70.9107 445.822C71.0489 446.198 70.82 446.558 70.224 446.902C69.9359 447.069 69.6202 447.208 69.2768 447.319ZM68.5901 442.732L69.4781 442.028C69.9596 442.238 70.447 442.33 70.9403 442.305C71.4376 442.278 71.929 442.124 72.4145 441.844C72.9038 441.561 73.1683 441.295 73.2077 441.044C73.2433 440.791 73.1268 440.587 72.8585 440.432C72.6177 440.293 72.3237 440.244 71.9764 440.285C71.7356 440.315 71.2521 440.455 70.5259 440.706C69.5472 441.043 68.8348 441.258 68.3888 441.352C67.9428 441.44 67.5146 441.458 67.1041 441.403C66.6937 441.344 66.3345 441.225 66.0267 441.047C65.7465 440.886 65.5511 440.7 65.4406 440.49C65.3301 440.276 65.3064 440.06 65.3695 439.841C65.413 439.674 65.5353 439.485 65.7366 439.273C65.9379 439.057 66.2023 438.854 66.5299 438.665C67.0232 438.38 67.5264 438.172 68.0395 438.04C68.5565 437.905 69.0262 437.857 69.4485 437.896C69.8668 437.932 70.3128 438.049 70.7864 438.245L69.8866 438.928C69.5156 438.769 69.1249 438.703 68.7144 438.73C68.3079 438.755 67.8974 438.887 67.483 439.126C66.9936 439.409 66.7252 439.657 66.6779 439.872C66.6305 440.086 66.7154 440.256 66.9324 440.381C67.0706 440.461 67.2383 440.507 67.4357 440.521C67.6369 440.537 67.8678 440.513 68.1283 440.449C68.2743 440.41 68.6789 440.282 69.3419 440.063C70.297 439.744 70.9877 439.537 71.414 439.441C71.8402 439.341 72.2605 439.312 72.6749 439.355C73.0893 439.399 73.4781 439.525 73.8412 439.735C74.1964 439.94 74.4273 440.194 74.5338 440.497C74.6404 440.796 74.5852 441.108 74.3681 441.434C74.1471 441.757 73.7899 442.061 73.2965 442.346C72.4796 442.818 71.6863 443.08 70.9167 443.132C70.151 443.182 69.3755 443.049 68.5901 442.732Z"
              fill="#6FEC5B"
            />
            <path
              d="M83.4182 427.732L82.1927 427.024L83.2583 426.409L84.4838 427.117L83.4182 427.732ZM90.8716 432.035L84.5844 428.405L85.65 427.79L91.9372 431.42L90.8716 432.035ZM93.5652 430.48L87.2781 426.85L88.2371 426.296L89.1311 426.812C88.9022 426.147 89.2238 425.563 90.096 425.059C90.4749 424.84 90.8913 424.68 91.3452 424.577C91.7991 424.47 92.2154 424.435 92.5943 424.471C92.9732 424.508 93.3462 424.595 93.7132 424.734C93.95 424.826 94.3151 425.014 94.8084 425.298L98.6743 427.53L97.6086 428.146L93.7843 425.938C93.3501 425.687 92.985 425.524 92.689 425.449C92.3891 425.371 92.0694 425.358 91.73 425.408C91.3906 425.453 91.0788 425.558 90.7946 425.722C90.3407 425.984 90.0921 426.294 90.0487 426.652C90.0092 427.007 90.392 427.417 91.1972 427.882L94.6308 429.865L93.5652 430.48ZM104.393 424.229L103.6 423.771C103.825 424.361 103.55 424.879 102.777 425.326C102.276 425.615 101.676 425.802 100.977 425.886C100.283 425.968 99.5721 425.934 98.8459 425.784C98.1197 425.629 97.435 425.366 96.7917 424.994C96.1641 424.632 95.7004 424.243 95.4004 423.829C95.0965 423.412 95.0176 423.004 95.1636 422.605C95.3097 422.206 95.6412 421.858 96.1582 421.559C96.5371 421.34 96.9555 421.192 97.4133 421.115C97.8671 421.035 98.3151 421.016 98.7571 421.057L95.6432 419.259L96.7029 418.647L105.382 423.658L104.393 424.229ZM97.8869 424.362C98.692 424.827 99.4636 425.076 100.202 425.11C100.94 425.145 101.54 425.028 102.001 424.762C102.467 424.493 102.672 424.156 102.617 423.75C102.562 423.34 102.143 422.909 101.362 422.458C100.502 421.961 99.7044 421.692 98.9703 421.651C98.2362 421.61 97.6264 421.73 97.141 422.01C96.6673 422.284 96.4641 422.624 96.5312 423.032C96.6022 423.438 97.0541 423.881 97.8869 424.362ZM109.342 419.033L110.58 418.476C111.049 418.948 111.227 419.422 111.112 419.898C110.998 420.374 110.576 420.823 109.845 421.245C108.926 421.776 107.914 422.034 106.808 422.021C105.703 422.002 104.64 421.698 103.618 421.108C102.56 420.497 102.011 419.866 101.972 419.214C101.932 418.563 102.347 417.986 103.215 417.485C104.056 417 105.028 416.768 106.134 416.791C107.239 416.814 108.31 417.125 109.348 417.724C109.411 417.761 109.504 417.816 109.626 417.892L104.938 420.599C105.668 420.975 106.392 421.167 107.11 421.176C107.829 421.185 108.45 421.038 108.975 420.735C109.366 420.51 109.597 420.258 109.668 419.98C109.739 419.702 109.63 419.386 109.342 419.033ZM104.121 420.059L107.631 418.032C107.055 417.754 106.524 417.602 106.039 417.577C105.289 417.536 104.644 417.672 104.103 417.984C103.614 418.266 103.365 418.599 103.357 418.982C103.353 419.362 103.608 419.721 104.121 420.059ZM113.102 419.201L112.131 415.988L106.986 415.472L108.318 414.703L110.757 414.997C111.219 415.054 111.6 415.105 111.9 415.15C111.813 414.9 111.742 414.674 111.687 414.474L111.26 413.004L112.533 412.269L113.321 415.232L118.986 415.803L117.678 416.559L114.434 416.176L113.563 416.07L114.392 418.456L113.102 419.201ZM120.176 415.116L118.962 414.416L120.176 413.715L121.39 414.416L120.176 415.116ZM115.801 409.049L114.564 408.335L115.629 407.72L116.867 408.434L115.801 409.049ZM124.332 415.533L123.627 414.894C123.896 414.803 124.091 414.722 124.214 414.651C124.431 414.526 124.519 414.39 124.48 414.245C124.444 414.101 124.139 413.863 123.562 413.53L116.956 409.716L118.021 409.101L124.652 412.929C125.425 413.375 125.863 413.744 125.966 414.036C126.104 414.412 125.875 414.772 125.279 415.116C124.991 415.283 124.675 415.422 124.332 415.533ZM123.645 410.946L124.533 410.242C125.015 410.452 125.502 410.544 125.995 410.519C126.493 410.492 126.984 410.338 127.47 410.058C127.959 409.775 128.223 409.508 128.263 409.258C128.298 409.005 128.182 408.801 127.914 408.646C127.673 408.507 127.379 408.458 127.032 408.499C126.791 408.529 126.307 408.669 125.581 408.919C124.602 409.257 123.89 409.472 123.444 409.565C122.998 409.654 122.57 409.671 122.159 409.617C121.749 409.557 121.39 409.439 121.082 409.261C120.802 409.099 120.606 408.914 120.496 408.704C120.385 408.49 120.362 408.273 120.425 408.055C120.468 407.888 120.59 407.699 120.792 407.487C120.993 407.271 121.257 407.068 121.585 406.879C122.078 406.594 122.582 406.386 123.095 406.253C123.612 406.119 124.081 406.071 124.504 406.11C124.922 406.146 125.368 406.263 125.842 406.458L124.942 407.142C124.571 406.983 124.18 406.917 123.77 406.944C123.363 406.969 122.953 407.101 122.538 407.34C122.049 407.623 121.78 407.871 121.733 408.085C121.686 408.3 121.771 408.469 121.988 408.595C122.126 408.674 122.293 408.721 122.491 408.735C122.692 408.751 122.923 408.727 123.183 408.663C123.329 408.624 123.734 408.496 124.397 408.277C125.352 407.958 126.043 407.75 126.469 407.655C126.895 407.555 127.316 407.526 127.73 407.569C128.144 407.613 128.533 407.739 128.896 407.949C129.252 408.154 129.482 408.408 129.589 408.711C129.696 409.009 129.64 409.322 129.423 409.647C129.202 409.971 128.845 410.275 128.352 410.56C127.535 411.032 126.741 411.294 125.972 411.346C125.206 411.396 124.431 411.263 123.645 410.946Z"
              fill="white"
              opacity="0.3"
            />
            <path
              d="M143.122 399.701L144.01 398.997C144.492 399.207 144.979 399.299 145.473 399.274C145.97 399.247 146.461 399.093 146.947 398.812C147.436 398.53 147.701 398.263 147.74 398.013C147.775 397.76 147.659 397.556 147.391 397.401C147.15 397.262 146.856 397.213 146.509 397.254C146.268 397.284 145.784 397.424 145.058 397.674C144.079 398.012 143.367 398.227 142.921 398.32C142.475 398.409 142.047 398.426 141.636 398.372C141.226 398.312 140.867 398.194 140.559 398.016C140.279 397.854 140.083 397.669 139.973 397.459C139.862 397.245 139.839 397.028 139.902 396.81C139.945 396.643 140.068 396.454 140.269 396.242C140.47 396.026 140.735 395.823 141.062 395.634C141.555 395.349 142.059 395.14 142.572 395.008C143.089 394.874 143.558 394.826 143.981 394.865C144.399 394.901 144.845 395.017 145.319 395.213L144.419 395.897C144.048 395.737 143.657 395.671 143.247 395.699C142.84 395.724 142.43 395.856 142.015 396.095C141.526 396.378 141.257 396.626 141.21 396.84C141.163 397.055 141.248 397.224 141.465 397.35C141.603 397.429 141.771 397.476 141.968 397.49C142.169 397.506 142.4 397.482 142.661 397.418C142.807 397.379 143.211 397.25 143.874 397.032C144.829 396.713 145.52 396.505 145.946 396.41C146.372 396.309 146.793 396.281 147.207 396.324C147.622 396.368 148.01 396.494 148.373 396.704C148.729 396.909 148.96 397.163 149.066 397.466C149.173 397.764 149.117 398.076 148.9 398.402C148.679 398.726 148.322 399.03 147.829 399.315C147.012 399.787 146.219 400.049 145.449 400.101C144.683 400.151 143.908 400.018 143.122 399.701ZM152.861 395.145L153.956 395.6C153.719 395.809 153.482 395.982 153.246 396.119C152.859 396.342 152.498 396.48 152.162 396.533C151.827 396.585 151.517 396.579 151.233 396.516C150.945 396.45 150.481 396.232 149.842 395.863L146.224 393.774L145.443 394.226L144.614 393.747L145.396 393.296L143.839 392.397L144.259 391.416L146.455 392.684L147.527 392.065L148.356 392.544L147.284 393.163L150.961 395.285C151.264 395.461 151.478 395.563 151.6 395.593C151.726 395.62 151.856 395.625 151.991 395.606C152.129 395.586 152.277 395.53 152.435 395.439C152.553 395.371 152.695 395.273 152.861 395.145ZM157.236 396.516L156.117 396.006C156.413 395.908 156.648 395.809 156.821 395.709C157.058 395.572 157.208 395.44 157.271 395.312C157.334 395.185 157.34 395.054 157.289 394.919C157.25 394.819 157.094 394.604 156.821 394.273C156.782 394.228 156.727 394.16 156.656 394.068L147.971 391.809L149.119 391.146L154.069 392.493C154.7 392.661 155.337 392.854 155.981 393.07C155.614 392.717 155.282 392.357 154.986 391.99L152.665 389.099L153.731 388.483L157.733 393.556C158.167 394.103 158.444 394.492 158.562 394.725C158.724 395.037 158.763 395.31 158.68 395.545C158.601 395.782 158.392 395.998 158.053 396.194C157.848 396.313 157.575 396.42 157.236 396.516ZM160.9 391.604L152.221 386.593L153.287 385.978L161.966 390.989L160.9 391.604ZM165.903 386.378L167.14 385.821C167.61 386.292 167.787 386.766 167.673 387.243C167.558 387.719 167.136 388.168 166.406 388.589C165.486 389.12 164.474 389.379 163.369 389.365C162.264 389.347 161.2 389.043 160.178 388.453C159.12 387.842 158.572 387.211 158.532 386.559C158.493 385.907 158.907 385.331 159.776 384.83C160.616 384.344 161.589 384.113 162.694 384.136C163.799 384.159 164.871 384.47 165.909 385.069C165.972 385.105 166.065 385.161 166.187 385.236L161.498 387.943C162.228 388.319 162.953 388.512 163.671 388.521C164.389 388.53 165.011 388.383 165.536 388.08C165.927 387.854 166.157 387.603 166.228 387.325C166.299 387.047 166.191 386.731 165.903 386.378ZM160.681 387.403L164.192 385.376C163.616 385.098 163.085 384.947 162.599 384.922C161.85 384.881 161.204 385.016 160.664 385.329C160.174 385.611 159.926 385.944 159.918 386.327C159.914 386.707 160.168 387.066 160.681 387.403ZM168.07 385.298L168.958 384.594C169.439 384.803 169.927 384.896 170.42 384.871C170.917 384.843 171.409 384.689 171.894 384.409C172.383 384.127 172.648 383.86 172.687 383.609C172.723 383.356 172.606 383.153 172.338 382.998C172.097 382.859 171.803 382.81 171.456 382.851C171.215 382.88 170.732 383.02 170.005 383.271C169.027 383.608 168.314 383.824 167.868 383.917C167.422 384.006 166.994 384.023 166.584 383.968C166.173 383.909 165.814 383.791 165.506 383.613C165.226 383.451 165.031 383.265 164.92 383.056C164.81 382.841 164.786 382.625 164.849 382.406C164.892 382.24 165.015 382.051 165.216 381.839C165.417 381.622 165.682 381.42 166.009 381.23C166.503 380.946 167.006 380.737 167.519 380.605C168.036 380.471 168.506 380.423 168.928 380.461C169.346 380.498 169.792 380.614 170.266 380.81L169.366 381.494C168.995 381.334 168.604 381.268 168.194 381.295C167.787 381.32 167.377 381.453 166.963 381.692C166.473 381.974 166.205 382.223 166.157 382.437C166.11 382.651 166.195 382.821 166.412 382.946C166.55 383.026 166.718 383.073 166.915 383.086C167.116 383.102 167.347 383.078 167.608 383.015C167.754 382.976 168.158 382.847 168.821 382.628C169.777 382.309 170.467 382.102 170.893 382.006C171.32 381.906 171.74 381.878 172.154 381.921C172.569 381.964 172.958 382.091 173.321 382.3C173.676 382.505 173.907 382.759 174.013 383.062C174.12 383.361 174.065 383.673 173.848 383.999C173.627 384.323 173.269 384.627 172.776 384.912C171.959 385.383 171.166 385.645 170.396 385.698C169.631 385.748 168.855 385.615 168.07 385.298ZM176.737 382.461L175.523 381.76L176.737 381.06L177.95 381.76L176.737 382.461ZM181.609 376.989L182.793 376.462C183.401 376.945 183.673 377.442 183.61 377.953C183.547 378.458 183.172 378.91 182.485 379.306C181.625 379.803 180.652 380.041 179.566 380.021C178.481 379.995 177.413 379.68 176.364 379.074C175.685 378.682 175.203 378.274 174.919 377.85C174.635 377.426 174.596 377.009 174.801 376.599C175.006 376.184 175.379 375.821 175.92 375.509C176.602 375.115 177.335 374.892 178.116 374.842C178.893 374.79 179.661 374.912 180.419 375.208L179.543 375.898C179.022 375.712 178.528 375.63 178.063 375.652C177.601 375.673 177.192 375.786 176.837 375.991C176.3 376.301 176.058 376.664 176.109 377.081C176.156 377.496 176.596 377.944 177.429 378.424C178.274 378.912 179.049 379.173 179.756 379.207C180.462 379.241 181.076 379.108 181.597 378.807C182.015 378.566 182.236 378.29 182.26 377.98C182.284 377.67 182.067 377.34 181.609 376.989ZM183.568 376.35L184.456 375.646C184.938 375.855 185.425 375.947 185.919 375.922C186.416 375.895 186.907 375.741 187.393 375.461C187.882 375.178 188.147 374.912 188.186 374.661C188.222 374.408 188.105 374.204 187.837 374.049C187.596 373.91 187.302 373.861 186.955 373.902C186.714 373.932 186.23 374.072 185.504 374.323C184.525 374.66 183.813 374.875 183.367 374.969C182.921 375.058 182.493 375.075 182.082 375.02C181.672 374.961 181.313 374.842 181.005 374.665C180.725 374.503 180.529 374.317 180.419 374.107C180.308 373.893 180.285 373.677 180.348 373.458C180.391 373.292 180.514 373.103 180.715 372.891C180.916 372.674 181.181 372.471 181.508 372.282C182.002 371.997 182.505 371.789 183.018 371.657C183.535 371.522 184.005 371.474 184.427 371.513C184.845 371.55 185.291 371.666 185.765 371.862L184.865 372.545C184.494 372.386 184.103 372.32 183.693 372.347C183.286 372.372 182.876 372.504 182.461 372.744C181.972 373.026 181.704 373.275 181.656 373.489C181.609 373.703 181.694 373.873 181.911 373.998C182.049 374.078 182.217 374.125 182.414 374.138C182.615 374.154 182.846 374.13 183.107 374.066C183.253 374.028 183.657 373.899 184.32 373.68C185.275 373.361 185.966 373.154 186.392 373.058C186.819 372.958 187.239 372.929 187.653 372.973C188.068 373.016 188.456 373.142 188.82 373.352C189.175 373.557 189.406 373.811 189.512 374.114C189.619 374.413 189.563 374.725 189.346 375.051C189.125 375.374 188.768 375.679 188.275 375.963C187.458 376.435 186.665 376.697 185.895 376.75C185.129 376.8 184.354 376.666 183.568 376.35ZM189.631 372.85L190.519 372.146C191 372.355 191.488 372.447 191.981 372.422C192.478 372.395 192.97 372.241 193.455 371.961C193.944 371.678 194.209 371.412 194.248 371.161C194.284 370.908 194.167 370.704 193.899 370.549C193.658 370.41 193.364 370.361 193.017 370.402C192.776 370.432 192.293 370.572 191.566 370.823C190.588 371.16 189.875 371.375 189.429 371.469C188.983 371.558 188.555 371.575 188.145 371.52C187.734 371.461 187.375 371.342 187.067 371.165C186.787 371.003 186.592 370.817 186.481 370.607C186.371 370.393 186.347 370.177 186.41 369.958C186.453 369.792 186.576 369.603 186.777 369.391C186.978 369.174 187.243 368.971 187.57 368.782C188.064 368.497 188.567 368.289 189.08 368.157C189.597 368.022 190.067 367.974 190.489 368.013C190.907 368.05 191.353 368.166 191.827 368.362L190.927 369.045C190.556 368.886 190.165 368.82 189.755 368.847C189.348 368.872 188.938 369.004 188.524 369.244C188.034 369.526 187.766 369.775 187.718 369.989C187.671 370.203 187.756 370.373 187.973 370.498C188.111 370.578 188.279 370.625 188.476 370.638C188.677 370.654 188.908 370.63 189.169 370.566C189.315 370.528 189.719 370.399 190.382 370.18C191.338 369.861 192.028 369.654 192.454 369.558C192.881 369.458 193.301 369.429 193.715 369.473C194.13 369.516 194.519 369.642 194.882 369.852C195.237 370.057 195.468 370.311 195.574 370.614C195.681 370.913 195.626 371.225 195.409 371.551C195.188 371.874 194.83 372.179 194.337 372.463C193.52 372.935 192.727 373.197 191.957 373.25C191.192 373.3 190.416 373.166 189.631 372.85Z"
              fill="white"
              opacity="0.3"
            />
            <path
              d="M204.662 357.732L203.436 357.024L204.502 356.409L205.727 357.117L204.662 357.732ZM212.115 362.035L205.828 358.405L206.894 357.79L213.181 361.42L212.115 362.035ZM214.809 360.48L208.522 356.85L209.481 356.296L210.375 356.812C210.146 356.147 210.467 355.563 211.34 355.059C211.719 354.84 212.135 354.68 212.589 354.577C213.043 354.47 213.459 354.435 213.838 354.471C214.217 354.508 214.59 354.595 214.957 354.734C215.194 354.826 215.559 355.014 216.052 355.298L219.918 357.53L218.852 358.146L215.028 355.938C214.594 355.687 214.229 355.524 213.933 355.449C213.633 355.371 213.313 355.358 212.974 355.408C212.634 355.453 212.322 355.558 212.038 355.722C211.584 355.984 211.336 356.294 211.292 356.652C211.253 357.007 211.636 357.417 212.441 357.882L215.874 359.865L214.809 360.48ZM225.637 354.229L224.843 353.771C225.068 354.361 224.794 354.879 224.021 355.326C223.519 355.615 222.919 355.802 222.221 355.886C221.526 355.968 220.816 355.934 220.09 355.784C219.363 355.629 218.679 355.366 218.035 354.994C217.408 354.632 216.944 354.243 216.644 353.829C216.34 353.412 216.261 353.004 216.407 352.605C216.553 352.206 216.885 351.858 217.402 351.559C217.781 351.34 218.199 351.192 218.657 351.115C219.111 351.035 219.559 351.016 220.001 351.057L216.887 349.259L217.947 348.647L226.625 353.658L225.637 354.229ZM219.131 354.362C219.936 354.827 220.707 355.076 221.445 355.11C222.183 355.145 222.783 355.028 223.245 354.762C223.711 354.493 223.916 354.156 223.861 353.75C223.805 353.34 223.387 352.909 222.606 352.458C221.745 351.961 220.948 351.692 220.214 351.651C219.48 351.61 218.87 351.73 218.385 352.01C217.911 352.284 217.708 352.624 217.775 353.032C217.846 353.438 218.298 353.881 219.131 354.362ZM230.586 349.033L231.823 348.476C232.293 348.948 232.47 349.422 232.356 349.898C232.242 350.374 231.819 350.823 231.089 351.245C230.17 351.776 229.157 352.034 228.052 352.021C226.947 352.002 225.883 351.698 224.861 351.108C223.803 350.497 223.255 349.866 223.215 349.214C223.176 348.563 223.59 347.986 224.459 347.485C225.299 347 226.272 346.768 227.377 346.791C228.482 346.814 229.554 347.125 230.592 347.724C230.655 347.761 230.748 347.816 230.87 347.892L226.181 350.599C226.912 350.975 227.636 351.167 228.354 351.176C229.072 351.185 229.694 351.038 230.219 350.735C230.61 350.51 230.84 350.258 230.912 349.98C230.983 349.702 230.874 349.386 230.586 349.033ZM225.364 350.059L228.875 348.032C228.299 347.754 227.768 347.602 227.283 347.577C226.533 347.536 225.887 347.672 225.347 347.984C224.857 348.266 224.609 348.599 224.601 348.982C224.597 349.362 224.851 349.721 225.364 350.059ZM234.345 349.201L233.374 345.988L228.23 345.472L229.562 344.703L232.001 344.997C232.463 345.054 232.843 345.105 233.143 345.15C233.057 344.9 232.986 344.674 232.93 344.474L232.504 343.004L233.777 342.269L234.564 345.232L240.23 345.803L238.921 346.559L235.677 346.176L234.807 346.07L235.636 348.456L234.345 349.201ZM241.42 345.116L240.206 344.416L241.42 343.715L242.633 344.416L241.42 345.116ZM244.492 343.342L235.813 338.332L236.879 337.716L239.993 339.514C239.914 338.894 240.253 338.366 241.011 337.928C241.477 337.659 241.974 337.479 242.503 337.388C243.028 337.295 243.525 337.299 243.995 337.402C244.469 337.502 245.013 337.73 245.629 338.085L249.613 340.386L248.547 341.001L244.563 338.701C244.03 338.393 243.527 338.237 243.054 338.232C242.58 338.223 242.132 338.341 241.71 338.584C241.394 338.767 241.179 338.987 241.064 339.244C240.95 339.497 240.974 339.739 241.136 339.969C241.297 340.199 241.625 340.456 242.118 340.741L245.558 342.727L244.492 343.342ZM252.615 337.552L253.71 338.007C253.473 338.216 253.236 338.39 252.999 338.526C252.613 338.75 252.251 338.888 251.916 338.94C251.581 338.992 251.271 338.987 250.987 338.923C250.698 338.857 250.235 338.639 249.595 338.27L245.978 336.182L245.197 336.633L244.368 336.154L245.149 335.703L243.592 334.804L244.013 333.823L246.209 335.091L247.281 334.473L248.109 334.951L247.038 335.57L250.714 337.692C251.018 337.868 251.231 337.97 251.354 338C251.48 338.027 251.61 338.032 251.744 338.014C251.882 337.993 252.03 337.937 252.188 337.846C252.307 337.778 252.449 337.68 252.615 337.552ZM254.616 337.498L248.328 333.868L249.282 333.317L250.164 333.827C250.053 333.535 250.069 333.241 250.211 332.945C250.349 332.646 250.627 332.376 251.046 332.135C251.511 331.866 251.989 331.702 252.478 331.643C252.972 331.581 253.453 331.615 253.923 331.745C253.686 331.034 253.966 330.449 254.764 329.988C255.387 329.628 256.04 329.452 256.723 329.458C257.402 329.463 258.101 329.673 258.819 330.087L263.135 332.579L262.075 333.191L258.114 330.904C257.688 330.658 257.347 330.502 257.09 330.436C256.834 330.365 256.557 330.349 256.261 330.388C255.965 330.427 255.695 330.517 255.45 330.658C255.008 330.913 254.789 331.211 254.793 331.55C254.793 331.888 255.117 332.243 255.764 332.617L259.417 334.726L258.351 335.341L254.266 332.982C253.793 332.709 253.351 332.554 252.94 332.518C252.53 332.481 252.127 332.577 251.733 332.805C251.433 332.978 251.233 333.184 251.135 333.423C251.04 333.66 251.087 333.9 251.277 334.141C251.466 334.383 251.847 334.669 252.419 334.999L255.681 336.882L254.616 337.498ZM264.692 331.68L256.013 326.669L257.078 326.054L265.757 331.065L264.692 331.68Z"
              fill="white"
              opacity="0.3"
            />
            <path d="M48.4976 471.5L96.129 444" stroke="#6FEC5B" />
          </g>
        </g>

        <g className={styles.movement}>
          <g className={styles.editor}>
            <rect
              fill="#191919"
              height="260"
              rx="10"
              transform="matrix(0.866025 -0.5 0.866025 0.5 173 479.5)"
              width="479"
            />
            <rect
              fill="#232323"
              height="20"
              transform="matrix(0.866025 -0.5 0.866025 0.5 186.856 487.5)"
              width="479"
            />
            <path
              d="M213.293 483.693C214.02 484.085 214.732 484.286 215.427 484.295C216.13 484.3 216.744 484.15 217.27 483.847C217.585 483.665 217.827 483.474 217.997 483.273C218.167 483.063 218.304 482.816 218.409 482.531L219.561 482.65C219.496 482.958 219.335 483.261 219.076 483.56C218.826 483.854 218.506 484.113 218.118 484.337C217.197 484.869 216.178 485.112 215.063 485.065C213.948 485.009 212.885 484.689 211.874 484.106C211.236 483.737 210.779 483.343 210.504 482.923C210.221 482.498 210.149 482.083 210.286 481.677C210.415 481.266 210.759 480.9 211.317 480.578C212.125 480.111 213.042 479.908 214.069 479.969C215.095 480.02 216.094 480.326 217.063 480.886C217.249 480.993 217.423 481.103 217.585 481.215L213.293 483.693ZM212.165 481.054C211.672 481.339 211.45 481.672 211.498 482.055C211.539 482.433 211.878 482.83 212.517 483.245L215.839 481.327C215.16 480.944 214.501 480.732 213.863 480.69C213.224 480.648 212.658 480.769 212.165 481.054ZM222.054 481.911L221.036 478.607L215.943 478.061L217.156 477.361L221.011 477.879L220.126 475.646L221.302 474.967L222.199 477.879L227.971 478.495L226.734 479.209L222.236 478.642L223.218 481.239L222.054 481.911ZM226.196 471.987C227.74 471.096 229.619 471.29 231.834 472.568C232.844 473.152 233.442 473.74 233.628 474.332C233.814 474.925 233.507 475.452 232.707 475.914C232.011 476.316 231.203 476.502 230.282 476.474L233.325 478.231L232.428 478.889L223.468 473.716L224.341 473.212L225.323 473.681C225.226 473.355 225.25 473.047 225.396 472.757C225.549 472.463 225.816 472.207 226.196 471.987ZM226.778 472.603C226.454 472.79 226.252 473.019 226.172 473.289C226.099 473.555 226.107 473.831 226.196 474.115L229.36 475.942C229.781 475.989 230.189 475.982 230.585 475.921C230.981 475.851 231.328 475.73 231.627 475.557C232.161 475.249 232.355 474.904 232.209 474.521C232.064 474.129 231.571 473.691 230.73 473.205C229.89 472.72 229.146 472.426 228.499 472.323C227.853 472.221 227.279 472.314 226.778 472.603ZM233.041 468.035C233.922 467.527 234.896 467.31 235.963 467.384C237.03 467.45 238.077 467.779 239.103 468.371C240.106 468.95 240.672 469.557 240.801 470.191C240.93 470.817 240.558 471.381 239.685 471.885C238.804 472.394 237.83 472.616 236.763 472.55C235.688 472.48 234.638 472.149 233.611 471.556C232.601 470.973 232.031 470.369 231.902 469.743C231.78 469.113 232.16 468.544 233.041 468.035ZM233.878 468.518C233.32 468.84 233.11 469.2 233.247 469.596C233.385 469.993 233.874 470.434 234.714 470.919C235.555 471.405 236.315 471.689 236.994 471.773C237.673 471.848 238.291 471.724 238.849 471.402C239.407 471.08 239.617 470.726 239.479 470.338C239.342 469.942 238.849 469.498 238 469.008C237.16 468.523 236.4 468.243 235.721 468.168C235.042 468.084 234.428 468.201 233.878 468.518ZM242.19 462.753C242.449 462.604 242.793 462.457 243.221 462.312L245.246 463.649L244.421 464.125L243.051 463.334L242.991 463.369C242.005 463.938 242.009 464.748 243.003 465.798L245.694 467.352L246.992 466.603L247.78 467.058L244.458 468.976L243.67 468.521L244.676 467.94L239.863 465.161L238.856 465.742L238.068 465.287L239.838 464.265L241.548 465.028C241.257 464.561 241.152 464.146 241.233 463.782C241.322 463.413 241.641 463.07 242.19 462.753ZM256.42 461.692C256.347 461.902 256.193 462.121 255.959 462.35C255.733 462.574 255.466 462.774 255.159 462.952C254.488 463.339 253.789 463.542 253.061 463.561C252.326 463.575 251.671 463.416 251.097 463.085L247.29 460.887L245.823 461.734L245.023 461.272L246.49 460.425L245.047 459.592L245.944 458.934L247.508 459.837L249.727 458.556L250.394 459.095L248.309 460.299L252.103 462.49C252.467 462.7 252.835 462.8 253.207 462.791C253.579 462.781 253.979 462.653 254.407 462.406C254.844 462.154 255.151 461.86 255.329 461.524L256.42 461.692ZM262.097 448.446L271.056 453.619L270.159 454.137L269.226 453.71C269.315 454.032 269.286 454.328 269.141 454.599C268.995 454.87 268.745 455.108 268.389 455.313C267.581 455.78 266.676 455.962 265.673 455.859C264.679 455.752 263.665 455.399 262.63 454.802C261.991 454.433 261.523 454.046 261.224 453.64C260.916 453.229 260.807 452.835 260.896 452.457C260.985 452.07 261.284 451.729 261.793 451.435C262.497 451.029 263.325 450.845 264.279 450.882L260.957 448.964L262.097 448.446ZM262.885 451.757C262.351 452.065 262.149 452.424 262.278 452.835C262.416 453.241 262.901 453.684 263.733 454.165C264.558 454.641 265.314 454.928 266.001 455.026C266.688 455.115 267.282 455.014 267.783 454.725C268.389 454.375 268.575 453.876 268.341 453.227L265.164 451.393C264.719 451.342 264.303 451.349 263.915 451.414C263.519 451.475 263.176 451.589 262.885 451.757ZM271.452 450.115C272.179 450.507 272.891 450.708 273.586 450.717C274.289 450.722 274.903 450.572 275.429 450.269C275.744 450.087 275.986 449.896 276.156 449.695C276.326 449.485 276.463 449.238 276.568 448.953L277.72 449.072C277.655 449.38 277.494 449.683 277.235 449.982C276.985 450.276 276.665 450.535 276.277 450.759C275.356 451.291 274.337 451.534 273.222 451.487C272.107 451.431 271.044 451.111 270.033 450.528C269.395 450.159 268.938 449.765 268.663 449.345C268.38 448.92 268.308 448.505 268.445 448.099C268.574 447.688 268.918 447.322 269.476 447C270.284 446.533 271.201 446.33 272.228 446.391C273.254 446.442 274.253 446.748 275.222 447.308C275.408 447.415 275.582 447.525 275.744 447.637L271.452 450.115ZM270.324 447.476C269.831 447.761 269.609 448.094 269.657 448.477C269.698 448.855 270.037 449.252 270.676 449.667L273.998 447.749C273.319 447.366 272.66 447.154 272.022 447.112C271.383 447.07 270.817 447.191 270.324 447.476ZM275.436 440.605C276.042 440.255 276.733 439.986 277.509 439.8L277.946 440.43C277.364 440.56 276.818 440.773 276.309 441.067C275.42 441.58 275.327 442.04 276.03 442.446L277.327 443.195L279.486 441.949L280.189 442.481L278.14 443.664L283.22 446.597L282.189 447.192L277.109 444.259L275.594 445.134L274.781 444.665L276.297 443.79L275.024 443.055C274.45 442.723 274.207 442.331 274.296 441.879C274.385 441.417 274.765 440.992 275.436 440.605ZM291.205 440.376C291.456 440.521 291.682 440.605 291.884 440.628C292.078 440.647 292.296 440.619 292.539 440.544L293.012 441.111C292.308 441.424 291.617 441.473 290.938 441.258C291.003 441.557 290.938 441.851 290.744 442.14C290.558 442.425 290.255 442.689 289.835 442.931C289.196 443.3 288.513 443.489 287.786 443.498C287.067 443.503 286.408 443.333 285.81 442.987C285.155 442.609 284.904 442.171 285.058 441.671C285.22 441.167 285.781 440.638 286.743 440.082L287.689 439.536L287.168 439.235C286.715 438.974 286.262 438.862 285.81 438.899C285.349 438.932 284.872 439.091 284.379 439.375C283.894 439.655 283.449 440.038 283.045 440.523L281.991 440.236C282.476 439.648 283.041 439.168 283.688 438.794C284.464 438.346 285.236 438.111 286.004 438.087C286.78 438.059 287.491 438.232 288.138 438.605L291.205 440.376ZM289.326 442.343C289.641 442.161 289.859 441.942 289.98 441.685C290.11 441.424 290.126 441.158 290.029 440.887L288.392 439.942L287.471 440.474C286.792 440.866 286.416 441.214 286.343 441.517C286.27 441.821 286.452 442.098 286.889 442.35C287.697 442.817 288.509 442.815 289.326 442.343ZM294.45 437.971C294.862 438.209 295.25 438.335 295.614 438.349C295.977 438.354 296.345 438.249 296.717 438.034C297.056 437.838 297.287 437.593 297.408 437.299C297.529 437.005 297.537 436.72 297.432 436.445L292.728 433.729L293.746 433.141L300.136 436.83L299.263 437.334L298.317 436.886C298.382 437.213 298.317 437.535 298.123 437.852C297.929 438.16 297.642 438.424 297.262 438.643C296.656 438.993 296.034 439.166 295.395 439.161C294.765 439.152 294.147 438.972 293.54 438.622L288.897 435.941L289.915 435.353L294.45 437.971ZM303.478 433.081C304.051 433.412 304.69 433.375 305.393 432.969C305.725 432.777 306.007 432.53 306.242 432.227L307.248 432.5C307.062 432.859 306.666 433.214 306.06 433.564C305.486 433.895 304.868 434.07 304.205 434.089C303.55 434.103 302.952 433.953 302.411 433.641L295.888 429.875L293.924 431.009L293.111 430.54L296.094 428.818L303.478 433.081ZM314.579 428.114C314.506 428.324 314.352 428.543 314.118 428.772C313.892 428.996 313.625 429.196 313.318 429.374C312.647 429.761 311.948 429.964 311.22 429.983C310.485 429.997 309.83 429.838 309.256 429.507L305.449 427.309L303.982 428.156L303.182 427.694L304.649 426.847L303.206 426.014L304.103 425.356L305.667 426.259L307.886 424.978L308.553 425.517L306.468 426.721L310.262 428.912C310.626 429.122 310.994 429.222 311.366 429.213C311.738 429.203 312.138 429.075 312.566 428.828C313.003 428.576 313.31 428.282 313.488 427.946L314.579 428.114ZM319.055 415.421C319.661 415.071 320.353 414.803 321.129 414.616L321.565 415.246C320.983 415.377 320.437 415.589 319.928 415.883C319.039 416.396 318.946 416.856 319.649 417.262L320.947 418.011L323.105 416.765L323.808 417.297L321.759 418.48L326.839 421.413L325.809 422.008L320.728 419.075L319.213 419.95L318.401 419.481L319.916 418.606L318.643 417.871C318.069 417.54 317.827 417.148 317.916 416.695C318.004 416.233 318.384 415.808 319.055 415.421ZM330.799 416.985C331.211 417.223 331.599 417.349 331.963 417.363C332.327 417.367 332.694 417.262 333.066 417.048C333.406 416.852 333.636 416.607 333.757 416.313C333.879 416.019 333.887 415.734 333.782 415.459L329.077 412.743L330.096 412.155L336.485 415.844L335.612 416.348L334.667 415.9C334.731 416.226 334.667 416.548 334.473 416.866C334.279 417.174 333.992 417.437 333.612 417.657C333.006 418.007 332.383 418.179 331.745 418.175C331.114 418.165 330.496 417.986 329.89 417.636L325.246 414.955L326.265 414.367L330.799 416.985ZM332.516 410.757L333.389 410.253L334.371 410.722C334.298 410.391 334.363 410.064 334.565 409.742C334.767 409.411 335.062 409.133 335.45 408.909C336.646 408.219 337.875 408.237 339.136 408.965L343.767 411.639L342.749 412.227L338.869 409.987C338.392 409.712 338 409.518 337.693 409.406C337.394 409.29 337.107 409.241 336.832 409.259C336.557 409.278 336.262 409.378 335.947 409.56C335.6 409.761 335.377 410.011 335.28 410.309C335.183 410.608 335.183 410.897 335.28 411.177L339.924 413.858L338.905 414.446L332.516 410.757ZM348.333 408.149C348.891 407.827 349.259 407.4 349.437 406.868L350.589 406.973C350.556 407.263 350.411 407.561 350.152 407.869C349.893 408.177 349.578 408.439 349.206 408.653C348.261 409.199 347.226 409.456 346.103 409.423C344.979 409.381 343.912 409.069 342.902 408.485C342.263 408.117 341.807 407.718 341.532 407.288C341.265 406.854 341.212 406.423 341.374 405.993C341.536 405.564 341.928 405.17 342.55 404.81C343.375 404.334 344.337 404.068 345.436 404.012L345.606 404.684C344.676 404.792 343.94 405.002 343.399 405.314C342.825 405.646 342.578 406.035 342.659 406.483C342.74 406.922 343.189 407.377 344.005 407.848C344.821 408.32 345.601 408.574 346.345 408.611C347.089 408.639 347.752 408.485 348.333 408.149ZM358.198 402.93C358.125 403.14 357.972 403.359 357.737 403.588C357.511 403.812 357.244 404.013 356.937 404.19C356.266 404.577 355.567 404.78 354.84 404.799C354.104 404.813 353.449 404.654 352.875 404.323L349.068 402.125L347.601 402.972L346.801 402.51L348.268 401.663L346.825 400.83L347.723 400.172L349.287 401.075L351.505 399.794L352.172 400.333L350.087 401.537L353.882 403.728C354.245 403.938 354.613 404.038 354.985 404.029C355.357 404.02 355.757 403.891 356.185 403.644C356.622 403.392 356.929 403.098 357.107 402.762L358.198 402.93ZM353.768 395.044C353.994 394.913 354.245 394.848 354.52 394.848C354.786 394.843 355.025 394.901 355.235 395.023C355.445 395.144 355.55 395.284 355.55 395.443C355.542 395.597 355.425 395.739 355.199 395.87C354.98 395.996 354.738 396.061 354.471 396.066C354.204 396.061 353.966 395.998 353.756 395.877C353.546 395.755 353.441 395.62 353.441 395.471C353.441 395.312 353.55 395.17 353.768 395.044ZM363.14 399.517L364.934 398.481L365.747 398.95L360.97 401.708L360.157 401.239L362.122 400.105L357.357 397.354L355.453 398.453L354.641 397.984L357.563 396.297L363.14 399.517ZM363.899 392.484C364.78 391.976 365.754 391.759 366.821 391.833C367.888 391.899 368.935 392.228 369.961 392.82C370.964 393.399 371.529 394.006 371.659 394.64C371.788 395.266 371.416 395.83 370.543 396.334C369.662 396.843 368.688 397.065 367.621 396.999C366.546 396.929 365.495 396.598 364.469 396.005C363.459 395.422 362.889 394.818 362.759 394.192C362.638 393.562 363.018 392.993 363.899 392.484ZM364.736 392.967C364.178 393.289 363.968 393.649 364.105 394.045C364.243 394.442 364.732 394.883 365.572 395.368C366.413 395.854 367.173 396.138 367.852 396.222C368.531 396.297 369.149 396.173 369.707 395.851C370.264 395.529 370.475 395.175 370.337 394.787C370.2 394.391 369.707 393.947 368.858 393.457C368.017 392.972 367.258 392.692 366.579 392.617C365.9 392.533 365.285 392.65 364.736 392.967ZM368.865 389.771L369.738 389.267L370.72 389.736C370.648 389.405 370.712 389.078 370.914 388.756C371.116 388.425 371.411 388.147 371.799 387.923C372.996 387.232 374.224 387.251 375.485 387.979L380.117 390.653L379.098 391.241L375.218 389.001C374.742 388.726 374.35 388.532 374.042 388.42C373.743 388.303 373.456 388.254 373.182 388.273C372.907 388.292 372.612 388.392 372.297 388.574C371.949 388.775 371.727 389.024 371.63 389.323C371.533 389.622 371.533 389.911 371.63 390.191L376.273 392.872L375.255 393.46L368.865 389.771ZM244.971 481.147C245.23 480.998 245.573 480.851 246.002 480.706L248.027 482.043L247.202 482.519L245.832 481.728L245.771 481.763C244.785 482.333 244.789 483.142 245.784 484.192L248.475 485.746L249.772 484.997L250.561 485.452L247.238 487.37L246.45 486.915L247.457 486.334L242.643 483.555L241.637 484.136L240.849 483.681L242.619 482.659L244.329 483.422C244.038 482.956 243.933 482.54 244.013 482.176C244.102 481.808 244.422 481.465 244.971 481.147ZM252.423 481.101C253.15 481.493 253.862 481.694 254.557 481.703C255.26 481.708 255.874 481.559 256.4 481.255C256.715 481.073 256.957 480.882 257.127 480.681C257.297 480.471 257.434 480.224 257.539 479.939L258.691 480.058C258.627 480.366 258.465 480.67 258.206 480.968C257.956 481.262 257.636 481.521 257.248 481.745C256.327 482.277 255.309 482.52 254.193 482.473C253.078 482.417 252.015 482.098 251.004 481.514C250.366 481.146 249.909 480.751 249.634 480.331C249.351 479.907 249.279 479.491 249.416 479.085C249.545 478.675 249.889 478.308 250.447 477.986C251.255 477.52 252.172 477.317 253.199 477.377C254.225 477.429 255.224 477.734 256.194 478.294C256.38 478.402 256.553 478.511 256.715 478.623L252.423 481.101ZM251.295 478.462C250.802 478.747 250.58 479.081 250.629 479.463C250.669 479.841 251.008 480.238 251.647 480.653L254.969 478.735C254.29 478.353 253.631 478.14 252.993 478.098C252.354 478.056 251.788 478.178 251.295 478.462ZM266.47 475.889C266.398 476.099 266.244 476.318 266.01 476.547C265.783 476.771 265.517 476.972 265.209 477.149C264.539 477.536 263.839 477.739 263.112 477.758C262.376 477.772 261.722 477.613 261.148 477.282L257.341 475.084L255.874 475.931L255.073 475.469L256.54 474.622L255.098 473.789L255.995 473.131L257.559 474.034L259.778 472.753L260.445 473.292L258.359 474.496L262.154 476.687C262.518 476.897 262.886 476.997 263.257 476.988C263.629 476.979 264.029 476.85 264.458 476.603C264.894 476.351 265.201 476.057 265.379 475.721L266.47 475.889ZM268.151 473.155C268.563 473.393 268.951 473.519 269.315 473.533C269.679 473.537 270.046 473.432 270.418 473.218C270.758 473.022 270.988 472.777 271.109 472.483C271.23 472.189 271.239 471.904 271.133 471.629L266.429 468.913L267.448 468.325L273.837 472.014L272.964 472.518L272.019 472.07C272.083 472.396 272.019 472.718 271.825 473.036C271.631 473.344 271.344 473.607 270.964 473.827C270.358 474.177 269.735 474.349 269.097 474.345C268.466 474.335 267.848 474.156 267.242 473.806L262.598 471.125L263.616 470.537L268.151 473.155ZM274.051 464.358C274.309 464.209 274.653 464.062 275.081 463.917L277.106 465.254L276.282 465.73L274.912 464.939L274.851 464.974C273.865 465.544 273.869 466.353 274.863 467.403L277.555 468.957L278.852 468.208L279.64 468.663L276.318 470.581L275.53 470.126L276.536 469.545L271.723 466.766L270.717 467.347L269.928 466.892L271.699 465.87L273.408 466.633C273.117 466.167 273.012 465.751 273.093 465.387C273.182 465.019 273.501 464.676 274.051 464.358ZM277.138 462.73L278.011 462.226L278.993 462.695C278.92 462.364 278.985 462.037 279.187 461.715C279.389 461.384 279.684 461.106 280.072 460.882C281.268 460.191 282.497 460.21 283.758 460.938L288.389 463.612L287.371 464.2L283.491 461.96C283.014 461.685 282.622 461.491 282.315 461.379C282.016 461.262 281.729 461.213 281.454 461.232C281.179 461.251 280.884 461.351 280.569 461.533C280.221 461.734 279.999 461.983 279.902 462.282C279.805 462.581 279.805 462.87 279.902 463.15L284.546 465.831L283.527 466.419L277.138 462.73ZM300.851 450.061C300.778 449.73 300.835 449.408 301.021 449.095C301.206 448.783 301.493 448.514 301.881 448.29C303.078 447.6 304.306 447.618 305.567 448.346L310.199 451.02L309.18 451.608L304.561 448.941C304.181 448.722 303.817 448.615 303.47 448.619C303.114 448.619 302.742 448.731 302.354 448.955C302.023 449.147 301.809 449.392 301.712 449.69C301.615 449.989 301.611 450.276 301.7 450.551L306.355 453.239L305.337 453.827L296.389 448.661L297.298 448.01L300.851 450.061ZM316.838 446.235L317.663 446.711L312.849 449.49L312.025 449.014L314.074 447.831L307.66 444.128L306.908 445.892L305.744 445.738L306.678 443.407L307.575 442.889L315.104 447.236L316.838 446.235ZM424.439 378.708C424.366 378.376 424.423 378.054 424.608 377.742C424.794 377.429 425.081 377.161 425.469 376.937C426.666 376.246 427.894 376.265 429.155 376.993L433.787 379.667L432.768 380.255L428.149 377.588C427.769 377.368 427.405 377.261 427.058 377.266C426.702 377.266 426.33 377.378 425.942 377.602C425.611 377.793 425.397 378.038 425.3 378.337C425.203 378.635 425.199 378.922 425.287 379.198L429.943 381.886L428.925 382.474L419.977 377.308L420.886 376.657L424.439 378.708ZM440.426 374.882L441.251 375.358L436.437 378.137L435.613 377.661L437.662 376.478L431.248 372.775L430.496 374.539L429.332 374.385L430.266 372.054L431.163 371.536L438.692 375.883L440.426 374.882Z"
              fill="#6FEC5B"
            />
            <path
              d="M388.4 383.407L389.867 385.024L388.825 385.626L383.199 379.228L384.533 378.458L395.602 381.713L394.511 382.343L391.71 381.496L388.4 383.407ZM390.558 381.153L384.739 379.375L387.806 382.742L390.558 381.153ZM393.403 375.45C394.947 374.559 396.826 374.753 399.041 376.031C400.051 376.615 400.649 377.203 400.835 377.795C401.021 378.388 400.714 378.915 399.914 379.377C399.219 379.779 398.41 379.965 397.489 379.937L400.532 381.694L399.635 382.352L390.675 377.179L391.548 376.675L392.53 377.144C392.433 376.818 392.457 376.51 392.603 376.22C392.756 375.926 393.023 375.67 393.403 375.45ZM393.985 376.066C393.662 376.253 393.46 376.482 393.379 376.752C393.306 377.018 393.314 377.294 393.403 377.578L396.567 379.405C396.988 379.452 397.396 379.445 397.792 379.384C398.188 379.314 398.536 379.193 398.835 379.02C399.368 378.712 399.562 378.367 399.417 377.984C399.271 377.592 398.778 377.154 397.937 376.668C397.097 376.183 396.353 375.889 395.707 375.786C395.06 375.684 394.486 375.777 393.985 376.066ZM400.673 371.253C402.217 370.362 404.096 370.555 406.311 371.834C407.321 372.417 407.919 373.005 408.105 373.598C408.291 374.191 407.984 374.718 407.184 375.18C406.488 375.581 405.68 375.768 404.759 375.74L407.802 377.497L406.905 378.155L397.945 372.982L398.818 372.478L399.8 372.947C399.703 372.62 399.727 372.312 399.873 372.023C400.026 371.729 400.293 371.472 400.673 371.253ZM401.255 371.869C400.931 372.056 400.729 372.284 400.649 372.555C400.576 372.821 400.584 373.096 400.673 373.381L403.837 375.208C404.258 375.255 404.666 375.248 405.062 375.187C405.458 375.117 405.805 374.996 406.105 374.823C406.638 374.515 406.832 374.17 406.687 373.787C406.541 373.395 406.048 372.956 405.207 372.471C404.367 371.986 403.623 371.692 402.976 371.589C402.33 371.486 401.756 371.58 401.255 371.869ZM408.731 369.233C409.555 369.709 410.368 370.07 411.168 370.318C411.96 370.56 412.788 370.721 413.653 370.801C414.518 370.871 415.533 370.887 416.696 370.85L416.733 371.473C415.448 371.552 414.3 371.561 413.29 371.501C412.287 371.435 411.321 371.274 410.392 371.018C409.47 370.756 408.561 370.367 407.664 369.849C406.767 369.331 406.092 368.806 405.639 368.274C405.195 367.737 404.916 367.179 404.802 366.601C404.697 366.017 404.714 365.355 404.851 364.613L405.93 364.634C405.857 365.31 405.882 365.898 406.003 366.398C406.132 366.892 406.411 367.371 406.839 367.833C407.268 368.285 407.898 368.752 408.731 369.233ZM418.11 363.818C417.278 363.337 416.465 362.975 415.673 362.733C414.881 362.481 414.053 362.32 413.188 362.25C412.331 362.175 411.317 362.159 410.145 362.201L410.108 361.578C411.393 361.498 412.537 361.491 413.539 361.557C414.55 361.617 415.516 361.778 416.437 362.04C417.367 362.296 418.28 362.684 419.177 363.202C420.074 363.72 420.745 364.247 421.19 364.784C421.643 365.316 421.921 365.873 422.026 366.457C422.14 367.035 422.128 367.696 421.99 368.438L420.911 368.417C420.976 367.745 420.943 367.161 420.814 366.667C420.685 366.163 420.41 365.682 419.99 365.225C419.561 364.763 418.935 364.294 418.11 363.818ZM428.346 352.042C427.271 352.663 427.089 353.141 427.8 353.477L430.528 354.772C430.609 354.809 430.718 354.868 430.856 354.947C431.244 355.171 431.45 355.397 431.474 355.626C431.49 355.85 431.341 356.095 431.025 356.361C431.494 356.174 431.919 356.088 432.298 356.102C432.678 356.107 433.066 356.223 433.462 356.452C433.6 356.531 433.705 356.597 433.778 356.648L436.021 358.223C436.344 358.447 436.716 358.522 437.136 358.447C437.556 358.372 438.013 358.193 438.506 357.908L439.318 358.377C438.591 358.797 437.872 359.068 437.16 359.189C436.449 359.31 435.794 359.198 435.196 358.853C435.091 358.792 435.014 358.743 434.966 358.706L432.917 357.229C432.868 357.192 432.792 357.143 432.686 357.082C432.331 356.877 431.935 356.802 431.498 356.858C431.062 356.914 430.492 357.145 429.789 357.551L428.964 357.075C429.667 356.669 430.072 356.342 430.177 356.095C430.274 355.843 430.144 355.614 429.789 355.409C429.692 355.353 429.611 355.311 429.546 355.283L426.964 354.086C426.899 354.058 426.814 354.014 426.709 353.953C426.111 353.608 425.917 353.23 426.127 352.819C426.337 352.408 426.806 351.993 427.534 351.573L428.346 352.042ZM296.648 451.424L295 455.414L301.935 454.476L302.129 455.218L294.648 456.219L293.593 455.61L295.375 451.263L296.648 451.424ZM320.568 440.05L321.61 440.652L319.877 444.971L318.579 444.852L320.216 440.855L313.305 441.807L313.026 441.072L320.568 440.05ZM327.183 436.637L324.031 438.457L327.995 440.746L326.94 441.355L318.587 436.532L319.642 435.923L323.17 437.96L326.322 436.14L322.794 434.103L323.849 433.494L332.202 438.317L331.148 438.926L327.183 436.637ZM332.392 434.931C333.119 435.323 333.83 435.524 334.525 435.533C335.229 435.538 335.843 435.389 336.368 435.085C336.684 434.903 336.926 434.712 337.096 434.511C337.266 434.301 337.403 434.054 337.508 433.769L338.66 433.888C338.595 434.196 338.434 434.5 338.175 434.798C337.924 435.092 337.605 435.351 337.217 435.575C336.296 436.107 335.277 436.35 334.162 436.303C333.046 436.247 331.983 435.928 330.973 435.344C330.334 434.976 329.878 434.581 329.603 434.161C329.32 433.737 329.247 433.321 329.385 432.915C329.514 432.505 329.858 432.138 330.415 431.816C331.224 431.35 332.141 431.147 333.168 431.207C334.194 431.259 335.192 431.564 336.162 432.124C336.348 432.232 336.522 432.341 336.684 432.453L332.392 434.931ZM331.264 432.292C330.771 432.577 330.549 432.911 330.597 433.293C330.638 433.671 330.977 434.068 331.616 434.483L334.938 432.565C334.259 432.183 333.6 431.97 332.961 431.928C332.323 431.886 331.757 432.008 331.264 432.292ZM342.608 430.489C343.182 430.82 343.82 430.783 344.523 430.377C344.855 430.186 345.138 429.938 345.372 429.635L346.378 429.908C346.192 430.267 345.796 430.622 345.19 430.972C344.616 431.303 343.998 431.478 343.335 431.497C342.68 431.511 342.082 431.362 341.541 431.049L335.018 427.283L333.054 428.417L332.241 427.948L335.224 426.226L342.608 430.489ZM349.878 426.292C350.451 426.623 351.09 426.586 351.793 426.18C352.125 425.988 352.408 425.741 352.642 425.438L353.648 425.711C353.462 426.07 353.066 426.425 352.46 426.775C351.886 427.106 351.268 427.281 350.605 427.3C349.95 427.314 349.352 427.164 348.811 426.852L342.288 423.086L340.324 424.22L339.511 423.751L342.494 422.029L349.878 426.292ZM352.14 419.273C353.021 418.765 353.995 418.548 355.062 418.622C356.129 418.688 357.176 419.017 358.202 419.609C359.205 420.188 359.77 420.795 359.9 421.429C360.029 422.055 359.657 422.619 358.784 423.123C357.903 423.632 356.929 423.854 355.862 423.788C354.787 423.718 353.736 423.387 352.71 422.794C351.7 422.211 351.13 421.607 351 420.981C350.879 420.351 351.259 419.782 352.14 419.273ZM352.977 419.756C352.419 420.078 352.209 420.438 352.346 420.834C352.484 421.231 352.973 421.672 353.813 422.157C354.654 422.643 355.414 422.927 356.093 423.011C356.772 423.086 357.39 422.962 357.948 422.64C358.505 422.318 358.716 421.964 358.578 421.576C358.441 421.18 357.948 420.736 357.099 420.246C356.258 419.761 355.499 419.481 354.82 419.406C354.141 419.322 353.526 419.439 352.977 419.756ZM375.506 413.315L374.124 414.113L366.862 411.026L372.196 415.226L370.778 416.045L361.26 411.894L362.315 411.285L370.402 414.932L365.176 410.753L366.462 410.011L373.651 413.056L367.444 408.324L368.414 407.764L375.506 413.315ZM373.95 406.682C374.831 406.173 375.805 405.956 376.872 406.031C377.939 406.096 378.985 406.425 380.012 407.018C381.014 407.596 381.58 408.203 381.709 408.838C381.839 409.463 381.467 410.028 380.594 410.532C379.713 411.04 378.739 411.262 377.672 411.197C376.597 411.127 375.546 410.795 374.52 410.203C373.509 409.619 372.939 409.015 372.81 408.39C372.689 407.76 373.069 407.19 373.95 406.682ZM374.786 407.165C374.229 407.487 374.018 407.846 374.156 408.243C374.293 408.639 374.782 409.08 375.623 409.566C376.463 410.051 377.223 410.336 377.902 410.42C378.581 410.494 379.2 410.371 379.757 410.049C380.315 409.727 380.525 409.372 380.388 408.985C380.25 408.588 379.757 408.145 378.909 407.655C378.068 407.169 377.308 406.889 376.629 406.815C375.95 406.731 375.336 406.847 374.786 407.165ZM383.099 401.399C383.358 401.25 383.701 401.103 384.129 400.958L386.154 402.295L385.33 402.771L383.96 401.98L383.899 402.015C382.913 402.585 382.917 403.394 383.911 404.444L386.603 405.998L387.9 405.249L388.688 405.704L385.366 407.622L384.578 407.167L385.584 406.586L380.771 403.807L379.765 404.388L378.977 403.933L380.747 402.911L382.456 403.674C382.165 403.208 382.06 402.792 382.141 402.428C382.23 402.06 382.549 401.717 383.099 401.399ZM393.497 401.108C394.071 401.439 394.709 401.402 395.412 400.996C395.744 400.805 396.027 400.557 396.261 400.254L397.268 400.527C397.082 400.886 396.686 401.241 396.079 401.591C395.505 401.922 394.887 402.097 394.224 402.116C393.57 402.13 392.971 401.981 392.43 401.668L385.907 397.902L383.943 399.036L383.131 398.567L386.113 396.845L393.497 401.108ZM395.735 391.29L404.695 396.463L403.798 396.981L402.864 396.554C402.953 396.876 402.925 397.172 402.779 397.443C402.634 397.714 402.383 397.952 402.028 398.157C401.219 398.624 400.314 398.806 399.312 398.703C398.318 398.596 397.303 398.243 396.269 397.646C395.63 397.277 395.161 396.89 394.862 396.484C394.555 396.073 394.446 395.679 394.535 395.301C394.624 394.914 394.923 394.573 395.432 394.279C396.135 393.873 396.964 393.689 397.917 393.726L394.595 391.808L395.735 391.29ZM396.523 394.601C395.99 394.909 395.788 395.268 395.917 395.679C396.054 396.085 396.539 396.528 397.372 397.009C398.196 397.485 398.952 397.772 399.639 397.87C400.326 397.959 400.92 397.858 401.421 397.569C402.028 397.219 402.214 396.72 401.979 396.071L398.803 394.237C398.358 394.186 397.942 394.193 397.554 394.258C397.158 394.319 396.814 394.433 396.523 394.601ZM407.224 391.825L406.315 392.35L400.592 389.186L401.732 388.528L407.224 391.825ZM408.037 392.812C408.271 392.676 408.546 392.611 408.861 392.616C409.168 392.616 409.435 392.681 409.661 392.812C409.896 392.947 410.013 393.103 410.013 393.281C410.013 393.458 409.896 393.614 409.661 393.75C409.435 393.88 409.164 393.948 408.849 393.953C408.534 393.948 408.263 393.88 408.037 393.75C407.81 393.619 407.697 393.465 407.697 393.288C407.697 393.101 407.81 392.942 408.037 392.812ZM412.966 384.267L411.318 388.257L418.253 387.319L418.447 388.061L410.966 389.062L409.911 388.453L411.693 384.106L412.966 384.267ZM421.97 387.511L416.454 378.348L417.654 378.103L423.158 387.245L421.97 387.511ZM444.156 368.696L445.198 369.298L443.465 373.617L442.167 373.498L443.804 369.501L436.893 370.453L436.614 369.718L444.156 368.696ZM240.417 499.605C241.144 499.185 241.864 498.914 242.575 498.793C243.286 498.672 243.941 498.784 244.539 499.129C244.644 499.19 244.721 499.239 244.769 499.276L246.843 500.767C246.875 500.795 246.932 500.832 247.012 500.879C247.376 501.089 247.788 501.164 248.249 501.103C248.718 501.038 249.284 500.814 249.946 500.431L250.771 500.907C250.1 501.294 249.712 501.621 249.607 501.887C249.502 502.153 249.635 502.393 250.007 502.608C250.088 502.655 250.157 502.69 250.213 502.713L252.771 503.896C252.836 503.924 252.921 503.968 253.026 504.029C253.624 504.374 253.818 504.752 253.608 505.163C253.398 505.574 252.929 505.989 252.202 506.409L251.389 505.94C251.882 505.655 252.194 505.392 252.323 505.149C252.452 504.906 252.323 504.692 251.935 504.505L249.207 503.21C249.029 503.126 248.912 503.068 248.855 503.035C248.451 502.802 248.253 502.571 248.261 502.342C248.269 502.113 248.467 501.85 248.855 501.551C248.338 501.756 247.873 501.861 247.461 501.866C247.049 501.861 246.645 501.745 246.249 501.516C246.119 501.441 246.022 501.381 245.958 501.334L243.715 499.759C243.133 499.348 242.304 499.453 241.229 500.074L240.417 499.605Z"
              fill="#EDEDED"
            />
          </g>
        </g>

        <g className={styles.movement}>
          <g className={styles.browser}>
            <rect
              fill="#FAFAFA"
              height="39"
              rx="9.5"
              stroke="#E6E6E6"
              transform="matrix(0.866025 -0.5 0.866025 0.5 201.116 239.933)"
              width="478"
              x="0.866025"
            />
            <path
              d="M233.909 235.5L233.909 240.5H242.569"
              opacity="0.1"
              stroke="black"
            />
            <path
              d="M252.096 225H260.756L260.756 230"
              opacity="0.1"
              stroke="black"
            />
            <path
              clipRule="evenodd"
              d="M285.297 211.689C286.961 213.041 286.795 214.895 284.764 216.068C282.488 217.382 278.732 217.344 276.374 215.983C274.017 214.622 273.951 212.453 276.227 211.139C277.861 210.196 280.257 209.949 282.352 210.389L280.79 211.291L281.903 211.934L283.812 210.831L284.053 210.692L284.719 210.308L285.128 210.071L281.417 207.929L280.342 208.549L282.118 209.575C279.731 209.21 277.124 209.55 275.299 210.603C272.528 212.203 272.609 214.843 275.478 216.5C278.348 218.157 282.921 218.203 285.692 216.603C288.219 215.144 288.374 212.819 286.204 211.165L285.297 211.689Z"
              fill="#313131"
              fillRule="evenodd"
              opacity="0.5"
            />
            <rect
              fill="white"
              height="23"
              rx="5.5"
              transform="matrix(0.866025 -0.5 0.866025 0.5 282.522 200.933)"
              width="384"
              x="0.866025"
            />
            <path d="M300.593 197L306.655 203.5" opacity="0.4" stroke="black" />
            <rect
              height="23"
              rx="5.5"
              stroke="#EFF1F3"
              transform="matrix(0.866025 -0.5 0.866025 0.5 282.522 200.933)"
              width="384"
              x="0.866025"
            />
          </g>
        </g>

        <g className={styles.movement}>
          <g className={styles.preview}>
            <rect
              fill="#FCFCFC"
              height="260"
              rx="10"
              transform="matrix(0.866025 -0.5 0.866025 0.5 347 275.5)"
              width="479"
            />
            <rect
              height="259"
              rx="9.5"
              stroke="black"
              strokeOpacity="0.09"
              transform="matrix(0.866025 -0.5 0.866025 0.5 347.116 275.933)"
              width="478"
              x="0.866025"
            />
            <path
              d="M413.069 288.855L390.63 275.9L395.273 273.22L403.829 278.159L412.597 273.097L404.042 268.157L408.7 265.468L431.139 278.423L426.481 281.112L416.464 275.329L407.695 280.392L417.712 286.175L413.069 288.855ZM428.368 264.483C427.364 265.063 426.897 265.696 426.968 266.382C427.049 267.062 427.557 267.753 428.49 268.456L435.234 264.562C434.016 263.941 432.798 263.643 431.58 263.666C430.363 263.678 429.292 263.95 428.368 264.483ZM424.791 262.418C426.171 261.621 427.673 261.053 429.297 260.713C430.921 260.373 432.651 260.317 434.488 260.546C436.122 260.739 437.685 261.155 439.177 261.794C440.05 262.169 441.191 262.775 442.602 263.613L431.246 270.17C432.971 271.096 434.661 271.468 436.315 271.286C437.33 271.181 438.258 270.885 439.101 270.398C439.994 269.883 440.466 269.317 440.516 268.702C440.547 268.368 440.435 267.993 440.182 267.577L444.611 265.02C445.484 265.652 445.971 266.525 446.073 267.639C446.266 269.391 445.083 271.005 442.526 272.481C440.415 273.7 437.873 274.383 434.899 274.529C431.926 274.676 428.906 273.864 425.841 272.095C422.969 270.437 421.493 268.746 421.411 267.023C421.34 265.295 422.467 263.76 424.791 262.418ZM457.064 263.455L452.725 265.96L430.287 253.005L434.625 250.5L457.064 263.455ZM465.741 258.445L461.403 260.95L438.964 247.995L443.302 245.49L465.741 258.445ZM474.373 249.929C475.641 249.196 476.164 248.373 475.941 247.459C475.717 246.545 474.774 245.607 473.109 244.646C471.445 243.686 469.826 243.144 468.253 243.021C466.67 242.892 465.244 243.193 463.975 243.926C462.707 244.658 462.179 245.484 462.392 246.404C462.605 247.312 463.544 248.247 465.208 249.208C466.873 250.169 468.497 250.714 470.08 250.843C471.673 250.966 473.104 250.661 474.373 249.929ZM477.661 242.019C480.097 243.425 481.482 245.033 481.817 246.844C482.141 248.648 480.878 250.374 478.026 252.021C475.174 253.667 472.186 254.396 469.06 254.209C465.924 254.016 463.138 253.216 460.702 251.81C458.307 250.427 456.932 248.824 456.577 247.002C456.222 245.18 457.47 243.445 460.322 241.799C463.174 240.152 466.178 239.432 469.334 239.637C472.49 239.842 475.266 240.636 477.661 242.019ZM478.696 225.056L494.513 230.76L498.73 232.456L495.883 230.057L485.485 221.136L490.433 218.279L505.945 224.159L510.208 225.829L507.452 223.447L497.466 214.219L502.231 211.468L518.352 228.07L513.877 230.654L498.045 224.643L492.914 222.595L496.461 225.557L506.874 234.697L502.52 237.211L473.718 227.93L478.696 225.056ZM531.003 217.233C532.271 216.501 532.794 215.678 532.571 214.764C532.347 213.85 531.403 212.912 529.739 211.951C528.075 210.99 526.456 210.448 524.883 210.325C523.3 210.196 521.874 210.498 520.605 211.23C519.337 211.963 518.809 212.789 519.022 213.709C519.235 214.617 520.174 215.552 521.838 216.513C523.503 217.474 525.126 218.019 526.71 218.147C528.303 218.271 529.734 217.966 531.003 217.233ZM534.291 209.323C536.726 210.729 538.112 212.338 538.447 214.148C538.771 215.953 537.508 217.679 534.656 219.325C531.804 220.972 528.816 221.701 525.69 221.514C522.554 221.32 519.768 220.521 517.332 219.114C514.937 217.731 513.562 216.129 513.207 214.307C512.852 212.484 514.1 210.75 516.952 209.104C519.803 207.457 522.807 206.736 525.964 206.941C529.12 207.146 531.896 207.94 534.291 209.323ZM537.701 197.282C537.782 197.235 537.853 197.2 537.914 197.177C537.975 197.142 538.107 197.071 538.31 196.966L542.755 199.532C542.45 199.673 542.186 199.802 541.963 199.919C541.74 200.036 541.562 200.133 541.43 200.209C539.685 201.217 539.081 202.222 539.619 203.224C539.923 203.786 540.74 204.451 542.07 205.219L550.001 209.798L545.632 212.32L529.039 202.74L533.179 200.35L536.072 202.02C535.635 200.994 535.463 200.221 535.554 199.699C535.686 198.838 536.402 198.032 537.701 197.282ZM562.256 202.723L557.917 205.228L535.478 192.272L539.817 189.768L562.256 202.723ZM555.634 186.929C556.638 186.349 557.755 185.962 558.983 185.769C560.2 185.569 561.444 185.555 562.712 185.725L554.796 181.154L559.196 178.614L581.604 191.552L577.387 193.986L575.089 192.659C575.454 193.585 575.464 194.405 575.119 195.12C574.774 195.835 574.013 196.532 572.836 197.212C570.897 198.331 568.482 198.823 565.589 198.688C562.697 198.542 560.023 197.76 557.567 196.342C554.735 194.707 553.157 193.046 552.833 191.358C552.518 189.665 553.452 188.188 555.634 186.929ZM570.43 194.382C571.658 193.673 572.135 192.87 571.861 191.974C571.587 191.077 570.725 190.21 569.273 189.372C567.244 188.2 565.28 187.658 563.382 187.746C562.225 187.805 561.231 188.074 560.398 188.555C559.13 189.287 558.678 190.104 559.044 191.007C559.409 191.897 560.302 192.753 561.723 193.573C563.255 194.458 564.783 194.994 566.305 195.182C567.827 195.357 569.202 195.091 570.43 194.382ZM564.6 175.547L569.365 172.796L575.058 176.083L584.299 182.842L582.03 184.151L570.293 178.834L564.6 175.547ZM582.67 185.856L587.206 183.237L591.606 185.777L587.069 188.396L582.67 185.856Z"
              fill="#1F1F1F"
            />
            <g>
              <rect
                fill="#EAEAEA"
                height="30"
                rx="6"
                transform="matrix(0.866025 -0.5 0.866025 0.5 913.744 165.871)"
                width="30"
              />
              <g>
                <path
                  clipRule="evenodd"
                  d="M931.429 161.564L928.591 167.117C928.461 167.372 928.583 167.647 928.907 167.834L936.227 172.06C936.542 172.242 937.002 172.314 937.434 172.248L947.288 170.746C947.721 170.68 948.06 170.486 948.177 170.236L950.841 164.592C950.96 164.342 950.836 164.074 950.518 163.89L943.191 159.659C942.873 159.476 942.41 159.405 941.977 159.472L932.524 160.946C931.998 161.028 931.583 161.262 931.429 161.564ZM936.701 171.311L930.215 167.566C929.96 167.419 929.854 167.203 929.949 167.002L932.303 162.103C932.358 162 932.525 161.873 932.659 161.796C932.792 161.719 933.031 161.619 933.192 161.59L941.632 160.257C941.801 160.232 942.09 160.232 942.254 160.257C942.422 160.283 942.526 160.311 942.653 160.385L949.139 164.13C949.394 164.277 949.5 164.442 949.405 164.643L947.007 169.721C946.96 169.82 946.906 169.881 946.784 169.951C946.663 170.022 946.512 170.078 946.34 170.105L937.723 171.439C937.375 171.493 936.956 171.458 936.701 171.311ZM932.303 167.848L934.835 169.31C935.013 169.413 935.146 169.438 935.413 169.387L938.345 168.925C938.611 168.874 938.789 168.925 938.922 169.002L940.699 170.028C940.877 170.131 941.01 170.156 941.276 170.105L944.208 169.643C944.475 169.592 944.564 169.49 944.386 169.387L939.633 166.643C939.5 166.566 939.322 166.515 939.055 166.566L932.481 167.592C932.259 167.617 932.126 167.746 932.303 167.848ZM936.568 161.898L935.857 163.386C935.813 163.514 935.635 163.617 935.413 163.642L932.836 164.053C932.667 164.08 932.528 164.16 932.481 164.258L931.593 166.104C931.504 166.258 931.681 166.361 931.948 166.309L938.389 165.309C938.561 165.282 938.698 165.203 938.744 165.104L940.477 161.385C940.521 161.257 940.388 161.129 940.121 161.18L936.923 161.693C936.754 161.72 936.615 161.8 936.568 161.898ZM946.918 166.438C947.095 166.54 947.118 166.63 947.051 166.771L946.251 168.464C946.207 168.592 945.985 168.669 945.807 168.567L941.054 165.822C940.927 165.749 940.874 165.589 940.921 165.489L942.742 161.616C942.792 161.509 943.005 161.512 943.142 161.591L945.674 163.053C945.805 163.128 945.861 163.232 945.807 163.335L944.919 165.027C944.865 165.13 944.876 165.259 945.008 165.335L946.918 166.438Z"
                  fill="#8E8E8E"
                  fillRule="evenodd"
                />
              </g>
            </g>
            <g>
              <rect
                fill="#EAEAEA"
                height="30"
                rx="6"
                transform="matrix(0.866025 -0.5 0.866025 0.5 879.103 185.871)"
                width="30"
              />
              <path
                clipRule="evenodd"
                d="M909.705 184.06C911.37 185.412 911.204 187.266 909.172 188.439C906.896 189.753 903.14 189.715 900.783 188.354C898.426 186.993 898.36 184.824 900.636 183.51C902.27 182.567 904.666 182.32 906.76 182.76L905.198 183.662L906.312 184.305L908.221 183.203L908.462 183.063L909.128 182.679L909.537 182.443L905.826 180.3L904.75 180.92L906.526 181.946C904.139 181.581 901.533 181.921 899.708 182.975C896.937 184.574 897.017 187.214 899.887 188.871C902.757 190.528 907.329 190.574 910.1 188.975C912.628 187.515 912.783 185.19 910.612 183.536L909.705 184.06Z"
                fill="#8E8E8E"
                fillRule="evenodd"
              />
            </g>
          </g>
        </g>
      </svg>
    </div>
  );
};

export default ComponentsIllustration;
