import React from "react";

import styles from "./Client.module.css";

const ClientIllustration: React.FC<{ isActive: boolean }> = ({ isActive }) => {
  return (
    <div className={isActive ? styles.active : ""}>
      <svg
        className={styles.svg}
        fill="none"
        height="720"
        viewBox="0 0 742 640"
        width="650"
        xmlns="http://www.w3.org/2000/svg"
      >
        <g className={styles.movement}>
          <g className={styles.editor}>
            <rect
              fill="#151515"
              height="405.137"
              rx="10"
              transform="matrix(0.866025 -0.5 0.866025 0.5 2 427)"
              width="446.868"
            />

            <g className={styles.movement}>
              <path
                d="M113.867 463.368C114.468 463.687 115.052 463.896 115.62 463.995C116.184 464.09 116.716 464.094 117.218 464.007C117.715 463.917 118.155 463.761 118.538 463.54C118.921 463.318 119.21 463.086 119.404 462.843C119.603 462.597 119.754 462.316 119.858 461.999L121.207 462.13C121.131 462.491 120.947 462.846 120.653 463.195C120.365 463.542 119.986 463.851 119.518 464.122C118.794 464.54 118.013 464.802 117.175 464.909C116.337 465.015 115.493 464.978 114.641 464.798C113.789 464.612 112.977 464.297 112.206 463.851C111.448 463.414 110.911 462.948 110.594 462.454C110.277 461.959 110.194 461.474 110.346 460.999C110.497 460.523 110.904 460.094 111.567 459.712C112.196 459.348 112.887 459.121 113.64 459.031C114.387 458.938 115.157 458.981 115.947 459.158C116.737 459.33 117.511 459.635 118.268 460.072C118.396 460.146 118.514 460.217 118.623 460.285C118.727 460.351 118.817 460.411 118.893 460.466L113.867 463.368ZM112.561 460.269C112.007 460.589 111.74 460.97 111.758 461.413C111.782 461.852 112.18 462.325 112.951 462.831L116.848 460.581C116.034 460.127 115.258 459.881 114.52 459.843C113.777 459.802 113.124 459.944 112.561 460.269ZM125.127 460.694L123.764 461.481L122.579 457.608L116.63 456.969L118.043 456.153L122.558 456.76L121.528 454.141L122.891 453.354L123.956 456.756L130.707 457.473L129.245 458.317L123.992 457.645L125.127 460.694ZM128.274 450.066C128.936 449.683 129.625 449.472 130.34 449.431C131.059 449.387 131.8 449.484 132.562 449.722C133.319 449.957 134.088 450.299 134.869 450.75C135.621 451.185 136.187 451.634 136.565 452.099C136.944 452.558 137.088 453.007 136.998 453.447C136.909 453.887 136.539 454.294 135.891 454.669C135.072 455.141 134.126 455.354 133.051 455.308L136.615 457.365L135.572 458.14L125.086 452.086L126.102 451.5L127.244 452.045C127.136 451.666 127.166 451.306 127.337 450.968C127.512 450.626 127.824 450.325 128.274 450.066ZM128.948 450.783C128.536 451.021 128.297 451.304 128.231 451.632C128.165 451.954 128.182 452.261 128.281 452.554L131.987 454.693C132.469 454.748 132.943 454.74 133.406 454.669C133.87 454.592 134.28 454.451 134.634 454.246C135.254 453.888 135.484 453.483 135.323 453.029C135.162 452.576 134.582 452.061 133.584 451.484C132.931 451.107 132.327 450.83 131.774 450.652C131.215 450.472 130.704 450.392 130.24 450.414C129.772 450.433 129.341 450.556 128.948 450.783ZM135.935 445.643C136.64 445.235 137.39 444.988 138.186 444.901C138.981 444.808 139.788 444.861 140.606 445.061C141.43 445.257 142.237 445.584 143.027 446.04C143.789 446.48 144.34 446.94 144.681 447.421C145.022 447.902 145.121 448.378 144.979 448.848C144.837 449.312 144.416 449.747 143.716 450.151C143.015 450.555 142.265 450.803 141.465 450.893C140.665 450.983 139.851 450.931 139.023 450.737C138.195 450.538 137.39 450.213 136.61 449.762C135.838 449.316 135.282 448.853 134.941 448.372C134.601 447.891 134.506 447.419 134.657 446.954C134.809 446.484 135.235 446.047 135.935 445.643ZM136.908 446.204C136.264 446.576 136.016 446.995 136.162 447.462C136.309 447.924 136.884 448.445 137.887 449.024C138.872 449.592 139.764 449.922 140.564 450.012C141.368 450.099 142.092 449.957 142.736 449.585C143.38 449.214 143.623 448.797 143.467 448.335C143.316 447.871 142.743 447.352 141.749 446.778C140.755 446.204 139.861 445.873 139.066 445.786C138.266 445.696 137.547 445.835 136.908 446.204ZM148.949 446.941L148.033 446.412L149.198 445.74L143.554 442.482L142.39 443.154L141.474 442.625L143.547 441.428L145.535 442.322C145.208 441.8 145.083 441.323 145.158 440.891C145.234 440.46 145.61 440.048 146.287 439.658C146.495 439.538 146.696 439.441 146.89 439.367C147.084 439.288 147.29 439.212 147.508 439.141L148.225 439.957C148.026 440.023 147.854 440.087 147.707 440.15C147.555 440.21 147.397 440.288 147.231 440.383C146.659 440.714 146.37 441.115 146.365 441.588C146.36 442.061 146.647 442.606 147.224 443.224L150.39 445.052L151.909 444.174L152.825 444.703L148.949 446.941ZM148.885 441.264L147.26 440.326L146.479 439.736L147.508 439.141L149.865 440.699L148.885 441.264ZM162.595 438.628C162.51 438.874 162.332 439.13 162.062 439.395C161.793 439.66 161.483 439.893 161.133 440.095C160.328 440.56 159.497 440.796 158.641 440.804C157.784 440.813 157.025 440.625 156.362 440.243L151.904 437.669L150.186 438.661L149.263 438.128L150.981 437.136L149.284 436.157L150.335 435.386L152.174 436.448L154.758 434.956L155.539 435.571L153.096 436.98L157.54 439.546C157.957 439.787 158.383 439.907 158.818 439.907C159.258 439.904 159.734 439.755 160.245 439.46C160.524 439.299 160.749 439.131 160.92 438.956C161.09 438.781 161.225 438.605 161.324 438.427L162.595 438.628ZM167.191 424.13L168.533 423.527L179.018 429.581L177.974 430.183L176.874 429.679C176.992 430.07 176.962 430.424 176.782 430.741C176.607 431.055 176.313 431.331 175.901 431.569C175.253 431.943 174.555 432.157 173.807 432.212C173.06 432.267 172.293 432.185 171.507 431.966C170.717 431.745 169.936 431.411 169.165 430.966C168.417 430.534 167.865 430.082 167.51 429.609C167.151 429.134 167.021 428.674 167.12 428.228C167.219 427.777 167.577 427.374 168.192 427.019C168.623 426.77 169.077 426.596 169.555 426.494C170.028 426.391 170.535 426.35 171.074 426.372L167.191 424.13ZM169.463 427.392C168.838 427.753 168.601 428.171 168.753 428.646C168.904 429.122 169.475 429.645 170.464 430.216C171.107 430.588 171.715 430.859 172.288 431.032C172.861 431.204 173.388 431.276 173.871 431.249C174.359 431.219 174.796 431.092 175.184 430.868C175.61 430.622 175.852 430.343 175.909 430.032C175.97 429.717 175.949 429.415 175.845 429.126L172.111 426.97C171.604 426.913 171.124 426.919 170.67 426.99C170.21 427.059 169.808 427.193 169.463 427.392ZM179.133 425.686C179.734 426.006 180.319 426.215 180.887 426.313C181.45 426.409 181.982 426.413 182.484 426.326C182.981 426.235 183.421 426.08 183.804 425.858C184.188 425.637 184.476 425.405 184.67 425.162C184.869 424.916 185.02 424.634 185.125 424.317L186.473 424.448C186.398 424.809 186.213 425.164 185.92 425.514C185.631 425.861 185.252 426.17 184.784 426.44C184.06 426.858 183.279 427.121 182.441 427.227C181.604 427.334 180.759 427.297 179.907 427.117C179.055 426.931 178.243 426.615 177.472 426.17C176.715 425.733 176.178 425.267 175.86 424.772C175.543 424.278 175.461 423.793 175.612 423.317C175.763 422.842 176.17 422.413 176.833 422.03C177.462 421.667 178.153 421.44 178.906 421.35C179.654 421.257 180.423 421.299 181.213 421.477C182.003 421.649 182.777 421.954 183.534 422.391C183.662 422.465 183.781 422.536 183.889 422.604C183.993 422.67 184.083 422.73 184.159 422.784L179.133 425.686ZM177.827 422.588C177.273 422.907 177.006 423.288 177.025 423.731C177.048 424.171 177.446 424.644 178.217 425.149L182.115 422.899C181.301 422.446 180.524 422.2 179.786 422.161C179.043 422.12 178.39 422.262 177.827 422.588ZM183.451 414.742C183.853 414.51 184.253 414.32 184.651 414.172C185.048 414.025 185.457 413.903 185.879 413.808L186.383 414.541C186.037 414.62 185.704 414.723 185.382 414.849C185.06 414.974 184.755 415.12 184.466 415.287C183.945 415.588 183.654 415.873 183.593 416.144C183.536 416.412 183.718 416.667 184.139 416.91L185.659 417.787L188.193 416.324L189.002 416.939L186.596 418.328L192.552 421.767L191.359 422.456L185.403 419.017L183.621 420.046L182.684 419.505L184.466 418.476L182.975 417.615C182.511 417.347 182.23 417.048 182.13 416.718C182.036 416.384 182.104 416.047 182.336 415.705C182.563 415.361 182.935 415.04 183.451 414.742ZM201.548 414.688C201.846 414.86 202.113 414.957 202.35 414.979C202.586 415.001 202.842 414.971 203.117 414.889L203.663 415.54C203.299 415.702 202.915 415.805 202.513 415.852C202.106 415.896 201.683 415.853 201.242 415.725C201.318 416.08 201.245 416.426 201.022 416.762C200.795 417.095 200.438 417.402 199.95 417.684C199.203 418.116 198.403 418.334 197.551 418.34C196.699 418.345 195.925 418.147 195.23 417.745C194.458 417.3 194.167 416.785 194.356 416.2C194.546 415.615 195.208 414.995 196.344 414.339L197.444 413.704L196.82 413.343C196.28 413.032 195.741 412.904 195.201 412.958C194.662 413.007 194.113 413.193 193.554 413.516C193.308 413.658 193.05 413.842 192.78 414.069C192.506 414.293 192.243 414.557 191.992 414.86L190.778 414.52C191.067 414.156 191.377 413.838 191.708 413.565C192.04 413.292 192.388 413.05 192.752 412.839C193.684 412.301 194.6 412.024 195.499 412.007C196.399 411.985 197.22 412.189 197.963 412.618L201.548 414.688ZM199.347 416.983C199.716 416.77 199.976 416.513 200.128 416.213C200.275 415.909 200.291 415.599 200.178 415.282L198.254 414.171L197.175 414.794C196.351 415.27 195.911 415.688 195.854 416.049C195.802 416.407 196.015 416.723 196.493 416.999C196.957 417.267 197.428 417.402 197.906 417.405C198.384 417.402 198.864 417.262 199.347 416.983ZM199.703 409.006L204.999 412.064C205.491 412.348 205.948 412.494 206.369 412.502C206.791 412.511 207.217 412.39 207.647 412.142C208.059 411.904 208.331 411.613 208.464 411.269C208.596 410.919 208.603 410.592 208.485 410.289L202.983 407.113L204.176 406.424L211.651 410.74L210.636 411.326L209.528 410.801C209.614 411.189 209.543 411.567 209.315 411.933C209.084 412.296 208.748 412.605 208.307 412.859C207.583 413.277 206.85 413.479 206.107 413.466C205.364 413.446 204.644 413.236 203.949 412.834L198.511 409.695L199.703 409.006ZM206.57 401.566L215.209 406.554C215.578 406.768 215.955 406.854 216.338 406.813C216.721 406.766 217.095 406.638 217.46 406.427C217.687 406.296 217.878 406.158 218.035 406.013C218.191 405.869 218.33 405.714 218.453 405.55L219.646 405.87C219.542 406.045 219.376 406.242 219.149 406.46C218.931 406.679 218.633 406.897 218.255 407.116C217.592 407.498 216.873 407.703 216.097 407.731C215.316 407.755 214.601 407.58 213.953 407.206L206.321 402.8L204.028 404.124L203.084 403.579L206.57 401.566ZM227.861 400.947C227.776 401.193 227.598 401.448 227.329 401.713C227.059 401.978 226.749 402.212 226.399 402.414C225.594 402.878 224.764 403.115 223.907 403.123C223.05 403.131 222.291 402.944 221.628 402.561L217.17 399.988L215.452 400.979L214.529 400.447L216.247 399.455L214.551 398.475L215.601 397.705L217.44 398.766L220.024 397.274L220.805 397.889L218.363 399.299L222.807 401.865C223.223 402.105 223.649 402.225 224.084 402.225C224.525 402.223 225 402.074 225.511 401.779C225.791 401.617 226.015 401.449 226.186 401.275C226.356 401.1 226.491 400.923 226.59 400.746L227.861 400.947ZM232.4 386.481C232.803 386.249 233.203 386.059 233.6 385.911C233.998 385.764 234.407 385.642 234.828 385.546L235.332 386.28C234.987 386.359 234.653 386.462 234.331 386.587C234.01 386.713 233.704 386.859 233.416 387.026C232.895 387.327 232.604 387.612 232.542 387.883C232.486 388.15 232.668 388.406 233.089 388.649L234.608 389.526L237.143 388.063L237.952 388.678L235.545 390.067L241.501 393.506L240.309 394.194L234.353 390.756L232.571 391.785L231.634 391.243L233.416 390.215L231.925 389.354C231.461 389.086 231.179 388.787 231.08 388.456C230.985 388.123 231.054 387.786 231.286 387.444C231.513 387.1 231.885 386.779 232.4 386.481ZM240.495 385.455L245.791 388.513C246.283 388.797 246.74 388.943 247.161 388.951C247.582 388.96 248.008 388.839 248.439 388.591C248.85 388.353 249.122 388.062 249.255 387.718C249.387 387.368 249.395 387.042 249.276 386.738L243.775 383.562L244.967 382.873L252.442 387.189L251.427 387.775L250.32 387.251C250.405 387.639 250.334 388.016 250.107 388.382C249.875 388.745 249.539 389.054 249.099 389.308C248.375 389.726 247.641 389.928 246.898 389.915C246.155 389.896 245.436 389.685 244.74 389.283L239.302 386.144L240.495 385.455ZM254.936 385.75L247.46 381.434L248.476 380.848L249.604 381.393C249.524 380.997 249.609 380.609 249.86 380.229C250.111 379.844 250.452 379.527 250.882 379.278C251.616 378.854 252.342 378.659 253.062 378.692C253.786 378.722 254.493 378.936 255.184 379.335L260.615 382.471L259.422 383.159L254.872 380.532C254.361 380.237 253.921 380.016 253.551 379.868C253.178 379.718 252.83 379.654 252.508 379.675C252.181 379.695 251.829 379.813 251.45 380.032C251.157 380.201 250.944 380.398 250.811 380.622C250.683 380.844 250.615 381.069 250.605 381.299C250.596 381.523 250.622 381.729 250.683 381.917L256.128 385.061L254.936 385.75ZM265.607 378.588C265.981 378.373 266.267 378.136 266.466 377.879C266.669 377.62 266.814 377.356 266.899 377.088L268.262 377.203C268.215 377.553 268.042 377.907 267.744 378.265C267.446 378.623 267.076 378.929 266.636 379.183C265.893 379.612 265.101 379.886 264.258 380.007C263.416 380.121 262.569 380.091 261.717 379.916C260.86 379.739 260.041 379.425 259.261 378.974C258.513 378.542 257.98 378.076 257.663 377.576C257.346 377.071 257.278 376.569 257.457 376.072C257.642 375.572 258.108 375.106 258.856 374.674C259.334 374.398 259.854 374.182 260.418 374.027C260.981 373.865 261.582 373.767 262.221 373.732L262.434 374.527C261.894 374.581 261.409 374.67 260.978 374.793C260.548 374.911 260.167 375.065 259.836 375.256C259.192 375.628 258.903 376.073 258.969 376.592C259.036 377.112 259.563 377.657 260.553 378.228C261.215 378.61 261.852 378.869 262.462 379.002C263.073 379.131 263.643 379.157 264.173 379.08C264.703 378.998 265.181 378.834 265.607 378.588ZM276.811 372.686C276.726 372.931 276.548 373.187 276.278 373.452C276.009 373.717 275.699 373.951 275.348 374.153C274.544 374.617 273.713 374.854 272.857 374.862C272 374.87 271.24 374.683 270.578 374.3L266.12 371.726L264.402 372.718L263.479 372.186L265.197 371.194L263.5 370.214L264.551 369.444L266.389 370.505L268.973 369.013L269.754 369.628L267.312 371.038L271.756 373.604C272.173 373.844 272.599 373.964 273.034 373.964C273.474 373.962 273.95 373.813 274.461 373.518C274.74 373.356 274.965 373.188 275.135 373.013C275.306 372.839 275.441 372.662 275.54 372.485L276.811 372.686ZM275.719 365.119L282.25 368.889L284.359 367.672L285.303 368.217L279.694 371.455L278.75 370.91L281.057 369.578L275.471 366.352L273.234 367.643L272.29 367.098L275.719 365.119ZM271.268 363.647C271.533 363.494 271.824 363.419 272.141 363.422C272.463 363.422 272.74 363.489 272.972 363.623C273.213 363.762 273.336 363.926 273.341 364.115C273.346 364.298 273.215 364.466 272.95 364.619C272.7 364.763 272.413 364.836 272.091 364.836C271.765 364.833 271.481 364.762 271.24 364.623C271.008 364.489 270.892 364.329 270.892 364.143C270.892 363.957 271.017 363.792 271.268 363.647ZM282.784 360.859C283.489 360.452 284.239 360.205 285.034 360.117C285.83 360.025 286.636 360.078 287.455 360.277C288.279 360.474 289.086 360.801 289.876 361.257C290.638 361.697 291.189 362.157 291.53 362.638C291.871 363.119 291.97 363.594 291.828 364.064C291.686 364.529 291.265 364.963 290.565 365.368C289.864 365.772 289.114 366.019 288.314 366.11C287.514 366.2 286.7 366.148 285.872 365.954C285.044 365.754 284.239 365.429 283.458 364.978C282.687 364.533 282.131 364.07 281.79 363.589C281.449 363.108 281.355 362.635 281.506 362.171C281.658 361.701 282.084 361.264 282.784 360.859ZM283.757 361.421C283.113 361.792 282.865 362.212 283.011 362.679C283.158 363.141 283.733 363.661 284.736 364.241C285.721 364.809 286.613 365.138 287.413 365.228C288.217 365.316 288.941 365.174 289.585 364.802C290.229 364.431 290.472 364.014 290.316 363.552C290.165 363.088 289.592 362.568 288.598 361.995C287.604 361.421 286.71 361.09 285.915 361.003C285.115 360.913 284.396 361.052 283.757 361.421ZM295.727 362.199L288.252 357.883L289.267 357.297L290.396 357.842C290.315 357.446 290.4 357.058 290.651 356.678C290.902 356.293 291.243 355.976 291.674 355.727C292.407 355.303 293.134 355.108 293.853 355.141C294.577 355.171 295.285 355.385 295.976 355.784L301.406 358.92L300.214 359.608L295.663 356.981C295.152 356.686 294.712 356.465 294.343 356.317C293.969 356.167 293.621 356.103 293.299 356.125C292.973 356.144 292.62 356.263 292.241 356.481C291.948 356.651 291.735 356.847 291.603 357.071C291.475 357.293 291.406 357.518 291.397 357.748C291.387 357.972 291.413 358.178 291.475 358.366L296.92 361.51L295.727 362.199ZM152.551 467.861L151.635 467.333L152.8 466.66L147.156 463.402L145.992 464.074L145.076 463.545L147.149 462.349L149.137 463.242C148.81 462.72 148.685 462.244 148.76 461.812C148.836 461.38 149.212 460.969 149.889 460.578C150.097 460.458 150.298 460.361 150.492 460.287C150.686 460.208 150.892 460.133 151.11 460.062L151.827 460.877C151.628 460.943 151.456 461.007 151.309 461.07C151.157 461.13 150.999 461.208 150.833 461.304C150.261 461.634 149.972 462.036 149.967 462.509C149.962 462.981 150.249 463.526 150.826 464.144L153.992 465.972L155.511 465.095L156.427 465.623L152.551 467.861ZM152.487 462.185L150.862 461.246L150.081 460.656L151.11 460.062L153.467 461.619L152.487 462.185ZM158.26 460.737C158.861 461.057 159.446 461.266 160.014 461.364C160.577 461.46 161.109 461.464 161.611 461.376C162.108 461.286 162.548 461.131 162.931 460.909C163.315 460.688 163.603 460.456 163.797 460.212C163.996 459.967 164.148 459.685 164.252 459.368L165.601 459.499C165.525 459.86 165.34 460.215 165.047 460.565C164.758 460.912 164.38 461.221 163.911 461.491C163.187 461.909 162.406 462.172 161.568 462.278C160.731 462.385 159.886 462.348 159.034 462.167C158.182 461.982 157.371 461.666 156.599 461.221C155.842 460.784 155.305 460.318 154.988 459.823C154.671 459.329 154.588 458.844 154.739 458.368C154.891 457.893 155.298 457.464 155.96 457.081C156.59 456.718 157.281 456.491 158.033 456.401C158.781 456.308 159.55 456.35 160.34 456.528C161.131 456.7 161.904 457.005 162.662 457.442C162.789 457.516 162.908 457.587 163.017 457.655C163.121 457.72 163.211 457.781 163.286 457.835L158.26 460.737ZM156.954 457.639C156.4 457.958 156.133 458.339 156.152 458.782C156.176 459.222 156.573 459.695 157.345 460.2L161.242 457.95C160.428 457.496 159.652 457.251 158.913 457.212C158.17 457.171 157.517 457.313 156.954 457.639ZM174.355 454.838C174.27 455.084 174.093 455.34 173.823 455.605C173.553 455.87 173.243 456.103 172.893 456.306C172.088 456.77 171.258 457.006 170.401 457.015C169.544 457.023 168.785 456.836 168.122 456.453L163.664 453.879L161.946 454.871L161.023 454.338L162.741 453.346L161.045 452.367L162.095 451.596L163.934 452.658L166.518 451.166L167.299 451.781L164.857 453.191L169.301 455.756C169.717 455.997 170.143 456.117 170.579 456.117C171.019 456.114 171.494 455.965 172.005 455.67C172.285 455.509 172.509 455.341 172.68 455.166C172.85 454.991 172.985 454.815 173.084 454.637L174.355 454.838ZM170.672 448.767L175.968 451.825C176.46 452.109 176.917 452.255 177.338 452.263C177.76 452.272 178.185 452.151 178.616 451.903C179.028 451.665 179.3 451.374 179.433 451.03C179.565 450.68 179.572 450.354 179.454 450.05L173.952 446.874L175.145 446.185L182.62 450.501L181.605 451.087L180.497 450.563C180.583 450.951 180.512 451.328 180.284 451.694C180.053 452.057 179.716 452.366 179.276 452.62C178.552 453.038 177.819 453.24 177.076 453.227C176.333 453.208 175.613 452.997 174.918 452.595L169.48 449.456L170.672 448.767ZM185.184 449.021L184.268 448.492L185.433 447.82L179.789 444.561L178.625 445.233L177.709 444.705L179.782 443.508L181.77 444.401C181.443 443.88 181.318 443.403 181.393 442.971C181.469 442.539 181.845 442.128 182.522 441.737C182.73 441.617 182.932 441.52 183.126 441.446C183.32 441.367 183.525 441.292 183.743 441.221L184.46 442.037C184.261 442.102 184.089 442.166 183.942 442.229C183.79 442.289 183.632 442.367 183.466 442.463C182.894 442.793 182.605 443.195 182.6 443.668C182.595 444.141 182.882 444.686 183.459 445.303L186.625 447.131L188.145 446.254L189.06 446.783L185.184 449.021ZM185.12 443.344L183.495 442.405L182.714 441.815L183.743 441.221L186.1 442.778L185.12 443.344ZM193.272 444.351L185.796 440.036L186.811 439.449L187.94 439.995C187.86 439.598 187.945 439.21 188.196 438.831C188.447 438.445 188.787 438.128 189.218 437.88C189.952 437.456 190.678 437.261 191.397 437.294C192.121 437.324 192.829 437.538 193.52 437.937L198.951 441.073L197.758 441.761L193.208 439.134C192.697 438.839 192.256 438.617 191.887 438.47C191.513 438.32 191.166 438.255 190.844 438.277C190.517 438.296 190.165 438.415 189.786 438.634C189.493 438.803 189.28 439 189.147 439.224C189.019 439.445 188.951 439.671 188.941 439.9C188.932 440.124 188.958 440.331 189.019 440.519L194.464 443.663L193.272 444.351ZM208.34 423.413L212.486 425.807C212.387 425.41 212.453 425.033 212.685 424.675C212.917 424.312 213.253 424.003 213.693 423.749C214.422 423.328 215.148 423.133 215.872 423.163C216.596 423.193 217.304 423.408 217.995 423.807L223.426 426.942L222.233 427.631L216.831 424.512C216.381 424.252 215.95 424.124 215.539 424.126C215.122 424.126 214.691 424.255 214.247 424.512C213.963 424.675 213.757 424.868 213.629 425.089C213.501 425.311 213.43 425.535 213.416 425.762C213.402 425.988 213.428 426.197 213.494 426.389L218.939 429.532L217.746 430.221L207.275 424.175L208.34 423.413ZM220.005 417.629L229.497 423.109L228.304 423.797L220.105 419.064L219.224 421.146L217.854 420.953L218.962 418.232L220.005 417.629ZM230.853 421.531L231.825 422.092L226.181 425.351L225.209 424.789L230.853 421.531ZM347.031 343.34L351.177 345.734C351.077 345.337 351.144 344.96 351.375 344.602C351.607 344.239 351.943 343.93 352.384 343.676C353.112 343.255 353.839 343.06 354.563 343.09C355.287 343.12 355.995 343.335 356.685 343.733L362.116 346.869L360.924 347.557L355.521 344.438C355.072 344.179 354.641 344.05 354.229 344.053C353.813 344.053 353.382 344.182 352.937 344.438C352.653 344.602 352.447 344.795 352.32 345.016C352.192 345.238 352.121 345.462 352.107 345.688C352.092 345.915 352.118 346.124 352.185 346.316L357.63 349.459L356.437 350.148L345.966 344.102L347.031 343.34ZM358.696 337.556L368.187 343.036L366.995 343.724L358.795 338.99L357.915 341.073L356.545 340.88L357.652 338.158L358.696 337.556ZM369.543 341.458L370.516 342.019L364.872 345.278L363.9 344.716L369.543 341.458Z"
                fill="#6FEC5B"
              />

              <path
                d="M314.28 348.61L310.411 350.844L312.122 352.733L310.908 353.434L304.313 345.954L305.889 345.044L318.844 348.852L317.552 349.598L314.28 348.61ZM309.708 350.069L312.938 348.204L306.109 346.114L309.708 350.069ZM315.914 341.732C316.577 341.349 317.265 341.137 317.98 341.096C318.699 341.053 319.44 341.15 320.202 341.387C320.959 341.622 321.728 341.965 322.509 342.416C323.262 342.851 323.827 343.3 324.206 343.765C324.584 344.224 324.729 344.673 324.639 345.113C324.549 345.553 324.18 345.96 323.531 346.334C322.713 346.807 321.766 347.02 320.692 346.974L324.255 349.031L323.212 349.806L312.727 343.752L313.742 343.166L314.885 343.711C314.776 343.332 314.807 342.972 314.977 342.633C315.152 342.292 315.465 341.991 315.914 341.732ZM316.589 342.449C316.177 342.687 315.938 342.969 315.872 343.297C315.805 343.62 315.822 343.927 315.921 344.22L319.627 346.359C320.11 346.414 320.583 346.405 321.047 346.334C321.51 346.258 321.92 346.117 322.275 345.912C322.895 345.554 323.124 345.149 322.963 344.695C322.802 344.241 322.223 343.726 321.224 343.15C320.571 342.773 319.968 342.495 319.414 342.318C318.855 342.137 318.344 342.058 317.881 342.08C317.412 342.099 316.981 342.222 316.589 342.449ZM324.072 337.022C324.735 336.639 325.424 336.427 326.138 336.386C326.858 336.343 327.598 336.44 328.36 336.677C329.117 336.912 329.886 337.255 330.667 337.706C331.42 338.14 331.985 338.59 332.364 339.054C332.743 339.513 332.887 339.963 332.797 340.403C332.707 340.843 332.338 341.25 331.69 341.624C330.871 342.097 329.924 342.31 328.85 342.264L332.414 344.321L331.37 345.096L320.885 339.042L321.9 338.456L323.043 339.001C322.934 338.621 322.965 338.262 323.135 337.923C323.31 337.582 323.623 337.281 324.072 337.022ZM324.747 337.739C324.335 337.976 324.096 338.259 324.03 338.587C323.964 338.91 323.98 339.217 324.079 339.509L327.785 341.649C328.268 341.703 328.741 341.695 329.205 341.624C329.669 341.548 330.078 341.407 330.433 341.202C331.053 340.844 331.283 340.438 331.122 339.985C330.961 339.531 330.381 339.016 329.382 338.44C328.729 338.063 328.126 337.785 327.572 337.608C327.014 337.427 326.503 337.348 326.039 337.37C325.57 337.389 325.14 337.512 324.747 337.739ZM333.139 334.861C334.124 335.429 335.087 335.857 336.029 336.144C336.975 336.428 337.969 336.611 339.01 336.693C340.051 336.775 341.209 336.792 342.482 336.746L342.51 337.484C341.114 337.563 339.812 337.571 338.606 337.508C337.403 337.443 336.251 337.261 335.148 336.963C334.05 336.663 332.964 336.202 331.89 335.582C330.811 334.959 330.011 334.331 329.49 333.697C328.975 333.06 328.66 332.395 328.546 331.701C328.437 331.004 328.454 330.254 328.596 329.451L329.874 329.467C329.817 330.024 329.817 330.541 329.874 331.016C329.931 331.486 330.075 331.933 330.307 332.356C330.534 332.777 330.877 333.194 331.336 333.606C331.795 334.014 332.396 334.432 333.139 334.861ZM343.782 328.716C343.039 328.287 342.313 327.941 341.603 327.679C340.893 327.411 340.174 327.212 339.445 327.081C338.711 326.947 337.935 326.865 337.116 326.835C336.298 326.799 335.405 326.798 334.44 326.831L334.412 326.093C335.808 326.008 337.107 325.999 338.309 326.064C339.511 326.13 340.661 326.313 341.759 326.613C342.862 326.911 343.953 327.372 345.032 327.995C346.106 328.615 346.901 329.243 347.417 329.88C347.938 330.514 348.255 331.178 348.368 331.872C348.482 332.566 348.468 333.317 348.326 334.126L347.048 334.11C347.128 333.375 347.097 332.707 346.955 332.106C346.814 331.504 346.494 330.932 345.997 330.388C345.505 329.842 344.767 329.284 343.782 328.716ZM354.114 314.791L355.051 315.332C354.706 315.532 354.427 315.734 354.214 315.939C354.001 316.138 353.899 316.331 353.908 316.517C353.923 316.7 354.086 316.868 354.398 317.021L357.607 318.529C358.047 318.734 358.352 318.938 358.523 319.14C358.693 319.342 358.745 319.547 358.679 319.755C358.617 319.96 358.454 320.174 358.189 320.398C358.577 320.24 358.949 320.14 359.304 320.099C359.654 320.055 360.002 320.084 360.347 320.185C360.688 320.283 361.048 320.466 361.426 320.734L364.039 322.587C364.308 322.77 364.602 322.865 364.919 322.874C365.236 322.882 365.57 322.823 365.92 322.697C366.27 322.572 366.618 322.409 366.963 322.21L367.901 322.751C367.503 322.98 367.087 323.18 366.651 323.349C366.22 323.521 365.783 323.64 365.338 323.706C364.893 323.771 364.455 323.762 364.025 323.677C363.599 323.595 363.192 323.415 362.803 323.136L360.39 321.415C360.101 321.204 359.796 321.063 359.474 320.992C359.157 320.919 358.781 320.942 358.345 321.062C357.91 321.177 357.375 321.417 356.741 321.783L355.79 321.234C356.424 320.868 356.843 320.561 357.046 320.312C357.254 320.061 357.295 319.843 357.167 319.66C357.044 319.475 356.802 319.3 356.443 319.136L353.447 317.734C352.964 317.51 352.652 317.275 352.51 317.029C352.363 316.78 352.344 316.529 352.453 316.275C352.567 316.018 352.773 315.765 353.071 315.517C353.369 315.263 353.717 315.021 354.114 314.791ZM206.436 427.013L207.927 427.209L205.989 431.878L214.103 430.775L214.337 431.648L205.57 432.816L204.349 432.111L206.436 427.013ZM226.027 415.702L234.858 414.497L236.079 415.202L234.063 420.259L232.537 420.124L234.453 415.444L226.353 416.554L226.027 415.702ZM246.899 413.389L242.264 410.713L238.572 412.844L243.208 415.521L241.98 416.23L232.205 410.586L233.433 409.877L237.564 412.262L241.256 410.131L237.124 407.746L238.352 407.037L248.128 412.68L246.899 413.389ZM248.001 408.925C248.602 409.245 249.187 409.454 249.755 409.552C250.318 409.648 250.85 409.652 251.352 409.564C251.849 409.474 252.289 409.319 252.672 409.097C253.056 408.876 253.344 408.644 253.538 408.4C253.737 408.155 253.889 407.873 253.993 407.556L255.342 407.687C255.266 408.048 255.081 408.403 254.788 408.753C254.499 409.1 254.121 409.409 253.652 409.679C252.928 410.097 252.147 410.36 251.309 410.466C250.472 410.573 249.627 410.536 248.775 410.355C247.923 410.17 247.112 409.854 246.34 409.409C245.583 408.972 245.046 408.506 244.729 408.011C244.412 407.517 244.329 407.032 244.48 406.556C244.632 406.081 245.039 405.652 245.701 405.269C246.331 404.906 247.022 404.679 247.774 404.589C248.522 404.496 249.291 404.538 250.081 404.716C250.872 404.888 251.645 405.193 252.403 405.63C252.53 405.704 252.649 405.775 252.758 405.843C252.862 405.908 252.952 405.969 253.027 406.023L248.001 408.925ZM246.695 405.827C246.141 406.146 245.874 406.527 245.893 406.97C245.917 407.41 246.314 407.883 247.086 408.388L250.983 406.138C250.169 405.684 249.393 405.439 248.654 405.4C247.911 405.359 247.258 405.501 246.695 405.827ZM250.963 398.936L259.603 403.924C259.972 404.137 260.348 404.223 260.731 404.182C261.115 404.136 261.489 404.007 261.853 403.797C262.08 403.666 262.272 403.528 262.428 403.383C262.584 403.238 262.724 403.084 262.847 402.92L264.039 403.239C263.935 403.414 263.77 403.611 263.543 403.83C263.325 404.048 263.027 404.267 262.648 404.485C261.985 404.868 261.266 405.073 260.49 405.1C259.709 405.125 258.994 404.95 258.346 404.576L250.715 400.17L248.422 401.493L247.478 400.948L250.963 398.936ZM259.121 394.226L267.761 399.214C268.13 399.427 268.506 399.513 268.89 399.472C269.273 399.425 269.647 399.297 270.011 399.087C270.238 398.955 270.43 398.818 270.586 398.673C270.742 398.528 270.882 398.373 271.005 398.21L272.198 398.529C272.094 398.704 271.928 398.901 271.701 399.119C271.483 399.338 271.185 399.557 270.806 399.775C270.144 400.158 269.424 400.363 268.648 400.39C267.867 400.415 267.153 400.24 266.504 399.865L258.873 395.459L256.58 396.783L255.636 396.238L259.121 394.226ZM270.07 391.2C270.775 390.793 271.525 390.546 272.32 390.458C273.115 390.365 273.922 390.419 274.741 390.618C275.564 390.815 276.371 391.141 277.161 391.598C277.923 392.038 278.475 392.498 278.816 392.979C279.156 393.46 279.256 393.935 279.114 394.405C278.972 394.87 278.55 395.304 277.85 395.709C277.15 396.113 276.399 396.36 275.6 396.45C274.8 396.541 273.986 396.489 273.158 396.295C272.329 396.095 271.525 395.77 270.744 395.319C269.973 394.874 269.416 394.411 269.076 393.93C268.735 393.449 268.64 392.976 268.792 392.512C268.943 392.042 269.369 391.604 270.07 391.2ZM271.042 391.762C270.398 392.133 270.15 392.553 270.297 393.02C270.443 393.482 271.018 394.002 272.022 394.581C273.006 395.15 273.898 395.479 274.698 395.569C275.503 395.657 276.227 395.515 276.87 395.143C277.514 394.771 277.758 394.355 277.602 393.893C277.45 393.428 276.877 392.909 275.884 392.335C274.89 391.762 273.995 391.431 273.2 391.344C272.4 391.253 271.681 391.393 271.042 391.762ZM288.424 378.128L296.708 384.632L295.089 385.567L286.592 381.956L292.839 386.866L291.185 387.821L280.033 382.972L281.268 382.259L290.731 386.518L284.618 381.636L286.131 380.763L294.529 384.325L287.281 378.788L288.424 378.128ZM294.544 377.07C295.25 376.662 296 376.415 296.795 376.328C297.59 376.235 298.397 376.288 299.216 376.488C300.039 376.684 300.846 377.011 301.636 377.467C302.398 377.907 302.95 378.367 303.29 378.848C303.631 379.329 303.73 379.805 303.588 380.275C303.447 380.739 303.025 381.174 302.325 381.578C301.624 381.982 300.874 382.23 300.074 382.32C299.275 382.41 298.461 382.358 297.632 382.164C296.804 381.965 296 381.639 295.219 381.189C294.447 380.743 293.891 380.28 293.551 379.799C293.21 379.318 293.115 378.846 293.267 378.381C293.418 377.911 293.844 377.474 294.544 377.07ZM295.517 377.631C294.873 378.003 294.625 378.422 294.772 378.889C294.918 379.351 295.493 379.872 296.497 380.451C297.481 381.019 298.373 381.348 299.173 381.439C299.977 381.526 300.702 381.384 301.345 381.012C301.989 380.641 302.233 380.224 302.076 379.762C301.925 379.298 301.352 378.779 300.358 378.205C299.365 377.631 298.47 377.3 297.675 377.213C296.875 377.123 296.156 377.262 295.517 377.631ZM307.558 378.368L306.643 377.839L307.807 377.167L302.163 373.909L300.999 374.581L300.083 374.052L302.156 372.855L304.144 373.749C303.817 373.227 303.692 372.75 303.768 372.318C303.843 371.887 304.219 371.475 304.896 371.085C305.104 370.964 305.306 370.867 305.5 370.794C305.694 370.714 305.9 370.639 306.117 370.568L306.834 371.384C306.636 371.449 306.463 371.514 306.316 371.576C306.165 371.637 306.006 371.714 305.84 371.81C305.268 372.141 304.979 372.542 304.974 373.015C304.97 373.488 305.256 374.033 305.833 374.65L308.999 376.478L310.519 375.601L311.434 376.13L307.558 378.368ZM307.494 372.691L305.869 371.753L305.088 371.163L306.117 370.568L308.474 372.126L307.494 372.691ZM308.071 365.965L316.711 370.953C317.08 371.166 317.456 371.252 317.839 371.211C318.223 371.164 318.596 371.036 318.961 370.826C319.188 370.694 319.38 370.556 319.536 370.412C319.692 370.267 319.832 370.112 319.955 369.948L321.147 370.268C321.043 370.443 320.878 370.64 320.65 370.858C320.433 371.077 320.135 371.296 319.756 371.514C319.093 371.897 318.374 372.102 317.598 372.129C316.817 372.153 316.102 371.979 315.454 371.604L307.823 367.198L305.53 368.522L304.585 367.977L308.071 365.965ZM317.642 360.267L318.984 359.664L329.469 365.718L328.425 366.32L327.325 365.816C327.443 366.207 327.413 366.561 327.233 366.878C327.058 367.192 326.764 367.468 326.352 367.706C325.704 368.08 325.006 368.294 324.258 368.349C323.511 368.404 322.744 368.322 321.958 368.103C321.168 367.882 320.387 367.549 319.616 367.103C318.868 366.671 318.316 366.219 317.961 365.746C317.602 365.271 317.472 364.811 317.571 364.365C317.67 363.914 318.028 363.511 318.643 363.156C319.074 362.908 319.528 362.733 320.006 362.632C320.479 362.528 320.986 362.487 321.525 362.509L317.642 360.267ZM319.914 363.529C319.289 363.89 319.052 364.308 319.204 364.783C319.355 365.259 319.926 365.782 320.915 366.353C321.558 366.725 322.166 366.997 322.739 367.169C323.312 367.341 323.839 367.413 324.322 367.386C324.81 367.356 325.247 367.229 325.635 367.005C326.061 366.759 326.303 366.48 326.36 366.169C326.421 365.854 326.4 365.552 326.296 365.263L322.562 363.107C322.055 363.05 321.575 363.056 321.121 363.127C320.661 363.196 320.259 363.33 319.914 363.529ZM325.651 356.634L332.083 360.487L331.011 361.106L324.317 357.405L325.651 356.634ZM333.041 361.647C333.316 361.489 333.635 361.411 334 361.413C334.369 361.413 334.683 361.489 334.944 361.639C335.209 361.792 335.344 361.976 335.348 362.192C335.353 362.403 335.218 362.587 334.944 362.745C334.674 362.901 334.357 362.978 333.993 362.975C333.623 362.969 333.306 362.89 333.041 362.737C332.781 362.587 332.648 362.407 332.644 362.196C332.639 361.986 332.771 361.803 333.041 361.647ZM336.608 351.858L338.099 352.054L336.161 356.723L347.264 355.206L347.498 356.079L335.742 357.661L334.521 356.956L336.608 351.858ZM348.939 356.911L347.54 357.219L340.761 345.927L342.181 345.648L348.939 356.911ZM364.718 335.629L373.549 334.424L374.77 335.129L372.754 340.186L371.227 340.051L373.144 335.371L365.044 336.481L364.718 335.629ZM144.901 481.58C145.299 481.351 145.715 481.151 146.151 480.982C146.581 480.81 147.019 480.691 147.464 480.625C147.909 480.56 148.347 480.569 148.777 480.654C149.208 480.733 149.615 480.914 149.998 481.195L152.426 482.925C152.71 483.132 153.023 483.266 153.363 483.326C153.709 483.384 154.099 483.352 154.535 483.232C154.97 483.112 155.479 482.884 156.061 482.548L157.012 483.097C156.435 483.43 156.042 483.725 155.834 483.982C155.625 484.234 155.571 484.459 155.67 484.658C155.775 484.855 156.009 485.037 156.373 485.204L159.355 486.597C159.838 486.821 160.15 487.056 160.292 487.302C160.439 487.551 160.455 487.803 160.342 488.06C160.233 488.314 160.027 488.567 159.724 488.819C159.431 489.07 159.085 489.31 158.688 489.54L157.75 488.999C158.096 488.799 158.375 488.6 158.588 488.401C158.806 488.198 158.91 488.004 158.9 487.819C158.891 487.633 158.725 487.463 158.404 487.31L155.195 485.802C154.731 485.583 154.416 485.374 154.251 485.175C154.08 484.973 154.042 484.765 154.137 484.552C154.236 484.336 154.452 484.102 154.783 483.851C154.352 484.029 153.943 484.142 153.555 484.191C153.172 484.238 152.802 484.213 152.448 484.117C152.093 484.022 151.735 483.848 151.376 483.597L148.763 481.744C148.503 481.561 148.212 481.467 147.89 481.462C147.568 481.456 147.235 481.515 146.889 481.638C146.539 481.758 146.189 481.919 145.838 482.121L144.901 481.58Z"
                fill="#E1E1E1"
              />
            </g>

            <g className={styles.movement}>
              <g className={styles.fadeIn}>
                <rect
                  fill="#ECECEC"
                  fillOpacity="0.04"
                  height="26.1539"
                  transform="matrix(0.866025 -0.5 0.866025 0.5 77.2754 470.338)"
                  width="450.045"
                />
              </g>
            </g>
            <g opacity="0.3">
              <path
                d="M130.844 390.424C129.523 390.048 128.112 390.1 126.737 390.894C125.272 391.74 125.018 392.847 126.194 393.526C127.153 394.079 128.365 394.121 129.939 393.557L131.368 393.045C132.232 392.735 132.897 392.737 133.377 393.014C133.974 393.359 133.829 394.006 132.834 394.581C131.961 395.085 131.038 395.184 130.102 394.863L129.342 395.594C130.771 396.132 132.373 395.933 133.793 395.114C135.407 394.181 135.624 393.038 134.426 392.346C133.458 391.787 132.241 391.784 130.699 392.325L129.415 392.774C128.388 393.132 127.741 393.186 127.207 392.878C126.61 392.534 126.809 391.917 127.66 391.426C128.591 390.889 129.491 390.964 130.156 391.134L130.844 390.424ZM133.724 386.964L132.241 387.821L130.576 386.86L129.509 387.476L131.173 388.437L130.124 389.043L131.029 389.565L132.078 388.959L136.42 391.466C137.632 392.166 139.188 391.936 140.092 391.414C140.49 391.184 140.671 390.996 140.762 390.881L139.586 390.453C139.513 390.516 139.405 390.62 139.17 390.756C138.699 391.027 138.102 391.205 137.198 390.683L133.145 388.343L134.629 387.487L133.724 386.964ZM145.251 391.339C146.214 390.783 146.382 390.096 145.703 389.24L140.719 382.947L139.534 383.61L143.152 387.913L143.08 387.955L135.626 385.866L134.469 386.534L144.021 389.083L144.364 389.511C145.034 390.347 144.654 390.681 143.677 391.015L144.346 391.715C144.509 391.684 144.889 391.548 145.251 391.339ZM140.547 380.351L139.479 380.968L148.742 386.316L149.809 385.699L140.547 380.351ZM154.503 383.156C155.914 382.342 156.24 381.339 155.516 380.545L154.196 380.973C154.648 381.548 154.381 382.12 153.544 382.603C152.292 383.326 150.618 383.357 149.08 382.527L154.123 379.615L153.671 379.354C151.084 377.861 148.66 378.237 147.212 379.072C145.331 380.159 145.566 381.736 147.701 382.968C149.836 384.201 152.495 384.316 154.503 383.156ZM148.158 381.994C147.149 381.328 146.95 380.331 148.171 379.626C149.329 378.957 150.939 379.031 152.115 379.709L148.158 381.994ZM158.07 374.705C156.749 374.329 155.338 374.381 153.963 375.175C152.498 376.021 152.245 377.128 153.42 377.807C154.379 378.361 155.591 378.402 157.165 377.838L158.595 377.326C159.458 377.016 160.123 377.018 160.603 377.295C161.2 377.64 161.055 378.287 160.06 378.862C159.187 379.366 158.264 379.465 157.328 379.144L156.568 379.875C157.998 380.413 159.599 380.214 161.019 379.395C162.633 378.462 162.85 377.319 161.652 376.627C160.684 376.068 159.467 376.065 157.925 376.606L156.641 377.055C155.614 377.413 154.967 377.467 154.434 377.159C153.837 376.815 154.036 376.198 154.886 375.707C155.818 375.17 156.718 375.245 157.382 375.415L158.07 374.705ZM165.726 376.593C166.174 376.335 166.174 375.912 165.726 375.653C165.279 375.395 164.546 375.395 164.098 375.653C163.65 375.912 163.65 376.335 164.098 376.593C164.546 376.852 165.279 376.852 165.726 376.593ZM171.032 373.613C172.57 372.726 172.642 371.598 171.593 370.783L170.525 371.399C171.086 371.953 170.905 372.579 170.073 373.06C168.807 373.791 166.943 373.655 165.333 372.726C163.759 371.817 163.56 370.741 164.809 370.02C165.749 369.477 166.889 369.488 167.685 369.759L168.752 369.143C167.269 368.495 165.297 368.631 163.832 369.477C161.95 370.563 162.185 372.141 164.302 373.363C166.383 374.564 169.078 374.741 171.032 373.613ZM174.391 365.282C173.07 364.906 171.659 364.958 170.284 365.752C168.819 366.598 168.565 367.705 169.741 368.384C170.7 368.938 171.912 368.98 173.486 368.415L174.915 367.904C175.779 367.593 176.444 367.596 176.923 367.872C177.52 368.217 177.376 368.865 176.381 369.439C175.508 369.943 174.585 370.042 173.649 369.721L172.889 370.452C174.318 370.99 175.919 370.792 177.339 369.972C178.954 369.04 179.171 367.896 177.973 367.204C177.005 366.645 175.788 366.642 174.246 367.183L172.961 367.632C171.935 367.99 171.288 368.045 170.754 367.737C170.157 367.392 170.356 366.776 171.207 366.285C172.138 365.747 173.038 365.823 173.703 365.992L174.391 365.282ZM180.726 361.624C179.406 361.248 177.995 361.3 176.62 362.094C175.154 362.94 174.901 364.047 176.077 364.726C177.036 365.28 178.248 365.322 179.822 364.758L181.251 364.246C182.115 363.935 182.78 363.938 183.259 364.214C183.856 364.559 183.711 365.207 182.716 365.781C181.843 366.285 180.921 366.384 179.985 366.063L179.225 366.794C180.654 367.332 182.255 367.134 183.675 366.314C185.29 365.382 185.507 364.238 184.308 363.546C183.341 362.987 182.124 362.985 180.582 363.525L179.297 363.974C178.27 364.332 177.624 364.387 177.09 364.079C176.493 363.734 176.692 363.118 177.542 362.627C178.474 362.089 179.374 362.165 180.039 362.334L180.726 361.624Z"
                fill="white"
              />
            </g>

            <g className={styles.movement}>
              <g className={styles.fadeIn}>
                <rect
                  fill="#6FEC5B"
                  height="30.3321"
                  rx="15.1661"
                  transform="matrix(0.866025 -0.5 0.866025 0.5 41 426.246)"
                  width="66.1792"
                />
              </g>
              <path
                d="M72.6767 428.312L71.1966 426.516L74.4734 424.624L77.5839 425.479L78.6129 424.885L67.532 421.923L66.5189 422.508L71.6478 428.906L72.6767 428.312ZM70.6347 425.835L68.276 422.974L68.3393 422.938L73.2941 424.3L70.6347 425.835ZM81.7495 425.706L82.6835 425.166L79.47 423.311L79.5492 423.265C80.0874 423.339 81.2113 423.531 82.3827 422.854C83.9024 421.977 83.7441 420.661 81.8128 419.546C79.8974 418.44 77.618 418.349 76.0825 419.235C74.8952 419.92 75.2593 420.551 75.3701 420.853L75.2593 420.917L74.2937 420.359L73.3914 420.88L81.7495 425.706ZM77.3489 422.105C75.9875 421.319 75.6709 420.441 76.8106 419.783C77.9979 419.098 79.5808 419.336 80.8631 420.076C82.1611 420.825 82.5885 421.767 81.4171 422.443C80.2932 423.092 78.726 422.9 77.3489 422.105ZM88.2619 421.946L89.1959 421.407L85.9824 419.551L86.0616 419.506C86.5998 419.579 87.7237 419.771 88.8951 419.094C90.4147 418.217 90.2564 416.901 88.3252 415.786C86.4098 414.68 84.1303 414.589 82.5948 415.475C81.4076 416.161 81.7717 416.791 81.8825 417.093L81.7717 417.157L80.8061 416.599L79.9038 417.12L88.2619 421.946ZM83.8612 418.345C82.4999 417.559 82.1833 416.682 83.323 416.023C84.5102 415.338 86.0932 415.576 87.3754 416.316C88.6735 417.065 89.1009 418.007 87.9295 418.683C86.8056 419.332 85.2384 419.14 83.8612 418.345ZM93.2388 416.513C93.6306 416.287 93.6306 415.917 93.2388 415.691C92.847 415.465 92.2059 415.465 91.8141 415.691C91.4223 415.917 91.4223 416.287 91.8141 416.513C92.2059 416.74 92.847 416.74 93.2388 416.513ZM89.2065 411.749L95.7284 415.515C96.3458 415.871 96.4407 416.218 95.8709 416.547L95.6967 416.648L96.5674 417.151L96.7573 417.041C97.9287 416.365 97.7863 415.624 96.6624 414.975L90.1405 411.21L89.2065 411.749ZM88.6525 410.899C89.0166 410.689 89.0324 410.351 88.6842 410.15C88.3359 409.949 87.7502 409.958 87.3861 410.168C87.022 410.378 87.0062 410.716 87.3545 410.918C87.7027 411.119 88.2884 411.109 88.6525 410.899ZM97.2396 408.683C96.084 408.354 94.8493 408.4 93.6462 409.095C92.364 409.835 92.1424 410.804 93.1713 411.398C94.0103 411.882 95.0709 411.919 96.4481 411.425L97.6986 410.977C98.4545 410.705 99.0362 410.708 99.4557 410.95C99.9781 411.251 99.8515 411.818 98.9808 412.321C98.217 412.762 97.4097 412.849 96.5905 412.568L95.9257 413.207C97.1762 413.678 98.5772 413.504 99.8198 412.787C101.233 411.971 101.423 410.97 100.374 410.365C99.527 409.876 98.4624 409.874 97.1129 410.347L95.989 410.74C95.0907 411.053 94.5247 411.101 94.0578 410.831C93.5354 410.529 93.7095 409.99 94.4535 409.561C95.2687 409.09 96.0563 409.156 96.638 409.305L97.2396 408.683Z"
                fill="#131313"
              />
            </g>
          </g>
          <g className={styles.compiler} clipPath="url(#clip2_831_3535)">
            <rect
              fill="#1E1E1E"
              height="407.697"
              rx="10"
              transform="matrix(0.866025 -0.5 0.866025 0.5 1 326)"
              width="447.874"
            />
            <g className={styles.lines} clipPath="url(#clip3_831_3535)">
              <path
                d="M122.646 267.605L136.907 275.839L215.338 275.839L222.865 280.184"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M78.2812 225.068L106.802 241.534L106.802 281.328L118.685 288.189L163.843 288.189L198.305 308.086L211.773 308.086"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M198.305 285.217L214.942 294.822"
                opacity="0.3"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M126.211 249.082L155.524 266.006"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M202.266 262.347H179.291L87.3917 209.288L87.3917 201.512"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M138.095 173.611L138.095 204.714L172.161 224.382"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M97.2949 196.709L181.668 245.422H205.435L238.313 264.404"
                opacity="0.3"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M155.524 168.121L155.524 181.843L265.645 245.422"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M162.654 200.598L254.554 253.656"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M165.427 153.713L180.084 162.175L180.084 180.928L261.288 227.812"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M176.122 148.454L210.981 168.58L210.981 185.503L294.958 233.988"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M228.806 160.117L186.421 135.646"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M232.372 180.473L268.022 201.056"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M270.003 177.499L289.412 188.705L289.412 211.118L320.31 228.956"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M341.7 222.095L308.03 202.655L308.03 161.947"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M277.529 163.09H259.307L199.097 128.328"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M217.715 122.611L264.061 149.369H313.972"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M278.717 140.908L333.382 140.908L356.357 154.172L356.357 216.378L369.429 223.926"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M332.589 204.028L332.589 173.382"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M238.313 114.378L267.23 131.073H349.623L373.39 144.795L373.39 213.405L392.404 224.383"
                opacity="0.3"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M85.411 250.225L85.411 287.732L120.666 308.086H179.291L207.812 324.553"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M85.0151 306.256L118.289 325.467L182.46 325.467"
                opacity="0.3"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M60.8517 263.491L60.8517 214.091"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M60.4554 283.388L60.4554 315.405L100.067 338.275H214.942"
                opacity="0.7"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M253.366 105.23L278.321 119.638H344.869L397.949 150.284L397.949 204.714L422.113 218.665L422.113 228.27"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M290.205 107.289H380.52L410.625 124.67L410.625 149.369L422.905 156.459L422.905 200.369L450.237 216.15L450.237 234.446"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M271.983 94.9375L411.417 94.9375L436.769 109.574L509.655 109.574L535.799 94.4801"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M405.08 105.001L428.054 118.265L428.054 145.252"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M366.26 117.352L392.404 132.446"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M449.049 128.556L449.049 197.166"
                opacity="0.3"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M469.251 120.095L469.251 156.229"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M476.777 245.194L476.777 175.212L493.414 165.606L493.414 132.674L558.377 95.1668H643.147"
                opacity="0.7"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M438.354 100.428H493.018"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M289.808 83.7318H365.863L396.761 65.8932L396.761 53.5434L418.943 40.7362L418.943 5.97391"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M471.627 -20.3271L471.627 39.5922L451.029 51.4846L451.029 81.673L458.555 86.0182L613.834 86.0182"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M511.24 23.5848L511.24 55.6027L551.644 78.9301L706.13 78.9301"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M500.94 231.701L500.94 172.239L520.746 160.804L520.746 138.849L569.865 110.49H672.064L702.565 92.8801"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M555.604 152.57H655.427"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M584.125 143.881H671.272"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M538.175 140.221L551.247 132.674L689.889 132.674L725.144 112.319L725.144 89.9068"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M575.411 123.754H683.947L703.753 112.319"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M691.078 160.346L691.078 192.364L640.374 221.637H612.646"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M645.92 204.715L680.382 184.818"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M581.352 229.185L671.667 177.041L671.667 158.745L745.742 115.978L745.742 102.714"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M620.172 172.467H646.316"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M630.075 162.175H543.721L516.389 177.956L516.389 196.251"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M554.812 173.154L554.812 217.979"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M576.599 182.988L576.599 203.114"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M601.158 233.301H644.731L695.435 204.027"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M746.138 127.642L708.507 149.369L708.507 210.203L650.277 243.822H584.521"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M504.505 261.66L608.289 201.741L608.289 185.274L584.918 171.781"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M535.006 211.117L535.006 231.7L505.694 248.624"
                opacity="0.3"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M524.708 264.633L554.813 247.252"
                opacity="0.7"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M518.37 275.611H530.253L555.209 261.203H688.305L701.377 253.656"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M595.216 252.284L682.363 252.284L723.163 228.728L723.163 157.831"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M676.025 243.135L707.318 225.068"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M762.775 138.62L762.775 154.629L739.008 168.351L739.008 229.643L718.806 241.306L718.806 254.114L685.136 273.553H605.912"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M778.224 121.01L778.224 163.091L752.08 178.185L752.08 228.041L733.066 239.019L733.066 263.718L715.241 274.01"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M769.905 183.446L769.905 221.41"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M751.684 242.449L751.684 262.117"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M793.276 137.933L793.276 228.041L772.282 240.162L772.282 267.149L782.185 272.866H934.295"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M837.642 264.175L816.251 251.825L816.251 132.444"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M549.267 274.695H569.865L584.917 283.386H735.443L760.794 298.023H828.135L860.22 279.498"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M528.668 289.332L570.657 289.332L600.762 306.713L670.479 306.713L723.559 337.359L723.559 390.875L735.047 397.507"
                opacity="0.7"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M691.474 304.199L714.449 317.464"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M616.211 294.135L704.149 294.135L733.462 311.059L733.462 337.588L747.326 345.593L747.326 383.557L756.041 388.588"
                opacity="0.3"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M772.678 317.235L772.678 378.984"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M749.703 333.244L749.703 304.885L728.313 292.535"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M533.818 306.027L587.691 337.13L636.017 337.13"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M604.723 327.754H654.634L678.402 341.476L678.402 400.023L707.318 416.718"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M715.241 408.029L699 398.652L699 333.701L674.44 319.522L591.255 319.522L558.774 300.769"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M534.61 321.123L584.125 349.71L601.555 349.71"
                opacity="0.7"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M630.075 347.88L630.075 389.503L693.058 425.866"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M657.011 389.961L657.011 361.145"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M594.82 364.118L613.042 374.638L613.042 396.136L683.551 436.845"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M533.026 336.674L556.397 350.167"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M555.208 365.947L590.463 386.302"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M521.935 348.565L531.045 353.826L531.045 370.749L621.361 422.893H634.829L679.194 448.507"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M507.278 368.92L596.801 420.606"
                opacity="0.7"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M493.81 378.068L609.873 445.077L647.9 445.077"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M482.719 385.844L592.444 449.194"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M465.686 392.934L495.394 410.086"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M447.86 399.109L507.674 433.643L529.065 433.643L581.749 464.06L638.79 464.06"
                opacity="0.7"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M424.489 405.283L500.94 449.422L527.876 449.422"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M450.237 435.242L481.53 453.309"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M446.276 455.369L456.971 461.544H540.948L573.034 480.069H594.424"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M518.766 471.148L543.721 485.557"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M413.794 418.777L429.243 427.696L429.243 468.404L441.919 475.723H487.868L521.935 495.391H570.261"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M386.858 408.714L386.858 448.965"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M409.833 436.158L409.833 475.494L443.107 494.705H504.109L528.669 508.884H541.344"
                opacity="0.7"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M363.487 409.399L363.487 509.112L386.066 522.148"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M383.293 470.692L383.293 503.167L420.528 524.665H534.61"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M409.041 493.791L439.542 511.401L506.09 511.401"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M343.681 407.57L343.681 486.7L322.687 498.821L322.687 527.18L332.194 532.669H488.264"
                opacity="0.3"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M346.85 499.965L346.85 523.75"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M318.725 445.764L318.725 484.185"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M297.335 505.226L297.335 522.149"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M325.063 403.682L325.063 427.925L303.277 440.503L303.277 489.445L279.113 503.395L279.113 524.436L256.931 537.243"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M407.456 543.19L382.897 557.369L309.218 557.369L284.659 543.19L138.887 543.19L125.815 535.643L99.6714 535.643"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M309.615 402.081L309.615 414.431L289.413 426.095L289.413 488.301L266.438 501.566L266.438 512.543L231.579 532.669H162.654"
                opacity="0.7"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M479.55 545.018L426.47 545.018L366.656 579.552L366.656 610.198"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M163.05 554.395L250.989 554.395L280.302 571.319L280.302 593.274L298.127 603.566L298.127 654.794"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M42.2344 548.678L123.043 548.678L150.771 564.687L218.111 564.687L273.568 596.705L273.568 650.22L294.958 662.57"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M270.003 418.091L270.003 489.445L228.807 513.23L145.622 513.23"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M250.593 512.544L232.371 523.064H100.86L79.0731 535.643H56.0981"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M77.8848 522.605L106.405 506.139"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M131.757 503.397H199.098L257.327 469.778L257.327 411.231L286.64 394.307"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M270.003 386.987L216.527 417.862L216.527 438.445L130.173 488.301"
                opacity="0.7"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M242.274 421.292L242.274 453.768L192.759 482.355L160.278 482.355"
                opacity="0.3"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M198.305 464.518L228.014 447.365"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M225.637 503.167L256.139 485.557M170.577 436.158L199.097 436.158"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M136.51 432.956L155.128 443.705L155.128 461.086L29.9543 533.355"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M127.796 442.561L127.796 466.346"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M132.945 402.996H224.845"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M252.574 385.616L237.125 394.535H98.4833L86.2036 401.625M125.419 383.558H230.787L245.047 375.325"
                opacity="0.3"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M236.729 362.746L222.468 370.979H120.27L69.9625 400.024L69.9625 423.351L48.9682 435.472L48.9682 493.562"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M55.7022 507.97L84.6189 491.275L84.6189 472.979"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M103.633 477.095L103.633 429.983"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M68.378 459.943L68.378 441.647L101.256 422.665L179.687 422.665"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M102.444 412.373H206.228"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M10.1487 528.781L27.578 518.718L27.578 434.557L43.4227 425.409L43.4227 394.305L110.367 355.655H197.513"
                opacity="0.3"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M218.111 347.423H10.5447L-0.942759 340.79L-0.942757 313.346L21.2399 300.539L21.2399 227.813"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M42.2342 228.956L42.2342 324.552L64.0208 337.131"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M22.0323 338.961L22.0323 315.176"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M-57.1917 349.481L-44.5159 342.163L-44.5159 315.634L-22.3332 302.826L-22.3332 259.831"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M-0.94266 257.544L-0.942662 294.593"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M-10.8457 360.23H43.0265"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M89.3724 354.054L60.4557 370.749H-10.0536L-37.3858 354.969H-194.249"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M-157.41 342.849H-82.9393L-58.3799 328.67L-58.3799 315.862L-36.9895 303.513L-36.9895 255.486"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M-46.8929 363.66L-21.5412 378.297L-21.5412 408.028"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M0.245407 389.046L0.245403 459.028"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M20.4477 380.583L20.4477 416.718"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M-29.0673 476.867L-48.0811 465.889L-48.0811 410.086L-103.538 378.068L-170.878 378.068L-210.886 354.97"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M-161.767 368.235L-71.4523 368.235L-38.9705 386.989L-38.9705 411.231L-27.8792 417.634L-27.8792 461.545L-1.33921 476.867L-1.33921 519.406L-24.7102 532.899"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
              <path
                d="M-26.6904 514.831L-26.6904 503.396L-76.9976 474.351L-76.9976 406.656L-99.9725 393.392H-187.911L-231.484 368.235"
                stroke="#6FEC5B"
                strokeLinecap="round"
                strokeOpacity="0.2"
              />
            </g>
            <circle
              className={styles.circle}
              r="116.706"
              stroke="#6FEC5B"
              strokeOpacity="0.2"
              transform="matrix(0.866025 -0.5 0.866025 0.5 372.069 316.031)"
            />
            <g className={styles.logo}>
              <g className={styles.logoLeft}>
                <rect
                  height="68"
                  stroke="white"
                  strokeWidth="7"
                  transform="matrix(0.866025, -0.5, 0.866025, 0.5, 297.993, 314.031)"
                  width="34"
                  x="6.06218"
                />
              </g>
              <g className={styles.logoRight}>
                <rect
                  height="68"
                  stroke="white"
                  strokeWidth="7"
                  transform="matrix(0.866025, -0.5, 0.866025, 0.5, 344.758, 307.031)"
                  width="34"
                  x="6.06218"
                />
              </g>
            </g>
          </g>
          <g className={styles.preview}>
            <rect
              fill="#FCFCFC"
              height="408"
              rx="10"
              transform="matrix(0.866025 -0.5 0.866025 0.5 0 224)"
              width="448"
            />
            <rect
              height="407"
              rx="9.5"
              stroke="black"
              strokeOpacity="0.09"
              transform="matrix(0.866025 -0.5 0.866025 0.5 0.116025 224.433)"
              width="447"
              x="0.866025"
            />

            <g className={styles.movement}>
              <g clipPath="url(#clip6_831_3535)">
                <rect
                  fill="#EAEAEA"
                  height="30"
                  rx="6"
                  transform="matrix(0.866025 -0.5 0.866025 0.5 667.641 203.625)"
                  width="30"
                />
                <g clipPath="url(#clip7_831_3535)">
                  <path
                    clipRule="evenodd"
                    d="M685.326 199.318L682.489 204.871C682.359 205.125 682.48 205.4 682.805 205.588L690.124 209.814C690.44 209.996 690.9 210.068 691.331 210.002L701.185 208.5C701.618 208.434 701.957 208.24 702.075 207.99L704.739 202.346C704.857 202.095 704.734 201.828 704.416 201.644L697.088 197.413C696.771 197.23 696.308 197.159 695.874 197.226L686.421 198.7C685.895 198.782 685.48 199.016 685.326 199.318ZM690.598 209.064L684.113 205.32C683.858 205.173 683.752 204.957 683.846 204.756L686.201 199.857C686.256 199.754 686.423 199.626 686.556 199.55C686.689 199.473 686.928 199.373 687.089 199.344L695.529 198.011C695.698 197.986 695.988 197.986 696.151 198.011C696.32 198.036 696.423 198.065 696.551 198.139L703.036 201.884C703.291 202.031 703.397 202.196 703.303 202.397L700.904 207.475C700.857 207.574 700.804 207.635 700.682 207.705C700.56 207.776 700.409 207.832 700.238 207.859L691.62 209.193C691.272 209.247 690.853 209.212 690.598 209.064ZM686.201 205.602L688.733 207.064C688.91 207.167 689.044 207.192 689.31 207.141L692.242 206.679C692.509 206.628 692.686 206.679 692.82 206.756L694.596 207.782C694.774 207.885 694.907 207.91 695.174 207.859L698.106 207.397C698.372 207.346 698.461 207.244 698.283 207.141L693.53 204.397C693.397 204.32 693.219 204.268 692.953 204.32L686.378 205.346C686.156 205.371 686.023 205.5 686.201 205.602ZM690.465 199.652L689.754 201.14C689.71 201.268 689.532 201.37 689.31 201.396L686.734 201.806C686.564 201.834 686.426 201.914 686.378 202.012L685.49 203.858C685.401 204.012 685.579 204.115 685.845 204.063L692.286 203.063C692.458 203.036 692.595 202.957 692.642 202.858L694.374 199.139C694.419 199.011 694.285 198.883 694.019 198.934L690.821 199.447C690.651 199.474 690.512 199.554 690.465 199.652ZM700.815 204.192C700.993 204.294 701.015 204.384 700.948 204.525L700.149 206.218C700.104 206.346 699.882 206.423 699.705 206.32L694.951 203.576C694.824 203.503 694.771 203.343 694.818 203.243L696.64 199.37C696.69 199.262 696.903 199.266 697.039 199.345L699.571 200.806C699.703 200.882 699.759 200.986 699.705 201.089L698.816 202.781C698.762 202.884 698.774 203.013 698.905 203.089L700.815 204.192Z"
                    fill="#8E8E8E"
                    fillRule="evenodd"
                  />
                </g>
              </g>
            </g>

            <g className={styles.movement}>
              <g clipPath="url(#clip8_831_3535)">
                <rect
                  fill="#EAEAEA"
                  height="30"
                  rx="6"
                  transform="matrix(0.866025 -0.5 0.866025 0.5 633 223.625)"
                  width="30"
                />
                <path
                  clipRule="evenodd"
                  d="M663.603 221.814C665.267 223.166 665.102 225.02 663.07 226.193C660.794 227.507 657.038 227.469 654.681 226.108C652.324 224.747 652.258 222.578 654.534 221.264C656.168 220.321 658.564 220.074 660.658 220.514L659.096 221.416L660.21 222.059L662.119 220.956L662.36 220.817L663.026 220.433L663.435 220.196L659.723 218.054L658.648 218.674L660.424 219.7C658.037 219.335 655.431 219.675 653.606 220.728C650.835 222.328 650.915 224.968 653.785 226.625C656.655 228.282 661.227 228.328 663.998 226.728C666.526 225.269 666.681 222.944 664.51 221.29L663.603 221.814Z"
                  fill="#8E8E8E"
                  fillRule="evenodd"
                />
              </g>
            </g>
            <path
              className={styles.movement}
              d="M80.1994 243.771L85.676 240.609L72.8333 233.194L86.8422 225.106L99.685 232.521L105.176 229.35L74.9442 211.896L69.4528 215.066L82.2513 222.455L68.2424 230.543L55.4439 223.154L49.9673 226.316L80.1994 243.771ZM119.299 221.708C124.584 218.657 125.632 215.069 122.635 212.248L117.085 214.804C118.28 216.33 117.513 217.932 115.21 219.262C111.756 221.256 107.194 221.265 103.268 219.049L119.063 209.929L117.424 208.983C109.468 204.39 101.186 205.131 95.6063 208.353C89.1111 212.103 89.6425 217.302 96.6396 221.341C103.755 225.449 112.464 225.654 119.299 221.708ZM99.6806 216.961C96.9496 215.196 96.6544 212.554 99.8429 210.713C102.913 208.941 107.224 209.043 110.339 210.807L99.6806 216.961ZM106.492 193.681L101.149 196.766L131.381 214.221L136.725 211.136L106.492 193.681ZM115.253 188.623L109.909 191.709L140.141 209.163L145.485 206.078L115.253 188.623ZM159.235 198.651C165.878 194.816 165.42 189.676 158.408 185.628C151.382 181.571 142.465 181.299 135.823 185.134C129.18 188.969 129.652 194.117 136.679 198.174C143.691 202.222 152.592 202.486 159.235 198.651ZM154.983 196.162C151.308 198.284 146.23 197.432 142.082 195.037C137.934 192.642 136.413 189.685 140.089 187.563C143.705 185.475 148.828 186.353 152.976 188.747C157.124 191.142 158.6 194.074 154.983 196.162ZM186.945 182.141L192.348 179.022L177.202 163.272L177.438 163.135L204.703 171.888L210.106 168.769L188.406 146.388L182.516 149.789L199.301 165.769L199.035 165.922L170.973 156.454L165.614 159.547L182.014 175.732L181.734 175.894L154.07 166.212L148.18 169.613L186.945 182.141ZM228.141 158.868C234.783 155.033 234.326 149.894 227.314 145.845C220.287 141.788 211.371 141.516 204.728 145.351C198.086 149.186 198.558 154.334 205.585 158.391C212.597 162.439 221.498 162.703 228.141 158.868ZM223.889 156.379C220.214 158.502 215.136 157.649 210.987 155.254C206.839 152.86 205.319 149.902 208.995 147.78C212.611 145.692 217.734 146.57 221.882 148.965C226.03 151.36 227.506 154.291 223.889 156.379ZM241.02 150.921L246.363 147.836L233.033 140.14C230.155 138.478 230.288 136.049 233.225 134.353C234.126 133.833 235.41 133.279 236.015 133.1L231.1 130.262C230.524 130.492 229.624 130.944 229.033 131.285C226.435 132.785 225.741 134.89 227.542 136.884L227.306 137.02L223.527 134.839L218.345 137.83L241.02 150.921ZM230.534 122.066L225.191 125.151L255.423 142.605L260.766 139.52L230.534 122.066ZM272.996 132.92C276.893 130.67 276.332 128.317 275.52 126.877L275.845 126.69L279.417 128.752L284.672 125.718L254.44 108.263L249.082 111.357L260.389 117.886L260.168 118.013C257.717 117.536 253.643 117.11 249.643 119.42C244.402 122.445 244.388 127.192 251.946 131.556C259.415 135.869 267.652 136.005 272.996 132.92ZM270.103 129.528C266.574 131.565 261.615 130.849 257.363 128.394C253.141 125.957 251.946 123.153 255.503 121.099C258.943 119.113 263.681 119.667 268.08 122.207C272.479 124.746 273.513 127.559 270.103 129.528ZM264.596 102.4L258.883 105.699L280.701 117.75L285.454 115.005L264.596 102.4ZM292.289 121.696C294.031 120.69 294.075 118.994 292.289 117.946C290.503 116.932 287.565 116.957 285.823 117.963C284.022 119.003 284.007 120.682 285.794 121.696C287.58 122.744 290.488 122.736 292.289 121.696Z"
              fill="#202020"
            />
          </g>

          <defs>
            <clipPath id="clip1_831_3535">
              <rect
                fill="white"
                height="405.137"
                rx="10"
                transform="matrix(0.866025 -0.5 0.866025 0.5 2 427)"
                width="446.868"
              />
            </clipPath>
            <clipPath id="clip2_831_3535">
              <rect
                fill="white"
                height="407.697"
                rx="10"
                transform="matrix(0.866025 -0.5 0.866025 0.5 1 326)"
                width="447.874"
              />
            </clipPath>
            <clipPath id="clip3_831_3535">
              <rect
                fill="white"
                height="612"
                transform="matrix(0.866025 -0.5 0.866025 0.5 -275.85 387.902)"
                width="885.982"
              />
            </clipPath>
            <clipPath id="clip6_831_3535">
              <rect
                fill="white"
                height="30"
                rx="6"
                transform="matrix(0.866025 -0.5 0.866025 0.5 667.641 203.625)"
                width="30"
              />
            </clipPath>
            <clipPath id="clip7_831_3535">
              <rect
                fill="white"
                height="24"
                transform="matrix(0.866025 -0.5 0.866025 0.5 672.837 203.625)"
                width="24"
              />
            </clipPath>
            <clipPath id="clip8_831_3535">
              <rect
                fill="white"
                height="30"
                rx="6"
                transform="matrix(0.866025 -0.5 0.866025 0.5 633 223.625)"
                width="30"
              />
            </clipPath>
          </defs>
        </g>
      </svg>
    </div>
  );
};

export default ClientIllustration;
