/* eslint-disable @typescript-eslint/no-explicit-any */
import React, { useState } from "react";

import {
  Sandpack,
  SandpackCodeEditor,
  SandpackFileExplorer,
  SandpackLayout,
  SandpackProvider,
} from "./index";

export default {
  title: "Bug reports/Issues",
};
export const FlushServerVsClient = (): JSX.Element => {
  return (
    <SandpackProvider>
      <div style={{ border: "1px solid black" }}>
        <SandpackCodeEditor />
      </div>
    </SandpackProvider>
  );
};

export const Issue663 = (): JSX.Element => (
  <Sandpack
    options={{
      showTabs: true,
      activeFile: "/index.tsx",
    }}
    template="react-ts"
  />
);

export const Issue482 = (): JSX.Element => {
  const [hidden, setHidden] = useState(false);

  const toggleHidden = (): void => {
    setHidden((prevHidden) => !prevHidden);
  };

  return (
    <>
      <button onClick={toggleHidden}>toggle hidden</button>
      <SandpackProvider
        customSetup={{
          entry: "/index.js",
        }}
        files={{
          "/index.js": {
            code: "// index.js",
            active: true,
          },
          "/index2.js": {
            code: "// index2.js",
          },
          "/src/index.js": {
            code: "// this file is generated by vanilla template, but it is not needed",
            hidden: true,
          },
          "/hidden.js": {
            code: "// hidden.js",
            hidden: true,
          },
        }}
        options={{
          visibleFiles: ["/index.js", "/hidden.js"],
          activeFile: "/index.js",
        }}
        template={"vanilla"}
      >
        <SandpackLayout>
          <SandpackFileExplorer autoHiddenFiles={hidden} />
          <SandpackCodeEditor />
        </SandpackLayout>
      </SandpackProvider>
    </>
  );
};

export const Issue454 = (): JSX.Element => {
  const [readOnly, setReadOnly] = useState(false);

  return (
    <>
      <button
        className="trigger"
        onClick={(): any => setReadOnly((prev) => !prev)}
      >
        click
      </button>
      <Sandpack options={{ readOnly }} />
    </>
  );
};

export const FileTab = (): JSX.Element => {
  return (
    <Sandpack
      options={{ visibleFiles: ["/App.js", "/styles.css"] }}
      template="react"
    />
  );
};

export const ReactRouter = (): JSX.Element => {
  return (
    <Sandpack
      customSetup={{
        dependencies: {
          "react-router-dom": "^5.3.0",
        },
      }}
      files={{
        "/App.js": `import React from "react";
import {
  BrowserRouter as Router,
  Switch,
  Route,
  Link
} from "react-router-dom";

// This site has 3 pages, all of which are rendered
// dynamically in the browser (not server rendered).
//
// Although the page does not ever refresh, notice how
// React Router keeps the URL up to date as you navigate
// through the site. This preserves the browser history,
// making sure things like the back button and bookmarks
// work properly.

export default function BasicExample() {
  return (
    <Router>
      <div>
        <ul>
          <li>
            <Link to="/">Home</Link>
          </li>
          <li>
            <Link to="/about">About</Link>
          </li>
          <li>
            <Link to="/dashboard">Dashboard</Link>
          </li>
        </ul>

        <hr />

        {/*
          A <Switch> looks through all its children <Route>
          elements and renders the first one whose path
          matches the current URL. Use a <Switch> any time
          you have multiple routes, but you want only one
          of them to render at a time
        */}
        <Switch>
          <Route exact path="/">
            <Home />
          </Route>
          <Route path="/about">
            <About />
          </Route>
          <Route path="/dashboard">
            <Dashboard />
          </Route>
        </Switch>
      </div>
    </Router>
  );
}

// You can think of these components as "pages"
// in your app.

function Home() {
  return (
    <div>
      <h2>Home</h2>
    </div>
  );
}

function About() {
  return (
    <div>
      <h2>About</h2>
    </div>
  );
}

function Dashboard() {
  return (
    <div>
      <h2>Dashboard</h2>
    </div>
  );
}
`,
      }}
      options={{ showNavigator: true }}
      template="react"
    />
  );
};
