# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## [2.19.10](https://github.com/codesandbox/sandpack/compare/v2.19.9...v2.19.10) (2024-11-21)

### Bug Fixes

- replace eval with globalThis to comply with CSP policies ([#1232](https://github.com/codesandbox/sandpack/issues/1232)) ([515488d](https://github.com/codesandbox/sandpack/commit/515488da9dcbf4cf062527347b46adc7d7dba08f))

## [2.19.9](https://github.com/codesandbox/sandpack/compare/v2.19.8...v2.19.9) (2024-09-23)

### Bug Fixes

- handle string errors in SandpackTests component ([#1208](https://github.com/codesandbox/sandpack/issues/1208)) ([23c1b8d](https://github.com/codesandbox/sandpack/commit/23c1b8d9b3d3651c9eef76224c7c4f0c5b232085))

## [2.19.8](https://github.com/codesandbox/sandpack/compare/v2.19.7...v2.19.8) (2024-09-12)

### Bug Fixes

- **sandpack-id:** generate new bundler id based on client version ([#1202](https://github.com/codesandbox/sandpack/issues/1202)) ([dbb882e](https://github.com/codesandbox/sandpack/commit/dbb882eec6963a11c2eac7293c0891b501f9a9fe))

## [2.19.7](https://github.com/codesandbox/sandpack/compare/v2.19.6...v2.19.7) (2024-09-11)

### Bug Fixes

- **client:** postcss transpile to angular template ([#1201](https://github.com/codesandbox/sandpack/issues/1201)) ([0b57de6](https://github.com/codesandbox/sandpack/commit/0b57de653d3bea38917c2665aae3942c87a212ff))

## [2.19.6](https://github.com/codesandbox/sandpack/compare/v2.19.5...v2.19.6) (2024-09-11)

### Bug Fixes

- **file-tab:** close button ([#1198](https://github.com/codesandbox/sandpack/issues/1198)) ([58d1f54](https://github.com/codesandbox/sandpack/commit/58d1f54a1f18fb917b54510976f5ab87c4d16ae7))

## [2.19.5](https://github.com/codesandbox/sandpack/compare/v2.19.4...v2.19.5) (2024-09-10)

### Bug Fixes

- **sw:** support fixed id value ([#1197](https://github.com/codesandbox/sandpack/issues/1197)) ([1fb5a56](https://github.com/codesandbox/sandpack/commit/1fb5a56ec1359c09e2e6671a9885368c52f460af))

## [2.19.4](https://github.com/codesandbox/sandpack/compare/v2.19.3...v2.19.4) (2024-09-10)

### Bug Fixes

- **sw:** get transpiled files from bundler ([#1196](https://github.com/codesandbox/sandpack/issues/1196)) ([4563646](https://github.com/codesandbox/sandpack/commit/4563646a08d3b072dec14c0942af46f9755d2719))

## [2.19.3](https://github.com/codesandbox/sandpack/compare/v2.19.2...v2.19.3) (2024-09-05)

### Bug Fixes

- **client:** remove non-letter chart from random id ([#1193](https://github.com/codesandbox/sandpack/issues/1193)) ([c7d4113](https://github.com/codesandbox/sandpack/commit/c7d4113ba4704fe4d1a5c25c3735bbadd77d980b))

## [2.19.2](https://github.com/codesandbox/sandpack/compare/v2.19.1...v2.19.2) (2024-09-04)

### Bug Fixes

- accessibility issue in tabs ([#1184](https://github.com/codesandbox/sandpack/issues/1184)) ([98af978](https://github.com/codesandbox/sandpack/commit/98af978f40942ed6d3a3bb96151c9c9dcd00691a))

## [2.19.1](https://github.com/codesandbox/sandpack/compare/v2.19.0...v2.19.1) (2024-08-27)

### Bug Fixes

- **read only:** use codemirror instance with decorators ([#1186](https://github.com/codesandbox/sandpack/issues/1186)) ([623a346](https://github.com/codesandbox/sandpack/commit/623a34648ece5667768b4f0de75a581e9d348470))

# [2.19.0](https://github.com/codesandbox/sandpack/compare/v2.18.3...v2.19.0) (2024-08-22)

### Features

- **iframe allow:** introduce xr-spatial-tracking ([#1183](https://github.com/codesandbox/sandpack/issues/1183)) ([7245731](https://github.com/codesandbox/sandpack/commit/72457311c01c9d6ece540e177007e59b42a64153))

## [2.18.3](https://github.com/codesandbox/sandpack/compare/v2.18.2...v2.18.3) (2024-08-19)

### Bug Fixes

- **code editor:** remount when readOnly change ([#1179](https://github.com/codesandbox/sandpack/issues/1179)) ([f30adcb](https://github.com/codesandbox/sandpack/commit/f30adcb17fda8b87f087dbb0dfba1f8e46cdc0db))

## [2.18.2](https://github.com/codesandbox/sandpack/compare/v2.18.1...v2.18.2) (2024-07-31)

### Bug Fixes

- **client:** use stable sw id ([#1169](https://github.com/codesandbox/sandpack/issues/1169)) ([8c15b85](https://github.com/codesandbox/sandpack/commit/8c15b85018fae9d55bfad86922c736694e45848f))
- **docs:** update deps ([#1167](https://github.com/codesandbox/sandpack/issues/1167)) ([768374b](https://github.com/codesandbox/sandpack/commit/768374b9bdfa2734be67bd069231c47be5f37b62))

## [2.18.1](https://github.com/codesandbox/sandpack/compare/v2.18.0...v2.18.1) (2024-07-25)

### Bug Fixes

- **docs:** update sandpack version ([#1162](https://github.com/codesandbox/sandpack/issues/1162)) ([55cb609](https://github.com/codesandbox/sandpack/commit/55cb6092b7436351f9adcc18ea0f966a1e416c28))
- **sw:** assign new channel port on reload ([#1166](https://github.com/codesandbox/sandpack/issues/1166)) ([2d92bea](https://github.com/codesandbox/sandpack/commit/2d92bea4a9754373027455494050110d91bd13fc))

# [2.18.0](https://github.com/codesandbox/sandpack/compare/v2.17.1...v2.18.0) (2024-07-11)

### Features

- Add support for enabling service worker feature ([#1127](https://github.com/codesandbox/sandpack/issues/1127)) ([4e2b116](https://github.com/codesandbox/sandpack/commit/4e2b1167446be930e4b072f785f719aa7444b5a9))

## [2.17.1](https://github.com/codesandbox/sandpack/compare/v2.17.0...v2.17.1) (2024-07-11)

### Bug Fixes

- **client:** update bundler ([#1160](https://github.com/codesandbox/sandpack/issues/1160)) ([a0c4209](https://github.com/codesandbox/sandpack/commit/a0c4209ce1172b2a9cdadd21dc3007d7f7cbfb1f))

# [2.17.0](https://github.com/codesandbox/sandpack/compare/v2.16.1...v2.17.0) (2024-07-09)

### Features

- **client:** enable SW in the bundler ([#1159](https://github.com/codesandbox/sandpack/issues/1159)) ([36e580b](https://github.com/codesandbox/sandpack/commit/36e580b5b76ee34bb722027b35302fa6c75e521e))

## [2.16.1](https://github.com/codesandbox/sandpack/compare/v2.16.0...v2.16.1) (2024-07-08)

### Bug Fixes

- **loading:** update bundler to consume the correct loading message ([#1157](https://github.com/codesandbox/sandpack/issues/1157)) ([7a70999](https://github.com/codesandbox/sandpack/commit/7a7099991e8831a5ca76b56cada5ec06b17aa339))

# [2.16.0](https://github.com/codesandbox/sandpack/compare/v2.15.0...v2.16.0) (2024-07-08)

### Features

- **loading:** show dependency download progress ([#1146](https://github.com/codesandbox/sandpack/issues/1146)) ([a811267](https://github.com/codesandbox/sandpack/commit/a811267243785bb461fafed3228a90e8630d022f))

# [2.15.0](https://github.com/codesandbox/sandpack/compare/v2.14.5...v2.15.0) (2024-07-08)

### Features

- **react:** enable use client directive ([#1156](https://github.com/codesandbox/sandpack/issues/1156)) ([3b4a6ec](https://github.com/codesandbox/sandpack/commit/3b4a6ecc1d9a80b91d64d00f72ca71482377e8db))

## [2.14.5](https://github.com/codesandbox/sandpack/compare/v2.14.4...v2.14.5) (2024-07-03)

### Bug Fixes

- **bundler:** use latest bundler version ([#1155](https://github.com/codesandbox/sandpack/issues/1155)) ([260cb35](https://github.com/codesandbox/sandpack/commit/260cb35be7a669cf337533a0c1b970f04bc8571c))

## [2.14.4](https://github.com/codesandbox/sandpack/compare/v2.14.3...v2.14.4) (2024-06-18)

### Bug Fixes

- **client:** bump version ([#1151](https://github.com/codesandbox/sandpack/issues/1151)) ([a2e56c0](https://github.com/codesandbox/sandpack/commit/a2e56c0bcdacb242295fb545ab8d08231adfba21))

## [2.14.3](https://github.com/codesandbox/sandpack/compare/v2.14.2...v2.14.3) (2024-06-18)

### Bug Fixes

- **preview:** allows clipboard api ([#1149](https://github.com/codesandbox/sandpack/issues/1149)) ([7350364](https://github.com/codesandbox/sandpack/commit/7350364b3dbf933ac04686be284222994335c001))

## [2.14.2](https://github.com/codesandbox/sandpack/compare/v2.14.1...v2.14.2) (2024-06-06)

### Bug Fixes

- **export:** normalize files and pass template ([#1145](https://github.com/codesandbox/sandpack/issues/1145)) ([c3bc09d](https://github.com/codesandbox/sandpack/commit/c3bc09d11a0cf492c5211bf25d5916685aeae170))

## [2.14.1](https://github.com/codesandbox/sandpack/compare/v2.14.0...v2.14.1) (2024-06-05)

### Bug Fixes

- **openCSB:** pass children to buttons ([#1144](https://github.com/codesandbox/sandpack/issues/1144)) ([62ba672](https://github.com/codesandbox/sandpack/commit/62ba6720fd0c8cef46f0cbe8bdad4083a29cdf9f))

# [2.14.0](https://github.com/codesandbox/sandpack/compare/v2.13.10...v2.14.0) (2024-05-29)

### Bug Fixes

- **docs:** Change Layout to Provider for accepting theme prop ([#1133](https://github.com/codesandbox/sandpack/issues/1133)) ([e07adc0](https://github.com/codesandbox/sandpack/commit/e07adc0331eba90855df0cff3989914e05f2155a))

### Features

- **export:** support private sandboxes in workspace ([#1136](https://github.com/codesandbox/sandpack/issues/1136)) ([1c7907e](https://github.com/codesandbox/sandpack/commit/1c7907e9219a7cf8bb5fd48e7f22048f900179da))

## [2.13.10](https://github.com/codesandbox/sandpack/compare/v2.13.9...v2.13.10) (2024-04-26)

### Bug Fixes

- **codemirror:** make sure extensions & theme is applied when init ([#1126](https://github.com/codesandbox/sandpack/issues/1126)) ([9b4816e](https://github.com/codesandbox/sandpack/commit/9b4816e59902cc11c833e1ac1fd35aada5b93fa7))

## [2.13.9](https://github.com/codesandbox/sandpack/compare/v2.13.8...v2.13.9) (2024-04-26)

### Bug Fixes

- dynamically reconfigure codemirror instead of recreate on rerender ([#1125](https://github.com/codesandbox/sandpack/issues/1125)) ([a41d1a0](https://github.com/codesandbox/sandpack/commit/a41d1a07306918cffadfaaa81ac7cd97ce3d182d))

## [2.13.8](https://github.com/codesandbox/sandpack/compare/v2.13.7...v2.13.8) (2024-04-11)

### Bug Fixes

- force new release ([#1118](https://github.com/codesandbox/sandpack/issues/1118)) ([5b38b37](https://github.com/codesandbox/sandpack/commit/5b38b372de2d9ff26967fec1e22c772c755a0d33))

## [2.13.7](https://github.com/codesandbox/sandpack/compare/v2.13.6...v2.13.7) (2024-03-26)

### Bug Fixes

- Fixed sandpackNode initializing failure ([#1105](https://github.com/codesandbox/sandpack/issues/1105)) ([26685d9](https://github.com/codesandbox/sandpack/commit/26685d92973ab609bae03dadca4d7f21c1fd696c))

## [2.13.6](https://github.com/codesandbox/sandpack/compare/v2.13.5...v2.13.6) (2024-03-25)

### Bug Fixes

- **docs:** update file explorer props table ([#1100](https://github.com/codesandbox/sandpack/issues/1100)) ([09403e9](https://github.com/codesandbox/sandpack/commit/09403e952e2380b0e55b482b785cab2a8b8fb751))
- **pro:** use partitioned cookie for sandpack authentication ([#1110](https://github.com/codesandbox/sandpack/issues/1110)) ([2950186](https://github.com/codesandbox/sandpack/commit/29501863c2ebbcbf64fb9e7080feed1f2bc724b5))

## [2.13.5](https://github.com/codesandbox/sandpack/compare/v2.13.4...v2.13.5) (2024-02-28)

### Bug Fixes

- make sure to unregister all clients when "user-visible" option is out of viewport ([#1098](https://github.com/codesandbox/sandpack/issues/1098)) ([230960c](https://github.com/codesandbox/sandpack/commit/230960c1dafd74d7e5e578865cb0b27526152e07))

## [2.13.4](https://github.com/codesandbox/sandpack/compare/v2.13.3...v2.13.4) (2024-02-27)

### Bug Fixes

- update intersection callback ref every time prop change ([#1096](https://github.com/codesandbox/sandpack/issues/1096)) ([4fb3d7c](https://github.com/codesandbox/sandpack/commit/4fb3d7c5a8ba701f30fa0506eb27c246d4197de8))

## [2.13.3](https://github.com/codesandbox/sandpack/compare/v2.13.2...v2.13.3) (2024-02-27)

### Bug Fixes

- investigating scroll issue ([#1094](https://github.com/codesandbox/sandpack/issues/1094)) ([b994287](https://github.com/codesandbox/sandpack/commit/b994287a5ffc0b3a6bdcb7f857a46f34e97ed039))

## [2.13.2](https://github.com/codesandbox/sandpack/compare/v2.13.1...v2.13.2) (2024-02-24)

### Bug Fixes

- **compile opts:** don't overwrite default properties ([#1090](https://github.com/codesandbox/sandpack/issues/1090)) ([2877fcf](https://github.com/codesandbox/sandpack/commit/2877fcf46be7579a20d793b5ebb746e63622fb74))

## [2.13.1](https://github.com/codesandbox/sandpack/compare/v2.13.0...v2.13.1) (2024-02-23)

### Bug Fixes

- **timeout:** clear it when there is a syntax error ([#1087](https://github.com/codesandbox/sandpack/issues/1087)) ([6777c24](https://github.com/codesandbox/sandpack/commit/6777c241f2d04b709e778543fe4afd9f79d3b514))

# [2.13.0](https://github.com/codesandbox/sandpack/compare/v2.12.1...v2.13.0) (2024-02-22)

### Features

- Add spread operator for options in runtime client ([#1086](https://github.com/codesandbox/sandpack/issues/1086)) ([b7c7551](https://github.com/codesandbox/sandpack/commit/b7c7551472e42723a70db7cbf7af853810dfd9d3))

## [2.12.1](https://github.com/codesandbox/sandpack/compare/v2.12.0...v2.12.1) (2024-02-12)

### Bug Fixes

- Theme state logic to account for non-prefers-color-scheme usage ([#1082](https://github.com/codesandbox/sandpack/issues/1082)) ([3fcd51d](https://github.com/codesandbox/sandpack/commit/3fcd51d1f1cae45030d1903a419fae3f7af0367d))

### Features

- Private NPM guidance update ([#1079](https://github.com/codesandbox/sandpack/issues/1079)) ([40ad726](https://github.com/codesandbox/sandpack/commit/40ad726a2016e2156b0030444ae9a91b749fdc42))

# [2.12.0](https://github.com/codesandbox/sandpack/compare/v2.11.3...v2.12.0) (2024-02-05)

### Features

- sandpack template type ([#1075](https://github.com/codesandbox/sandpack/issues/1075)) ([db8eba7](https://github.com/codesandbox/sandpack/commit/db8eba7d7810896948e29067ac6606388e31c5e2))

## [2.11.3](https://github.com/codesandbox/sandpack/compare/v2.11.2...v2.11.3) (2024-01-17)

### Bug Fixes

- Update CodeMirror View when autoReload changed ([#1059](https://github.com/codesandbox/sandpack/issues/1059)) ([782c0c7](https://github.com/codesandbox/sandpack/commit/782c0c713af7e4c8181236c128b7df7ec6c6433a))

## [2.11.2](https://github.com/codesandbox/sandpack/compare/v2.11.1...v2.11.2) (2024-01-11)

### Bug Fixes

- bump codesandbox-client and test new publish script ([#1056](https://github.com/codesandbox/sandpack/issues/1056)) ([1736185](https://github.com/codesandbox/sandpack/commit/173618538584f11426c7b2156243bc1691303696))

## [2.11.1](https://github.com/codesandbox/sandpack/compare/v2.11.0...v2.11.1) (2024-01-10)

### Bug Fixes

- add `allow-downloads` to iframes ([#1054](https://github.com/codesandbox/sandpack/issues/1054)) ([c038e13](https://github.com/codesandbox/sandpack/commit/c038e1322bbca94ea529f7a92089ad0f605d1ba5))

# [2.11.0](https://github.com/codesandbox/sandpack/compare/v2.10.0...v2.11.0) (2024-01-03)

### Bug Fixes

- Update git user configuration ([#1051](https://github.com/codesandbox/sandpack/issues/1051)) ([7144ed4](https://github.com/codesandbox/sandpack/commit/7144ed46370c6f0b6740c4fb2be0e2a0a3781c0b))
- Update git user settings ([#1052](https://github.com/codesandbox/sandpack/issues/1052)) ([cc88156](https://github.com/codesandbox/sandpack/commit/cc8815624a9505747ee66a8aa2c0dc46eae8f4ee))

### Features

- Added showResetButton prop ([#1044](https://github.com/codesandbox/sandpack/issues/1044)) ([d7c2679](https://github.com/codesandbox/sandpack/commit/d7c2679fbc61dee6d486cb6d4ec33a77a8f30589))
- improve system color scheme support and documentation ([#1050](https://github.com/codesandbox/sandpack/issues/1050)) ([23d513c](https://github.com/codesandbox/sandpack/commit/23d513cf9f81e240053768084178ce2e850711b3))

# [2.10.0](https://github.com/codesandbox/sandpack/compare/v2.9.0...v2.10.0) (2023-11-15)

### Bug Fixes

- GitHub Publish script ([#1016](https://github.com/codesandbox/sandpack/issues/1016)) ([5881e03](https://github.com/codesandbox/sandpack/commit/5881e031724f9f5150a79a3158768ab0a7c7da1b))
- Update GitHub workflow permissions ([#1039](https://github.com/codesandbox/sandpack/issues/1039)) ([d5aa486](https://github.com/codesandbox/sandpack/commit/d5aa4863319f10500b92c3d2b280e2d990d76286))
- Update Node.js version ([#1038](https://github.com/codesandbox/sandpack/issues/1038)) ([5d050cf](https://github.com/codesandbox/sandpack/commit/5d050cfd0b1228b652101fd82c9514ce4a158d6f))
- update the broken link ([#1017](https://github.com/codesandbox/sandpack/issues/1017)) ([0392ad1](https://github.com/codesandbox/sandpack/commit/0392ad19d8d00dcb63d6d1206a24e3a17133da29))

### Features

- **node:** Added resize event ([#1037](https://github.com/codesandbox/sandpack/issues/1037)) ([61ccf7e](https://github.com/codesandbox/sandpack/commit/61ccf7ebfb954710fed40d26f800d8e145806006))
- Upgrade Node.js version ([#1029](https://github.com/codesandbox/sandpack/issues/1029)) ([a79a5d2](https://github.com/codesandbox/sandpack/commit/a79a5d2feca6800e1d967df688a555aa39f8c5e6))

# [2.9.0](https://github.com/codesandbox/sandpack/compare/v2.8.0...v2.9.0) (2023-10-06)

### Features

- add sandbox-id prop to compile ([#1015](https://github.com/codesandbox/sandpack/issues/1015)) ([600b984](https://github.com/codesandbox/sandpack/commit/600b984d4dccaefc36e87d41a56bbd4cb9bb434f))

# [2.8.0](https://github.com/codesandbox/sandpack/compare/v2.7.1...v2.8.0) (2023-09-26)

### Features

- add vite-preact and vite-preact-ts templates ([#1000](https://github.com/codesandbox/sandpack/issues/1000)) ([8789aa9](https://github.com/codesandbox/sandpack/commit/8789aa9b3c5ee4544e41e9ff1ae9e858bdcf85c9))

## [2.7.1](https://github.com/codesandbox/sandpack/compare/v2.7.0...v2.7.1) (2023-09-13)

### Bug Fixes

- **node:** fix issue with undefined startRoute in iframePreviewUrl ([#1002](https://github.com/codesandbox/sandpack/issues/1002)) ([c457a53](https://github.com/codesandbox/sandpack/commit/c457a5330d4c0eb9bf4bf35ab4af7c9171a5680e))

# [2.7.0](https://github.com/codesandbox/sandpack/compare/v2.6.9...v2.7.0) (2023-09-11)

### Features

- add console hook to static template ([#909](https://github.com/codesandbox/sandpack/issues/909)) ([1a473e3](https://github.com/codesandbox/sandpack/commit/1a473e3fa2a4d6581d8a1c4e30586588f5a9ee9b))

## [2.6.9](https://github.com/codesandbox/sandpack/compare/v2.6.8...v2.6.9) (2023-06-20)

### Bug Fixes

- **lerna:** remove experimental flag for workspaces ([#956](https://github.com/codesandbox/sandpack/issues/956)) ([dec34f0](https://github.com/codesandbox/sandpack/commit/dec34f02bcbb92b0f3d62c305d58cd27a7db6b3b))

## [2.6.8](https://github.com/codesandbox/sandpack/compare/v2.6.7...v2.6.8) (2023-06-20)

### Bug Fixes

- **client:** hard reload on module removal ([d5dfdd1](https://github.com/codesandbox/sandpack/commit/d5dfdd126d1061d63e1f1b086f30cbe7077ca30b))

## [2.6.7](https://github.com/codesandbox/sandpack/compare/v2.6.6...v2.6.7) (2023-05-26)

### Bug Fixes

- **client:** avoid concurrent compile step and init ([#946](https://github.com/codesandbox/sandpack/issues/946)) ([98a20e9](https://github.com/codesandbox/sandpack/commit/98a20e92ebb3aecb7ef23f18a5d3cb76f716b0a4))
- **node:** remove --force option from all Sandpack Vite templates ([#947](https://github.com/codesandbox/sandpack/issues/947)) ([4d1b576](https://github.com/codesandbox/sandpack/commit/4d1b576adaa607e460b17a44f6d2b4c2349a2648))

## [2.6.6](https://github.com/codesandbox/sandpack/compare/v2.6.5...v2.6.6) (2023-05-22)

### Bug Fixes

- **compile:** create one TestRunner between sandbox compiles ([5ada4e3](https://github.com/codesandbox/sandpack/commit/5ada4e3e80509a0810e39baf8a638675991bb7dd))

## [2.6.5](https://github.com/codesandbox/sandpack/compare/v2.6.4...v2.6.5) (2023-05-19)

### Bug Fixes

- **package.json:** update @codesandbox/nodebox and outvariant versions ([#942](https://github.com/codesandbox/sandpack/issues/942)) ([e20d475](https://github.com/codesandbox/sandpack/commit/e20d475fdd5bd63c6597e4ba9367d7f9c49aa3ff))

## [2.6.4](https://github.com/codesandbox/sandpack/compare/v2.6.3...v2.6.4) (2023-05-11)

### Bug Fixes

- **runtime-client:** disable loading state by default ([#935](https://github.com/codesandbox/sandpack/issues/935)) ([aee0e3d](https://github.com/codesandbox/sandpack/commit/aee0e3dd76548c43c7439ce353200685ab7f5288))
- **types:** deduplicate files type ([#932](https://github.com/codesandbox/sandpack/issues/932)) ([c1b19ee](https://github.com/codesandbox/sandpack/commit/c1b19eec470f934cc5eb91ff331cf12efcb594ed))
- **vite templates:** set specific version ([#934](https://github.com/codesandbox/sandpack/issues/934)) ([8ab934e](https://github.com/codesandbox/sandpack/commit/8ab934e2863df8c316eb40080fcbe8b15a743c6e))

## [2.6.3](https://github.com/codesandbox/sandpack/compare/v2.6.2...v2.6.3) (2023-05-05)

### Bug Fixes

- **client:** work around solid refresh bugs ([b11b5c7](https://github.com/codesandbox/sandpack/commit/b11b5c79d1bfbbf0806e68a9ae74eeebb23c58f1))

## [2.6.2](https://github.com/codesandbox/sandpack/compare/v2.6.1...v2.6.2) (2023-05-02)

### Bug Fixes

- **useClient:** track all clients and update clients on runSandpack ([#923](https://github.com/codesandbox/sandpack/issues/923)) ([a7334ad](https://github.com/codesandbox/sandpack/commit/a7334adfb712abd2342c3fa949f72f201c7ba2c4))

## [2.6.1](https://github.com/codesandbox/sandpack/compare/v2.6.0...v2.6.1) (2023-04-17)

### Bug Fixes

- **sandpack-react:** fix autoReload and honor showRunButton false ([#907](https://github.com/codesandbox/sandpack/issues/907)) ([63c89e3](https://github.com/codesandbox/sandpack/commit/63c89e3857fef05360375c1c2722097c5f56101d))

# [2.6.0](https://github.com/codesandbox/sandpack/compare/v2.5.0...v2.6.0) (2023-04-11)

### Features

- private dep v2 ([#746](https://github.com/codesandbox/sandpack/issues/746)) ([4fef453](https://github.com/codesandbox/sandpack/commit/4fef453b78444d41a4917629545decc091ff3cb6))

# [2.5.0](https://github.com/codesandbox/sandpack/compare/v2.4.11...v2.5.0) (2023-04-11)

### Features

- **task-manager:** parse commands ([#892](https://github.com/codesandbox/sandpack/issues/892)) ([7b5f25c](https://github.com/codesandbox/sandpack/commit/7b5f25c1355ab290f67b253e9de845825cc8ddb2))

## [2.4.11](https://github.com/codesandbox/sandpack/compare/v2.4.10...v2.4.11) (2023-04-11)

### Bug Fixes

- verbose mode runtime error ([#903](https://github.com/codesandbox/sandpack/issues/903)) ([017d3d3](https://github.com/codesandbox/sandpack/commit/017d3d3812f1ca16c2aa1fb125b46210b6838969))

## [2.4.10](https://github.com/codesandbox/sandpack/compare/v2.4.9...v2.4.10) (2023-04-11)

### Bug Fixes

- **sandpack-react:** disable LanguageTool extention for code editor ([#900](https://github.com/codesandbox/sandpack/issues/900)) ([6b92b32](https://github.com/codesandbox/sandpack/commit/6b92b32f67e72011935f6911b1fbd7df9edfb14b))

## [2.4.9](https://github.com/codesandbox/sandpack/compare/v2.4.8...v2.4.9) (2023-04-10)

### Bug Fixes

- **Static Template:** Ensure valid HTML formatting for static template ([#894](https://github.com/codesandbox/sandpack/issues/894)) ([af68579](https://github.com/codesandbox/sandpack/commit/af68579a8cd2177608110d6a5c87006c31d77cd6))

## [2.4.8](https://github.com/codesandbox/sandpack/compare/v2.4.7...v2.4.8) (2023-04-09)

### Bug Fixes

- **react-template:** update react-scripts to ^5.0.0 ([#898](https://github.com/codesandbox/sandpack/issues/898)) ([49e365d](https://github.com/codesandbox/sandpack/commit/49e365d1a24b8e9b3c8a418fc48e0d1fbacb3bfa))

## [2.4.7](https://github.com/codesandbox/sandpack/compare/v2.4.6...v2.4.7) (2023-04-08)

### Bug Fixes

- **Static Template:** fix doctype injection ([#899](https://github.com/codesandbox/sandpack/issues/899)) ([9d4a1c7](https://github.com/codesandbox/sandpack/commit/9d4a1c70d2353946adc78fea0bd3b900322e7888))

## [2.4.6](https://github.com/codesandbox/sandpack/compare/v2.4.5...v2.4.6) (2023-04-08)

### Bug Fixes

- **SandpackCodeEditor:** add className prop ([#896](https://github.com/codesandbox/sandpack/issues/896)) ([00cd7f4](https://github.com/codesandbox/sandpack/commit/00cd7f4ab724284cf84a1edd36720f1e7454f09b))

## [2.4.5](https://github.com/codesandbox/sandpack/compare/v2.4.4...v2.4.5) (2023-04-07)

### Bug Fixes

- **client:** remove buffer dependency ([#891](https://github.com/codesandbox/sandpack/issues/891)) ([307e52b](https://github.com/codesandbox/sandpack/commit/307e52b3fb59fcef4942c27a14dd51326ebbe649))

## [2.4.4](https://github.com/codesandbox/sandpack/compare/v2.4.3...v2.4.4) (2023-04-07)

### Bug Fixes

- **classNames context:** general improvements ([#771](https://github.com/codesandbox/sandpack/issues/771)) ([93df1ec](https://github.com/codesandbox/sandpack/commit/93df1ec0cdd558d28248a9f7a7204697cd5f8863))

## [2.4.3](https://github.com/codesandbox/sandpack/compare/v2.4.2...v2.4.3) (2023-04-07)

**Note:** Version bump only for package sandpack

## [2.4.2](https://github.com/codesandbox/sandpack/compare/v2.4.1...v2.4.2) (2023-04-06)

### Bug Fixes

- **code-viewer:** support additionalLanguages ([#889](https://github.com/codesandbox/sandpack/issues/889)) ([99cb481](https://github.com/codesandbox/sandpack/commit/99cb4811e263dbb581fd65229d672bb53509996e))

## [2.4.1](https://github.com/codesandbox/sandpack/compare/v2.4.0...v2.4.1) (2023-04-06)

### Bug Fixes

- **react build:** rename esm modules ([#888](https://github.com/codesandbox/sandpack/issues/888)) ([b0c4b82](https://github.com/codesandbox/sandpack/commit/b0c4b82be87b8ab95d080d3f3b3c6dc4bf791a24))

# [2.4.0](https://github.com/codesandbox/sandpack/compare/v2.3.2...v2.4.0) (2023-04-06)

### Features

- **Static Template:** add hidden head tags option ([#884](https://github.com/codesandbox/sandpack/issues/884)) ([3cee76f](https://github.com/codesandbox/sandpack/commit/3cee76fdd937460e379ddffea52f462c34ed5d36))

## [2.3.2](https://github.com/codesandbox/sandpack/compare/v2.3.1...v2.3.2) (2023-04-06)

### Bug Fixes

- **useFiles:** Only sync props to state after mount ([#886](https://github.com/codesandbox/sandpack/issues/886)) ([c6390f2](https://github.com/codesandbox/sandpack/commit/c6390f26778339ab0ad058bab66d2fa86a8647a7))

## [2.3.1](https://github.com/codesandbox/sandpack/compare/v2.3.0...v2.3.1) (2023-04-06)

**Note:** Version bump only for package sandpack

# [2.3.0](https://github.com/codesandbox/sandpack/compare/v2.2.9...v2.3.0) (2023-04-05)

### Features

- **Preview:** add startRoute prop to override Provider default ([#868](https://github.com/codesandbox/sandpack/issues/868)) ([bc28871](https://github.com/codesandbox/sandpack/commit/bc288719afd057d8699cf10de13f905bf1dcded9))

## [2.2.9](https://github.com/codesandbox/sandpack/compare/v2.2.8...v2.2.9) (2023-04-03)

### Bug Fixes

- **static:** Don't crash at inserting runtime ([#878](https://github.com/codesandbox/sandpack/issues/878)) ([7da3346](https://github.com/codesandbox/sandpack/commit/7da3346aa0f79abc24c4ecf51fd7506bbf590dd7))

## [2.2.8](https://github.com/codesandbox/sandpack/compare/v2.2.7...v2.2.8) (2023-04-03)

### Bug Fixes

- **sandpack client:** introduce auto reload ([#877](https://github.com/codesandbox/sandpack/issues/877)) ([4a591fc](https://github.com/codesandbox/sandpack/commit/4a591fc00d80666fb5b301e87f4b0f565c3207f4))

## [2.2.7](https://github.com/codesandbox/sandpack/compare/v2.2.6...v2.2.7) (2023-04-03)

### Bug Fixes

- **sandpack-content:** destroy current client in case it tries to run it again ([#875](https://github.com/codesandbox/sandpack/issues/875)) ([04298be](https://github.com/codesandbox/sandpack/commit/04298bef19e838d641dfb7e3a455dd190093cbb1))

## [2.2.6](https://github.com/codesandbox/sandpack/compare/v2.2.5...v2.2.6) (2023-04-03)

### Bug Fixes

- Don't add index logic to StaticSandbox ([#874](https://github.com/codesandbox/sandpack/issues/874)) ([146287b](https://github.com/codesandbox/sandpack/commit/146287b6fc09c6cf6335c1167f1425a3ec636614))

## [2.2.5](https://github.com/codesandbox/sandpack/compare/v2.2.4...v2.2.5) (2023-04-03)

### Bug Fixes

- **sandpack preset:** use standalone mode for console layout ([#872](https://github.com/codesandbox/sandpack/issues/872)) ([6b52a72](https://github.com/codesandbox/sandpack/commit/6b52a72274107fa3d15b864ad68026308110f72f))

## [2.2.4](https://github.com/codesandbox/sandpack/compare/v2.2.3...v2.2.4) (2023-04-01)

### Bug Fixes

- **SandpackConsole:** make showHeader flag works ([#867](https://github.com/codesandbox/sandpack/issues/867)) ([54fd641](https://github.com/codesandbox/sandpack/commit/54fd64181e5318c396815ecd58baa1e2316d75a8))

## [2.2.3](https://github.com/codesandbox/sandpack/compare/v2.2.2...v2.2.3) (2023-04-01)

### Bug Fixes

- **console:** add resetOnPreviewRestart to main useEffect hook ([#861](https://github.com/codesandbox/sandpack/issues/861)) ([abd8d39](https://github.com/codesandbox/sandpack/commit/abd8d394819725ee57cce720c397123525c10333))

## [2.2.2](https://github.com/codesandbox/sandpack/compare/v2.2.1...v2.2.2) (2023-04-01)

### Bug Fixes

- **SandpackConsole:** clear logs based on maxMessageCount option ([#866](https://github.com/codesandbox/sandpack/issues/866)) ([c8afd3e](https://github.com/codesandbox/sandpack/commit/c8afd3e35b7ee3021dc5c10ab1949e16f05cbaad))

## [2.2.1](https://github.com/codesandbox/sandpack/compare/v2.2.0...v2.2.1) (2023-04-01)

### Bug Fixes

- **clients:** allow clipboard write ([#864](https://github.com/codesandbox/sandpack/issues/864)) ([7ec95e1](https://github.com/codesandbox/sandpack/commit/7ec95e1dfdbf1d943a6ef063f75dd14650bbba1a))

# [2.2.0](https://github.com/codesandbox/sandpack/compare/v2.1.11...v2.2.0) (2023-03-31)

### Features

- static template ([#830](https://github.com/codesandbox/sandpack/issues/830)) ([2b14ed2](https://github.com/codesandbox/sandpack/commit/2b14ed226c7fdfe49054c6efe732f7f9f560b23c))

## [2.1.11](https://github.com/codesandbox/sandpack/compare/v2.1.10...v2.1.11) (2023-03-22)

### Bug Fixes

- **types:** incorrect typings for ErrorOverlay ([#855](https://github.com/codesandbox/sandpack/issues/855)) ([05f6625](https://github.com/codesandbox/sandpack/commit/05f66251b9cd36ac0d17b86dc3bcff0abb876f74))

## [2.1.10](https://github.com/codesandbox/sandpack/compare/v2.1.9...v2.1.10) (2023-03-20)

**Note:** Version bump only for package sandpack

## [2.1.9](https://github.com/codesandbox/sandpack/compare/v2.1.8...v2.1.9) (2023-03-17)

**Note:** Version bump only for package sandpack

## [2.1.8](https://github.com/codesandbox/sandpack/compare/v2.1.7...v2.1.8) (2023-03-16)

### Bug Fixes

- reference error with sandpack-react/unstyled in typescript ([#842](https://github.com/codesandbox/sandpack/issues/842)) ([834d3c3](https://github.com/codesandbox/sandpack/commit/834d3c361284e0599bf72690f5ebc6ea38758287))

## [2.1.7](https://github.com/codesandbox/sandpack/compare/v2.1.6...v2.1.7) (2023-03-14)

### Bug Fixes

- add new build for styleless ([#798](https://github.com/codesandbox/sandpack/issues/798)) ([d9e475d](https://github.com/codesandbox/sandpack/commit/d9e475d13eaaeb04ff1e5e51403a5694c1ada65c))

## [2.1.6](https://github.com/codesandbox/sandpack/compare/v2.1.5...v2.1.6) (2023-03-13)

### Bug Fixes

- **SandpackConsole:** make standalone defaults to false ([#837](https://github.com/codesandbox/sandpack/issues/837)) ([bb612c5](https://github.com/codesandbox/sandpack/commit/bb612c5324b16b9d7f308ea8cce741ace7b5d661))

## [2.1.5](https://github.com/codesandbox/sandpack/compare/v2.1.4...v2.1.5) (2023-03-13)

### Bug Fixes

- **client:** make sure `unsubscribeQueuedClients` receives a valid obj ([#836](https://github.com/codesandbox/sandpack/issues/836)) ([3d42177](https://github.com/codesandbox/sandpack/commit/3d4217735a53452ea337fc11dc82dae0aa23703b))

## [2.1.4](https://github.com/codesandbox/sandpack/compare/v2.1.3...v2.1.4) (2023-03-13)

### Bug Fixes

- **sandpack-console:** standalone mode ([#835](https://github.com/codesandbox/sandpack/issues/835)) ([88d7d72](https://github.com/codesandbox/sandpack/commit/88d7d7220a2855ac4fc181d93333e3358f702281))

## [2.1.3](https://github.com/codesandbox/sandpack/compare/v2.1.2...v2.1.3) (2023-03-12)

### Bug Fixes

- **sandpack-react:** tweak imports to avoid circular deps ([#832](https://github.com/codesandbox/sandpack/issues/832)) ([b0faa50](https://github.com/codesandbox/sandpack/commit/b0faa50347912219d799eb7ec4aff5f50c4b2d75))

## [2.1.2](https://github.com/codesandbox/sandpack/compare/v2.1.1...v2.1.2) (2023-03-07)

### Bug Fixes

- add vite-react-ts template ([#810](https://github.com/codesandbox/sandpack/issues/810)) ([924b704](https://github.com/codesandbox/sandpack/commit/924b704b5c2096d720bfbf28254af8e44ef86bf0))

## [2.1.1](https://github.com/codesandbox/sandpack/compare/v2.1.0...v2.1.1) (2023-03-06)

### Bug Fixes

- **template vite:** clean cache on start script ([#806](https://github.com/codesandbox/sandpack/issues/806)) ([f7263ce](https://github.com/codesandbox/sandpack/commit/f7263ce1ca7b0e80674789efa5a17bd25a5601e1))

# [2.1.0](https://github.com/codesandbox/sandpack/compare/v2.0.29...v2.1.0) (2023-03-06)

### Features

- Improved loading and restarts ([#805](https://github.com/codesandbox/sandpack/issues/805)) ([1e1dffb](https://github.com/codesandbox/sandpack/commit/1e1dffb451f36b56084a87497e0da77ec6f16e29))

## [2.0.29](https://github.com/codesandbox/sandpack/compare/v2.0.28...v2.0.29) (2023-03-05)

### Reverts

- **remove outvariant:** remove it as it doesn't support esm ([#801](https://github.com/codesandbox/sandpack/issues/801)) ([dd47b0d](https://github.com/codesandbox/sandpack/commit/dd47b0d1e7811ab72d7ea48ee5c5256a79a69731))

## [2.0.28](https://github.com/codesandbox/sandpack/compare/v2.0.27...v2.0.28) (2023-03-05)

### Bug Fixes

- Make generateRandomId actually generate a unique id ([#796](https://github.com/codesandbox/sandpack/issues/796)) ([3f76933](https://github.com/codesandbox/sandpack/commit/3f76933891b63aa24ef5729362ac008bbb7d0a0a))
- **remove outvariant:** remove it as it doesn't support esm ([#800](https://github.com/codesandbox/sandpack/issues/800)) ([3c1faef](https://github.com/codesandbox/sandpack/commit/3c1faefb5d2989c6ba75357ea743dbeb3cf71e5d))
- upgrade node version to csb-client ([ad1d072](https://github.com/codesandbox/sandpack/commit/ad1d0723422ddf043ff10f28835e19c8c16567a2))

## [2.0.27](https://github.com/codesandbox/sandpack/compare/v2.0.26...v2.0.27) (2023-03-03)

### Bug Fixes

- **getNodeProcess:** check if process is available ([#795](https://github.com/codesandbox/sandpack/issues/795)) ([ef272bc](https://github.com/codesandbox/sandpack/commit/ef272bca69abcef4dead63a8997f820364818931))

## [2.0.26](https://github.com/codesandbox/sandpack/compare/v2.0.25...v2.0.26) (2023-03-02)

### Bug Fixes

- **preview:** add stdout for long process ([#792](https://github.com/codesandbox/sandpack/issues/792)) ([4da4d99](https://github.com/codesandbox/sandpack/commit/4da4d997b54beb408d3ec2f15d027090d05879c7))

## [2.0.25](https://github.com/codesandbox/sandpack/compare/v2.0.24...v2.0.25) (2023-03-02)

### Bug Fixes

- make codesandbox theme private ([a01ff5c](https://github.com/codesandbox/sandpack/commit/a01ff5c9df034790c39aa377ae0d38290f2a7466))
- throw error on timeout ([#791](https://github.com/codesandbox/sandpack/issues/791)) ([3c201aa](https://github.com/codesandbox/sandpack/commit/3c201aa1edc0bd16ad7045bd8c6303f7fdeba289))

## [2.0.24](https://github.com/codesandbox/sandpack/compare/v2.0.23...v2.0.24) (2023-03-02)

### Bug Fixes

- increase preview timeout ([#789](https://github.com/codesandbox/sandpack/issues/789)) ([27fe67b](https://github.com/codesandbox/sandpack/commit/27fe67b986b81eee31f62c134fb08e47e002f7ee))
- make disable default style env variable work for client side bundler and nextjs ([#787](https://github.com/codesandbox/sandpack/issues/787)) ([2a48214](https://github.com/codesandbox/sandpack/commit/2a4821425ee937ee3cd46b7ce4ff1edd1c90ecd3))

## [2.0.23](https://github.com/codesandbox/sandpack/compare/v2.0.22...v2.0.23) (2023-03-01)

### Bug Fixes

- **nodebox:** writeFile recursively ([#783](https://github.com/codesandbox/sandpack/issues/783)) ([9e61ef0](https://github.com/codesandbox/sandpack/commit/9e61ef0518677f2742d9b372a773af133ca4a2e5))

## [2.0.22](https://github.com/codesandbox/sandpack/compare/v2.0.21...v2.0.22) (2023-03-01)

### Bug Fixes

- add rtl layout option ([#780](https://github.com/codesandbox/sandpack/issues/780)) ([80624f7](https://github.com/codesandbox/sandpack/commit/80624f7912cc0eda6b0fd61ecce29983cd1efdb6))
- open icon style with loading status ([#782](https://github.com/codesandbox/sandpack/issues/782)) ([427aa8c](https://github.com/codesandbox/sandpack/commit/427aa8cf6708f3885129af6ce2a36c84b21bf905))

## [2.0.21](https://github.com/codesandbox/sandpack/compare/v2.0.20...v2.0.21) (2023-02-28)

### Bug Fixes

- **nodebox:** consider new files from Sandpack ([#778](https://github.com/codesandbox/sandpack/issues/778)) ([877222e](https://github.com/codesandbox/sandpack/commit/877222ef649ed741534709c834053eeefce70948))
- **sandpack-tests:** introduce `hideTestsAndSupressLogs` prop ([#775](https://github.com/codesandbox/sandpack/issues/775)) ([373ab43](https://github.com/codesandbox/sandpack/commit/373ab4329692820d6cb6760c88a21b0222708cc9))

## [2.0.20](https://github.com/codesandbox/sandpack/compare/v2.0.19...v2.0.20) (2023-02-28)

### Bug Fixes

- **sandpack-client:** setup build with rollup ([#758](https://github.com/codesandbox/sandpack/issues/758)) ([f645119](https://github.com/codesandbox/sandpack/commit/f6451194a718a0679ce5fcb4d64d1f0d58f6c146))

## [2.0.19](https://github.com/codesandbox/sandpack/compare/v2.0.18...v2.0.19) (2023-02-28)

### Bug Fixes

- **use-files:** watch prop keys changes ([#776](https://github.com/codesandbox/sandpack/issues/776)) ([987814f](https://github.com/codesandbox/sandpack/commit/987814f9ec0f7e455a645e69c1b51bda6aec7521))

## [2.0.18](https://github.com/codesandbox/sandpack/compare/v2.0.17...v2.0.18) (2023-02-28)

### Bug Fixes

- **sandpack-react:** open sandbox button ([#761](https://github.com/codesandbox/sandpack/issues/761)) ([430a0f5](https://github.com/codesandbox/sandpack/commit/430a0f5d13acc6da11e4108c8c4c82b35a0c7978))

## [2.0.17](https://github.com/codesandbox/sandpack/compare/v2.0.16...v2.0.17) (2023-02-24)

### Bug Fixes

- **use-files:** make files reference more stable ([#760](https://github.com/codesandbox/sandpack/issues/760)) ([32ab419](https://github.com/codesandbox/sandpack/commit/32ab419bdd082353408ca2cfb7e2dba6d52caf08))

## [2.0.16](https://github.com/codesandbox/sandpack/compare/v2.0.15...v2.0.16) (2023-02-23)

### Bug Fixes

- **sandpack-react:** use automatic runtime for jsx ([#738](https://github.com/codesandbox/sandpack/issues/738)) ([818d1b0](https://github.com/codesandbox/sandpack/commit/818d1b03e61a89119560f26e17e5ae6e9c9a3878))

## [2.0.15](https://github.com/codesandbox/sandpack/compare/v2.0.14...v2.0.15) (2023-02-22)

### Bug Fixes

- Send serialized console output to parent ([#757](https://github.com/codesandbox/sandpack/issues/757)) ([5865fc5](https://github.com/codesandbox/sandpack/commit/5865fc51ae18a877194bd6832df12d0de86b38e0))

## [2.0.14](https://github.com/codesandbox/sandpack/compare/v2.0.13...v2.0.14) (2023-02-22)

### Bug Fixes

- **file-explorer:** introduce initialCollapsedFolders ([#756](https://github.com/codesandbox/sandpack/issues/756)) ([27b075e](https://github.com/codesandbox/sandpack/commit/27b075ebff60424889cb2f6210de84a22fe7fb4d))

## [2.0.13](https://github.com/codesandbox/sandpack/compare/v2.0.12...v2.0.13) (2023-02-22)

### Bug Fixes

- **nodebox:** support env vars on commands ([#755](https://github.com/codesandbox/sandpack/issues/755)) ([af8d5c1](https://github.com/codesandbox/sandpack/commit/af8d5c1cfa0d9ef525565ec62c77459d745dfbf2))

## [2.0.12](https://github.com/codesandbox/sandpack/compare/v2.0.11...v2.0.12) (2023-02-22)

### Bug Fixes

- **file-explorer:** sort alpha & overflow scroll ([#754](https://github.com/codesandbox/sandpack/issues/754)) ([254df65](https://github.com/codesandbox/sandpack/commit/254df65e09fb2d600c11abe15a347178f29e2a24))

## [2.0.11](https://github.com/codesandbox/sandpack/compare/v2.0.10...v2.0.11) (2023-02-22)

### Bug Fixes

- **sandpack-client:** move console-feed to dev deps ([#747](https://github.com/codesandbox/sandpack/issues/747)) ([bdd1bb7](https://github.com/codesandbox/sandpack/commit/bdd1bb7925f2511aaea594593e3f7f3b7b9c3613))

## [2.0.10](https://github.com/codesandbox/sandpack/compare/v2.0.9...v2.0.10) (2023-02-21)

### Bug Fixes

- **client:** enable code-splitting and dynamic imports in esbuild ([#741](https://github.com/codesandbox/sandpack/issues/741)) ([0bc9d80](https://github.com/codesandbox/sandpack/commit/0bc9d80f05d2c1bd35f2b74e1a4de96d9ddd4839))

## [2.0.9](https://github.com/codesandbox/sandpack/compare/v2.0.8...v2.0.9) (2023-02-20)

### Bug Fixes

- **console:** improvements ([#743](https://github.com/codesandbox/sandpack/issues/743)) ([685fac3](https://github.com/codesandbox/sandpack/commit/685fac3717a5eb7173729b41bd9d37650e180d58))

## [2.0.8](https://github.com/codesandbox/sandpack/compare/v2.0.7...v2.0.8) (2023-02-20)

### Bug Fixes

- **sandpack-client:** fixing package exports ([#737](https://github.com/codesandbox/sandpack/issues/737)) ([e96672a](https://github.com/codesandbox/sandpack/commit/e96672a4abb8f09234126b95bdf0bb641fdbad91))

## [2.0.7](https://github.com/codesandbox/sandpack/compare/v2.0.6...v2.0.7) (2023-02-20)

### Bug Fixes

- Invalid esm package exports ([#725](https://github.com/codesandbox/sandpack/issues/725)) ([44b05ec](https://github.com/codesandbox/sandpack/commit/44b05ecc5a2d322473f06e8eef8ad49afe3c2d20)), closes [#724](https://github.com/codesandbox/sandpack/issues/724)

## [2.0.6](https://github.com/codesandbox/sandpack/compare/v2.0.5...v2.0.6) (2023-02-17)

### Bug Fixes

- **react-vite template:** use automatic runtime for jsx ([#720](https://github.com/codesandbox/sandpack/issues/720)) ([bbb41a6](https://github.com/codesandbox/sandpack/commit/bbb41a69ae7914bf905b6512dbde98584d39a0a9))

## [2.0.5](https://github.com/codesandbox/sandpack/compare/v2.0.4...v2.0.5) (2023-02-16)

**Note:** Version bump only for package sandpack

## [2.0.4](https://github.com/codesandbox/sandpack/compare/v2.0.3...v2.0.4) (2023-02-16)

**Note:** Version bump only for package sandpack

## [2.0.3](https://github.com/codesandbox/sandpack/compare/v2.0.2...v2.0.3) (2023-02-16)

**Note:** Version bump only for package sandpack

## [2.0.2](https://github.com/codesandbox/sandpack/compare/v2.0.1...v2.0.2) (2023-02-16)

### Bug Fixes

- remove unnecessary script ([4a2f425](https://github.com/codesandbox/sandpack/commit/4a2f425c999aa12981c254646977917e58d280b4))

## [2.0.1](https://github.com/codesandbox/sandpack/compare/v1.20.9...v2.0.1) (2023-02-16)

**Note:** Version bump only for package sandpack

## [1.15.2](https://github.com/codesandbox/sandpack/compare/v1.15.1...v1.15.2) (2022-10-21)

### Bug Fixes

- **themes:** ui tweaks ([#625](https://github.com/codesandbox/sandpack/issues/625)) ([d90f47e](https://github.com/codesandbox/sandpack/commit/d90f47e0814706971054a42a29a9ea591dd73821))

## [1.15.1](https://github.com/codesandbox/sandpack/compare/v1.15.0...v1.15.1) (2022-10-18)

### Bug Fixes

- **themes:** adds unpublished themes ([#621](https://github.com/codesandbox/sandpack/issues/621)) ([10b94cc](https://github.com/codesandbox/sandpack/commit/10b94ccdee92224997ac3fa7c1ae2728739c90cb))

# [1.15.0](https://github.com/codesandbox/sandpack/compare/v1.14.2...v1.15.0) (2022-10-17)

### Features

- added a new sandbox theme ([#616](https://github.com/codesandbox/sandpack/issues/616)) ([0cc7567](https://github.com/codesandbox/sandpack/commit/0cc75673090572da1a416d330a63ceb1070172c2))
- added a new sandbox theme ([#617](https://github.com/codesandbox/sandpack/issues/617)) ([ca659f4](https://github.com/codesandbox/sandpack/commit/ca659f4a2fcf840c2a5052d530a94854d4172514))
- **theme:** add cyberpunk theme ([#618](https://github.com/codesandbox/sandpack/issues/618)) ([6e16a71](https://github.com/codesandbox/sandpack/commit/6e16a71d9ad40a7e3257393199bd9d22fe35a7f1))

## [1.14.2](https://github.com/codesandbox/sandpack/compare/v1.14.1...v1.14.2) (2022-10-06)

**Note:** Version bump only for package sandpack

## [1.14.1](https://github.com/codesandbox/sandpack/compare/v1.14.0...v1.14.1) (2022-10-06)

### Bug Fixes

- **bare components:** extend to browser api ([266d721](https://github.com/codesandbox/sandpack/commit/266d721fdc440dc87eb525da77a65bbe65d78286))

# [1.14.0](https://github.com/codesandbox/sandpack/compare/v1.13.0...v1.14.0) (2022-10-06)

### Features

- **theme:** provide bare components ([#590](https://github.com/codesandbox/sandpack/issues/590)) ([158fd8c](https://github.com/codesandbox/sandpack/commit/158fd8c349677aebfb7d7fe01e7e23ab51089b9f))

# [1.13.0](https://github.com/codesandbox/sandpack/compare/v1.12.2...v1.13.0) (2022-10-06)

### Features

- **theme:** Cobalt2 Theme ([#608](https://github.com/codesandbox/sandpack/issues/608)) ([929fbf2](https://github.com/codesandbox/sandpack/commit/929fbf23899ac765d2c4342a1be8f2618e678f48))
- **theme:** Level Up Theme ([#609](https://github.com/codesandbox/sandpack/issues/609)) ([374536b](https://github.com/codesandbox/sandpack/commit/374536bf231497c3f6f9f1f319358c2a5cb4428e))

## [1.12.2](https://github.com/codesandbox/sandpack/compare/v1.12.1...v1.12.2) (2022-10-05)

**Note:** Version bump only for package sandpack

## [1.12.1](https://github.com/codesandbox/sandpack/compare/v1.12.0...v1.12.1) (2022-10-04)

**Note:** Version bump only for package sandpack

# [1.12.0](https://github.com/codesandbox/sandpack/compare/v1.11.1...v1.12.0) (2022-10-04)

### Features

- **theme:** freeCodeCamp Dark Theme ([#605](https://github.com/codesandbox/sandpack/issues/605)) ([24370e1](https://github.com/codesandbox/sandpack/commit/24370e1f1e7840f6757eac232d9929ce24b988f9))

## [1.11.1](https://github.com/codesandbox/sandpack/compare/v1.11.0...v1.11.1) (2022-10-04)

### Bug Fixes

- style prop no longer passed to React.Fragment ([#601](https://github.com/codesandbox/sandpack/issues/601)) ([05766bb](https://github.com/codesandbox/sandpack/commit/05766bb18e519e20fc3a9012ebd9412981173fba))

# [1.11.0](https://github.com/codesandbox/sandpack/compare/v1.10.1...v1.11.0) (2022-10-04)

### Features

- **theme:** EcoLight theme ([#602](https://github.com/codesandbox/sandpack/issues/602)) ([c8ed057](https://github.com/codesandbox/sandpack/commit/c8ed057de5ba6b7d01290738ba18ee0c6602da22))

## [1.10.1](https://github.com/codesandbox/sandpack/compare/v1.10.0...v1.10.1) (2022-10-04)

### Bug Fixes

- **templates:** move dependencies to a package json ([#594](https://github.com/codesandbox/sandpack/issues/594)) ([441d5a5](https://github.com/codesandbox/sandpack/commit/441d5a5182f162d343e4ad56cb6321e3e839d984))

# [1.10.0](https://github.com/codesandbox/sandpack/compare/v1.9.0...v1.10.0) (2022-10-04)

### Features

- **theme:** gruvbox light and dark ([#600](https://github.com/codesandbox/sandpack/issues/600)) ([3d93fc0](https://github.com/codesandbox/sandpack/commit/3d93fc048e948980884545bb23e61d67b9615ed6))

# [1.9.0](https://github.com/codesandbox/sandpack/compare/v1.8.8...v1.9.0) (2022-10-04)

### Features

- **theme:** atom dark ⚛ ([#598](https://github.com/codesandbox/sandpack/issues/598)) ([f48dc93](https://github.com/codesandbox/sandpack/commit/f48dc93ff3e213e3c19aa63b10161378835ee74b))

## [1.8.8](https://github.com/codesandbox/sandpack/compare/v1.8.7...v1.8.8) (2022-09-30)

### Bug Fixes

- **e2e:** migrate from cypress to playwright & fix sandpackStateFromProps ([#593](https://github.com/codesandbox/sandpack/issues/593)) ([c993827](https://github.com/codesandbox/sandpack/commit/c993827aeed87b4fea91b63b829a09ad5563c61e))

## [1.8.7](https://github.com/codesandbox/sandpack/compare/v1.8.6...v1.8.7) (2022-09-30)

### Bug Fixes

- **files:** normalize paths ([#595](https://github.com/codesandbox/sandpack/issues/595)) ([71a2044](https://github.com/codesandbox/sandpack/commit/71a2044f61ae32f69822f8eefdaae246629ef400))

## [1.8.6](https://github.com/codesandbox/sandpack/compare/v1.8.5...v1.8.6) (2022-09-28)

### Bug Fixes

- **syntax languages:** remove markdown ([#591](https://github.com/codesandbox/sandpack/issues/591)) ([a56962a](https://github.com/codesandbox/sandpack/commit/a56962a8be52f86d31ba3c9360d1480afc8e3fe5))

## [1.8.5](https://github.com/codesandbox/sandpack/compare/v1.8.4...v1.8.5) (2022-09-28)

### Bug Fixes

- **client-navigation:** make sure iframe is using the right location on refreshing ([#587](https://github.com/codesandbox/sandpack/issues/587)) ([317d456](https://github.com/codesandbox/sandpack/commit/317d456d5b137e795bb6e7bfa86fb92803c5afd3))

## [1.8.4](https://github.com/codesandbox/sandpack/compare/v1.8.3...v1.8.4) (2022-09-27)

### Bug Fixes

- **track fork:** standardized UTM parameter ([#585](https://github.com/codesandbox/sandpack/issues/585)) ([8b21ed6](https://github.com/codesandbox/sandpack/commit/8b21ed6c733de54a7866e9796421368f61bbc2a4))

## [1.8.3](https://github.com/codesandbox/sandpack/compare/v1.8.2...v1.8.3) (2022-09-27)

### Bug Fixes

- **codemirror:** avoid Escape keybinding conflict ([#581](https://github.com/codesandbox/sandpack/issues/581)) ([61e615c](https://github.com/codesandbox/sandpack/commit/61e615c38a6e0a42c4f436d475eba8af2c26aa01))

## [1.8.2](https://github.com/codesandbox/sandpack/compare/v1.8.1...v1.8.2) (2022-09-27)

### Bug Fixes

- **useGenerateId:** improve useId conditional ([#584](https://github.com/codesandbox/sandpack/issues/584)) ([91acb05](https://github.com/codesandbox/sandpack/commit/91acb05f0d353392287a83f7a1526bfbbddfc4bd))

## [1.8.1](https://github.com/codesandbox/sandpack/compare/v1.8.0...v1.8.1) (2022-09-26)

### Bug Fixes

- **file-explorer:** trim and avoid shrinks the icon on long file names ([#578](https://github.com/codesandbox/sandpack/issues/578)) ([bc12d03](https://github.com/codesandbox/sandpack/commit/bc12d0347743065a68f4af6ac65719e9c0dbf954))
- website csb logo ([#574](https://github.com/codesandbox/sandpack/issues/574)) ([4d91860](https://github.com/codesandbox/sandpack/commit/4d9186053270fd4396dfb73a1208984d26afe0da))

# [1.8.0](https://github.com/codesandbox/sandpack/compare/v1.7.2...v1.8.0) (2022-09-15)

### Bug Fixes

- **docs:** redirect double dash url ([25efc62](https://github.com/codesandbox/sandpack/commit/25efc62d99e5245e07f1bb9b51c90bbc2cfd2c9b))

### Features

- **codeeditor:** support additional, user-supplied language modes ([#570](https://github.com/codesandbox/sandpack/issues/570)) ([a746ae3](https://github.com/codesandbox/sandpack/commit/a746ae3ae700bf3b64b8e14e5caee3cb57dd307d))

## [1.7.2](https://github.com/codesandbox/sandpack/compare/v1.7.1...v1.7.2) (2022-09-01)

### Bug Fixes

- **sandpack preset:** fix columns size ([#566](https://github.com/codesandbox/sandpack/issues/566)) ([cad7273](https://github.com/codesandbox/sandpack/commit/cad72736e86cdff689e963fc0b535b262f99bae3))

## [1.7.1](https://github.com/codesandbox/sandpack/compare/v1.7.0...v1.7.1) (2022-08-31)

### Bug Fixes

- **console-wrapper:** refactor toggle animation and reset padding on the editor ([#565](https://github.com/codesandbox/sandpack/issues/565)) ([6e730c6](https://github.com/codesandbox/sandpack/commit/6e730c6bb462e225daea1dcea58c56c3fd17bcd3))

# [1.7.0](https://github.com/codesandbox/sandpack/compare/v1.6.0...v1.7.0) (2022-08-31)

### Features

- **SandpackTests:** Add SandpackTests component ([#562](https://github.com/codesandbox/sandpack/issues/562)) ([1191f82](https://github.com/codesandbox/sandpack/commit/1191f82c643356a3ff5729edc81ef0b501f81edc))

# [1.6.0](https://github.com/codesandbox/sandpack/compare/v1.5.5...v1.6.0) (2022-08-30)

### Features

- **console:** Add SandpackConsole component ([#546](https://github.com/codesandbox/sandpack/issues/546)) ([9987ec5](https://github.com/codesandbox/sandpack/commit/9987ec5979778143b35f2d1697ea01ac75aff0d4))

## [1.5.5](https://github.com/codesandbox/sandpack/compare/v1.5.4...v1.5.5) (2022-08-25)

### Bug Fixes

- **UnstyledOpenInCodeSandboxButton:** set visibility to hidden ([#560](https://github.com/codesandbox/sandpack/issues/560)) ([653cf0e](https://github.com/codesandbox/sandpack/commit/653cf0e93a19a4a3214c058269b3c9a8b77faa46))

## [1.5.4](https://github.com/codesandbox/sandpack/compare/v1.5.3...v1.5.4) (2022-08-22)

### Bug Fixes

- **client:** do not set default credentials for custom npm requests ([4ce7be9](https://github.com/codesandbox/sandpack/commit/4ce7be95e771339ebcbdd4868c04d3c4e2cb2d77))

## [1.5.3](https://github.com/codesandbox/sandpack/compare/v1.5.2...v1.5.3) (2022-08-22)

### Bug Fixes

- **client:** custom registry should include the credentials only for csb urls ([#555](https://github.com/codesandbox/sandpack/issues/555)) ([de1e424](https://github.com/codesandbox/sandpack/commit/de1e424092525f2e9fa013c35ec8c961a4f1ced7))

## [1.5.2](https://github.com/codesandbox/sandpack/compare/v1.5.1...v1.5.2) (2022-08-22)

### Bug Fixes

- **custom registry:** cors issue and make the types more strict ([#554](https://github.com/codesandbox/sandpack/issues/554)) ([dca96ec](https://github.com/codesandbox/sandpack/commit/dca96ec69587f6bb59d84d524357890f98bf980c))

## [1.5.1](https://github.com/codesandbox/sandpack/compare/v1.5.0...v1.5.1) (2022-08-19)

**Note:** Version bump only for package sandpack

# [1.5.0](https://github.com/codesandbox/sandpack/compare/v1.4.0...v1.5.0) (2022-08-11)

### Features

- **themes:** dracula 🧛 ([#551](https://github.com/codesandbox/sandpack/issues/551)) ([88cbc83](https://github.com/codesandbox/sandpack/commit/88cbc83797122a5241e6ee819255246064538f32))

# [1.4.0](https://github.com/codesandbox/sandpack/compare/v1.3.5...v1.4.0) (2022-08-11)

### Features

- **custom-setup:** introduce custom npm registries ([#542](https://github.com/codesandbox/sandpack/issues/542)) ([1fd8b99](https://github.com/codesandbox/sandpack/commit/1fd8b997e3e95bc76026e3de1a5c267859d92c82))

## [1.3.5](https://github.com/codesandbox/sandpack/compare/v1.3.4...v1.3.5) (2022-08-10)

**Note:** Version bump only for package sandpack

## [1.3.4](https://github.com/codesandbox/sandpack/compare/v1.3.3...v1.3.4) (2022-08-05)

### Bug Fixes

- **themes:** tweak error surface contrast ([#548](https://github.com/codesandbox/sandpack/issues/548)) ([d9120c9](https://github.com/codesandbox/sandpack/commit/d9120c9f42bc5ab75619332cb44197e5e8d43b13))
- **website:** ui tweaks ([b07c378](https://github.com/codesandbox/sandpack/commit/b07c378d04f5441ecea8b9718ddb0d494c0aa60e))

## [1.3.3](https://github.com/codesandbox/sandpack/compare/v1.3.2...v1.3.3) (2022-08-04)

### Bug Fixes

- **syntax highlight:** default json to javascript ([f6b29e5](https://github.com/codesandbox/sandpack/commit/f6b29e5c8cb9c1caabba97f62974b357be04330f))

## [1.3.2](https://github.com/codesandbox/sandpack/compare/v1.3.1...v1.3.2) (2022-07-29)

### Bug Fixes

- **client:** update bundler ([bb6d9c1](https://github.com/codesandbox/sandpack/commit/bb6d9c175568b26f51a11b84e44ceba7fcf3d74c))

## [1.3.1](https://github.com/codesandbox/sandpack/compare/v1.3.0...v1.3.1) (2022-07-25)

**Note:** Version bump only for package sandpack

# [1.3.0](https://github.com/codesandbox/sandpack/compare/v1.2.4...v1.3.0) (2022-07-20)

### Features

- **codeeditor:** support markdown and plain text ([#535](https://github.com/codesandbox/sandpack/issues/535)) ([c159608](https://github.com/codesandbox/sandpack/commit/c1596084b99b3f00282b7a25abaea008ad0e88a6))

## [1.2.4](https://github.com/codesandbox/sandpack/compare/v1.2.3...v1.2.4) (2022-07-12)

### Bug Fixes

- **react:** set react 18 as peer dependencies ([#529](https://github.com/codesandbox/sandpack/issues/529)) ([5a7e61c](https://github.com/codesandbox/sandpack/commit/5a7e61c622c4628af0767feb16bfcf4b3ee3351e))

## [1.2.3](https://github.com/codesandbox/sandpack/compare/v1.2.2...v1.2.3) (2022-07-12)

### Bug Fixes

- **codemirror:** use correct method to indent the code on tab key press ([#527](https://github.com/codesandbox/sandpack/issues/527)) ([6bea86b](https://github.com/codesandbox/sandpack/commit/6bea86bcd74fe0694abf6435ca7ab3c0d093428f))

## [1.2.2](https://github.com/codesandbox/sandpack/compare/v1.2.1...v1.2.2) (2022-06-29)

### Bug Fixes

- **codeeditor:** test-id should not be included in the bundler ([#521](https://github.com/codesandbox/sandpack/issues/521)) ([bf9cc21](https://github.com/codesandbox/sandpack/commit/bf9cc21827b69374914f416e03f06832d444af24))

## [1.2.1](https://github.com/codesandbox/sandpack/compare/v1.2.0...v1.2.1) (2022-06-27)

### Bug Fixes

- **global-listeners:** doesn't unsubscribe all listener unexpectedly ([#516](https://github.com/codesandbox/sandpack/issues/516)) ([7e65f6e](https://github.com/codesandbox/sandpack/commit/7e65f6ef3df52dfcd30be4181257ad3dadbfac53))

# [1.2.0](https://github.com/codesandbox/sandpack/compare/v1.1.8...v1.2.0) (2022-06-22)

### Features

- **sandpack-context:** add file method ([#512](https://github.com/codesandbox/sandpack/issues/512)) ([3b76995](https://github.com/codesandbox/sandpack/commit/3b76995b3284250b4d8f37a16e613b0854f48156))

## [1.1.8](https://github.com/codesandbox/sandpack/compare/v1.1.7...v1.1.8) (2022-06-22)

**Note:** Version bump only for package sandpack

## [1.1.7](https://github.com/codesandbox/sandpack/compare/v1.1.6...v1.1.7) (2022-06-22)

**Note:** Version bump only for package sandpack

## [1.1.6](https://github.com/codesandbox/sandpack/compare/v1.1.5...v1.1.6) (2022-06-20)

### Bug Fixes

- **client/react:** make Template more accessible and do a deep equal on react context ([#504](https://github.com/codesandbox/sandpack/issues/504)) ([31980f8](https://github.com/codesandbox/sandpack/commit/31980f86e40d4cd09e586eaa004df8073e02d6e0))

## [1.1.5](https://github.com/codesandbox/sandpack/compare/v1.1.4...v1.1.5) (2022-06-14)

### Bug Fixes

- **sandpack options:** recreate sandpack context on `options` change and persist visible file in file-explorer ([#498](https://github.com/codesandbox/sandpack/issues/498)) ([1064bd0](https://github.com/codesandbox/sandpack/commit/1064bd0761148abe3fcdd58fcd6ca5a6c17fe72f))

## [1.1.4](https://github.com/codesandbox/sandpack/compare/v1.1.3...v1.1.4) (2022-06-13)

**Note:** Version bump only for package sandpack

## [1.1.3](https://github.com/codesandbox/sandpack/compare/v1.1.2...v1.1.3) (2022-06-07)

### Bug Fixes

- **file-explorer:** adds property not to show hidden files ([#488](https://github.com/codesandbox/sandpack/issues/488)) ([1048fe9](https://github.com/codesandbox/sandpack/commit/1048fe93b7f3be2d54cd9d35ac64271e1ea613fe))

## [1.1.2](https://github.com/codesandbox/sandpack/compare/v1.1.1...v1.1.2) (2022-06-06)

### Bug Fixes

- **theme:** set color-scheme css property in theme context ([#491](https://github.com/codesandbox/sandpack/issues/491)) ([35342a3](https://github.com/codesandbox/sandpack/commit/35342a36cf8a5d9d0bd48779070397575541e9a7))

## [1.1.1](https://github.com/codesandbox/sandpack/compare/v1.1.0...v1.1.1) (2022-06-01)

### Bug Fixes

- **showOpenInCodeSandbox:** pass prop to loading component ([#486](https://github.com/codesandbox/sandpack/issues/486)) ([ba81506](https://github.com/codesandbox/sandpack/commit/ba8150628a47ad5f0f3374d36047ea3886bfba9e))

# [1.1.0](https://github.com/codesandbox/sandpack/compare/v1.0.4...v1.1.0) (2022-05-31)

### Features

- **client:** refactor iFrame fs protocol ([#483](https://github.com/codesandbox/sandpack/issues/483)) ([28f93d0](https://github.com/codesandbox/sandpack/commit/28f93d05b978ae59655d4c574a1393ce4b9d6e53))

## [1.0.4](https://github.com/codesandbox/sandpack/compare/v1.0.3...v1.0.4) (2022-05-27)

### Bug Fixes

- **release-script:** trigger release ([#480](https://github.com/codesandbox/sandpack/issues/480)) ([46890fd](https://github.com/codesandbox/sandpack/commit/46890fdc6748f997cad38a39860b573869af1c60))

## [1.0.3](https://github.com/codesandbox/sandpack/compare/v1.0.2...v1.0.3) (2022-05-27)

### Bug Fixes

- **codemirror:** remove inline props ([#477](https://github.com/codesandbox/sandpack/issues/477)) ([b3d9c63](https://github.com/codesandbox/sandpack/commit/b3d9c63f6b4dde06b7fdb682fb2874d0dab079ec))

## [1.0.2](https://github.com/codesandbox/sandpack/compare/v1.0.1...v1.0.2) (2022-05-26)

### Bug Fixes

- **package registry:** trigger deploy ([#475](https://github.com/codesandbox/sandpack/issues/475)) ([551c7c0](https://github.com/codesandbox/sandpack/commit/551c7c08898e5a49ceae36572b3e16bff5e9d64c))

## [1.0.1](https://github.com/codesandbox/sandpack/compare/v1.0.0...v1.0.1) (2022-05-25)

### Bug Fixes

- **theme context component:** extend props support ([#472](https://github.com/codesandbox/sandpack/issues/472)) ([a11dce4](https://github.com/codesandbox/sandpack/commit/a11dce418973a66c5fa36862161ea1cd98ba280f))

# [1.0.0](https://github.com/codesandbox/sandpack/compare/v0.19.10...v1.0.0) (2022-05-25)

### Features

- **react/client:** BREAKING CHANGES ([#375](https://github.com/codesandbox/sandpack/issues/375)) ([20a8993](https://github.com/codesandbox/sandpack/commit/20a899337343e35a8d8e0b4e00c42e7190625747))

## [0.19.10](https://github.com/codesandbox/sandpack/compare/v0.19.9...v0.19.10) (2022-05-25)

### Bug Fixes

- **codemirror:** watch extensions changes from props ([#469](https://github.com/codesandbox/sandpack/issues/469)) ([10ac96a](https://github.com/codesandbox/sandpack/commit/10ac96ab7ec912b559e1977db85809d32bc40cdc))
- **editor:** prefer useId when available ([#461](https://github.com/codesandbox/sandpack/issues/461)) ([a7187db](https://github.com/codesandbox/sandpack/commit/a7187db5784ff403396e1d792b5dd5d3300bcf04))

## [0.19.9](https://github.com/codesandbox/sandpack/compare/v0.19.8...v0.19.9) (2022-05-23)

### Bug Fixes

- **client:** console message methods ([1b76dcf](https://github.com/codesandbox/sandpack/commit/1b76dcf5ccfd0db61cda8d70329424cdf27116ad))

## [0.19.8](https://github.com/codesandbox/sandpack/compare/v0.19.7...v0.19.8) (2022-05-23)

### Bug Fixes

- **sandpack messages:** add console type ([3edcb4d](https://github.com/codesandbox/sandpack/commit/3edcb4d11238f47ecbc286a8535205579856d3f3))

## [0.19.7](https://github.com/codesandbox/sandpack/compare/v0.19.6...v0.19.7) (2022-05-16)

### Bug Fixes

- **inline-error:** check if error message has a valid value ([#466](https://github.com/codesandbox/sandpack/issues/466)) ([b088a2e](https://github.com/codesandbox/sandpack/commit/b088a2e7011a6c688916cb2e6a40e7cae5a66e9b))

## [0.19.6](https://github.com/codesandbox/sandpack/compare/v0.19.5...v0.19.6) (2022-05-02)

### Bug Fixes

- **readonly:** toggle remounting ([#456](https://github.com/codesandbox/sandpack/issues/456)) ([b4162bc](https://github.com/codesandbox/sandpack/commit/b4162bcd7d284c0b3cb2d3acdfff2e7f9818870d))

## [0.19.5](https://github.com/codesandbox/sandpack/compare/v0.19.4...v0.19.5) (2022-05-02)

### Bug Fixes

- **updatefile:** update all clients ([#455](https://github.com/codesandbox/sandpack/issues/455)) ([fc2e13c](https://github.com/codesandbox/sandpack/commit/fc2e13c00e2339c1ef18d18f4cb895248787b0d5))

## [0.19.4](https://github.com/codesandbox/sandpack/compare/v0.19.3...v0.19.4) (2022-04-29)

### Bug Fixes

- **updatefile:** support multiple files ([#453](https://github.com/codesandbox/sandpack/issues/453)) ([a05faac](https://github.com/codesandbox/sandpack/commit/a05faaca453b60f1ffab7b9d6fd7b6bb8050f8b2))

## [0.19.3](https://github.com/codesandbox/sandpack/compare/v0.19.2...v0.19.3) (2022-04-27)

### Bug Fixes

- **codeeditor:** ensure selections are inside of the document length ([#452](https://github.com/codesandbox/sandpack/issues/452)) ([7391c6e](https://github.com/codesandbox/sandpack/commit/7391c6e5fc896eb9b937323f918562beef694061))

## [0.19.2](https://github.com/codesandbox/sandpack/compare/v0.19.1...v0.19.2) (2022-04-26)

### Bug Fixes

- **solid template:** deprecate beta version ([#451](https://github.com/codesandbox/sandpack/issues/451)) ([8278c71](https://github.com/codesandbox/sandpack/commit/8278c71e33c9ca8197827f041f4c6da68c33d4f5))

## [0.19.1](https://github.com/codesandbox/sandpack/compare/v0.19.0...v0.19.1) (2022-04-26)

### Bug Fixes

- **client:** update bundler version ([#450](https://github.com/codesandbox/sandpack/issues/450)) ([1b6a663](https://github.com/codesandbox/sandpack/commit/1b6a663d8d7ff0bf3c3449b4aa0bfd675e37a221))

# [0.19.0](https://github.com/codesandbox/sandpack/compare/v0.18.2...v0.19.0) (2022-04-21)

### Features

- **template:** add solidjs (beta) ([#447](https://github.com/codesandbox/sandpack/issues/447)) ([7b03882](https://github.com/codesandbox/sandpack/commit/7b038827add0001b460af7574e12e4c664a075d2))

## [0.18.2](https://github.com/codesandbox/sandpack/compare/v0.18.1...v0.18.2) (2022-04-19)

### Bug Fixes

- **sandpack:** expose `showOpenInCodeSandbox` prop ([#443](https://github.com/codesandbox/sandpack/issues/443)) ([f5b9eda](https://github.com/codesandbox/sandpack/commit/f5b9eda0854f267e1c89b191294f10e65cf48c25))

## [0.18.1](https://github.com/codesandbox/sandpack/compare/v0.18.0...v0.18.1) (2022-04-12)

### Bug Fixes

- **custom-setup:** add dev-dependencies ([#436](https://github.com/codesandbox/sandpack/issues/436)) ([df2f906](https://github.com/codesandbox/sandpack/commit/df2f906257b763aed07181f053a7ed4781831195))

# [0.18.0](https://github.com/codesandbox/sandpack/compare/v0.17.1...v0.18.0) (2022-03-31)

### Features

- file-resolver protocol error handling ([#427](https://github.com/codesandbox/sandpack/issues/427)) ([c3b3cca](https://github.com/codesandbox/sandpack/commit/c3b3cca98ca4aba2c0744545969683e41d963ab4))

## [0.17.1](https://github.com/codesandbox/sandpack/compare/v0.17.0...v0.17.1) (2022-03-30)

**Note:** Version bump only for package sandpack

# [0.17.0](https://github.com/codesandbox/sandpack/compare/v0.16.1...v0.17.0) (2022-03-30)

### Features

- **preview:** consume client ([#425](https://github.com/codesandbox/sandpack/issues/425)) ([ec854c1](https://github.com/codesandbox/sandpack/commit/ec854c12d5b9ccdb862637e03f5f2d37dfa88e82))

## [0.16.1](https://github.com/codesandbox/sandpack/compare/v0.16.0...v0.16.1) (2022-03-29)

**Note:** Version bump only for package sandpack

# [0.16.0](https://github.com/codesandbox/sandpack/compare/v0.15.2...v0.16.0) (2022-03-27)

### Bug Fixes

- Add year and company name to license ([#417](https://github.com/codesandbox/sandpack/issues/417)) ([d3adcac](https://github.com/codesandbox/sandpack/commit/d3adcac9c45fd90bb04754f286da203eda8a5a56))

### Features

- **preview:** additional content in preview container ([#422](https://github.com/codesandbox/sandpack/issues/422)) ([98103a8](https://github.com/codesandbox/sandpack/commit/98103a8b43fd16525ad8106b149c8c1747907be1))

## [0.15.2](https://github.com/codesandbox/sandpack/compare/v0.15.1...v0.15.2) (2022-03-18)

### Bug Fixes

- **loglevel:** set default ([#418](https://github.com/codesandbox/sandpack/issues/418)) ([abf0243](https://github.com/codesandbox/sandpack/commit/abf0243e5f106888ac3829daa6a5e6d6dd4f41b5))

## [0.15.1](https://github.com/codesandbox/sandpack/compare/v0.15.0...v0.15.1) (2022-03-18)

### Bug Fixes

- format & lint [skip ci] ([#413](https://github.com/codesandbox/sandpack/issues/413)) ([95ce023](https://github.com/codesandbox/sandpack/commit/95ce023e4c4e3809c0588997b651842baae91a4e))

# [0.15.0](https://github.com/codesandbox/sandpack/compare/v0.14.9...v0.15.0) (2022-03-16)

### Features

- Add slot for additional buttons ([#412](https://github.com/codesandbox/sandpack/issues/412)) ([7a59d18](https://github.com/codesandbox/sandpack/commit/7a59d18fd286163a72e3b4675456ca6b22a8468c))

## [0.14.9](https://github.com/codesandbox/sandpack/compare/v0.14.8...v0.14.9) (2022-03-14)

### Bug Fixes

- **environment:** remove sse envs ([#410](https://github.com/codesandbox/sandpack/issues/410)) ([cf65e50](https://github.com/codesandbox/sandpack/commit/cf65e500321c4d18674c05b3fcc3d1b81c8d2e6c))

## [0.14.8](https://github.com/codesandbox/sandpack/compare/v0.14.7...v0.14.8) (2022-03-11)

### Bug Fixes

- **client:** prevent add route into the main page browser history ([#407](https://github.com/codesandbox/sandpack/issues/407)) ([1e5230a](https://github.com/codesandbox/sandpack/commit/1e5230af5dff6c9afec8a96d1b9281cc585a826d))

## [0.14.7](https://github.com/codesandbox/sandpack/compare/v0.14.6...v0.14.7) (2022-03-10)

### Bug Fixes

- **logo:** update icons ([#402](https://github.com/codesandbox/sandpack/issues/402)) ([e7b0e46](https://github.com/codesandbox/sandpack/commit/e7b0e4630985b6e875a39087a1c4757b5729dd91))

## [0.14.6](https://github.com/codesandbox/sandpack/compare/v0.14.5...v0.14.6) (2022-03-10)

### Bug Fixes

- **codemirror:** persist selection position on code change ([#406](https://github.com/codesandbox/sandpack/issues/406)) ([65534eb](https://github.com/codesandbox/sandpack/commit/65534ebfdc785057b0ebff417a51867e5f8ba242))

## [0.14.5](https://github.com/codesandbox/sandpack/compare/v0.14.4...v0.14.5) (2022-03-07)

### Bug Fixes

- side effect should contain css ([#396](https://github.com/codesandbox/sandpack/issues/396)) ([4c2b149](https://github.com/codesandbox/sandpack/commit/4c2b1491838d2fe654c426f1429f96a76cace3ca))

## [0.14.4](https://github.com/codesandbox/sandpack/compare/v0.14.3...v0.14.4) (2022-03-07)

**Note:** Version bump only for package sandpack

## [0.14.3](https://github.com/codesandbox/sandpack/compare/v0.14.2...v0.14.3) (2022-02-23)

### Bug Fixes

- **codeviewer:** make CM view read-only ([#390](https://github.com/codesandbox/sandpack/issues/390)) ([56ac9f2](https://github.com/codesandbox/sandpack/commit/56ac9f2f89d510cce71dd08f2e656e739d91c46d))

## [0.14.2](https://github.com/codesandbox/sandpack/compare/v0.14.1...v0.14.2) (2022-02-22)

**Note:** Version bump only for package sandpack

## [0.14.1](https://github.com/codesandbox/sandpack/compare/v0.14.0...v0.14.1) (2022-02-21)

### Bug Fixes

- **read-only:** make editor-state read-only not only editor-view ([#386](https://github.com/codesandbox/sandpack/issues/386)) ([5a6a973](https://github.com/codesandbox/sandpack/commit/5a6a973a8e9be9c7dbd8fb4d233123d38a7d4789))

# [0.14.0](https://github.com/codesandbox/sandpack/compare/v0.13.15...v0.14.0) (2022-02-18)

### Features

- add loglevel to sandpack opts ([#378](https://github.com/codesandbox/sandpack/issues/378)) ([a3216e8](https://github.com/codesandbox/sandpack/commit/a3216e8f4940373df87e938148632e46cb661b4f))

## [0.13.15](https://github.com/codesandbox/sandpack/compare/v0.13.14...v0.13.15) (2022-02-11)

**Note:** Version bump only for package sandpack

## [0.13.14](https://github.com/codesandbox/sandpack/compare/v0.13.13...v0.13.14) (2022-02-09)

**Note:** Version bump only for package sandpack

## [0.13.13](https://github.com/codesandbox/sandpack/compare/v0.13.12...v0.13.13) (2022-02-08)

### Bug Fixes

- **codemirror instance:** refresh instance on rerender ([#365](https://github.com/codesandbox/sandpack/issues/365)) ([930c7be](https://github.com/codesandbox/sandpack/commit/930c7bea1d6a8e8d5e825c19c8f392091bbfce8c))

## [0.13.12](https://github.com/codesandbox/sandpack/compare/v0.13.11...v0.13.12) (2022-02-08)

### Bug Fixes

- **open cdb:** move window api to useeffect ([#362](https://github.com/codesandbox/sandpack/issues/362)) ([7b40dc2](https://github.com/codesandbox/sandpack/commit/7b40dc2799dfc53911503698f82b55fcdd4637da))

## [0.13.11](https://github.com/codesandbox/sandpack/compare/v0.13.10...v0.13.11) (2022-02-07)

### Bug Fixes

- **OpenInCodeSandboxButton:** preserve ?file= param for big sandboxes ([#357](https://github.com/codesandbox/sandpack/issues/357)) ([85f126d](https://github.com/codesandbox/sandpack/commit/85f126d184ae6139b6cc7e2c3dc66c6fd9fd603c))

## [0.13.10](https://github.com/codesandbox/sandpack/compare/v0.13.9...v0.13.10) (2022-02-03)

**Note:** Version bump only for package sandpack

## [0.13.9](https://github.com/codesandbox/sandpack/compare/v0.13.8...v0.13.9) (2022-02-02)

### Bug Fixes

- **initMode:** improve the reliability of the "user-visible" mode ([#343](https://github.com/codesandbox/sandpack/issues/343)) ([177f0ab](https://github.com/codesandbox/sandpack/commit/177f0ab43e33bc50a7595f81ede3b6693e2e0d0d))

## [0.13.8](https://github.com/codesandbox/sandpack/compare/v0.13.7...v0.13.8) (2022-01-27)

### Bug Fixes

- **codemirror:** adds language extension as classname ([#334](https://github.com/codesandbox/sandpack/issues/334)) ([9155a1e](https://github.com/codesandbox/sandpack/commit/9155a1e36b380113533b6db54272b8b06a4ab5fa))
- **init-mode:** reset bundler state on unmount ([#337](https://github.com/codesandbox/sandpack/issues/337)) ([98d4745](https://github.com/codesandbox/sandpack/commit/98d4745563b9e022cef030fb61df957910781555))

## [0.13.7](https://github.com/codesandbox/sandpack/compare/v0.13.6...v0.13.7) (2022-01-26)

**Note:** Version bump only for package sandpack

## [0.13.6](https://github.com/codesandbox/sandpack/compare/v0.13.5...v0.13.6) (2022-01-26)

### Bug Fixes

- **editorstate:** watch changes on files instead of each method ([#333](https://github.com/codesandbox/sandpack/issues/333)) ([75ebadb](https://github.com/codesandbox/sandpack/commit/75ebadb6bab1fa7c0ed0a4eff507fc432dd91844))

## [0.13.5](https://github.com/codesandbox/sandpack/compare/v0.13.4...v0.13.5) (2022-01-21)

**Note:** Version bump only for package sandpack

## [0.13.4](https://github.com/codesandbox/sandpack/compare/v0.13.3...v0.13.4) (2022-01-20)

### Bug Fixes

- **scrollbar:** remove hijack custom style ([#315](https://github.com/codesandbox/sandpack/issues/315)) ([5781e97](https://github.com/codesandbox/sandpack/commit/5781e974d0fd410394efac20cb11530ade6cfd8d))

## [0.13.3](https://github.com/codesandbox/sandpack/compare/v0.13.2...v0.13.3) (2022-01-20)

### Bug Fixes

- **calculateNearestUniquePath:** ensures unique paths ([#311](https://github.com/codesandbox/sandpack/issues/311)) ([a337269](https://github.com/codesandbox/sandpack/commit/a33726914e22c5b009c3ad5a5a6a7976ea29fd3f))

## [0.13.2](https://github.com/codesandbox/sandpack/compare/v0.13.1...v0.13.2) (2022-01-20)

### Bug Fixes

- **codemirror:** shift approach to remove placeholder ([#310](https://github.com/codesandbox/sandpack/issues/310)) ([4021b16](https://github.com/codesandbox/sandpack/commit/4021b16f956b52ed14e8fbb8b4c1784a5b43a1f8))

## [0.13.1](https://github.com/codesandbox/sandpack/compare/v0.13.0...v0.13.1) (2022-01-14)

### Bug Fixes

- **ui:** visual regression ([#304](https://github.com/codesandbox/sandpack/issues/304)) ([ced8b49](https://github.com/codesandbox/sandpack/commit/ced8b492e52c6db8565e66c228ee4c2bd85b3ef8))

# [0.13.0](https://github.com/codesandbox/sandpack/compare/v0.12.0...v0.13.0) (2022-01-14)

### Bug Fixes

- **who's using:** remove csb ([#299](https://github.com/codesandbox/sandpack/issues/299)) ([b20d498](https://github.com/codesandbox/sandpack/commit/b20d4983992ea5b567cfb165d880bb17fe6191ed))

### Features

- **files:** read-only mode ([#300](https://github.com/codesandbox/sandpack/issues/300)) ([9d5d1bf](https://github.com/codesandbox/sandpack/commit/9d5d1bfc3ac0d21d57958ee61057a706762701f2))

# [0.12.0](https://github.com/codesandbox/sandpack/compare/v0.11.0...v0.12.0) (2022-01-11)

### Features

- **codeeditor:** support to extensions ([#286](https://github.com/codesandbox/sandpack/issues/286)) ([47e73a9](https://github.com/codesandbox/sandpack/commit/47e73a94e072e544c4be692810c736547a4ef6f9))

# [0.11.0](https://github.com/codesandbox/sandpack/compare/v0.10.12...v0.11.0) (2022-01-11)

### Features

- **icons:** export sandpack icons ([#288](https://github.com/codesandbox/sandpack/issues/288)) ([ec184f7](https://github.com/codesandbox/sandpack/commit/ec184f750c2852236ef92e949a089beaac31a308))

## [0.10.12](https://github.com/codesandbox/sandpack/compare/v0.10.11...v0.10.12) (2022-01-07)

### Bug Fixes

- **init-mode:** avoid unnecessary unmonted state ([#294](https://github.com/codesandbox/sandpack/issues/294)) ([8a8bc11](https://github.com/codesandbox/sandpack/commit/8a8bc11d160b48225f7f3ec52c3f339f1aa3745e))

## [0.10.11](https://github.com/codesandbox/sandpack/compare/v0.10.10...v0.10.11) (2022-01-05)

### Bug Fixes

- **react-devtools:** legacy mode ([#272](https://github.com/codesandbox/sandpack/issues/272)) ([4891ba4](https://github.com/codesandbox/sandpack/commit/4891ba4bdf5ad8ed1aed1f6a37cc4b8e5a94b8e2))

## [0.10.10](https://github.com/codesandbox/sandpack/compare/v0.10.9...v0.10.10) (2021-12-29)

### Bug Fixes

- **filetab:** not show files that doesn't exist ([#283](https://github.com/codesandbox/sandpack/issues/283)) ([053d695](https://github.com/codesandbox/sandpack/commit/053d695e106683d169ede0bc81d12650f4491605))

## [0.10.9](https://github.com/codesandbox/sandpack/compare/v0.10.8...v0.10.9) (2021-12-28)

### Bug Fixes

- **entry/files:** prevent mismatch with pathname ([#268](https://github.com/codesandbox/sandpack/issues/268)) ([b618daf](https://github.com/codesandbox/sandpack/commit/b618dafab8595b7dc224f4620a9a8f73caa7762b))

## [0.10.8](https://github.com/codesandbox/sandpack/compare/v0.10.7...v0.10.8) (2021-12-28)

**Note:** Version bump only for package sandpack

## [0.10.7](https://github.com/codesandbox/sandpack/compare/v0.10.6...v0.10.7) (2021-12-28)

**Note:** Version bump only for package sandpack

## [0.10.6](https://github.com/codesandbox/sandpack/compare/v0.10.5...v0.10.6) (2021-12-17)

**Note:** Version bump only for package sandpack

## [0.10.5](https://github.com/codesandbox/sandpack/compare/v0.10.4...v0.10.5) (2021-12-16)

**Note:** Version bump only for package sandpack

## [0.10.4](https://github.com/codesandbox/sandpack/compare/v0.10.3...v0.10.4) (2021-12-15)

### Bug Fixes

- **codemirror:** line-height/gutter] calculation ([#262](https://github.com/codesandbox/sandpack/issues/262)) ([77f3f04](https://github.com/codesandbox/sandpack/commit/77f3f04ffe4c4f72d60349b834fc8ef6af3ca71a))

## [0.10.3](https://github.com/codesandbox/sandpack/compare/v0.10.2...v0.10.3) (2021-12-14)

### Bug Fixes

- lint errors ([#234](https://github.com/codesandbox/sandpack/issues/234)) ([2d51830](https://github.com/codesandbox/sandpack/commit/2d518309cfd86222078fde25d399ea12258b3493))

## [0.10.2](https://github.com/codesandbox/sandpack/compare/v0.10.1...v0.10.2) (2021-12-10)

### Bug Fixes

- **docs:** react dev tools layout ([54eeaaa](https://github.com/codesandbox/sandpack/commit/54eeaaa50fd9f27dc3579c99978c86d780dd2378))
- **react:** correct types for resting props ([#251](https://github.com/codesandbox/sandpack/issues/251)) ([eff38a6](https://github.com/codesandbox/sandpack/commit/eff38a6cea2259cbdaec7183ba195eb8992af652))

## [0.10.1](https://github.com/codesandbox/sandpack/compare/v0.10.0...v0.10.1) (2021-12-09)

### Bug Fixes

- **react-devtool:** add dependency ([#249](https://github.com/codesandbox/sandpack/issues/249)) ([d569a6e](https://github.com/codesandbox/sandpack/commit/d569a6e22d2c09ccb763b1e296e4b37eb17c194c))

# [0.10.0](https://github.com/codesandbox/sandpack/compare/v0.9.14...v0.10.0) (2021-12-09)

### Bug Fixes

- **react:** duplicated import ([512f814](https://github.com/codesandbox/sandpack/commit/512f814a7d045c57f56fbd3eacf7868ccfe2f516))

### Features

- **react:** react devtool ([#236](https://github.com/codesandbox/sandpack/issues/236)) ([a67e1b2](https://github.com/codesandbox/sandpack/commit/a67e1b2ccfc38b01ad78d2d7f518148cf94eb15d))

## [0.9.14](https://github.com/codesandbox/sandpack/compare/v0.9.13...v0.9.14) (2021-12-09)

### Bug Fixes

- **landing:** set pointerEvents to avoid reset button overlap ([#245](https://github.com/codesandbox/sandpack/issues/245)) ([51be6cf](https://github.com/codesandbox/sandpack/commit/51be6cf8dbee4df309167e07484f67e2c0324ac0))
- **react-context:** expose clients ([#241](https://github.com/codesandbox/sandpack/issues/241)) ([f47295d](https://github.com/codesandbox/sandpack/commit/f47295d9cd5365ce9482c02922d0ea6e2db61592))
- **react:** ensure hidden files even for templates ([#231](https://github.com/codesandbox/sandpack/issues/231)) ([a1461a0](https://github.com/codesandbox/sandpack/commit/a1461a0e58e8c5595209463d965aefb6760215fe))

## [0.9.13](https://github.com/codesandbox/sandpack/compare/v0.9.12...v0.9.13) (2021-12-08)

### Bug Fixes

- **client:** support reactdevtools ([7f0373f](https://github.com/codesandbox/sandpack/commit/7f0373f328d60229904bbebab0329718616b59bb))

## [0.9.12](https://github.com/codesandbox/sandpack/compare/v0.9.11...v0.9.12) (2021-12-08)

### Bug Fixes

- docs url ([#244](https://github.com/codesandbox/sandpack/issues/244)) ([ff40f97](https://github.com/codesandbox/sandpack/commit/ff40f9724f1a805890ae70758f746dd4ab7c58ae))
- **docs:** typo ([3134081](https://github.com/codesandbox/sandpack/commit/3134081ab95762aedbc6a6ae1cbdbb8da787eedc))
- **open in codesandbox button:** optimize for long sandoxes ([#120](https://github.com/codesandbox/sandpack/issues/120)) ([3ad5261](https://github.com/codesandbox/sandpack/commit/3ad5261ca06fad62ddd9430327645511aa072435))

## [0.9.11](https://github.com/codesandbox/sandpack/compare/v0.9.10...v0.9.11) (2021-12-05)

### Bug Fixes

- add feedback for clipboard button ([#235](https://github.com/codesandbox/sandpack/issues/235)) ([21a0337](https://github.com/codesandbox/sandpack/commit/21a033736ef8c9cd4fe18fba7bada70fc5a665e1))
- **types:** react components not actually accepting children ([#239](https://github.com/codesandbox/sandpack/issues/239)) ([44af959](https://github.com/codesandbox/sandpack/commit/44af9599d475db0b4732477c4365fd10d85f7788))

## [0.9.10](https://github.com/codesandbox/sandpack/compare/v0.9.9...v0.9.10) (2021-12-03)

**Note:** Version bump only for package sandpack

## [0.9.9](https://github.com/codesandbox/sandpack/compare/v0.9.8...v0.9.9) (2021-12-03)

**Note:** Version bump only for package sandpack

## [0.9.8](https://github.com/codesandbox/sandpack/compare/v0.9.7...v0.9.8) (2021-12-02)

### Bug Fixes

- amplitude ([#213](https://github.com/codesandbox/sandpack/issues/213)) ([2ce34d4](https://github.com/codesandbox/sandpack/commit/2ce34d40906c016a48b0d38232795d290377736a))
- cropped tabs ([#215](https://github.com/codesandbox/sandpack/issues/215)) ([4939202](https://github.com/codesandbox/sandpack/commit/49392028f71abb7dab4eee7bd67125a02f045fe6))

## [0.9.7](https://github.com/codesandbox/sandpack/compare/v0.9.6...v0.9.7) (2021-12-01)

### Bug Fixes

- leverege -> leverage ([#210](https://github.com/codesandbox/sandpack/issues/210)) ([6915d24](https://github.com/codesandbox/sandpack/commit/6915d24a3d6d064ca8135b1b7d5e320943bfb156))

## [0.9.6](https://github.com/codesandbox/sandpack/compare/v0.9.5...v0.9.6) (2021-11-30)

### Bug Fixes

- landing - global styles ([#205](https://github.com/codesandbox/sandpack/issues/205)) ([32cc3bd](https://github.com/codesandbox/sandpack/commit/32cc3bd3265efdaa6df59e936824eff3f6b80652))

## [0.9.5](https://github.com/codesandbox/sandpack/compare/v0.9.4...v0.9.5) (2021-11-30)

### Features

- landing - animate hero ([#197](https://github.com/codesandbox/sandpack/issues/197)) ([6ba7ea1](https://github.com/codesandbox/sandpack/commit/6ba7ea1adfbd5258a195645617625c1069acc0b4))

## [0.9.4](https://github.com/codesandbox/sandpack/compare/v0.9.3...v0.9.4) (2021-11-30)

### Bug Fixes

- **landing:** shift fonts import ([#201](https://github.com/codesandbox/sandpack/issues/201)) ([455684e](https://github.com/codesandbox/sandpack/commit/455684efa01ed53723d66da1b40f8eaeca320b1f))

## [0.9.3](https://github.com/codesandbox/sandpack/compare/v0.9.2...v0.9.3) (2021-11-30)

**Note:** Version bump only for package sandpack

## [0.9.2](https://github.com/codesandbox/sandpack/compare/v0.9.1...v0.9.2) (2021-11-29)

### Bug Fixes

- landing - users logos ([#188](https://github.com/codesandbox/sandpack/issues/188)) ([06f8170](https://github.com/codesandbox/sandpack/commit/06f81706f2b073008f012076b63ec8a2a6620c78))

## [0.9.1](https://github.com/codesandbox/sandpack/compare/v0.9.0...v0.9.1) (2021-11-25)

### Bug Fixes

- **init-mode:** render placeholder ([#187](https://github.com/codesandbox/sandpack/issues/187)) ([04b0286](https://github.com/codesandbox/sandpack/commit/04b028600dde049d512d16b2fdb176b1789c62ee))

# [0.9.0](https://github.com/codesandbox/sandpack/compare/v0.8.0...v0.9.0) (2021-11-25)

### Features

- **template:** svelte ([#182](https://github.com/codesandbox/sandpack/issues/182)) ([2d0c85c](https://github.com/codesandbox/sandpack/commit/2d0c85c5ef4fa856c83e539e2c9e2ffd804fa366))

# [0.8.0](https://github.com/codesandbox/sandpack/compare/v0.7.3...v0.8.0) (2021-11-25)

### Bug Fixes

- landing - showcase preview size on smaller bps ([#185](https://github.com/codesandbox/sandpack/issues/185)) ([f7bda3d](https://github.com/codesandbox/sandpack/commit/f7bda3dc17e931b76befdf4f5b3ce9ca99d8df42))
- **landing:** update animation trigger ([#184](https://github.com/codesandbox/sandpack/issues/184)) ([8c94cd7](https://github.com/codesandbox/sandpack/commit/8c94cd7e8bcd8fd73927719f719f83287991265e))

### Features

- **react:** initilization mode ([#152](https://github.com/codesandbox/sandpack/issues/152)) ([53d9195](https://github.com/codesandbox/sandpack/commit/53d9195fa02f412f99f50d96e43ffd24b269dfa4))

## [0.7.3](https://github.com/codesandbox/sandpack/compare/v0.7.2...v0.7.3) (2021-11-25)

**Note:** Version bump only for package sandpack

## [0.7.2](https://github.com/codesandbox/sandpack/compare/v0.7.1...v0.7.2) (2021-11-25)

### Bug Fixes

- **landing:** ui tweaks ([#176](https://github.com/codesandbox/sandpack/issues/176)) ([5ecf9ed](https://github.com/codesandbox/sandpack/commit/5ecf9eddd9184703e19f61739f559cca21b0595c))

### Features

- landing - update showcase structure ([#181](https://github.com/codesandbox/sandpack/issues/181)) ([b35eef3](https://github.com/codesandbox/sandpack/commit/b35eef302f763fb17a29f59c39d76641a6f3484c))

## [0.7.1](https://github.com/codesandbox/sandpack/compare/v0.7.0...v0.7.1) (2021-11-24)

### Bug Fixes

- **bundler:** make sure transpiled files are cut ([ef11a7c](https://github.com/codesandbox/sandpack/commit/ef11a7c5178e6d41200ed0b4aa157c6c73096eba))
- **landing:** remove ssr from index ([#169](https://github.com/codesandbox/sandpack/issues/169)) ([c7e7f2e](https://github.com/codesandbox/sandpack/commit/c7e7f2e5a2c44a2f65c636e93062b5eeca4ee670))

# [0.7.0](https://github.com/codesandbox/sandpack/compare/v0.6.0...v0.7.0) (2021-11-23)

### Features

- landing - parallax logo in banner ([#165](https://github.com/codesandbox/sandpack/issues/165)) ([e2ad885](https://github.com/codesandbox/sandpack/commit/e2ad885eec09a0550bf2bbcc9229d109f6c2bbc8))
- landing - update og content ([#163](https://github.com/codesandbox/sandpack/issues/163)) ([c0c92e6](https://github.com/codesandbox/sandpack/commit/c0c92e6f0c36a47647da129339ec3daaaf3a6378))
- **landing:** add examples section ([#160](https://github.com/codesandbox/sandpack/issues/160)) ([5a0b279](https://github.com/codesandbox/sandpack/commit/5a0b2798dbcaead54f997a0c1445a98f4075a005))
- update card description code snippets ([#166](https://github.com/codesandbox/sandpack/issues/166)) ([7d5706f](https://github.com/codesandbox/sandpack/commit/7d5706fb7610c2ff8e8e5146f84b9884e47221f8))

# [0.6.0](https://github.com/codesandbox/sandpack/compare/v0.5.4...v0.6.0) (2021-11-22)

### Features

- landing - adds gitlab to users section ([#164](https://github.com/codesandbox/sandpack/issues/164)) ([fa885a1](https://github.com/codesandbox/sandpack/commit/fa885a110207cca5db26498bd69f89adc93fbcb4))

## [0.5.4](https://github.com/codesandbox/sandpack/compare/v0.5.3...v0.5.4) (2021-11-19)

**Note:** Version bump only for package sandpack

## [0.5.3](https://github.com/codesandbox/sandpack/compare/v0.5.2...v0.5.3) (2021-11-19)

**Note:** Version bump only for package sandpack

## [0.5.2](https://github.com/codesandbox/sandpack/compare/v0.5.1...v0.5.2) (2021-11-19)

**Note:** Version bump only for package sandpack

## [0.5.1](https://github.com/codesandbox/sandpack/compare/v0.5.0...v0.5.1) (2021-11-19)

**Note:** Version bump only for package sandpack

# [0.5.0](https://github.com/codesandbox/sandpack/compare/v0.4.1...v0.5.0) (2021-11-19)

### Features

- **landing:** advanced usage animated examples ([#157](https://github.com/codesandbox/sandpack/issues/157)) ([fde82a5](https://github.com/codesandbox/sandpack/commit/fde82a5ee120f46cd7fa776a57ff35167e98f0f8))

## [0.4.1](https://github.com/codesandbox/sandpack/compare/v0.4.0...v0.4.1) (2021-11-18)

**Note:** Version bump only for package sandpack

# [0.4.0](https://github.com/codesandbox/sandpack/compare/v0.3.10...v0.4.0) (2021-11-18)

### Features

- **landing:** misc tweaks ([#156](https://github.com/codesandbox/sandpack/issues/156)) ([37109ad](https://github.com/codesandbox/sandpack/commit/37109ad77881e39fd8f2fc777e9407861e888bdf))

## [0.3.10](https://github.com/codesandbox/sandpack/compare/v0.3.9...v0.3.10) (2021-11-18)

**Note:** Version bump only for package sandpack

## [0.3.9](https://github.com/codesandbox/sandpack/compare/v0.3.8...v0.3.9) (2021-11-17)

**Note:** Version bump only for package sandpack

## [0.3.8](https://github.com/codesandbox/sandpack/compare/v0.3.7...v0.3.8) (2021-11-16)

### Bug Fixes

- **landing:** ui feedbacks ([#149](https://github.com/codesandbox/sandpack/issues/149)) ([49bfe6f](https://github.com/codesandbox/sandpack/commit/49bfe6f7bcbcdcf52a6b3a594b51fcef1fc482cd))

## [0.3.7](https://github.com/codesandbox/sandpack/compare/v0.3.6...v0.3.7) (2021-11-16)

**Note:** Version bump only for package sandpack

## [0.3.6](https://github.com/codesandbox/sandpack/compare/v0.3.5...v0.3.6) (2021-11-16)

**Note:** Version bump only for package sandpack

## [0.3.5](https://github.com/codesandbox/sandpack/compare/v0.3.4...v0.3.5) (2021-11-15)

**Note:** Version bump only for package sandpack

## [0.3.4](https://github.com/codesandbox/sandpack/compare/v0.3.3...v0.3.4) (2021-11-15)

**Note:** Version bump only for package sandpack

## [0.3.3](https://github.com/codesandbox/sandpack/compare/v0.3.2...v0.3.3) (2021-11-15)

**Note:** Version bump only for package sandpack

## [0.3.2](https://github.com/codesandbox/sandpack/compare/v0.3.1...v0.3.2) (2021-11-15)

**Note:** Version bump only for package sandpack

## [0.3.1](https://github.com/codesandbox/sandpack/compare/v0.3.0...v0.3.1) (2021-11-15)

### Bug Fixes

- **react:** dedupe deps ([#145](https://github.com/codesandbox/sandpack/issues/145)) ([bc86c31](https://github.com/codesandbox/sandpack/commit/bc86c3160fbf07c8c226f8c2462ffcadd3faac0e))

# [0.3.0](https://github.com/codesandbox/sandpack/compare/v0.2.3...v0.3.0) (2021-11-15)

### Features

- **template:** add vanilla typescript ([#130](https://github.com/codesandbox/sandpack/issues/130)) ([d33eeb9](https://github.com/codesandbox/sandpack/commit/d33eeb9be6809fb40165d97e34a13471ec5faf1b))

## [0.2.3](https://github.com/codesandbox/sandpack/compare/v0.2.2...v0.2.3) (2021-11-11)

**Note:** Version bump only for package sandpack

## [0.2.2](https://github.com/codesandbox/sandpack/compare/v0.2.1...v0.2.2) (2021-11-11)

### Bug Fixes

- **react-layout:** remove max-height limit for print media ([#121](https://github.com/codesandbox/sandpack/issues/121)) ([e0001a5](https://github.com/codesandbox/sandpack/commit/e0001a575b13b17188a0233bab36c38800e6c21b))

## [0.2.1](https://github.com/codesandbox/sandpack/compare/v0.2.0...v0.2.1) (2021-11-10)

**Note:** Version bump only for package sandpack

# [0.2.0](https://github.com/codesandbox/sandpack/compare/v0.1.20...v0.2.0) (2021-11-10)

### Features

- **template:** add react typescript ([#114](https://github.com/codesandbox/sandpack/issues/114)) ([96aaac8](https://github.com/codesandbox/sandpack/commit/96aaac86afc2287a1e96fa95a9836d156a4bc9de))

## [0.1.20](https://github.com/codesandbox/sandpack/compare/v0.1.19...v0.1.20) (2021-11-08)

### Bug Fixes

- **codemirror:** upgrade dependencies ([#125](https://github.com/codesandbox/sandpack/issues/125)) ([7cbf7f1](https://github.com/codesandbox/sandpack/commit/7cbf7f1aa8f07b4826eb8ebbeb1ca5d868b5c4df))

## [0.1.19](https://github.com/codesandbox/sandpack/compare/v0.1.18...v0.1.19) (2021-11-04)

### Bug Fixes

- **bundler:** reduce retry count for jsdelivr if it fails to load ([0712fe1](https://github.com/codesandbox/sandpack/commit/0712fe16ec25df8ca420e3e36c22742711ec2d0b))

## [0.1.18](https://github.com/codesandbox/sandpack/compare/v0.1.17...v0.1.18) (2021-11-04)

**Note:** Version bump only for package sandpack

## [0.1.17](https://github.com/codesandbox/sandpack/compare/v0.1.16...v0.1.17) (2021-11-04)

### Bug Fixes

- **react:** make instructions elements ids unique ([#123](https://github.com/codesandbox/sandpack/issues/123)) ([3bd8a78](https://github.com/codesandbox/sandpack/commit/3bd8a78e87758e97c4bec909d318b5917547f520))

## [0.1.16](https://github.com/codesandbox/sandpack/compare/v0.1.15...v0.1.16) (2021-11-03)

### Bug Fixes

- **react:** do not translate code blocks and error messages ([#117](https://github.com/codesandbox/sandpack/issues/117)) ([c09acfc](https://github.com/codesandbox/sandpack/commit/c09acfcc79bb8456f6bc6d0966ebaa2fdc626256))

### Reverts

- Revert "visual changes" ([f293b0d](https://github.com/codesandbox/sandpack/commit/f293b0dc1007939d39124a6fa2ee0f62d15399a7))
