---
# https://vitepress.dev/reference/default-theme-home-page
layout: home

hero:
  name: 'x-crawl'
  text: 'Flexible Node.js AI-assisted crawler library'
  tagline: Making crawler work more efficient, intelligent and convenient
  image:
    src: '/logo.svg'
    alt: x-crawl
  actions:
    - theme: brand
      text: Get Started
      link: /guide/index
    - theme: alt
      text: View on GitHub
      link: https://github.com/coder-hxl/x-crawl

features:
  - title: 🤖 AI Assistance
    details: Powerful AI assistance function makes crawler work more efficient, intelligent and convenient.
  - title: 🖋️ Flexible writing style
    details: A single crawling API is suitable for multiple configurations, and each configuration method has its own advantages.
  - title: ⚙️ Feature-rich
    details: Support crawling dynamic pages, static pages, interface data and file data.
  - title: ⚒️ Control page
    details: Crawling dynamic pages supports automated operations, keyboard input, event operations, etc.
  - title: 👀 Device fingerprint
    details: Zero configuration or custom configuration to avoid fingerprint recognition and tracking us from different locations.
  - title: 🔥 Asynchronous synchronization
    details: Asynchronous or synchronous crawling modes without switching the crawling API.
  - title: ⏱️ Interval crawling
    details: No interval, fixed interval and random interval, determine whether to crawl with high concurrency.
  - title: 🔄 Retry if failed
    details: Customize the number of retries to avoid crawling failures due to transient problems.
  - title: ➡️ Rotating Agent
    details: With failure retries, custom error times and HTTP status code automatic proxy rotation.
  - title: 🚀 Priority Queue
    details: Depending on the priority of a single crawl target, it can be crawled ahead of other targets.
  - title: 🧾 Record crawling
    details: Controllable crawling information, colored string information will be output in the terminal.
  - title: 🦾 TypeScript
    details: Has a type and implements a complete type through generics.
---
