<?php


namespace app\common\library;

class Email
{
	protected static $instance;
	protected $mail = [];
	protected $_error = "";
	public $options = ["charset" => "utf-8", "debug" => false];
	public static function instance($options = [])
	{
		if (is_null(self::$instance)) {
			self::$instance = new static($options);
		}
		return self::$instance;
	}
	public function __construct($options = [])
	{
		$this->options = \think\Db::name("config")->where("type", "email")->select();
		$securArr = [1 => "tls", 2 => "ssl"];
		$this->mail = new \PHPMailer\PHPMailer\PHPMailer(true);
		$this->mail->CharSet = $this->options["charset"];
		if ($this->options["mail_type"] == 1) {
			$this->mail->SMTPDebug = $this->options["debug"];
			$this->mail->isSMTP();
			$this->mail->SMTPAuth = true;
		} else {
			$this->mail->isMail();
		}
		$this->mail->Host = $this->options["email_smtp1"];
		$this->mail->Username = $this->options["email_user1"];
		$this->mail->Password = $this->options["email_password1"];
		$this->mail->SMTPSecure = "ssl";
		$this->mail->Port = $this->options["email_port1"];
		$this->from($this->options["mail_from"], $this->options["mail_smtp_user"]);
	}
	public function subject($subject)
	{
		$this->mail->Subject = $subject;
		return $this;
	}
	public function from($email, $name = "")
	{
		$this->mail->setFrom($email, $name);
		return $this;
	}
	public function to($email, $name = "")
	{
		$emailArr = $this->buildAddress($email);
		foreach ($emailArr as $address => $name) {
			$this->mail->addAddress($address, $name);
		}
		return $this;
	}
	public function cc($email, $name = "")
	{
		$emailArr = $this->buildAddress($email);
		foreach ($emailArr as $address => $name) {
			$this->mail->addCC($address, $name);
		}
		return $this;
	}
	public function bcc($email, $name = "")
	{
		$emailArr = $this->buildAddress($email);
		foreach ($emailArr as $address => $name) {
			$this->mail->addBCC($address, $name);
		}
		return $this;
	}
	public function message($body, $ishtml = true)
	{
		if ($ishtml) {
			$this->mail->msgHTML($body);
		} else {
			$this->mail->Body = $body;
		}
		return $this;
	}
	public function attachment($path, $name = "")
	{
		$this->mail->addAttachment($path, $name);
		return $this;
	}
	protected function buildAddress($emails)
	{
		$emails = is_array($emails) ? $emails : explode(",", str_replace(";", ",", $emails));
		$result = [];
		foreach ($emails as $key => $value) {
			$email = is_numeric($key) ? $value : $key;
			$result[$email] = is_numeric($key) ? "" : $value;
		}
		return $result;
	}
	public function getError()
	{
		return $this->_error;
	}
	protected function setError($error)
	{
		$this->_error = $error;
	}
	public function send()
	{
		$result = false;
		if (in_array($this->options["mail_type"], [1, 2])) {
			try {
				$result = $this->mail->send();
			} catch (\PHPMailer\PHPMailer\Exception $e) {
				$this->setError($e->getMessage());
			}
			$this->setError($result ? "" : $this->mail->ErrorInfo);
		} else {
			$this->setError(__("Mail already closed"));
		}
		return $result;
	}
}