import { expectError, expectType } from 'tsd';

// @ts-ignore
const playwright = new CodeceptJS.PlaywrightTs();

const str = 'text';
const num = 1;
const position = { x: 100, y: 200 };
const sourcePosition = { x: 10, y: 20 };
const targetPosition = { x: 20, y: 30 };

expectType<Promise<any>>(playwright.usePlaywrightTo(str, () => {}));
expectType<Promise<any>>(playwright.amAcceptingPopups());
expectType<Promise<any>>(playwright.acceptPopup());
expectType<Promise<any>>(playwright.amCancellingPopups());
expectType<Promise<any>>(playwright.cancelPopup());
expectType<Promise<any>>(playwright.seeInPopup(str));
expectType<Promise<any>>(playwright._setPage(str));
expectType<Promise<any>>(playwright._addPopupListener());
expectType<Promise<any>>(playwright._getPageUrl());
expectType<Promise<string | null>>(playwright.grabPopupText());
expectType<Promise<any>>(playwright.amOnPage(str));
expectType<Promise<any>>(playwright.resizeWindow(num, num));
expectType<Promise<any>>(playwright.setPlaywrightRequestHeaders(str));
expectType<Promise<any>>(playwright.moveCursorTo(str, num, num));
expectError(playwright.dragAndDrop(str));
expectType<Promise<any>>(playwright.dragAndDrop(str, str));
expectType<Promise<any>>(playwright.dragAndDrop(str, str, { sourcePosition, targetPosition }));
expectType<Promise<any>>(playwright.refreshPage());
expectType<Promise<any>>(playwright.scrollPageToTop());
expectType<Promise<any>>(playwright.scrollPageToBottom());
expectType<Promise<any>>(playwright.scrollTo(str, num, num));
expectType<Promise<any>>(playwright.seeInTitle(str));
//expectType<Promise<any>>(playwright.grabPageScrollPosition());
expectType<Promise<any>>(playwright.seeTitleEquals(str));
expectType<Promise<any>>(playwright.dontSeeInTitle(str));
expectType<Promise<string>>(playwright.grabTitle());
expectType<Promise<any>>(playwright._locate());
expectType<Promise<any>>(playwright._locateCheckable());
expectType<Promise<any>>(playwright._locateClickable());
expectType<Promise<any>>(playwright._locateFields());
expectType<Promise<any>>(playwright.switchToNextTab());
expectType<Promise<any>>(playwright.switchToPreviousTab());
expectType<Promise<any>>(playwright.closeCurrentTab());
expectType<Promise<any>>(playwright.closeOtherTabs());
expectType<Promise<any>>(playwright.openNewTab());
expectType<Promise<number>>(playwright.grabNumberOfOpenTabs());
expectType<Promise<any>>(playwright.seeElement(str));
expectType<Promise<any>>(playwright.dontSeeElement(str));
expectType<Promise<any>>(playwright.seeElementInDOM(str));
expectType<Promise<any>>(playwright.dontSeeElementInDOM(str));
expectType<Promise<void>>(playwright.handleDownloads(str));
expectType<Promise<any>>(playwright.click(str));
expectType<Promise<any>>(playwright.click(str, str));
expectType<Promise<any>>(playwright.click(str, null, { position }));
expectType<Promise<any>>(playwright.clickLink());
expectType<Promise<any>>(playwright.forceClick(str));
expectType<Promise<any>>(playwright.focus(str));
expectType<Promise<any>>(playwright.blur(str));
expectType<Promise<any>>(playwright.doubleClick(str));
expectType<Promise<any>>(playwright.rightClick(str));
expectType<Promise<any>>(playwright.checkOption(str));
expectType<Promise<any>>(playwright.uncheckOption(str));
expectType<Promise<any>>(playwright.seeCheckboxIsChecked(str));
expectType<Promise<any>>(playwright.dontSeeCheckboxIsChecked(str));
expectType<Promise<any>>(playwright.pressKeyDown(str));
expectType<Promise<any>>(playwright.pressKeyUp(str));
expectType<Promise<any>>(playwright.pressKey(str));
expectType<Promise<any>>(playwright.type(str));
expectType<Promise<any>>(playwright.fillField(str, str));
expectType<Promise<any>>(playwright.clearField(str));
expectType<Promise<any>>(playwright.appendField(str, str));
expectType<Promise<any>>(playwright.seeInField(str, str));
expectType<Promise<any>>(playwright.dontSeeInField(str, str));
expectType<Promise<any>>(playwright.attachFile(str, str));
expectType<Promise<any>>(playwright.selectOption(str, str));
expectType<Promise<number>>(playwright.grabNumberOfVisibleElements(str));
expectType<Promise<any>>(playwright.seeInCurrentUrl(str));
expectType<Promise<any>>(playwright.dontSeeInCurrentUrl(str));
expectType<Promise<any>>(playwright.seeCurrentUrlEquals(str));
expectType<Promise<any>>(playwright.dontSeeCurrentUrlEquals(str));
expectType<Promise<any>>(playwright.see(str));
expectType<Promise<any>>(playwright.seeTextEquals(str));
expectType<Promise<any>>(playwright.dontSee(str));
expectType<Promise<string>>(playwright.grabSource());
expectType<Promise<any[]>>(playwright.grabBrowserLogs());
expectType<Promise<string>>(playwright.grabCurrentUrl());
expectType<Promise<any>>(playwright.seeInSource(str));
expectType<Promise<any>>(playwright.dontSeeInSource(str));
expectType<Promise<any>>(playwright.seeNumberOfElements(str, num));
expectType<Promise<any>>(playwright.seeNumberOfVisibleElements(str, num));
expectType<Promise<any>>(playwright.setCookie({ name: str, value: str }));
expectType<Promise<any>>(playwright.seeCookie(str));
expectType<Promise<any>>(playwright.dontSeeCookie(str));
expectType<Promise<any>>(playwright.grabCookie());
expectType<Promise<any>>(playwright.clearCookie());
expectType<Promise<any>>(playwright.executeScript(() => {}));
expectType<Promise<string>>(playwright.grabTextFrom(str));
expectType<Promise<string[]>>(playwright.grabTextFromAll(str));
expectType<Promise<string>>(playwright.grabValueFrom(str));
expectType<Promise<string[]>>(playwright.grabValueFromAll(str));
expectType<Promise<string>>(playwright.grabHTMLFrom(str));
expectType<Promise<string[]>>(playwright.grabHTMLFromAll(str));
expectType<Promise<string>>(playwright.grabCssPropertyFrom(str, str));
expectType<Promise<string[]>>(playwright.grabCssPropertyFromAll(str, str));
expectType<Promise<any>>(playwright.seeCssPropertiesOnElements(str, str));
expectType<Promise<any>>(playwright.seeAttributesOnElements(str, str));
expectType<Promise<any>>(playwright.dragSlider(str, num));
expectType<Promise<string>>(playwright.grabAttributeFrom(str, str));
expectType<Promise<string[]>>(playwright.grabAttributeFromAll(str, str));
expectType<Promise<any>>(playwright.saveElementScreenshot(str, str));
expectType<Promise<any>>(playwright.saveScreenshot(str));
expectType<Promise<object>>(playwright.makeApiRequest(str, str, str));
expectType<Promise<any>>(playwright.wait(num));
expectType<Promise<any>>(playwright.waitForEnabled(str));
expectType<Promise<any>>(playwright.waitForValue(str, str));
expectType<Promise<any>>(playwright.waitNumberOfVisibleElements(str, num));
expectType<Promise<any>>(playwright.waitForClickable(str));
expectType<Promise<any>>(playwright.waitForElement(str));
expectType<Promise<any>>(playwright.waitForVisible(str));
expectType<Promise<any>>(playwright.waitForInvisible(str));
expectType<Promise<any>>(playwright.waitToHide(str));
expectType<Promise<any>>(playwright.waitInUrl(str));
expectType<Promise<any>>(playwright.waitUrlEquals(str));
expectType<Promise<any>>(playwright.waitForText(str));
expectType<Promise<any>>(playwright.waitForRequest(str));
expectType<Promise<any>>(playwright.waitForResponse(str));
expectType<Promise<any>>(playwright.switchTo());
expectType<Promise<any>>(playwright.waitForFunction(() => { }));
expectType<Promise<any>>(playwright.waitForNavigation(str));
expectType<Promise<any>>(playwright.waitForDetached(str));
expectType<Promise<any>>(playwright.grabDataFromPerformanceTiming());
//expectType<Promise<number>>(playwright.grabElementBoundingRect(str));
expectType<Promise<any>>(playwright.mockRoute(str));
expectType<Promise<any>>(playwright.stopMockingRoute(str));

expectType<Promise<any>>(playwright.startRecordingTraffic());
expectType<Promise<any>>(playwright.stopRecordingTraffic());
expectError(playwright.seeTraffic());
expectError(playwright.seeTraffic(str));
expectType<Promise<any>>(playwright.seeTraffic({ name: str, url: str }));
expectError(playwright.seeTraffic({ name: str }));
expectError(playwright.seeTraffic({ url: str }));
expectError(playwright.dontSeeTraffic());
expectError(playwright.dontSeeTraffic(str));
expectType<Promise<any>>(playwright.dontSeeTraffic({ name: str, url: str }));
expectType<Promise<any>>(playwright.dontSeeTraffic({ name: str, url: /hello/ }));
expectError(playwright.dontSeeTraffic({ name: str }));
expectError(playwright.dontSeeTraffic({ url: str }));
