import { expectError, expectType } from 'tsd';

// @ts-ignore
const playwright = new CodeceptJS.Playwright();

const str = 'text';
const num = 1;
const position = { x: 100, y: 200 };
const sourcePosition = { x: 10, y: 20 };
const targetPosition = { x: 20, y: 30 };

expectType<void>(playwright.usePlaywrightTo(str, () => {}));
expectType<void>(playwright.amAcceptingPopups());
expectType<void>(playwright.acceptPopup());
expectType<void>(playwright.amCancellingPopups());
expectType<void>(playwright.cancelPopup());
expectType<void>(playwright.seeInPopup(str));
expectType<void>(playwright._setPage(str));
expectType<void>(playwright._addPopupListener());
expectType<void>(playwright._getPageUrl());
expectType<Promise<string | null>>(playwright.grabPopupText());
expectType<void>(playwright._createContextPage());
expectType<void>(playwright._createContextPage({}));
expectType<void>(playwright.amOnPage(str));
expectType<void>(playwright.resizeWindow(num, num));
expectType<void>(playwright.setPlaywrightRequestHeaders(str));
expectType<void>(playwright.moveCursorTo(str, num, num));
expectError(playwright.dragAndDrop(str));
expectType<void>(playwright.dragAndDrop(str, str));
expectType<void>(playwright.dragAndDrop(str, str, { sourcePosition, targetPosition }));
expectType<void>(playwright.restartBrowser());
expectType<void>(playwright.restartBrowser({}));
expectType<void>(playwright.refreshPage());
expectType<void>(playwright.scrollPageToTop());
expectType<void>(playwright.scrollPageToBottom());
expectType<void>(playwright.scrollTo(str, num, num));
expectType<void>(playwright.seeInTitle(str));
//playwright.grabPageScrollPosition();
expectType<void>(playwright.seeTitleEquals(str));
expectType<void>(playwright.dontSeeInTitle(str));
expectType<Promise<string>>(playwright.grabTitle());
expectType<void>(playwright._locate());
expectType<void>(playwright._locateCheckable());
expectType<void>(playwright._locateClickable());
expectType<void>(playwright._locateFields());
expectType<void>(playwright.switchToNextTab());
expectType<void>(playwright.switchToPreviousTab());
expectType<void>(playwright.closeCurrentTab());
expectType<void>(playwright.closeOtherTabs());
expectType<void>(playwright.openNewTab());
expectType<Promise<number>>(playwright.grabNumberOfOpenTabs());
expectType<void>(playwright.seeElement(str));
expectType<void>(playwright.dontSeeElement(str));
expectType<void>(playwright.seeElementInDOM(str));
expectType<void>(playwright.dontSeeElementInDOM(str));
expectType<Promise<void>>(playwright.handleDownloads(str));
expectType<void>(playwright.click(str));
expectType<void>(playwright.click(str, str));
expectType<void>(playwright.click(str, null, { position }));
expectType<void>(playwright.clickLink());
expectType<void>(playwright.forceClick(str));
expectType<void>(playwright.focus(str));
expectType<void>(playwright.blur(str));
expectType<void>(playwright.doubleClick(str));
expectType<void>(playwright.rightClick(str));
expectType<void>(playwright.checkOption(str));
expectType<void>(playwright.uncheckOption(str));
expectType<void>(playwright.seeCheckboxIsChecked(str));
expectType<void>(playwright.dontSeeCheckboxIsChecked(str));
expectType<void>(playwright.pressKeyDown(str));
expectType<void>(playwright.pressKeyUp(str));
expectType<void>(playwright.pressKey(str));
expectType<void>(playwright.type(str));
expectType<void>(playwright.fillField(str, str));
expectType<void>(playwright.clearField(str));
expectType<void>(playwright.appendField(str, str));
expectType<void>(playwright.seeInField(str, str));
expectType<void>(playwright.dontSeeInField(str, str));
expectType<void>(playwright.attachFile(str, str));
expectType<void>(playwright.selectOption(str, str));
expectType<Promise<number>>(playwright.grabNumberOfVisibleElements(str));
expectType<void>(playwright.seeInCurrentUrl(str));
expectType<void>(playwright.dontSeeInCurrentUrl(str));
expectType<void>(playwright.seeCurrentUrlEquals(str));
expectType<void>(playwright.dontSeeCurrentUrlEquals(str));
expectType<void>(playwright.see(str));
expectType<void>(playwright.seeTextEquals(str));
expectType<void>(playwright.dontSee(str));
expectType<Promise<string>>(playwright.grabSource());
expectType<Promise<any[]>>(playwright.grabBrowserLogs());
expectType<Promise<string>>(playwright.grabCurrentUrl());
expectType<void>(playwright.seeInSource(str));
expectType<void>(playwright.dontSeeInSource(str));
expectType<void>(playwright.seeNumberOfElements(str, num));
expectType<void>(playwright.seeNumberOfVisibleElements(str, num));
expectType<void>(playwright.setCookie({ name: str, value: str }));
expectType<void>(playwright.seeCookie(str));
expectType<void>(playwright.dontSeeCookie(str));
expectType<any>(playwright.grabCookie());
expectType<void>(playwright.clearCookie());
expectType<Promise<any>>(playwright.executeScript(() => {}));
expectType<Promise<string>>(playwright.grabTextFrom(str));
expectType<Promise<string[]>>(playwright.grabTextFromAll(str));
expectType<Promise<string>>(playwright.grabValueFrom(str));
expectType<Promise<string[]>>(playwright.grabValueFromAll(str));
expectType<Promise<string>>(playwright.grabHTMLFrom(str));
expectType<Promise<string[]>>(playwright.grabHTMLFromAll(str));
expectType<Promise<string>>(playwright.grabCssPropertyFrom(str, str));
expectType<Promise<string[]>>(playwright.grabCssPropertyFromAll(str, str));
expectType<void>(playwright.seeCssPropertiesOnElements(str, str));
expectType<void>(playwright.seeAttributesOnElements(str, str));
expectType<void>(playwright.dragSlider(str, num));
expectType<Promise<string>>(playwright.grabAttributeFrom(str, str));
expectType<Promise<string[]>>(playwright.grabAttributeFromAll(str, str));
expectType<void>(playwright.saveElementScreenshot(str, str));
expectType<void>(playwright.saveScreenshot(str));
expectType<Promise<object>>(playwright.makeApiRequest(str, str, str));
expectType<void>(playwright.wait(num));
expectType<void>(playwright.waitForEnabled(str));
expectType<void>(playwright.waitForValue(str, str));
expectType<void>(playwright.waitNumberOfVisibleElements(str, num));
expectType<void>(playwright.waitForClickable(str));
expectType<void>(playwright.waitForElement(str));
expectType<void>(playwright.waitForVisible(str));
expectType<void>(playwright.waitForInvisible(str));
expectType<void>(playwright.waitToHide(str));
expectType<void>(playwright.waitInUrl(str));
expectType<void>(playwright.waitUrlEquals(str));
expectType<void>(playwright.waitForText(str));
expectType<void>(playwright.waitForRequest(str));
expectType<void>(playwright.waitForResponse(str));
expectType<void>(playwright.switchTo());
expectType<void>(playwright.waitForFunction(() => { }));
expectType<void>(playwright.waitForNavigation(str));
expectType<void>(playwright.waitForDetached(str));
expectType<void>(playwright.grabDataFromPerformanceTiming());
//expectType<Promise<number>>(playwright.grabElementBoundingRect(str));
expectType<void>(playwright.mockRoute(str));
expectType<void>(playwright.stopMockingRoute(str));

expectType<void>(playwright.startRecordingTraffic());
expectType<void>(playwright.stopRecordingTraffic());
expectError(playwright.seeTraffic());
expectError(playwright.seeTraffic(str));
expectError(playwright.seeTraffic({ name: str }));
expectError(playwright.seeTraffic({ url: str }));
expectType<void>(playwright.seeTraffic({ name: str, url: str }));
expectError(playwright.dontSeeTraffic());
expectError(playwright.dontSeeTraffic(str));
expectType<void>(playwright.dontSeeTraffic({ name: str, url: str }));
expectType<void>(playwright.dontSeeTraffic({ name: str, url: /hello/ }));
expectError(playwright.dontSeeTraffic({ name: str }));
expectError(playwright.dontSeeTraffic({ url: str }));
