---
permalink: /helpers/SoftExpectHelper
editLink: false
sidebar: auto
title: SoftExpectHelper
---

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## SoftAssertHelper

**Extends ExpectHelper**

SoftAssertHelper is a utility class for performing soft assertions.
Unlike traditional assertions that stop the execution on failure,
soft assertions allow the execution to continue and report all failures at the end.

### Examples

Zero-configuration when paired with other helpers like REST, Playwright:

```js
// inside codecept.conf.js
{
  helpers: {
    Playwright: {...},
    SoftExpectHelper: {},
  }
}
```

```js
// in scenario
I.softExpectEqual('a', 'b')
I.flushSoftAssertions() // Throws an error if any soft assertions have failed. The error message contains all the accumulated failures.
```

## Methods

### flushSoftAssertions

Throws an error if any soft assertions have failed.
The error message contains all the accumulated failures.

- Throws **[Error][1]** If there are any soft assertion failures.

### softAssert

Performs a soft assertion by executing the provided assertion function.
If the assertion fails, the error is caught and stored without halting the execution.

#### Parameters

- `assertionFn` **[Function][2]** The assertion function to execute.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectAbove

Softly asserts that the target data is above a specified value.

#### Parameters

- `targetData` **any** The data to check.
- `aboveThan` **any** The value that the target data should be above.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectBelow

Softly asserts that the target data is below a specified value.

#### Parameters

- `targetData` **any** The data to check.
- `belowThan` **any** The value that the target data should be below.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectContain

Softly asserts that a value contains the expected value.

#### Parameters

- `actualValue` **any** The actual value.
- `expectedValueToContain` **any** The value that should be contained within the actual value.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectDeepEqual

Softly asserts that two values are deeply equal.

#### Parameters

- `actualValue` **any** The actual value.
- `expectedValue` **any** The expected value.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectDeepEqualExcluding

Softly asserts that two objects are deeply equal, excluding specified fields.

#### Parameters

- `actualValue` **[Object][4]** The actual object.
- `expectedValue` **[Object][4]** The expected object.
- `fieldsToExclude` **[Array][5]<[string][3]>** The fields to exclude from the comparison.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectDeepIncludeMembers

Softly asserts that an array (superset) deeply includes all members of another array (set).

#### Parameters

- `superset` **[Array][5]** The array that should contain the expected members.
- `set` **[Array][5]** The array with members that should be included.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectDeepMembers

Softly asserts that two arrays have deep equality, considering members in any order.

#### Parameters

- `actualValue` **[Array][5]** The actual array.
- `expectedValue` **[Array][5]** The expected array.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectEmpty

Softly asserts that the target data is empty.

#### Parameters

- `targetData` **any** The data to check.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectEndsWith

Softly asserts that a value ends with the expected value.

#### Parameters

- `actualValue` **any** The actual value.
- `expectedValueToEndWith` **any** The value that the actual value should end with.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectEqual

Softly asserts that two values are equal.

#### Parameters

- `actualValue` **any** The actual value.
- `expectedValue` **any** The expected value.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectEqualIgnoreCase

Softly asserts that two values are equal, ignoring case.

#### Parameters

- `actualValue` **[string][3]** The actual string value.
- `expectedValue` **[string][3]** The expected string value.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectFalse

Softly asserts that the target data is false.

#### Parameters

- `targetData` **any** The data to check.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectHasAProperty

Softly asserts that the target data has a property with the specified name.

#### Parameters

- `targetData` **any** The data to check.
- `propertyName` **[string][3]** The property name to check for.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectHasProperty

Softly asserts that the target data has the specified property.

#### Parameters

- `targetData` **any** The data to check.
- `propertyName` **[string][3]** The property name to check for.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion
  fails.

### softExpectJsonSchema

Softly asserts that the target data matches the given JSON schema.

#### Parameters

- `targetData` **any** The data to validate.
- `jsonSchema` **[Object][4]** The JSON schema to validate against.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectJsonSchemaUsingAJV

Softly asserts that the target data matches the given JSON schema using AJV.

#### Parameters

- `targetData` **any** The data to validate.
- `jsonSchema` **[Object][4]** The JSON schema to validate against.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.
- `ajvOptions` **[Object][4]** Options to pass to AJV.

### softExpectLengthAboveThan

Softly asserts that the length of the target data is above a specified value.

#### Parameters

- `targetData` **any** The data to check.
- `lengthAboveThan` **[number][6]** The length that the target data should be above.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectLengthBelowThan

Softly asserts that the length of the target data is below a specified value.

#### Parameters

- `targetData` **any** The data to check.
- `lengthBelowThan` **[number][6]** The length that the target data should be below.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectLengthOf

Softly asserts that the target data has a specified length.

#### Parameters

- `targetData` **any** The data to check.
- `length` **[number][6]** The expected length.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectMatchesPattern

Softly asserts that a value matches the expected pattern.

#### Parameters

- `actualValue` **any** The actual value.
- `expectedPattern` **any** The pattern the value should match.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectNotContain

Softly asserts that a value does not contain the expected value.

#### Parameters

- `actualValue` **any** The actual value.
- `expectedValueToNotContain` **any** The value that should not be contained within the actual value.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectNotDeepEqual

Softly asserts that two values are not deeply equal.

#### Parameters

- `actualValue` **any** The actual value.
- `expectedValue` **any** The expected value.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectNotEndsWith

Softly asserts that a value does not end with the expected value.

#### Parameters

- `actualValue` **any** The actual value.
- `expectedValueToNotEndWith` **any** The value that the actual value should not end with.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectNotEqual

Softly asserts that two values are not equal.

#### Parameters

- `actualValue` **any** The actual value.
- `expectedValue` **any** The expected value.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectNotStartsWith

Softly asserts that a value does not start with the expected value.

#### Parameters

- `actualValue` **any** The actual value.
- `expectedValueToNotStartWith` **any** The value that the actual value should not start with.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectStartsWith

Softly asserts that a value starts with the expected value.

#### Parameters

- `actualValue` **any** The actual value.
- `expectedValueToStartWith` **any** The value that the actual value should start with.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectToBeA

Softly asserts that the target data is of a specific type.

#### Parameters

- `targetData` **any** The data to check.
- `type` **[string][3]** The expected type (e.g., 'string', 'number').
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectToBeAn

Softly asserts that the target data is of a specific type (alternative for articles).

#### Parameters

- `targetData` **any** The data to check.
- `type` **[string][3]** The expected type (e.g., 'string', 'number').
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

### softExpectTrue

Softly asserts that the target data is true.

#### Parameters

- `targetData` **any** The data to check.
- `customErrorMsg` **[string][3]** A custom error message to display if the assertion fails.

[1]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Error
[2]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Statements/function
[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String
[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object
[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array
[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number
