---
permalink: /helpers/Protractor
editLink: false
sidebar: auto
title: Protractor
---

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## Protractor

**Extends Helper**

Protractor helper is based on [Protractor library][1] and used for testing web applications.

Protractor requires [Selenium Server and ChromeDriver/GeckoDriver to be installed][2].
To test non-Angular applications please make sure you have `angular: false` in configuration file.

### Configuration

This helper should be configured in codecept.conf.ts or codecept.conf.js

*   `url` - base url of website to be tested
*   `browser` - browser in which perform testing
*   `angular` : disable this option to run tests for non-Angular applications.
*   `driver` - which protractor driver to use (local, direct, session, hosted, sauce, browserstack). By default set to 'hosted' which requires selenium server to be started.
*   `restart`  - restart browser between tests.
*   `smartWait`: (optional) **enables [SmartWait][3]**; wait for additional milliseconds for element to appear. Enable for 5 secs: "smartWait": 5000
*   `disableScreenshots`   - don't save screenshot on failure
*   `fullPageScreenshots`  - make full page screenshots on failure.
*   `uniqueScreenshotNames`   - option to prevent screenshot override if you have scenarios with the same name in different suites
*   `keepBrowserState`   - keep browser state between tests when `restart` set to false.
*   `seleniumAddress` - Selenium address to connect (default: [http://localhost:4444/wd/hub][4])
*   `rootElement` - Root element of AngularJS application (default: body)
*   `getPageTimeout` (optional) sets default timeout for a page to be loaded. 10000 by default.
*   `waitForTimeout`: (optional) sets default wait time in *ms* for all `wait*` functions. 1000 by default.
*   `scriptsTimeout`: (optional) timeout in milliseconds for each script run on the browser, 10000 by default.
*   `windowSize`: (optional) default window size. Set to `maximize` or a dimension in the format `640x480`.
*   `manualStart`  - do not start browser before a test, start it manually inside a helper with `this.helpers.WebDriver._startBrowser()`
*   `capabilities`: {} - list of [Desired Capabilities][5]
*   `proxy`: set proxy settings

other options are the same as in [Protractor config][6].

#### Sample Config

```json
{
   "helpers": {
     "Protractor" : {
       "url": "http://localhost",
       "browser": "chrome",
       "smartWait": 5000,
       "restart": false
     }
   }
}
```

#### Config for Non-Angular application:

```json
{
   "helpers": {
     "Protractor" : {
       "url": "http://localhost",
       "browser": "chrome",
       "angular": false
     }
   }
}
```

#### Config for Headless Chrome

```json
{
   "helpers": {
     "Protractor" : {
       "url": "http://localhost",
       "browser": "chrome",
       "capabilities": {
         "chromeOptions": {
           "args": [ "--headless", "--disable-gpu", "--no-sandbox" ]
         }
       }
     }
   }
}
```

## Access From Helpers

Receive a WebDriverIO client from a custom helper by accessing `browser` property:

```js
this.helpers['Protractor'].browser
```

## Methods

### Parameters

*   `config` &#x20;

### _getWindowHandle

Get the window handle relative to the current handle. i.e. the next handle or the previous.

#### Parameters

*   `offset` **[Number][7]** Offset from current handle index. i.e. offset < 0 will go to the previous handle and positive number will go to the next window handle in sequence. 

### _locate

Get elements by different locator types, including strict locator
Should be used in custom helpers:

```js
this.helpers['Protractor']._locate({name: 'password'}).then //...
```

To use SmartWait and wait for element to appear on a page, add `true` as second arg:

```js
this.helpers['Protractor']._locate({name: 'password'}, true).then //...
```

#### Parameters

*   `locator` &#x20;
*   `smartWait`   

### _locateCheckable

Find a checkbox by providing human readable text:

```js
this.helpers['Protractor']._locateCheckable('I agree with terms and conditions').then // ...
```

#### Parameters

*   `locator` &#x20;

### _locateClickable

Find a clickable element by providing human readable text:

```js
this.helpers['Protractor']._locateClickable('Next page').then // ...
```

#### Parameters

*   `locator` &#x20;

### _locateFields

Find field elements by providing human readable text:

```js
this.helpers['Protractor']._locateFields('Your email').then // ...
```

#### Parameters

*   `locator` &#x20;

### acceptPopup

Accepts the active JavaScript native popup window, as created by window.alert|window.confirm|window.prompt.
Don't confuse popups with modal windows, as created by [various
libraries][8]. Appium: support only web testing

### amInsideAngularApp

Enters Angular mode (switched on by default)
Should be used after "amOutsideAngularApp"

### amOnPage

Opens a web page in a browser. Requires relative or absolute url.
If url starts with `/`, opens a web page of a site defined in `url` config parameter.

```js
I.amOnPage('/'); // opens main page of website
I.amOnPage('https://github.com'); // opens github
I.amOnPage('/login'); // opens a login page
```

#### Parameters

*   `url` **[string][9]** url path or global url.

Returns **void** automatically synchronized promise through #recorder

### amOutsideAngularApp

Switch to non-Angular mode,
start using WebDriver instead of Protractor in this session

### appendField

Appends text to a input field or textarea.
Field is located by name, label, CSS or XPath

```js
I.appendField('#myTextField', 'appended');
// typing secret
I.appendField('password', secret('123456'));
```

#### Parameters

*   `field` **([string][9] | [object][10])** located by label|name|CSS|XPath|strict locator
*   `value` **[string][9]** text value to append.

Returns **void** automatically synchronized promise through #recorder

### attachFile

Attaches a file to element located by label, name, CSS or XPath
Path to file is relative current codecept directory (where codecept.conf.ts or codecept.conf.js is located).
File will be uploaded to remote system (if tests are running remotely).

```js
I.attachFile('Avatar', 'data/avatar.jpg');
I.attachFile('form input[name=avatar]', 'data/avatar.jpg');
```

#### Parameters

*   `locator` **([string][9] | [object][10])** field located by label|name|CSS|XPath|strict locator.
*   `pathToFile` **[string][9]** local file path relative to codecept.conf.ts or codecept.conf.js config file.

Returns **void** automatically synchronized promise through #recorder

### cancelPopup

Dismisses the active JavaScript popup, as created by window.alert|window.confirm|window.prompt.

### checkOption

Selects a checkbox or radio button.
Element is located by label or name or CSS or XPath.

The second parameter is a context (CSS or XPath locator) to narrow the search.

```js
I.checkOption('#agree');
I.checkOption('I Agree to Terms and Conditions');
I.checkOption('agree', '//form');
```

#### Parameters

*   `field` **([string][9] | [object][10])** checkbox located by label | name | CSS | XPath | strict locator.
*   `context` **([string][9]? | [object][10])** (optional, `null` by default) element located by CSS | XPath | strict locator. 

Returns **void** automatically synchronized promise through #recorder

### clearCookie

Clears a cookie by name,
if none provided clears all cookies.

```js
I.clearCookie();
I.clearCookie('test');
```

#### Parameters

*   `cookie` **[string][9]?** (optional, `null` by default) cookie name 

### clearField

Clears a `<textarea>` or text `<input>` element's value.

```js
I.clearField('Email');
I.clearField('user[email]');
I.clearField('#email');
```

#### Parameters

*   `field` &#x20;
*   `editable` **([string][9] | [object][10])** field located by label|name|CSS|XPath|strict locator.

Returns **void** automatically synchronized promise through #recorder.

### click

Perform a click on a link or a button, given by a locator.
If a fuzzy locator is given, the page will be searched for a button, link, or image matching the locator string.
For buttons, the "value" attribute, "name" attribute, and inner text are searched. For links, the link text is searched.
For images, the "alt" attribute and inner text of any parent links are searched.

The second parameter is a context (CSS or XPath locator) to narrow the search.

```js
// simple link
I.click('Logout');
// button of form
I.click('Submit');
// CSS button
I.click('#form input[type=submit]');
// XPath
I.click('//form/*[@type=submit]');
// link in context
I.click('Logout', '#nav');
// using strict locator
I.click({css: 'nav a.login'});
```

#### Parameters

*   `locator` **([string][9] | [object][10])** clickable link or button located by text, or any element located by CSS|XPath|strict locator.
*   `context` **([string][9]? | [object][10] | null)** (optional, `null` by default) element to search in CSS|XPath|Strict locator. 

Returns **void** automatically synchronized promise through #recorder

### closeCurrentTab

Close current tab

```js
I.closeCurrentTab();
```

### closeOtherTabs

Close all tabs except for the current one.

```js
I.closeOtherTabs();
```

### dontSee

Opposite to `see`. Checks that a text is not present on a page.
Use context parameter to narrow down the search.

```js
I.dontSee('Login'); // assume we are already logged in.
I.dontSee('Login', '.nav'); // no login inside .nav element
```

#### Parameters

*   `text` **[string][9]** which is not present.
*   `context` **([string][9] | [object][10])?** (optional) element located by CSS|XPath|strict locator in which to perfrom search. 

Returns **void** automatically synchronized promise through #recorder

### dontSeeCheckboxIsChecked

Verifies that the specified checkbox is not checked.

```js
I.dontSeeCheckboxIsChecked('#agree'); // located by ID
I.dontSeeCheckboxIsChecked('I agree to terms'); // located by label
I.dontSeeCheckboxIsChecked('agree'); // located by name
```

#### Parameters

*   `field` **([string][9] | [object][10])** located by label|name|CSS|XPath|strict locator.

Returns **void** automatically synchronized promise through #recorder

### dontSeeCookie

Checks that cookie with given name does not exist.

```js
I.dontSeeCookie('auth'); // no auth cookie
```

#### Parameters

*   `name` **[string][9]** cookie name.

Returns **void** automatically synchronized promise through #recorder

### dontSeeCurrentUrlEquals

Checks that current url is not equal to provided one.
If a relative url provided, a configured url will be prepended to it.

```js
I.dontSeeCurrentUrlEquals('/login'); // relative url are ok
I.dontSeeCurrentUrlEquals('http://mysite.com/login'); // absolute urls are also ok
```

#### Parameters

*   `url` **[string][9]** value to check.

Returns **void** automatically synchronized promise through #recorder

### dontSeeElement

Opposite to `seeElement`. Checks that element is not visible (or in DOM)

```js
I.dontSeeElement('.modal'); // modal is not shown
```

#### Parameters

*   `locator` **([string][9] | [object][10])** located by CSS|XPath|Strict locator.

Returns **void** automatically synchronized promise through #recorder

### dontSeeElementInDOM

Opposite to `seeElementInDOM`. Checks that element is not on page.

```js
I.dontSeeElementInDOM('.nav'); // checks that element is not on page visible or not
```

#### Parameters

*   `locator` **([string][9] | [object][10])** located by CSS|XPath|Strict locator.

Returns **void** automatically synchronized promise through #recorder

### dontSeeInCurrentUrl

Checks that current url does not contain a provided fragment.

#### Parameters

*   `url` **[string][9]** value to check.

Returns **void** automatically synchronized promise through #recorder

### dontSeeInField

Checks that value of input field or textarea doesn't equal to given value
Opposite to `seeInField`.

```js
I.dontSeeInField('email', 'user@user.com'); // field by name
I.dontSeeInField({ css: 'form input.email' }, 'user@user.com'); // field by CSS
```

#### Parameters

*   `field` **([string][9] | [object][10])** located by label|name|CSS|XPath|strict locator.
*   `value` **([string][9] | [object][10])** value to check.

Returns **void** automatically synchronized promise through #recorder

### dontSeeInSource

Checks that the current page does not contains the given string in its raw source code.

```js
I.dontSeeInSource('<!--'); // no comments in source
```

#### Parameters

*   `text` &#x20;
*   `value` **[string][9]** to check.

Returns **void** automatically synchronized promise through #recorder

### dontSeeInTitle

Checks that title does not contain text.

```js
I.dontSeeInTitle('Error');
```

#### Parameters

*   `text` **[string][9]** value to check.

Returns **void** automatically synchronized promise through #recorder

### doubleClick

Performs a double-click on an element matched by link|button|label|CSS or XPath.
Context can be specified as second parameter to narrow search.

```js
I.doubleClick('Edit');
I.doubleClick('Edit', '.actions');
I.doubleClick({css: 'button.accept'});
I.doubleClick('.btn.edit');
```

#### Parameters

*   `locator` **([string][9] | [object][10])** clickable link or button located by text, or any element located by CSS|XPath|strict locator.
*   `context` **([string][9]? | [object][10])** (optional, `null` by default) element to search in CSS|XPath|Strict locator. 

Returns **void** automatically synchronized promise through #recorder

### dragAndDrop

Drag an item to a destination element.

```js
I.dragAndDrop('#dragHandle', '#container');
```

#### Parameters

*   `srcElement` **([string][9] | [object][10])** located by CSS|XPath|strict locator.
*   `destElement` **([string][9] | [object][10])** located by CSS|XPath|strict locator.

Returns **void** automatically synchronized promise through #recorder

### executeAsyncScript

Executes async script on page.
Provided function should execute a passed callback (as first argument) to signal it is finished.

Example: In Vue.js to make components completely rendered we are waiting for [nextTick][11].

```js
I.executeAsyncScript(function(done) {
  Vue.nextTick(done); // waiting for next tick
});
```

By passing value to `done()` function you can return values.
Additional arguments can be passed as well, while `done` function is always last parameter in arguments list.

```js
let val = await I.executeAsyncScript(function(url, done) {
  // in browser context
  $.ajax(url, { success: (data) => done(data); }
}, 'http://ajax.callback.url/');
```

#### Parameters

*   `fn` **([string][9] | [function][12])** function to be executed in browser context.
*   `args` **...any** to be passed to function.

Returns **[Promise][13]<any>** script return value

### executeScript

Executes sync script on a page.
Pass arguments to function as additional parameters.
Will return execution result to a test.
In this case you should use async function and await to receive results.

Example with jQuery DatePicker:

```js
// change date of jQuery DatePicker
I.executeScript(function() {
  // now we are inside browser context
  $('date').datetimepicker('setDate', new Date());
});
```

Can return values. Don't forget to use `await` to get them.

```js
let date = await I.executeScript(function(el) {
  // only basic types can be returned
  return $(el).datetimepicker('getDate').toString();
}, '#date'); // passing jquery selector
```

#### Parameters

*   `fn` **([string][9] | [function][12])** function to be executed in browser context.
*   `args` **...any** to be passed to function.

Returns **[Promise][13]<any>** script return value

### fillField

Fills a text field or textarea, after clearing its value, with the given string.
Field is located by name, label, CSS, or XPath.

```js
// by label
I.fillField('Email', 'hello@world.com');
// by name
I.fillField('password', secret('123456'));
// by CSS
I.fillField('form#login input[name=username]', 'John');
// or by strict locator
I.fillField({css: 'form#login input[name=username]'}, 'John');
```

#### Parameters

*   `field` **([string][9] | [object][10])** located by label|name|CSS|XPath|strict locator.
*   `value` **([string][9] | [object][10])** text value to fill.

Returns **void** automatically synchronized promise through #recorder

### grabAttributeFrom

Retrieves an attribute from an element located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async with `await`** operator.
If more than one element is found - attribute of first element is returned.

```js
let hint = await I.grabAttributeFrom('#tooltip', 'title');
```

#### Parameters

*   `locator` **([string][9] | [object][10])** element located by CSS|XPath|strict locator.
*   `attr` **[string][9]** attribute name.

Returns **[Promise][13]<[string][9]>** attribute value

### grabAttributeFromAll

Retrieves an array of attributes from elements located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async with `await`** operator.

```js
let hints = await I.grabAttributeFromAll('.tooltip', 'title');
```

#### Parameters

*   `locator` **([string][9] | [object][10])** element located by CSS|XPath|strict locator.
*   `attr` **[string][9]** attribute name.

Returns **[Promise][13]<[Array][14]<[string][9]>>** attribute value

### grabBrowserLogs

Get JS log from browser. Log buffer is reset after each request.
Resumes test execution, so **should be used inside an async function with `await`** operator.

```js
let logs = await I.grabBrowserLogs();
console.log(JSON.stringify(logs))
```

Returns **([Promise][13]<[Array][14]<[object][10]>> | [undefined][15])** all browser logs

### grabCookie

Gets a cookie object by name.
If none provided gets all cookies.
Resumes test execution, so **should be used inside async function with `await`** operator.

```js
let cookie = await I.grabCookie('auth');
assert(cookie.value, '123456');
```

#### Parameters

*   `name` **[string][9]?** cookie name. 

Returns **any** attribute valueReturns cookie in JSON [format][16].

### grabCssPropertyFrom

Grab CSS property for given locator
Resumes test execution, so **should be used inside an async function with `await`** operator.
If more than one element is found - value of first element is returned.

```js
const value = await I.grabCssPropertyFrom('h3', 'font-weight');
```

#### Parameters

*   `locator` **([string][9] | [object][10])** element located by CSS|XPath|strict locator.
*   `cssProperty` **[string][9]** CSS property name.

Returns **[Promise][13]<[string][9]>** CSS value

### grabCssPropertyFromAll

Grab array of CSS properties for given locator
Resumes test execution, so **should be used inside an async function with `await`** operator.

```js
const values = await I.grabCssPropertyFromAll('h3', 'font-weight');
```

#### Parameters

*   `locator` **([string][9] | [object][10])** element located by CSS|XPath|strict locator.
*   `cssProperty` **[string][9]** CSS property name.

Returns **[Promise][13]<[Array][14]<[string][9]>>** CSS value

### grabCurrentUrl

Get current URL from browser.
Resumes test execution, so should be used inside an async function.

```js
let url = await I.grabCurrentUrl();
console.log(`Current URL is [${url}]`);
```

Returns **[Promise][13]<[string][9]>** current URL

### grabHTMLFrom

Retrieves the innerHTML from an element located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async function with `await`** operator.
If more than one element is found - HTML of first element is returned.

```js
let postHTML = await I.grabHTMLFrom('#post');
```

#### Parameters

*   `locator` &#x20;
*   `element` **([string][9] | [object][10])** located by CSS|XPath|strict locator.

Returns **[Promise][13]<[string][9]>** HTML code for an element

### grabHTMLFromAll

Retrieves all the innerHTML from elements located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async function with `await`** operator.

```js
let postHTMLs = await I.grabHTMLFromAll('.post');
```

#### Parameters

*   `locator` &#x20;
*   `element` **([string][9] | [object][10])** located by CSS|XPath|strict locator.

Returns **[Promise][13]<[Array][14]<[string][9]>>** HTML code for an element

### grabNumberOfOpenTabs

Grab number of open tabs.
Resumes test execution, so **should be used inside async function with `await`** operator.

```js
let tabs = await I.grabNumberOfOpenTabs();
```

Returns **[Promise][13]<[number][7]>** number of open tabs

### grabNumberOfVisibleElements

Grab number of visible elements by locator.
Resumes test execution, so **should be used inside async function with `await`** operator.

```js
let numOfElements = await I.grabNumberOfVisibleElements('p');
```

#### Parameters

*   `locator` **([string][9] | [object][10])** located by CSS|XPath|strict locator.

Returns **[Promise][13]<[number][7]>** number of visible elements

### grabPageScrollPosition

Retrieves a page scroll position and returns it to test.
Resumes test execution, so **should be used inside an async function with `await`** operator.

```js
let { x, y } = await I.grabPageScrollPosition();
```

Returns **[Promise][13]<PageScrollPosition>** scroll position

### grabPopupText

Grab the text within the popup. If no popup is visible then it will return null

```js
await I.grabPopupText();
```

### grabSource

Retrieves page source and returns it to test.
Resumes test execution, so **should be used inside async function with `await`** operator.

```js
let pageSource = await I.grabSource();
```

Returns **[Promise][13]<[string][9]>** source code

### grabTextFrom

Retrieves a text from an element located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async with `await`** operator.

```js
let pin = await I.grabTextFrom('#pin');
```

If multiple elements found returns first element.

#### Parameters

*   `locator` **([string][9] | [object][10])** element located by CSS|XPath|strict locator.

Returns **[Promise][13]<[string][9]>** attribute value

### grabTextFromAll

Retrieves all texts from an element located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async with `await`** operator.

```js
let pins = await I.grabTextFromAll('#pin li');
```

#### Parameters

*   `locator` **([string][9] | [object][10])** element located by CSS|XPath|strict locator.

Returns **[Promise][13]<[Array][14]<[string][9]>>** attribute value

### grabTitle

Retrieves a page title and returns it to test.
Resumes test execution, so **should be used inside async with `await`** operator.

```js
let title = await I.grabTitle();
```

Returns **[Promise][13]<[string][9]>** title

### grabValueFrom

Retrieves a value from a form element located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async function with `await`** operator.
If more than one element is found - value of first element is returned.

```js
let email = await I.grabValueFrom('input[name=email]');
```

#### Parameters

*   `locator` **([string][9] | [object][10])** field located by label|name|CSS|XPath|strict locator.

Returns **[Promise][13]<[string][9]>** attribute value

### grabValueFromAll

Retrieves an array of value from a form located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async function with `await`** operator.

```js
let inputs = await I.grabValueFromAll('//form/input');
```

#### Parameters

*   `locator` **([string][9] | [object][10])** field located by label|name|CSS|XPath|strict locator.

Returns **[Promise][13]<[Array][14]<[string][9]>>** attribute value

### haveModule

Injects Angular module.

```js
I.haveModule('modName', function() {
  angular.module('modName', []).value('foo', 'bar');
});
```

#### Parameters

*   `modName` &#x20;
*   `fn` &#x20;

### moveCursorTo

Moves cursor to element matched by locator.
Extra shift can be set with offsetX and offsetY options.

```js
I.moveCursorTo('.tooltip');
I.moveCursorTo('#submit', 5,5);
```

#### Parameters

*   `locator` **([string][9] | [object][10])** located by CSS|XPath|strict locator.
*   `offsetX` **[number][7]** (optional, `0` by default) X-axis offset. 
*   `offsetY` **[number][7]** (optional, `0` by default) Y-axis offset. 

Returns **void** automatically synchronized promise through #recorder

### moveTo

Moves to url

#### Parameters

*   `path` &#x20;

### openNewTab

Open new tab and switch to it

```js
I.openNewTab();
```

### pressKey

Presses a key on a focused element.
Special keys like 'Enter', 'Control', [etc][17]
will be replaced with corresponding unicode.
If modifier key is used (Control, Command, Alt, Shift) in array, it will be released afterwards.

```js
I.pressKey('Enter');
I.pressKey(['Control','a']);
```

#### Parameters

*   `key` **([string][9] | [Array][14]<[string][9]>)** key or array of keys to press.

Returns **void** automatically synchronized promise through #recorder


[Valid key names](https://w3c.github.io/webdriver/#keyboard-actions) are:

- `'Add'`,
- `'Alt'`,
- `'ArrowDown'` or `'Down arrow'`,
- `'ArrowLeft'` or `'Left arrow'`,
- `'ArrowRight'` or `'Right arrow'`,
- `'ArrowUp'` or `'Up arrow'`,
- `'Backspace'`,
- `'Command'`,
- `'Control'`,
- `'Del'`,
- `'Divide'`,
- `'End'`,
- `'Enter'`,
- `'Equals'`,
- `'Escape'`,
- `'F1 to F12'`,
- `'Home'`,
- `'Insert'`,
- `'Meta'`,
- `'Multiply'`,
- `'Numpad 0'` to `'Numpad 9'`,
- `'Pagedown'` or `'PageDown'`,
- `'Pageup'` or `'PageUp'`,
- `'Pause'`,
- `'Semicolon'`,
- `'Shift'`,
- `'Space'`,
- `'Subtract'`,
- `'Tab'`.

### refresh

Reloads page

### refreshPage

Reload the current page.

```js
I.refreshPage();
```

Returns **void** automatically synchronized promise through #recorder

### resetModule

Removes mocked Angular module. If modName not specified - clears all mock modules.

```js
I.resetModule(); // clears all
I.resetModule('modName');
```

#### Parameters

*   `modName` &#x20;

### resizeWindow

Resize the current window to provided width and height.
First parameter can be set to `maximize`.

#### Parameters

*   `width` **[number][7]** width in pixels or `maximize`.
*   `height` **[number][7]** height in pixels.

Returns **void** automatically synchronized promise through #recorder

### rightClick

Performs right click on a clickable element matched by semantic locator, CSS or XPath.

```js
// right click element with id el
I.rightClick('#el');
// right click link or button with text "Click me"
I.rightClick('Click me');
// right click button with text "Click me" inside .context
I.rightClick('Click me', '.context');
```

#### Parameters

*   `locator` **([string][9] | [object][10])** clickable element located by CSS|XPath|strict locator.
*   `context` **([string][9]? | [object][10])** (optional, `null` by default) element located by CSS|XPath|strict locator. 

Returns **void** automatically synchronized promise through #recorder

### saveElementScreenshot

Saves screenshot of the specified locator to ouput folder (set in codecept.conf.ts or codecept.conf.js).
Filename is relative to output folder.

```js
I.saveElementScreenshot(`#submit`,'debug.png');
```

#### Parameters

*   `locator` **([string][9] | [object][10])** element located by CSS|XPath|strict locator.
*   `fileName` **[string][9]** file name to save.

Returns **void** automatically synchronized promise through #recorder

### saveScreenshot

Saves a screenshot to ouput folder (set in codecept.conf.ts or codecept.conf.js).
Filename is relative to output folder.
Optionally resize the window to the full available page `scrollHeight` and `scrollWidth` to capture the entire page by passing `true` in as the second argument.

```js
I.saveScreenshot('debug.png');
I.saveScreenshot('debug.png', true) //resizes to available scrollHeight and scrollWidth before taking screenshot
```

#### Parameters

*   `fileName` **[string][9]** file name to save.
*   `fullPage` **[boolean][18]** (optional, `false` by default) flag to enable fullscreen screenshot mode. 

Returns **void** automatically synchronized promise through #recorder

### scrollPageToBottom

Scroll page to the bottom.

```js
I.scrollPageToBottom();
```

Returns **void** automatically synchronized promise through #recorder

### scrollPageToTop

Scroll page to the top.

```js
I.scrollPageToTop();
```

Returns **void** automatically synchronized promise through #recorder

### scrollTo

Scrolls to element matched by locator.
Extra shift can be set with offsetX and offsetY options.

```js
I.scrollTo('footer');
I.scrollTo('#submit', 5, 5);
```

#### Parameters

*   `locator` **([string][9] | [object][10])** located by CSS|XPath|strict locator.
*   `offsetX` **[number][7]** (optional, `0` by default) X-axis offset. 
*   `offsetY` **[number][7]** (optional, `0` by default) Y-axis offset. 

Returns **void** automatically synchronized promise through #recorder

### see

Checks that a page contains a visible text.
Use context parameter to narrow down the search.

```js
I.see('Welcome'); // text welcome on a page
I.see('Welcome', '.content'); // text inside .content div
I.see('Register', {css: 'form.register'}); // use strict locator
```

#### Parameters

*   `text` **[string][9]** expected on page.
*   `context` **([string][9]? | [object][10])** (optional, `null` by default) element located by CSS|Xpath|strict locator in which to search for text. 

Returns **void** automatically synchronized promise through #recorder

### seeAttributesOnElements

Checks that all elements with given locator have given attributes.

```js
I.seeAttributesOnElements('//form', { method: "post"});
```

#### Parameters

*   `locator` **([string][9] | [object][10])** located by CSS|XPath|strict locator.
*   `attributes` **[object][10]** attributes and their values to check.

Returns **void** automatically synchronized promise through #recorder

### seeCheckboxIsChecked

Verifies that the specified checkbox is checked.

```js
I.seeCheckboxIsChecked('Agree');
I.seeCheckboxIsChecked('#agree'); // I suppose user agreed to terms
I.seeCheckboxIsChecked({css: '#signup_form input[type=checkbox]'});
```

#### Parameters

*   `field` **([string][9] | [object][10])** located by label|name|CSS|XPath|strict locator.

Returns **void** automatically synchronized promise through #recorder

### seeCookie

Checks that cookie with given name exists.

```js
I.seeCookie('Auth');
```

#### Parameters

*   `name` **[string][9]** cookie name.

Returns **void** automatically synchronized promise through #recorder

### seeCssPropertiesOnElements

Checks that all elements with given locator have given CSS properties.

```js
I.seeCssPropertiesOnElements('h3', { 'font-weight': "bold"});
```

#### Parameters

*   `locator` **([string][9] | [object][10])** located by CSS|XPath|strict locator.
*   `cssProperties` **[object][10]** object with CSS properties and their values to check.

Returns **void** automatically synchronized promise through #recorder

### seeCurrentUrlEquals

Checks that current url is equal to provided one.
If a relative url provided, a configured url will be prepended to it.
So both examples will work:

```js
I.seeCurrentUrlEquals('/register');
I.seeCurrentUrlEquals('http://my.site.com/register');
```

#### Parameters

*   `url` **[string][9]** value to check.

Returns **void** automatically synchronized promise through #recorder

### seeElement

Checks that a given Element is visible
Element is located by CSS or XPath.

```js
I.seeElement('#modal');
```

#### Parameters

*   `locator` **([string][9] | [object][10])** located by CSS|XPath|strict locator.

Returns **void** automatically synchronized promise through #recorder

### seeElementInDOM

Checks that a given Element is present in the DOM
Element is located by CSS or XPath.

```js
I.seeElementInDOM('#modal');
```

#### Parameters

*   `locator` **([string][9] | [object][10])** element located by CSS|XPath|strict locator.

Returns **void** automatically synchronized promise through #recorder

### seeInCurrentUrl

Checks that current url contains a provided fragment.

```js
I.seeInCurrentUrl('/register'); // we are on registration page
```

#### Parameters

*   `url` **[string][9]** a fragment to check

Returns **void** automatically synchronized promise through #recorder

### seeInField

Checks that the given input field or textarea equals to given value.
For fuzzy locators, fields are matched by label text, the "name" attribute, CSS, and XPath.

```js
I.seeInField('Username', 'davert');
I.seeInField({css: 'form textarea'},'Type your comment here');
I.seeInField('form input[type=hidden]','hidden_value');
I.seeInField('#searchform input','Search');
```

#### Parameters

*   `field` **([string][9] | [object][10])** located by label|name|CSS|XPath|strict locator.
*   `value` **([string][9] | [object][10])** value to check.

Returns **void** automatically synchronized promise through #recorder

### seeInPopup

Checks that the active JavaScript popup, as created by `window.alert|window.confirm|window.prompt`, contains the
given string.

```js
I.seeInPopup('Popup text');
```

#### Parameters

*   `text` **[string][9]** value to check.

Returns **void** automatically synchronized promise through #recorder

### seeInSource

Checks that the current page contains the given string in its raw source code.

```js
I.seeInSource('<h1>Green eggs &amp; ham</h1>');
```

#### Parameters

*   `text` **[string][9]** value to check.

Returns **void** automatically synchronized promise through #recorder

### seeInTitle

Checks that title contains text.

```js
I.seeInTitle('Home Page');
```

#### Parameters

*   `text` **[string][9]** text value to check.

Returns **void** automatically synchronized promise through #recorder

### seeNumberOfElements

Asserts that an element appears a given number of times in the DOM.
Element is located by label or name or CSS or XPath.

```js
I.seeNumberOfElements('#submitBtn', 1);
```

#### Parameters

*   `locator` **([string][9] | [object][10])** element located by CSS|XPath|strict locator.
*   `num` **[number][7]** number of elements.

Returns **void** automatically synchronized promise through #recorder

### seeNumberOfVisibleElements

Asserts that an element is visible a given number of times.
Element is located by CSS or XPath.

```js
I.seeNumberOfVisibleElements('.buttons', 3);
```

#### Parameters

*   `locator` **([string][9] | [object][10])** element located by CSS|XPath|strict locator.
*   `num` **[number][7]** number of elements.

Returns **void** automatically synchronized promise through #recorder

### seeTextEquals

Checks that text is equal to provided one.

```js
I.seeTextEquals('text', 'h1');
```

#### Parameters

*   `text` **[string][9]** element value to check.
*   `context` **([string][9] | [object][10])?** element located by CSS|XPath|strict locator. 

Returns **void** automatically synchronized promise through #recorder

### seeTitleEquals

Checks that title is equal to provided one.

```js
I.seeTitleEquals('Test title.');
```

#### Parameters

*   `text` **[string][9]** value to check.

Returns **void** automatically synchronized promise through #recorder

### selectOption

Selects an option in a drop-down select.
Field is searched by label | name | CSS | XPath.
Option is selected by visible text or by value.

```js
I.selectOption('Choose Plan', 'Monthly'); // select by label
I.selectOption('subscription', 'Monthly'); // match option by text
I.selectOption('subscription', '0'); // or by value
I.selectOption('//form/select[@name=account]','Premium');
I.selectOption('form select[name=account]', 'Premium');
I.selectOption({css: 'form select[name=account]'}, 'Premium');
```

Provide an array for the second argument to select multiple options.

```js
I.selectOption('Which OS do you use?', ['Android', 'iOS']);
```

#### Parameters

*   `select` **([string][9] | [object][10])** field located by label|name|CSS|XPath|strict locator.
*   `option` **([string][9] | [Array][14]<any>)** visible text or value of option.

Returns **void** automatically synchronized promise through #recorder

### setCookie

Sets cookie(s).

Can be a single cookie object or an array of cookies:

```js
I.setCookie({name: 'auth', value: true});

// as array
I.setCookie([
  {name: 'auth', value: true},
  {name: 'agree', value: true}
]);
```

#### Parameters

*   `cookie` **(Cookie | [Array][14]<Cookie>)** a cookie object or array of cookie objects.

Returns **void** automatically synchronized promise through #recorder

### switchTo

Switches frame or in case of null locator reverts to parent.

```js
I.switchTo('iframe'); // switch to first iframe
I.switchTo(); // switch back to main page
```

#### Parameters

*   `locator` **([string][9]? | [object][10])** (optional, `null` by default) element located by CSS|XPath|strict locator. 

Returns **void** automatically synchronized promise through #recorder

### switchToNextTab

Switch focus to a particular tab by its number. It waits tabs loading and then switch tab

```js
I.switchToNextTab();
I.switchToNextTab(2);
```

#### Parameters

*   `num`   

### switchToPreviousTab

Switch focus to a particular tab by its number. It waits tabs loading and then switch tab

```js
I.switchToPreviousTab();
I.switchToPreviousTab(2);
```

#### Parameters

*   `num`   

### uncheckOption

Unselects a checkbox or radio button.
Element is located by label or name or CSS or XPath.

The second parameter is a context (CSS or XPath locator) to narrow the search.

```js
I.uncheckOption('#agree');
I.uncheckOption('I Agree to Terms and Conditions');
I.uncheckOption('agree', '//form');
```

#### Parameters

*   `field` **([string][9] | [object][10])** checkbox located by label | name | CSS | XPath | strict locator.
*   `context` **([string][9]? | [object][10])** (optional, `null` by default) element located by CSS | XPath | strict locator. 

Returns **void** automatically synchronized promise through #recorder

### useProtractorTo

Use [Protractor][19] API inside a test.

First argument is a description of an action.
Second argument is async function that gets this helper as parameter.

{ [`browser`][20]) } object from Protractor API is available.

```js
I.useProtractorTo('change url via in-page navigation', async ({ browser }) {
   await browser.setLocation('api');
});
```

#### Parameters

*   `description` **[string][9]** used to show in logs.
*   `fn` **[function][12]** async functuion that executed with Protractor helper as argument

### wait

Pauses execution for a number of seconds.

```js
I.wait(2); // wait 2 secs
```

#### Parameters

*   `sec` **[number][7]** number of second to wait.

Returns **void** automatically synchronized promise through #recorder

### waitForClickable

Waits for element to become clickable for number of seconds.

```js
I.waitForClickable('#link');
```

#### Parameters

*   `locator` &#x20;
*   `sec`   

### waitForDetached

Waits for an element to become not attached to the DOM on a page (by default waits for 1sec).
Element can be located by CSS or XPath.

```js
I.waitForDetached('#popup');
```

#### Parameters

*   `locator` **([string][9] | [object][10])** element located by CSS|XPath|strict locator.
*   `sec` **[number][7]** (optional, `1` by default) time in seconds to wait 

Returns **void** automatically synchronized promise through #recorder

### waitForElement

Waits for element to be present on page (by default waits for 1sec).
Element can be located by CSS or XPath.

```js
I.waitForElement('.btn.continue');
I.waitForElement('.btn.continue', 5); // wait for 5 secs
```

#### Parameters

*   `locator` **([string][9] | [object][10])** element located by CSS|XPath|strict locator.
*   `sec` **[number][7]?** (optional, `1` by default) time in seconds to wait 

Returns **void** automatically synchronized promise through #recorder

### waitForEnabled

Waits for element to become enabled (by default waits for 1sec).
Element can be located by CSS or XPath.

#### Parameters

*   `locator` **([string][9] | [object][10])** element located by CSS|XPath|strict locator.
*   `sec` **[number][7]** (optional) time in seconds to wait, 1 by default. 

Returns **void** automatically synchronized promise through #recorder

### waitForFunction

Waits for a function to return true (waits for 1 sec by default).
Running in browser context.

```js
I.waitForFunction(fn[, [args[, timeout]])
```

```js
I.waitForFunction(() => window.requests == 0);
I.waitForFunction(() => window.requests == 0, 5); // waits for 5 sec
I.waitForFunction((count) => window.requests == count, [3], 5) // pass args and wait for 5 sec
```

#### Parameters

*   `fn` **([string][9] | [function][12])** to be executed in browser context.
*   `argsOrSec` **([Array][14]<any> | [number][7])?** (optional, `1` by default) arguments for function or seconds. 
*   `sec` **[number][7]?** (optional, `1` by default) time in seconds to wait 

Returns **void** automatically synchronized promise through #recorder

### waitForInvisible

Waits for an element to be removed or become invisible on a page (by default waits for 1sec).
Element can be located by CSS or XPath.

```js
I.waitForInvisible('#popup');
```

#### Parameters

*   `locator` **([string][9] | [object][10])** element located by CSS|XPath|strict locator.
*   `sec` **[number][7]** (optional, `1` by default) time in seconds to wait 

Returns **void** automatically synchronized promise through #recorder

### waitForText

Waits for a text to appear (by default waits for 1sec).
Element can be located by CSS or XPath.
Narrow down search results by providing context.

```js
I.waitForText('Thank you, form has been submitted');
I.waitForText('Thank you, form has been submitted', 5, '#modal');
```

#### Parameters

*   `text` **[string][9]** to wait for.
*   `sec` **[number][7]** (optional, `1` by default) time in seconds to wait 
*   `context` **([string][9] | [object][10])?** (optional) element located by CSS|XPath|strict locator. 

Returns **void** automatically synchronized promise through #recorder

### waitForValue

Waits for the specified value to be in value attribute.

```js
I.waitForValue('//input', "GoodValue");
```

#### Parameters

*   `field` **([string][9] | [object][10])** input field.
*   `value` **[string][9]** expected value.
*   `sec` **[number][7]** (optional, `1` by default) time in seconds to wait 

Returns **void** automatically synchronized promise through #recorder

### waitForVisible

Waits for an element to become visible on a page (by default waits for 1sec).
Element can be located by CSS or XPath.

```js
I.waitForVisible('#popup');
```

#### Parameters

*   `locator` **([string][9] | [object][10])** element located by CSS|XPath|strict locator.
*   `sec` **[number][7]** (optional, `1` by default) time in seconds to wait 

Returns **void** automatically synchronized promise through #recorder

### waitInUrl

Waiting for the part of the URL to match the expected. Useful for SPA to understand that page was changed.

```js
I.waitInUrl('/info', 2);
```

#### Parameters

*   `urlPart` **[string][9]** value to check.
*   `sec` **[number][7]** (optional, `1` by default) time in seconds to wait 

Returns **void** automatically synchronized promise through #recorder

### waitNumberOfVisibleElements

Waits for a specified number of elements on the page.

```js
I.waitNumberOfVisibleElements('a', 3);
```

#### Parameters

*   `locator` **([string][9] | [object][10])** element located by CSS|XPath|strict locator.
*   `num` **[number][7]** number of elements.
*   `sec` **[number][7]** (optional, `1` by default) time in seconds to wait 

Returns **void** automatically synchronized promise through #recorder

### waitToHide

Waits for an element to hide (by default waits for 1sec).
Element can be located by CSS or XPath.

```js
I.waitToHide('#popup');
```

#### Parameters

*   `locator` **([string][9] | [object][10])** element located by CSS|XPath|strict locator.
*   `sec` **[number][7]** (optional, `1` by default) time in seconds to wait 

Returns **void** automatically synchronized promise through #recorder

### waitUrlEquals

Waits for the entire URL to match the expected

```js
I.waitUrlEquals('/info', 2);
I.waitUrlEquals('http://127.0.0.1:8000/info');
```

#### Parameters

*   `urlPart` **[string][9]** value to check.
*   `sec` **[number][7]** (optional, `1` by default) time in seconds to wait 

Returns **void** automatically synchronized promise through #recorder

## locator

just press button if no selector is given

[1]: http://www.protractortest.org

[2]: http://codecept.io/quickstart/#prepare-selenium-server

[3]: http://codecept.io/acceptance/#smartwait

[4]: http://localhost:4444/wd/hub

[5]: https://github.com/SeleniumHQ/selenium/wiki/DesiredCapabilities

[6]: https://github.com/angular/protractor/blob/master/docs/referenceConf.js

[7]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[8]: http://jster.net/category/windows-modals-popups

[9]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[10]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[11]: https://vuejs.org/v2/api/#Vue-nextTick

[12]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Statements/function

[13]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise

[14]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

[15]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/undefined

[16]: https://code.google.com/p/selenium/wiki/JsonWireProtocol#Cookie_JSON_Object

[17]: https://code.google.com/p/selenium/wiki/JsonWireProtocol#/session/:sessionId/element/:id/value

[18]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[19]: https://www.protractortest.org/#/api

[20]: https://www.protractortest.org/#/api?view=ProtractorBrowser
