---
permalink: /helpers/OpenAI
editLink: false
sidebar: auto
title: OpenAI
---

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## OpenAI

**Extends Helper**

OpenAI Helper for CodeceptJS.

This helper class provides integration with the OpenAI GPT-3.5 or 4 language model for generating responses to questions or prompts within the context of web pages. It allows you to interact with the GPT-3.5 model to obtain intelligent responses based on HTML fragments or general prompts.
This helper should be enabled with any web helpers like Playwright or Puppeteer or WebDrvier to ensure the HTML context is available.

## Configuration

This helper should be configured in codecept.json or codecept.conf.js

-   `chunkSize`:  - The maximum number of characters to send to the OpenAI API at once. We split HTML fragments by 8000 chars to not exceed token limit. Increase this value if you use GPT-4.

### Parameters

-   `config`  

### askGptGeneralPrompt

Send a general request to ChatGPT and return response.

#### Parameters

-   `prompt` **[string][1]** 

Returns **[Promise][2]&lt;[string][1]>** A Promise that resolves to the generated response from the GPT model.

### askGptOnPage

Asks the OpenAI GPT language model a question based on the provided prompt within the context of the current page's HTML.

```js
I.askGptOnPage('what does this page do?');
```

#### Parameters

-   `prompt` **[string][1]** The question or prompt to ask the GPT model.

Returns **[Promise][2]&lt;[string][1]>** A Promise that resolves to the generated responses from the GPT model, joined by newlines.

### askGptOnPageFragment

Asks the OpenAI GPT-3.5 language model a question based on the provided prompt within the context of a specific HTML fragment on the current page.

```js
I.askGptOnPageFragment('describe features of this screen', '.screen');
```

#### Parameters

-   `prompt` **[string][1]** The question or prompt to ask the GPT-3.5 model.
-   `locator` **[string][1]** The locator or selector used to identify the HTML fragment on the page.

Returns **[Promise][2]&lt;[string][1]>** A Promise that resolves to the generated response from the GPT model.

[1]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[2]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise
