---
permalink: /helpers/Nightmare
editLink: false
sidebar: auto
title: Nightmare
---

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## Nightmare

**Extends Helper**

Nightmare helper wraps [Nightmare][1] library to provide
fastest headless testing using Electron engine. Unlike Selenium-based drivers this uses
Chromium-based browser with Electron with lots of client side scripts, thus should be less stable and
less trusted.

Requires `nightmare` package to be installed.

## Configuration

This helper should be configured in codecept.conf.ts or codecept.conf.js

*   `url` - base url of website to be tested
*   `restart`  - restart browser between tests.
*   `disableScreenshots`   - don't save screenshot on failure.
*   `uniqueScreenshotNames`   - option to prevent screenshot override if you have scenarios with the same name in different suites.
*   `fullPageScreenshots`  - make full page screenshots on failure.
*   `keepBrowserState`   - keep browser state between tests when `restart` set to false.
*   `keepCookies`   - keep cookies between tests when `restart` set to false.
*   `waitForAction`: (optional) how long to wait after click, doubleClick or PressKey actions in ms. Default: 500.
*   `waitForTimeout`: (optional) default wait* timeout in ms. Default: 1000.
*   `windowSize`: (optional) default window size. Set a dimension like `640x480`.

<!---->

*   options from [Nightmare configuration][2]

## Methods

### Parameters

*   `config` &#x20;

### _locate

Locate elements by different locator types, including strict locator.
Should be used in custom helpers.

This method return promise with array of IDs of found elements.
Actual elements can be accessed inside `evaluate` by using `codeceptjs.fetchElement()`
client-side function:

```js
// get an inner text of an element

let browser = this.helpers['Nightmare'].browser;
let value = this.helpers['Nightmare']._locate({name: 'password'}).then(function(els) {
  return browser.evaluate(function(el) {
    return codeceptjs.fetchElement(el).value;
  }, els[0]);
});
```

#### Parameters

*   `locator` &#x20;

### amOnPage

Opens a web page in a browser. Requires relative or absolute url.
If url starts with `/`, opens a web page of a site defined in `url` config parameter.

```js
I.amOnPage('/'); // opens main page of website
I.amOnPage('https://github.com'); // opens github
I.amOnPage('/login'); // opens a login page
```

#### Parameters

*   `url` **[string][3]** url path or global url.
*   `headers` **[object][4]?** list of request headers can be passed 

Returns **void** automatically synchronized promise through #recorder

### appendField

Appends text to a input field or textarea.
Field is located by name, label, CSS or XPath

```js
I.appendField('#myTextField', 'appended');
// typing secret
I.appendField('password', secret('123456'));
```

#### Parameters

*   `field` **([string][3] | [object][4])** located by label|name|CSS|XPath|strict locator
*   `value` **[string][3]** text value to append.

Returns **void** automatically synchronized promise through #recorder

### attachFile

Attaches a file to element located by label, name, CSS or XPath
Path to file is relative current codecept directory (where codecept.conf.ts or codecept.conf.js is located).
File will be uploaded to remote system (if tests are running remotely).

```js
I.attachFile('Avatar', 'data/avatar.jpg');
I.attachFile('form input[name=avatar]', 'data/avatar.jpg');
```

#### Parameters

*   `locator` **([string][3] | [object][4])** field located by label|name|CSS|XPath|strict locator.
*   `pathToFile` **[string][3]** local file path relative to codecept.conf.ts or codecept.conf.js config file.

Returns **void** automatically synchronized promise through #recorderDoesn't work if the Chromium DevTools panel is open (as Chromium allows only one attachment to the debugger at a time. [See more][5])

### checkOption

Selects a checkbox or radio button.
Element is located by label or name or CSS or XPath.

The second parameter is a context (CSS or XPath locator) to narrow the search.

```js
I.checkOption('#agree');
I.checkOption('I Agree to Terms and Conditions');
I.checkOption('agree', '//form');
```

#### Parameters

*   `field` **([string][3] | [object][4])** checkbox located by label | name | CSS | XPath | strict locator.
*   `context` **([string][3]? | [object][4])** (optional, `null` by default) element located by CSS | XPath | strict locator. 

Returns **void** automatically synchronized promise through #recorder

### clearCookie

Clears a cookie by name,
if none provided clears all cookies.

```js
I.clearCookie();
I.clearCookie('test');
```

#### Parameters

*   `cookie` **[string][3]?** (optional, `null` by default) cookie name 

### clearField

Clears a `<textarea>` or text `<input>` element's value.

```js
I.clearField('Email');
I.clearField('user[email]');
I.clearField('#email');
```

#### Parameters

*   `field` &#x20;
*   `editable` **([string][3] | [object][4])** field located by label|name|CSS|XPath|strict locator.

Returns **void** automatically synchronized promise through #recorder.

### click

Perform a click on a link or a button, given by a locator.
If a fuzzy locator is given, the page will be searched for a button, link, or image matching the locator string.
For buttons, the "value" attribute, "name" attribute, and inner text are searched. For links, the link text is searched.
For images, the "alt" attribute and inner text of any parent links are searched.

The second parameter is a context (CSS or XPath locator) to narrow the search.

```js
// simple link
I.click('Logout');
// button of form
I.click('Submit');
// CSS button
I.click('#form input[type=submit]');
// XPath
I.click('//form/*[@type=submit]');
// link in context
I.click('Logout', '#nav');
// using strict locator
I.click({css: 'nav a.login'});
```

#### Parameters

*   `locator` **([string][3] | [object][4])** clickable link or button located by text, or any element located by CSS|XPath|strict locator.
*   `context` **([string][3]? | [object][4] | null)** (optional, `null` by default) element to search in CSS|XPath|Strict locator. 

Returns **void** automatically synchronized promise through #recorder

### dontSee

Opposite to `see`. Checks that a text is not present on a page.
Use context parameter to narrow down the search.

```js
I.dontSee('Login'); // assume we are already logged in.
I.dontSee('Login', '.nav'); // no login inside .nav element
```

#### Parameters

*   `text` **[string][3]** which is not present.
*   `context` **([string][3] | [object][4])?** (optional) element located by CSS|XPath|strict locator in which to perfrom search. 

Returns **void** automatically synchronized promise through #recorder

### dontSeeCheckboxIsChecked

Verifies that the specified checkbox is not checked.

```js
I.dontSeeCheckboxIsChecked('#agree'); // located by ID
I.dontSeeCheckboxIsChecked('I agree to terms'); // located by label
I.dontSeeCheckboxIsChecked('agree'); // located by name
```

#### Parameters

*   `field` **([string][3] | [object][4])** located by label|name|CSS|XPath|strict locator.

Returns **void** automatically synchronized promise through #recorder

### dontSeeCookie

Checks that cookie with given name does not exist.

```js
I.dontSeeCookie('auth'); // no auth cookie
```

#### Parameters

*   `name` **[string][3]** cookie name.

Returns **void** automatically synchronized promise through #recorder

### dontSeeCurrentUrlEquals

Checks that current url is not equal to provided one.
If a relative url provided, a configured url will be prepended to it.

```js
I.dontSeeCurrentUrlEquals('/login'); // relative url are ok
I.dontSeeCurrentUrlEquals('http://mysite.com/login'); // absolute urls are also ok
```

#### Parameters

*   `url` **[string][3]** value to check.

Returns **void** automatically synchronized promise through #recorder

### dontSeeElement

Opposite to `seeElement`. Checks that element is not visible (or in DOM)

```js
I.dontSeeElement('.modal'); // modal is not shown
```

#### Parameters

*   `locator` **([string][3] | [object][4])** located by CSS|XPath|Strict locator.

Returns **void** automatically synchronized promise through #recorder

### dontSeeElementInDOM

Opposite to `seeElementInDOM`. Checks that element is not on page.

```js
I.dontSeeElementInDOM('.nav'); // checks that element is not on page visible or not
```

#### Parameters

*   `locator` **([string][3] | [object][4])** located by CSS|XPath|Strict locator.

Returns **void** automatically synchronized promise through #recorder

### dontSeeInCurrentUrl

Checks that current url does not contain a provided fragment.

#### Parameters

*   `url` **[string][3]** value to check.

Returns **void** automatically synchronized promise through #recorder

### dontSeeInField

Checks that value of input field or textarea doesn't equal to given value
Opposite to `seeInField`.

```js
I.dontSeeInField('email', 'user@user.com'); // field by name
I.dontSeeInField({ css: 'form input.email' }, 'user@user.com'); // field by CSS
```

#### Parameters

*   `field` **([string][3] | [object][4])** located by label|name|CSS|XPath|strict locator.
*   `value` **([string][3] | [object][4])** value to check.

Returns **void** automatically synchronized promise through #recorder

### dontSeeInSource

Checks that the current page does not contains the given string in its raw source code.

```js
I.dontSeeInSource('<!--'); // no comments in source
```

#### Parameters

*   `text` &#x20;
*   `value` **[string][3]** to check.

Returns **void** automatically synchronized promise through #recorder

### dontSeeInTitle

Checks that title does not contain text.

```js
I.dontSeeInTitle('Error');
```

#### Parameters

*   `text` **[string][3]** value to check.

Returns **void** automatically synchronized promise through #recorder

### doubleClick

Performs a double-click on an element matched by link|button|label|CSS or XPath.
Context can be specified as second parameter to narrow search.

```js
I.doubleClick('Edit');
I.doubleClick('Edit', '.actions');
I.doubleClick({css: 'button.accept'});
I.doubleClick('.btn.edit');
```

#### Parameters

*   `locator` **([string][3] | [object][4])** clickable link or button located by text, or any element located by CSS|XPath|strict locator.
*   `context` **([string][3]? | [object][4])** (optional, `null` by default) element to search in CSS|XPath|Strict locator. 

Returns **void** automatically synchronized promise through #recorder

### executeAsyncScript

Executes async script on page.
Provided function should execute a passed callback (as first argument) to signal it is finished.

Example: In Vue.js to make components completely rendered we are waiting for [nextTick][6].

```js
I.executeAsyncScript(function(done) {
  Vue.nextTick(done); // waiting for next tick
});
```

By passing value to `done()` function you can return values.
Additional arguments can be passed as well, while `done` function is always last parameter in arguments list.

```js
let val = await I.executeAsyncScript(function(url, done) {
  // in browser context
  $.ajax(url, { success: (data) => done(data); }
}, 'http://ajax.callback.url/');
```

#### Parameters

*   `args` **...any** to be passed to function.
*   `fn` **([string][3] | [function][7])** function to be executed in browser context.

Returns **[Promise][8]<any>** script return valueWrapper for asynchronous [evaluate][9].
Unlike NightmareJS implementation calling `done` will return its first argument.

### executeScript

Executes sync script on a page.
Pass arguments to function as additional parameters.
Will return execution result to a test.
In this case you should use async function and await to receive results.

Example with jQuery DatePicker:

```js
// change date of jQuery DatePicker
I.executeScript(function() {
  // now we are inside browser context
  $('date').datetimepicker('setDate', new Date());
});
```

Can return values. Don't forget to use `await` to get them.

```js
let date = await I.executeScript(function(el) {
  // only basic types can be returned
  return $(el).datetimepicker('getDate').toString();
}, '#date'); // passing jquery selector
```

#### Parameters

*   `args` **...any** to be passed to function.
*   `fn` **([string][3] | [function][7])** function to be executed in browser context.

Returns **[Promise][8]<any>** script return valueWrapper for synchronous [evaluate][9]

### fillField

Fills a text field or textarea, after clearing its value, with the given string.
Field is located by name, label, CSS, or XPath.

```js
// by label
I.fillField('Email', 'hello@world.com');
// by name
I.fillField('password', secret('123456'));
// by CSS
I.fillField('form#login input[name=username]', 'John');
// or by strict locator
I.fillField({css: 'form#login input[name=username]'}, 'John');
```

#### Parameters

*   `field` **([string][3] | [object][4])** located by label|name|CSS|XPath|strict locator.
*   `value` **([string][3] | [object][4])** text value to fill.

Returns **void** automatically synchronized promise through #recorder

### grabAttributeFrom

Retrieves an attribute from an element located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async with `await`** operator.
If more than one element is found - attribute of first element is returned.

```js
let hint = await I.grabAttributeFrom('#tooltip', 'title');
```

#### Parameters

*   `locator` **([string][3] | [object][4])** element located by CSS|XPath|strict locator.
*   `attr` **[string][3]** attribute name.

Returns **[Promise][8]<[string][3]>** attribute value

### grabAttributeFromAll

Retrieves an array of attributes from elements located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async with `await`** operator.

```js
let hints = await I.grabAttributeFromAll('.tooltip', 'title');
```

#### Parameters

*   `locator` **([string][3] | [object][4])** element located by CSS|XPath|strict locator.
*   `attr` **[string][3]** attribute name.

Returns **[Promise][8]<[Array][10]<[string][3]>>** attribute value

### grabCookie

Gets a cookie object by name.
If none provided gets all cookies.
Resumes test execution, so **should be used inside async function with `await`** operator.

```js
let cookie = await I.grabCookie('auth');
assert(cookie.value, '123456');
```

#### Parameters

*   `name` **[string][3]?** cookie name. 

Returns **any** attribute valueCookie in JSON format. If name not passed returns all cookies for this domain.Multiple cookies can be received by passing query object `I.grabCookie({ secure: true});`. If you'd like get all cookies for all urls, use: `.grabCookie({ url: null }).`

### grabCssPropertyFrom

Grab CSS property for given locator
Resumes test execution, so **should be used inside an async function with `await`** operator.
If more than one element is found - value of first element is returned.

```js
const value = await I.grabCssPropertyFrom('h3', 'font-weight');
```

#### Parameters

*   `locator` **([string][3] | [object][4])** element located by CSS|XPath|strict locator.
*   `cssProperty` **[string][3]** CSS property name.

Returns **[Promise][8]<[string][3]>** CSS value

### grabCurrentUrl

Get current URL from browser.
Resumes test execution, so should be used inside an async function.

```js
let url = await I.grabCurrentUrl();
console.log(`Current URL is [${url}]`);
```

Returns **[Promise][8]<[string][3]>** current URL

### grabElementBoundingRect

Grab the width, height, location of given locator.
Provide `width` or `height`as second param to get your desired prop.
Resumes test execution, so **should be used inside an async function with `await`** operator.

Returns an object with `x`, `y`, `width`, `height` keys.

```js
const value = await I.grabElementBoundingRect('h3');
// value is like { x: 226.5, y: 89, width: 527, height: 220 }
```

To get only one metric use second parameter:

```js
const width = await I.grabElementBoundingRect('h3', 'width');
// width == 527
```

#### Parameters

*   `locator` **([string][3] | [object][4])** element located by CSS|XPath|strict locator.
*   `prop` &#x20;
*   `elementSize` **[string][3]?** x, y, width or height of the given element.

Returns **([Promise][8]<DOMRect> | [Promise][8]<[number][11]>)** Element bounding rectangle

### grabHAR

Get HAR

```js
let har = await I.grabHAR();
fs.writeFileSync('sample.har', JSON.stringify({log: har}));
```

### grabHTMLFrom

Retrieves the innerHTML from an element located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async function with `await`** operator.
If more than one element is found - HTML of first element is returned.

```js
let postHTML = await I.grabHTMLFrom('#post');
```

#### Parameters

*   `locator` &#x20;
*   `element` **([string][3] | [object][4])** located by CSS|XPath|strict locator.

Returns **[Promise][8]<[string][3]>** HTML code for an element

### grabHTMLFromAll

Retrieves all the innerHTML from elements located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async function with `await`** operator.

```js
let postHTMLs = await I.grabHTMLFromAll('.post');
```

#### Parameters

*   `locator` &#x20;
*   `element` **([string][3] | [object][4])** located by CSS|XPath|strict locator.

Returns **[Promise][8]<[Array][10]<[string][3]>>** HTML code for an element

### grabNumberOfVisibleElements

Grab number of visible elements by locator.
Resumes test execution, so **should be used inside async function with `await`** operator.

```js
let numOfElements = await I.grabNumberOfVisibleElements('p');
```

#### Parameters

*   `locator` **([string][3] | [object][4])** located by CSS|XPath|strict locator.

Returns **[Promise][8]<[number][11]>** number of visible elements

### grabPageScrollPosition

Retrieves a page scroll position and returns it to test.
Resumes test execution, so **should be used inside an async function with `await`** operator.

```js
let { x, y } = await I.grabPageScrollPosition();
```

Returns **[Promise][8]<PageScrollPosition>** scroll position

### grabTextFrom

Retrieves a text from an element located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async with `await`** operator.

```js
let pin = await I.grabTextFrom('#pin');
```

If multiple elements found returns first element.

#### Parameters

*   `locator` **([string][3] | [object][4])** element located by CSS|XPath|strict locator.

Returns **[Promise][8]<[string][3]>** attribute value

### grabTextFromAll

Retrieves all texts from an element located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async with `await`** operator.

```js
let pins = await I.grabTextFromAll('#pin li');
```

#### Parameters

*   `locator` **([string][3] | [object][4])** element located by CSS|XPath|strict locator.

Returns **[Promise][8]<[Array][10]<[string][3]>>** attribute value

### grabTitle

Retrieves a page title and returns it to test.
Resumes test execution, so **should be used inside async with `await`** operator.

```js
let title = await I.grabTitle();
```

Returns **[Promise][8]<[string][3]>** title

### grabValueFrom

Retrieves a value from a form element located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async function with `await`** operator.
If more than one element is found - value of first element is returned.

```js
let email = await I.grabValueFrom('input[name=email]');
```

#### Parameters

*   `locator` **([string][3] | [object][4])** field located by label|name|CSS|XPath|strict locator.

Returns **[Promise][8]<[string][3]>** attribute value

### grabValueFromAll

Retrieves an array of value from a form located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async function with `await`** operator.

```js
let inputs = await I.grabValueFromAll('//form/input');
```

#### Parameters

*   `locator` **([string][3] | [object][4])** field located by label|name|CSS|XPath|strict locator.

Returns **[Promise][8]<[Array][10]<[string][3]>>** attribute value

### haveHeader

Add a header override for all HTTP requests. If header is undefined, the header overrides will be reset.

```js
I.haveHeader('x-my-custom-header', 'some value');
I.haveHeader(); // clear headers
```

#### Parameters

*   `header` &#x20;
*   `value` &#x20;

### moveCursorTo

Moves cursor to element matched by locator.
Extra shift can be set with offsetX and offsetY options.

```js
I.moveCursorTo('.tooltip');
I.moveCursorTo('#submit', 5,5);
```

#### Parameters

*   `locator` **([string][3] | [object][4])** located by CSS|XPath|strict locator.
*   `offsetX` **[number][11]** (optional, `0` by default) X-axis offset. 
*   `offsetY` **[number][11]** (optional, `0` by default) Y-axis offset. 

Returns **void** automatically synchronized promise through #recorder

### pressKey

Sends [input event][12] on a page.
Can submit special keys like 'Enter', 'Backspace', etc

#### Parameters

*   `key` &#x20;

### refresh

Reload the page

### refreshPage

Reload the current page.

```js
I.refreshPage();
```

Returns **void** automatically synchronized promise through #recorder

### resizeWindow

Resize the current window to provided width and height.
First parameter can be set to `maximize`.

#### Parameters

*   `width` **[number][11]** width in pixels or `maximize`.
*   `height` **[number][11]** height in pixels.

Returns **void** automatically synchronized promise through #recorder

### rightClick

Performs right click on a clickable element matched by semantic locator, CSS or XPath.

```js
// right click element with id el
I.rightClick('#el');
// right click link or button with text "Click me"
I.rightClick('Click me');
// right click button with text "Click me" inside .context
I.rightClick('Click me', '.context');
```

#### Parameters

*   `locator` **([string][3] | [object][4])** clickable element located by CSS|XPath|strict locator.
*   `context` **([string][3]? | [object][4])** (optional, `null` by default) element located by CSS|XPath|strict locator. 

Returns **void** automatically synchronized promise through #recorder

### saveElementScreenshot

Saves screenshot of the specified locator to ouput folder (set in codecept.conf.ts or codecept.conf.js).
Filename is relative to output folder.

```js
I.saveElementScreenshot(`#submit`,'debug.png');
```

#### Parameters

*   `locator` **([string][3] | [object][4])** element located by CSS|XPath|strict locator.
*   `fileName` **[string][3]** file name to save.

Returns **void** automatically synchronized promise through #recorder

### saveScreenshot

Saves a screenshot to ouput folder (set in codecept.conf.ts or codecept.conf.js).
Filename is relative to output folder.
Optionally resize the window to the full available page `scrollHeight` and `scrollWidth` to capture the entire page by passing `true` in as the second argument.

```js
I.saveScreenshot('debug.png');
I.saveScreenshot('debug.png', true) //resizes to available scrollHeight and scrollWidth before taking screenshot
```

#### Parameters

*   `fileName` **[string][3]** file name to save.
*   `fullPage` **[boolean][13]** (optional, `false` by default) flag to enable fullscreen screenshot mode. 

Returns **void** automatically synchronized promise through #recorder

### scrollPageToBottom

Scroll page to the bottom.

```js
I.scrollPageToBottom();
```

Returns **void** automatically synchronized promise through #recorder

### scrollPageToTop

Scroll page to the top.

```js
I.scrollPageToTop();
```

Returns **void** automatically synchronized promise through #recorder

### scrollTo

Scrolls to element matched by locator.
Extra shift can be set with offsetX and offsetY options.

```js
I.scrollTo('footer');
I.scrollTo('#submit', 5, 5);
```

#### Parameters

*   `locator` **([string][3] | [object][4])** located by CSS|XPath|strict locator.
*   `offsetX` **[number][11]** (optional, `0` by default) X-axis offset. 
*   `offsetY` **[number][11]** (optional, `0` by default) Y-axis offset. 

Returns **void** automatically synchronized promise through #recorder

### see

Checks that a page contains a visible text.
Use context parameter to narrow down the search.

```js
I.see('Welcome'); // text welcome on a page
I.see('Welcome', '.content'); // text inside .content div
I.see('Register', {css: 'form.register'}); // use strict locator
```

#### Parameters

*   `text` **[string][3]** expected on page.
*   `context` **([string][3]? | [object][4])** (optional, `null` by default) element located by CSS|Xpath|strict locator in which to search for text. 

Returns **void** automatically synchronized promise through #recorder

### seeCheckboxIsChecked

Verifies that the specified checkbox is checked.

```js
I.seeCheckboxIsChecked('Agree');
I.seeCheckboxIsChecked('#agree'); // I suppose user agreed to terms
I.seeCheckboxIsChecked({css: '#signup_form input[type=checkbox]'});
```

#### Parameters

*   `field` **([string][3] | [object][4])** located by label|name|CSS|XPath|strict locator.

Returns **void** automatically synchronized promise through #recorder

### seeCookie

Checks that cookie with given name exists.

```js
I.seeCookie('Auth');
```

#### Parameters

*   `name` **[string][3]** cookie name.

Returns **void** automatically synchronized promise through #recorder

### seeCurrentUrlEquals

Checks that current url is equal to provided one.
If a relative url provided, a configured url will be prepended to it.
So both examples will work:

```js
I.seeCurrentUrlEquals('/register');
I.seeCurrentUrlEquals('http://my.site.com/register');
```

#### Parameters

*   `url` **[string][3]** value to check.

Returns **void** automatically synchronized promise through #recorder

### seeElement

Checks that a given Element is visible
Element is located by CSS or XPath.

```js
I.seeElement('#modal');
```

#### Parameters

*   `locator` **([string][3] | [object][4])** located by CSS|XPath|strict locator.

Returns **void** automatically synchronized promise through #recorder

### seeElementInDOM

Checks that a given Element is present in the DOM
Element is located by CSS or XPath.

```js
I.seeElementInDOM('#modal');
```

#### Parameters

*   `locator` **([string][3] | [object][4])** element located by CSS|XPath|strict locator.

Returns **void** automatically synchronized promise through #recorder

### seeInCurrentUrl

Checks that current url contains a provided fragment.

```js
I.seeInCurrentUrl('/register'); // we are on registration page
```

#### Parameters

*   `url` **[string][3]** a fragment to check

Returns **void** automatically synchronized promise through #recorder

### seeInField

Checks that the given input field or textarea equals to given value.
For fuzzy locators, fields are matched by label text, the "name" attribute, CSS, and XPath.

```js
I.seeInField('Username', 'davert');
I.seeInField({css: 'form textarea'},'Type your comment here');
I.seeInField('form input[type=hidden]','hidden_value');
I.seeInField('#searchform input','Search');
```

#### Parameters

*   `field` **([string][3] | [object][4])** located by label|name|CSS|XPath|strict locator.
*   `value` **([string][3] | [object][4])** value to check.

Returns **void** automatically synchronized promise through #recorder

### seeInSource

Checks that the current page contains the given string in its raw source code.

```js
I.seeInSource('<h1>Green eggs &amp; ham</h1>');
```

#### Parameters

*   `text` **[string][3]** value to check.

Returns **void** automatically synchronized promise through #recorder

### seeInTitle

Checks that title contains text.

```js
I.seeInTitle('Home Page');
```

#### Parameters

*   `text` **[string][3]** text value to check.

Returns **void** automatically synchronized promise through #recorder

### seeNumberOfElements

Asserts that an element appears a given number of times in the DOM.
Element is located by label or name or CSS or XPath.

```js
I.seeNumberOfElements('#submitBtn', 1);
```

#### Parameters

*   `locator` **([string][3] | [object][4])** element located by CSS|XPath|strict locator.
*   `num` **[number][11]** number of elements.

Returns **void** automatically synchronized promise through #recorder

### seeNumberOfVisibleElements

Asserts that an element is visible a given number of times.
Element is located by CSS or XPath.

```js
I.seeNumberOfVisibleElements('.buttons', 3);
```

#### Parameters

*   `locator` **([string][3] | [object][4])** element located by CSS|XPath|strict locator.
*   `num` **[number][11]** number of elements.

Returns **void** automatically synchronized promise through #recorder

### selectOption

Selects an option in a drop-down select.
Field is searched by label | name | CSS | XPath.
Option is selected by visible text or by value.

```js
I.selectOption('Choose Plan', 'Monthly'); // select by label
I.selectOption('subscription', 'Monthly'); // match option by text
I.selectOption('subscription', '0'); // or by value
I.selectOption('//form/select[@name=account]','Premium');
I.selectOption('form select[name=account]', 'Premium');
I.selectOption({css: 'form select[name=account]'}, 'Premium');
```

Provide an array for the second argument to select multiple options.

```js
I.selectOption('Which OS do you use?', ['Android', 'iOS']);
```

#### Parameters

*   `select` **([string][3] | [object][4])** field located by label|name|CSS|XPath|strict locator.
*   `option` **([string][3] | [Array][10]<any>)** visible text or value of option.

Returns **void** automatically synchronized promise through #recorder

### setCookie

Sets cookie(s).

Can be a single cookie object or an array of cookies:

```js
I.setCookie({name: 'auth', value: true});

// as array
I.setCookie([
  {name: 'auth', value: true},
  {name: 'agree', value: true}
]);
```

#### Parameters

*   `cookie` **(Cookie | [Array][10]<Cookie>)** a cookie object or array of cookie objects.

Returns **void** automatically synchronized promise through #recorderWrapper for `.cookies.set(cookie)`.
[See more][14]

### triggerMouseEvent

Sends [input event][15] on a page.
Should be a mouse event like:
{
type: 'mouseDown',
x: args.x,
y: args.y,
button: "left"
}

#### Parameters

*   `event` &#x20;

### uncheckOption

Unselects a checkbox or radio button.
Element is located by label or name or CSS or XPath.

The second parameter is a context (CSS or XPath locator) to narrow the search.

```js
I.uncheckOption('#agree');
I.uncheckOption('I Agree to Terms and Conditions');
I.uncheckOption('agree', '//form');
```

#### Parameters

*   `field` **([string][3] | [object][4])** checkbox located by label | name | CSS | XPath | strict locator.
*   `context` **([string][3]? | [object][4])** (optional, `null` by default) element located by CSS | XPath | strict locator. 

Returns **void** automatically synchronized promise through #recorder

### wait

Pauses execution for a number of seconds.

```js
I.wait(2); // wait 2 secs
```

#### Parameters

*   `sec` **[number][11]** number of second to wait.

Returns **void** automatically synchronized promise through #recorder

### waitForDetached

Waits for an element to become not attached to the DOM on a page (by default waits for 1sec).
Element can be located by CSS or XPath.

```js
I.waitForDetached('#popup');
```

#### Parameters

*   `locator` **([string][3] | [object][4])** element located by CSS|XPath|strict locator.
*   `sec` **[number][11]** (optional, `1` by default) time in seconds to wait 

Returns **void** automatically synchronized promise through #recorder

### waitForElement

Waits for element to be present on page (by default waits for 1sec).
Element can be located by CSS or XPath.

```js
I.waitForElement('.btn.continue');
I.waitForElement('.btn.continue', 5); // wait for 5 secs
```

#### Parameters

*   `locator` **([string][3] | [object][4])** element located by CSS|XPath|strict locator.
*   `sec` **[number][11]?** (optional, `1` by default) time in seconds to wait

Returns **void** automatically synchronized promise through #recorder

### waitForFunction

Waits for a function to return true (waits for 1 sec by default).
Running in browser context.

```js
I.waitForFunction(fn[, [args[, timeout]])
```

```js
I.waitForFunction(() => window.requests == 0);
I.waitForFunction(() => window.requests == 0, 5); // waits for 5 sec
I.waitForFunction((count) => window.requests == count, [3], 5) // pass args and wait for 5 sec
```

#### Parameters

*   `fn` **([string][3] | [function][7])** to be executed in browser context.
*   `argsOrSec` **([Array][10]<any> | [number][11])?** (optional, `1` by default) arguments for function or seconds. 
*   `sec` **[number][11]?** (optional, `1` by default) time in seconds to wait 

Returns **void** automatically synchronized promise through #recorder

### waitForInvisible

Waits for an element to be removed or become invisible on a page (by default waits for 1sec).
Element can be located by CSS or XPath.

```js
I.waitForInvisible('#popup');
```

#### Parameters

*   `locator` **([string][3] | [object][4])** element located by CSS|XPath|strict locator.
*   `sec` **[number][11]** (optional, `1` by default) time in seconds to wait 

Returns **void** automatically synchronized promise through #recorder

### waitForText

Waits for a text to appear (by default waits for 1sec).
Element can be located by CSS or XPath.
Narrow down search results by providing context.

```js
I.waitForText('Thank you, form has been submitted');
I.waitForText('Thank you, form has been submitted', 5, '#modal');
```

#### Parameters

*   `text` **[string][3]** to wait for.
*   `sec` **[number][11]** (optional, `1` by default) time in seconds to wait 
*   `context` **([string][3] | [object][4])?** (optional) element located by CSS|XPath|strict locator. 

Returns **void** automatically synchronized promise through #recorder

### waitForVisible

Waits for an element to become visible on a page (by default waits for 1sec).
Element can be located by CSS or XPath.

```js
I.waitForVisible('#popup');
```

#### Parameters

*   `locator` **([string][3] | [object][4])** element located by CSS|XPath|strict locator.
*   `sec` **[number][11]** (optional, `1` by default) time in seconds to wait 

Returns **void** automatically synchronized promise through #recorder

### waitToHide

Waits for an element to hide (by default waits for 1sec).
Element can be located by CSS or XPath.

```js
I.waitToHide('#popup');
```

#### Parameters

*   `locator` **([string][3] | [object][4])** element located by CSS|XPath|strict locator.
*   `sec` **[number][11]** (optional, `1` by default) time in seconds to wait 

Returns **void** automatically synchronized promise through #recorder

[1]: https://github.com/segmentio/nightmare

[2]: https://github.com/segmentio/nightmare#api

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[5]: https://github.com/rosshinkley/nightmare-upload#important-note-about-setting-file-upload-inputs

[6]: https://vuejs.org/v2/api/#Vue-nextTick

[7]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Statements/function

[8]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise

[9]: https://github.com/segmentio/nightmare#evaluatefn-arg1-arg2

[10]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

[11]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[12]: http://electron.atom.io/docs/api/web-contents/#webcontentssendinputeventevent

[13]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[14]: https://github.com/segmentio/nightmare/blob/master/Readme.md#cookiessetcookie

[15]: http://electron.atom.io/docs/api/web-contents/#contentssendinputeventevent
