---
permalink: /helpers/MockServer
editLink: false
sidebar: auto
title: MockServer
---

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## MockServer

MockServer

The MockServer Helper in CodeceptJS empowers you to mock any server or service via HTTP or HTTPS, making it an excellent tool for simulating REST endpoints and other HTTP-based APIs.



## Configuration

This helper should be configured in codecept.conf.(js|ts)

Type: [object][1]

### Properties

-   `port` **[number][2]?** Mock server port
-   `host` **[string][3]?** Mock server host
-   `httpsOpts` **[object][1]?** key & cert values are the paths to .key and .crt files



#### Examples

You can seamlessly integrate MockServer with other helpers like REST or Playwright. Here's a configuration example inside the `codecept.conf.js` file:

```javascript
{
  helpers: {
    REST: {...},
    MockServer: {
      // default mock server config
      port: 9393,
      host: '0.0.0.0',
      httpsOpts: {
        key: '',
        cert: '',
      },
    },
  }
}
```

#### Adding Interactions

Interactions add behavior to the mock server. Use the `I.addInteractionToMockServer()` method to include interactions. It takes an interaction object as an argument, containing request and response details.

```javascript
I.addInteractionToMockServer({
   request: {
     method: 'GET',
     path: '/api/hello'
   },
   response: {
     status: 200,
     body: {
       'say': 'hello to mock server'
     }
   }
});
```

#### Request Matching

When a real request is sent to the mock server, it matches the received request with the interactions. If a match is found, it returns the specified response; otherwise, a 404 status code is returned.

-   Strong match on HTTP Method, Path, Query Params & JSON body.
-   Loose match on Headers.

##### Strong Match on Query Params

You can send different responses based on query parameters:

```javascript
I.addInteractionToMockServer({
  request: {
    method: 'GET',
    path: '/api/users',
    queryParams: {
      id: 1
    }
  },
  response: {
    status: 200,
    body: 'user 1'
  }
});

I.addInteractionToMockServer({
  request: {
    method: 'GET',
    path: '/api/users',
    queryParams: {
      id: 2
    }
  },
  response: {
    status: 200,
    body: 'user 2'
  }
});
```

-   GET to `/api/users?id=1` will return 'user 1'.
-   GET to `/api/users?id=2` will return 'user 2'.
-   For all other requests, it returns a 404 status code.

##### Loose Match on Body

When `strict` is set to false, it performs a loose match on query params and response body:

```javascript
I.addInteractionToMockServer({
  strict: false,
  request: {
    method: 'POST',
    path: '/api/users',
    body: {
      name: 'john'
    }
  },
  response: {
    status: 200
  }
});
```

-   POST to `/api/users` with the body containing `name` as 'john' will return a 200 status code.
-   POST to `/api/users` without the `name` property in the body will return a 404 status code.

Happy testing with MockServer in CodeceptJS! 🚀

## Methods

### Parameters

-   `passedConfig`  

### addInteractionToMockServer

An interaction adds behavior to the mock server

```js
I.addInteractionToMockServer({
   request: {
     method: 'GET',
     path: '/api/hello'
   },
   response: {
     status: 200,
     body: {
       'say': 'hello to mock server'
     }
   }
});
```

```js
// with query params
I.addInteractionToMockServer({
   request: {
     method: 'GET',
     path: '/api/hello',
     queryParams: {
      id: 2
    }
   },
   response: {
     status: 200,
     body: {
       'say': 'hello to mock server'
     }
   }
});
```

#### Parameters

-   `interaction` **(CodeceptJS.MockInteraction | [object][1])** add behavior to the mock server

Returns **any** void

### startMockServer

Start the mock server

#### Parameters

-   `port` **[number][2]?** start the mock server with given port

Returns **any** void

### stopMockServer

Stop the mock server

Returns **any** void

[1]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[2]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String
