---
permalink: /helpers/GraphQL
editLink: false
sidebar: auto
title: GraphQL
---

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## GraphQL

**Extends Helper**

GraphQL helper allows to send additional requests to a GraphQl endpoint during acceptance tests.
[Axios][1] library is used to perform requests.

## Configuration

*   endpoint: GraphQL base URL
*   timeout: timeout for requests in milliseconds. 10000ms by default
*   defaultHeaders: a list of default headers
*   onRequest: a async function which can update request object.

## Example

```js
GraphQL: {
   endpoint: 'http://site.com/graphql/',
   onRequest: (request) => {
     request.headers.auth = '123';
   }
}
```

## Access From Helpers

Send GraphQL requests by accessing `_executeQuery` method:

```js
this.helpers['GraphQL']._executeQuery({
   url,
   data,
});
```

## Methods

### Parameters

*   `config` &#x20;

### _executeQuery

Executes query via axios call

#### Parameters

*   `request` **[object][2]**&#x20;

### _prepareGraphQLRequest

Prepares request for axios call

#### Parameters

*   `operation` **[object][2]**&#x20;
*   `headers` **[object][2]**&#x20;

Returns **[object][2]** graphQLRequest

### amBearerAuthenticated

Adds a header for Bearer authentication

```js
// we use secret function to hide token from logs
I.amBearerAuthenticated(secret('heregoestoken'))
```

#### Parameters

*   `accessToken` **([string][3] | CodeceptJS.Secret)** Bearer access token

### haveRequestHeaders

Sets request headers for all requests of this test

#### Parameters

*   `headers` **[object][2]** headers list

### sendMutation

Send query to GraphQL endpoint over http

```js
I.sendMutation(`
      mutation createUser($user: UserInput!) {
         createUser(user: $user) {
           id
           name
           email
         }
       }
   `,
  { user: {
      name: 'John Doe',
      email: 'john@xmail.com'
    }
  },
});
```

#### Parameters

*   `mutation` **[String][3]**&#x20;
*   `variables` **[object][2]?** that may go along with the mutation
*   `options` **[object][2]?** are additional query options 
*   `headers` **[object][2]?**  

Returns **any** Promise<any>

### sendQuery

Send query to GraphQL endpoint over http.
Returns a response as a promise.

```js

const response = await I.sendQuery('{ users { name email }}');
// with variables
const response = await I.sendQuery(
 'query getUser($id: ID) { user(id: $id) { name email }}',
 { id: 1 },
)
const user = response.data.data;
```

#### Parameters

*   `query` **[String][3]**&#x20;
*   `variables` **[object][2]?** that may go along with the query
*   `options` **[object][2]?** are additional query options 
*   `headers` **[object][2]?**  

Returns **any** Promise<any>

[1]: https://github.com/axios/axios

[2]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String
