---
permalink: /helpers/FileSystem
editLink: false
sidebar: auto
title: FileSystem
---

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## FileSystem

**Extends Helper**

Helper for testing filesystem.
Can be easily used to check file structures:

```js
I.amInPath('test');
I.seeFile('codecept.js');
I.seeInThisFile('FileSystem');
I.dontSeeInThisFile("WebDriver");
```

## Configuration

Enable helper in config file:

```js
helpers: {
    FileSystem: {},
}
```

## Methods

### amInPath

Enters a directory In local filesystem.
Starts from a current directory

#### Parameters

*   `openPath` **[string][1]**&#x20;

### dontSeeFileContentsEqual

Checks that contents of file found by `seeFile` doesn't equal to text.

#### Parameters

*   `text` **[string][1]**&#x20;
*   `encoding` **[string][1]**  

### dontSeeInThisFile

Checks that file found by `seeFile` doesn't include text.

#### Parameters

*   `text` **[string][1]**&#x20;
*   `encoding` **[string][1]**  

### grabFileNames

Returns file names in current directory.

```js
I.handleDownloads();
I.click('Download Files');
I.amInPath('output/downloads');
const downloadedFileNames = I.grabFileNames();
```

### seeFile

Checks that file exists

#### Parameters

*   `name` **[string][1]**&#x20;

### seeFileContentsEqual

Checks that contents of file found by `seeFile` equal to text.

#### Parameters

*   `text` **[string][1]**&#x20;
*   `encoding` **[string][1]**  

### seeFileContentsEqualReferenceFile

Checks that contents of the file found by `seeFile` equal to contents of the file at `pathToReferenceFile`.

#### Parameters

*   `pathToReferenceFile` **[string][1]**&#x20;
*   `encoding` **[string][1]**  
*   `encodingReference` **[string][1]**  

### seeFileNameMatching

Checks that file with a name including given text exists in the current directory.

```js
I.handleDownloads();
I.click('Download as PDF');
I.amInPath('output/downloads');
I.seeFileNameMatching('.pdf');
```

#### Parameters

*   `text` **[string][1]**&#x20;

### seeInThisFile

Checks that file found by `seeFile` includes a text.

#### Parameters

*   `text` **[string][1]**&#x20;
*   `encoding` **[string][1]**  

### waitForFile

Waits for the file to be present in the current directory.

```js
I.handleDownloads('downloads/largeFilesName.txt');
I.click('Download large File');
I.amInPath('output/downloads');
I.waitForFile('largeFilesName.txt', 10); // wait 10 seconds for file
```

#### Parameters

*   `name` **[string][1]**&#x20;
*   `sec` **[number][2]** seconds to wait 

### writeToFile

Writes text to file

#### Parameters

*   `name` **[string][1]**&#x20;
*   `text` **[string][1]**&#x20;

[1]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[2]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number
