---
permalink: /helpers/Detox
sidebar: auto
title: Detox
---

# Detox


<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## Detox

**Extends Helper**

This is a wrapper on top of [Detox][1] library, aimied to unify testing experience for CodeceptJS framework.
Detox provides a grey box testing for mobile applications, playing especially good for React Native apps.

Detox plays quite differently from Appium. To establish detox testing you need to build a mobile application in a special way to inject Detox code.
This why **Detox is grey box testing** solution, so you need access to application source code, and a way to build and execute it on emulator.

Comparing to Appium, Detox runs faster and more stable but requires an additional setup for build.

### Setup

1.  [Install and configure Detox][2]
2.  [Build an application][3] using `detox build` command.
3.  Install [CodeceptJS][4] and detox-helper:

<!---->

    npm i @codeceptjs/detox-helper --save

Detox configuration is required in `package.json` under `detox` section.

If you completed step 1 and step 2 you should have a configuration similar this:

```js
 "detox": {
    "configurations": {
      "ios.sim.debug": {
        "device": "simulator",
        "app": "ios.debug"
      }
    },
    "apps": {
      "ios.debug": {
        "type": "ios.app",
        "binaryPath": "../test/ios/build/Build/Products/Debug-iphonesimulator/MyTestApp.app",
        "build": "xcodebuild -workspace ../test/ios/MyTestApp.xcworkspace -scheme MyTestApp -configuration Debug -sdk iphonesimulator -derivedDataPath ../test/ios/build"
      }
    },
    "devices": {
      "simulator": {
        "type": "ios.simulator",
        "device": {
          "type": "iPhone 15"
        }
      }
    }
  }
```

### Configuration

Besides Detox configuration, CodeceptJS should also be configured to use Detox.

In `codecept.conf.js` enable Detox helper:

```js
helpers: {
   Detox: {
     require: '@codeceptjs/detox-helper',
     configuration: '<detox-configuration-name>',
   }
}

```

It's important to specify a package name under `require` section and current detox configuration taken from `package.json`.

Options:

*   `configuration` - a detox configuration name. Required.
*   `reloadReactNative` - should be enabled for React Native applications.
*   `reuse` - reuse application for tests. By default, Detox reinstalls and relaunches app.
*   `registerGlobals` - (default: true) Register Detox helper functions `by`, `element`, `expect`, `waitFor` globally.
*   `url` - URL to open via deep-link each time the app is launched (android) or immediately afterwards (iOS). Useful for opening a bundle URL at the beginning of tests when working with Expo.

### Parameters

*   `config` &#x20;

### appendField

Appends text into the field.
A field can be located by text, accessibility id, id.

```js
I.appendField('name', 'davert');
```

#### Parameters

*   `field` **([string][5] | [object][6])**&#x20;
*   `value` **[string][5]**&#x20;

### checkIfElementExists

Checks if an element exists.

```js
I.checkIfElementExists('~edit'); // located by accessibility id
I.checkIfElementExists('~edit', '#menu'); // element inside #menu
```

#### Parameters

*   `locator` **([string][5] | [object][6])** element to locate
*   `context` **([string][5] | [object][6] | null)** context element (optional, default `null`)

### clearField

Clears a text field.
A field can be located by text, accessibility id, id.

```js
I.clearField('~name');
```

#### Parameters

*   `field` **([string][5] | [object][6])** an input element to clear

### click

Clicks on an element.
Element can be located by its text or id or accessibility id

The second parameter is a context (id | type | accessibility id) to narrow the search.

Same as [tap][7]

```js
I.click('Login'); // locate by text
I.click('~nav-1'); // locate by accessibility label
I.click('#user'); // locate by id
I.click('Login', '#nav'); // locate by text inside #nav
I.click({ ios: 'Save', android: 'SAVE' }, '#main'); // different texts on iOS and Android
```

#### Parameters

*   `locator` **([string][5] | [object][6])**&#x20;
*   `context` **([string][5] | [object][6] | null)**  (optional, default `null`)

### clickAtPoint

Performs click on element with horizontal and vertical offset.
An element is located by text, id, accessibility id.

```js
I.clickAtPoint('Save', 10, 10);
I.clickAtPoint('~save', 10, 10); // locate by accessibility id
```

#### Parameters

*   `locator` **([string][5] | [object][6])**&#x20;
*   `x` **[number][8]** horizontal offset (optional, default `0`)
*   `y` **[number][8]** vertical offset (optional, default `0`)

### dontSee

Checks text not to be visible.
Use second parameter to narrow down the search.

```js
I.dontSee('Record created');
I.dontSee('Record updated', '#message');
I.dontSee('Record deleted', '~message');
```

#### Parameters

*   `text` **[string][5]** to check invisibility
*   `context` **([string][5] | [object][6] | null)** element in which to search for text (optional, default `null`)

### dontSeeElement

Checks that element is not visible.
Use second parameter to narrow down the search.

```js
I.dontSeeElement('~edit'); // located by accessibility id
I.dontSeeElement('~edit', '#menu'); // element inside #menu
```

#### Parameters

*   `locator` **([string][5] | [object][6])** element to locate
*   `context` **([string][5] | [object][6] | null)** context element (optional, default `null`)

### dontSeeElementExists

Checks that element not exists.
Use second parameter to narrow down the search.

```js
I.dontSeeElementExist('~edit'); // located by accessibility id
I.dontSeeElementExist('~edit', '#menu'); // element inside #menu
```

#### Parameters

*   `locator` **([string][5] | [object][6])** element to locate
*   `context` **([string][5] | [object][6])** context element (optional, default `null`)

### fillField

Fills in text field in an app.
A field can be located by text, accessibility id, id.

```js
I.fillField('Username', 'davert');
I.fillField('~name', 'davert');
I.fillField({ android: 'NAME', ios: 'name' }, 'davert');
```

#### Parameters

*   `field` **([string][5] | [object][6])** an input element to fill in
*   `value` **[string][5]** value to fill

### goBack

Goes back on Android

```js
I.goBack(); // on Android only
```

### grabPlatform

Grab the device platform

```js
const platform = await I.grabPlatform();
```

### installApp

Installs a configured application.
Application is installed by default.

```js
I.installApp();
```

### launchApp

Launches an application. If application instance already exists, use [relaunchApp][9].

```js
I.launchApp();
```

### longPress

Taps an element and holds for a requested time.

```js
I.longPress('Login', 2); // locate by text, hold for 2 seconds
I.longPress('~nav', 1); // locate by accessibility label, hold for second
I.longPress('Update', 2, '#menu'); // locate by text inside #menu, hold for 2 seconds
```

#### Parameters

*   `locator` **([string][5] | [object][6])** element to locate
*   `sec` **[number][8]** number of seconds to hold tap
*   `context` **([string][5] | [object][6] | null)** context element (optional, default `null`)

### multiTap

Multi taps on an element.
Element can be located by its text or id or accessibility id.

Set the number of taps in second argument.
Optionally define the context element by third argument.

```js
I.multiTap('Login', 2); // locate by text
I.multiTap('~nav', 2); // locate by accessibility label
I.multiTap('#user', 2); // locate by id
I.multiTap('Update', 2, '#menu'); // locate by id
```

#### Parameters

*   `locator` **([string][5] | [object][6])** element to locate
*   `num` **[number][8]** number of taps
*   `context` **([string][5] | [object][6] | null)** context element (optional, default `null`)

### relaunchApp

Relaunches an application.

```js
I.relaunchApp();
```

### runOnAndroid

Execute code only on Android

```js
I.runOnAndroid(() => {
   I.click('Button');
   I.see('Hi, Android');
});
```

#### Parameters

*   `fn` **[Function][10]** a function which will be executed on android

### runOnIOS

Execute code only on iOS

```js
I.runOnIOS(() => {
   I.click('Button');
   I.see('Hi, IOS');
});
```

#### Parameters

*   `fn` **[Function][10]** a function which will be executed on iOS

### saveScreenshot

Saves a screenshot to the output dir

```js
I.saveScreenshot('main-window.png');
```

#### Parameters

*   `name` **[string][5]**&#x20;

### scrollDown

Scrolls to the bottom of an element.

```js
I.scrollDown('#container');
```

#### Parameters

*   `locator` **([string][5] | [object][6])**&#x20;

### scrollLeft

Scrolls to the left of an element.

```js
I.scrollLeft('#container');
```

#### Parameters

*   `locator` **([string][5] | [object][6])**&#x20;

### scrollRight

Scrolls to the right of an element.

```js
I.scrollRight('#container');
```

#### Parameters

*   `locator` **([string][5] | [object][6])**&#x20;

### scrollToElement

Scrolls within a scrollable container to an element.

#### Parameters

*   `targetLocator` **([string][5] | [object][6])** Locator of the element to scroll to
*   `containerLocator` **([string][5] | [object][6])** Locator of the scrollable container
*   `direction` **[string][5]** 'up' or 'down' (optional, default `'down'`)
*   `offset` **[number][8]** Offset for scroll, can be adjusted based on need (optional, default `100`)

### scrollUp

Scrolls to the top of an element.

```js
I.scrollUp('#container');
```

#### Parameters

*   `locator` **([string][5] | [object][6])**&#x20;

### see

Checks text to be visible.
Use second parameter to narrow down the search.

```js
I.see('Record created');
I.see('Record updated', '#message');
I.see('Record deleted', '~message');
```

#### Parameters

*   `text` **[string][5]** to check visibility
*   `context` **([string][5] | [object][6] | null)** element inside which to search for text (optional, default `null`)

### seeElement

Checks for visibility of an element.
Use second parameter to narrow down the search.

```js
I.seeElement('~edit'); // located by accessibility id
I.seeElement('~edit', '#menu'); // element inside #menu
```

#### Parameters

*   `locator` **([string][5] | [object][6])** element to locate
*   `context` **([string][5] | [object][6] | null)** context element (optional, default `null`)

### seeElementExists

Checks for existence of an element. An element can be visible or not.
Use second parameter to narrow down the search.

```js
I.seeElementExists('~edit'); // located by accessibility id
I.seeElementExists('~edit', '#menu'); // element inside #menu
```

#### Parameters

*   `locator` **([string][5] | [object][6])** element to locate
*   `context` **([string][5] | [object][6])** context element (optional, default `null`)

### setLandscapeOrientation

Switches device to landscape orientation

```js
I.setLandscapeOrientation();
```

### setPortraitOrientation

Switches device to portrait orientation

```js
I.setPortraitOrientation();
```

### shakeDevice

Shakes the device.

```js
I.shakeDevice();
```

### swipeDown

Performs a swipe up inside an element.
Can be `slow` or `fast` swipe.

```js
I.swipeUp('#container');
```

#### Parameters

*   `locator` **([string][5] | [object][6])** an element on which to perform swipe
*   `speed` **[string][5]** a speed to perform: `slow` or `fast`. (optional, default `'slow'`)

### swipeLeft

Performs a swipe up inside an element.
Can be `slow` or `fast` swipe.

```js
I.swipeUp('#container');
```

#### Parameters

*   `locator` **([string][5] | [object][6])** an element on which to perform swipe
*   `speed` **[string][5]** a speed to perform: `slow` or `fast`. (optional, default `'slow'`)

### swipeRight

Performs a swipe up inside an element.
Can be `slow` or `fast` swipe.

```js
I.swipeUp('#container');
```

#### Parameters

*   `locator` **([string][5] | [object][6])** an element on which to perform swipe
*   `speed` **[string][5]** a speed to perform: `slow` or `fast`. (optional, default `'slow'`)

### swipeUp

Performs a swipe up inside an element.
Can be `slow` or `fast` swipe.

```js
I.swipeUp('#container');
```

#### Parameters

*   `locator` **([string][5] | [object][6])** an element on which to perform swipe
*   `speed` **[string][5]** a speed to perform: `slow` or `fast`. (optional, default `'slow'`)

### tap

Taps on an element.
Element can be located by its text or id or accessibility id.

The second parameter is a context element to narrow the search.

Same as [click][11]

```js
I.tap('Login'); // locate by text
I.tap('~nav-1'); // locate by accessibility label
I.tap('#user'); // locate by id
I.tap('Login', '#nav'); // locate by text inside #nav
I.tap({ ios: 'Save', android: 'SAVE' }, '#main'); // different texts on iOS and Android
```

#### Parameters

*   `locator` **([string][5] | [object][6])**&#x20;
*   `context` **([string][5] | [object][6] | null)**  (optional, default `null`)

### tapByLabel

Clicks on an element.
Element can be located by its label

The second parameter is a context (id | type | accessibility id) to narrow the search.

```js
I.tapByLabel('Login'); // locate by text
I.tapByLabel('Login', '#nav'); // locate by text inside #nav
```

#### Parameters

*   `locator` **([string][5] | [object][6])**&#x20;
*   `context` **([string][5] | [object][6] | null)**  (optional, default `null`)

### tapReturnKey

Taps return key.
A field can be located by text, accessibility id, id.

```js
I.tapReturnKey('Username');
I.tapReturnKey('~name');
I.tapReturnKey({ android: 'NAME', ios: 'name' });
```

#### Parameters

*   `field` **([string][5] | [object][6])** an input element to fill in

### wait

Waits for number of seconds

```js
I.wait(2); // waits for 2 seconds
```

#### Parameters

*   `sec` **[number][8]** number of seconds to wait

### waitForElement

Waits for an element to exist on page.

```js
I.waitForElement('#message', 1); // wait for 1 second
```

#### Parameters

*   `locator` **([string][5] | [object][6])** an element to wait for
*   `sec` **[number][8]** number of seconds to wait, 5 by default (optional, default `5`)

### waitForElementVisible

Waits for an element to be visible on page.

```js
I.waitForElementVisible('#message', 1); // wait for 1 second
```

#### Parameters

*   `locator` **([string][5] | [object][6])** an element to wait for
*   `sec` **[number][8]** number of seconds to wait (optional, default `5`)

### waitToHide

Waits an elmenet to become not visible.

```js
I.waitToHide('#message', 2); // wait for 2 seconds
```

#### Parameters

*   `locator` **([string][5] | [object][6])** an element to wait for
*   `sec` **[number][8]** number of seconds to wait (optional, default `5`)

[1]: https://github.com/wix/Detox

[2]: https://wix.github.io/Detox/docs/introduction/project-setup

[3]: https://wix.github.io/Detox/docs/introduction/project-setup#step-5-build-the-app

[4]: https://codecept.io

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[7]: #tap

[8]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[9]: #relaunchApp

[10]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Statements/function

[11]: #click
