---
permalink: /helpers/Appium
editLink: false
sidebar: auto
title: Appium
---

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## Appium

**Extends Webdriver**

Appium helper extends [Webdriver][1] helper.
It supports all browser methods and also includes special methods for mobile apps testing.
You can use this helper to test Web on desktop and mobile devices and mobile apps.

## Appium Installation

Appium is an open source test automation framework for use with native, hybrid and mobile web apps that implements the WebDriver protocol.
It allows you to run Selenium tests on mobile devices and also test native, hybrid and mobile web apps.

Download and install [Appium][2]

```sh
npm install -g appium
```

Launch the daemon: `appium`

## Helper configuration

This helper should be configured in codecept.conf.ts or codecept.conf.js

*   `appiumV2`: set this to true if you want to run tests with AppiumV2. See more how to setup [here][3]
*   `app`: Application path. Local path or remote URL to an .ipa or .apk file, or a .zip containing one of these. Alias to desiredCapabilities.appPackage
*   `host`: (default: 'localhost') Appium host
*   `port`: (default: '4723') Appium port
*   `platform`: (Android or IOS), which mobile OS to use; alias to desiredCapabilities.platformName
*   `restart`: restart browser or app between tests (default: true), if set to false cookies will be cleaned but browser window will be kept and for apps nothing will be changed.
*   `desiredCapabilities`: \[], Appium capabilities, see below
    *   `platformName` - Which mobile OS platform to use
    *   `appPackage` - Java package of the Android app you want to run
    *   `appActivity` - Activity name for the Android activity you want to launch from your package.
    *   `deviceName`: The kind of mobile device or emulator to use
    *   `platformVersion`: Mobile OS version
    *   `app` - The absolute local path or remote http URL to an .ipa or .apk file, or a .zip containing one of these. Appium will attempt to install this app binary on the appropriate device first.
    *   `browserName`: Name of mobile web browser to automate. Should be an empty string if automating an app instead.

Example Android App:

```js
{
  helpers: {
      Appium: {
          platform: "Android",
          desiredCapabilities: {
              appPackage: "com.example.android.myApp",
              appActivity: "MainActivity",
              deviceName: "OnePlus3",
              platformVersion: "6.0.1"
          }
      }
    }
}
```

Example iOS Mobile Web with local Appium:

```js
{
helpers: {
  Appium: {
    platform: "iOS",
    url: "https://the-internet.herokuapp.com/",
    desiredCapabilities: {
      deviceName: "iPhone X",
      platformVersion: "12.0",
      browserName: "safari"
    }
  }
}
}
```

Example iOS Mobile Web on BrowserStack:

```js
{
helpers: {
  Appium: {
    host: "hub-cloud.browserstack.com",
    port: 4444,
    user: process.env.BROWSERSTACK_USER,
    key: process.env.BROWSERSTACK_KEY,
    platform: "iOS",
    url: "https://the-internet.herokuapp.com/",
    desiredCapabilities: {
      realMobile: "true",
      device: "iPhone 8",
      os_version: "12",
      browserName: "safari"
    }
  }
}
}
```

Example Android App using AppiumV2 on BrowserStack:

```js
{
helpers: {
  Appium: {
        appiumV2: true,
        host: "hub-cloud.browserstack.com",
        port: 4444,
        user: process.env.BROWSERSTACK_USER,
        key: process.env.BROWSERSTACK_KEY,
        app: `bs://c700ce60cf1gjhgjh3ae8ed9770ghjg5a55b8e022f13c5827cg`,
        browser: '',
        desiredCapabilities: {
            'appPackage': data.packageName,
            'deviceName': process.env.DEVICE || 'Google Pixel 3',
            'platformName': process.env.PLATFORM || 'android',
            'platformVersion': process.env.OS_VERSION || '10.0',
            'automationName': process.env.ENGINE || 'UIAutomator2',
            'newCommandTimeout': 300000,
            'androidDeviceReadyTimeout': 300000,
            'androidInstallTimeout': 90000,
            'appWaitDuration': 300000,
            'autoGrantPermissions': true,
            'gpsEnabled': true,
            'isHeadless': false,
            'noReset': false,
            'noSign': true,
            'bstack:options' : {
                "appiumVersion" : "2.0.1",
            },
        }
  }
}
}
```

Additional configuration params can be used from [https://github.com/appium/appium/blob/master/packages/appium/docs/en/guides/caps.md][4]

## Access From Helpers

Receive Appium client from a custom helper by accessing `browser` property:

```js
let browser = this.helpers['Appium'].browser
```

## Methods

### Parameters

*   `config` &#x20;

### runOnIOS

Execute code only on iOS

```js
I.runOnIOS(() => {
   I.click('//UIAApplication[1]/UIAWindow[1]/UIAButton[1]');
   I.see('Hi, IOS', '~welcome');
});
```

Additional filter can be applied by checking for capabilities.
For instance, this code will be executed only on iPhone 5s:

```js
I.runOnIOS({deviceName: 'iPhone 5s'},() => {
   // ...
});
```

Also capabilities can be checked by a function.

```js
I.runOnAndroid((caps) => {
   // caps is current config of desiredCapabiliites
   return caps.platformVersion >= 6
},() => {
   // ...
});
```

#### Parameters

*   `caps` **any**&#x20;
*   `fn` **any**&#x20;

### runOnAndroid

Execute code only on Android

```js
I.runOnAndroid(() => {
   I.click('io.selendroid.testapp:id/buttonTest');
});
```

Additional filter can be applied by checking for capabilities.
For instance, this code will be executed only on Android 6.0:

```js
I.runOnAndroid({platformVersion: '6.0'},() => {
   // ...
});
```

Also capabilities can be checked by a function.
In this case, code will be executed only on Android >= 6.

```js
I.runOnAndroid((caps) => {
   // caps is current config of desiredCapabiliites
   return caps.platformVersion >= 6
},() => {
   // ...
});
```

#### Parameters

*   `caps` **any**&#x20;
*   `fn` **any**&#x20;

### runInWeb

Execute code only in Web mode.

```js
I.runInWeb(() => {
   I.waitForElement('#data');
   I.seeInCurrentUrl('/data');
});
```

### checkIfAppIsInstalled

Returns app installation status.

```js
I.checkIfAppIsInstalled("com.example.android.apis");
```

#### Parameters

*   `bundleId` **[string][5]** String  ID of bundled app

Returns **[Promise][6]<[boolean][7]>** Appium: support only Android

### seeAppIsInstalled

Check if an app is installed.

```js
I.seeAppIsInstalled("com.example.android.apis");
```

#### Parameters

*   `bundleId` **[string][5]** String  ID of bundled app

Returns **[Promise][6]\<void>** Appium: support only Android

### seeAppIsNotInstalled

Check if an app is not installed.

```js
I.seeAppIsNotInstalled("com.example.android.apis");
```

#### Parameters

*   `bundleId` **[string][5]** String  ID of bundled app

Returns **[Promise][6]\<void>** Appium: support only Android

### installApp

Install an app on device.

```js
I.installApp('/path/to/file.apk');
```

#### Parameters

*   `path` **[string][5]** path to apk file

Returns **[Promise][6]\<void>** Appium: support only Android

### removeApp

Remove an app from the device.

```js
I.removeApp('appName', 'com.example.android.apis');
```

Appium: support only Android

#### Parameters

*   `appId` **[string][5]**&#x20;
*   `bundleId` **[string][5]?** ID of bundle

### resetApp

Reset the currently running app for current session.

```js
I.resetApp();
```

### seeCurrentActivityIs

Check current activity on an Android device.

```js
I.seeCurrentActivityIs(".HomeScreenActivity")
```

#### Parameters

*   `currentActivity` **[string][5]**&#x20;

Returns **[Promise][6]\<void>** Appium: support only Android

### seeDeviceIsLocked

Check whether the device is locked.

```js
I.seeDeviceIsLocked();
```

Returns **[Promise][6]\<void>** Appium: support only Android

### seeDeviceIsUnlocked

Check whether the device is not locked.

```js
I.seeDeviceIsUnlocked();
```

Returns **[Promise][6]\<void>** Appium: support only Android

### seeOrientationIs

Check the device orientation

```js
I.seeOrientationIs('PORTRAIT');
I.seeOrientationIs('LANDSCAPE')
```

#### Parameters

*   `orientation` **(`"LANDSCAPE"` | `"PORTRAIT"`)** LANDSCAPE or PORTRAITAppium: support Android and iOS

Returns **[Promise][6]\<void>**&#x20;

### setOrientation

Set a device orientation. Will fail, if app will not set orientation

```js
I.setOrientation('PORTRAIT');
I.setOrientation('LANDSCAPE')
```

#### Parameters

*   `orientation` **(`"LANDSCAPE"` | `"PORTRAIT"`)** LANDSCAPE or PORTRAITAppium: support Android and iOS

### grabAllContexts

Get list of all available contexts

    let contexts = await I.grabAllContexts();

Returns **[Promise][6]<[Array][8]<[string][5]>>** Appium: support Android and iOS

### grabContext

Retrieve current context

```js
let context = await I.grabContext();
```

Returns **[Promise][6]<([string][5] | null)>** Appium: support Android and iOS

### grabCurrentActivity

Get current device activity.

```js
let activity = await I.grabCurrentActivity();
```

Returns **[Promise][6]<[string][5]>** Appium: support only Android

### grabNetworkConnection

Get information about the current network connection (Data/WIFI/Airplane).
The actual server value will be a number. However WebdriverIO additional
properties to the response object to allow easier assertions.

```js
let con = await I.grabNetworkConnection();
```

Returns **[Promise][6]<{}>** Appium: support only Android

### grabOrientation

Get current orientation.

```js
let orientation = await I.grabOrientation();
```

Returns **[Promise][6]<[string][5]>** Appium: support Android and iOS

### grabSettings

Get all the currently specified settings.

```js
let settings = await I.grabSettings();
```

Returns **[Promise][6]<[string][5]>** Appium: support Android and iOS

### switchToContext

Switch to the specified context.

#### Parameters

*   `context` **any** the context to switch to

### switchToWeb

Switches to web context.
If no context is provided switches to the first detected web context

```js
// switch to first web context
I.switchToWeb();

// or set the context explicitly
I.switchToWeb('WEBVIEW_io.selendroid.testapp');
```

#### Parameters

*   `context` **[string][5]?**&#x20;

Returns **[Promise][6]\<void>**&#x20;

### switchToNative

Switches to native context.
By default switches to NATIVE\_APP context unless other specified.

```js
I.switchToNative();

// or set context explicitly
I.switchToNative('SOME_OTHER_CONTEXT');
```

#### Parameters

*   `context` **any?**  (optional, default `null`)

Returns **[Promise][6]\<void>**&#x20;

### startActivity

Start an arbitrary Android activity during a session.

```js
I.startActivity('io.selendroid.testapp', '.RegisterUserActivity');
```

Appium: support only Android

#### Parameters

*   `appPackage` **[string][5]**&#x20;
*   `appActivity` **[string][5]**&#x20;

Returns **[Promise][6]\<void>**&#x20;

### setNetworkConnection

Set network connection mode.

*   airplane mode
*   wifi mode
*   data data

```js
I.setNetworkConnection(0) // airplane mode off, wifi off, data off
I.setNetworkConnection(1) // airplane mode on, wifi off, data off
I.setNetworkConnection(2) // airplane mode off, wifi on, data off
I.setNetworkConnection(4) // airplane mode off, wifi off, data on
I.setNetworkConnection(6) // airplane mode off, wifi on, data on
```

See corresponding [webdriverio reference][9].

Appium: support only Android

#### Parameters

*   `value` **[number][10]** The network connection mode bitmask

Returns **[Promise][6]<[number][10]>**&#x20;

### setSettings

Update the current setting on the device

```js
I.setSettings({cyberdelia: 'open'});
```

#### Parameters

*   `settings` **[object][11]** objectAppium: support Android and iOS

### hideDeviceKeyboard

Hide the keyboard.

```js
// taps outside to hide keyboard per default
I.hideDeviceKeyboard();
I.hideDeviceKeyboard('tapOutside');

// or by pressing key
I.hideDeviceKeyboard('pressKey', 'Done');
```

Appium: support Android and iOS

#### Parameters

*   `strategy` **(`"tapOutside"` | `"pressKey"`)?** Desired strategy to close keyboard (‘tapOutside’ or ‘pressKey’)
*   `key` **[string][5]?** Optional key

### sendDeviceKeyEvent

Send a key event to the device.
List of keys: [https://developer.android.com/reference/android/view/KeyEvent.html][12]

```js
I.sendDeviceKeyEvent(3);
```

#### Parameters

*   `keyValue` **[number][10]** Device specific key value

Returns **[Promise][6]\<void>** Appium: support only Android

### openNotifications

Open the notifications panel on the device.

```js
I.openNotifications();
```

Returns **[Promise][6]\<void>** Appium: support only Android

### makeTouchAction

The Touch Action API provides the basis of all gestures that can be
automated in Appium. At its core is the ability to chain together ad hoc
individual actions, which will then be applied to an element in the
application on the device.
[See complete documentation][13]

```js
I.makeTouchAction("~buttonStartWebviewCD", 'tap');
```

#### Parameters

*   `locator` &#x20;
*   `action` &#x20;

Returns **[Promise][6]\<void>** Appium: support Android and iOS

### tap

Taps on element.

```js
I.tap("~buttonStartWebviewCD");
```

Shortcut for `makeTouchAction`

#### Parameters

*   `locator` **any**&#x20;

Returns **[Promise][6]\<void>**&#x20;

### swipe

Perform a swipe on the screen or an element.

```js
let locator = "#io.selendroid.testapp:id/LinearLayout1";
I.swipe(locator, 800, 1200, 1000);
```

[See complete reference][14]

#### Parameters

*   `locator` **([string][5] | [object][11])**&#x20;
*   `xoffset` **[number][10]**&#x20;
*   `yoffset` **[number][10]**&#x20;
*   `speed` **[number][10]** (optional), 1000 by default (optional, default `1000`)

Returns **[Promise][6]\<void>** Appium: support Android and iOS

### performSwipe

Perform a swipe on the screen.

```js
I.performSwipe({ x: 300, y: 100 }, { x: 200, y: 100 });
```

#### Parameters

*   `from` **[object][11]**&#x20;
*   `to` **[object][11]** Appium: support Android and iOS

### swipeDown

Perform a swipe down on an element.

```js
let locator = "#io.selendroid.testapp:id/LinearLayout1";
I.swipeDown(locator); // simple swipe
I.swipeDown(locator, 500); // set speed
I.swipeDown(locator, 1200, 1000); // set offset and speed
```

#### Parameters

*   `locator` **([string][5] | [object][11])**&#x20;
*   `yoffset` **[number][10]?** (optional) (optional, default `1000`)
*   `speed` **[number][10]** (optional), 1000 by default (optional, default `1000`)

Returns **[Promise][6]\<void>** Appium: support Android and iOS

### swipeLeft

Perform a swipe left on an element.

```js
let locator = "#io.selendroid.testapp:id/LinearLayout1";
I.swipeLeft(locator); // simple swipe
I.swipeLeft(locator, 500); // set speed
I.swipeLeft(locator, 1200, 1000); // set offset and speed
```

#### Parameters

*   `locator` **([string][5] | [object][11])**&#x20;
*   `xoffset` **[number][10]?** (optional) (optional, default `1000`)
*   `speed` **[number][10]** (optional), 1000 by default (optional, default `1000`)

Returns **[Promise][6]\<void>** Appium: support Android and iOS

### swipeRight

Perform a swipe right on an element.

```js
let locator = "#io.selendroid.testapp:id/LinearLayout1";
I.swipeRight(locator); // simple swipe
I.swipeRight(locator, 500); // set speed
I.swipeRight(locator, 1200, 1000); // set offset and speed
```

#### Parameters

*   `locator` **([string][5] | [object][11])**&#x20;
*   `xoffset` **[number][10]?** (optional) (optional, default `1000`)
*   `speed` **[number][10]** (optional), 1000 by default (optional, default `1000`)

Returns **[Promise][6]\<void>** Appium: support Android and iOS

### swipeUp

Perform a swipe up on an element.

```js
let locator = "#io.selendroid.testapp:id/LinearLayout1";
I.swipeUp(locator); // simple swipe
I.swipeUp(locator, 500); // set speed
I.swipeUp(locator, 1200, 1000); // set offset and speed
```

#### Parameters

*   `locator` **([string][5] | [object][11])**&#x20;
*   `yoffset` **[number][10]?** (optional) (optional, default `1000`)
*   `speed` **[number][10]** (optional), 1000 by default (optional, default `1000`)

Returns **[Promise][6]\<void>** Appium: support Android and iOS

### swipeTo

Perform a swipe in selected direction on an element to searchable element.

```js
I.swipeTo(
 "android.widget.CheckBox", // searchable element
 "//android.widget.ScrollView/android.widget.LinearLayout", // scroll element
  "up", // direction
   30,
   100,
   500);
```

#### Parameters

*   `searchableLocator` **[string][5]**&#x20;
*   `scrollLocator` **[string][5]**&#x20;
*   `direction` **[string][5]**&#x20;
*   `timeout` **[number][10]**&#x20;
*   `offset` **[number][10]**&#x20;
*   `speed` **[number][10]**&#x20;

Returns **[Promise][6]\<void>** Appium: support Android and iOS

### touchPerform

Performs a specific touch action.
The action object need to contain the action name, x/y coordinates

```js
I.touchPerform([{
    action: 'press',
    options: {
      x: 100,
      y: 200
    }
}, {action: 'release'}])

I.touchPerform([{
   action: 'tap',
   options: {
       element: '1', // json web element was queried before
       x: 10,   // x offset
       y: 20,   // y offset
       count: 1 // number of touches
   }
}]);
```

Appium: support Android and iOS

#### Parameters

*   `actions` **[Array][8]** Array of touch actions

### pullFile

Pulls a file from the device.

```js
I.pullFile('/storage/emulated/0/DCIM/logo.png', 'my/path');
// save file to output dir
I.pullFile('/storage/emulated/0/DCIM/logo.png', output_dir);
```

#### Parameters

*   `path` **[string][5]**&#x20;
*   `dest` **[string][5]**&#x20;

Returns **[Promise][6]<[string][5]>** Appium: support Android and iOS

### shakeDevice

Perform a shake action on the device.

```js
I.shakeDevice();
```

Returns **[Promise][6]\<void>** Appium: support only iOS

### rotate

Perform a rotation gesture centered on the specified element.

```js
I.rotate(120, 120)
```

See corresponding [webdriverio reference][15].

#### Parameters

*   `x` &#x20;
*   `y` &#x20;
*   `duration` &#x20;
*   `radius` &#x20;
*   `rotation` &#x20;
*   `touchCount` &#x20;

Returns **[Promise][6]\<void>** Appium: support only iOS

### setImmediateValue

Set immediate value in app.

See corresponding [webdriverio reference][16].

#### Parameters

*   `id` &#x20;
*   `value` &#x20;

Returns **[Promise][6]\<void>** Appium: support only iOS

### simulateTouchId

Simulate Touch ID with either valid (match == true) or invalid (match == false) fingerprint.

```js
I.touchId(); // simulates valid fingerprint
I.touchId(true); // simulates valid fingerprint
I.touchId(false); // simulates invalid fingerprint
```

#### Parameters

*   `match` &#x20;

Returns **[Promise][6]\<void>** Appium: support only iOS
TODO: not tested

### closeApp

Close the given application.

```js
I.closeApp();
```

Returns **[Promise][6]\<void>** Appium: support both Android and iOS

### appendField

Appends text to a input field or textarea.
Field is located by name, label, CSS or XPath

```js
I.appendField('#myTextField', 'appended');
// typing secret
I.appendField('password', secret('123456'));
```

#### Parameters

*   `field` **([string][5] | [object][11])** located by label|name|CSS|XPath|strict locator
*   `value` **[string][5]** text value to append.

Returns **void** automatically synchronized promise through #recorder

### checkOption

Selects a checkbox or radio button.
Element is located by label or name or CSS or XPath.

The second parameter is a context (CSS or XPath locator) to narrow the search.

```js
I.checkOption('#agree');
I.checkOption('I Agree to Terms and Conditions');
I.checkOption('agree', '//form');
```

#### Parameters

*   `field` **([string][5] | [object][11])** checkbox located by label | name | CSS | XPath | strict locator.
*   `context` **([string][5]? | [object][11])** (optional, `null` by default) element located by CSS | XPath | strict locator. (optional, default `null`)

Returns **void** automatically synchronized promise through #recorder

### click

Perform a click on a link or a button, given by a locator.
If a fuzzy locator is given, the page will be searched for a button, link, or image matching the locator string.
For buttons, the "value" attribute, "name" attribute, and inner text are searched. For links, the link text is searched.
For images, the "alt" attribute and inner text of any parent links are searched.

The second parameter is a context (CSS or XPath locator) to narrow the search.

```js
// simple link
I.click('Logout');
// button of form
I.click('Submit');
// CSS button
I.click('#form input[type=submit]');
// XPath
I.click('//form/*[@type=submit]');
// link in context
I.click('Logout', '#nav');
// using strict locator
I.click({css: 'nav a.login'});
```

#### Parameters

*   `locator` **([string][5] | [object][11])** clickable link or button located by text, or any element located by CSS|XPath|strict locator.
*   `context` **([string][5]? | [object][11] | null)** (optional, `null` by default) element to search in CSS|XPath|Strict locator. (optional, default `null`)

Returns **void** automatically synchronized promise through #recorder

### dontSeeCheckboxIsChecked

Verifies that the specified checkbox is not checked.

```js
I.dontSeeCheckboxIsChecked('#agree'); // located by ID
I.dontSeeCheckboxIsChecked('I agree to terms'); // located by label
I.dontSeeCheckboxIsChecked('agree'); // located by name
```

#### Parameters

*   `field` **([string][5] | [object][11])** located by label|name|CSS|XPath|strict locator.

Returns **void** automatically synchronized promise through #recorder

### dontSeeElement

Opposite to `seeElement`. Checks that element is not visible (or in DOM)

```js
I.dontSeeElement('.modal'); // modal is not shown
```

#### Parameters

*   `locator` **([string][5] | [object][11])** located by CSS|XPath|Strict locator.

Returns **void** automatically synchronized promise through #recorder

### dontSeeInField

Checks that value of input field or textarea doesn't equal to given value
Opposite to `seeInField`.

```js
I.dontSeeInField('email', 'user@user.com'); // field by name
I.dontSeeInField({ css: 'form input.email' }, 'user@user.com'); // field by CSS
```

#### Parameters

*   `field` **([string][5] | [object][11])** located by label|name|CSS|XPath|strict locator.
*   `value` **([string][5] | [object][11])** value to check.

Returns **void** automatically synchronized promise through #recorder

### dontSee

Opposite to `see`. Checks that a text is not present on a page.
Use context parameter to narrow down the search.

```js
I.dontSee('Login'); // assume we are already logged in.
I.dontSee('Login', '.nav'); // no login inside .nav element
```

#### Parameters

*   `text` **[string][5]** which is not present.
*   `context` **([string][5] | [object][11])?** (optional) element located by CSS|XPath|strict locator in which to perfrom search. (optional, default `null`)

Returns **void** automatically synchronized promise through #recorder

### fillField

Fills a text field or textarea, after clearing its value, with the given string.
Field is located by name, label, CSS, or XPath.

```js
// by label
I.fillField('Email', 'hello@world.com');
// by name
I.fillField('password', secret('123456'));
// by CSS
I.fillField('form#login input[name=username]', 'John');
// or by strict locator
I.fillField({css: 'form#login input[name=username]'}, 'John');
```

#### Parameters

*   `field` **([string][5] | [object][11])** located by label|name|CSS|XPath|strict locator.
*   `value` **([string][5] | [object][11])** text value to fill.

Returns **void** automatically synchronized promise through #recorder

### grabTextFromAll

Retrieves all texts from an element located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async with `await`** operator.

```js
let pins = await I.grabTextFromAll('#pin li');
```

#### Parameters

*   `locator` **([string][5] | [object][11])** element located by CSS|XPath|strict locator.

Returns **[Promise][6]<[Array][8]<[string][5]>>** attribute value

### grabTextFrom

Retrieves a text from an element located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async with `await`** operator.

```js
let pin = await I.grabTextFrom('#pin');
```

If multiple elements found returns first element.

#### Parameters

*   `locator` **([string][5] | [object][11])** element located by CSS|XPath|strict locator.

Returns **[Promise][6]<[string][5]>** attribute value

### grabNumberOfVisibleElements

Grab number of visible elements by locator.
Resumes test execution, so **should be used inside async function with `await`** operator.

```js
let numOfElements = await I.grabNumberOfVisibleElements('p');
```

#### Parameters

*   `locator` **([string][5] | [object][11])** located by CSS|XPath|strict locator.

Returns **[Promise][6]<[number][10]>** number of visible elements

### grabAttributeFrom

Can be used for apps only with several values ("contentDescription", "text", "className", "resourceId")

Retrieves an attribute from an element located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async with `await`** operator.
If more than one element is found - attribute of first element is returned.

```js
let hint = await I.grabAttributeFrom('#tooltip', 'title');
```

#### Parameters

*   `locator` **([string][5] | [object][11])** element located by CSS|XPath|strict locator.
*   `attr` **[string][5]** attribute name.

Returns **[Promise][6]<[string][5]>** attribute value

### grabAttributeFromAll

Can be used for apps only with several values ("contentDescription", "text", "className", "resourceId")
Retrieves an array of attributes from elements located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async with `await`** operator.

```js
let hints = await I.grabAttributeFromAll('.tooltip', 'title');
```

#### Parameters

*   `locator` **([string][5] | [object][11])** element located by CSS|XPath|strict locator.
*   `attr` **[string][5]** attribute name.

Returns **[Promise][6]<[Array][8]<[string][5]>>** attribute value

### grabValueFromAll

Retrieves an array of value from a form located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async function with `await`** operator.

```js
let inputs = await I.grabValueFromAll('//form/input');
```

#### Parameters

*   `locator` **([string][5] | [object][11])** field located by label|name|CSS|XPath|strict locator.

Returns **[Promise][6]<[Array][8]<[string][5]>>** attribute value

### grabValueFrom

Retrieves a value from a form element located by CSS or XPath and returns it to test.
Resumes test execution, so **should be used inside async function with `await`** operator.
If more than one element is found - value of first element is returned.

```js
let email = await I.grabValueFrom('input[name=email]');
```

#### Parameters

*   `locator` **([string][5] | [object][11])** field located by label|name|CSS|XPath|strict locator.

Returns **[Promise][6]<[string][5]>** attribute value

### saveScreenshot

Saves a screenshot to ouput folder (set in codecept.conf.ts or codecept.conf.js).
Filename is relative to output folder.

```js
I.saveScreenshot('debug.png');
```

#### Parameters

*   `fileName` **[string][5]** file name to save.

Returns **[Promise][6]\<void>**&#x20;

### scrollIntoView

Scroll element into viewport.

```js
I.scrollIntoView('#submit');
I.scrollIntoView('#submit', true);
I.scrollIntoView('#submit', { behavior: "smooth", block: "center", inline: "center" });
```

#### Parameters

*   `locator` **([string][5] | [object][11])** located by CSS|XPath|strict locator.
*   `scrollIntoViewOptions` **(ScrollIntoViewOptions | [boolean][7])** either alignToTop=true|false or scrollIntoViewOptions. See [https://developer.mozilla.org/en-US/docs/Web/API/Element/scrollIntoView][17].

Returns **void** automatically synchronized promise through #recorderSupported only for web testing

### seeCheckboxIsChecked

Verifies that the specified checkbox is checked.

```js
I.seeCheckboxIsChecked('Agree');
I.seeCheckboxIsChecked('#agree'); // I suppose user agreed to terms
I.seeCheckboxIsChecked({css: '#signup_form input[type=checkbox]'});
```

#### Parameters

*   `field` **([string][5] | [object][11])** located by label|name|CSS|XPath|strict locator.

Returns **void** automatically synchronized promise through #recorder

### seeElement

Checks that a given Element is visible
Element is located by CSS or XPath.

```js
I.seeElement('#modal');
```

#### Parameters

*   `locator` **([string][5] | [object][11])** located by CSS|XPath|strict locator.

Returns **void** automatically synchronized promise through #recorder

### seeInField

Checks that the given input field or textarea equals to given value.
For fuzzy locators, fields are matched by label text, the "name" attribute, CSS, and XPath.

```js
I.seeInField('Username', 'davert');
I.seeInField({css: 'form textarea'},'Type your comment here');
I.seeInField('form input[type=hidden]','hidden_value');
I.seeInField('#searchform input','Search');
```

#### Parameters

*   `field` **([string][5] | [object][11])** located by label|name|CSS|XPath|strict locator.
*   `value` **([string][5] | [object][11])** value to check.

Returns **void** automatically synchronized promise through #recorder

### see

Checks that a page contains a visible text.
Use context parameter to narrow down the search.

```js
I.see('Welcome'); // text welcome on a page
I.see('Welcome', '.content'); // text inside .content div
I.see('Register', {css: 'form.register'}); // use strict locator
```

#### Parameters

*   `text` **[string][5]** expected on page.
*   `context` **([string][5]? | [object][11])** (optional, `null` by default) element located by CSS|Xpath|strict locator in which to search for text. (optional, default `null`)

Returns **void** automatically synchronized promise through #recorder

### selectOption

Selects an option in a drop-down select.
Field is searched by label | name | CSS | XPath.
Option is selected by visible text or by value.

```js
I.selectOption('Choose Plan', 'Monthly'); // select by label
I.selectOption('subscription', 'Monthly'); // match option by text
I.selectOption('subscription', '0'); // or by value
I.selectOption('//form/select[@name=account]','Premium');
I.selectOption('form select[name=account]', 'Premium');
I.selectOption({css: 'form select[name=account]'}, 'Premium');
```

Provide an array for the second argument to select multiple options.

```js
I.selectOption('Which OS do you use?', ['Android', 'iOS']);
```

#### Parameters

*   `select` **([string][5] | [object][11])** field located by label|name|CSS|XPath|strict locator.
*   `option` **([string][5] | [Array][8]\<any>)** visible text or value of option.

Returns **void** automatically synchronized promise through #recorderSupported only for web testing

### waitForElement

Waits for element to be present on page (by default waits for 1sec).
Element can be located by CSS or XPath.

```js
I.waitForElement('.btn.continue');
I.waitForElement('.btn.continue', 5); // wait for 5 secs
```

#### Parameters

*   `locator` **([string][5] | [object][11])** element located by CSS|XPath|strict locator.
*   `sec` **[number][10]?** (optional, `1` by default) time in seconds to wait (optional, default `null`)

Returns **void** automatically synchronized promise through #recorder

### waitForVisible

Waits for an element to become visible on a page (by default waits for 1sec).
Element can be located by CSS or XPath.

```js
I.waitForVisible('#popup');
```

#### Parameters

*   `locator` **([string][5] | [object][11])** element located by CSS|XPath|strict locator.
*   `sec` **[number][10]** (optional, `1` by default) time in seconds to wait (optional, default `1`)

Returns **void** automatically synchronized promise through #recorder

### waitForInvisible

Waits for an element to be removed or become invisible on a page (by default waits for 1sec).
Element can be located by CSS or XPath.

```js
I.waitForInvisible('#popup');
```

#### Parameters

*   `locator` **([string][5] | [object][11])** element located by CSS|XPath|strict locator.
*   `sec` **[number][10]** (optional, `1` by default) time in seconds to wait (optional, default `1`)

Returns **void** automatically synchronized promise through #recorder

### waitForText

Waits for a text to appear (by default waits for 1sec).
Element can be located by CSS or XPath.
Narrow down search results by providing context.

```js
I.waitForText('Thank you, form has been submitted');
I.waitForText('Thank you, form has been submitted', 5, '#modal');
```

#### Parameters

*   `text` **[string][5]** to wait for.
*   `sec` **[number][10]** (optional, `1` by default) time in seconds to wait (optional, default `1`)
*   `context` **([string][5] | [object][11])?** (optional) element located by CSS|XPath|strict locator. (optional, default `null`)

Returns **void** automatically synchronized promise through #recorder

[1]: http://codecept.io/helpers/WebDriver/

[2]: https://appium.io/docs/en/2.1/

[3]: https://codecept.io/mobile/#setting-up

[4]: https://github.com/appium/appium/blob/master/packages/appium/docs/en/guides/caps.md

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise

[7]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[8]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

[9]: https://webdriver.io/docs/api/chromium/#setnetworkconnection

[10]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[11]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[12]: https://developer.android.com/reference/android/view/KeyEvent.html

[13]: http://webdriver.io/api/mobile/touchAction.html

[14]: http://webdriver.io/api/mobile/swipe.html

[15]: http://webdriver.io/api/mobile/rotate.html

[16]: http://webdriver.io/api/mobile/setImmediateValue.html

[17]: https://developer.mozilla.org/en-US/docs/Web/API/Element/scrollIntoView
