---
permalink: /helpers/AI
editLink: false
sidebar: auto
title: AI
---

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## AI

**Extends Helper**

AI Helper for CodeceptJS.

This helper class provides integration with the AI GPT-3.5 or 4 language model for generating responses to questions or prompts within the context of web pages. It allows you to interact with the GPT-3.5 model to obtain intelligent responses based on HTML fragments or general prompts.
This helper should be enabled with any web helpers like Playwright or Puppeteer or WebDriver to ensure the HTML context is available.

Use it only in development mode. It is recommended to run it only inside pause() mode.

## Configuration

This helper should be configured in codecept.conf.{js|ts}

*   `chunkSize`:  - The maximum number of characters to send to the AI API at once. We split HTML fragments by 8000 chars to not exceed token limit. Increase this value if you use GPT-4.

### Parameters

*   `config` &#x20;

### askForPageObject

Generates PageObject for current page using AI.

It saves the PageObject to the output directory. You can review the page object and adjust it as needed and move to pages directory.
Prompt can be customized in a global config file.

```js
// create page object for whole page
I.askForPageObject('home');

// create page object with extra prompt
I.askForPageObject('home', 'implement signIn(username, password) method');

// create page object for a specific element
I.askForPageObject('home', null, '.detail');
```

Asks for a page object based on the provided page name, locator, and extra prompt.

#### Parameters

*   `pageName` **[string][1]** The name of the page to retrieve the object for.
*   `extraPrompt` **([string][1] | null)** An optional extra prompt for additional context or information. 
*   `locator` **([string][1] | null)** An optional locator to find a specific element on the page. 

Returns **[Promise][2]<[Object][3]>** A promise that resolves to the requested page object.

### askGptGeneralPrompt

Send a general request to AI and return response.

#### Parameters

*   `prompt` **[string][1]**&#x20;

Returns **[Promise][2]<[string][1]>** A Promise that resolves to the generated response from the GPT model.

### askGptOnPage

Asks the AI GPT language model a question based on the provided prompt within the context of the current page's HTML.

```js
I.askGptOnPage('what does this page do?');
```

#### Parameters

*   `prompt` **[string][1]** The question or prompt to ask the GPT model.

Returns **[Promise][2]<[string][1]>** A Promise that resolves to the generated responses from the GPT model, joined by newlines.

### askGptOnPageFragment

Asks the AI a question based on the provided prompt within the context of a specific HTML fragment on the current page.

```js
I.askGptOnPageFragment('describe features of this screen', '.screen');
```

#### Parameters

*   `prompt` **[string][1]** The question or prompt to ask the GPT-3.5 model.
*   `locator` **[string][1]** The locator or selector used to identify the HTML fragment on the page.

Returns **[Promise][2]<[string][1]>** A Promise that resolves to the generated response from the GPT model.

[1]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[2]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object
