## Motivation/Description of the PR
- Description of this PR, which problem it solves
- Resolves #issueId (if applicable).

Applicable helpers:

- [ ] Playwright
- [ ] Puppeteer
- [ ] WebDriver
- [ ] REST
- [ ] FileHelper
- [ ] Appium
- [ ] TestCafe

Applicable plugins:

- [ ] allure
- [ ] autoDelay
- [ ] autoLogin
- [ ] customLocator
- [ ] pauseOnFail
- [ ] coverage
- [ ] retryFailedStep
- [ ] screenshotOnFail
- [ ] selenoid
- [ ] stepByStepReport
- [ ] stepTimeout
- [ ] wdio
- [ ] subtitles

## Type of change

- [ ] :fire: Breaking changes
- [ ] :rocket: New functionality
- [ ] :bug: Bug fix
- [ ] 🧹 Chore
- [ ] :clipboard: Documentation changes/updates
- [ ] :hotsprings: Hot fix
- [ ] :hammer: Markdown files fix - not related to source code
- [ ] :nail_care: Polish code

## Checklist:

- [ ] Tests have been added
- [ ] Documentation has been added (Run `npm run docs`)
- [ ] Lint checking (Run `npm run lint`)
- [ ] Local tests are passed (Run `npm test`)
