# `vitest` config

Config for projects using **Vitest** for testing.

## 🏗️ Setup

1. If you haven't already, make sure to [install `@code-pushup/eslint-config` and its required peer dependencies](../README.md#🏗️-setup).
2. Since this plugin requires additional peer dependencies, you have to install them as well:

   ```sh
   npm install -D eslint-plugin-{jest-formatting,vitest}
   ```

3. Add to your `eslint.config.js` file:

   ```js
   import vitest from '@code-pushup/eslint-config/vitest.js';
   import tseslint from 'typescript-eslint';
   
   export default tseslint.config(
     ...vitest,
     {
       // customize rules if needed:
       rules: {
         // e.g. to customize file naming convention (default pattern is '.*\\.spec\\.[tj]sx?$'):
         'vitest/consistent-test-filename': [
           'warn',
           { 'pattern': '.*\\.(unit|integration|e2e)\\.test\\.ts$' }
         ],
         // e.g. to customize `test` or `it` usage (default is `it` in `describe` and `test` at top-level):
         'vitest/consistent-test-it': ['warn', { fn: 'test', withinDescribe: 'test' }]
       }
     }
   );
   ```

## 📏 Rules (41)

> 🔧 Automatically fixable by the [`--fix` CLI option](https://eslint.org/docs/user-guide/command-line-interface#--fix).<br>💡 Manually fixable by [editor suggestions](https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions).

### 🚨 Errors (8)

|                                              Plugin                                              | Rule                                                                                                                                                                                                                                             | Options | Autofix | Overrides |
| :----------------------------------------------------------------------------------------------: | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :------ | :-----: | :-------: |
| [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme) | [expect-expect](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/expect-expect.md)<br />enforce having expectation in test body                                                                                              |         |         |           |
| [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme) | [no-commented-out-tests](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/no-commented-out-tests.md)<br />disallow commented out tests                                                                                       |         |         |           |
| [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme) | [no-identical-title](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/no-identical-title.md)<br />disallow identical titles                                                                                                  |         |   🔧    |           |
| [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme) | [no-import-node-test](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/no-import-node-test.md)<br />disallow importing `node:test`                                                                                           |         |   🔧    |           |
| [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme) | [require-local-test-context-for-concurrent-snapshots](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/require-local-test-context-for-concurrent-snapshots.md)<br />require local Test Context for concurrent snapshot tests |         |         |           |
| [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme) | [valid-describe-callback](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/valid-describe-callback.md)<br />enforce valid describe callback                                                                                  |         |         |           |
| [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme) | [valid-expect](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/valid-expect.md)<br />enforce valid `expect()` usage                                                                                                         |         |         |           |
| [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme) | [valid-title](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/valid-title.md)<br />enforce valid titles                                                                                                                     |         |   🔧    |           |

### ⚠️ Warnings (33)

|                                                        Plugin                                                         | Rule                                                                                                                                                                                               | Options                                                                                                                                                      | Autofix | Overrides |
| :-------------------------------------------------------------------------------------------------------------------: | :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :----------------------------------------------------------------------------------------------------------------------------------------------------------- | :-----: | :-------: |
| [![jest-formatting](./icons/icons8/test.png)](https://github.com/dangreenisrael/eslint-plugin-jest-formatting#readme) | padding-around-after-all-blocks<br />                                                                                                                                                              |                                                                                                                                                              |   🔧    |           |
| [![jest-formatting](./icons/icons8/test.png)](https://github.com/dangreenisrael/eslint-plugin-jest-formatting#readme) | padding-around-after-each-blocks<br />                                                                                                                                                             |                                                                                                                                                              |   🔧    |           |
| [![jest-formatting](./icons/icons8/test.png)](https://github.com/dangreenisrael/eslint-plugin-jest-formatting#readme) | padding-around-before-all-blocks<br />                                                                                                                                                             |                                                                                                                                                              |   🔧    |           |
| [![jest-formatting](./icons/icons8/test.png)](https://github.com/dangreenisrael/eslint-plugin-jest-formatting#readme) | padding-around-before-each-blocks<br />                                                                                                                                                            |                                                                                                                                                              |   🔧    |           |
| [![jest-formatting](./icons/icons8/test.png)](https://github.com/dangreenisrael/eslint-plugin-jest-formatting#readme) | padding-around-describe-blocks<br />                                                                                                                                                               |                                                                                                                                                              |   🔧    |           |
| [![jest-formatting](./icons/icons8/test.png)](https://github.com/dangreenisrael/eslint-plugin-jest-formatting#readme) | padding-around-test-blocks<br />                                                                                                                                                                   |                                                                                                                                                              |   🔧    |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [consistent-test-filename](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/consistent-test-filename.md)<br />require .spec test file pattern                                  | <details><summary>pattern: .\*\\.spec\\.[tj]sx?$</summary><pre lang="json"><code>{&#13;  "pattern": ".\*\\\\.spec\\\\.[tj]sx?$"&#13;}</code></pre></details> |         |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [consistent-test-it](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/consistent-test-it.md)<br />enforce using test or it but not both                                        |                                                                                                                                                              |   🔧    |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [max-nested-describe](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/max-nested-describe.md)<br />require describe block to be less than set max value or default value      | <details><summary>max: 2</summary><pre lang="json"><code>{&#13;  "max": 2&#13;}</code></pre></details>                                                       |         |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [no-alias-methods](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/no-alias-methods.md)<br />disallow alias methods                                                           |                                                                                                                                                              |   🔧    |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [no-conditional-expect](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/no-conditional-expect.md)<br />disallow conditional expects                                           |                                                                                                                                                              |         |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [no-conditional-tests](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/no-conditional-tests.md)<br />disallow conditional tests                                               |                                                                                                                                                              |         |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [no-disabled-tests](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/no-disabled-tests.md)<br />disallow disabled tests                                                        |                                                                                                                                                              |         |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [no-done-callback](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/no-done-callback.md)<br />disallow using a callback in asynchronous tests and hooks                        |                                                                                                                                                              |   💡    |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [no-duplicate-hooks](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/no-duplicate-hooks.md)<br />disallow duplicate hooks and teardown hooks                                  |                                                                                                                                                              |         |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [no-focused-tests](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/no-focused-tests.md)<br />disallow focused tests                                                           |                                                                                                                                                              |   🔧    |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [no-mocks-import](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/no-mocks-import.md)<br />disallow importing from __mocks__ directory                                        |                                                                                                                                                              |         |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [no-standalone-expect](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/no-standalone-expect.md)<br />disallow using `expect` outside of `it` or `test` blocks                 |                                                                                                                                                              |         |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [no-test-return-statement](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/no-test-return-statement.md)<br />disallow return statements in tests                              |                                                                                                                                                              |         |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [prefer-comparison-matcher](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/prefer-comparison-matcher.md)<br />enforce using the built-in comparison matchers                 |                                                                                                                                                              |   🔧    |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [prefer-each](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/prefer-each.md)<br />enforce using `each` rather than manual loops                                              |                                                                                                                                                              |         |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [prefer-equality-matcher](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/prefer-equality-matcher.md)<br />enforce using the built-in quality matchers                        |                                                                                                                                                              |   💡    |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [prefer-expect-resolves](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/prefer-expect-resolves.md)<br />enforce using `expect().resolves` over `expect(await ...)` syntax    |                                                                                                                                                              |   🔧    |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [prefer-hooks-on-top](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/prefer-hooks-on-top.md)<br />enforce having hooks before any test cases                                 |                                                                                                                                                              |         |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [prefer-mock-promise-shorthand](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/prefer-mock-promise-shorthand.md)<br />enforce mock resolved/rejected shorthands for promises |                                                                                                                                                              |   🔧    |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [prefer-spy-on](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/prefer-spy-on.md)<br />enforce using `vi.spyOn`                                                               |                                                                                                                                                              |   🔧    |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [prefer-to-be](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/prefer-to-be.md)<br />enforce using toBe()                                                                     |                                                                                                                                                              |   🔧    |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [prefer-to-contain](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/prefer-to-contain.md)<br />enforce using toContain()                                                      |                                                                                                                                                              |   🔧    |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [prefer-to-have-length](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/prefer-to-have-length.md)<br />enforce using toHaveLength()                                           |                                                                                                                                                              |   🔧    |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [prefer-todo](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/prefer-todo.md)<br />enforce using `test.todo`                                                                  |                                                                                                                                                              |   🔧    |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [require-hook](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/require-hook.md)<br />require setup and teardown to be within a hook                                           |                                                                                                                                                              |         |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [require-to-throw-message](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/require-to-throw-message.md)<br />require toThrow() to be called with an error message             |                                                                                                                                                              |         |           |
|           [![vitest](./icons/material/vitest.png)](https://github.com/veritem/eslint-plugin-vitest#readme)            | [require-top-level-describe](https://github.com/veritem/eslint-plugin-vitest/blob/main/docs/rules/require-top-level-describe.md)<br />enforce that all tests are in a top-level describe           |                                                                                                                                                              |         |           |
