# `typescript` config

Config for strict **TypeScript** projects.

## 🏗️ Setup

1. If you haven't already, make sure to [install `@code-pushup/eslint-config` and its required peer dependencies](../README.md#🏗️-setup).
2. Because this config includes rules which require type information, make sure to configure `parserOptions.project` in your .eslintrc points to your project's tsconfig.
   For more information, refer to [_Linting with Type Information_ (typescript-eslint)](https://typescript-eslint.io/linting/typed-linting).
   
   - Example for library in Nx monorepo:
   
     ```js
     import tseslint from 'typescript-eslint';
     import baseConfig from '../../eslint.config.js';
     
     export default tseslint.config(
       ...baseConfig,
       {
         files: ['**/*.ts'],
         ignores: ['**/code-pushup.config.ts'],
         languageOptions: {
           parserOptions: {
             projectService: true,
             tsconfigRootDir: import.meta.dirname
           }
         }
       }
     );
     ```

   Similarly, you may need to [configure a tsconfig file for `eslint-plugin-import` rules](https://www.npmjs.com/package/eslint-plugin-import#typescript) (e.g. if using path aliases in `.ts` files):
   
   - Install additional import resolver:
   
     ```sh
     npm i -D eslint-import-resolver-typescript
     ```
   
   - Example `eslint.config.js` for Nx monorepo:
   
     ```js
     export default tseslint.config(
       // ...
       {
         settings: {
           'import/resolver': {
             typescript: {
               alwaysTryTypes: true,
               project: 'tsconfig.base.json'
               // or if using RxJS:
               // project: ['tsconfig.base.json', 'node_modules/rxjs/tsconfig.json']
             }
           }
         }
       }
     );
     ```
3. Add to your `eslint.config.js` file:

   ```js
   import typescript from '@code-pushup/eslint-config/typescript.js';
   import tseslint from 'typescript-eslint';
   
   export default tseslint.config(...typescript);
   ```

## 📏 Rules (345)

**290** rules are included from [`javascript` config](./javascript.md#📏-rules-290). For brevity, only the **55** additional rules are listed in this document.

> 🔧 Automatically fixable by the [`--fix` CLI option](https://eslint.org/docs/user-guide/command-line-interface#--fix).<br>💡 Manually fixable by [editor suggestions](https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions).<br>🧪🚫 Disabled for [test files](../README.md#🧪-test-overrides).<br>🧪⚠️ Severity lessened to warning for [test files](../README.md#🧪-test-overrides).

### 🚨 Errors (35)

|                                         Plugin                                          | Rule                                                                                                                                                                                                         | Options                                                                                                                                                               | Autofix | Overrides |
| :-------------------------------------------------------------------------------------: | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :-------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :-----: | :-------: |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [await-thenable](https://typescript-eslint.io/rules/await-thenable)<br />Disallow awaiting a value that is not a Thenable                                                                                    |                                                                                                                                                                       |   💡    |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-array-delete](https://typescript-eslint.io/rules/no-array-delete)<br />Disallow using the `delete` operator on array values                                                                              |                                                                                                                                                                       |   💡    |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-base-to-string](https://typescript-eslint.io/rules/no-base-to-string)<br />Require `.toString()` and `.toLocaleString()` to only be called on objects which provide useful information when stringified  |                                                                                                                                                                       |         |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-deprecated](https://typescript-eslint.io/rules/no-deprecated)<br />Disallow using code marked as `@deprecated`                                                                                           |                                                                                                                                                                       |         |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-duplicate-type-constituents](https://typescript-eslint.io/rules/no-duplicate-type-constituents)<br />Disallow duplicate constituents of union or intersection types                                      |                                                                                                                                                                       |   🔧    |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-dynamic-delete](https://typescript-eslint.io/rules/no-dynamic-delete)<br />Disallow using the `delete` operator on computed key expressions                                                              |                                                                                                                                                                       |   🔧    |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-extraneous-class](https://typescript-eslint.io/rules/no-extraneous-class)<br />Disallow classes used as namespaces                                                                                       |                                                                                                                                                                       |         |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-floating-promises](https://typescript-eslint.io/rules/no-floating-promises)<br />Require Promise-like statements to be handled appropriately                                                             |                                                                                                                                                                       |   💡    |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-for-in-array](https://typescript-eslint.io/rules/no-for-in-array)<br />Disallow iterating over an array with a for-in loop                                                                               |                                                                                                                                                                       |         |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-implied-eval](https://typescript-eslint.io/rules/no-implied-eval)<br />Disallow the use of `eval()`-like methods                                                                                         |                                                                                                                                                                       |         |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-invalid-void-type](https://typescript-eslint.io/rules/no-invalid-void-type)<br />Disallow `void` type outside of generic or return types                                                                 |                                                                                                                                                                       |         |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-misused-promises](https://typescript-eslint.io/rules/no-misused-promises)<br />Disallow Promises in places not designed to handle them                                                                   |                                                                                                                                                                       |         |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-mixed-enums](https://typescript-eslint.io/rules/no-mixed-enums)<br />Disallow enums from having both number and string members                                                                           |                                                                                                                                                                       |         |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-non-null-asserted-nullish-coalescing](https://typescript-eslint.io/rules/no-non-null-asserted-nullish-coalescing)<br />Disallow non-null assertions in the left operand of a nullish coalescing operator |                                                                                                                                                                       |   💡    |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-non-null-assertion](https://typescript-eslint.io/rules/no-non-null-assertion)<br />Disallow non-null assertions using the `!` postfix operator                                                           |                                                                                                                                                                       |   💡    |   🧪🚫    |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-redundant-type-constituents](https://typescript-eslint.io/rules/no-redundant-type-constituents)<br />Disallow members of unions and intersections that do nothing or override type information           |                                                                                                                                                                       |         |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-unnecessary-type-assertion](https://typescript-eslint.io/rules/no-unnecessary-type-assertion)<br />Disallow type assertions that do not change the type of an expression                                 |                                                                                                                                                                       |   🔧    |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-unnecessary-type-parameters](https://typescript-eslint.io/rules/no-unnecessary-type-parameters)<br />Disallow type parameters that aren't used multiple times                                            |                                                                                                                                                                       |   💡    |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-unsafe-argument](https://typescript-eslint.io/rules/no-unsafe-argument)<br />Disallow calling a function with a value with type `any`                                                                    |                                                                                                                                                                       |         |   🧪🚫    |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-unsafe-assignment](https://typescript-eslint.io/rules/no-unsafe-assignment)<br />Disallow assigning a value with type `any` to variables and properties                                                  |                                                                                                                                                                       |         |   🧪🚫    |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-unsafe-call](https://typescript-eslint.io/rules/no-unsafe-call)<br />Disallow calling a value with type `any`                                                                                            |                                                                                                                                                                       |         |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-unsafe-enum-comparison](https://typescript-eslint.io/rules/no-unsafe-enum-comparison)<br />Disallow comparing an enum value with a non-enum value                                                        |                                                                                                                                                                       |   💡    |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-unsafe-member-access](https://typescript-eslint.io/rules/no-unsafe-member-access)<br />Disallow member access on a value with type `any`                                                                 |                                                                                                                                                                       |         |   🧪🚫    |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-unsafe-return](https://typescript-eslint.io/rules/no-unsafe-return)<br />Disallow returning a value with type `any` from a function                                                                      |                                                                                                                                                                       |         |   🧪🚫    |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-unsafe-unary-minus](https://typescript-eslint.io/rules/no-unsafe-unary-minus)<br />Require unary negation to take a number                                                                               |                                                                                                                                                                       |         |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [no-useless-constructor](https://typescript-eslint.io/rules/no-useless-constructor)<br />Disallow unnecessary constructors                                                                                   |                                                                                                                                                                       |   💡    |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [non-nullable-type-assertion-style](https://typescript-eslint.io/rules/non-nullable-type-assertion-style)<br />Enforce non-null assertions over explicit type casts                                          |                                                                                                                                                                       |   🔧    |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [only-throw-error](https://typescript-eslint.io/rules/only-throw-error)<br />Disallow throwing non-`Error` values as exceptions                                                                              |                                                                                                                                                                       |         |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [prefer-literal-enum-member](https://typescript-eslint.io/rules/prefer-literal-enum-member)<br />Require all enum members to be literal values                                                               |                                                                                                                                                                       |         |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [restrict-plus-operands](https://typescript-eslint.io/rules/restrict-plus-operands)<br />Require both operands of addition to be the same type and be `bigint`, `number`, or `string`                        |                                                                                                                                                                       |         |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [restrict-template-expressions](https://typescript-eslint.io/rules/restrict-template-expressions)<br />Enforce template literal expressions to be of `string` type                                           | <details><summary>allowBoolean: true, allowNu...</summary><pre lang="json"><code>{&#13;  "allowBoolean": true,&#13;  "allowNumber": true&#13;}</code></pre></details> |         |   🧪🚫    |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [return-await](https://typescript-eslint.io/rules/return-await)<br />Enforce consistent awaiting of returned promises                                                                                        | <details><summary>error-handling-correctness-...</summary><pre lang="json"><code>"error-handling-correctness-only"</code></pre></details>                             | 🔧, 💡  |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [unbound-method](https://typescript-eslint.io/rules/unbound-method)<br />Enforce unbound methods are called with their expected scope                                                                        |                                                                                                                                                                       |         |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [unified-signatures](https://typescript-eslint.io/rules/unified-signatures)<br />Disallow two overloads that could be unified into one with a union or an optional/rest parameter                            |                                                                                                                                                                       |         |           |
| [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/) | [use-unknown-in-catch-callback-variable](https://typescript-eslint.io/rules/use-unknown-in-catch-callback-variable)<br />Enforce typing arguments in Promise rejection callbacks as `unknown`                |                                                                                                                                                                       | 🔧, 💡  |           |

### ⚠️ Warnings (20)

|                                                      Plugin                                                      | Rule                                                                                                                                                                                                                  | Options                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | Autofix | Overrides |
| :--------------------------------------------------------------------------------------------------------------: | :-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :-----: | :-------: |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [consistent-type-assertions](https://typescript-eslint.io/rules/consistent-type-assertions)<br />Enforce consistent usage of type assertions                                                                          | <details><summary>assertionStyle: as, objectL...</summary><pre lang="json"><code>{&#13;  "assertionStyle": "as",&#13;  "objectLiteralTypeAssertions": "allow"&#13;}</code></pre></details>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 🔧, 💡  |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [dot-notation](https://typescript-eslint.io/rules/dot-notation)<br />Enforce dot notation whenever possible                                                                                                           | <details><summary>allowPrivateClassPropertyAc...</summary><pre lang="json"><code>{&#13;  "allowPrivateClassPropertyAccess": true,&#13;  "allowProtectedClassPropertyAccess": true,&#13;  "allowIndexSignaturePropertyAccess": true&#13;}</code></pre></details>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |   🔧    |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [naming-convention](https://typescript-eslint.io/rules/naming-convention)<br />Enforce naming conventions for everything across a codebase                                                                            | <details><summary>selector: variableLike, met...</summary><pre lang="json"><code>[&#13;  {&#13;    "selector": [&#13;      "variableLike",&#13;      "method",&#13;      "typeProperty",&#13;      "parameterProperty",&#13;      "classProperty"&#13;    ],&#13;    "format": [&#13;      "camelCase"&#13;    ]&#13;  },&#13;  {&#13;    "selector": "variable",&#13;    "format": [&#13;      "camelCase",&#13;      "UPPER_CASE",&#13;      "PascalCase"&#13;    ]&#13;  },&#13;  {&#13;    "selector": "typeLike",&#13;    "format": [&#13;      "PascalCase"&#13;    ]&#13;  },&#13;  {&#13;    "selector": "enumMember",&#13;    "format": [&#13;      "PascalCase"&#13;    ]&#13;  },&#13;  {&#13;    "selector": "parameter",&#13;    "modifiers": [&#13;      "unused"&#13;    ],&#13;    "format": null,&#13;    "custom": {&#13;      "regex": "^(_+\|[a-z][a-zA-Z0-9]\*)$",&#13;      "match": true&#13;    }&#13;  },&#13;  {&#13;    "selector": "objectLiteralProperty",&#13;    "modifiers": [&#13;      "requiresQuotes"&#13;    ],&#13;    "format": null&#13;  },&#13;  {&#13;    "selector": [&#13;      "variable",&#13;      "parameter"&#13;    ],&#13;    "modifiers": [&#13;      "destructured"&#13;    ],&#13;    "format": null&#13;  }&#13;]</code></pre></details> |         |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [no-confusing-void-expression](https://typescript-eslint.io/rules/no-confusing-void-expression)<br />Require expressions of type void to appear in statement position                                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 🔧, 💡  |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [no-meaningless-void-operator](https://typescript-eslint.io/rules/no-meaningless-void-operator)<br />Disallow the `void` operator except when used to discard a value                                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 🔧, 💡  |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [no-unnecessary-boolean-literal-compare](https://typescript-eslint.io/rules/no-unnecessary-boolean-literal-compare)<br />Disallow unnecessary equality comparisons against boolean literals                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |   🔧    |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [no-unnecessary-condition](https://typescript-eslint.io/rules/no-unnecessary-condition)<br />Disallow conditionals where the type is always truthy or always falsy                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |   🔧    |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [no-unnecessary-template-expression](https://typescript-eslint.io/rules/no-unnecessary-template-expression)<br />Disallow unnecessary template expressions                                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |   🔧    |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [no-unnecessary-type-arguments](https://typescript-eslint.io/rules/no-unnecessary-type-arguments)<br />Disallow type arguments that are equal to the default                                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |   🔧    |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [prefer-includes](https://typescript-eslint.io/rules/prefer-includes)<br />Enforce `includes` method over `indexOf` method                                                                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |   🔧    |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [prefer-nullish-coalescing](https://typescript-eslint.io/rules/prefer-nullish-coalescing)<br />Enforce using the nullish coalescing operator instead of logical assignments or chaining                               | <details><summary>ignorePrimitives: {"string"...</summary><pre lang="json"><code>{&#13;  "ignorePrimitives": {&#13;    "string": true&#13;  }&#13;}</code></pre></details>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |   💡    |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [prefer-optional-chain](https://typescript-eslint.io/rules/prefer-optional-chain)<br />Enforce using concise optional chain expressions instead of chained logical ands, negated logical ors, or empty objects        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 🔧, 💡  |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [prefer-promise-reject-errors](https://typescript-eslint.io/rules/prefer-promise-reject-errors)<br />Require using Error objects as Promise rejection reasons                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |         |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [prefer-reduce-type-parameter](https://typescript-eslint.io/rules/prefer-reduce-type-parameter)<br />Enforce using type parameter when calling `Array#reduce` instead of casting                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |   🔧    |   🧪🚫    |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [prefer-return-this-type](https://typescript-eslint.io/rules/prefer-return-this-type)<br />Enforce that `this` is used when only `this` type is returned                                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |   🔧    |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [prefer-string-starts-ends-with](https://typescript-eslint.io/rules/prefer-string-starts-ends-with)<br />Enforce using `String#startsWith` and `String#endsWith` over other equivalent methods of checking substrings |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |   🔧    |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [require-await](https://typescript-eslint.io/rules/require-await)<br />Disallow async functions which do not return promises and have no `await` expression                                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |   💡    |           |
| [![functional](./icons/icons8/lambda.png)](https://github.com/eslint-functional/eslint-plugin-functional#readme) | [immutable-data](https://github.com/eslint-functional/eslint-plugin-functional/blob/v7.0.0/docs/rules/immutable-data.md)<br />Enforce treating data as immutable.                                                     | <details><summary>ignoreImmediateMutation: tr...</summary><pre lang="json"><code>{&#13;  "ignoreImmediateMutation": true,&#13;  "ignoreClasses": true,&#13;  "ignoreAccessorPattern": "module.exports"&#13;}</code></pre></details>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |         |           |
| [![functional](./icons/icons8/lambda.png)](https://github.com/eslint-functional/eslint-plugin-functional#readme) | [prefer-property-signatures](https://github.com/eslint-functional/eslint-plugin-functional/blob/v7.0.0/docs/rules/prefer-property-signatures.md)<br />Prefer property signatures over method signatures.              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |         |           |
| [![functional](./icons/icons8/lambda.png)](https://github.com/eslint-functional/eslint-plugin-functional#readme) | [prefer-tacit](https://github.com/eslint-functional/eslint-plugin-functional/blob/v7.0.0/docs/rules/prefer-tacit.md)<br />Replaces `x => f(x)` with just `f`.                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |   💡    |           |
