# `javascript` config

Default config, suitable for any **JavaScript/TypeScript** project.

## 🏗️ Setup

Refer to [setup instructions in README](../README.md#🏗️-setup).

## 📏 Rules (290)

> 🔧 Automatically fixable by the [`--fix` CLI option](https://eslint.org/docs/user-guide/command-line-interface#--fix).<br>💡 Manually fixable by [editor suggestions](https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions).<br>🧪🚫 Disabled for [test files](../README.md#🧪-test-overrides).<br>🧪⚠️ Severity lessened to warning for [test files](../README.md#🧪-test-overrides).

### 🚨 Errors (120)

|                                                   Plugin                                                   | Rule                                                                                                                                                                                                                                 | Options                                                                                                                                                                                                                         | Autofix | Overrides |
| :--------------------------------------------------------------------------------------------------------: | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | :-----: | :-------: |
|                                                                                                            | [constructor-super](https://eslint.org/docs/latest/rules/constructor-super)<br />Require `super()` calls in constructors                                                                                                             |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [eqeqeq](https://eslint.org/docs/latest/rules/eqeqeq)<br />Require the use of `===` and `!==`                                                                                                                                        | <details><summary>always, null: never</summary><pre lang="json"><code>[&#13;  "always",&#13;  {&#13;    "null": "never"&#13;  }&#13;]</code></pre></details>                                                                    |   🔧    |           |
|                                                                                                            | [for-direction](https://eslint.org/docs/latest/rules/for-direction)<br />Enforce "for" loop update clause moving the counter in the right direction                                                                                  |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [getter-return](https://eslint.org/docs/latest/rules/getter-return)<br />Enforce `return` statements in getters                                                                                                                      |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [guard-for-in](https://eslint.org/docs/latest/rules/guard-for-in)<br />Require `for-in` loops to include an `if` statement                                                                                                           |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-async-promise-executor](https://eslint.org/docs/latest/rules/no-async-promise-executor)<br />Disallow using an async function as a Promise executor                                                                              |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-case-declarations](https://eslint.org/docs/latest/rules/no-case-declarations)<br />Disallow lexical declarations in case clauses                                                                                                 |                                                                                                                                                                                                                                 |   💡    |           |
|                                                                                                            | [no-class-assign](https://eslint.org/docs/latest/rules/no-class-assign)<br />Disallow reassigning class members                                                                                                                      |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-compare-neg-zero](https://eslint.org/docs/latest/rules/no-compare-neg-zero)<br />Disallow comparing against -0                                                                                                                   |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-cond-assign](https://eslint.org/docs/latest/rules/no-cond-assign)<br />Disallow assignment operators in conditional expressions                                                                                                  |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-const-assign](https://eslint.org/docs/latest/rules/no-const-assign)<br />Disallow reassigning `const` variables                                                                                                                  |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-constant-binary-expression](https://eslint.org/docs/latest/rules/no-constant-binary-expression)<br />Disallow expressions where the operation doesn't affect the value                                                           |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-constant-condition](https://eslint.org/docs/latest/rules/no-constant-condition)<br />Disallow constant expressions in conditions                                                                                                 |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-control-regex](https://eslint.org/docs/latest/rules/no-control-regex)<br />Disallow control characters in regular expressions                                                                                                    |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-debugger](https://eslint.org/docs/latest/rules/no-debugger)<br />Disallow the use of `debugger`                                                                                                                                  |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-delete-var](https://eslint.org/docs/latest/rules/no-delete-var)<br />Disallow deleting variables                                                                                                                                 |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-dupe-args](https://eslint.org/docs/latest/rules/no-dupe-args)<br />Disallow duplicate arguments in `function` definitions                                                                                                        |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-dupe-class-members](https://eslint.org/docs/latest/rules/no-dupe-class-members)<br />Disallow duplicate class members                                                                                                            |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-dupe-else-if](https://eslint.org/docs/latest/rules/no-dupe-else-if)<br />Disallow duplicate conditions in if-else-if chains                                                                                                      |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-dupe-keys](https://eslint.org/docs/latest/rules/no-dupe-keys)<br />Disallow duplicate keys in object literals                                                                                                                    |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-duplicate-case](https://eslint.org/docs/latest/rules/no-duplicate-case)<br />Disallow duplicate case labels                                                                                                                      |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-empty](https://eslint.org/docs/latest/rules/no-empty)<br />Disallow empty block statements                                                                                                                                       |                                                                                                                                                                                                                                 |   💡    |           |
|                                                                                                            | [no-empty-character-class](https://eslint.org/docs/latest/rules/no-empty-character-class)<br />Disallow empty character classes in regular expressions                                                                               |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-empty-pattern](https://eslint.org/docs/latest/rules/no-empty-pattern)<br />Disallow empty destructuring patterns                                                                                                                 |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-eval](https://eslint.org/docs/latest/rules/no-eval)<br />Disallow the use of `eval()`                                                                                                                                            |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-ex-assign](https://eslint.org/docs/latest/rules/no-ex-assign)<br />Disallow reassigning exceptions in `catch` clauses                                                                                                            |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-extra-boolean-cast](https://eslint.org/docs/latest/rules/no-extra-boolean-cast)<br />Disallow unnecessary boolean casts                                                                                                          |                                                                                                                                                                                                                                 |   🔧    |           |
|                                                                                                            | [no-fallthrough](https://eslint.org/docs/latest/rules/no-fallthrough)<br />Disallow fallthrough of `case` statements                                                                                                                 |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-func-assign](https://eslint.org/docs/latest/rules/no-func-assign)<br />Disallow reassigning `function` declarations                                                                                                              |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-global-assign](https://eslint.org/docs/latest/rules/no-global-assign)<br />Disallow assignments to native objects or read-only global variables                                                                                  |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-import-assign](https://eslint.org/docs/latest/rules/no-import-assign)<br />Disallow assigning to imported bindings                                                                                                               |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-inner-declarations](https://eslint.org/docs/latest/rules/no-inner-declarations)<br />Disallow variable or `function` declarations in nested blocks                                                                               |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-invalid-regexp](https://eslint.org/docs/latest/rules/no-invalid-regexp)<br />Disallow invalid regular expression strings in `RegExp` constructors                                                                                |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-irregular-whitespace](https://eslint.org/docs/latest/rules/no-irregular-whitespace)<br />Disallow irregular whitespace                                                                                                           |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-loss-of-precision](https://eslint.org/docs/latest/rules/no-loss-of-precision)<br />Disallow literal numbers that lose precision                                                                                                  |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-misleading-character-class](https://eslint.org/docs/latest/rules/no-misleading-character-class)<br />Disallow characters which are made with multiple code points in character class syntax                                      |                                                                                                                                                                                                                                 |   💡    |           |
|                                                                                                            | [no-new-native-nonconstructor](https://eslint.org/docs/latest/rules/no-new-native-nonconstructor)<br />Disallow `new` operators with global non-constructor functions                                                                |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-nonoctal-decimal-escape](https://eslint.org/docs/latest/rules/no-nonoctal-decimal-escape)<br />Disallow `\8` and `\9` escape sequences in string literals                                                                        |                                                                                                                                                                                                                                 |   💡    |           |
|                                                                                                            | [no-obj-calls](https://eslint.org/docs/latest/rules/no-obj-calls)<br />Disallow calling global object properties as functions                                                                                                        |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-octal](https://eslint.org/docs/latest/rules/no-octal)<br />Disallow octal literals                                                                                                                                               |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-param-reassign](https://eslint.org/docs/latest/rules/no-param-reassign)<br />Disallow reassigning `function` parameters                                                                                                          | <details><summary>props: true</summary><pre lang="json"><code>{&#13;  "props": true&#13;}</code></pre></details>                                                                                                                |         |           |
|                                                                                                            | [no-prototype-builtins](https://eslint.org/docs/latest/rules/no-prototype-builtins)<br />Disallow calling some `Object.prototype` methods directly on objects                                                                        |                                                                                                                                                                                                                                 |   💡    |           |
|                                                                                                            | [no-redeclare](https://eslint.org/docs/latest/rules/no-redeclare)<br />Disallow variable redeclaration                                                                                                                               |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-regex-spaces](https://eslint.org/docs/latest/rules/no-regex-spaces)<br />Disallow multiple spaces in regular expressions                                                                                                         |                                                                                                                                                                                                                                 |   🔧    |           |
|                                                                                                            | [no-self-assign](https://eslint.org/docs/latest/rules/no-self-assign)<br />Disallow assignments where both sides are exactly the same                                                                                                |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-sequences](https://eslint.org/docs/latest/rules/no-sequences)<br />Disallow comma operators                                                                                                                                      |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-setter-return](https://eslint.org/docs/latest/rules/no-setter-return)<br />Disallow returning values from setters                                                                                                                |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-shadow-restricted-names](https://eslint.org/docs/latest/rules/no-shadow-restricted-names)<br />Disallow identifiers from shadowing restricted names                                                                              |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-sparse-arrays](https://eslint.org/docs/latest/rules/no-sparse-arrays)<br />Disallow sparse arrays                                                                                                                                |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-template-curly-in-string](https://eslint.org/docs/latest/rules/no-template-curly-in-string)<br />Disallow template literal placeholder syntax in regular strings                                                                 |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-this-before-super](https://eslint.org/docs/latest/rules/no-this-before-super)<br />Disallow `this`/`super` before calling `super()` in constructors                                                                              |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-undef](https://eslint.org/docs/latest/rules/no-undef)<br />Disallow the use of undeclared variables unless mentioned in `/*global */` comments                                                                                   |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-unexpected-multiline](https://eslint.org/docs/latest/rules/no-unexpected-multiline)<br />Disallow confusing multiline expressions                                                                                                |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-unreachable](https://eslint.org/docs/latest/rules/no-unreachable)<br />Disallow unreachable code after `return`, `throw`, `continue`, and `break` statements                                                                     |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-unreachable-loop](https://eslint.org/docs/latest/rules/no-unreachable-loop)<br />Disallow loops with a body that allows only one iteration                                                                                       |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-unsafe-finally](https://eslint.org/docs/latest/rules/no-unsafe-finally)<br />Disallow control flow statements in `finally` blocks                                                                                                |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-unsafe-negation](https://eslint.org/docs/latest/rules/no-unsafe-negation)<br />Disallow negating the left operand of relational operators                                                                                        |                                                                                                                                                                                                                                 |   💡    |           |
|                                                                                                            | [no-unsafe-optional-chaining](https://eslint.org/docs/latest/rules/no-unsafe-optional-chaining)<br />Disallow use of optional chaining in contexts where the `undefined` value is not allowed                                        |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-unused-labels](https://eslint.org/docs/latest/rules/no-unused-labels)<br />Disallow unused labels                                                                                                                                |                                                                                                                                                                                                                                 |   🔧    |           |
|                                                                                                            | [no-unused-vars](https://eslint.org/docs/latest/rules/no-unused-vars)<br />Disallow unused variables                                                                                                                                 |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-useless-backreference](https://eslint.org/docs/latest/rules/no-useless-backreference)<br />Disallow useless backreferences in regular expressions                                                                                |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-useless-catch](https://eslint.org/docs/latest/rules/no-useless-catch)<br />Disallow unnecessary `catch` clauses                                                                                                                  |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [no-useless-escape](https://eslint.org/docs/latest/rules/no-useless-escape)<br />Disallow unnecessary escape characters                                                                                                              |                                                                                                                                                                                                                                 |   💡    |           |
|                                                                                                            | [no-var](https://eslint.org/docs/latest/rules/no-var)<br />Require `let` or `const` instead of `var`                                                                                                                                 |                                                                                                                                                                                                                                 |   🔧    |           |
|                                                                                                            | [no-with](https://eslint.org/docs/latest/rules/no-with)<br />Disallow `with` statements                                                                                                                                              |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [prefer-const](https://eslint.org/docs/latest/rules/prefer-const)<br />Require `const` declarations for variables that are never reassigned after declared                                                                           |                                                                                                                                                                                                                                 |   🔧    |           |
|                                                                                                            | [prefer-rest-params](https://eslint.org/docs/latest/rules/prefer-rest-params)<br />Require rest parameters instead of `arguments`                                                                                                    |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [prefer-spread](https://eslint.org/docs/latest/rules/prefer-spread)<br />Require spread operators instead of `.apply()`                                                                                                              |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [require-yield](https://eslint.org/docs/latest/rules/require-yield)<br />Require generator functions to contain `yield`                                                                                                              |                                                                                                                                                                                                                                 |         |           |
|                                                                                                            | [use-isnan](https://eslint.org/docs/latest/rules/use-isnan)<br />Require calls to `isNaN()` when checking for `NaN`                                                                                                                  |                                                                                                                                                                                                                                 |   💡    |           |
|                                                                                                            | [valid-typeof](https://eslint.org/docs/latest/rules/valid-typeof)<br />Enforce comparing `typeof` expressions against valid strings                                                                                                  |                                                                                                                                                                                                                                 |   💡    |           |
|          [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)           | [ban-ts-comment](https://typescript-eslint.io/rules/ban-ts-comment)<br />Disallow `@ts-<directive>` comments or require descriptions after directives                                                                                |                                                                                                                                                                                                                                 |   💡    |           |
|          [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)           | [no-array-constructor](https://typescript-eslint.io/rules/no-array-constructor)<br />Disallow generic `Array` constructors                                                                                                           |                                                                                                                                                                                                                                 |   🔧    |           |
|          [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)           | [no-duplicate-enum-values](https://typescript-eslint.io/rules/no-duplicate-enum-values)<br />Disallow duplicate enum member values                                                                                                   |                                                                                                                                                                                                                                 |         |           |
|          [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)           | [no-empty-object-type](https://typescript-eslint.io/rules/no-empty-object-type)<br />Disallow accidentally using the "empty object" type                                                                                             |                                                                                                                                                                                                                                 |   💡    |           |
|          [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)           | [no-explicit-any](https://typescript-eslint.io/rules/no-explicit-any)<br />Disallow the `any` type                                                                                                                                   |                                                                                                                                                                                                                                 | 🔧, 💡  |   🧪🚫    |
|          [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)           | [no-extra-non-null-assertion](https://typescript-eslint.io/rules/no-extra-non-null-assertion)<br />Disallow extra non-null assertions                                                                                                |                                                                                                                                                                                                                                 |   🔧    |           |
|          [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)           | [no-misused-new](https://typescript-eslint.io/rules/no-misused-new)<br />Enforce valid definition of `new` and `constructor`                                                                                                         |                                                                                                                                                                                                                                 |         |           |
|          [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)           | [no-namespace](https://typescript-eslint.io/rules/no-namespace)<br />Disallow TypeScript namespaces                                                                                                                                  |                                                                                                                                                                                                                                 |         |           |
|          [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)           | [no-non-null-asserted-optional-chain](https://typescript-eslint.io/rules/no-non-null-asserted-optional-chain)<br />Disallow non-null assertions after an optional chain expression                                                   |                                                                                                                                                                                                                                 |   💡    |           |
|          [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)           | [no-require-imports](https://typescript-eslint.io/rules/no-require-imports)<br />Disallow invocation of `require()`                                                                                                                  |                                                                                                                                                                                                                                 |         |           |
|          [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)           | [no-this-alias](https://typescript-eslint.io/rules/no-this-alias)<br />Disallow aliasing `this`                                                                                                                                      |                                                                                                                                                                                                                                 |         |           |
|          [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)           | [no-unnecessary-type-constraint](https://typescript-eslint.io/rules/no-unnecessary-type-constraint)<br />Disallow unnecessary constraints on generic types                                                                           |                                                                                                                                                                                                                                 |   💡    |           |
|          [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)           | [no-unsafe-declaration-merging](https://typescript-eslint.io/rules/no-unsafe-declaration-merging)<br />Disallow unsafe declaration merging                                                                                           |                                                                                                                                                                                                                                 |         |           |
|          [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)           | [no-unsafe-function-type](https://typescript-eslint.io/rules/no-unsafe-function-type)<br />Disallow using the unsafe built-in Function type                                                                                          |                                                                                                                                                                                                                                 |   🔧    |           |
|          [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)           | [no-unused-vars](https://typescript-eslint.io/rules/no-unused-vars)<br />Disallow unused variables                                                                                                                                   | <details><summary>argsIgnorePattern: ^_, dest...</summary><pre lang="json"><code>{&#13;  "argsIgnorePattern": "^_",&#13;  "destructuredArrayIgnorePattern": "^_",&#13;  "ignoreRestSiblings": true&#13;}</code></pre></details> |         |           |
|          [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)           | [no-wrapper-object-types](https://typescript-eslint.io/rules/no-wrapper-object-types)<br />Disallow using confusing built-in primitive class wrappers                                                                                |                                                                                                                                                                                                                                 |   🔧    |           |
|          [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)           | [prefer-as-const](https://typescript-eslint.io/rules/prefer-as-const)<br />Enforce the use of `as const` over literal type                                                                                                           |                                                                                                                                                                                                                                 | 🔧, 💡  |           |
|          [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)           | [triple-slash-reference](https://typescript-eslint.io/rules/triple-slash-reference)<br />Disallow certain triple slash directives in favor of ES6-style import declarations                                                          |                                                                                                                                                                                                                                 |         |           |
|      [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)      | [default](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/default.md)<br />Ensure a default export is present, given a default import.                                                                     |                                                                                                                                                                                                                                 |         |           |
|      [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)      | [export](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/export.md)<br />Forbid any invalid exports, i.e. re-export of the same name.                                                                      |                                                                                                                                                                                                                                 |         |           |
|      [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)      | [named](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/named.md)<br />Ensure named imports correspond to a named export in the remote file.                                                               |                                                                                                                                                                                                                                 |         |           |
|      [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)      | [namespace](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/namespace.md)<br />Ensure imported namespaces contain dereferenced properties as they are dereferenced.                                        |                                                                                                                                                                                                                                 |         |           |
|      [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)      | [no-absolute-path](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/no-absolute-path.md)<br />Forbid import of modules using absolute paths.                                                                |                                                                                                                                                                                                                                 |   🔧    |           |
|      [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)      | [no-amd](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/no-amd.md)<br />Forbid AMD `require` and `define` calls.                                                                                          |                                                                                                                                                                                                                                 |         |           |
|      [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)      | [no-commonjs](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/no-commonjs.md)<br />Forbid CommonJS `require` calls and `module.exports` or `exports.*`.                                                    |                                                                                                                                                                                                                                 |         |           |
|      [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)      | [no-cycle](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/no-cycle.md)<br />Forbid a module from importing a module with a dependency path back to itself.                                                |                                                                                                                                                                                                                                 |         |           |
|      [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)      | [no-mutable-exports](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/no-mutable-exports.md)<br />Forbid the use of mutable exports with `var` or `let`.                                                    |                                                                                                                                                                                                                                 |         |           |
|      [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)      | [no-self-import](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/no-self-import.md)<br />Forbid a module from importing itself.                                                                            |                                                                                                                                                                                                                                 |         |           |
|      [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)      | [no-unresolved](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/no-unresolved.md)<br />Ensure imports point to a file/module that can be resolved.                                                         |                                                                                                                                                                                                                                 |         |           |
| [![promise](./icons/icons8/promise.png)](https://github.com/eslint-community/eslint-plugin-promise#readme) | [always-return](https://github.com/eslint-community/eslint-plugin-promise/blob/main/docs/rules/always-return.md)<br />Require returning inside each `then()` to create readable and reusable Promise chains.                         | <details><summary>ignoreLastCallback: true</summary><pre lang="json"><code>{&#13;  "ignoreLastCallback": true&#13;}</code></pre></details>                                                                                      |         |           |
| [![promise](./icons/icons8/promise.png)](https://github.com/eslint-community/eslint-plugin-promise#readme) | [catch-or-return](https://github.com/eslint-community/eslint-plugin-promise/blob/main/docs/rules/catch-or-return.md)<br />Enforce the use of `catch()` on un-returned promises.                                                      |                                                                                                                                                                                                                                 |         |   🧪🚫    |
| [![promise](./icons/icons8/promise.png)](https://github.com/eslint-community/eslint-plugin-promise#readme) | [no-new-statics](https://github.com/eslint-community/eslint-plugin-promise/blob/main/docs/rules/no-new-statics.md)<br />Disallow calling `new` on a Promise static method.                                                           |                                                                                                                                                                                                                                 |   🔧    |           |
| [![promise](./icons/icons8/promise.png)](https://github.com/eslint-community/eslint-plugin-promise#readme) | [no-return-wrap](https://github.com/eslint-community/eslint-plugin-promise/blob/main/docs/rules/no-return-wrap.md)<br />Disallow wrapping values in `Promise.resolve` or `Promise.reject` when not needed.                           |                                                                                                                                                                                                                                 |         |           |
| [![promise](./icons/icons8/promise.png)](https://github.com/eslint-community/eslint-plugin-promise#readme) | [param-names](https://github.com/eslint-community/eslint-plugin-promise/blob/main/docs/rules/param-names.md)<br />Enforce consistent param names and ordering when creating new promises.                                            |                                                                                                                                                                                                                                 |         |           |
|     [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)     | [no-all-duplicated-branches](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-all-duplicated-branches.md)<br />All branches in a conditional structure should not have exactly the same implementation |                                                                                                                                                                                                                                 |         |           |
|     [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)     | [no-collection-size-mischeck](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-collection-size-mischeck.md)<br />Collection sizes and array length comparisons should make sense                       |                                                                                                                                                                                                                                 |   💡    |           |
|     [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)     | [no-duplicated-branches](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-duplicated-branches.md)<br />Two branches in a conditional structure should not have exactly the same implementation         |                                                                                                                                                                                                                                 |         |           |
|     [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)     | [no-element-overwrite](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-element-overwrite.md)<br />Collection elements should not be replaced unconditionally                                          |                                                                                                                                                                                                                                 |         |           |
|     [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)     | [no-empty-collection](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-empty-collection.md)<br />Empty collections should not be accessed or iterated                                                  |                                                                                                                                                                                                                                 |         |           |
|     [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)     | [no-extra-arguments](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-extra-arguments.md)<br />Function calls should not pass extra arguments                                                          |                                                                                                                                                                                                                                 |         |           |
|     [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)     | [no-gratuitous-expressions](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-gratuitous-expressions.md)<br />Boolean expressions should not be gratuitous                                              |                                                                                                                                                                                                                                 |         |           |
|     [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)     | [no-identical-conditions](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-identical-conditions.md)<br />Related "if-else-if" and "switch-case" statements should not have the same condition          |                                                                                                                                                                                                                                 |         |           |
|     [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)     | [no-identical-expressions](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-identical-expressions.md)<br />Identical expressions should not be used on both sides of a binary operator                 |                                                                                                                                                                                                                                 |         |           |
|     [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)     | [no-identical-functions](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-identical-functions.md)<br />Functions should not have identical implementations                                             |                                                                                                                                                                                                                                 |         |           |
|     [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)     | [no-ignored-return](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-ignored-return.md)<br />Return values from functions without side effects should not be ignored                                   |                                                                                                                                                                                                                                 |         |           |
|     [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)     | [no-one-iteration-loop](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-one-iteration-loop.md)<br />Loops with at most one iteration should be refactored                                             |                                                                                                                                                                                                                                 |         |           |
|     [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)     | [no-unused-collection](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-unused-collection.md)<br />Collection and array contents should be used                                                        |                                                                                                                                                                                                                                 |         |           |
|     [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)     | [no-use-of-empty-return-value](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-use-of-empty-return-value.md)<br />The output of functions that don't return anything should not be used               |                                                                                                                                                                                                                                 |         |           |
|     [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)     | [non-existent-operator](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/non-existent-operator.md)<br />Non-existent operators "=+", "=-" and "=!" should not be used                                     |                                                                                                                                                                                                                                 |   💡    |           |

### ⚠️ Warnings (170)

|                                                      Plugin                                                      | Rule                                                                                                                                                                                                                                                                                                                                                     | Options                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Autofix | Overrides |
| :--------------------------------------------------------------------------------------------------------------: | :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :-----: | :-------: |
|                                                                                                                  | [arrow-body-style](https://eslint.org/docs/latest/rules/arrow-body-style)<br />Require braces around arrow function bodies                                                                                                                                                                                                                               | <details><summary>as-needed</summary><pre lang="json"><code>"as-needed"</code></pre></details>                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |   🔧    |           |
|                                                                                                                  | [complexity](https://eslint.org/docs/latest/rules/complexity)<br />Enforce a maximum cyclomatic complexity allowed in a program                                                                                                                                                                                                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|                                                                                                                  | [curly](https://eslint.org/docs/latest/rules/curly)<br />Enforce consistent brace style for all control statements                                                                                                                                                                                                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |   🧪🚫    |
|                                                                                                                  | [max-depth](https://eslint.org/docs/latest/rules/max-depth)<br />Enforce a maximum depth that blocks can be nested                                                                                                                                                                                                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|                                                                                                                  | [max-lines](https://eslint.org/docs/latest/rules/max-lines)<br />Enforce a maximum number of lines per file                                                                                                                                                                                                                                              | <details><summary>skipBlankLines: true, skipC...</summary><pre lang="json"><code>{&#13;  "skipBlankLines": true,&#13;  "skipComments": true&#13;}</code></pre></details>                                                                                                                                                                                                                                                                                                                                                                                                 |         |   🧪🚫    |
|                                                                                                                  | [max-lines-per-function](https://eslint.org/docs/latest/rules/max-lines-per-function)<br />Enforce a maximum number of lines of code in a function                                                                                                                                                                                                       | <details><summary>skipBlankLines: true, skipC...</summary><pre lang="json"><code>{&#13;  "skipBlankLines": true,&#13;  "skipComments": true&#13;}</code></pre></details>                                                                                                                                                                                                                                                                                                                                                                                                 |         |   🧪🚫    |
|                                                                                                                  | [max-nested-callbacks](https://eslint.org/docs/latest/rules/max-nested-callbacks)<br />Enforce a maximum depth that callbacks can be nested                                                                                                                                                                                                              | <details><summary>max: 10</summary><pre lang="json"><code>{&#13;  "max": 10&#13;}</code></pre></details>                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |         |           |
|                                                                                                                  | [no-bitwise](https://eslint.org/docs/latest/rules/no-bitwise)<br />Disallow bitwise operators                                                                                                                                                                                                                                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|                                                                                                                  | [no-console](https://eslint.org/docs/latest/rules/no-console)<br />Disallow the use of `console`                                                                                                                                                                                                                                                         | <details><summary>allow: error, warn, info</summary><pre lang="json"><code>{&#13;  "allow": [&#13;    "error",&#13;    "warn",&#13;    "info"&#13;  ]&#13;}</code></pre></details>                                                                                                                                                                                                                                                                                                                                                                                       |   💡    |           |
|                                                                                                                  | [no-duplicate-imports](https://eslint.org/docs/latest/rules/no-duplicate-imports)<br />Disallow duplicate module imports                                                                                                                                                                                                                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|                                                                                                                  | [no-empty-static-block](https://eslint.org/docs/latest/rules/no-empty-static-block)<br />Disallow empty static blocks                                                                                                                                                                                                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|                                                                                                                  | [no-undef-init](https://eslint.org/docs/latest/rules/no-undef-init)<br />Disallow initializing variables to `undefined`                                                                                                                                                                                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|                                                                                                                  | [no-unused-private-class-members](https://eslint.org/docs/latest/rules/no-unused-private-class-members)<br />Disallow unused private class members                                                                                                                                                                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|                                                                                                                  | [no-useless-computed-key](https://eslint.org/docs/latest/rules/no-useless-computed-key)<br />Disallow unnecessary computed property keys in objects and classes                                                                                                                                                                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|                                                                                                                  | [no-useless-rename](https://eslint.org/docs/latest/rules/no-useless-rename)<br />Disallow renaming import, export, and destructured assignments to the same name                                                                                                                                                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|                                                                                                                  | [object-shorthand](https://eslint.org/docs/latest/rules/object-shorthand)<br />Require or disallow method and property shorthand syntax for object literals                                                                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|                                                                                                                  | [prefer-template](https://eslint.org/docs/latest/rules/prefer-template)<br />Require template literals instead of string concatenation                                                                                                                                                                                                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|                                                                                                                  | [radix](https://eslint.org/docs/latest/rules/radix)<br />Enforce the consistent use of the radix argument when using `parseInt()`                                                                                                                                                                                                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   💡    |           |
|                                                                                                                  | [yoda](https://eslint.org/docs/latest/rules/yoda)<br />Require or disallow "Yoda" conditions                                                                                                                                                                                                                                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [adjacent-overload-signatures](https://typescript-eslint.io/rules/adjacent-overload-signatures)<br />Require that function overload signatures be consecutive                                                                                                                                                                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [array-type](https://typescript-eslint.io/rules/array-type)<br />Require consistently using either `T[]` or `Array<T>` for arrays                                                                                                                                                                                                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [ban-tslint-comment](https://typescript-eslint.io/rules/ban-tslint-comment)<br />Disallow `// tslint:<rule-flag>` comments                                                                                                                                                                                                                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [class-methods-use-this](https://typescript-eslint.io/rules/class-methods-use-this)<br />Enforce that class methods utilize `this`                                                                                                                                                                                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [consistent-generic-constructors](https://typescript-eslint.io/rules/consistent-generic-constructors)<br />Enforce specifying generic type arguments on type annotation or constructor name of a constructor call                                                                                                                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [consistent-type-definitions](https://typescript-eslint.io/rules/consistent-type-definitions)<br />Enforce type definitions to consistently use either `interface` or `type`                                                                                                                                                                             | <details><summary>type</summary><pre lang="json"><code>"type"</code></pre></details>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |   🔧    |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [default-param-last](https://typescript-eslint.io/rules/default-param-last)<br />Enforce default parameters to be last                                                                                                                                                                                                                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [max-params](https://typescript-eslint.io/rules/max-params)<br />Enforce a maximum number of parameters in function definitions                                                                                                                                                                                                                          | <details><summary>max: 4</summary><pre lang="json"><code>{&#13;  "max": 4&#13;}</code></pre></details>                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |         |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [method-signature-style](https://typescript-eslint.io/rules/method-signature-style)<br />Enforce using a particular method signature syntax                                                                                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [no-confusing-non-null-assertion](https://typescript-eslint.io/rules/no-confusing-non-null-assertion)<br />Disallow non-null assertion in locations that may be confusing                                                                                                                                                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   💡    |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [no-empty-function](https://typescript-eslint.io/rules/no-empty-function)<br />Disallow empty functions                                                                                                                                                                                                                                                  | <details><summary>allow: private-constructors...</summary><pre lang="json"><code>{&#13;  "allow": [&#13;    "private-constructors",&#13;    "protected-constructors",&#13;    "decoratedFunctions",&#13;    "overrideMethods"&#13;  ]&#13;}</code></pre></details>                                                                                                                                                                                                                                                                                                       |         |   🧪🚫    |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [no-import-type-side-effects](https://typescript-eslint.io/rules/no-import-type-side-effects)<br />Enforce the use of top-level import type qualifier when an import only has specifiers with inline type qualifiers                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [no-magic-numbers](https://typescript-eslint.io/rules/no-magic-numbers)<br />Disallow magic numbers                                                                                                                                                                                                                                                      | <details><summary>ignore: -1, 0, 1, 2, 7, 10,...</summary><pre lang="json"><code>{&#13;  "ignore": [&#13;    -1,&#13;    0,&#13;    1,&#13;    2,&#13;    7,&#13;    10,&#13;    24,&#13;    60,&#13;    100,&#13;    1000,&#13;    3600&#13;  ],&#13;  "ignoreClassFieldInitialValues": true,&#13;  "ignoreDefaultValues": true,&#13;  "ignoreEnums": true,&#13;  "ignoreNumericLiteralTypes": true,&#13;  "ignoreReadonlyClassProperties": true,&#13;  "ignoreTypeIndexes": true,&#13;  "enforceConst": true,&#13;  "detectObjects": true&#13;}</code></pre></details> |         |   🧪🚫    |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [no-shadow](https://typescript-eslint.io/rules/no-shadow)<br />Disallow variable declarations from shadowing variables declared in the outer scope                                                                                                                                                                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [no-unused-expressions](https://typescript-eslint.io/rules/no-unused-expressions)<br />Disallow unused expressions                                                                                                                                                                                                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [prefer-function-type](https://typescript-eslint.io/rules/prefer-function-type)<br />Enforce using function types instead of interfaces with call signatures                                                                                                                                                                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|             [![@typescript-eslint](./icons/material/typescript.png)](https://typescript-eslint.io/)              | [prefer-namespace-keyword](https://typescript-eslint.io/rules/prefer-namespace-keyword)<br />Require using `namespace` keyword over `module` keyword to declare custom TypeScript modules                                                                                                                                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
| [![functional](./icons/icons8/lambda.png)](https://github.com/eslint-functional/eslint-plugin-functional#readme) | [no-let](https://github.com/eslint-functional/eslint-plugin-functional/blob/v7.0.0/docs/rules/no-let.md)<br />Disallow mutable variables.                                                                                                                                                                                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |   🧪🚫    |
| [![functional](./icons/icons8/lambda.png)](https://github.com/eslint-functional/eslint-plugin-functional#readme) | [no-loop-statements](https://github.com/eslint-functional/eslint-plugin-functional/blob/v7.0.0/docs/rules/no-loop-statements.md)<br />Disallow imperative loops.                                                                                                                                                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|         [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)         | [max-dependencies](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/max-dependencies.md)<br />Enforce the maximum number of dependencies a module can have.                                                                                                                                                                     | <details><summary>ignoreTypeImports: true</summary><pre lang="json"><code>{&#13;  "ignoreTypeImports": true&#13;}</code></pre></details>                                                                                                                                                                                                                                                                                                                                                                                                                                 |         |           |
|         [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)         | [no-anonymous-default-export](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/no-anonymous-default-export.md)<br />Forbid anonymous values as default exports.                                                                                                                                                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|         [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)         | [no-duplicates](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/no-duplicates.md)<br />Forbid repeated import of the same module in multiple places.                                                                                                                                                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|         [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)         | [no-named-as-default](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/no-named-as-default.md)<br />Forbid use of exported name as identifier of default export.                                                                                                                                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|         [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)         | [no-named-as-default-member](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/no-named-as-default-member.md)<br />Forbid use of exported name as property of default export.                                                                                                                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|         [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)         | [no-named-default](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/no-named-default.md)<br />Forbid named default exports.                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|         [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)         | [no-unassigned-import](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/no-unassigned-import.md)<br />Forbid unassigned imports                                                                                                                                                                                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|         [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)         | [no-useless-path-segments](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/no-useless-path-segments.md)<br />Forbid unnecessary path segments in import and require statements.                                                                                                                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|    [![promise](./icons/icons8/promise.png)](https://github.com/eslint-community/eslint-plugin-promise#readme)    | [no-callback-in-promise](https://github.com/eslint-community/eslint-plugin-promise/blob/main/docs/rules/no-callback-in-promise.md)<br />Disallow calling `cb()` inside of a `then()` (use [nodeify][] instead).                                                                                                                                          | <details><summary>exceptions: next</summary><pre lang="json"><code>{&#13;  "exceptions": [&#13;    "next"&#13;  ]&#13;}</code></pre></details>                                                                                                                                                                                                                                                                                                                                                                                                                           |         |           |
|    [![promise](./icons/icons8/promise.png)](https://github.com/eslint-community/eslint-plugin-promise#readme)    | [no-nesting](https://github.com/eslint-community/eslint-plugin-promise/blob/main/docs/rules/no-nesting.md)<br />Disallow nested `then()` or `catch()` statements.                                                                                                                                                                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|    [![promise](./icons/icons8/promise.png)](https://github.com/eslint-community/eslint-plugin-promise#readme)    | [no-promise-in-callback](https://github.com/eslint-community/eslint-plugin-promise/blob/main/docs/rules/no-promise-in-callback.md)<br />Disallow using promises inside of callbacks.                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|    [![promise](./icons/icons8/promise.png)](https://github.com/eslint-community/eslint-plugin-promise#readme)    | [no-return-in-finally](https://github.com/eslint-community/eslint-plugin-promise/blob/main/docs/rules/no-return-in-finally.md)<br />Disallow return statements in `finally()`.                                                                                                                                                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|    [![promise](./icons/icons8/promise.png)](https://github.com/eslint-community/eslint-plugin-promise#readme)    | [valid-params](https://github.com/eslint-community/eslint-plugin-promise/blob/main/docs/rules/valid-params.md)<br />Enforces the proper number of arguments are passed to Promise functions.                                                                                                                                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|        [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)        | [max-switch-cases](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/max-switch-cases.md)<br />"switch" statements should not have too many "case" clauses                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|        [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)        | [no-collapsible-if](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-collapsible-if.md)<br />Collapsible "if" statements should be merged                                                                                                                                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|        [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)        | [no-duplicate-string](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-duplicate-string.md)<br />String literals should not be duplicated                                                                                                                                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |   🧪🚫    |
|        [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)        | [no-inverted-boolean-check](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-inverted-boolean-check.md)<br />Boolean checks should not be inverted                                                                                                                                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|        [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)        | [no-nested-switch](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-nested-switch.md)<br />"switch" statements should not be nested                                                                                                                                                                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|        [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)        | [no-nested-template-literals](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-nested-template-literals.md)<br />Template literals should not be nested                                                                                                                                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|        [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)        | [no-redundant-boolean](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-redundant-boolean.md)<br />Boolean literals should not be redundant                                                                                                                                                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|        [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)        | [no-redundant-jump](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-redundant-jump.md)<br />Jump statements should not be redundant                                                                                                                                                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   💡    |           |
|        [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)        | [no-same-line-conditional](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-same-line-conditional.md)<br />Conditionals should start on new lines                                                                                                                                                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   💡    |           |
|        [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)        | [no-small-switch](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-small-switch.md)<br />"switch" statements should have at least 3 "case" clauses                                                                                                                                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|        [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)        | [no-useless-catch](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/no-useless-catch.md)<br />"catch" clauses should do more than rethrow                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|        [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)        | [prefer-immediate-return](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/prefer-immediate-return.md)<br />Local variables should not be declared and then immediately returned or thrown                                                                                                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|        [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)        | [prefer-object-literal](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/prefer-object-literal.md)<br />Object literal syntax should be used                                                                                                                                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|        [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)        | [prefer-single-boolean-return](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/prefer-single-boolean-return.md)<br />Return of boolean expressions should not be wrapped into an "if-then-else" statement                                                                                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   💡    |           |
|        [![sonarjs](./icons/other/sonar.png)](https://github.com/SonarSource/eslint-plugin-sonarjs#readme)        | [prefer-while](https://github.com/SonarSource/eslint-plugin-sonarjs/blob/master/docs/rules/prefer-while.md)<br />A "while" loop should be used instead of a "for" loop                                                                                                                                                                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [better-regex](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/better-regex.md)<br />Improve regexes by making them shorter, consistent, and safer.                                                                                                                                                                        | <details><summary>sortCharacterClasses: false</summary><pre lang="json"><code>{&#13;  "sortCharacterClasses": false&#13;}</code></pre></details>                                                                                                                                                                                                                                                                                                                                                                                                                         |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [catch-error-name](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/catch-error-name.md)<br />Enforce a specific parameter name in catch clauses.                                                                                                                                                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [consistent-destructuring](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/consistent-destructuring.md)<br />Use destructured variables over properties.                                                                                                                                                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [consistent-function-scoping](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/consistent-function-scoping.md)<br />Move function definitions to the highest possible scope.                                                                                                                                                | <details><summary>checkArrowFunctions: false</summary><pre lang="json"><code>{&#13;  "checkArrowFunctions": false&#13;}</code></pre></details>                                                                                                                                                                                                                                                                                                                                                                                                                           |         |   🧪🚫    |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [empty-brace-spaces](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/empty-brace-spaces.md)<br />Enforce no spaces between braces.                                                                                                                                                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [error-message](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/error-message.md)<br />Enforce passing a `message` value when creating a built-in error.                                                                                                                                                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [escape-case](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/escape-case.md)<br />Require escape sequences to use uppercase values.                                                                                                                                                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [expiring-todo-comments](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/expiring-todo-comments.md)<br />Add expiration conditions to TODO comments.                                                                                                                                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [explicit-length-check](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/explicit-length-check.md)<br />Enforce explicitly comparing the `length` or `size` property of a value.                                                                                                                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [filename-case](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/filename-case.md)<br />Enforce a case style for filenames.                                                                                                                                                                                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [import-style](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/import-style.md)<br />Enforce specific import styles per module.                                                                                                                                                                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [new-for-builtins](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/new-for-builtins.md)<br />Enforce the use of `new` for all builtins, except `String`, `Number`, `Boolean`, `Symbol` and `BigInt`.                                                                                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-abusive-eslint-disable](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-abusive-eslint-disable.md)<br />Enforce specifying rules to disable in `eslint-disable` comments.                                                                                                                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-array-callback-reference](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-array-callback-reference.md)<br />Prevent passing a function reference directly to iterator methods.                                                                                                                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   💡    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-array-for-each](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-array-for-each.md)<br />Prefer `for…of` over the `forEach` method.                                                                                                                                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-array-method-this-argument](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-array-method-this-argument.md)<br />Disallow using the `this` argument in array methods.                                                                                                                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-array-push-push](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-array-push-push.md)<br />Enforce combining multiple `Array#push()` into one call.                                                                                                                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-array-reduce](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-array-reduce.md)<br />Disallow `Array#reduce()` and `Array#reduceRight()`.                                                                                                                                                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-await-expression-member](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-await-expression-member.md)<br />Disallow member access from await expression.                                                                                                                                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-console-spaces](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-console-spaces.md)<br />Do not use leading/trailing space between `console.log` parameters.                                                                                                                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-document-cookie](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-document-cookie.md)<br />Do not use `document.cookie` directly.                                                                                                                                                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-empty-file](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-empty-file.md)<br />Disallow empty files.                                                                                                                                                                                                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-for-loop](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-for-loop.md)<br />Do not use a `for` loop that can be replaced with a `for-of` loop.                                                                                                                                                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-hex-escape](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-hex-escape.md)<br />Enforce the use of Unicode escapes instead of hexadecimal escapes.                                                                                                                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-instanceof-array](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-instanceof-array.md)<br />Require `Array.isArray()` instead of `instanceof Array`.                                                                                                                                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-invalid-remove-event-listener](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-invalid-remove-event-listener.md)<br />Prevent calling `EventTarget#removeEventListener()` with the result of an expression.                                                                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-lonely-if](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-lonely-if.md)<br />Disallow `if` statements as the only statement in `if` blocks without `else`.                                                                                                                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-negated-condition](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-negated-condition.md)<br />Disallow negated conditions.                                                                                                                                                                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-nested-ternary](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-nested-ternary.md)<br />Disallow nested ternary expressions.                                                                                                                                                                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-new-array](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-new-array.md)<br />Disallow `new Array()`.                                                                                                                                                                                                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-new-buffer](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-new-buffer.md)<br />Enforce the use of `Buffer.from()` and `Buffer.alloc()` instead of the deprecated `new Buffer()`.                                                                                                                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-null](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-null.md)<br />Disallow the use of the `null` literal.                                                                                                                                                                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-object-as-default-parameter](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-object-as-default-parameter.md)<br />Disallow the use of objects as default parameters.                                                                                                                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-process-exit](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-process-exit.md)<br />Disallow `process.exit()`.                                                                                                                                                                                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-static-only-class](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-static-only-class.md)<br />Disallow classes that only have static members.                                                                                                                                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-thenable](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-thenable.md)<br />Disallow `then` property.                                                                                                                                                                                                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-this-assignment](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-this-assignment.md)<br />Disallow assigning `this` to a variable.                                                                                                                                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-typeof-undefined](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-typeof-undefined.md)<br />Disallow comparing `undefined` using `typeof`.                                                                                                                                                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-unnecessary-await](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-unnecessary-await.md)<br />Disallow awaiting non-promise values.                                                                                                                                                                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-unnecessary-polyfills](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-unnecessary-polyfills.md)<br />Enforce the use of built-in methods instead of unnecessary polyfills.                                                                                                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-unreadable-array-destructuring](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-unreadable-array-destructuring.md)<br />Disallow unreadable array destructuring.                                                                                                                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-unreadable-iife](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-unreadable-iife.md)<br />Disallow unreadable IIFEs.                                                                                                                                                                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-useless-fallback-in-spread](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-useless-fallback-in-spread.md)<br />Disallow useless fallback when spreading in object literals.                                                                                                                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-useless-length-check](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-useless-length-check.md)<br />Disallow useless array length check.                                                                                                                                                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-useless-promise-resolve-reject](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-useless-promise-resolve-reject.md)<br />Disallow returning/yielding `Promise.resolve/reject()` in async functions or promise callbacks                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-useless-spread](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-useless-spread.md)<br />Disallow unnecessary spread.                                                                                                                                                                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-useless-switch-case](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-useless-switch-case.md)<br />Disallow useless case in switch statements.                                                                                                                                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   💡    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-useless-undefined](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-useless-undefined.md)<br />Disallow useless `undefined`.                                                                                                                                                                                         | <details><summary>checkArguments: false</summary><pre lang="json"><code>{&#13;  "checkArguments": false&#13;}</code></pre></details>                                                                                                                                                                                                                                                                                                                                                                                                                                     |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [no-zero-fractions](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/no-zero-fractions.md)<br />Disallow number literals with zero fractions or dangling dots.                                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [number-literal-case](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/number-literal-case.md)<br />Enforce proper case for numeric literals.                                                                                                                                                                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [numeric-separators-style](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/numeric-separators-style.md)<br />Enforce the style of numeric separators by correctly grouping digits.                                                                                                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-add-event-listener](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-add-event-listener.md)<br />Prefer `.addEventListener()` and `.removeEventListener()` over `on`-functions.                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-array-find](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-array-find.md)<br />Prefer `.find(…)` and `.findLast(…)` over the first or last element from `.filter(…)`.                                                                                                                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-array-flat](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-array-flat.md)<br />Prefer `Array#flat()` over legacy techniques to flatten arrays.                                                                                                                                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-array-flat-map](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-array-flat-map.md)<br />Prefer `.flatMap(…)` over `.map(…).flat()`.                                                                                                                                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-array-index-of](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-array-index-of.md)<br />Prefer `Array#{indexOf,lastIndexOf}()` over `Array#{findIndex,findLastIndex}()` when looking for the index of an item.                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-array-some](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-array-some.md)<br />Prefer `.some(…)` over `.filter(…).length` check and `.{find,findLast}(…)`.                                                                                                                                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-at](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-at.md)<br />Prefer `.at()` method for index access and `String#charAt()`.                                                                                                                                                                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-blob-reading-methods](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-blob-reading-methods.md)<br />Prefer `Blob#arrayBuffer()` over `FileReader#readAsArrayBuffer(…)` and `Blob#text()` over `FileReader#readAsText(…)`.                                                                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-code-point](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-code-point.md)<br />Prefer `String#codePointAt(…)` over `String#charCodeAt(…)` and `String.fromCodePoint(…)` over `String.fromCharCode(…)`.                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   💡    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-date-now](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-date-now.md)<br />Prefer `Date.now()` to get the number of milliseconds since the Unix Epoch.                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-default-parameters](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-default-parameters.md)<br />Prefer default parameters over reassignment.                                                                                                                                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-dom-node-append](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-dom-node-append.md)<br />Prefer `Node#append()` over `Node#appendChild()`.                                                                                                                                                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-dom-node-dataset](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-dom-node-dataset.md)<br />Prefer using `.dataset` on DOM elements over calling attribute methods.                                                                                                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-dom-node-remove](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-dom-node-remove.md)<br />Prefer `childNode.remove()` over `parentNode.removeChild(childNode)`.                                                                                                                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-dom-node-text-content](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-dom-node-text-content.md)<br />Prefer `.textContent` over `.innerText`.                                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   💡    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-event-target](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-event-target.md)<br />Prefer `EventTarget` over `EventEmitter`.                                                                                                                                                                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |         |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-export-from](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-export-from.md)<br />Prefer `export…from` when re-exporting.                                                                                                                                                                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-includes](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-includes.md)<br />Prefer `.includes()` over `.indexOf()` and `Array#some()` when checking for existence or non-existence.                                                                                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-keyboard-event-key](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-keyboard-event-key.md)<br />Prefer `KeyboardEvent#key` over `KeyboardEvent#keyCode`.                                                                                                                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-logical-operator-over-ternary](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-logical-operator-over-ternary.md)<br />Prefer using a logical operator over a ternary.                                                                                                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   💡    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-math-trunc](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-math-trunc.md)<br />Enforce the use of `Math.trunc` instead of bitwise operators.                                                                                                                                                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-modern-dom-apis](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-modern-dom-apis.md)<br />Prefer `.before()` over `.insertBefore()`, `.replaceWith()` over `.replaceChild()`, prefer one of `.before()`, `.after()`, `.append()` or `.prepend()` over `insertAdjacentText()` and `insertAdjacentElement()`. |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-modern-math-apis](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-modern-math-apis.md)<br />Prefer modern `Math` APIs over legacy patterns.                                                                                                                                                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-module](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-module.md)<br />Prefer JavaScript modules (ESM) over CommonJS.                                                                                                                                                                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-native-coercion-functions](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-native-coercion-functions.md)<br />Prefer using `String`, `Number`, `BigInt`, `Boolean`, and `Symbol` directly.                                                                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-negative-index](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-negative-index.md)<br />Prefer negative index over `.length - index` when possible.                                                                                                                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-node-protocol](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-node-protocol.md)<br />Prefer using the `node:` protocol when importing Node.js builtin modules.                                                                                                                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-number-properties](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-number-properties.md)<br />Prefer `Number` static properties over global ones.                                                                                                                                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-object-from-entries](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-object-from-entries.md)<br />Prefer using `Object.fromEntries(…)` to transform a list of key-value pairs into an object.                                                                                                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-optional-catch-binding](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-optional-catch-binding.md)<br />Prefer omitting the `catch` binding parameter.                                                                                                                                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-prototype-methods](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-prototype-methods.md)<br />Prefer borrowing methods from the prototype instead of the instance.                                                                                                                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-query-selector](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-query-selector.md)<br />Prefer `.querySelector()` over `.getElementById()`, `.querySelectorAll()` over `.getElementsByClassName()` and `.getElementsByTagName()`.                                                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-reflect-apply](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-reflect-apply.md)<br />Prefer `Reflect.apply()` over `Function#apply()`.                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-regexp-test](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-regexp-test.md)<br />Prefer `RegExp#test()` over `String#match()` and `RegExp#exec()`.                                                                                                                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-set-has](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-set-has.md)<br />Prefer `Set#has()` over `Array#includes()` when checking for existence or non-existence.                                                                                                                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-set-size](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-set-size.md)<br />Prefer using `Set#size` instead of `Array#length`.                                                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-spread](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-spread.md)<br />Prefer the spread operator over `Array.from(…)`, `Array#concat(…)`, `Array#{slice,toSpliced}()` and `String#split('')`.                                                                                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-string-replace-all](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-string-replace-all.md)<br />Prefer `String#replaceAll()` over regex searches with the global flag.                                                                                                                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-string-slice](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-string-slice.md)<br />Prefer `String#slice()` over `String#substr()` and `String#substring()`.                                                                                                                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-string-starts-ends-with](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-string-starts-ends-with.md)<br />Prefer `String#startsWith()` & `String#endsWith()` over `RegExp#test()`.                                                                                                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-string-trim-start-end](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-string-trim-start-end.md)<br />Prefer `String#trimStart()` / `String#trimEnd()` over `String#trimLeft()` / `String#trimRight()`.                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-switch](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-switch.md)<br />Prefer `switch` over multiple `else-if`.                                                                                                                                                                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-ternary](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-ternary.md)<br />Prefer ternary expressions over simple `if-else` statements.                                                                                                                                                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-top-level-await](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-top-level-await.md)<br />Prefer top-level await over top-level promises and async function calls.                                                                                                                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   💡    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prefer-type-error](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prefer-type-error.md)<br />Enforce throwing `TypeError` in type checking conditions.                                                                                                                                                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [prevent-abbreviations](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/prevent-abbreviations.md)<br />Prevent abbreviations.                                                                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [relative-url-style](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/relative-url-style.md)<br />Enforce consistent relative URL style.                                                                                                                                                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [require-array-join-separator](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/require-array-join-separator.md)<br />Enforce using the separator argument with `Array#join()`.                                                                                                                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [require-number-to-fixed-digits-argument](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/require-number-to-fixed-digits-argument.md)<br />Enforce using the digits argument with `Number#toFixed()`.                                                                                                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [switch-case-braces](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/switch-case-braces.md)<br />Enforce consistent brace style for `case` clauses.                                                                                                                                                                        | <details><summary>avoid</summary><pre lang="json"><code>"avoid"</code></pre></details>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [template-indent](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/template-indent.md)<br />Fix whitespace-insensitive template indentation.                                                                                                                                                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [text-encoding-identifier-case](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/text-encoding-identifier-case.md)<br />Enforce consistent case for text encoding identifiers.                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🔧, 💡  |           |
|      [![unicorn](./icons/icons8/unicorn.png)](https://github.com/sindresorhus/eslint-plugin-unicorn#readme)      | [throw-new-error](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/v50.0.0/docs/rules/throw-new-error.md)<br />Require `new` when throwing an error.                                                                                                                                                                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |   🔧    |           |
