# `angular` config

Config for **Angular** projects.

## 🏗️ Setup

1. If you haven't already, make sure to [install `@code-pushup/eslint-config` and its required peer dependencies](../README.md#🏗️-setup).
2. Since this plugin requires additional peer dependencies, you have to install them as well:

   ```sh
   npm install -D angular-eslint eslint-plugin-rxjs-x
   ```

3. Refer to [step 3 in TypeScript config's setup docs](./typescript.md#🏗️-setup) for how to set up tsconfig properly.
4. Add to your `eslint.config.js` file:

   ```js
   import angular from '@code-pushup/eslint-config/angular.js';
   import tseslint from 'typescript-eslint';
   
   export default tseslint.config(
     ...angular,
     {
       // It is recommended that selectors in Angular use a common custom prefix
       // - see https://angular.io/guide/styleguide#style-02-07
       // To enforce this consistently, add the following rules:
       rules: {
         '@angular-eslint/component-selector': [
           'warn',
           {
             type: 'element',
             style: 'kebab-case',
             prefix: ['cp'] // <-- replace with your own prefix
           }
         ],
         '@angular-eslint/directive-selector': [
           'warn',
           {
             type: 'attribute',
             style: 'camelCase',
             prefix: 'cp' // <-- replace with your own prefix
           }
         ],
         '@angular-eslint/pipe-prefix': [
           'warn',
           {
             prefixes: ['cp'] // <-- replace with your own prefix
           }
         ]
       }
     }
   );
   ```

## 📏 Rules (425)

**345** rules are included from [`typescript` config](./typescript.md#📏-rules-345). For brevity, only the **80** additional rules are listed in this document.

> 🔧 Automatically fixable by the [`--fix` CLI option](https://eslint.org/docs/user-guide/command-line-interface#--fix).<br>💡 Manually fixable by [editor suggestions](https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions).<br>🧪🚫 Disabled for [test files](../README.md#🧪-test-overrides).<br>🧪⚠️ Severity lessened to warning for [test files](../README.md#🧪-test-overrides).

### 🚨 Errors (35)

|                                                                                  Plugin                                                                                  | Rule                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | Options                                                                                                                                        | Autofix | Overrides |
| :----------------------------------------------------------------------------------------------------------------------------------------------------------------------: | :-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :--------------------------------------------------------------------------------------------------------------------------------------------- | :-----: | :-------: |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [contextual-decorator](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/contextual-decorator.md)<br />Ensures that classes use contextual decorators in its body                                                                                                                                                                                                                                                                                                                |                                                                                                                                                |         |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [contextual-lifecycle](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/contextual-lifecycle.md)<br />Ensures that lifecycle methods are used in a correct context                                                                                                                                                                                                                                                                                                              |                                                                                                                                                |         |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [no-conflicting-lifecycle](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/no-conflicting-lifecycle.md)<br />Ensures that directives not implement conflicting lifecycle interfaces.                                                                                                                                                                                                                                                                                           |                                                                                                                                                |         |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [use-component-view-encapsulation](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/use-component-view-encapsulation.md)<br />Disallows using `ViewEncapsulation.None`                                                                                                                                                                                                                                                                                                          |                                                                                                                                                |   💡    |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [use-pipe-transform-interface](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/use-pipe-transform-interface.md)<br />Ensures that `Pipes` implement `PipeTransform` interface                                                                                                                                                                                                                                                                                                  |                                                                                                                                                |   🔧    |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [alt-text](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/alt-text.md)<br />[Accessibility] Enforces alternate text for elements which require the alt, aria-label, aria-labelledby attributes.                                                                                                                                                                                                                                                                      |                                                                                                                                                |         |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [banana-in-box](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/banana-in-box.md)<br />Ensures that the two-way data binding syntax is correct                                                                                                                                                                                                                                                                                                                        |                                                                                                                                                |   🔧    |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [click-events-have-key-events](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/click-events-have-key-events.md)<br />[Accessibility] Ensures that the click event is accompanied with at least one key event keyup, keydown or keypress.                                                                                                                                                                                                                              |                                                                                                                                                |         |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [elements-content](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/elements-content.md)<br />[Accessibility] Ensures that the heading, anchor and button elements have content in it                                                                                                                                                                                                                                                                                  |                                                                                                                                                |         |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [eqeqeq](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/eqeqeq.md)<br />Requires `===` and `!==` in place of `==` and `!=`                                                                                                                                                                                                                                                                                                                                           | <details><summary>allowNullOrUndefined: true</summary><pre lang="json"><code>{&#13;  "allowNullOrUndefined": true&#13;}</code></pre></details> | 🔧, 💡  |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [interactive-supports-focus](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/interactive-supports-focus.md)<br />[Accessibility] Ensures that elements with interactive handlers like `(click)` are focusable.                                                                                                                                                                                                                                                        |                                                                                                                                                |         |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [label-has-associated-control](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/label-has-associated-control.md)<br />[Accessibility] Ensures that a label element/component is associated with a form element                                                                                                                                                                                                                                                         |                                                                                                                                                |         |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [mouse-events-have-key-events](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/mouse-events-have-key-events.md)<br />[Accessibility] Ensures that the mouse events `mouseout` and `mouseover` are accompanied by `focus` and `blur` events respectively. Coding for the keyboard is important for users with physical disabilities who cannot use a mouse, AT compatibility, and screenreader users. See more at https://www.w3.org/WAI/WCAG21/Understanding/keyboard |                                                                                                                                                |         |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [no-any](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/no-any.md)<br />The use of "$any" nullifies the compile-time benefits of Angular's type system                                                                                                                                                                                                                                                                                                               |                                                                                                                                                |   💡    |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [no-distracting-elements](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/no-distracting-elements.md)<br />[Accessibility] Enforces that no distracting elements are used                                                                                                                                                                                                                                                                                             |                                                                                                                                                |   🔧    |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [no-duplicate-attributes](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/no-duplicate-attributes.md)<br />Ensures that there are no duplicate input properties or output event listeners                                                                                                                                                                                                                                                                             |                                                                                                                                                |   💡    |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [no-negated-async](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/no-negated-async.md)<br />Ensures that async pipe results, as well as values used with the async pipe, are not negated                                                                                                                                                                                                                                                                             |                                                                                                                                                |   💡    |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [role-has-required-aria](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/role-has-required-aria.md)<br />[Accessibility] Ensures elements with ARIA roles have all required properties for that role.                                                                                                                                                                                                                                                                 |                                                                                                                                                |   💡    |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [table-scope](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/table-scope.md)<br />[Accessibility] Ensures that the `scope` attribute is only used on the `<th>` element                                                                                                                                                                                                                                                                                              |                                                                                                                                                |   🔧    |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [valid-aria](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/valid-aria.md)<br />[Accessibility] Ensures that correct ARIA attributes and respective values are used                                                                                                                                                                                                                                                                                                  |                                                                                                                                                |   💡    |           |
|                                     [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)                                     | [no-namespace](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/no-namespace.md)<br />Forbid namespace (a.k.a. "wildcard" `*`) imports.                                                                                                                                                                                                                                                                                                                                                            |                                                                                                                                                |   🔧    |           |
|                                     [![import](./icons/icons8/import.png)](https://github.com/import-js/eslint-plugin-import#readme)                                     | [no-nodejs-modules](https://github.com/import-js/eslint-plugin-import/blob/v2.31.0/docs/rules/no-nodejs-modules.md)<br />Forbid Node.js builtin modules.                                                                                                                                                                                                                                                                                                                                                                    |                                                                                                                                                |         |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-floating-observables](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-floating-observables.md)<br />Require Observables to be handled appropriately.                                                                                                                                                                                                                                                                                                                                     |                                                                                                                                                |         |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-ignored-notifier](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-ignored-notifier.md)<br />Disallow observables not composed from the `repeatWhen` or `retryWhen` notifier.                                                                                                                                                                                                                                                                                                             |                                                                                                                                                |         |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-ignored-replay-buffer](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-ignored-replay-buffer.md)<br />Disallow using `ReplaySubject`, `publishReplay` or `shareReplay` without specifying the buffer size.                                                                                                                                                                                                                                                                               |                                                                                                                                                |         |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-ignored-takewhile-value](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-ignored-takewhile-value.md)<br />Disallow ignoring the value within `takeWhile`.                                                                                                                                                                                                                                                                                                                                |                                                                                                                                                |         |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-implicit-any-catch](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-implicit-any-catch.md)<br />Disallow implicit `any` error parameters in `catchError` operators.                                                                                                                                                                                                                                                                                                                      |                                                                                                                                                | 🔧, 💡  |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-index](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-index.md)<br />Disallow importing index modules.                                                                                                                                                                                                                                                                                                                                                                                  |                                                                                                                                                |         |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-internal](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-internal.md)<br />Disallow importing internal modules.                                                                                                                                                                                                                                                                                                                                                                         |                                                                                                                                                | 🔧, 💡  |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-redundant-notify](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-redundant-notify.md)<br />Disallow sending redundant notifications from completed or errored observables.                                                                                                                                                                                                                                                                                                              |                                                                                                                                                |         |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-sharereplay](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-sharereplay.md)<br />Disallow unsafe `shareReplay` usage.                                                                                                                                                                                                                                                                                                                                                                   |                                                                                                                                                |         |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-subject-unsubscribe](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-subject-unsubscribe.md)<br />Disallow calling the `unsubscribe` method of subjects.                                                                                                                                                                                                                                                                                                                                 |                                                                                                                                                |         |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-unbound-methods](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-unbound-methods.md)<br />Disallow passing unbound methods.                                                                                                                                                                                                                                                                                                                                                              |                                                                                                                                                |         |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-unsafe-subject-next](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-unsafe-subject-next.md)<br />Disallow unsafe optional `next` calls.                                                                                                                                                                                                                                                                                                                                                 |                                                                                                                                                |         |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-unsafe-takeuntil](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-unsafe-takeuntil.md)<br />Disallow applying operators after `takeUntil`.                                                                                                                                                                                                                                                                                                                                               |                                                                                                                                                |         |           |

### ⚠️ Warnings (45)

|                                                                                  Plugin                                                                                  | Rule                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | Options                                                                                                                                                                    | Autofix | Overrides |
| :----------------------------------------------------------------------------------------------------------------------------------------------------------------------: | :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :-----: | :-------: |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [component-class-suffix](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/component-class-suffix.md)<br />Classes decorated with @Component must have suffix "Component" (or custom) in their name. See more at https://angular.dev/style-guide#style-02-03                                                                                                                                                                                                        |                                                                                                                                                                            |         |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [component-max-inline-declarations](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/component-max-inline-declarations.md)<br />Enforces a maximum number of lines in inline template, styles and animations. See more at https://angular.dev/style-guide#style-05-04                                                                                                                                                                                              |                                                                                                                                                                            |         |   🧪🚫    |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [component-selector](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/component-selector.md)<br />Component selectors should follow given naming rules. See more at https://angular.dev/style-guide#style-02-07, https://angular.dev/style-guide#style-05-02<br />      and https://angular.dev/style-guide#style-05-03.                                                                                                                                           | <details><summary>type: element, style: kebab...</summary><pre lang="json"><code>{&#13;  "type": "element",&#13;  "style": "kebab-case"&#13;}</code></pre></details>       |         |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [directive-class-suffix](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/directive-class-suffix.md)<br />Classes decorated with @Directive must have suffix "Directive" (or custom) in their name. See more at https://angular.dev/style-guide#style-02-03                                                                                                                                                                                                        |                                                                                                                                                                            |         |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [directive-selector](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/directive-selector.md)<br />Directive selectors should follow given naming rules. See more at https://angular.dev/style-guide#style-02-06 and https://angular.dev/style-guide#style-02-08.                                                                                                                                                                                                   | <details><summary>type: attribute, style: cam...</summary><pre lang="json"><code>{&#13;  "type": "attribute",&#13;  "style": "camelCase"&#13;}</code></pre></details>      |         |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [no-attribute-decorator](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/no-attribute-decorator.md)<br />The @Attribute decorator is used to obtain a single value for an attribute. This is a much less common use-case than getting a stream of values (using @Input), so often the @Attribute decorator is mistakenly used when @Input was what was intended. This rule disallows usage of @Attribute decorator altogether in order to prevent these mistakes. |                                                                                                                                                                            |         |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [no-empty-lifecycle-method](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/no-empty-lifecycle-method.md)<br />Disallows declaring empty lifecycle methods                                                                                                                                                                                                                                                                                                        |                                                                                                                                                                            |   💡    |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [no-input-rename](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/no-input-rename.md)<br />Ensures that input bindings are not aliased                                                                                                                                                                                                                                                                                                                            |                                                                                                                                                                            | 🔧, 💡  |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [no-inputs-metadata-property](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/no-inputs-metadata-property.md)<br />Disallows usage of the `inputs` metadata property. See more at https://angular.dev/style-guide#style-05-12                                                                                                                                                                                                                                     |                                                                                                                                                                            |         |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [no-lifecycle-call](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/no-lifecycle-call.md)<br />Disallows explicit calls to lifecycle methods                                                                                                                                                                                                                                                                                                                      |                                                                                                                                                                            |         |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [no-output-native](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/no-output-native.md)<br />Ensures that output bindings, including aliases, are not named as standard DOM events                                                                                                                                                                                                                                                                                |                                                                                                                                                                            |         |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [no-output-on-prefix](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/no-output-on-prefix.md)<br />Ensures that output bindings, including aliases, are not named "on", nor prefixed with it. See more at https://angular.dev/style-guide#style-05-16                                                                                                                                                                                                             |                                                                                                                                                                            |         |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [no-output-rename](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/no-output-rename.md)<br />Ensures that output bindings are not aliased                                                                                                                                                                                                                                                                                                                         |                                                                                                                                                                            | 🔧, 💡  |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [no-outputs-metadata-property](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/no-outputs-metadata-property.md)<br />Disallows usage of the `outputs` metadata property. See more at https://angular.dev/style-guide#style-05-12                                                                                                                                                                                                                                  |                                                                                                                                                                            |         |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [no-pipe-impure](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/no-pipe-impure.md)<br />Disallows the declaration of impure pipes                                                                                                                                                                                                                                                                                                                                |                                                                                                                                                                            |   💡    |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [no-queries-metadata-property](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/no-queries-metadata-property.md)<br />Disallows usage of the `queries` metadata property. See more at https://angular.dev/style-guide#style-05-12.                                                                                                                                                                                                                                 |                                                                                                                                                                            |         |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [prefer-on-push-component-change-detection](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/prefer-on-push-component-change-detection.md)<br />Ensures component's `changeDetection` is set to `ChangeDetectionStrategy.OnPush`                                                                                                                                                                                                                                   |                                                                                                                                                                            |   💡    |   🧪🚫    |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [prefer-output-readonly](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/prefer-output-readonly.md)<br />Prefer to declare `@Output` as `readonly` since they are not supposed to be reassigned                                                                                                                                                                                                                                                                   |                                                                                                                                                                            |   💡    |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [prefer-standalone-component](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/prefer-standalone-component.md)<br />Ensures component `standalone` property is set to `true` in the component decorator                                                                                                                                                                                                                                                            |                                                                                                                                                                            |   🔧    |   🧪🚫    |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [relative-url-prefix](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/relative-url-prefix.md)<br />The ./ and ../ prefix is standard syntax for relative URLs; don't depend on Angular's current ability to do without that prefix. See more at https://angular.dev/style-guide#style-05-04                                                                                                                                                                       |                                                                                                                                                                            |         |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [sort-lifecycle-methods](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/sort-lifecycle-methods.md)<br />Ensures that lifecycle methods are declared in order of execution                                                                                                                                                                                                                                                                                        |                                                                                                                                                                            |         |           |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [use-component-selector](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/use-component-selector.md)<br />Component selector must be declared                                                                                                                                                                                                                                                                                                                      |                                                                                                                                                                            |         |   🧪🚫    |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [use-injectable-provided-in](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/use-injectable-provided-in.md)<br />Using the `providedIn` property makes `Injectables` tree-shakable                                                                                                                                                                                                                                                                                |                                                                                                                                                                            |   💡    |   🧪🚫    |
|               [![@angular-eslint](./icons/material/angular.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin#readme)               | [use-lifecycle-interface](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/use-lifecycle-interface.md)<br />Ensures that classes implement lifecycle interfaces corresponding to the declared lifecycle methods. See more at https://angular.dev/style-guide#style-09-01                                                                                                                                                                                           |                                                                                                                                                                            |   🔧    |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [conditional-complexity](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/conditional-complexity.md)<br />The conditional complexity should not exceed a rational limit                                                                                                                                                                                                                                                                                   |                                                                                                                                                                            |         |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [cyclomatic-complexity](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/cyclomatic-complexity.md)<br />Checks cyclomatic complexity against a specified limit. It is a quantitative measure of the number of linearly independent paths through a program's source code                                                                                                                                                                                  | <details><summary>maxComplexity: 20</summary><pre lang="json"><code>{&#13;  "maxComplexity": 20&#13;}</code></pre></details>                                               |         |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [no-autofocus](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/no-autofocus.md)<br />[Accessibility] Ensures that the `autofocus` attribute is not used                                                                                                                                                                                                                                                                                                  |                                                                                                                                                                            |   🔧    |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [no-inline-styles](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/no-inline-styles.md)<br />Disallows the use of inline styles in HTML templates                                                                                                                                                                                                                                                                                                        | <details><summary>allowNgStyle: true, allowBi...</summary><pre lang="json"><code>{&#13;  "allowNgStyle": true,&#13;  "allowBindToStyle": true&#13;}</code></pre></details> |         |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [no-interpolation-in-attributes](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/no-interpolation-in-attributes.md)<br />Ensures that property-binding is used instead of interpolation in attributes.                                                                                                                                                                                                                                                   |                                                                                                                                                                            |         |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [no-positive-tabindex](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/no-positive-tabindex.md)<br />Ensures that the `tabindex` attribute is not positive                                                                                                                                                                                                                                                                                               |                                                                                                                                                                            |   💡    |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [prefer-control-flow](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/prefer-control-flow.md)<br />Ensures that the built-in control flow is used.                                                                                                                                                                                                                                                                                                       |                                                                                                                                                                            |         |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [prefer-ngsrc](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/prefer-ngsrc.md)<br />Ensures ngSrc is used instead of src for img elements                                                                                                                                                                                                                                                                                                               |                                                                                                                                                                            |         |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [prefer-self-closing-tags](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/prefer-self-closing-tags.md)<br />Ensures that self-closing tags are used for elements with a closing tag but no content.                                                                                                                                                                                                                                                     |                                                                                                                                                                            |   🔧    |           |
| [![@angular-eslint/template](./icons/material/angular_component.png)](https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template#readme) | [use-track-by-function](https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin-template/docs/rules/use-track-by-function.md)<br />Ensures trackBy function is used                                                                                                                                                                                                                                                                                                                  |                                                                                                                                                                            |         |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [finnish](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/finnish.md)<br />Enforce Finnish notation.                                                                                                                                                                                                                                                                                                                                                                               |                                                                                                                                                                            |         |   🧪🚫    |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-async-subscribe](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-async-subscribe.md)<br />Disallow passing `async` functions to `subscribe`.                                                                                                                                                                                                                                                                                                                                |                                                                                                                                                                            |         |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-compat](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-compat.md)<br />Disallow the `rxjs-compat` package.                                                                                                                                                                                                                                                                                                                                                                 |                                                                                                                                                                            |         |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-create](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-create.md)<br />Disallow the static `Observable.create` function.                                                                                                                                                                                                                                                                                                                                                   |                                                                                                                                                                            |         |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-exposed-subjects](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-exposed-subjects.md)<br />Disallow public and protected subjects.                                                                                                                                                                                                                                                                                                                                         |                                                                                                                                                                            |         |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-nested-subscribe](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-nested-subscribe.md)<br />Disallow calling `subscribe` within a `subscribe` callback.                                                                                                                                                                                                                                                                                                                     |                                                                                                                                                                            |         |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-subscribe-in-pipe](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-subscribe-in-pipe.md)<br />Disallow calling of `subscribe` within any RxJS operator inside a `pipe`.                                                                                                                                                                                                                                                                                                     |                                                                                                                                                                            |         |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [no-topromise](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/no-topromise.md)<br />Disallow use of the `toPromise` method.                                                                                                                                                                                                                                                                                                                                                       |                                                                                                                                                                            |   💡    |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [prefer-observer](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/prefer-observer.md)<br />Disallow passing separate handlers to `subscribe` and `tap`.                                                                                                                                                                                                                                                                                                                            |                                                                                                                                                                            | 🔧, 💡  |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [prefer-root-operators](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/prefer-root-operators.md)<br />Disallow importing operators from `rxjs/operators`.                                                                                                                                                                                                                                                                                                                         |                                                                                                                                                                            | 🔧, 💡  |           |
|                                    [![rxjs-x](./icons/other/rxjs.png)](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x#readme)                                    | [throw-error](https://github.com/JasonWeinzierl/eslint-plugin-rxjs-x/blob/main/docs/rules/throw-error.md)<br />Enforce passing only `Error` values to `throwError`.                                                                                                                                                                                                                                                                                                                                            |                                                                                                                                                                            |         |           |
