// Copyright 2016 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package examples

import (
	"encoding/hex"

	"github.com/cockroachdb/cockroach/pkg/workload"
)

type intro struct{}

func init() {
	workload.Register(introMeta)
}

var introMeta = workload.Meta{
	Name:        `intro`,
	Description: `Intro contains a single table with a hidden message.`,
	Version:     `1.0.0`,
	New:         func() workload.Generator { return intro{} },
}

// Meta implements the Generator interface.
func (intro) Meta() workload.Meta { return introMeta }

// Tables implements the Generator interface.
func (intro) Tables() []workload.Table {
	return []workload.Table{
		{
			Name:   `mytable`,
			Schema: `(l INT PRIMARY KEY, v TEXT)`,
			InitialRows: workload.Tuples(
				len(mytableRows),
				func(rowIdx int) []interface{} {
					// The second datum in mytableRows is a hex encoded string, but
					// we want to hand it back as bytes.
					row := mytableRows[rowIdx]
					bytes, err := hex.DecodeString(row[1].(string))
					if err != nil {
						panic(err)
					}
					return []interface{}{row[0], bytes}
				},
			),
		},
	}
}

var mytableRows = [...][]interface{}{
	{0, `215F5F61616177776D716D716D7777776161732C2C5F20202020202020202E5F5F6161617777776D716D716D77776161612C2C`},
	{2, `212256543F212222225E7E7E5E2222223F3F5424576D7161612C5F6175716D5742543F212222225E7E7E5E5E22223F3F59565E`},
	{4, `212020202020202020202020202020202020202020223F23236D5723233F222D20202020202020202020202020202020202020`},
	{6, `21202043204F204E2047205220412054205320205F616D235A3F3F41236D612C2020202020202020202020592020202020202020`},
	{8, `2120202020202020202020202020202020205F756D6D5922202020202239236D612C2020202020202041202020202020202020`},
	{10, `2120202020202020202020202020202020766D235A28202020202020202029586D6D7320202020592020202020202020202020`},
	{12, `2120202020202020202020202020202E6A232323236D6D6D23232323236D6D236D2323362E2020202020202020202020202020`},
	{14, `2120202057204F20572021202020206A6D6D2323236D6D2323232323236D236D6D6D2323362020202020202020202020202020`},
	{16, `21202020202020202020202020205D236D652A586D236D236D6D23236D236D2323535823236320202020202020202020202020`},
	{18, `2120202020202020202020202020646D237C7C2B2A2423236D236D6D236D235376766E23236D20202020202020202020202020`},
	{20, `212020202020202020202020203A6D6D453D7C2B7C7C5323236D23236D23316E766E6E5823233B20202020204120202020202020`},
	{22, `212020202020202020202020203A6D23682B7C2B2B2B3D586D6D236D23316E766E6E76646D6D3B20202020204D202020202020`},
	{24, `212059202020202020202020202024236D3E2B7C2B7C7C7C23236D23316E766E6E6E6E6D6D2320202020202041202020202020`},
	{26, `2120204F202020202020202020205D23237A2B7C2B7C2B7C33236D456E6E6E6E766E642323662020202020205A202020202020`},
	{28, `212020205520204420202020202020342323637C2B7C2B7C5D6D236B766E766E6E6F2323502020202020202045202020202020`},
	{30, `2120202020202020492020202020202034236D612B7C2B2B5D6D6D68766E6E7671232350602020202020202021202020202020`},
	{32, `21202020202020202044204920202020203F242371252B7C646D6D6D766E6E6D23232120202020202020202020202020202020`},
	{34, `2120202020202020202020205420202020202D3423237775236D6D237077232337272020202020202020202020202020202020`},
	{36, `21202020202020202020202020202020202020202D3F2423236D23232323592720202020202020202020202020202020202020`},
	{38, `21202020202020202020202020202121202020202020202259232359222D202020202020202020202020202020202020202020`},
	{40, `21`},
	{41, `215F5F61616177776D716D716D7777776161732C2C5F20202020202020202E5F5F6161617777776D716D716D77776161612C2C`},
	{39, `212256543F212222225E7E7E5E2222223F3F5424576D7161612C5F6175716D5742543F212222225E7E7E5E5E22223F3F59565E`},
	{37, `212020202020202020202020202020202020202020223F23236D5723233F222D20202020202020202020202020202020202020`},
	{35, `21202043204F204E2047205220412054205320205F616D235A3F3F41236D612C2020202020202020202020592020202020202020`},
	{33, `2120202020202020202020202020202020205F756D6D5922202020202239236D612C2020202020202041202020202020202020`},
	{31, `2120202020202020202020202020202020766D235A28202020202020202029586D6D7320202020592020202020202020202020`},
	{29, `2120202020202020202020202020202E6A232323236D6D6D23232323236D6D236D2323362E2020202020202020202020202020`},
	{27, `2120202057204F20572021202020206A6D6D2323236D6D2323232323236D236D6D6D2323362020202020202020202020202020`},
	{25, `21202020202020202020202020205D236D652A586D236D236D6D23236D236D2323535823236320202020202020202020202020`},
	{23, `2120202020202020202020202020646D237C7C2B2A2423236D236D6D236D235376766E23236D20202020202020202020202020`},
	{21, `212020202020202020202020203A6D6D453D7C2B7C7C5323236D23236D23316E766E6E5823233B20202020204120202020202020`},
	{19, `212020202020202020202020203A6D23682B7C2B2B2B3D586D6D236D23316E766E6E76646D6D3B20202020204D202020202020`},
	{17, `212059202020202020202020202024236D3E2B7C2B7C7C7C23236D23316E766E6E6E6E6D6D2320202020202041202020202020`},
	{15, `2120204F202020202020202020205D23237A2B7C2B7C2B7C33236D456E6E6E6E766E642323662020202020205A202020202020`},
	{13, `212020205520204420202020202020342323637C2B7C2B7C5D6D236B766E766E6E6F2323502020202020202045202020202020`},
	{11, `2120202020202020492020202020202034236D612B7C2B2B5D6D6D68766E6E7671232350602020202020202021202020202020`},
	{9, `21202020202020202044204920202020203F242371252B7C646D6D6D766E6E6D23232120202020202020202020202020202020`},
	{7, `2120202020202020202020205420202020202D3423237775236D6D237077232337272020202020202020202020202020202020`},
	{5, `21202020202020202020202020202020202020202D3F2423236D23232323592720202020202020202020202020202020202020`},
	{3, `21202020202020202020202020202121202020202020202259232359222D202020202020202020202020202020202020202020`},
	{1, `21`},
}
