// Code generated by gen/main.go. DO NOT EDIT.

package log

import (
	"context"

	"github.com/cockroachdb/cockroach/pkg/util/log/channel"
	"github.com/cockroachdb/cockroach/pkg/util/log/severity"
)

// ChannelLogger is a helper interface to ease the run-time selection
// of channels. We do not force use of ChannelLogger when
// instantiating the logger objects below (e.g. by giving them the
// interface type), to ensure the calls remain inlinable in the common
// case.
//
// Note that casting a channel logger to the interface
// type yields a heap allocation: it may be useful for performance to
// pre-allocate interface references in the global scope.
type ChannelLogger interface {
	// Infof logs to the channel with severity INFO.
	// It extracts log tags from the context and logs them along with the given
	// message. Arguments are handled in the manner of fmt.Printf.
	Infof(ctx context.Context, format string, args ...interface{})

	// VInfof logs to the channel with severity INFO,
	// if logging has been enabled for the source file where the call is
	// performed at the provided verbosity level, via the vmodule setting.
	// It extracts log tags from the context and logs them along with the given
	// message. Arguments are handled in the manner of fmt.Printf.
	VInfof(ctx context.Context, level Level, format string, args ...interface{})

	// Info logs to the channel with severity INFO.
	// It extracts log tags from the context and logs them along with the given
	// message.
	Info(ctx context.Context, msg string)

	// InfofDepth logs to the channel with severity INFO,
	// offsetting the caller's stack frame by 'depth'.
	// It extracts log tags from the context and logs them along with the given
	// message. Arguments are handled in the manner of fmt.Printf.
	InfofDepth(ctx context.Context, depth int, format string, args ...interface{})

	// Warningf logs to the channel with severity WARNING.
	// It extracts log tags from the context and logs them along with the given
	// message. Arguments are handled in the manner of fmt.Printf.
	Warningf(ctx context.Context, format string, args ...interface{})

	// VWarningf logs to the channel with severity WARNING,
	// if logging has been enabled for the source file where the call is
	// performed at the provided verbosity level, via the vmodule setting.
	// It extracts log tags from the context and logs them along with the given
	// message. Arguments are handled in the manner of fmt.Printf.
	VWarningf(ctx context.Context, level Level, format string, args ...interface{})

	// Warning logs to the channel with severity WARNING.
	// It extracts log tags from the context and logs them along with the given
	// message.
	Warning(ctx context.Context, msg string)

	// WarningfDepth logs to the channel with severity WARNING,
	// offsetting the caller's stack frame by 'depth'.
	// It extracts log tags from the context and logs them along with the given
	// message. Arguments are handled in the manner of fmt.Printf.
	WarningfDepth(ctx context.Context, depth int, format string, args ...interface{})

	// Errorf logs to the channel with severity ERROR.
	// It extracts log tags from the context and logs them along with the given
	// message. Arguments are handled in the manner of fmt.Printf.
	Errorf(ctx context.Context, format string, args ...interface{})

	// VErrorf logs to the channel with severity ERROR,
	// if logging has been enabled for the source file where the call is
	// performed at the provided verbosity level, via the vmodule setting.
	// It extracts log tags from the context and logs them along with the given
	// message. Arguments are handled in the manner of fmt.Printf.
	VErrorf(ctx context.Context, level Level, format string, args ...interface{})

	// Error logs to the channel with severity ERROR.
	// It extracts log tags from the context and logs them along with the given
	// message.
	Error(ctx context.Context, msg string)

	// ErrorfDepth logs to the channel with severity ERROR,
	// offsetting the caller's stack frame by 'depth'.
	// It extracts log tags from the context and logs them along with the given
	// message. Arguments are handled in the manner of fmt.Printf.
	ErrorfDepth(ctx context.Context, depth int, format string, args ...interface{})

	// Fatalf logs to the channel with severity FATAL.
	// It extracts log tags from the context and logs them along with the given
	// message. Arguments are handled in the manner of fmt.Printf.
	Fatalf(ctx context.Context, format string, args ...interface{})

	// VFatalf logs to the channel with severity FATAL,
	// if logging has been enabled for the source file where the call is
	// performed at the provided verbosity level, via the vmodule setting.
	// It extracts log tags from the context and logs them along with the given
	// message. Arguments are handled in the manner of fmt.Printf.
	VFatalf(ctx context.Context, level Level, format string, args ...interface{})

	// Fatal logs to the channel with severity FATAL.
	// It extracts log tags from the context and logs them along with the given
	// message.
	Fatal(ctx context.Context, msg string)

	// FatalfDepth logs to the channel with severity FATAL,
	// offsetting the caller's stack frame by 'depth'.
	// It extracts log tags from the context and logs them along with the given
	// message. Arguments are handled in the manner of fmt.Printf.
	FatalfDepth(ctx context.Context, depth int, format string, args ...interface{})

	// Shout logs to the channel, and also to the real stderr if logging
	// is currently redirected to a file.
	Shout(ctx context.Context, sev Severity, msg string)

	// Shoutf logs to the channel, and also to the real stderr if
	// logging is currently redirected to a file. Arguments are handled in
	// the manner of fmt.Printf.
	Shoutf(ctx context.Context, sev Severity, format string, args ...interface{})

	// VEvent either logs a message to the channel (which also outputs to the
	// active trace) or to the trace alone, depending on whether the specified
	// verbosity level is active.
	VEvent(ctx context.Context, level Level, msg string)

	// VEventf either logs a message to the channel (which also outputs to the
	// active trace) or to the trace alone, depending on whether the specified
	// verbosity level is active.
	VEventf(ctx context.Context, level Level, format string, args ...interface{})

	// VEventfDepth performs the same as VEventf but checks the verbosity level
	// at the given depth in the call stack.
	VEventfDepth(ctx context.Context, depth int, level Level, format string, args ...interface{})
}

// loggerDev is the logger type for the DEV channel.
type loggerDev struct{}

// Dev is a logger that logs to the DEV channel.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
var Dev loggerDev

// Dev and loggerDev implement ChannelLogger.
//
// We do not force use of ChannelLogger when instantiating the logger
// object above (e.g. by giving it the interface type), to ensure
// the calls to the API methods remain inlinable in the common case.
var _ ChannelLogger = Dev

// Infof logs to the DEV channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerDev) Infof(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.INFO, channel.DEV, format, args...)
}

// VInfof logs to the DEV channel with severity INFO,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerDev) VInfof(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.INFO, channel.DEV, format, args...)
	}
}

// Info logs to the DEV channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerDev) Info(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.INFO, channel.DEV, msg)
}

// InfofDepth logs to the DEV channel with severity INFO,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerDev) InfofDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.INFO, channel.DEV, format, args...)
}

// Infof logs to the DEV channel with severity INFO,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `INFO` severity is used for informational messages that do not
// require action.
func Infof(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.INFO, channel.DEV, format, args...)
}

// VInfof logs to the DEV channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `INFO` severity is used for informational messages that do not
// require action.
func VInfof(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.INFO, channel.DEV, format, args...)
	}
}

// Info logs to the DEV channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `INFO` severity is used for informational messages that do not
// require action.
func Info(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.INFO, channel.DEV, msg)
}

// InfofDepth logs to the DEV channel with severity INFO,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `INFO` severity is used for informational messages that do not
// require action.
func InfofDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.INFO, channel.DEV, format, args...)
}

// Warningf logs to the DEV channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerDev) Warningf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.WARNING, channel.DEV, format, args...)
}

// VWarningf logs to the DEV channel with severity WARNING,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerDev) VWarningf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.WARNING, channel.DEV, format, args...)
	}
}

// Warning logs to the DEV channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerDev) Warning(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.WARNING, channel.DEV, msg)
}

// WarningfDepth logs to the DEV channel with severity WARNING,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerDev) WarningfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.WARNING, channel.DEV, format, args...)
}

// Warningf logs to the DEV channel with severity WARNING,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func Warningf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.WARNING, channel.DEV, format, args...)
}

// VWarningf logs to the DEV channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func VWarningf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.WARNING, channel.DEV, format, args...)
	}
}

// Warning logs to the DEV channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func Warning(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.WARNING, channel.DEV, msg)
}

// WarningfDepth logs to the DEV channel with severity WARNING,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func WarningfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.WARNING, channel.DEV, format, args...)
}

// Errorf logs to the DEV channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerDev) Errorf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.ERROR, channel.DEV, format, args...)
}

// VErrorf logs to the DEV channel with severity ERROR,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerDev) VErrorf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.ERROR, channel.DEV, format, args...)
	}
}

// Error logs to the DEV channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerDev) Error(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.ERROR, channel.DEV, msg)
}

// ErrorfDepth logs to the DEV channel with severity ERROR,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerDev) ErrorfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.ERROR, channel.DEV, format, args...)
}

// Errorf logs to the DEV channel with severity ERROR,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func Errorf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.ERROR, channel.DEV, format, args...)
}

// VErrorf logs to the DEV channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func VErrorf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.ERROR, channel.DEV, format, args...)
	}
}

// Error logs to the DEV channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func Error(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.ERROR, channel.DEV, msg)
}

// ErrorfDepth logs to the DEV channel with severity ERROR,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func ErrorfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.ERROR, channel.DEV, format, args...)
}

// Fatalf logs to the DEV channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerDev) Fatalf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.FATAL, channel.DEV, format, args...)
}

// VFatalf logs to the DEV channel with severity FATAL,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerDev) VFatalf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.FATAL, channel.DEV, format, args...)
	}
}

// Fatal logs to the DEV channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerDev) Fatal(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.FATAL, channel.DEV, msg)
}

// FatalfDepth logs to the DEV channel with severity FATAL,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerDev) FatalfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.FATAL, channel.DEV, format, args...)
}

// Fatalf logs to the DEV channel with severity FATAL,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func Fatalf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.FATAL, channel.DEV, format, args...)
}

// VFatalf logs to the DEV channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func VFatalf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.FATAL, channel.DEV, format, args...)
	}
}

// Fatal logs to the DEV channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func Fatal(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.FATAL, channel.DEV, msg)
}

// FatalfDepth logs to the DEV channel with severity FATAL,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func FatalfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.FATAL, channel.DEV, format, args...)
}

// Shout logs to channel DEV, and also to the real stderr if logging
// is currently redirected to a file.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
func (loggerDev) Shout(ctx context.Context, sev Severity, msg string) {
	shoutfDepth(ctx, 1, sev, channel.DEV, msg)
}

// Shoutf logs to channel DEV, and also to the real stderr if
// logging is currently redirected to a file. Arguments are handled in
// the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
func (loggerDev) Shoutf(ctx context.Context, sev Severity, format string, args ...interface{}) {
	shoutfDepth(ctx, 1, sev, channel.DEV, format, args...)
}

// VEvent either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
func (loggerDev) VEvent(ctx context.Context, level Level, msg string) {
	vEvent(ctx, false /* isErr */, 1, level, channel.DEV, msg)
}

// VEventf either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
func (loggerDev) VEventf(ctx context.Context, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1, level, channel.DEV, format, args...)
}

// VEventfDepth performs the same as VEventf but checks the verbosity level
// at the given depth in the call stack.
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
func (loggerDev) VEventfDepth(ctx context.Context, depth int, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1+depth, level, channel.DEV, format, args...)
}

// Shout logs to channel DEV, and also to the real stderr if logging
// is currently redirected to a file.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
func Shout(ctx context.Context, sev Severity, msg string) {
	shoutfDepth(ctx, 1, sev, channel.DEV, msg)
}

// Shoutf logs to channel DEV, and also to the real stderr if
// logging is currently redirected to a file. Arguments are handled in
// the manner of fmt.Printf.
//
// The `DEV` channel is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
func Shoutf(ctx context.Context, sev Severity, format string, args ...interface{}) {
	shoutfDepth(ctx, 1, sev, channel.DEV, format, args...)
}

// loggerOps is the logger type for the OPS channel.
type loggerOps struct{}

// Ops is a logger that logs to the OPS channel.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
var Ops loggerOps

// Ops and loggerOps implement ChannelLogger.
//
// We do not force use of ChannelLogger when instantiating the logger
// object above (e.g. by giving it the interface type), to ensure
// the calls to the API methods remain inlinable in the common case.
var _ ChannelLogger = Ops

// Infof logs to the OPS channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerOps) Infof(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.INFO, channel.OPS, format, args...)
}

// VInfof logs to the OPS channel with severity INFO,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerOps) VInfof(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.INFO, channel.OPS, format, args...)
	}
}

// Info logs to the OPS channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerOps) Info(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.INFO, channel.OPS, msg)
}

// InfofDepth logs to the OPS channel with severity INFO,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerOps) InfofDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.INFO, channel.OPS, format, args...)
}

// Warningf logs to the OPS channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerOps) Warningf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.WARNING, channel.OPS, format, args...)
}

// VWarningf logs to the OPS channel with severity WARNING,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerOps) VWarningf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.WARNING, channel.OPS, format, args...)
	}
}

// Warning logs to the OPS channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerOps) Warning(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.WARNING, channel.OPS, msg)
}

// WarningfDepth logs to the OPS channel with severity WARNING,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerOps) WarningfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.WARNING, channel.OPS, format, args...)
}

// Errorf logs to the OPS channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerOps) Errorf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.ERROR, channel.OPS, format, args...)
}

// VErrorf logs to the OPS channel with severity ERROR,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerOps) VErrorf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.ERROR, channel.OPS, format, args...)
	}
}

// Error logs to the OPS channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerOps) Error(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.ERROR, channel.OPS, msg)
}

// ErrorfDepth logs to the OPS channel with severity ERROR,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerOps) ErrorfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.ERROR, channel.OPS, format, args...)
}

// Fatalf logs to the OPS channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerOps) Fatalf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.FATAL, channel.OPS, format, args...)
}

// VFatalf logs to the OPS channel with severity FATAL,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerOps) VFatalf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.FATAL, channel.OPS, format, args...)
	}
}

// Fatal logs to the OPS channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerOps) Fatal(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.FATAL, channel.OPS, msg)
}

// FatalfDepth logs to the OPS channel with severity FATAL,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerOps) FatalfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.FATAL, channel.OPS, format, args...)
}

// Shout logs to channel OPS, and also to the real stderr if logging
// is currently redirected to a file.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
func (loggerOps) Shout(ctx context.Context, sev Severity, msg string) {
	shoutfDepth(ctx, 1, sev, channel.OPS, msg)
}

// Shoutf logs to channel OPS, and also to the real stderr if
// logging is currently redirected to a file. Arguments are handled in
// the manner of fmt.Printf.
//
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
func (loggerOps) Shoutf(ctx context.Context, sev Severity, format string, args ...interface{}) {
	shoutfDepth(ctx, 1, sev, channel.OPS, format, args...)
}

// VEvent either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
func (loggerOps) VEvent(ctx context.Context, level Level, msg string) {
	vEvent(ctx, false /* isErr */, 1, level, channel.OPS, msg)
}

// VEventf either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
func (loggerOps) VEventf(ctx context.Context, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1, level, channel.OPS, format, args...)
}

// VEventfDepth performs the same as VEventf but checks the verbosity level
// at the given depth in the call stack.
// The `OPS` channel is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
func (loggerOps) VEventfDepth(ctx context.Context, depth int, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1+depth, level, channel.OPS, format, args...)
}

// loggerHealth is the logger type for the HEALTH channel.
type loggerHealth struct{}

// Health is a logger that logs to the HEALTH channel.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
var Health loggerHealth

// Health and loggerHealth implement ChannelLogger.
//
// We do not force use of ChannelLogger when instantiating the logger
// object above (e.g. by giving it the interface type), to ensure
// the calls to the API methods remain inlinable in the common case.
var _ ChannelLogger = Health

// Infof logs to the HEALTH channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerHealth) Infof(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.INFO, channel.HEALTH, format, args...)
}

// VInfof logs to the HEALTH channel with severity INFO,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerHealth) VInfof(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.INFO, channel.HEALTH, format, args...)
	}
}

// Info logs to the HEALTH channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerHealth) Info(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.INFO, channel.HEALTH, msg)
}

// InfofDepth logs to the HEALTH channel with severity INFO,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerHealth) InfofDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.INFO, channel.HEALTH, format, args...)
}

// Warningf logs to the HEALTH channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerHealth) Warningf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.WARNING, channel.HEALTH, format, args...)
}

// VWarningf logs to the HEALTH channel with severity WARNING,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerHealth) VWarningf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.WARNING, channel.HEALTH, format, args...)
	}
}

// Warning logs to the HEALTH channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerHealth) Warning(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.WARNING, channel.HEALTH, msg)
}

// WarningfDepth logs to the HEALTH channel with severity WARNING,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerHealth) WarningfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.WARNING, channel.HEALTH, format, args...)
}

// Errorf logs to the HEALTH channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerHealth) Errorf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.ERROR, channel.HEALTH, format, args...)
}

// VErrorf logs to the HEALTH channel with severity ERROR,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerHealth) VErrorf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.ERROR, channel.HEALTH, format, args...)
	}
}

// Error logs to the HEALTH channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerHealth) Error(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.ERROR, channel.HEALTH, msg)
}

// ErrorfDepth logs to the HEALTH channel with severity ERROR,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerHealth) ErrorfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.ERROR, channel.HEALTH, format, args...)
}

// Fatalf logs to the HEALTH channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerHealth) Fatalf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.FATAL, channel.HEALTH, format, args...)
}

// VFatalf logs to the HEALTH channel with severity FATAL,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerHealth) VFatalf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.FATAL, channel.HEALTH, format, args...)
	}
}

// Fatal logs to the HEALTH channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerHealth) Fatal(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.FATAL, channel.HEALTH, msg)
}

// FatalfDepth logs to the HEALTH channel with severity FATAL,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerHealth) FatalfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.FATAL, channel.HEALTH, format, args...)
}

// Shout logs to channel HEALTH, and also to the real stderr if logging
// is currently redirected to a file.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
func (loggerHealth) Shout(ctx context.Context, sev Severity, msg string) {
	shoutfDepth(ctx, 1, sev, channel.HEALTH, msg)
}

// Shoutf logs to channel HEALTH, and also to the real stderr if
// logging is currently redirected to a file. Arguments are handled in
// the manner of fmt.Printf.
//
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
func (loggerHealth) Shoutf(ctx context.Context, sev Severity, format string, args ...interface{}) {
	shoutfDepth(ctx, 1, sev, channel.HEALTH, format, args...)
}

// VEvent either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
func (loggerHealth) VEvent(ctx context.Context, level Level, msg string) {
	vEvent(ctx, false /* isErr */, 1, level, channel.HEALTH, msg)
}

// VEventf either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
func (loggerHealth) VEventf(ctx context.Context, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1, level, channel.HEALTH, format, args...)
}

// VEventfDepth performs the same as VEventf but checks the verbosity level
// at the given depth in the call stack.
// The `HEALTH` channel is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
func (loggerHealth) VEventfDepth(ctx context.Context, depth int, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1+depth, level, channel.HEALTH, format, args...)
}

// loggerStorage is the logger type for the STORAGE channel.
type loggerStorage struct{}

// Storage is a logger that logs to the STORAGE channel.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
var Storage loggerStorage

// Storage and loggerStorage implement ChannelLogger.
//
// We do not force use of ChannelLogger when instantiating the logger
// object above (e.g. by giving it the interface type), to ensure
// the calls to the API methods remain inlinable in the common case.
var _ ChannelLogger = Storage

// Infof logs to the STORAGE channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerStorage) Infof(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.INFO, channel.STORAGE, format, args...)
}

// VInfof logs to the STORAGE channel with severity INFO,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerStorage) VInfof(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.INFO, channel.STORAGE, format, args...)
	}
}

// Info logs to the STORAGE channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerStorage) Info(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.INFO, channel.STORAGE, msg)
}

// InfofDepth logs to the STORAGE channel with severity INFO,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerStorage) InfofDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.INFO, channel.STORAGE, format, args...)
}

// Warningf logs to the STORAGE channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerStorage) Warningf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.WARNING, channel.STORAGE, format, args...)
}

// VWarningf logs to the STORAGE channel with severity WARNING,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerStorage) VWarningf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.WARNING, channel.STORAGE, format, args...)
	}
}

// Warning logs to the STORAGE channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerStorage) Warning(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.WARNING, channel.STORAGE, msg)
}

// WarningfDepth logs to the STORAGE channel with severity WARNING,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerStorage) WarningfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.WARNING, channel.STORAGE, format, args...)
}

// Errorf logs to the STORAGE channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerStorage) Errorf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.ERROR, channel.STORAGE, format, args...)
}

// VErrorf logs to the STORAGE channel with severity ERROR,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerStorage) VErrorf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.ERROR, channel.STORAGE, format, args...)
	}
}

// Error logs to the STORAGE channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerStorage) Error(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.ERROR, channel.STORAGE, msg)
}

// ErrorfDepth logs to the STORAGE channel with severity ERROR,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerStorage) ErrorfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.ERROR, channel.STORAGE, format, args...)
}

// Fatalf logs to the STORAGE channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerStorage) Fatalf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.FATAL, channel.STORAGE, format, args...)
}

// VFatalf logs to the STORAGE channel with severity FATAL,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerStorage) VFatalf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.FATAL, channel.STORAGE, format, args...)
	}
}

// Fatal logs to the STORAGE channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerStorage) Fatal(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.FATAL, channel.STORAGE, msg)
}

// FatalfDepth logs to the STORAGE channel with severity FATAL,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerStorage) FatalfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.FATAL, channel.STORAGE, format, args...)
}

// Shout logs to channel STORAGE, and also to the real stderr if logging
// is currently redirected to a file.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
func (loggerStorage) Shout(ctx context.Context, sev Severity, msg string) {
	shoutfDepth(ctx, 1, sev, channel.STORAGE, msg)
}

// Shoutf logs to channel STORAGE, and also to the real stderr if
// logging is currently redirected to a file. Arguments are handled in
// the manner of fmt.Printf.
//
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
func (loggerStorage) Shoutf(ctx context.Context, sev Severity, format string, args ...interface{}) {
	shoutfDepth(ctx, 1, sev, channel.STORAGE, format, args...)
}

// VEvent either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
func (loggerStorage) VEvent(ctx context.Context, level Level, msg string) {
	vEvent(ctx, false /* isErr */, 1, level, channel.STORAGE, msg)
}

// VEventf either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
func (loggerStorage) VEventf(ctx context.Context, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1, level, channel.STORAGE, format, args...)
}

// VEventfDepth performs the same as VEventf but checks the verbosity level
// at the given depth in the call stack.
// The `STORAGE` channel is used to report low-level storage
// layer events (RocksDB/Pebble).
func (loggerStorage) VEventfDepth(ctx context.Context, depth int, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1+depth, level, channel.STORAGE, format, args...)
}

// loggerSessions is the logger type for the SESSIONS channel.
type loggerSessions struct{}

// Sessions is a logger that logs to the SESSIONS channel.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
var Sessions loggerSessions

// Sessions and loggerSessions implement ChannelLogger.
//
// We do not force use of ChannelLogger when instantiating the logger
// object above (e.g. by giving it the interface type), to ensure
// the calls to the API methods remain inlinable in the common case.
var _ ChannelLogger = Sessions

// Infof logs to the SESSIONS channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSessions) Infof(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.INFO, channel.SESSIONS, format, args...)
}

// VInfof logs to the SESSIONS channel with severity INFO,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSessions) VInfof(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.INFO, channel.SESSIONS, format, args...)
	}
}

// Info logs to the SESSIONS channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSessions) Info(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.INFO, channel.SESSIONS, msg)
}

// InfofDepth logs to the SESSIONS channel with severity INFO,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSessions) InfofDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.INFO, channel.SESSIONS, format, args...)
}

// Warningf logs to the SESSIONS channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSessions) Warningf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.WARNING, channel.SESSIONS, format, args...)
}

// VWarningf logs to the SESSIONS channel with severity WARNING,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSessions) VWarningf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.WARNING, channel.SESSIONS, format, args...)
	}
}

// Warning logs to the SESSIONS channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSessions) Warning(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.WARNING, channel.SESSIONS, msg)
}

// WarningfDepth logs to the SESSIONS channel with severity WARNING,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSessions) WarningfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.WARNING, channel.SESSIONS, format, args...)
}

// Errorf logs to the SESSIONS channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSessions) Errorf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.ERROR, channel.SESSIONS, format, args...)
}

// VErrorf logs to the SESSIONS channel with severity ERROR,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSessions) VErrorf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.ERROR, channel.SESSIONS, format, args...)
	}
}

// Error logs to the SESSIONS channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSessions) Error(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.ERROR, channel.SESSIONS, msg)
}

// ErrorfDepth logs to the SESSIONS channel with severity ERROR,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSessions) ErrorfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.ERROR, channel.SESSIONS, format, args...)
}

// Fatalf logs to the SESSIONS channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSessions) Fatalf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.FATAL, channel.SESSIONS, format, args...)
}

// VFatalf logs to the SESSIONS channel with severity FATAL,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSessions) VFatalf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.FATAL, channel.SESSIONS, format, args...)
	}
}

// Fatal logs to the SESSIONS channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSessions) Fatal(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.FATAL, channel.SESSIONS, msg)
}

// FatalfDepth logs to the SESSIONS channel with severity FATAL,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSessions) FatalfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.FATAL, channel.SESSIONS, format, args...)
}

// Shout logs to channel SESSIONS, and also to the real stderr if logging
// is currently redirected to a file.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerSessions) Shout(ctx context.Context, sev Severity, msg string) {
	shoutfDepth(ctx, 1, sev, channel.SESSIONS, msg)
}

// Shoutf logs to channel SESSIONS, and also to the real stderr if
// logging is currently redirected to a file. Arguments are handled in
// the manner of fmt.Printf.
//
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerSessions) Shoutf(ctx context.Context, sev Severity, format string, args ...interface{}) {
	shoutfDepth(ctx, 1, sev, channel.SESSIONS, format, args...)
}

// VEvent either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerSessions) VEvent(ctx context.Context, level Level, msg string) {
	vEvent(ctx, false /* isErr */, 1, level, channel.SESSIONS, msg)
}

// VEventf either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerSessions) VEventf(ctx context.Context, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1, level, channel.SESSIONS, format, args...)
}

// VEventfDepth performs the same as VEventf but checks the verbosity level
// at the given depth in the call stack.
// The `SESSIONS` channel is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerSessions) VEventfDepth(ctx context.Context, depth int, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1+depth, level, channel.SESSIONS, format, args...)
}

// loggerSqlSchema is the logger type for the SQL_SCHEMA channel.
type loggerSqlSchema struct{}

// SqlSchema is a logger that logs to the SQL_SCHEMA channel.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
var SqlSchema loggerSqlSchema

// SqlSchema and loggerSqlSchema implement ChannelLogger.
//
// We do not force use of ChannelLogger when instantiating the logger
// object above (e.g. by giving it the interface type), to ensure
// the calls to the API methods remain inlinable in the common case.
var _ ChannelLogger = SqlSchema

// Infof logs to the SQL_SCHEMA channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSqlSchema) Infof(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.INFO, channel.SQL_SCHEMA, format, args...)
}

// VInfof logs to the SQL_SCHEMA channel with severity INFO,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSqlSchema) VInfof(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.INFO, channel.SQL_SCHEMA, format, args...)
	}
}

// Info logs to the SQL_SCHEMA channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSqlSchema) Info(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.INFO, channel.SQL_SCHEMA, msg)
}

// InfofDepth logs to the SQL_SCHEMA channel with severity INFO,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSqlSchema) InfofDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.INFO, channel.SQL_SCHEMA, format, args...)
}

// Warningf logs to the SQL_SCHEMA channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSqlSchema) Warningf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.WARNING, channel.SQL_SCHEMA, format, args...)
}

// VWarningf logs to the SQL_SCHEMA channel with severity WARNING,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSqlSchema) VWarningf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.WARNING, channel.SQL_SCHEMA, format, args...)
	}
}

// Warning logs to the SQL_SCHEMA channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSqlSchema) Warning(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.WARNING, channel.SQL_SCHEMA, msg)
}

// WarningfDepth logs to the SQL_SCHEMA channel with severity WARNING,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSqlSchema) WarningfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.WARNING, channel.SQL_SCHEMA, format, args...)
}

// Errorf logs to the SQL_SCHEMA channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSqlSchema) Errorf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.ERROR, channel.SQL_SCHEMA, format, args...)
}

// VErrorf logs to the SQL_SCHEMA channel with severity ERROR,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSqlSchema) VErrorf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.ERROR, channel.SQL_SCHEMA, format, args...)
	}
}

// Error logs to the SQL_SCHEMA channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSqlSchema) Error(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.ERROR, channel.SQL_SCHEMA, msg)
}

// ErrorfDepth logs to the SQL_SCHEMA channel with severity ERROR,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSqlSchema) ErrorfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.ERROR, channel.SQL_SCHEMA, format, args...)
}

// Fatalf logs to the SQL_SCHEMA channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSqlSchema) Fatalf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.FATAL, channel.SQL_SCHEMA, format, args...)
}

// VFatalf logs to the SQL_SCHEMA channel with severity FATAL,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSqlSchema) VFatalf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.FATAL, channel.SQL_SCHEMA, format, args...)
	}
}

// Fatal logs to the SQL_SCHEMA channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSqlSchema) Fatal(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.FATAL, channel.SQL_SCHEMA, msg)
}

// FatalfDepth logs to the SQL_SCHEMA channel with severity FATAL,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSqlSchema) FatalfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.FATAL, channel.SQL_SCHEMA, format, args...)
}

// Shout logs to channel SQL_SCHEMA, and also to the real stderr if logging
// is currently redirected to a file.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
func (loggerSqlSchema) Shout(ctx context.Context, sev Severity, msg string) {
	shoutfDepth(ctx, 1, sev, channel.SQL_SCHEMA, msg)
}

// Shoutf logs to channel SQL_SCHEMA, and also to the real stderr if
// logging is currently redirected to a file. Arguments are handled in
// the manner of fmt.Printf.
//
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
func (loggerSqlSchema) Shoutf(ctx context.Context, sev Severity, format string, args ...interface{}) {
	shoutfDepth(ctx, 1, sev, channel.SQL_SCHEMA, format, args...)
}

// VEvent either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
func (loggerSqlSchema) VEvent(ctx context.Context, level Level, msg string) {
	vEvent(ctx, false /* isErr */, 1, level, channel.SQL_SCHEMA, msg)
}

// VEventf either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
func (loggerSqlSchema) VEventf(ctx context.Context, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1, level, channel.SQL_SCHEMA, format, args...)
}

// VEventfDepth performs the same as VEventf but checks the verbosity level
// at the given depth in the call stack.
// The `SQL_SCHEMA` channel is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
func (loggerSqlSchema) VEventfDepth(ctx context.Context, depth int, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1+depth, level, channel.SQL_SCHEMA, format, args...)
}

// loggerUserAdmin is the logger type for the USER_ADMIN channel.
type loggerUserAdmin struct{}

// UserAdmin is a logger that logs to the USER_ADMIN channel.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
var UserAdmin loggerUserAdmin

// UserAdmin and loggerUserAdmin implement ChannelLogger.
//
// We do not force use of ChannelLogger when instantiating the logger
// object above (e.g. by giving it the interface type), to ensure
// the calls to the API methods remain inlinable in the common case.
var _ ChannelLogger = UserAdmin

// Infof logs to the USER_ADMIN channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerUserAdmin) Infof(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.INFO, channel.USER_ADMIN, format, args...)
}

// VInfof logs to the USER_ADMIN channel with severity INFO,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerUserAdmin) VInfof(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.INFO, channel.USER_ADMIN, format, args...)
	}
}

// Info logs to the USER_ADMIN channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerUserAdmin) Info(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.INFO, channel.USER_ADMIN, msg)
}

// InfofDepth logs to the USER_ADMIN channel with severity INFO,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerUserAdmin) InfofDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.INFO, channel.USER_ADMIN, format, args...)
}

// Warningf logs to the USER_ADMIN channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerUserAdmin) Warningf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.WARNING, channel.USER_ADMIN, format, args...)
}

// VWarningf logs to the USER_ADMIN channel with severity WARNING,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerUserAdmin) VWarningf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.WARNING, channel.USER_ADMIN, format, args...)
	}
}

// Warning logs to the USER_ADMIN channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerUserAdmin) Warning(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.WARNING, channel.USER_ADMIN, msg)
}

// WarningfDepth logs to the USER_ADMIN channel with severity WARNING,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerUserAdmin) WarningfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.WARNING, channel.USER_ADMIN, format, args...)
}

// Errorf logs to the USER_ADMIN channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerUserAdmin) Errorf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.ERROR, channel.USER_ADMIN, format, args...)
}

// VErrorf logs to the USER_ADMIN channel with severity ERROR,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerUserAdmin) VErrorf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.ERROR, channel.USER_ADMIN, format, args...)
	}
}

// Error logs to the USER_ADMIN channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerUserAdmin) Error(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.ERROR, channel.USER_ADMIN, msg)
}

// ErrorfDepth logs to the USER_ADMIN channel with severity ERROR,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerUserAdmin) ErrorfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.ERROR, channel.USER_ADMIN, format, args...)
}

// Fatalf logs to the USER_ADMIN channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerUserAdmin) Fatalf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.FATAL, channel.USER_ADMIN, format, args...)
}

// VFatalf logs to the USER_ADMIN channel with severity FATAL,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerUserAdmin) VFatalf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.FATAL, channel.USER_ADMIN, format, args...)
	}
}

// Fatal logs to the USER_ADMIN channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerUserAdmin) Fatal(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.FATAL, channel.USER_ADMIN, msg)
}

// FatalfDepth logs to the USER_ADMIN channel with severity FATAL,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerUserAdmin) FatalfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.FATAL, channel.USER_ADMIN, format, args...)
}

// Shout logs to channel USER_ADMIN, and also to the real stderr if logging
// is currently redirected to a file.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerUserAdmin) Shout(ctx context.Context, sev Severity, msg string) {
	shoutfDepth(ctx, 1, sev, channel.USER_ADMIN, msg)
}

// Shoutf logs to channel USER_ADMIN, and also to the real stderr if
// logging is currently redirected to a file. Arguments are handled in
// the manner of fmt.Printf.
//
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerUserAdmin) Shoutf(ctx context.Context, sev Severity, format string, args ...interface{}) {
	shoutfDepth(ctx, 1, sev, channel.USER_ADMIN, format, args...)
}

// VEvent either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerUserAdmin) VEvent(ctx context.Context, level Level, msg string) {
	vEvent(ctx, false /* isErr */, 1, level, channel.USER_ADMIN, msg)
}

// VEventf either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerUserAdmin) VEventf(ctx context.Context, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1, level, channel.USER_ADMIN, format, args...)
}

// VEventfDepth performs the same as VEventf but checks the verbosity level
// at the given depth in the call stack.
// The `USER_ADMIN` channel is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerUserAdmin) VEventfDepth(ctx context.Context, depth int, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1+depth, level, channel.USER_ADMIN, format, args...)
}

// loggerPrivileges is the logger type for the PRIVILEGES channel.
type loggerPrivileges struct{}

// Privileges is a logger that logs to the PRIVILEGES channel.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
var Privileges loggerPrivileges

// Privileges and loggerPrivileges implement ChannelLogger.
//
// We do not force use of ChannelLogger when instantiating the logger
// object above (e.g. by giving it the interface type), to ensure
// the calls to the API methods remain inlinable in the common case.
var _ ChannelLogger = Privileges

// Infof logs to the PRIVILEGES channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerPrivileges) Infof(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.INFO, channel.PRIVILEGES, format, args...)
}

// VInfof logs to the PRIVILEGES channel with severity INFO,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerPrivileges) VInfof(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.INFO, channel.PRIVILEGES, format, args...)
	}
}

// Info logs to the PRIVILEGES channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerPrivileges) Info(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.INFO, channel.PRIVILEGES, msg)
}

// InfofDepth logs to the PRIVILEGES channel with severity INFO,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerPrivileges) InfofDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.INFO, channel.PRIVILEGES, format, args...)
}

// Warningf logs to the PRIVILEGES channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerPrivileges) Warningf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.WARNING, channel.PRIVILEGES, format, args...)
}

// VWarningf logs to the PRIVILEGES channel with severity WARNING,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerPrivileges) VWarningf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.WARNING, channel.PRIVILEGES, format, args...)
	}
}

// Warning logs to the PRIVILEGES channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerPrivileges) Warning(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.WARNING, channel.PRIVILEGES, msg)
}

// WarningfDepth logs to the PRIVILEGES channel with severity WARNING,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerPrivileges) WarningfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.WARNING, channel.PRIVILEGES, format, args...)
}

// Errorf logs to the PRIVILEGES channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerPrivileges) Errorf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.ERROR, channel.PRIVILEGES, format, args...)
}

// VErrorf logs to the PRIVILEGES channel with severity ERROR,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerPrivileges) VErrorf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.ERROR, channel.PRIVILEGES, format, args...)
	}
}

// Error logs to the PRIVILEGES channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerPrivileges) Error(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.ERROR, channel.PRIVILEGES, msg)
}

// ErrorfDepth logs to the PRIVILEGES channel with severity ERROR,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerPrivileges) ErrorfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.ERROR, channel.PRIVILEGES, format, args...)
}

// Fatalf logs to the PRIVILEGES channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerPrivileges) Fatalf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.FATAL, channel.PRIVILEGES, format, args...)
}

// VFatalf logs to the PRIVILEGES channel with severity FATAL,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerPrivileges) VFatalf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.FATAL, channel.PRIVILEGES, format, args...)
	}
}

// Fatal logs to the PRIVILEGES channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerPrivileges) Fatal(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.FATAL, channel.PRIVILEGES, msg)
}

// FatalfDepth logs to the PRIVILEGES channel with severity FATAL,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerPrivileges) FatalfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.FATAL, channel.PRIVILEGES, format, args...)
}

// Shout logs to channel PRIVILEGES, and also to the real stderr if logging
// is currently redirected to a file.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerPrivileges) Shout(ctx context.Context, sev Severity, msg string) {
	shoutfDepth(ctx, 1, sev, channel.PRIVILEGES, msg)
}

// Shoutf logs to channel PRIVILEGES, and also to the real stderr if
// logging is currently redirected to a file. Arguments are handled in
// the manner of fmt.Printf.
//
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerPrivileges) Shoutf(ctx context.Context, sev Severity, format string, args ...interface{}) {
	shoutfDepth(ctx, 1, sev, channel.PRIVILEGES, format, args...)
}

// VEvent either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerPrivileges) VEvent(ctx context.Context, level Level, msg string) {
	vEvent(ctx, false /* isErr */, 1, level, channel.PRIVILEGES, msg)
}

// VEventf either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerPrivileges) VEventf(ctx context.Context, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1, level, channel.PRIVILEGES, format, args...)
}

// VEventfDepth performs the same as VEventf but checks the verbosity level
// at the given depth in the call stack.
// The `PRIVILEGES` channel is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerPrivileges) VEventfDepth(ctx context.Context, depth int, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1+depth, level, channel.PRIVILEGES, format, args...)
}

// loggerSensitiveAccess is the logger type for the SENSITIVE_ACCESS channel.
type loggerSensitiveAccess struct{}

// SensitiveAccess is a logger that logs to the SENSITIVE_ACCESS channel.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
var SensitiveAccess loggerSensitiveAccess

// SensitiveAccess and loggerSensitiveAccess implement ChannelLogger.
//
// We do not force use of ChannelLogger when instantiating the logger
// object above (e.g. by giving it the interface type), to ensure
// the calls to the API methods remain inlinable in the common case.
var _ ChannelLogger = SensitiveAccess

// Infof logs to the SENSITIVE_ACCESS channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSensitiveAccess) Infof(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.INFO, channel.SENSITIVE_ACCESS, format, args...)
}

// VInfof logs to the SENSITIVE_ACCESS channel with severity INFO,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSensitiveAccess) VInfof(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.INFO, channel.SENSITIVE_ACCESS, format, args...)
	}
}

// Info logs to the SENSITIVE_ACCESS channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSensitiveAccess) Info(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.INFO, channel.SENSITIVE_ACCESS, msg)
}

// InfofDepth logs to the SENSITIVE_ACCESS channel with severity INFO,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSensitiveAccess) InfofDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.INFO, channel.SENSITIVE_ACCESS, format, args...)
}

// Warningf logs to the SENSITIVE_ACCESS channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSensitiveAccess) Warningf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.WARNING, channel.SENSITIVE_ACCESS, format, args...)
}

// VWarningf logs to the SENSITIVE_ACCESS channel with severity WARNING,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSensitiveAccess) VWarningf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.WARNING, channel.SENSITIVE_ACCESS, format, args...)
	}
}

// Warning logs to the SENSITIVE_ACCESS channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSensitiveAccess) Warning(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.WARNING, channel.SENSITIVE_ACCESS, msg)
}

// WarningfDepth logs to the SENSITIVE_ACCESS channel with severity WARNING,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSensitiveAccess) WarningfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.WARNING, channel.SENSITIVE_ACCESS, format, args...)
}

// Errorf logs to the SENSITIVE_ACCESS channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSensitiveAccess) Errorf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.ERROR, channel.SENSITIVE_ACCESS, format, args...)
}

// VErrorf logs to the SENSITIVE_ACCESS channel with severity ERROR,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSensitiveAccess) VErrorf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.ERROR, channel.SENSITIVE_ACCESS, format, args...)
	}
}

// Error logs to the SENSITIVE_ACCESS channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSensitiveAccess) Error(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.ERROR, channel.SENSITIVE_ACCESS, msg)
}

// ErrorfDepth logs to the SENSITIVE_ACCESS channel with severity ERROR,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSensitiveAccess) ErrorfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.ERROR, channel.SENSITIVE_ACCESS, format, args...)
}

// Fatalf logs to the SENSITIVE_ACCESS channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSensitiveAccess) Fatalf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.FATAL, channel.SENSITIVE_ACCESS, format, args...)
}

// VFatalf logs to the SENSITIVE_ACCESS channel with severity FATAL,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSensitiveAccess) VFatalf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.FATAL, channel.SENSITIVE_ACCESS, format, args...)
	}
}

// Fatal logs to the SENSITIVE_ACCESS channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSensitiveAccess) Fatal(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.FATAL, channel.SENSITIVE_ACCESS, msg)
}

// FatalfDepth logs to the SENSITIVE_ACCESS channel with severity FATAL,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSensitiveAccess) FatalfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.FATAL, channel.SENSITIVE_ACCESS, format, args...)
}

// Shout logs to channel SENSITIVE_ACCESS, and also to the real stderr if logging
// is currently redirected to a file.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerSensitiveAccess) Shout(ctx context.Context, sev Severity, msg string) {
	shoutfDepth(ctx, 1, sev, channel.SENSITIVE_ACCESS, msg)
}

// Shoutf logs to channel SENSITIVE_ACCESS, and also to the real stderr if
// logging is currently redirected to a file. Arguments are handled in
// the manner of fmt.Printf.
//
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerSensitiveAccess) Shoutf(ctx context.Context, sev Severity, format string, args ...interface{}) {
	shoutfDepth(ctx, 1, sev, channel.SENSITIVE_ACCESS, format, args...)
}

// VEvent either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerSensitiveAccess) VEvent(ctx context.Context, level Level, msg string) {
	vEvent(ctx, false /* isErr */, 1, level, channel.SENSITIVE_ACCESS, msg)
}

// VEventf either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerSensitiveAccess) VEventf(ctx context.Context, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1, level, channel.SENSITIVE_ACCESS, format, args...)
}

// VEventfDepth performs the same as VEventf but checks the verbosity level
// at the given depth in the call stack.
// The `SENSITIVE_ACCESS` channel is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
func (loggerSensitiveAccess) VEventfDepth(ctx context.Context, depth int, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1+depth, level, channel.SENSITIVE_ACCESS, format, args...)
}

// loggerSqlExec is the logger type for the SQL_EXEC channel.
type loggerSqlExec struct{}

// SqlExec is a logger that logs to the SQL_EXEC channel.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
var SqlExec loggerSqlExec

// SqlExec and loggerSqlExec implement ChannelLogger.
//
// We do not force use of ChannelLogger when instantiating the logger
// object above (e.g. by giving it the interface type), to ensure
// the calls to the API methods remain inlinable in the common case.
var _ ChannelLogger = SqlExec

// Infof logs to the SQL_EXEC channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSqlExec) Infof(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.INFO, channel.SQL_EXEC, format, args...)
}

// VInfof logs to the SQL_EXEC channel with severity INFO,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSqlExec) VInfof(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.INFO, channel.SQL_EXEC, format, args...)
	}
}

// Info logs to the SQL_EXEC channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSqlExec) Info(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.INFO, channel.SQL_EXEC, msg)
}

// InfofDepth logs to the SQL_EXEC channel with severity INFO,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSqlExec) InfofDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.INFO, channel.SQL_EXEC, format, args...)
}

// Warningf logs to the SQL_EXEC channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSqlExec) Warningf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.WARNING, channel.SQL_EXEC, format, args...)
}

// VWarningf logs to the SQL_EXEC channel with severity WARNING,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSqlExec) VWarningf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.WARNING, channel.SQL_EXEC, format, args...)
	}
}

// Warning logs to the SQL_EXEC channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSqlExec) Warning(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.WARNING, channel.SQL_EXEC, msg)
}

// WarningfDepth logs to the SQL_EXEC channel with severity WARNING,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSqlExec) WarningfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.WARNING, channel.SQL_EXEC, format, args...)
}

// Errorf logs to the SQL_EXEC channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSqlExec) Errorf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.ERROR, channel.SQL_EXEC, format, args...)
}

// VErrorf logs to the SQL_EXEC channel with severity ERROR,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSqlExec) VErrorf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.ERROR, channel.SQL_EXEC, format, args...)
	}
}

// Error logs to the SQL_EXEC channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSqlExec) Error(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.ERROR, channel.SQL_EXEC, msg)
}

// ErrorfDepth logs to the SQL_EXEC channel with severity ERROR,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSqlExec) ErrorfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.ERROR, channel.SQL_EXEC, format, args...)
}

// Fatalf logs to the SQL_EXEC channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSqlExec) Fatalf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.FATAL, channel.SQL_EXEC, format, args...)
}

// VFatalf logs to the SQL_EXEC channel with severity FATAL,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSqlExec) VFatalf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.FATAL, channel.SQL_EXEC, format, args...)
	}
}

// Fatal logs to the SQL_EXEC channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSqlExec) Fatal(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.FATAL, channel.SQL_EXEC, msg)
}

// FatalfDepth logs to the SQL_EXEC channel with severity FATAL,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSqlExec) FatalfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.FATAL, channel.SQL_EXEC, format, args...)
}

// Shout logs to channel SQL_EXEC, and also to the real stderr if logging
// is currently redirected to a file.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
func (loggerSqlExec) Shout(ctx context.Context, sev Severity, msg string) {
	shoutfDepth(ctx, 1, sev, channel.SQL_EXEC, msg)
}

// Shoutf logs to channel SQL_EXEC, and also to the real stderr if
// logging is currently redirected to a file. Arguments are handled in
// the manner of fmt.Printf.
//
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
func (loggerSqlExec) Shoutf(ctx context.Context, sev Severity, format string, args ...interface{}) {
	shoutfDepth(ctx, 1, sev, channel.SQL_EXEC, format, args...)
}

// VEvent either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
func (loggerSqlExec) VEvent(ctx context.Context, level Level, msg string) {
	vEvent(ctx, false /* isErr */, 1, level, channel.SQL_EXEC, msg)
}

// VEventf either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
func (loggerSqlExec) VEventf(ctx context.Context, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1, level, channel.SQL_EXEC, format, args...)
}

// VEventfDepth performs the same as VEventf but checks the verbosity level
// at the given depth in the call stack.
// The `SQL_EXEC` channel is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
func (loggerSqlExec) VEventfDepth(ctx context.Context, depth int, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1+depth, level, channel.SQL_EXEC, format, args...)
}

// loggerSqlPerf is the logger type for the SQL_PERF channel.
type loggerSqlPerf struct{}

// SqlPerf is a logger that logs to the SQL_PERF channel.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
var SqlPerf loggerSqlPerf

// SqlPerf and loggerSqlPerf implement ChannelLogger.
//
// We do not force use of ChannelLogger when instantiating the logger
// object above (e.g. by giving it the interface type), to ensure
// the calls to the API methods remain inlinable in the common case.
var _ ChannelLogger = SqlPerf

// Infof logs to the SQL_PERF channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSqlPerf) Infof(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.INFO, channel.SQL_PERF, format, args...)
}

// VInfof logs to the SQL_PERF channel with severity INFO,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSqlPerf) VInfof(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.INFO, channel.SQL_PERF, format, args...)
	}
}

// Info logs to the SQL_PERF channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSqlPerf) Info(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.INFO, channel.SQL_PERF, msg)
}

// InfofDepth logs to the SQL_PERF channel with severity INFO,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSqlPerf) InfofDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.INFO, channel.SQL_PERF, format, args...)
}

// Warningf logs to the SQL_PERF channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSqlPerf) Warningf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.WARNING, channel.SQL_PERF, format, args...)
}

// VWarningf logs to the SQL_PERF channel with severity WARNING,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSqlPerf) VWarningf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.WARNING, channel.SQL_PERF, format, args...)
	}
}

// Warning logs to the SQL_PERF channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSqlPerf) Warning(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.WARNING, channel.SQL_PERF, msg)
}

// WarningfDepth logs to the SQL_PERF channel with severity WARNING,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSqlPerf) WarningfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.WARNING, channel.SQL_PERF, format, args...)
}

// Errorf logs to the SQL_PERF channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSqlPerf) Errorf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.ERROR, channel.SQL_PERF, format, args...)
}

// VErrorf logs to the SQL_PERF channel with severity ERROR,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSqlPerf) VErrorf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.ERROR, channel.SQL_PERF, format, args...)
	}
}

// Error logs to the SQL_PERF channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSqlPerf) Error(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.ERROR, channel.SQL_PERF, msg)
}

// ErrorfDepth logs to the SQL_PERF channel with severity ERROR,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSqlPerf) ErrorfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.ERROR, channel.SQL_PERF, format, args...)
}

// Fatalf logs to the SQL_PERF channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSqlPerf) Fatalf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.FATAL, channel.SQL_PERF, format, args...)
}

// VFatalf logs to the SQL_PERF channel with severity FATAL,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSqlPerf) VFatalf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.FATAL, channel.SQL_PERF, format, args...)
	}
}

// Fatal logs to the SQL_PERF channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSqlPerf) Fatal(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.FATAL, channel.SQL_PERF, msg)
}

// FatalfDepth logs to the SQL_PERF channel with severity FATAL,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSqlPerf) FatalfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.FATAL, channel.SQL_PERF, format, args...)
}

// Shout logs to channel SQL_PERF, and also to the real stderr if logging
// is currently redirected to a file.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
func (loggerSqlPerf) Shout(ctx context.Context, sev Severity, msg string) {
	shoutfDepth(ctx, 1, sev, channel.SQL_PERF, msg)
}

// Shoutf logs to channel SQL_PERF, and also to the real stderr if
// logging is currently redirected to a file. Arguments are handled in
// the manner of fmt.Printf.
//
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
func (loggerSqlPerf) Shoutf(ctx context.Context, sev Severity, format string, args ...interface{}) {
	shoutfDepth(ctx, 1, sev, channel.SQL_PERF, format, args...)
}

// VEvent either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
func (loggerSqlPerf) VEvent(ctx context.Context, level Level, msg string) {
	vEvent(ctx, false /* isErr */, 1, level, channel.SQL_PERF, msg)
}

// VEventf either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
func (loggerSqlPerf) VEventf(ctx context.Context, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1, level, channel.SQL_PERF, format, args...)
}

// VEventfDepth performs the same as VEventf but checks the verbosity level
// at the given depth in the call stack.
// The `SQL_PERF` channel is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
func (loggerSqlPerf) VEventfDepth(ctx context.Context, depth int, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1+depth, level, channel.SQL_PERF, format, args...)
}

// loggerSqlInternalPerf is the logger type for the SQL_INTERNAL_PERF channel.
type loggerSqlInternalPerf struct{}

// SqlInternalPerf is a logger that logs to the SQL_INTERNAL_PERF channel.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
var SqlInternalPerf loggerSqlInternalPerf

// SqlInternalPerf and loggerSqlInternalPerf implement ChannelLogger.
//
// We do not force use of ChannelLogger when instantiating the logger
// object above (e.g. by giving it the interface type), to ensure
// the calls to the API methods remain inlinable in the common case.
var _ ChannelLogger = SqlInternalPerf

// Infof logs to the SQL_INTERNAL_PERF channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSqlInternalPerf) Infof(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.INFO, channel.SQL_INTERNAL_PERF, format, args...)
}

// VInfof logs to the SQL_INTERNAL_PERF channel with severity INFO,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSqlInternalPerf) VInfof(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.INFO, channel.SQL_INTERNAL_PERF, format, args...)
	}
}

// Info logs to the SQL_INTERNAL_PERF channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSqlInternalPerf) Info(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.INFO, channel.SQL_INTERNAL_PERF, msg)
}

// InfofDepth logs to the SQL_INTERNAL_PERF channel with severity INFO,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerSqlInternalPerf) InfofDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.INFO, channel.SQL_INTERNAL_PERF, format, args...)
}

// Warningf logs to the SQL_INTERNAL_PERF channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSqlInternalPerf) Warningf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.WARNING, channel.SQL_INTERNAL_PERF, format, args...)
}

// VWarningf logs to the SQL_INTERNAL_PERF channel with severity WARNING,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSqlInternalPerf) VWarningf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.WARNING, channel.SQL_INTERNAL_PERF, format, args...)
	}
}

// Warning logs to the SQL_INTERNAL_PERF channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSqlInternalPerf) Warning(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.WARNING, channel.SQL_INTERNAL_PERF, msg)
}

// WarningfDepth logs to the SQL_INTERNAL_PERF channel with severity WARNING,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerSqlInternalPerf) WarningfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.WARNING, channel.SQL_INTERNAL_PERF, format, args...)
}

// Errorf logs to the SQL_INTERNAL_PERF channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSqlInternalPerf) Errorf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.ERROR, channel.SQL_INTERNAL_PERF, format, args...)
}

// VErrorf logs to the SQL_INTERNAL_PERF channel with severity ERROR,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSqlInternalPerf) VErrorf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.ERROR, channel.SQL_INTERNAL_PERF, format, args...)
	}
}

// Error logs to the SQL_INTERNAL_PERF channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSqlInternalPerf) Error(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.ERROR, channel.SQL_INTERNAL_PERF, msg)
}

// ErrorfDepth logs to the SQL_INTERNAL_PERF channel with severity ERROR,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerSqlInternalPerf) ErrorfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.ERROR, channel.SQL_INTERNAL_PERF, format, args...)
}

// Fatalf logs to the SQL_INTERNAL_PERF channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSqlInternalPerf) Fatalf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.FATAL, channel.SQL_INTERNAL_PERF, format, args...)
}

// VFatalf logs to the SQL_INTERNAL_PERF channel with severity FATAL,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSqlInternalPerf) VFatalf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.FATAL, channel.SQL_INTERNAL_PERF, format, args...)
	}
}

// Fatal logs to the SQL_INTERNAL_PERF channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSqlInternalPerf) Fatal(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.FATAL, channel.SQL_INTERNAL_PERF, msg)
}

// FatalfDepth logs to the SQL_INTERNAL_PERF channel with severity FATAL,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerSqlInternalPerf) FatalfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.FATAL, channel.SQL_INTERNAL_PERF, format, args...)
}

// Shout logs to channel SQL_INTERNAL_PERF, and also to the real stderr if logging
// is currently redirected to a file.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
func (loggerSqlInternalPerf) Shout(ctx context.Context, sev Severity, msg string) {
	shoutfDepth(ctx, 1, sev, channel.SQL_INTERNAL_PERF, msg)
}

// Shoutf logs to channel SQL_INTERNAL_PERF, and also to the real stderr if
// logging is currently redirected to a file. Arguments are handled in
// the manner of fmt.Printf.
//
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
func (loggerSqlInternalPerf) Shoutf(ctx context.Context, sev Severity, format string, args ...interface{}) {
	shoutfDepth(ctx, 1, sev, channel.SQL_INTERNAL_PERF, format, args...)
}

// VEvent either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
func (loggerSqlInternalPerf) VEvent(ctx context.Context, level Level, msg string) {
	vEvent(ctx, false /* isErr */, 1, level, channel.SQL_INTERNAL_PERF, msg)
}

// VEventf either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
func (loggerSqlInternalPerf) VEventf(ctx context.Context, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1, level, channel.SQL_INTERNAL_PERF, format, args...)
}

// VEventfDepth performs the same as VEventf but checks the verbosity level
// at the given depth in the call stack.
// The `SQL_INTERNAL_PERF` channel is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
func (loggerSqlInternalPerf) VEventfDepth(ctx context.Context, depth int, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1+depth, level, channel.SQL_INTERNAL_PERF, format, args...)
}

// loggerTelemetry is the logger type for the TELEMETRY channel.
type loggerTelemetry struct{}

// Telemetry is a logger that logs to the TELEMETRY channel.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
var Telemetry loggerTelemetry

// Telemetry and loggerTelemetry implement ChannelLogger.
//
// We do not force use of ChannelLogger when instantiating the logger
// object above (e.g. by giving it the interface type), to ensure
// the calls to the API methods remain inlinable in the common case.
var _ ChannelLogger = Telemetry

// Infof logs to the TELEMETRY channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerTelemetry) Infof(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.INFO, channel.TELEMETRY, format, args...)
}

// VInfof logs to the TELEMETRY channel with severity INFO,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerTelemetry) VInfof(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.INFO, channel.TELEMETRY, format, args...)
	}
}

// Info logs to the TELEMETRY channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerTelemetry) Info(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.INFO, channel.TELEMETRY, msg)
}

// InfofDepth logs to the TELEMETRY channel with severity INFO,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerTelemetry) InfofDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.INFO, channel.TELEMETRY, format, args...)
}

// Warningf logs to the TELEMETRY channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerTelemetry) Warningf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.WARNING, channel.TELEMETRY, format, args...)
}

// VWarningf logs to the TELEMETRY channel with severity WARNING,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerTelemetry) VWarningf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.WARNING, channel.TELEMETRY, format, args...)
	}
}

// Warning logs to the TELEMETRY channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerTelemetry) Warning(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.WARNING, channel.TELEMETRY, msg)
}

// WarningfDepth logs to the TELEMETRY channel with severity WARNING,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerTelemetry) WarningfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.WARNING, channel.TELEMETRY, format, args...)
}

// Errorf logs to the TELEMETRY channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerTelemetry) Errorf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.ERROR, channel.TELEMETRY, format, args...)
}

// VErrorf logs to the TELEMETRY channel with severity ERROR,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerTelemetry) VErrorf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.ERROR, channel.TELEMETRY, format, args...)
	}
}

// Error logs to the TELEMETRY channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerTelemetry) Error(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.ERROR, channel.TELEMETRY, msg)
}

// ErrorfDepth logs to the TELEMETRY channel with severity ERROR,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerTelemetry) ErrorfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.ERROR, channel.TELEMETRY, format, args...)
}

// Fatalf logs to the TELEMETRY channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerTelemetry) Fatalf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.FATAL, channel.TELEMETRY, format, args...)
}

// VFatalf logs to the TELEMETRY channel with severity FATAL,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerTelemetry) VFatalf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.FATAL, channel.TELEMETRY, format, args...)
	}
}

// Fatal logs to the TELEMETRY channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerTelemetry) Fatal(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.FATAL, channel.TELEMETRY, msg)
}

// FatalfDepth logs to the TELEMETRY channel with severity FATAL,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerTelemetry) FatalfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.FATAL, channel.TELEMETRY, format, args...)
}

// Shout logs to channel TELEMETRY, and also to the real stderr if logging
// is currently redirected to a file.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
func (loggerTelemetry) Shout(ctx context.Context, sev Severity, msg string) {
	shoutfDepth(ctx, 1, sev, channel.TELEMETRY, msg)
}

// Shoutf logs to channel TELEMETRY, and also to the real stderr if
// logging is currently redirected to a file. Arguments are handled in
// the manner of fmt.Printf.
//
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
func (loggerTelemetry) Shoutf(ctx context.Context, sev Severity, format string, args ...interface{}) {
	shoutfDepth(ctx, 1, sev, channel.TELEMETRY, format, args...)
}

// VEvent either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
func (loggerTelemetry) VEvent(ctx context.Context, level Level, msg string) {
	vEvent(ctx, false /* isErr */, 1, level, channel.TELEMETRY, msg)
}

// VEventf either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
func (loggerTelemetry) VEventf(ctx context.Context, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1, level, channel.TELEMETRY, format, args...)
}

// VEventfDepth performs the same as VEventf but checks the verbosity level
// at the given depth in the call stack.
// The `TELEMETRY` channel reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
func (loggerTelemetry) VEventfDepth(ctx context.Context, depth int, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1+depth, level, channel.TELEMETRY, format, args...)
}

// loggerKvDistribution is the logger type for the KV_DISTRIBUTION channel.
type loggerKvDistribution struct{}

// KvDistribution is a logger that logs to the KV_DISTRIBUTION channel.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
var KvDistribution loggerKvDistribution

// KvDistribution and loggerKvDistribution implement ChannelLogger.
//
// We do not force use of ChannelLogger when instantiating the logger
// object above (e.g. by giving it the interface type), to ensure
// the calls to the API methods remain inlinable in the common case.
var _ ChannelLogger = KvDistribution

// Infof logs to the KV_DISTRIBUTION channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerKvDistribution) Infof(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.INFO, channel.KV_DISTRIBUTION, format, args...)
}

// VInfof logs to the KV_DISTRIBUTION channel with severity INFO,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerKvDistribution) VInfof(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.INFO, channel.KV_DISTRIBUTION, format, args...)
	}
}

// Info logs to the KV_DISTRIBUTION channel with severity INFO.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerKvDistribution) Info(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.INFO, channel.KV_DISTRIBUTION, msg)
}

// InfofDepth logs to the KV_DISTRIBUTION channel with severity INFO,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
//
// The `INFO` severity is used for informational messages that do not
// require action.
func (loggerKvDistribution) InfofDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.INFO, channel.KV_DISTRIBUTION, format, args...)
}

// Warningf logs to the KV_DISTRIBUTION channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerKvDistribution) Warningf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.WARNING, channel.KV_DISTRIBUTION, format, args...)
}

// VWarningf logs to the KV_DISTRIBUTION channel with severity WARNING,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerKvDistribution) VWarningf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.WARNING, channel.KV_DISTRIBUTION, format, args...)
	}
}

// Warning logs to the KV_DISTRIBUTION channel with severity WARNING.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerKvDistribution) Warning(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.WARNING, channel.KV_DISTRIBUTION, msg)
}

// WarningfDepth logs to the KV_DISTRIBUTION channel with severity WARNING,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
//
// The `WARNING` severity is used for situations which may require special handling,
// where normal operation is expected to resume automatically.
func (loggerKvDistribution) WarningfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.WARNING, channel.KV_DISTRIBUTION, format, args...)
}

// Errorf logs to the KV_DISTRIBUTION channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerKvDistribution) Errorf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.ERROR, channel.KV_DISTRIBUTION, format, args...)
}

// VErrorf logs to the KV_DISTRIBUTION channel with severity ERROR,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerKvDistribution) VErrorf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.ERROR, channel.KV_DISTRIBUTION, format, args...)
	}
}

// Error logs to the KV_DISTRIBUTION channel with severity ERROR.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerKvDistribution) Error(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.ERROR, channel.KV_DISTRIBUTION, msg)
}

// ErrorfDepth logs to the KV_DISTRIBUTION channel with severity ERROR,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
//
// The `ERROR` severity is used for situations that require special handling,
// where normal operation could not proceed as expected.
// Other operations can continue mostly unaffected.
func (loggerKvDistribution) ErrorfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.ERROR, channel.KV_DISTRIBUTION, format, args...)
}

// Fatalf logs to the KV_DISTRIBUTION channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerKvDistribution) Fatalf(ctx context.Context, format string, args ...interface{}) {
	logfDepth(ctx, 1, severity.FATAL, channel.KV_DISTRIBUTION, format, args...)
}

// VFatalf logs to the KV_DISTRIBUTION channel with severity FATAL,
// if logging has been enabled for the source file where the call is
// performed at the provided verbosity level, via the vmodule setting.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerKvDistribution) VFatalf(ctx context.Context, level Level, format string, args ...interface{}) {
	if VDepth(level, 1) {
		logfDepth(ctx, 1, severity.FATAL, channel.KV_DISTRIBUTION, format, args...)
	}
}

// Fatal logs to the KV_DISTRIBUTION channel with severity FATAL.
// It extracts log tags from the context and logs them along with the given
// message.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerKvDistribution) Fatal(ctx context.Context, msg string) {
	logfDepth(ctx, 1, severity.FATAL, channel.KV_DISTRIBUTION, msg)
}

// FatalfDepth logs to the KV_DISTRIBUTION channel with severity FATAL,
// offsetting the caller's stack frame by 'depth'.
// It extracts log tags from the context and logs them along with the given
// message. Arguments are handled in the manner of fmt.Printf.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
//
// The `FATAL` severity is used for situations that require an immedate, hard
// server shutdown. A report is also sent to telemetry if telemetry
// is enabled.
func (loggerKvDistribution) FatalfDepth(ctx context.Context, depth int, format string, args ...interface{}) {
	logfDepth(ctx, depth+1, severity.FATAL, channel.KV_DISTRIBUTION, format, args...)
}

// Shout logs to channel KV_DISTRIBUTION, and also to the real stderr if logging
// is currently redirected to a file.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
func (loggerKvDistribution) Shout(ctx context.Context, sev Severity, msg string) {
	shoutfDepth(ctx, 1, sev, channel.KV_DISTRIBUTION, msg)
}

// Shoutf logs to channel KV_DISTRIBUTION, and also to the real stderr if
// logging is currently redirected to a file. Arguments are handled in
// the manner of fmt.Printf.
//
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
func (loggerKvDistribution) Shoutf(ctx context.Context, sev Severity, format string, args ...interface{}) {
	shoutfDepth(ctx, 1, sev, channel.KV_DISTRIBUTION, format, args...)
}

// VEvent either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
func (loggerKvDistribution) VEvent(ctx context.Context, level Level, msg string) {
	vEvent(ctx, false /* isErr */, 1, level, channel.KV_DISTRIBUTION, msg)
}

// VEventf either logs a message to the channel (which also outputs to the
// active trace) or to the trace alone, depending on whether the specified
// verbosity level is active.
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
func (loggerKvDistribution) VEventf(ctx context.Context, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1, level, channel.KV_DISTRIBUTION, format, args...)
}

// VEventfDepth performs the same as VEventf but checks the verbosity level
// at the given depth in the call stack.
// The `KV_DISTRIBUTION` channel is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
func (loggerKvDistribution) VEventfDepth(ctx context.Context, depth int, level Level, format string, args ...interface{}) {
	vEventf(ctx, false /* isErr */, 1+depth, level, channel.KV_DISTRIBUTION, format, args...)
}
