// Code generated by gen.go. DO NOT EDIT.

package eventpb

import (
	"regexp"
	"strconv"

	"github.com/cockroachdb/cockroach/pkg/util/jsonbytes"
	"github.com/cockroachdb/redact"
	"github.com/gogo/protobuf/jsonpb"
)

var safeRe1 = regexp.MustCompile(`^root|node$`)

var _ = jsonpb.Marshaler{}

// AppendJSONFields implements the EventPayload interface.
func (m *AdminQuery) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLExecDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterDatabaseAddRegion) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.DatabaseName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DatabaseName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.DatabaseName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.RegionName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RegionName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.RegionName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterDatabaseDropRegion) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.DatabaseName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DatabaseName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.DatabaseName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.RegionName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RegionName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.RegionName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterDatabaseOwner) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.DatabaseName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DatabaseName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.DatabaseName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Owner != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Owner\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Owner)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterDatabasePlacement) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.DatabaseName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DatabaseName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.DatabaseName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Placement != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Placement\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Placement)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterDatabasePrimaryRegion) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.DatabaseName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DatabaseName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.DatabaseName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.PrimaryRegionName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"PrimaryRegionName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.PrimaryRegionName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterDatabaseSetZoneConfigExtension) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonZoneConfigDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterDatabaseSurvivalGoal) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.DatabaseName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DatabaseName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.DatabaseName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.SurvivalGoal != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SurvivalGoal\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.SurvivalGoal)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterDefaultPrivileges) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLPrivilegeEventDetails.AppendJSONFields(printComma, b)

	if m.DatabaseName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DatabaseName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.DatabaseName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.RoleName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RoleName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.RoleName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.ForAllRoles {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ForAllRoles\":"...)
		b = strconv.AppendBool(b, m.ForAllRoles)
	}

	if m.SchemaName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SchemaName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.SchemaName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterFunctionOptions) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.FunctionName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"FunctionName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.FunctionName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterFunctionOwner) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.FunctionName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"FunctionName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.FunctionName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Owner != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Owner\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Owner)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterIndex) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.IndexName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IndexName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.IndexName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.MutationID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MutationID\":"...)
		b = strconv.AppendUint(b, uint64(m.MutationID), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterIndexVisible) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.IndexName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IndexName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.IndexName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.NotVisible {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NotVisible\":"...)
		b = strconv.AppendBool(b, m.NotVisible)
	}

	if m.Invisibility != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Invisibility\":"...)
		b = strconv.AppendFloat(b, float64(m.Invisibility), 'f', -1, 64)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterRole) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.RoleName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RoleName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.RoleName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if len(m.Options) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Options\":["...)
		for i, v := range m.Options {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), v))
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	if len(m.SetInfo) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SetInfo\":["...)
		for i, v := range m.SetInfo {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), v))
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterSchemaOwner) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.SchemaName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SchemaName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.SchemaName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Owner != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Owner\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Owner)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterSequence) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.SequenceName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SequenceName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.SequenceName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterTable) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.MutationID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MutationID\":"...)
		b = strconv.AppendUint(b, uint64(m.MutationID), 10)
	}

	if len(m.CascadeDroppedViews) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CascadeDroppedViews\":["...)
		for i, v := range m.CascadeDroppedViews {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = append(b, redact.StartMarker()...)
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(v)))))
			b = append(b, redact.EndMarker()...)
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterTableOwner) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Owner != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Owner\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Owner)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterType) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TypeName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TypeName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TypeName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *AlterTypeOwner) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TypeName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TypeName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TypeName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Owner != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Owner\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Owner)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CapturedIndexUsageStats) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	if m.TotalReadCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TotalReadCount\":"...)
		b = strconv.AppendUint(b, uint64(m.TotalReadCount), 10)
	}

	if m.LastRead != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"LastRead\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.LastRead)))
		b = append(b, '"')
	}

	if m.TableID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableID\":"...)
		b = strconv.AppendUint(b, uint64(m.TableID), 10)
	}

	if m.IndexID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IndexID\":"...)
		b = strconv.AppendUint(b, uint64(m.IndexID), 10)
	}

	if m.DatabaseName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DatabaseName\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.DatabaseName)))
		b = append(b, '"')
	}

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.TableName)))
		b = append(b, '"')
	}

	if m.IndexName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IndexName\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.IndexName)))
		b = append(b, '"')
	}

	if m.IndexType != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IndexType\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.IndexType)))
		b = append(b, '"')
	}

	if m.IsUnique {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IsUnique\":"...)
		b = strconv.AppendBool(b, m.IsUnique)
	}

	if m.IsInverted {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IsInverted\":"...)
		b = strconv.AppendBool(b, m.IsInverted)
	}

	if m.CreatedAt != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CreatedAt\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.CreatedAt)))
		b = append(b, '"')
	}

	if m.SchemaName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SchemaName\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.SchemaName)))
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CertsReload) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	if m.Success {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Success\":"...)
		b = strconv.AppendBool(b, m.Success)
	}

	if m.ErrorMessage != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ErrorMessage\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.ErrorMessage)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *ChangeDatabasePrivilege) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLPrivilegeEventDetails.AppendJSONFields(printComma, b)

	if m.DatabaseName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DatabaseName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.DatabaseName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *ChangeFunctionPrivilege) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLPrivilegeEventDetails.AppendJSONFields(printComma, b)

	if m.FuncName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"FuncName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.FuncName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *ChangeSchemaPrivilege) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLPrivilegeEventDetails.AppendJSONFields(printComma, b)

	if m.SchemaName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SchemaName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.SchemaName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *ChangeTablePrivilege) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLPrivilegeEventDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *ChangeTypePrivilege) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLPrivilegeEventDetails.AppendJSONFields(printComma, b)

	if m.TypeName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TypeName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TypeName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *ChangefeedEmittedBytes) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonChangefeedEventDetails.AppendJSONFields(printComma, b)

	if m.EmittedBytes != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"EmittedBytes\":"...)
		b = strconv.AppendInt(b, int64(m.EmittedBytes), 10)
	}

	if m.EmittedMessages != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"EmittedMessages\":"...)
		b = strconv.AppendInt(b, int64(m.EmittedMessages), 10)
	}

	if m.LoggingInterval != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"LoggingInterval\":"...)
		b = strconv.AppendInt(b, int64(m.LoggingInterval), 10)
	}

	if m.Closing {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Closing\":"...)
		b = strconv.AppendBool(b, m.Closing)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *ChangefeedFailed) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonChangefeedEventDetails.AppendJSONFields(printComma, b)

	if m.FailureType != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"FailureType\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.FailureType)))
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *ClientAuthenticationFailed) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonConnectionDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSessionDetails.AppendJSONFields(printComma, b)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"Reason\":"...)
	// Enums are defined in our code, so are always safe to print without
	// redaction.
	b = append(b, '"')
	b = append(b, m.Reason.String()...)
	b = append(b, '"')

	if m.Detail != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Detail\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.Detail)))
		b = append(b, '"')
	}

	if m.Method != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Method\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.Method)))
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *ClientAuthenticationInfo) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonConnectionDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSessionDetails.AppendJSONFields(printComma, b)

	if m.Method != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Method\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.Method)))
		b = append(b, '"')
	}

	if m.Info != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Info\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.Info)))
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *ClientAuthenticationOk) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonConnectionDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSessionDetails.AppendJSONFields(printComma, b)

	if m.Method != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Method\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.Method)))
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *ClientConnectionEnd) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonConnectionDetails.AppendJSONFields(printComma, b)

	if m.Duration != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Duration\":"...)
		b = strconv.AppendInt(b, int64(m.Duration), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *ClientConnectionStart) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonConnectionDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *ClientSessionEnd) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonConnectionDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSessionDetails.AppendJSONFields(printComma, b)

	if m.Duration != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Duration\":"...)
		b = strconv.AppendInt(b, int64(m.Duration), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommentOnColumn) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.ColumnName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ColumnName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.ColumnName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Comment != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Comment\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Comment)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.NullComment {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NullComment\":"...)
		b = strconv.AppendBool(b, m.NullComment)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommentOnConstraint) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.ConstraintName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ConstraintName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.ConstraintName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Comment != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Comment\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Comment)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.NullComment {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NullComment\":"...)
		b = strconv.AppendBool(b, m.NullComment)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommentOnDatabase) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.DatabaseName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DatabaseName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.DatabaseName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Comment != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Comment\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Comment)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.NullComment {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NullComment\":"...)
		b = strconv.AppendBool(b, m.NullComment)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommentOnIndex) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.IndexName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IndexName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.IndexName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Comment != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Comment\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Comment)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.NullComment {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NullComment\":"...)
		b = strconv.AppendBool(b, m.NullComment)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommentOnSchema) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.SchemaName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SchemaName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.SchemaName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Comment != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Comment\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Comment)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.NullComment {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NullComment\":"...)
		b = strconv.AppendBool(b, m.NullComment)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommentOnTable) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Comment != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Comment\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Comment)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.NullComment {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NullComment\":"...)
		b = strconv.AppendBool(b, m.NullComment)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommentOnType) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TypeName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TypeName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TypeName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Comment != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Comment\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Comment)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.NullComment {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NullComment\":"...)
		b = strconv.AppendBool(b, m.NullComment)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommonChangefeedEventDetails) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	if m.Description != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Description\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Description)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.SinkType != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SinkType\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.SinkType)))
		b = append(b, '"')
	}

	if m.NumTables != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NumTables\":"...)
		b = strconv.AppendInt(b, int64(m.NumTables), 10)
	}

	if m.Resolved != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Resolved\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.Resolved)))
		b = append(b, '"')
	}

	if m.InitialScan != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"InitialScan\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.InitialScan)))
		b = append(b, '"')
	}

	if m.Format != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Format\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.Format)))
		b = append(b, '"')
	}

	if m.JobId != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"JobId\":"...)
		b = strconv.AppendInt(b, int64(m.JobId), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommonConnectionDetails) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	if m.InstanceID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"InstanceID\":"...)
		b = strconv.AppendInt(b, int64(m.InstanceID), 10)
	}

	if m.Network != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Network\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.Network)))
		b = append(b, '"')
	}

	if m.RemoteAddress != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RemoteAddress\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.RemoteAddress)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.SessionID != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SessionID\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.SessionID)))
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommonDebugEventDetails) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	if m.NodeID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NodeID\":"...)
		b = strconv.AppendInt(b, int64(m.NodeID), 10)
	}

	if m.User != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"User\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.User)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommonJobEventDetails) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	if m.JobID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"JobID\":"...)
		b = strconv.AppendInt(b, int64(m.JobID), 10)
	}

	if m.JobType != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"JobType\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.JobType)))
		b = append(b, '"')
	}

	if m.Description != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Description\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Description)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.User != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"User\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.User)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if len(m.DescriptorIDs) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DescriptorIDs\":["...)
		for i, v := range m.DescriptorIDs {
			if i > 0 {
				b = append(b, ',')
			}
			b = strconv.AppendUint(b, uint64(v), 10)
		}
		b = append(b, ']')
	}

	if m.Status != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Status\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.Status)))
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommonLargeRowDetails) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	if m.RowSize != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RowSize\":"...)
		b = strconv.AppendUint(b, uint64(m.RowSize), 10)
	}

	if m.TableID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableID\":"...)
		b = strconv.AppendUint(b, uint64(m.TableID), 10)
	}

	if m.FamilyID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"FamilyID\":"...)
		b = strconv.AppendUint(b, uint64(m.FamilyID), 10)
	}

	if m.PrimaryKey != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"PrimaryKey\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.PrimaryKey)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommonNodeDecommissionDetails) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	if m.RequestingNodeID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RequestingNodeID\":"...)
		b = strconv.AppendInt(b, int64(m.RequestingNodeID), 10)
	}

	if m.TargetNodeID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TargetNodeID\":"...)
		b = strconv.AppendInt(b, int64(m.TargetNodeID), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommonNodeEventDetails) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	if m.NodeID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NodeID\":"...)
		b = strconv.AppendInt(b, int64(m.NodeID), 10)
	}

	if m.StartedAt != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"StartedAt\":"...)
		b = strconv.AppendInt(b, int64(m.StartedAt), 10)
	}

	if m.LastUp != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"LastUp\":"...)
		b = strconv.AppendInt(b, int64(m.LastUp), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommonSQLEventDetails) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	if m.Statement != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Statement\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.Statement)))
		b = append(b, '"')
	}

	if m.Tag != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Tag\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.Tag)))
		b = append(b, '"')
	}

	if m.User != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"User\":\""...)

		if safeRe1.MatchString(m.User) {
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.User)))))
		} else {
			b = append(b, redact.StartMarker()...)
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.User)))))
			b = append(b, redact.EndMarker()...)
		}
		b = append(b, '"')
	}

	if m.DescriptorID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DescriptorID\":"...)
		b = strconv.AppendUint(b, uint64(m.DescriptorID), 10)
	}

	if m.ApplicationName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ApplicationName\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.ApplicationName)))
		b = append(b, '"')
	}

	if len(m.PlaceholderValues) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"PlaceholderValues\":["...)
		for i, v := range m.PlaceholderValues {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = append(b, redact.StartMarker()...)
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(v)))))
			b = append(b, redact.EndMarker()...)
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommonSQLExecDetails) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	if m.ExecMode != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ExecMode\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.ExecMode)))
		b = append(b, '"')
	}

	if m.NumRows != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NumRows\":"...)
		b = strconv.AppendInt(b, int64(m.NumRows), 10)
	}

	if m.SQLSTATE != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SQLSTATE\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.SQLSTATE)))
		b = append(b, '"')
	}

	if m.ErrorText != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ErrorText\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.ErrorText)))
		b = append(b, '"')
	}

	if m.Age != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Age\":"...)
		b = strconv.AppendFloat(b, float64(m.Age), 'f', -1, 32)
	}

	if m.NumRetries != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NumRetries\":"...)
		b = strconv.AppendUint(b, uint64(m.NumRetries), 10)
	}

	if m.FullTableScan {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"FullTableScan\":"...)
		b = strconv.AppendBool(b, m.FullTableScan)
	}

	if m.FullIndexScan {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"FullIndexScan\":"...)
		b = strconv.AppendBool(b, m.FullIndexScan)
	}

	if m.TxnCounter != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TxnCounter\":"...)
		b = strconv.AppendUint(b, uint64(m.TxnCounter), 10)
	}

	if m.BulkJobId != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"BulkJobId\":"...)
		b = strconv.AppendUint(b, uint64(m.BulkJobId), 10)
	}

	if m.StmtPosInTxn != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"StmtPosInTxn\":"...)
		b = strconv.AppendUint(b, uint64(m.StmtPosInTxn), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommonSQLPrivilegeEventDetails) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	if m.Grantee != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Grantee\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Grantee)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if len(m.GrantedPrivileges) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"GrantedPrivileges\":["...)
		for i, v := range m.GrantedPrivileges {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), v))
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	if len(m.RevokedPrivileges) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RevokedPrivileges\":["...)
		for i, v := range m.RevokedPrivileges {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), v))
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommonSchemaChangeEventDetails) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	if m.InstanceID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"InstanceID\":"...)
		b = strconv.AppendInt(b, int64(m.InstanceID), 10)
	}

	if m.DescriptorID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DescriptorID\":"...)
		b = strconv.AppendUint(b, uint64(m.DescriptorID), 10)
	}

	if m.MutationID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MutationID\":"...)
		b = strconv.AppendUint(b, uint64(m.MutationID), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommonSessionDetails) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	if m.Transport != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Transport\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.Transport)))
		b = append(b, '"')
	}

	if m.User != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"User\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.User)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.SystemIdentity != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SystemIdentity\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.SystemIdentity)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommonSharedServiceEventDetails) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	if m.NodeID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NodeID\":"...)
		b = strconv.AppendInt(b, int64(m.NodeID), 10)
	}

	if m.TenantID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TenantID\":"...)
		b = strconv.AppendUint(b, uint64(m.TenantID), 10)
	}

	if m.InstanceID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"InstanceID\":"...)
		b = strconv.AppendInt(b, int64(m.InstanceID), 10)
	}

	if m.TenantName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TenantName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TenantName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommonTxnRowsLimitDetails) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	if m.TxnID != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TxnID\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.TxnID)))
		b = append(b, '"')
	}

	if m.SessionID != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SessionID\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.SessionID)))
		b = append(b, '"')
	}

	if m.NumRows != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NumRows\":"...)
		b = strconv.AppendInt(b, int64(m.NumRows), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CommonZoneConfigDetails) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	if m.Target != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Target\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Target)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Config != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Config\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Config)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if len(m.Options) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Options\":["...)
		for i, v := range m.Options {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = append(b, redact.StartMarker()...)
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(v)))))
			b = append(b, redact.EndMarker()...)
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CreateChangefeed) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonChangefeedEventDetails.AppendJSONFields(printComma, b)

	if m.Transformation {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Transformation\":"...)
		b = strconv.AppendBool(b, m.Transformation)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CreateDatabase) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.DatabaseName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DatabaseName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.DatabaseName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CreateFunction) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.FunctionName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"FunctionName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.FunctionName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.IsReplace {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IsReplace\":"...)
		b = strconv.AppendBool(b, m.IsReplace)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CreateIndex) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.IndexName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IndexName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.IndexName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.MutationID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MutationID\":"...)
		b = strconv.AppendUint(b, uint64(m.MutationID), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CreateRole) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.RoleName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RoleName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.RoleName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CreateSchema) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.SchemaName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SchemaName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.SchemaName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Owner != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Owner\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Owner)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CreateSequence) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.SequenceName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SequenceName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.SequenceName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Owner != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Owner\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Owner)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CreateStatistics) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CreateTable) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Owner != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Owner\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Owner)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CreateTrigger) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.TriggerName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TriggerName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TriggerName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CreateType) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TypeName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TypeName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TypeName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Owner != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Owner\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Owner)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *CreateView) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.ViewName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ViewName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.ViewName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Owner != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Owner\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Owner)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.ViewQuery != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ViewQuery\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.ViewQuery)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *DebugRecoverReplica) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonDebugEventDetails.AppendJSONFields(printComma, b)

	if m.RangeID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RangeID\":"...)
		b = strconv.AppendInt(b, int64(m.RangeID), 10)
	}

	if m.StoreID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"StoreID\":"...)
		b = strconv.AppendInt(b, int64(m.StoreID), 10)
	}

	if m.SurvivorReplicaID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SurvivorReplicaID\":"...)
		b = strconv.AppendInt(b, int64(m.SurvivorReplicaID), 10)
	}

	if m.UpdatedReplicaID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"UpdatedReplicaID\":"...)
		b = strconv.AppendInt(b, int64(m.UpdatedReplicaID), 10)
	}

	if m.StartKey != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"StartKey\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.StartKey)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.EndKey != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"EndKey\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.EndKey)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *DebugSendKvBatch) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonDebugEventDetails.AppendJSONFields(printComma, b)

	if m.BatchRequest != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"BatchRequest\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.BatchRequest)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *DiskSlownessCleared) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	if m.NodeID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NodeID\":"...)
		b = strconv.AppendInt(b, int64(m.NodeID), 10)
	}

	if m.StoreID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"StoreID\":"...)
		b = strconv.AppendInt(b, int64(m.StoreID), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *DiskSlownessDetected) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	if m.NodeID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NodeID\":"...)
		b = strconv.AppendInt(b, int64(m.NodeID), 10)
	}

	if m.StoreID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"StoreID\":"...)
		b = strconv.AppendInt(b, int64(m.StoreID), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *DropDatabase) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.DatabaseName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DatabaseName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.DatabaseName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if len(m.DroppedSchemaObjects) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DroppedSchemaObjects\":["...)
		for i, v := range m.DroppedSchemaObjects {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = append(b, redact.StartMarker()...)
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(v)))))
			b = append(b, redact.EndMarker()...)
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *DropFunction) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.FunctionName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"FunctionName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.FunctionName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *DropIndex) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.IndexName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IndexName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.IndexName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.MutationID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MutationID\":"...)
		b = strconv.AppendUint(b, uint64(m.MutationID), 10)
	}

	if len(m.CascadeDroppedViews) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CascadeDroppedViews\":["...)
		for i, v := range m.CascadeDroppedViews {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = append(b, redact.StartMarker()...)
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(v)))))
			b = append(b, redact.EndMarker()...)
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *DropRole) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.RoleName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RoleName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.RoleName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *DropSchema) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.SchemaName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SchemaName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.SchemaName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *DropSequence) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.SequenceName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SequenceName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.SequenceName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *DropTable) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if len(m.CascadeDroppedViews) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CascadeDroppedViews\":["...)
		for i, v := range m.CascadeDroppedViews {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = append(b, redact.StartMarker()...)
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(v)))))
			b = append(b, redact.EndMarker()...)
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *DropTrigger) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.TriggerName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TriggerName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TriggerName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *DropType) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TypeName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TypeName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TypeName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *DropView) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.ViewName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ViewName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.ViewName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if len(m.CascadeDroppedViews) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CascadeDroppedViews\":["...)
		for i, v := range m.CascadeDroppedViews {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = append(b, redact.StartMarker()...)
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(v)))))
			b = append(b, redact.EndMarker()...)
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *FinishSchemaChange) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSchemaChangeEventDetails.AppendJSONFields(printComma, b)

	if m.LatencyNanos != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"LatencyNanos\":"...)
		b = strconv.AppendInt(b, int64(m.LatencyNanos), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *FinishSchemaChangeRollback) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSchemaChangeEventDetails.AppendJSONFields(printComma, b)

	if m.LatencyNanos != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"LatencyNanos\":"...)
		b = strconv.AppendInt(b, int64(m.LatencyNanos), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *ForceDeleteTableDataEntry) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.DescriptorID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DescriptorID\":"...)
		b = strconv.AppendUint(b, uint64(m.DescriptorID), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *GrantRole) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if len(m.GranteeRoles) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"GranteeRoles\":["...)
		for i, v := range m.GranteeRoles {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = append(b, redact.StartMarker()...)
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(v)))))
			b = append(b, redact.EndMarker()...)
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	if len(m.Members) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Members\":["...)
		for i, v := range m.Members {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = append(b, redact.StartMarker()...)
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(v)))))
			b = append(b, redact.EndMarker()...)
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *HotRangesStats) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	if m.RangeID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RangeID\":"...)
		b = strconv.AppendInt(b, int64(m.RangeID), 10)
	}

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"Qps\":"...)
	b = strconv.AppendFloat(b, float64(m.Qps), 'f', -1, 64)

	if m.DatabaseName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DatabaseName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.DatabaseName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.IndexName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IndexName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.IndexName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.SchemaName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SchemaName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.SchemaName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.LeaseholderNodeID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"LeaseholderNodeID\":"...)
		b = strconv.AppendInt(b, int64(m.LeaseholderNodeID), 10)
	}

	if m.WritesPerSecond != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"WritesPerSecond\":"...)
		b = strconv.AppendFloat(b, float64(m.WritesPerSecond), 'f', -1, 64)
	}

	if m.ReadsPerSecond != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ReadsPerSecond\":"...)
		b = strconv.AppendFloat(b, float64(m.ReadsPerSecond), 'f', -1, 64)
	}

	if m.WriteBytesPerSecond != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"WriteBytesPerSecond\":"...)
		b = strconv.AppendFloat(b, float64(m.WriteBytesPerSecond), 'f', -1, 64)
	}

	if m.ReadBytesPerSecond != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ReadBytesPerSecond\":"...)
		b = strconv.AppendFloat(b, float64(m.ReadBytesPerSecond), 'f', -1, 64)
	}

	if m.CPUTimePerSecond != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CPUTimePerSecond\":"...)
		b = strconv.AppendFloat(b, float64(m.CPUTimePerSecond), 'f', -1, 64)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *Import) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonJobEventDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *LargeRow) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonLargeRowDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *LargeRowInternal) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonLargeRowDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *LevelStats) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"Level\":"...)
	b = strconv.AppendUint(b, uint64(m.Level), 10)

	if m.NumFiles != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NumFiles\":"...)
		b = strconv.AppendInt(b, int64(m.NumFiles), 10)
	}

	if m.SizeBytes != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SizeBytes\":"...)
		b = strconv.AppendInt(b, int64(m.SizeBytes), 10)
	}

	if m.Score != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Score\":"...)
		b = strconv.AppendFloat(b, float64(m.Score), 'f', -1, 32)
	}

	if m.BytesIn != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"BytesIn\":"...)
		b = strconv.AppendUint(b, uint64(m.BytesIn), 10)
	}

	if m.BytesIngested != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"BytesIngested\":"...)
		b = strconv.AppendUint(b, uint64(m.BytesIngested), 10)
	}

	if m.BytesMoved != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"BytesMoved\":"...)
		b = strconv.AppendUint(b, uint64(m.BytesMoved), 10)
	}

	if m.BytesRead != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"BytesRead\":"...)
		b = strconv.AppendUint(b, uint64(m.BytesRead), 10)
	}

	if m.BytesCompacted != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"BytesCompacted\":"...)
		b = strconv.AppendUint(b, uint64(m.BytesCompacted), 10)
	}

	if m.BytesFlushed != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"BytesFlushed\":"...)
		b = strconv.AppendUint(b, uint64(m.BytesFlushed), 10)
	}

	if m.TablesCompacted != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TablesCompacted\":"...)
		b = strconv.AppendUint(b, uint64(m.TablesCompacted), 10)
	}

	if m.TablesFlushed != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TablesFlushed\":"...)
		b = strconv.AppendUint(b, uint64(m.TablesFlushed), 10)
	}

	if m.TablesIngested != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TablesIngested\":"...)
		b = strconv.AppendUint(b, uint64(m.TablesIngested), 10)
	}

	if m.TablesMoved != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TablesMoved\":"...)
		b = strconv.AppendUint(b, uint64(m.TablesMoved), 10)
	}

	if m.NumSublevels != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NumSublevels\":"...)
		b = strconv.AppendInt(b, int64(m.NumSublevels), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *MVCCIteratorStats) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"StepCount\":"...)
	b = strconv.AppendInt(b, int64(m.StepCount), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"StepCountInternal\":"...)
	b = strconv.AppendInt(b, int64(m.StepCountInternal), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"SeekCount\":"...)
	b = strconv.AppendInt(b, int64(m.SeekCount), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"SeekCountInternal\":"...)
	b = strconv.AppendInt(b, int64(m.SeekCountInternal), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"BlockBytes\":"...)
	b = strconv.AppendInt(b, int64(m.BlockBytes), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"BlockBytesInCache\":"...)
	b = strconv.AppendInt(b, int64(m.BlockBytesInCache), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"KeyBytes\":"...)
	b = strconv.AppendInt(b, int64(m.KeyBytes), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"ValueBytes\":"...)
	b = strconv.AppendInt(b, int64(m.ValueBytes), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"PointCount\":"...)
	b = strconv.AppendInt(b, int64(m.PointCount), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"PointsCoveredByRangeTombstones\":"...)
	b = strconv.AppendInt(b, int64(m.PointsCoveredByRangeTombstones), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"RangeKeyCount\":"...)
	b = strconv.AppendInt(b, int64(m.RangeKeyCount), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"RangeKeyContainedPoints\":"...)
	b = strconv.AppendInt(b, int64(m.RangeKeyContainedPoints), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"RangeKeySkippedPoints\":"...)
	b = strconv.AppendInt(b, int64(m.RangeKeySkippedPoints), 10)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *NodeDecommissioned) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonNodeDecommissionDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *NodeDecommissioning) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonNodeDecommissionDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *NodeJoin) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonNodeEventDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *NodeRecommissioned) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonNodeDecommissionDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *NodeRestart) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonNodeEventDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *NodeShutdownConnectionTimeout) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonNodeEventDetails.AppendJSONFields(printComma, b)

	if m.Detail != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Detail\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.Detail)))
		b = append(b, '"')
	}

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"ConnectionsRemaining\":"...)
	b = strconv.AppendUint(b, uint64(m.ConnectionsRemaining), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"TimeoutMillis\":"...)
	b = strconv.AppendUint(b, uint64(m.TimeoutMillis), 10)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *NodeShutdownTransactionTimeout) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonNodeEventDetails.AppendJSONFields(printComma, b)

	if m.Detail != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Detail\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.Detail)))
		b = append(b, '"')
	}

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"ConnectionsRemaining\":"...)
	b = strconv.AppendUint(b, uint64(m.ConnectionsRemaining), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"TimeoutMillis\":"...)
	b = strconv.AppendUint(b, uint64(m.TimeoutMillis), 10)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *PasswordHashConverted) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	if m.RoleName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RoleName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.RoleName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.OldMethod != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"OldMethod\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.OldMethod)))
		b = append(b, '"')
	}

	if m.NewMethod != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NewMethod\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.NewMethod)))
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *QueryExecute) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLExecDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *RecoveryEvent) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	if m.RecoveryType != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RecoveryType\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.RecoveryType)))
		b = append(b, '"')
	}

	if m.TargetScope != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TargetScope\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.TargetScope)))
		b = append(b, '"')
	}

	if m.IsMultiregionTarget {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IsMultiregionTarget\":"...)
		b = strconv.AppendBool(b, m.IsMultiregionTarget)
	}

	if m.TargetCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TargetCount\":"...)
		b = strconv.AppendUint(b, uint64(m.TargetCount), 10)
	}

	if m.DestinationSubdirType != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DestinationSubdirType\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.DestinationSubdirType)))
		b = append(b, '"')
	}

	if len(m.DestinationStorageTypes) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DestinationStorageTypes\":["...)
		for i, v := range m.DestinationStorageTypes {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), v))
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	if len(m.DestinationAuthTypes) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DestinationAuthTypes\":["...)
		for i, v := range m.DestinationAuthTypes {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), v))
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	if m.IsLocalityAware {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IsLocalityAware\":"...)
		b = strconv.AppendBool(b, m.IsLocalityAware)
	}

	if m.AsOfInterval != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"AsOfInterval\":"...)
		b = strconv.AppendInt(b, int64(m.AsOfInterval), 10)
	}

	if m.WithRevisionHistory {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"WithRevisionHistory\":"...)
		b = strconv.AppendBool(b, m.WithRevisionHistory)
	}

	if m.HasEncryptionPassphrase {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"HasEncryptionPassphrase\":"...)
		b = strconv.AppendBool(b, m.HasEncryptionPassphrase)
	}

	if m.KMSType != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"KMSType\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.KMSType)))
		b = append(b, '"')
	}

	if m.KMSCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"KMSCount\":"...)
		b = strconv.AppendUint(b, uint64(m.KMSCount), 10)
	}

	if len(m.Options) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Options\":["...)
		for i, v := range m.Options {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), v))
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	if m.DebugPauseOn != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DebugPauseOn\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.DebugPauseOn)))
		b = append(b, '"')
	}

	if m.JobID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"JobID\":"...)
		b = strconv.AppendUint(b, uint64(m.JobID), 10)
	}

	if m.ResultStatus != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ResultStatus\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.ResultStatus)))
		b = append(b, '"')
	}

	if m.ErrorText != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ErrorText\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.ErrorText)))
		b = append(b, '"')
	}

	if m.RecurringCron != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RecurringCron\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.RecurringCron)))
		b = append(b, '"')
	}

	if m.FullBackupCron != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"FullBackupCron\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.FullBackupCron)))
		b = append(b, '"')
	}

	if m.CustomFirstRunTime != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CustomFirstRunTime\":"...)
		b = strconv.AppendInt(b, int64(m.CustomFirstRunTime), 10)
	}

	if m.OnExecutionFailure != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"OnExecutionFailure\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.OnExecutionFailure)))
		b = append(b, '"')
	}

	if m.OnPreviousRunning != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"OnPreviousRunning\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.OnPreviousRunning)))
		b = append(b, '"')
	}

	if m.IgnoreExistingBackup {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IgnoreExistingBackup\":"...)
		b = strconv.AppendBool(b, m.IgnoreExistingBackup)
	}

	if m.ApplicationName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ApplicationName\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.ApplicationName)))
		b = append(b, '"')
	}

	if m.NumRows != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NumRows\":"...)
		b = strconv.AppendInt(b, int64(m.NumRows), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *RemoveZoneConfig) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonZoneConfigDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *RenameDatabase) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.DatabaseName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DatabaseName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.DatabaseName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.NewDatabaseName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NewDatabaseName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.NewDatabaseName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *RenameFunction) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.FunctionName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"FunctionName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.FunctionName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.NewFunctionName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NewFunctionName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.NewFunctionName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *RenameSchema) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.SchemaName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SchemaName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.SchemaName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.NewSchemaName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NewSchemaName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.NewSchemaName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *RenameTable) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.NewTableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NewTableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.NewTableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *RenameType) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TypeName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TypeName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TypeName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.NewTypeName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NewTypeName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.NewTypeName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *Restore) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonJobEventDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *ReverseSchemaChange) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSchemaChangeEventDetails.AppendJSONFields(printComma, b)

	if m.Error != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Error\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Error)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.SQLSTATE != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SQLSTATE\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.SQLSTATE)))
		b = append(b, '"')
	}

	if m.LatencyNanos != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"LatencyNanos\":"...)
		b = strconv.AppendInt(b, int64(m.LatencyNanos), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *RoleBasedAuditEvent) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLExecDetails.AppendJSONFields(printComma, b)

	if m.Role != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Role\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Role)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *RuntimeStats) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	if m.MemRSSBytes != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MemRSSBytes\":"...)
		b = strconv.AppendUint(b, uint64(m.MemRSSBytes), 10)
	}

	if m.GoroutineCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"GoroutineCount\":"...)
		b = strconv.AppendUint(b, uint64(m.GoroutineCount), 10)
	}

	if m.MemStackSysBytes != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MemStackSysBytes\":"...)
		b = strconv.AppendUint(b, uint64(m.MemStackSysBytes), 10)
	}

	if m.GoAllocBytes != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"GoAllocBytes\":"...)
		b = strconv.AppendUint(b, uint64(m.GoAllocBytes), 10)
	}

	if m.GoTotalBytes != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"GoTotalBytes\":"...)
		b = strconv.AppendUint(b, uint64(m.GoTotalBytes), 10)
	}

	if m.GoStatsStaleness != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"GoStatsStaleness\":"...)
		b = strconv.AppendFloat(b, float64(m.GoStatsStaleness), 'f', -1, 32)
	}

	if m.HeapFragmentBytes != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"HeapFragmentBytes\":"...)
		b = strconv.AppendUint(b, uint64(m.HeapFragmentBytes), 10)
	}

	if m.HeapReservedBytes != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"HeapReservedBytes\":"...)
		b = strconv.AppendUint(b, uint64(m.HeapReservedBytes), 10)
	}

	if m.HeapReleasedBytes != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"HeapReleasedBytes\":"...)
		b = strconv.AppendUint(b, uint64(m.HeapReleasedBytes), 10)
	}

	if m.CGoAllocBytes != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CGoAllocBytes\":"...)
		b = strconv.AppendUint(b, uint64(m.CGoAllocBytes), 10)
	}

	if m.CGoTotalBytes != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CGoTotalBytes\":"...)
		b = strconv.AppendUint(b, uint64(m.CGoTotalBytes), 10)
	}

	if m.CGoCallRate != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CGoCallRate\":"...)
		b = strconv.AppendFloat(b, float64(m.CGoCallRate), 'f', -1, 32)
	}

	if m.CPUUserPercent != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CPUUserPercent\":"...)
		b = strconv.AppendFloat(b, float64(m.CPUUserPercent), 'f', -1, 32)
	}

	if m.CPUSysPercent != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CPUSysPercent\":"...)
		b = strconv.AppendFloat(b, float64(m.CPUSysPercent), 'f', -1, 32)
	}

	if m.GCPausePercent != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"GCPausePercent\":"...)
		b = strconv.AppendFloat(b, float64(m.GCPausePercent), 'f', -1, 32)
	}

	if m.GCRunCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"GCRunCount\":"...)
		b = strconv.AppendUint(b, uint64(m.GCRunCount), 10)
	}

	if m.NetHostRecvBytes != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NetHostRecvBytes\":"...)
		b = strconv.AppendUint(b, uint64(m.NetHostRecvBytes), 10)
	}

	if m.NetHostSendBytes != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NetHostSendBytes\":"...)
		b = strconv.AppendUint(b, uint64(m.NetHostSendBytes), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *SampledExecStats) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"NetworkBytes\":"...)
	b = strconv.AppendInt(b, int64(m.NetworkBytes), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"MaxMemUsage\":"...)
	b = strconv.AppendInt(b, int64(m.MaxMemUsage), 10)

	if m.ContentionTime != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ContentionTime\":"...)
		b = strconv.AppendInt(b, int64(m.ContentionTime), 10)
	}

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"NetworkMessages\":"...)
	b = strconv.AppendInt(b, int64(m.NetworkMessages), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"MaxDiskUsage\":"...)
	b = strconv.AppendInt(b, int64(m.MaxDiskUsage), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"CPUSQLNanos\":"...)
	b = strconv.AppendInt(b, int64(m.CPUSQLNanos), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"MVCCIteratorStats\":"...)
	b = append(b, '{')
	printComma, b = m.MVCCIteratorStats.AppendJSONFields(false, b)
	b = append(b, '}')

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *SampledQuery) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLExecDetails.AppendJSONFields(printComma, b)

	if m.SkippedQueries != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SkippedQueries\":"...)
		b = strconv.AppendUint(b, uint64(m.SkippedQueries), 10)
	}

	if m.CostEstimate != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CostEstimate\":"...)
		b = strconv.AppendFloat(b, float64(m.CostEstimate), 'f', -1, 64)
	}

	if m.Distribution != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Distribution\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.Distribution)))
		b = append(b, '"')
	}

	if m.PlanGist != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"PlanGist\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.PlanGist)))
		b = append(b, '"')
	}

	if m.SessionID != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SessionID\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.SessionID)))
		b = append(b, '"')
	}

	if m.Database != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Database\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.Database)))
		b = append(b, '"')
	}

	if m.StatementID != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"StatementID\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.StatementID)))
		b = append(b, '"')
	}

	if m.TransactionID != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TransactionID\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.TransactionID)))
		b = append(b, '"')
	}

	if m.MaxFullScanRowsEstimate != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MaxFullScanRowsEstimate\":"...)
		b = strconv.AppendFloat(b, float64(m.MaxFullScanRowsEstimate), 'f', -1, 64)
	}

	if m.TotalScanRowsEstimate != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TotalScanRowsEstimate\":"...)
		b = strconv.AppendFloat(b, float64(m.TotalScanRowsEstimate), 'f', -1, 64)
	}

	if m.OutputRowsEstimate != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"OutputRowsEstimate\":"...)
		b = strconv.AppendFloat(b, float64(m.OutputRowsEstimate), 'f', -1, 64)
	}

	if m.StatsAvailable {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"StatsAvailable\":"...)
		b = strconv.AppendBool(b, m.StatsAvailable)
	}

	if m.NanosSinceStatsCollected != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NanosSinceStatsCollected\":"...)
		b = strconv.AppendInt(b, int64(m.NanosSinceStatsCollected), 10)
	}

	if m.BytesRead != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"BytesRead\":"...)
		b = strconv.AppendInt(b, int64(m.BytesRead), 10)
	}

	if m.RowsRead != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RowsRead\":"...)
		b = strconv.AppendInt(b, int64(m.RowsRead), 10)
	}

	if m.RowsWritten != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RowsWritten\":"...)
		b = strconv.AppendInt(b, int64(m.RowsWritten), 10)
	}

	if m.InnerJoinCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"InnerJoinCount\":"...)
		b = strconv.AppendInt(b, int64(m.InnerJoinCount), 10)
	}

	if m.LeftOuterJoinCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"LeftOuterJoinCount\":"...)
		b = strconv.AppendInt(b, int64(m.LeftOuterJoinCount), 10)
	}

	if m.FullOuterJoinCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"FullOuterJoinCount\":"...)
		b = strconv.AppendInt(b, int64(m.FullOuterJoinCount), 10)
	}

	if m.SemiJoinCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SemiJoinCount\":"...)
		b = strconv.AppendInt(b, int64(m.SemiJoinCount), 10)
	}

	if m.AntiJoinCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"AntiJoinCount\":"...)
		b = strconv.AppendInt(b, int64(m.AntiJoinCount), 10)
	}

	if m.IntersectAllJoinCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IntersectAllJoinCount\":"...)
		b = strconv.AppendInt(b, int64(m.IntersectAllJoinCount), 10)
	}

	if m.ExceptAllJoinCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ExceptAllJoinCount\":"...)
		b = strconv.AppendInt(b, int64(m.ExceptAllJoinCount), 10)
	}

	if m.HashJoinCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"HashJoinCount\":"...)
		b = strconv.AppendInt(b, int64(m.HashJoinCount), 10)
	}

	if m.CrossJoinCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CrossJoinCount\":"...)
		b = strconv.AppendInt(b, int64(m.CrossJoinCount), 10)
	}

	if m.IndexJoinCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IndexJoinCount\":"...)
		b = strconv.AppendInt(b, int64(m.IndexJoinCount), 10)
	}

	if m.LookupJoinCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"LookupJoinCount\":"...)
		b = strconv.AppendInt(b, int64(m.LookupJoinCount), 10)
	}

	if m.MergeJoinCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MergeJoinCount\":"...)
		b = strconv.AppendInt(b, int64(m.MergeJoinCount), 10)
	}

	if m.InvertedJoinCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"InvertedJoinCount\":"...)
		b = strconv.AppendInt(b, int64(m.InvertedJoinCount), 10)
	}

	if m.ApplyJoinCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ApplyJoinCount\":"...)
		b = strconv.AppendInt(b, int64(m.ApplyJoinCount), 10)
	}

	if m.ZigZagJoinCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ZigZagJoinCount\":"...)
		b = strconv.AppendInt(b, int64(m.ZigZagJoinCount), 10)
	}

	if m.ContentionNanos != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ContentionNanos\":"...)
		b = strconv.AppendInt(b, int64(m.ContentionNanos), 10)
	}

	if len(m.Regions) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Regions\":["...)
		for i, v := range m.Regions {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), v))
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	if m.NetworkBytesSent != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NetworkBytesSent\":"...)
		b = strconv.AppendInt(b, int64(m.NetworkBytesSent), 10)
	}

	if m.MaxMemUsage != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MaxMemUsage\":"...)
		b = strconv.AppendInt(b, int64(m.MaxMemUsage), 10)
	}

	if m.MaxDiskUsage != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MaxDiskUsage\":"...)
		b = strconv.AppendInt(b, int64(m.MaxDiskUsage), 10)
	}

	if m.KVBytesRead != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"KVBytesRead\":"...)
		b = strconv.AppendInt(b, int64(m.KVBytesRead), 10)
	}

	if m.KVPairsRead != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"KVPairsRead\":"...)
		b = strconv.AppendInt(b, int64(m.KVPairsRead), 10)
	}

	if m.KVRowsRead != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"KVRowsRead\":"...)
		b = strconv.AppendInt(b, int64(m.KVRowsRead), 10)
	}

	if m.NetworkMessages != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NetworkMessages\":"...)
		b = strconv.AppendInt(b, int64(m.NetworkMessages), 10)
	}

	if len(m.IndexRecommendations) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IndexRecommendations\":["...)
		for i, v := range m.IndexRecommendations {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), v))
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	if m.ScanCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ScanCount\":"...)
		b = strconv.AppendInt(b, int64(m.ScanCount), 10)
	}

	if m.ScanWithStatsCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ScanWithStatsCount\":"...)
		b = strconv.AppendInt(b, int64(m.ScanWithStatsCount), 10)
	}

	if m.ScanWithStatsForecastCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ScanWithStatsForecastCount\":"...)
		b = strconv.AppendInt(b, int64(m.ScanWithStatsForecastCount), 10)
	}

	if m.TotalScanRowsWithoutForecastsEstimate != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TotalScanRowsWithoutForecastsEstimate\":"...)
		b = strconv.AppendFloat(b, float64(m.TotalScanRowsWithoutForecastsEstimate), 'f', -1, 64)
	}

	if m.NanosSinceStatsForecasted != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NanosSinceStatsForecasted\":"...)
		b = strconv.AppendInt(b, int64(m.NanosSinceStatsForecasted), 10)
	}

	if len(m.Indexes) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Indexes\":["...)
		for i, v := range m.Indexes {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), v))
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	if m.CpuTimeNanos != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CpuTimeNanos\":"...)
		b = strconv.AppendInt(b, int64(m.CpuTimeNanos), 10)
	}

	if m.KvGrpcCalls != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"KvGrpcCalls\":"...)
		b = strconv.AppendInt(b, int64(m.KvGrpcCalls), 10)
	}

	if m.KvTimeNanos != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"KvTimeNanos\":"...)
		b = strconv.AppendInt(b, int64(m.KvTimeNanos), 10)
	}

	if m.ServiceLatencyNanos != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ServiceLatencyNanos\":"...)
		b = strconv.AppendInt(b, int64(m.ServiceLatencyNanos), 10)
	}

	if m.OverheadLatencyNanos != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"OverheadLatencyNanos\":"...)
		b = strconv.AppendInt(b, int64(m.OverheadLatencyNanos), 10)
	}

	if m.RunLatencyNanos != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RunLatencyNanos\":"...)
		b = strconv.AppendInt(b, int64(m.RunLatencyNanos), 10)
	}

	if m.PlanLatencyNanos != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"PlanLatencyNanos\":"...)
		b = strconv.AppendInt(b, int64(m.PlanLatencyNanos), 10)
	}

	if m.IdleLatencyNanos != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IdleLatencyNanos\":"...)
		b = strconv.AppendInt(b, int64(m.IdleLatencyNanos), 10)
	}

	if m.ParseLatencyNanos != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ParseLatencyNanos\":"...)
		b = strconv.AppendInt(b, int64(m.ParseLatencyNanos), 10)
	}

	if m.MvccStepCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MvccStepCount\":"...)
		b = strconv.AppendInt(b, int64(m.MvccStepCount), 10)
	}

	if m.MvccStepCountInternal != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MvccStepCountInternal\":"...)
		b = strconv.AppendInt(b, int64(m.MvccStepCountInternal), 10)
	}

	if m.MvccSeekCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MvccSeekCount\":"...)
		b = strconv.AppendInt(b, int64(m.MvccSeekCount), 10)
	}

	if m.MvccSeekCountInternal != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MvccSeekCountInternal\":"...)
		b = strconv.AppendInt(b, int64(m.MvccSeekCountInternal), 10)
	}

	if m.MvccBlockBytes != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MvccBlockBytes\":"...)
		b = strconv.AppendInt(b, int64(m.MvccBlockBytes), 10)
	}

	if m.MvccBlockBytesInCache != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MvccBlockBytesInCache\":"...)
		b = strconv.AppendInt(b, int64(m.MvccBlockBytesInCache), 10)
	}

	if m.MvccKeyBytes != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MvccKeyBytes\":"...)
		b = strconv.AppendInt(b, int64(m.MvccKeyBytes), 10)
	}

	if m.MvccValueBytes != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MvccValueBytes\":"...)
		b = strconv.AppendInt(b, int64(m.MvccValueBytes), 10)
	}

	if m.MvccPointCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MvccPointCount\":"...)
		b = strconv.AppendInt(b, int64(m.MvccPointCount), 10)
	}

	if m.MvccPointsCoveredByRangeTombstones != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MvccPointsCoveredByRangeTombstones\":"...)
		b = strconv.AppendInt(b, int64(m.MvccPointsCoveredByRangeTombstones), 10)
	}

	if m.MvccRangeKeyCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MvccRangeKeyCount\":"...)
		b = strconv.AppendInt(b, int64(m.MvccRangeKeyCount), 10)
	}

	if m.MvccRangeKeyContainedPoints != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MvccRangeKeyContainedPoints\":"...)
		b = strconv.AppendInt(b, int64(m.MvccRangeKeyContainedPoints), 10)
	}

	if m.MvccRangeKeySkippedPoints != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MvccRangeKeySkippedPoints\":"...)
		b = strconv.AppendInt(b, int64(m.MvccRangeKeySkippedPoints), 10)
	}

	if m.SchemaChangerMode != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SchemaChangerMode\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.SchemaChangerMode)))
		b = append(b, '"')
	}

	if len(m.SQLInstanceIDs) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SQLInstanceIDs\":["...)
		for i, v := range m.SQLInstanceIDs {
			if i > 0 {
				b = append(b, ',')
			}
			b = strconv.AppendInt(b, int64(v), 10)
		}
		b = append(b, ']')
	}

	if len(m.KVNodeIDs) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"KVNodeIDs\":["...)
		for i, v := range m.KVNodeIDs {
			if i > 0 {
				b = append(b, ',')
			}
			b = strconv.AppendInt(b, int64(v), 10)
		}
		b = append(b, ']')
	}

	if m.StatementFingerprintID != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"StatementFingerprintID\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.StatementFingerprintID)))
		b = append(b, '"')
	}

	if m.UsedFollowerRead {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"UsedFollowerRead\":"...)
		b = strconv.AppendBool(b, m.UsedFollowerRead)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *SampledTransaction) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"User\":\""...)

	if safeRe1.MatchString(m.User) {
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.User)))))
	} else {
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.User)))))
		b = append(b, redact.EndMarker()...)
	}
	b = append(b, '"')

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"ApplicationName\":\""...)
	b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.ApplicationName)))
	b = append(b, '"')

	if m.TxnCounter != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TxnCounter\":"...)
		b = strconv.AppendUint(b, uint64(m.TxnCounter), 10)
	}

	if m.SessionID != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SessionID\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.SessionID)))
		b = append(b, '"')
	}

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"TransactionID\":\""...)
	b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.TransactionID)))
	b = append(b, '"')

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"Committed\":"...)
	b = strconv.AppendBool(b, m.Committed)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"ImplicitTxn\":"...)
	b = strconv.AppendBool(b, m.ImplicitTxn)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"StartTimeUnixNanos\":"...)
	b = strconv.AppendInt(b, int64(m.StartTimeUnixNanos), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"EndTimeUnixNanos\":"...)
	b = strconv.AppendInt(b, int64(m.EndTimeUnixNanos), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"ServiceLatNanos\":"...)
	b = strconv.AppendInt(b, int64(m.ServiceLatNanos), 10)

	if m.SQLSTATE != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SQLSTATE\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.SQLSTATE)))
		b = append(b, '"')
	}

	if m.ErrorText != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ErrorText\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.ErrorText)))
		b = append(b, '"')
	}

	if m.NumRetries != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NumRetries\":"...)
		b = strconv.AppendInt(b, int64(m.NumRetries), 10)
	}

	if m.LastAutoRetryReason != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"LastAutoRetryReason\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.LastAutoRetryReason)))
		b = append(b, '"')
	}

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"NumRows\":"...)
	b = strconv.AppendInt(b, int64(m.NumRows), 10)

	if m.RetryLatNanos != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RetryLatNanos\":"...)
		b = strconv.AppendInt(b, int64(m.RetryLatNanos), 10)
	}

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"CommitLatNanos\":"...)
	b = strconv.AppendInt(b, int64(m.CommitLatNanos), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"IdleLatNanos\":"...)
	b = strconv.AppendInt(b, int64(m.IdleLatNanos), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"BytesRead\":"...)
	b = strconv.AppendInt(b, int64(m.BytesRead), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"RowsRead\":"...)
	b = strconv.AppendInt(b, int64(m.RowsRead), 10)

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"RowsWritten\":"...)
	b = strconv.AppendInt(b, int64(m.RowsWritten), 10)

	if m.SampledExecStats != nil {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SampledExecStats\":"...)
		b = append(b, '{')
		printComma, b = m.SampledExecStats.AppendJSONFields(false, b)
		b = append(b, '}')
	}

	if m.SkippedTransactions != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SkippedTransactions\":"...)
		b = strconv.AppendInt(b, int64(m.SkippedTransactions), 10)
	}

	if m.TransactionFingerprintID != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TransactionFingerprintID\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.TransactionFingerprintID)))
		b = append(b, '"')
	}

	if len(m.StatementFingerprintIDs) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"StatementFingerprintIDs\":["...)
		for i, v := range m.StatementFingerprintIDs {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), v))
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *SchemaDescriptor) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	if m.SnapshotID != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SnapshotID\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.SnapshotID)))
		b = append(b, '"')
	}

	if m.ParentDatabaseID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ParentDatabaseID\":"...)
		b = strconv.AppendUint(b, uint64(m.ParentDatabaseID), 10)
	}

	if m.ParentSchemaID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ParentSchemaID\":"...)
		b = strconv.AppendUint(b, uint64(m.ParentSchemaID), 10)
	}

	if m.Name != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Name\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.Name)))
		b = append(b, '"')
	}

	if m.DescID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DescID\":"...)
		b = strconv.AppendUint(b, uint64(m.DescID), 10)
	}

	if m.Desc != nil {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		jsonEncoder := jsonpb.Marshaler{}
		if str, err := jsonEncoder.MarshalToString(m.Desc); err == nil {
			b = append(b, "\"Desc\":"...)
			b = append(b, []byte(str)...)
		}
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *SchemaSnapshotMetadata) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	if m.SnapshotID != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SnapshotID\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.SnapshotID)))
		b = append(b, '"')
	}

	if m.NumRecords != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NumRecords\":"...)
		b = strconv.AppendUint(b, uint64(m.NumRecords), 10)
	}

	if m.AsOfTimestamp != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"AsOfTimestamp\":"...)
		b = strconv.AppendInt(b, int64(m.AsOfTimestamp), 10)
	}

	if len(m.Errors) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Errors\":["...)
		for i, v := range m.Errors {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '"')
			b = append(b, redact.StartMarker()...)
			b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(v)))))
			b = append(b, redact.EndMarker()...)
			b = append(b, '"')
		}
		b = append(b, ']')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *SensitiveTableAccess) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLExecDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.AccessMode != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"AccessMode\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.AccessMode)))
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *SetClusterSetting) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.SettingName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SettingName\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.SettingName)))
		b = append(b, '"')
	}

	if m.Value != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Value\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Value)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *SetSchema) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.DescriptorName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DescriptorName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.DescriptorName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.NewDescriptorName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NewDescriptorName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.NewDescriptorName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.DescriptorType != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"DescriptorType\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.DescriptorType)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *SetTenantClusterSetting) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.SettingName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"SettingName\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.SettingName)))
		b = append(b, '"')
	}

	if m.Value != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Value\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Value)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.TenantId != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TenantId\":"...)
		b = strconv.AppendUint(b, uint64(m.TenantId), 10)
	}

	if m.AllTenants {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"AllTenants\":"...)
		b = strconv.AppendBool(b, m.AllTenants)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *SetZoneConfig) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonZoneConfigDetails.AppendJSONFields(printComma, b)

	if m.ResolvedOldConfig != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ResolvedOldConfig\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.ResolvedOldConfig)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *SlowQuery) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLExecDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *SlowQueryInternal) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLExecDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *StatusChange) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	if m.JobID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"JobID\":"...)
		b = strconv.AppendInt(b, int64(m.JobID), 10)
	}

	if m.JobType != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"JobType\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.JobType)))
		b = append(b, '"')
	}

	if m.Description != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Description\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.Description)))
		b = append(b, '"')
	}

	if m.PreviousStatus != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"PreviousStatus\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.PreviousStatus)))
		b = append(b, '"')
	}

	if m.NewStatus != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NewStatus\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.NewStatus)))
		b = append(b, '"')
	}

	if printComma {
		b = append(b, ',')
	}
	printComma = true
	b = append(b, "\"RunNum\":"...)
	b = strconv.AppendInt(b, int64(m.RunNum), 10)

	if m.Error != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Error\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Error)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.FinalResumeErr != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"FinalResumeErr\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.FinalResumeErr)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *StoreStats) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	if m.NodeId != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NodeId\":"...)
		b = strconv.AppendInt(b, int64(m.NodeId), 10)
	}

	if m.StoreId != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"StoreId\":"...)
		b = strconv.AppendInt(b, int64(m.StoreId), 10)
	}

	if len(m.Levels) > 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Levels\":["...)
		for i, l := range m.Levels {
			if i > 0 {
				b = append(b, ',')
			}
			b = append(b, '{')
			printComma, b = l.AppendJSONFields(false, b)
			b = append(b, '}')
		}
		b = append(b, ']')
	}

	if m.CacheSize != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CacheSize\":"...)
		b = strconv.AppendInt(b, int64(m.CacheSize), 10)
	}

	if m.CacheCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CacheCount\":"...)
		b = strconv.AppendInt(b, int64(m.CacheCount), 10)
	}

	if m.CacheHits != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CacheHits\":"...)
		b = strconv.AppendInt(b, int64(m.CacheHits), 10)
	}

	if m.CacheMisses != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CacheMisses\":"...)
		b = strconv.AppendInt(b, int64(m.CacheMisses), 10)
	}

	if m.CompactionCountDefault != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CompactionCountDefault\":"...)
		b = strconv.AppendInt(b, int64(m.CompactionCountDefault), 10)
	}

	if m.CompactionCountDeleteOnly != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CompactionCountDeleteOnly\":"...)
		b = strconv.AppendInt(b, int64(m.CompactionCountDeleteOnly), 10)
	}

	if m.CompactionCountElisionOnly != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CompactionCountElisionOnly\":"...)
		b = strconv.AppendInt(b, int64(m.CompactionCountElisionOnly), 10)
	}

	if m.CompactionCountMove != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CompactionCountMove\":"...)
		b = strconv.AppendInt(b, int64(m.CompactionCountMove), 10)
	}

	if m.CompactionCountRead != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CompactionCountRead\":"...)
		b = strconv.AppendInt(b, int64(m.CompactionCountRead), 10)
	}

	if m.CompactionCountRewrite != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CompactionCountRewrite\":"...)
		b = strconv.AppendInt(b, int64(m.CompactionCountRewrite), 10)
	}

	if m.CompactionNumInProgress != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CompactionNumInProgress\":"...)
		b = strconv.AppendInt(b, int64(m.CompactionNumInProgress), 10)
	}

	if m.CompactionMarkedFiles != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"CompactionMarkedFiles\":"...)
		b = strconv.AppendInt(b, int64(m.CompactionMarkedFiles), 10)
	}

	if m.FlushCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"FlushCount\":"...)
		b = strconv.AppendInt(b, int64(m.FlushCount), 10)
	}

	if m.FlushIngestCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"FlushIngestCount\":"...)
		b = strconv.AppendUint(b, uint64(m.FlushIngestCount), 10)
	}

	if m.FlushIngestTableCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"FlushIngestTableCount\":"...)
		b = strconv.AppendUint(b, uint64(m.FlushIngestTableCount), 10)
	}

	if m.FlushIngestTableBytes != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"FlushIngestTableBytes\":"...)
		b = strconv.AppendUint(b, uint64(m.FlushIngestTableBytes), 10)
	}

	if m.IngestCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"IngestCount\":"...)
		b = strconv.AppendUint(b, uint64(m.IngestCount), 10)
	}

	if m.MemtableSize != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MemtableSize\":"...)
		b = strconv.AppendUint(b, uint64(m.MemtableSize), 10)
	}

	if m.MemtableCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MemtableCount\":"...)
		b = strconv.AppendInt(b, int64(m.MemtableCount), 10)
	}

	if m.MemtableZombieCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MemtableZombieCount\":"...)
		b = strconv.AppendInt(b, int64(m.MemtableZombieCount), 10)
	}

	if m.MemtableZombieSize != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"MemtableZombieSize\":"...)
		b = strconv.AppendUint(b, uint64(m.MemtableZombieSize), 10)
	}

	if m.WalLiveCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"WalLiveCount\":"...)
		b = strconv.AppendInt(b, int64(m.WalLiveCount), 10)
	}

	if m.WalLiveSize != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"WalLiveSize\":"...)
		b = strconv.AppendUint(b, uint64(m.WalLiveSize), 10)
	}

	if m.WalObsoleteCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"WalObsoleteCount\":"...)
		b = strconv.AppendInt(b, int64(m.WalObsoleteCount), 10)
	}

	if m.WalObsoleteSize != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"WalObsoleteSize\":"...)
		b = strconv.AppendUint(b, uint64(m.WalObsoleteSize), 10)
	}

	if m.WalPhysicalSize != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"WalPhysicalSize\":"...)
		b = strconv.AppendUint(b, uint64(m.WalPhysicalSize), 10)
	}

	if m.WalBytesIn != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"WalBytesIn\":"...)
		b = strconv.AppendUint(b, uint64(m.WalBytesIn), 10)
	}

	if m.WalBytesWritten != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"WalBytesWritten\":"...)
		b = strconv.AppendUint(b, uint64(m.WalBytesWritten), 10)
	}

	if m.TableObsoleteCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableObsoleteCount\":"...)
		b = strconv.AppendInt(b, int64(m.TableObsoleteCount), 10)
	}

	if m.TableObsoleteSize != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableObsoleteSize\":"...)
		b = strconv.AppendUint(b, uint64(m.TableObsoleteSize), 10)
	}

	if m.TableZombieCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableZombieCount\":"...)
		b = strconv.AppendInt(b, int64(m.TableZombieCount), 10)
	}

	if m.TableZombieSize != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableZombieSize\":"...)
		b = strconv.AppendUint(b, uint64(m.TableZombieSize), 10)
	}

	if m.RangeKeySetsCount != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"RangeKeySetsCount\":"...)
		b = strconv.AppendUint(b, uint64(m.RangeKeySetsCount), 10)
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *TenantSharedServiceStart) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSharedServiceEventDetails.AppendJSONFields(printComma, b)

	if m.OK {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"OK\":"...)
		b = strconv.AppendBool(b, m.OK)
	}

	if m.ErrorText != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ErrorText\":\""...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(m.ErrorText)))
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *TenantSharedServiceStop) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSharedServiceEventDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *TruncateTable) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.TableName != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"TableName\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.TableName)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *TxnRowsReadLimit) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonTxnRowsLimitDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *TxnRowsReadLimitInternal) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonTxnRowsLimitDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *TxnRowsWrittenLimit) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonTxnRowsLimitDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *TxnRowsWrittenLimitInternal) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonTxnRowsLimitDetails.AppendJSONFields(printComma, b)

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *UnsafeDeleteDescriptor) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.ParentID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ParentID\":"...)
		b = strconv.AppendUint(b, uint64(m.ParentID), 10)
	}

	if m.ParentSchemaID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ParentSchemaID\":"...)
		b = strconv.AppendUint(b, uint64(m.ParentSchemaID), 10)
	}

	if m.Name != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Name\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Name)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Force {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Force\":"...)
		b = strconv.AppendBool(b, m.Force)
	}

	if m.ForceNotice != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ForceNotice\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.ForceNotice)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *UnsafeDeleteNamespaceEntry) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.ParentID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ParentID\":"...)
		b = strconv.AppendUint(b, uint64(m.ParentID), 10)
	}

	if m.ParentSchemaID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ParentSchemaID\":"...)
		b = strconv.AppendUint(b, uint64(m.ParentSchemaID), 10)
	}

	if m.Name != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Name\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Name)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Force {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Force\":"...)
		b = strconv.AppendBool(b, m.Force)
	}

	if m.ForceNotice != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ForceNotice\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.ForceNotice)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *UnsafeUpsertDescriptor) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.PreviousDescriptor != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"PreviousDescriptor\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.PreviousDescriptor)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.NewDescriptor != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"NewDescriptor\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.NewDescriptor)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.Force {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Force\":"...)
		b = strconv.AppendBool(b, m.Force)
	}

	if m.ForceNotice != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ForceNotice\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.ForceNotice)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}

// AppendJSONFields implements the EventPayload interface.
func (m *UnsafeUpsertNamespaceEntry) AppendJSONFields(printComma bool, b redact.RedactableBytes) (bool, redact.RedactableBytes) {

	printComma, b = m.CommonEventDetails.AppendJSONFields(printComma, b)

	printComma, b = m.CommonSQLEventDetails.AppendJSONFields(printComma, b)

	if m.ParentID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ParentID\":"...)
		b = strconv.AppendUint(b, uint64(m.ParentID), 10)
	}

	if m.ParentSchemaID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ParentSchemaID\":"...)
		b = strconv.AppendUint(b, uint64(m.ParentSchemaID), 10)
	}

	if m.Name != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Name\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.Name)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	if m.PreviousID != 0 {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"PreviousID\":"...)
		b = strconv.AppendUint(b, uint64(m.PreviousID), 10)
	}

	if m.Force {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"Force\":"...)
		b = strconv.AppendBool(b, m.Force)
	}

	if m.FailedValidation {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"FailedValidation\":"...)
		b = strconv.AppendBool(b, m.FailedValidation)
	}

	if m.ValidationErrors != "" {
		if printComma {
			b = append(b, ',')
		}
		printComma = true
		b = append(b, "\"ValidationErrors\":\""...)
		b = append(b, redact.StartMarker()...)
		b = redact.RedactableBytes(jsonbytes.EncodeString([]byte(b), string(redact.EscapeMarkers([]byte(m.ValidationErrors)))))
		b = append(b, redact.EndMarker()...)
		b = append(b, '"')
	}

	return printComma, b
}
