// Code generated by gen/main.go. DO NOT EDIT.

package channel

import "github.com/cockroachdb/cockroach/pkg/util/log/logpb"

// DEV is used during development to collect log
// details useful for troubleshooting that fall outside the
// scope of other channels. It is also the default logging
// channel for events not associated with a channel.
//
// This channel is special in that there are no constraints as to
// what may or may not be logged on it. Conversely, users in
// production deployments are invited to not collect `DEV` logs in
// centralized logging facilities, because they likely contain
// sensitive operational data.
// See [Configure logs](configure-logs.html#dev-channel).
const DEV = logpb.Channel_DEV

// OPS is used to report "point" operational events,
// initiated by user operators or automation:
//
//   - Operator or system actions on server processes: process starts,
//     stops, shutdowns, crashes (if they can be logged),
//     including each time: command-line parameters, current version being run
//   - Actions that impact the topology of a cluster: node additions,
//     removals, decommissions, etc.
//   - Job-related initiation or termination
//   - [Cluster setting](cluster-settings.html) changes
//   - [Zone configuration](configure-replication-zones.html) changes
const OPS = logpb.Channel_OPS

// HEALTH is used to report "background" operational
// events, initiated by CockroachDB or reporting on automatic processes:
//
//   - Current resource usage, including critical resource usage
//   - Node-node connection events, including connection errors and
//     gossip details
//   - Range and table leasing events
//   - Up- and down-replication, range unavailability
const HEALTH = logpb.Channel_HEALTH

// STORAGE is used to report low-level storage
// layer events (RocksDB/Pebble).
const STORAGE = logpb.Channel_STORAGE

// SESSIONS is used to report client network activity when enabled via
// the `server.auth_log.sql_connections.enabled` and/or
// `server.auth_log.sql_sessions.enabled` [cluster setting](cluster-settings.html):
//
//   - Connections opened/closed
//   - Authentication events: logins, failed attempts
//   - Session and query cancellation
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
const SESSIONS = logpb.Channel_SESSIONS

// SQL_SCHEMA is used to report changes to the
// SQL logical schema, excluding privilege and ownership changes
// (which are reported separately on the `PRIVILEGES` channel) and
// zone configuration changes (which go to the `OPS` channel).
//
// This includes:
//
//   - Database/schema/table/sequence/view/type creation
//   - Adding/removing/changing table columns
//   - Changing sequence parameters
//
// `SQL_SCHEMA` events generally comprise changes to the schema that affect the
// functional behavior of client apps using stored objects.
const SQL_SCHEMA = logpb.Channel_SQL_SCHEMA

// USER_ADMIN is used to report changes
// in users and roles, including:
//
//   - Users added/dropped
//   - Changes to authentication credentials (e.g., passwords, validity, etc.)
//   - Role grants/revocations
//   - Role option grants/revocations
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
const USER_ADMIN = logpb.Channel_USER_ADMIN

// PRIVILEGES is used to report data
// authorization changes, including:
//
//   - Privilege grants/revocations on database, objects, etc.
//   - Object ownership changes
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
const PRIVILEGES = logpb.Channel_PRIVILEGES

// SENSITIVE_ACCESS is used to report SQL
// data access to sensitive data:
//
//   - Data access audit events (when table audit is enabled via
//     [ALTER TABLE ... EXPERIMENTAL_AUDIT](alter-table.html#experimental_audit))
//   - Data access audit events (when role-based audit is enabled via
//     [`sql.log.user_audit` cluster setting](role-based-audit-logging.html#syntax-of-audit-settings))
//   - SQL statements executed by users with the admin role
//   - Operations that write to system tables
//
// This is typically configured in "audit" mode, with event
// numbering and synchronous writes.
const SENSITIVE_ACCESS = logpb.Channel_SENSITIVE_ACCESS

// SQL_EXEC is used to report SQL execution on
// behalf of client connections:
//
//   - Logical SQL statement executions (when enabled via the
//     `sql.log.all_statements.enabled` [cluster setting](cluster-settings.html))
//   - uncaught Go panic errors during the execution of a SQL statement.
const SQL_EXEC = logpb.Channel_SQL_EXEC

// SQL_PERF is used to report SQL executions
// that are marked as "out of the ordinary"
// to facilitate performance investigations.
// This includes the SQL "slow query log".
//
// Arguably, this channel overlaps with `SQL_EXEC`.
// However, we keep both channels separate for backward compatibility
// with versions prior to v21.1, where the corresponding events
// were redirected to separate files.
const SQL_PERF = logpb.Channel_SQL_PERF

// SQL_INTERNAL_PERF is like the `SQL_PERF` channel, but is aimed at
// helping developers of CockroachDB itself. It exists as a separate
// channel so as to not pollute the `SQL_PERF` logging output with
// internal troubleshooting details.
const SQL_INTERNAL_PERF = logpb.Channel_SQL_INTERNAL_PERF

// TELEMETRY reports telemetry events. Telemetry events describe
// feature usage within CockroachDB and anonymizes any application-
// specific data.
const TELEMETRY = logpb.Channel_TELEMETRY

// KV_DISTRIBUTION is used to report data distribution events, such as moving
// replicas between stores in the cluster, or adding (removing) replicas to
// ranges.
const KV_DISTRIBUTION = logpb.Channel_KV_DISTRIBUTION
