// Copyright 2024 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// DO NOT EDIT THIS FILE. Utils in this file will be deleted - they
// are only to support components in this directory, which will be
// replaced with imports from a shared CRDB UI library.

import filter from "lodash/fp/filter";
import flow from "lodash/fp/flow";
import join from "lodash/fp/join";
import map from "lodash/fp/map";
import split from "lodash/fp/split";
import uniq from "lodash/fp/uniq";
import isEmpty from "lodash/isEmpty";
import negate from "lodash/negate";

const appendSuffix = (suffix: string) => (string: string) =>
  `${string}${suffix}`;

const containerSuffix = appendSuffix("__container");

export const generateContainerClassnames = (className = ""): string =>
  flow([
    split(" "),
    filter(negate(isEmpty)),
    map(containerSuffix),
    uniq,
    join(" "),
  ])(className);

export default generateContainerClassnames;
