// Copyright 2021 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package grpcstatuswithdetails

import "github.com/cockroachdb/cockroach/pkg/testutils/lint/passes/forbiddenmethod"

// Analyzer checks that we don't use Status.WithDetails(), since it does not
// support Protobufs generated by gogoproto. This is because it uses an Any
// field to store details, with a reference to the type, but gogoproto types
// are not registered with the standard Protobuf type registry and are
// therefore unknown to the unmarshaler.
// (Exported from forbiddenmethod.)
var Analyzer = forbiddenmethod.GRPCStatusWithDetailsAnalyzer
