// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package tree

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[Ack-0]
	_ = x[DDL-1]
	_ = x[RowsAffected-2]
	_ = x[Rows-3]
	_ = x[CopyIn-4]
	_ = x[CopyOut-5]
	_ = x[Replication-6]
	_ = x[Unknown-7]
}

func (i StatementReturnType) String() string {
	switch i {
	case Ack:
		return "Ack"
	case DDL:
		return "DDL"
	case RowsAffected:
		return "RowsAffected"
	case Rows:
		return "Rows"
	case CopyIn:
		return "CopyIn"
	case CopyOut:
		return "CopyOut"
	case Replication:
		return "Replication"
	case Unknown:
		return "Unknown"
	default:
		return "StatementReturnType(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
