// Copyright 2022 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by eval_gen.go. DO NOT EDIT.
// Regenerate this file with either of the following commands:
//
//   ./dev generate go
//   go generate ./pkg/sql/sem/tree
//
// If you use the dev command and you have added a new tree expression, like
// tree.XYZ in a new file, you may get the confusing error: undefined: XYZ.
// Run './dev generate bazel' to fix this.
package tree

import "context"


// UnaryEvalOp is a unary operation which can be evaluated.
type UnaryEvalOp interface {
	Eval(context.Context, OpEvaluator, Datum) (Datum, error)
}

// BinaryEvalOp is a binary operation which can be evaluated.
type BinaryEvalOp interface {
	Eval(context.Context, OpEvaluator, Datum, Datum) (Datum, error)
}

// OpEvaluator is an evaluator for UnaryEvalOp and BinaryEvalOp operations.
type OpEvaluator interface {
	UnaryOpEvaluator
	BinaryOpEvaluator
}

// UnaryOpEvaluator knows how to evaluate UnaryEvalOps.
type UnaryOpEvaluator interface {
	EvalCbrtDecimalOp(context.Context, *CbrtDecimalOp, Datum) (Datum, error)
	EvalCbrtFloatOp(context.Context, *CbrtFloatOp, Datum) (Datum, error)
	EvalComplementINetOp(context.Context, *ComplementINetOp, Datum) (Datum, error)
	EvalComplementIntOp(context.Context, *ComplementIntOp, Datum) (Datum, error)
	EvalComplementVarBitOp(context.Context, *ComplementVarBitOp, Datum) (Datum, error)
	EvalSqrtDecimalOp(context.Context, *SqrtDecimalOp, Datum) (Datum, error)
	EvalSqrtFloatOp(context.Context, *SqrtFloatOp, Datum) (Datum, error)
	EvalUnaryMinusDecimalOp(context.Context, *UnaryMinusDecimalOp, Datum) (Datum, error)
	EvalUnaryMinusFloatOp(context.Context, *UnaryMinusFloatOp, Datum) (Datum, error)
	EvalUnaryMinusIntOp(context.Context, *UnaryMinusIntOp, Datum) (Datum, error)
	EvalUnaryMinusIntervalOp(context.Context, *UnaryMinusIntervalOp, Datum) (Datum, error)
}

// UnaryOpEvaluator knows how to evaluate BinaryEvalOps.
type BinaryOpEvaluator interface {
	EvalAppendToMaybeNullArrayOp(context.Context, *AppendToMaybeNullArrayOp, Datum, Datum) (Datum, error)
	EvalBitAndINetOp(context.Context, *BitAndINetOp, Datum, Datum) (Datum, error)
	EvalBitAndIntOp(context.Context, *BitAndIntOp, Datum, Datum) (Datum, error)
	EvalBitAndVarBitOp(context.Context, *BitAndVarBitOp, Datum, Datum) (Datum, error)
	EvalBitOrINetOp(context.Context, *BitOrINetOp, Datum, Datum) (Datum, error)
	EvalBitOrIntOp(context.Context, *BitOrIntOp, Datum, Datum) (Datum, error)
	EvalBitOrVarBitOp(context.Context, *BitOrVarBitOp, Datum, Datum) (Datum, error)
	EvalBitXorIntOp(context.Context, *BitXorIntOp, Datum, Datum) (Datum, error)
	EvalBitXorVarBitOp(context.Context, *BitXorVarBitOp, Datum, Datum) (Datum, error)
	EvalCompareBox2DOp(context.Context, *CompareBox2DOp, Datum, Datum) (Datum, error)
	EvalCompareScalarOp(context.Context, *CompareScalarOp, Datum, Datum) (Datum, error)
	EvalCompareTupleOp(context.Context, *CompareTupleOp, Datum, Datum) (Datum, error)
	EvalConcatArraysOp(context.Context, *ConcatArraysOp, Datum, Datum) (Datum, error)
	EvalConcatBytesOp(context.Context, *ConcatBytesOp, Datum, Datum) (Datum, error)
	EvalConcatJsonbOp(context.Context, *ConcatJsonbOp, Datum, Datum) (Datum, error)
	EvalConcatOp(context.Context, *ConcatOp, Datum, Datum) (Datum, error)
	EvalConcatStringOp(context.Context, *ConcatStringOp, Datum, Datum) (Datum, error)
	EvalConcatVarBitOp(context.Context, *ConcatVarBitOp, Datum, Datum) (Datum, error)
	EvalContainedByArrayOp(context.Context, *ContainedByArrayOp, Datum, Datum) (Datum, error)
	EvalContainedByJsonbOp(context.Context, *ContainedByJsonbOp, Datum, Datum) (Datum, error)
	EvalContainsArrayOp(context.Context, *ContainsArrayOp, Datum, Datum) (Datum, error)
	EvalContainsJsonbOp(context.Context, *ContainsJsonbOp, Datum, Datum) (Datum, error)
	EvalCosDistanceVectorOp(context.Context, *CosDistanceVectorOp, Datum, Datum) (Datum, error)
	EvalDistanceVectorOp(context.Context, *DistanceVectorOp, Datum, Datum) (Datum, error)
	EvalDivDecimalIntOp(context.Context, *DivDecimalIntOp, Datum, Datum) (Datum, error)
	EvalDivDecimalOp(context.Context, *DivDecimalOp, Datum, Datum) (Datum, error)
	EvalDivFloatOp(context.Context, *DivFloatOp, Datum, Datum) (Datum, error)
	EvalDivIntDecimalOp(context.Context, *DivIntDecimalOp, Datum, Datum) (Datum, error)
	EvalDivIntOp(context.Context, *DivIntOp, Datum, Datum) (Datum, error)
	EvalDivIntervalFloatOp(context.Context, *DivIntervalFloatOp, Datum, Datum) (Datum, error)
	EvalDivIntervalIntOp(context.Context, *DivIntervalIntOp, Datum, Datum) (Datum, error)
	EvalFloorDivDecimalIntOp(context.Context, *FloorDivDecimalIntOp, Datum, Datum) (Datum, error)
	EvalFloorDivDecimalOp(context.Context, *FloorDivDecimalOp, Datum, Datum) (Datum, error)
	EvalFloorDivFloatOp(context.Context, *FloorDivFloatOp, Datum, Datum) (Datum, error)
	EvalFloorDivIntDecimalOp(context.Context, *FloorDivIntDecimalOp, Datum, Datum) (Datum, error)
	EvalFloorDivIntOp(context.Context, *FloorDivIntOp, Datum, Datum) (Datum, error)
	EvalInTupleOp(context.Context, *InTupleOp, Datum, Datum) (Datum, error)
	EvalJSONAllExistsOp(context.Context, *JSONAllExistsOp, Datum, Datum) (Datum, error)
	EvalJSONExistsOp(context.Context, *JSONExistsOp, Datum, Datum) (Datum, error)
	EvalJSONFetchTextIntOp(context.Context, *JSONFetchTextIntOp, Datum, Datum) (Datum, error)
	EvalJSONFetchTextPathOp(context.Context, *JSONFetchTextPathOp, Datum, Datum) (Datum, error)
	EvalJSONFetchTextStringOp(context.Context, *JSONFetchTextStringOp, Datum, Datum) (Datum, error)
	EvalJSONFetchValIntOp(context.Context, *JSONFetchValIntOp, Datum, Datum) (Datum, error)
	EvalJSONFetchValPathOp(context.Context, *JSONFetchValPathOp, Datum, Datum) (Datum, error)
	EvalJSONFetchValStringOp(context.Context, *JSONFetchValStringOp, Datum, Datum) (Datum, error)
	EvalJSONSomeExistsOp(context.Context, *JSONSomeExistsOp, Datum, Datum) (Datum, error)
	EvalLShiftINetOp(context.Context, *LShiftINetOp, Datum, Datum) (Datum, error)
	EvalLShiftIntOp(context.Context, *LShiftIntOp, Datum, Datum) (Datum, error)
	EvalLShiftVarBitIntOp(context.Context, *LShiftVarBitIntOp, Datum, Datum) (Datum, error)
	EvalMatchLikeOp(context.Context, *MatchLikeOp, Datum, Datum) (Datum, error)
	EvalMatchRegexpOp(context.Context, *MatchRegexpOp, Datum, Datum) (Datum, error)
	EvalMinusDateIntOp(context.Context, *MinusDateIntOp, Datum, Datum) (Datum, error)
	EvalMinusDateIntervalOp(context.Context, *MinusDateIntervalOp, Datum, Datum) (Datum, error)
	EvalMinusDateOp(context.Context, *MinusDateOp, Datum, Datum) (Datum, error)
	EvalMinusDateTimeOp(context.Context, *MinusDateTimeOp, Datum, Datum) (Datum, error)
	EvalMinusDecimalIntOp(context.Context, *MinusDecimalIntOp, Datum, Datum) (Datum, error)
	EvalMinusDecimalOp(context.Context, *MinusDecimalOp, Datum, Datum) (Datum, error)
	EvalMinusFloatOp(context.Context, *MinusFloatOp, Datum, Datum) (Datum, error)
	EvalMinusINetIntOp(context.Context, *MinusINetIntOp, Datum, Datum) (Datum, error)
	EvalMinusINetOp(context.Context, *MinusINetOp, Datum, Datum) (Datum, error)
	EvalMinusIntDecimalOp(context.Context, *MinusIntDecimalOp, Datum, Datum) (Datum, error)
	EvalMinusIntOp(context.Context, *MinusIntOp, Datum, Datum) (Datum, error)
	EvalMinusIntervalOp(context.Context, *MinusIntervalOp, Datum, Datum) (Datum, error)
	EvalMinusJsonbIntOp(context.Context, *MinusJsonbIntOp, Datum, Datum) (Datum, error)
	EvalMinusJsonbStringArrayOp(context.Context, *MinusJsonbStringArrayOp, Datum, Datum) (Datum, error)
	EvalMinusJsonbStringOp(context.Context, *MinusJsonbStringOp, Datum, Datum) (Datum, error)
	EvalMinusPGLSNDecimalOp(context.Context, *MinusPGLSNDecimalOp, Datum, Datum) (Datum, error)
	EvalMinusPGLSNOp(context.Context, *MinusPGLSNOp, Datum, Datum) (Datum, error)
	EvalMinusPGVectorOp(context.Context, *MinusPGVectorOp, Datum, Datum) (Datum, error)
	EvalMinusTimeIntervalOp(context.Context, *MinusTimeIntervalOp, Datum, Datum) (Datum, error)
	EvalMinusTimeOp(context.Context, *MinusTimeOp, Datum, Datum) (Datum, error)
	EvalMinusTimeTZIntervalOp(context.Context, *MinusTimeTZIntervalOp, Datum, Datum) (Datum, error)
	EvalMinusTimestampIntervalOp(context.Context, *MinusTimestampIntervalOp, Datum, Datum) (Datum, error)
	EvalMinusTimestampOp(context.Context, *MinusTimestampOp, Datum, Datum) (Datum, error)
	EvalMinusTimestampTZIntervalOp(context.Context, *MinusTimestampTZIntervalOp, Datum, Datum) (Datum, error)
	EvalMinusTimestampTZOp(context.Context, *MinusTimestampTZOp, Datum, Datum) (Datum, error)
	EvalMinusTimestampTZTimestampOp(context.Context, *MinusTimestampTZTimestampOp, Datum, Datum) (Datum, error)
	EvalMinusTimestampTimestampTZOp(context.Context, *MinusTimestampTimestampTZOp, Datum, Datum) (Datum, error)
	EvalModDecimalIntOp(context.Context, *ModDecimalIntOp, Datum, Datum) (Datum, error)
	EvalModDecimalOp(context.Context, *ModDecimalOp, Datum, Datum) (Datum, error)
	EvalModFloatOp(context.Context, *ModFloatOp, Datum, Datum) (Datum, error)
	EvalModIntDecimalOp(context.Context, *ModIntDecimalOp, Datum, Datum) (Datum, error)
	EvalModIntOp(context.Context, *ModIntOp, Datum, Datum) (Datum, error)
	EvalModStringOp(context.Context, *ModStringOp, Datum, Datum) (Datum, error)
	EvalMultDecimalIntOp(context.Context, *MultDecimalIntOp, Datum, Datum) (Datum, error)
	EvalMultDecimalIntervalOp(context.Context, *MultDecimalIntervalOp, Datum, Datum) (Datum, error)
	EvalMultDecimalOp(context.Context, *MultDecimalOp, Datum, Datum) (Datum, error)
	EvalMultFloatIntervalOp(context.Context, *MultFloatIntervalOp, Datum, Datum) (Datum, error)
	EvalMultFloatOp(context.Context, *MultFloatOp, Datum, Datum) (Datum, error)
	EvalMultIntDecimalOp(context.Context, *MultIntDecimalOp, Datum, Datum) (Datum, error)
	EvalMultIntIntervalOp(context.Context, *MultIntIntervalOp, Datum, Datum) (Datum, error)
	EvalMultIntOp(context.Context, *MultIntOp, Datum, Datum) (Datum, error)
	EvalMultIntervalDecimalOp(context.Context, *MultIntervalDecimalOp, Datum, Datum) (Datum, error)
	EvalMultIntervalFloatOp(context.Context, *MultIntervalFloatOp, Datum, Datum) (Datum, error)
	EvalMultIntervalIntOp(context.Context, *MultIntervalIntOp, Datum, Datum) (Datum, error)
	EvalMultPGVectorOp(context.Context, *MultPGVectorOp, Datum, Datum) (Datum, error)
	EvalNegInnerProductVectorOp(context.Context, *NegInnerProductVectorOp, Datum, Datum) (Datum, error)
	EvalOverlapsArrayOp(context.Context, *OverlapsArrayOp, Datum, Datum) (Datum, error)
	EvalOverlapsINetOp(context.Context, *OverlapsINetOp, Datum, Datum) (Datum, error)
	EvalPlusDateIntOp(context.Context, *PlusDateIntOp, Datum, Datum) (Datum, error)
	EvalPlusDateIntervalOp(context.Context, *PlusDateIntervalOp, Datum, Datum) (Datum, error)
	EvalPlusDateTimeOp(context.Context, *PlusDateTimeOp, Datum, Datum) (Datum, error)
	EvalPlusDateTimeTZOp(context.Context, *PlusDateTimeTZOp, Datum, Datum) (Datum, error)
	EvalPlusDecimalIntOp(context.Context, *PlusDecimalIntOp, Datum, Datum) (Datum, error)
	EvalPlusDecimalOp(context.Context, *PlusDecimalOp, Datum, Datum) (Datum, error)
	EvalPlusDecimalPGLSNOp(context.Context, *PlusDecimalPGLSNOp, Datum, Datum) (Datum, error)
	EvalPlusFloatOp(context.Context, *PlusFloatOp, Datum, Datum) (Datum, error)
	EvalPlusINetIntOp(context.Context, *PlusINetIntOp, Datum, Datum) (Datum, error)
	EvalPlusIntDateOp(context.Context, *PlusIntDateOp, Datum, Datum) (Datum, error)
	EvalPlusIntDecimalOp(context.Context, *PlusIntDecimalOp, Datum, Datum) (Datum, error)
	EvalPlusIntINetOp(context.Context, *PlusIntINetOp, Datum, Datum) (Datum, error)
	EvalPlusIntOp(context.Context, *PlusIntOp, Datum, Datum) (Datum, error)
	EvalPlusIntervalDateOp(context.Context, *PlusIntervalDateOp, Datum, Datum) (Datum, error)
	EvalPlusIntervalOp(context.Context, *PlusIntervalOp, Datum, Datum) (Datum, error)
	EvalPlusIntervalTimeOp(context.Context, *PlusIntervalTimeOp, Datum, Datum) (Datum, error)
	EvalPlusIntervalTimeTZOp(context.Context, *PlusIntervalTimeTZOp, Datum, Datum) (Datum, error)
	EvalPlusIntervalTimestampOp(context.Context, *PlusIntervalTimestampOp, Datum, Datum) (Datum, error)
	EvalPlusIntervalTimestampTZOp(context.Context, *PlusIntervalTimestampTZOp, Datum, Datum) (Datum, error)
	EvalPlusPGLSNDecimalOp(context.Context, *PlusPGLSNDecimalOp, Datum, Datum) (Datum, error)
	EvalPlusPGVectorOp(context.Context, *PlusPGVectorOp, Datum, Datum) (Datum, error)
	EvalPlusTimeDateOp(context.Context, *PlusTimeDateOp, Datum, Datum) (Datum, error)
	EvalPlusTimeIntervalOp(context.Context, *PlusTimeIntervalOp, Datum, Datum) (Datum, error)
	EvalPlusTimeTZDateOp(context.Context, *PlusTimeTZDateOp, Datum, Datum) (Datum, error)
	EvalPlusTimeTZIntervalOp(context.Context, *PlusTimeTZIntervalOp, Datum, Datum) (Datum, error)
	EvalPlusTimestampIntervalOp(context.Context, *PlusTimestampIntervalOp, Datum, Datum) (Datum, error)
	EvalPlusTimestampTZIntervalOp(context.Context, *PlusTimestampTZIntervalOp, Datum, Datum) (Datum, error)
	EvalPowDecimalIntOp(context.Context, *PowDecimalIntOp, Datum, Datum) (Datum, error)
	EvalPowDecimalOp(context.Context, *PowDecimalOp, Datum, Datum) (Datum, error)
	EvalPowFloatOp(context.Context, *PowFloatOp, Datum, Datum) (Datum, error)
	EvalPowIntDecimalOp(context.Context, *PowIntDecimalOp, Datum, Datum) (Datum, error)
	EvalPowIntOp(context.Context, *PowIntOp, Datum, Datum) (Datum, error)
	EvalPrependToMaybeNullArrayOp(context.Context, *PrependToMaybeNullArrayOp, Datum, Datum) (Datum, error)
	EvalRShiftINetOp(context.Context, *RShiftINetOp, Datum, Datum) (Datum, error)
	EvalRShiftIntOp(context.Context, *RShiftIntOp, Datum, Datum) (Datum, error)
	EvalRShiftVarBitIntOp(context.Context, *RShiftVarBitIntOp, Datum, Datum) (Datum, error)
	EvalSimilarToOp(context.Context, *SimilarToOp, Datum, Datum) (Datum, error)
	EvalTSMatchesQueryVectorOp(context.Context, *TSMatchesQueryVectorOp, Datum, Datum) (Datum, error)
	EvalTSMatchesVectorQueryOp(context.Context, *TSMatchesVectorQueryOp, Datum, Datum) (Datum, error)
}


// Eval is part of the UnaryEvalOp interface.
func (op *CbrtDecimalOp) Eval(ctx context.Context, e OpEvaluator, v Datum) (Datum, error) {
	return e.EvalCbrtDecimalOp(ctx, op, v)
}

// Eval is part of the UnaryEvalOp interface.
func (op *CbrtFloatOp) Eval(ctx context.Context, e OpEvaluator, v Datum) (Datum, error) {
	return e.EvalCbrtFloatOp(ctx, op, v)
}

// Eval is part of the UnaryEvalOp interface.
func (op *ComplementINetOp) Eval(ctx context.Context, e OpEvaluator, v Datum) (Datum, error) {
	return e.EvalComplementINetOp(ctx, op, v)
}

// Eval is part of the UnaryEvalOp interface.
func (op *ComplementIntOp) Eval(ctx context.Context, e OpEvaluator, v Datum) (Datum, error) {
	return e.EvalComplementIntOp(ctx, op, v)
}

// Eval is part of the UnaryEvalOp interface.
func (op *ComplementVarBitOp) Eval(ctx context.Context, e OpEvaluator, v Datum) (Datum, error) {
	return e.EvalComplementVarBitOp(ctx, op, v)
}

// Eval is part of the UnaryEvalOp interface.
func (op *SqrtDecimalOp) Eval(ctx context.Context, e OpEvaluator, v Datum) (Datum, error) {
	return e.EvalSqrtDecimalOp(ctx, op, v)
}

// Eval is part of the UnaryEvalOp interface.
func (op *SqrtFloatOp) Eval(ctx context.Context, e OpEvaluator, v Datum) (Datum, error) {
	return e.EvalSqrtFloatOp(ctx, op, v)
}

// Eval is part of the UnaryEvalOp interface.
func (op *UnaryMinusDecimalOp) Eval(ctx context.Context, e OpEvaluator, v Datum) (Datum, error) {
	return e.EvalUnaryMinusDecimalOp(ctx, op, v)
}

// Eval is part of the UnaryEvalOp interface.
func (op *UnaryMinusFloatOp) Eval(ctx context.Context, e OpEvaluator, v Datum) (Datum, error) {
	return e.EvalUnaryMinusFloatOp(ctx, op, v)
}

// Eval is part of the UnaryEvalOp interface.
func (op *UnaryMinusIntOp) Eval(ctx context.Context, e OpEvaluator, v Datum) (Datum, error) {
	return e.EvalUnaryMinusIntOp(ctx, op, v)
}

// Eval is part of the UnaryEvalOp interface.
func (op *UnaryMinusIntervalOp) Eval(ctx context.Context, e OpEvaluator, v Datum) (Datum, error) {
	return e.EvalUnaryMinusIntervalOp(ctx, op, v)
}

// Eval is part of the BinaryEvalOp interface.
func (op *AppendToMaybeNullArrayOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalAppendToMaybeNullArrayOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *BitAndINetOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalBitAndINetOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *BitAndIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalBitAndIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *BitAndVarBitOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalBitAndVarBitOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *BitOrINetOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalBitOrINetOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *BitOrIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalBitOrIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *BitOrVarBitOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalBitOrVarBitOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *BitXorIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalBitXorIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *BitXorVarBitOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalBitXorVarBitOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *CompareBox2DOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalCompareBox2DOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *CompareScalarOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalCompareScalarOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *CompareTupleOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalCompareTupleOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *ConcatArraysOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalConcatArraysOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *ConcatBytesOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalConcatBytesOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *ConcatJsonbOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalConcatJsonbOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *ConcatOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalConcatOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *ConcatStringOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalConcatStringOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *ConcatVarBitOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalConcatVarBitOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *ContainedByArrayOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalContainedByArrayOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *ContainedByJsonbOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalContainedByJsonbOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *ContainsArrayOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalContainsArrayOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *ContainsJsonbOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalContainsJsonbOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *CosDistanceVectorOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalCosDistanceVectorOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *DistanceVectorOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalDistanceVectorOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *DivDecimalIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalDivDecimalIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *DivDecimalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalDivDecimalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *DivFloatOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalDivFloatOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *DivIntDecimalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalDivIntDecimalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *DivIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalDivIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *DivIntervalFloatOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalDivIntervalFloatOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *DivIntervalIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalDivIntervalIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *FloorDivDecimalIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalFloorDivDecimalIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *FloorDivDecimalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalFloorDivDecimalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *FloorDivFloatOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalFloorDivFloatOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *FloorDivIntDecimalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalFloorDivIntDecimalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *FloorDivIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalFloorDivIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *InTupleOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalInTupleOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *JSONAllExistsOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalJSONAllExistsOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *JSONExistsOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalJSONExistsOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *JSONFetchTextIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalJSONFetchTextIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *JSONFetchTextPathOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalJSONFetchTextPathOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *JSONFetchTextStringOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalJSONFetchTextStringOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *JSONFetchValIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalJSONFetchValIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *JSONFetchValPathOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalJSONFetchValPathOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *JSONFetchValStringOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalJSONFetchValStringOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *JSONSomeExistsOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalJSONSomeExistsOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *LShiftINetOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalLShiftINetOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *LShiftIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalLShiftIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *LShiftVarBitIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalLShiftVarBitIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MatchLikeOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMatchLikeOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MatchRegexpOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMatchRegexpOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusDateIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusDateIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusDateIntervalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusDateIntervalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusDateOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusDateOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusDateTimeOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusDateTimeOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusDecimalIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusDecimalIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusDecimalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusDecimalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusFloatOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusFloatOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusINetIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusINetIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusINetOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusINetOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusIntDecimalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusIntDecimalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusIntervalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusIntervalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusJsonbIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusJsonbIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusJsonbStringArrayOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusJsonbStringArrayOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusJsonbStringOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusJsonbStringOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusPGLSNDecimalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusPGLSNDecimalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusPGLSNOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusPGLSNOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusPGVectorOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusPGVectorOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusTimeIntervalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusTimeIntervalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusTimeOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusTimeOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusTimeTZIntervalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusTimeTZIntervalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusTimestampIntervalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusTimestampIntervalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusTimestampOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusTimestampOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusTimestampTZIntervalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusTimestampTZIntervalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusTimestampTZOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusTimestampTZOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusTimestampTZTimestampOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusTimestampTZTimestampOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MinusTimestampTimestampTZOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMinusTimestampTimestampTZOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *ModDecimalIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalModDecimalIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *ModDecimalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalModDecimalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *ModFloatOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalModFloatOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *ModIntDecimalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalModIntDecimalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *ModIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalModIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *ModStringOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalModStringOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MultDecimalIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMultDecimalIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MultDecimalIntervalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMultDecimalIntervalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MultDecimalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMultDecimalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MultFloatIntervalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMultFloatIntervalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MultFloatOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMultFloatOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MultIntDecimalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMultIntDecimalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MultIntIntervalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMultIntIntervalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MultIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMultIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MultIntervalDecimalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMultIntervalDecimalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MultIntervalFloatOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMultIntervalFloatOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MultIntervalIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMultIntervalIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *MultPGVectorOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalMultPGVectorOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *NegInnerProductVectorOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalNegInnerProductVectorOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *OverlapsArrayOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalOverlapsArrayOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *OverlapsINetOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalOverlapsINetOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusDateIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusDateIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusDateIntervalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusDateIntervalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusDateTimeOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusDateTimeOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusDateTimeTZOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusDateTimeTZOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusDecimalIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusDecimalIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusDecimalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusDecimalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusDecimalPGLSNOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusDecimalPGLSNOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusFloatOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusFloatOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusINetIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusINetIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusIntDateOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusIntDateOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusIntDecimalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusIntDecimalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusIntINetOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusIntINetOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusIntervalDateOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusIntervalDateOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusIntervalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusIntervalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusIntervalTimeOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusIntervalTimeOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusIntervalTimeTZOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusIntervalTimeTZOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusIntervalTimestampOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusIntervalTimestampOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusIntervalTimestampTZOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusIntervalTimestampTZOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusPGLSNDecimalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusPGLSNDecimalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusPGVectorOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusPGVectorOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusTimeDateOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusTimeDateOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusTimeIntervalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusTimeIntervalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusTimeTZDateOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusTimeTZDateOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusTimeTZIntervalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusTimeTZIntervalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusTimestampIntervalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusTimestampIntervalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PlusTimestampTZIntervalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPlusTimestampTZIntervalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PowDecimalIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPowDecimalIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PowDecimalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPowDecimalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PowFloatOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPowFloatOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PowIntDecimalOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPowIntDecimalOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PowIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPowIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *PrependToMaybeNullArrayOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalPrependToMaybeNullArrayOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *RShiftINetOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalRShiftINetOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *RShiftIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalRShiftIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *RShiftVarBitIntOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalRShiftVarBitIntOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *SimilarToOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalSimilarToOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *TSMatchesQueryVectorOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalTSMatchesQueryVectorOp(ctx, op, a, b)
}

// Eval is part of the BinaryEvalOp interface.
func (op *TSMatchesVectorQueryOp) Eval(ctx context.Context, e OpEvaluator, a, b Datum) (Datum, error) {
	return e.EvalTSMatchesVectorQueryOp(ctx, op, a, b)
}

