// Copyright 2022 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by sctestgen, DO NOT EDIT.

package schemachanger

import (
	"testing"

	"github.com/cockroachdb/cockroach/pkg/sql/schemachanger/sctest"
	"github.com/cockroachdb/cockroach/pkg/util/leaktest"
	"github.com/cockroachdb/cockroach/pkg/util/log"
)

func TestEndToEndSideEffects_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_add_column_default_seq(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_seq"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_add_column_default_unique(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_add_column_default_unique_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique_not_null"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_add_column_no_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_no_default"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_add_column_serial_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_rowid"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_add_column_serial_simple_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_add_column_serial_simple_sequence_cached(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_add_column_serial_simple_sequence_cached_node(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached_node"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_add_column_serial_simple_sequence_virtual(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_virtual"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_add_column_serial_unordered_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_unordered_rowid"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_add_column_virtual_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_virtual_not_null"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_add_column_with_stored(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_add_column_with_stored_family(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored_family"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_database_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_database_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_discard"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_database_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_multiple"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_index_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_index_configure_zone_discard"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_named_range_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_named_range_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_discard"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_named_range_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_multiple"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_add_check_udf(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_udf"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_add_check_unvalidated(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_unvalidated"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_add_check_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_vanilla"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_add_check_with_seq_and_udt(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_with_seq_and_udt"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_add_foreign_key(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_foreign_key"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_add_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_add_primary_key_drop_rowid_with_secondary_idx(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid_with_secondary_idx"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_add_unique_without_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_unique_without_index"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_alter_column_drop_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_drop_default"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_alter_column_set_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_default"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_alter_column_set_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_not_null"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_alter_column_type_general(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_alter_column_type_general_expr(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general_expr"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_alter_column_type_noop(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_noop"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_alter_column_type_trivial(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_trivial"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_alter_column_type_validation(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_validation"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_alter_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_drop_rowid"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_alter_primary_key_using_hash(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_using_hash"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_alter_primary_key_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_vanilla"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_discard"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_multiple"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_drop_add_same_col_implicit(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_add_same_col_implicit"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_drop_constraint_check(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_check"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_drop_constraint_fk(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_fk"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_drop_constraint_uwi(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_uwi"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_multiple_commands(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_multiple_commands"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_alter_table_validate_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_validate_constraint"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_composite"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_enum"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_create_complex(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_complex"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_create_database(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_create_database_drop_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database_drop_database_separate_statements"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_create_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_create_function_calling_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_calling_function"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_create_function_in_txn(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_in_txn"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_create_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_create_index_create_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_database_separate_statements"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_create_index_create_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_schema_separate_statements"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_create_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_create_schema_drop_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema_drop_schema_separate_statements"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_create_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_create_sequence_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_add_column"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_create_sequence_drop_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_drop_sequence"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_create_temp_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_temp_sequence"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_column_basic(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_basic"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_column_computed_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_computed_index"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_column_create_index_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_create_index_separate_statements"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_column_sequence_owner(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_sequence_owner"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_column_unique_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_unique_index"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_column_with_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_index"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_column_with_null_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_null_constraint"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_column_with_partial_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_partial_index"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_column_with_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_udf_default"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_composite"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_enum"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_function"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_index_hash_sharded_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_hash_sharded_index"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_index_partial_expression_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_partial_expression_index"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_index_vanilla_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_vanilla_index"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_index_with_fks(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_fks"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_index_with_materialized_view_dep(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_materialized_view_dep"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_multiple_columns_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_multiple_columns_separate_statements"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_schema"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_table(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestEndToEndSideEffects_drop_table_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table_udf_default"
	sctest.EndToEndSideEffects(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_add_column_default_seq(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_seq"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_add_column_default_unique(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_add_column_default_unique_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique_not_null"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_add_column_no_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_no_default"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_add_column_serial_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_rowid"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_add_column_serial_simple_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_add_column_serial_simple_sequence_cached(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_add_column_serial_simple_sequence_cached_node(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached_node"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_add_column_serial_simple_sequence_virtual(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_virtual"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_add_column_serial_unordered_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_unordered_rowid"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_add_column_virtual_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_virtual_not_null"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_add_column_with_stored(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_add_column_with_stored_family(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored_family"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_database_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_database_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_discard"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_database_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_multiple"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_index_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_index_configure_zone_discard"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_named_range_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_named_range_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_discard"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_named_range_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_multiple"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_add_check_udf(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_udf"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_add_check_unvalidated(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_unvalidated"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_add_check_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_vanilla"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_add_check_with_seq_and_udt(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_with_seq_and_udt"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_add_foreign_key(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_foreign_key"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_add_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_add_primary_key_drop_rowid_with_secondary_idx(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid_with_secondary_idx"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_add_unique_without_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_unique_without_index"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_alter_column_drop_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_drop_default"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_alter_column_set_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_default"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_alter_column_set_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_not_null"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_alter_column_type_general(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_alter_column_type_general_expr(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general_expr"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_alter_column_type_noop(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_noop"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_alter_column_type_trivial(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_trivial"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_alter_column_type_validation(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_validation"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_alter_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_drop_rowid"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_alter_primary_key_using_hash(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_using_hash"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_alter_primary_key_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_vanilla"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_discard"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_multiple"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_drop_add_same_col_implicit(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_add_same_col_implicit"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_drop_constraint_check(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_check"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_drop_constraint_fk(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_fk"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_drop_constraint_uwi(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_uwi"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_multiple_commands(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_multiple_commands"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_alter_table_validate_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_validate_constraint"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_composite"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_enum"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_create_complex(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_complex"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_create_database(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_create_database_drop_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database_drop_database_separate_statements"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_create_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_create_function_calling_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_calling_function"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_create_function_in_txn(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_in_txn"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_create_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_create_index_create_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_database_separate_statements"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_create_index_create_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_schema_separate_statements"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_create_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_create_schema_drop_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema_drop_schema_separate_statements"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_create_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_create_sequence_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_add_column"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_create_sequence_drop_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_drop_sequence"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_create_temp_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_temp_sequence"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_column_basic(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_basic"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_column_computed_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_computed_index"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_column_create_index_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_create_index_separate_statements"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_column_sequence_owner(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_sequence_owner"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_column_unique_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_unique_index"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_column_with_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_index"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_column_with_null_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_null_constraint"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_column_with_partial_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_partial_index"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_column_with_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_udf_default"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_composite"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_enum"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_function"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_index_hash_sharded_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_hash_sharded_index"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_index_partial_expression_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_partial_expression_index"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_index_vanilla_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_vanilla_index"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_index_with_fks(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_fks"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_index_with_materialized_view_dep(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_materialized_view_dep"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_multiple_columns_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_multiple_columns_separate_statements"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_schema"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_table(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestExecuteWithDMLInjection_drop_table_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table_udf_default"
	sctest.ExecuteWithDMLInjection(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_add_column_default_seq(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_seq"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_add_column_default_unique(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_add_column_default_unique_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique_not_null"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_add_column_no_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_no_default"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_add_column_serial_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_rowid"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_add_column_serial_simple_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_add_column_serial_simple_sequence_cached(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_add_column_serial_simple_sequence_cached_node(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached_node"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_add_column_serial_simple_sequence_virtual(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_virtual"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_add_column_serial_unordered_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_unordered_rowid"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_add_column_virtual_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_virtual_not_null"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_add_column_with_stored(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_add_column_with_stored_family(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored_family"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_database_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_database_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_discard"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_database_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_multiple"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_index_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_index_configure_zone_discard"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_named_range_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_named_range_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_discard"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_named_range_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_multiple"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_add_check_udf(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_udf"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_add_check_unvalidated(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_unvalidated"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_add_check_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_vanilla"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_add_check_with_seq_and_udt(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_with_seq_and_udt"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_add_foreign_key(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_foreign_key"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_add_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_add_primary_key_drop_rowid_with_secondary_idx(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid_with_secondary_idx"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_add_unique_without_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_unique_without_index"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_alter_column_drop_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_drop_default"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_alter_column_set_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_default"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_alter_column_set_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_not_null"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_alter_column_type_general(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_alter_column_type_general_expr(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general_expr"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_alter_column_type_noop(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_noop"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_alter_column_type_trivial(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_trivial"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_alter_column_type_validation(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_validation"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_alter_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_drop_rowid"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_alter_primary_key_using_hash(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_using_hash"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_alter_primary_key_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_vanilla"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_discard"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_multiple"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_drop_add_same_col_implicit(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_add_same_col_implicit"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_drop_constraint_check(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_check"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_drop_constraint_fk(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_fk"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_drop_constraint_uwi(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_uwi"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_multiple_commands(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_multiple_commands"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_alter_table_validate_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_validate_constraint"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_composite"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_enum"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_create_complex(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_complex"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_create_database(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_create_database_drop_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database_drop_database_separate_statements"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_create_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_create_function_calling_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_calling_function"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_create_function_in_txn(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_in_txn"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_create_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_create_index_create_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_database_separate_statements"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_create_index_create_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_schema_separate_statements"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_create_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_create_schema_drop_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema_drop_schema_separate_statements"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_create_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_create_sequence_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_add_column"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_create_sequence_drop_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_drop_sequence"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_create_temp_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_temp_sequence"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_column_basic(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_basic"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_column_computed_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_computed_index"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_column_create_index_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_create_index_separate_statements"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_column_sequence_owner(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_sequence_owner"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_column_unique_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_unique_index"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_column_with_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_index"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_column_with_null_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_null_constraint"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_column_with_partial_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_partial_index"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_column_with_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_udf_default"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_composite"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_enum"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_function"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_index_hash_sharded_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_hash_sharded_index"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_index_partial_expression_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_partial_expression_index"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_index_vanilla_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_vanilla_index"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_index_with_fks(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_fks"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_index_with_materialized_view_dep(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_materialized_view_dep"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_multiple_columns_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_multiple_columns_separate_statements"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_schema"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_table(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestGenerateSchemaChangeCorpus_drop_table_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table_udf_default"
	sctest.GenerateSchemaChangeCorpus(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_add_column_default_seq(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_seq"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_add_column_default_unique(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_add_column_default_unique_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique_not_null"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_add_column_no_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_no_default"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_add_column_serial_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_rowid"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_add_column_serial_simple_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_add_column_serial_simple_sequence_cached(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_add_column_serial_simple_sequence_cached_node(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached_node"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_add_column_serial_simple_sequence_virtual(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_virtual"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_add_column_serial_unordered_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_unordered_rowid"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_add_column_virtual_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_virtual_not_null"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_add_column_with_stored(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_add_column_with_stored_family(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored_family"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_database_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_database_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_discard"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_database_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_multiple"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_index_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_index_configure_zone_discard"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_named_range_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_named_range_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_discard"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_named_range_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_multiple"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_add_check_udf(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_udf"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_add_check_unvalidated(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_unvalidated"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_add_check_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_vanilla"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_add_check_with_seq_and_udt(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_with_seq_and_udt"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_add_foreign_key(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_foreign_key"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_add_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_add_primary_key_drop_rowid_with_secondary_idx(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid_with_secondary_idx"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_add_unique_without_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_unique_without_index"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_alter_column_drop_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_drop_default"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_alter_column_set_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_default"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_alter_column_set_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_not_null"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_alter_column_type_general(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_alter_column_type_general_expr(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general_expr"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_alter_column_type_noop(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_noop"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_alter_column_type_trivial(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_trivial"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_alter_column_type_validation(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_validation"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_alter_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_drop_rowid"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_alter_primary_key_using_hash(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_using_hash"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_alter_primary_key_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_vanilla"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_discard"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_multiple"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_drop_add_same_col_implicit(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_add_same_col_implicit"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_drop_constraint_check(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_check"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_drop_constraint_fk(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_fk"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_drop_constraint_uwi(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_uwi"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_multiple_commands(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_multiple_commands"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_alter_table_validate_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_validate_constraint"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_composite"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_enum"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_create_complex(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_complex"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_create_database(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_create_database_drop_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database_drop_database_separate_statements"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_create_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_create_function_calling_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_calling_function"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_create_function_in_txn(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_in_txn"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_create_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_create_index_create_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_database_separate_statements"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_create_index_create_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_schema_separate_statements"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_create_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_create_schema_drop_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema_drop_schema_separate_statements"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_create_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_create_sequence_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_add_column"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_create_sequence_drop_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_drop_sequence"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_create_temp_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_temp_sequence"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_column_basic(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_basic"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_column_computed_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_computed_index"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_column_create_index_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_create_index_separate_statements"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_column_sequence_owner(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_sequence_owner"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_column_unique_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_unique_index"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_column_with_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_index"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_column_with_null_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_null_constraint"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_column_with_partial_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_partial_index"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_column_with_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_udf_default"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_composite"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_enum"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_function"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_index_hash_sharded_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_hash_sharded_index"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_index_partial_expression_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_partial_expression_index"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_index_vanilla_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_vanilla_index"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_index_with_fks(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_fks"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_index_with_materialized_view_dep(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_materialized_view_dep"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_multiple_columns_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_multiple_columns_separate_statements"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_schema"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_table(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPause_drop_table_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table_udf_default"
	sctest.Pause(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_add_column_default_seq(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_seq"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_add_column_default_unique(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_add_column_default_unique_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique_not_null"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_add_column_no_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_no_default"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_add_column_serial_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_rowid"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_add_column_serial_simple_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_add_column_serial_simple_sequence_cached(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_add_column_serial_simple_sequence_cached_node(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached_node"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_add_column_serial_simple_sequence_virtual(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_virtual"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_add_column_serial_unordered_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_unordered_rowid"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_add_column_virtual_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_virtual_not_null"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_add_column_with_stored(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_add_column_with_stored_family(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored_family"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_database_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_database_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_discard"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_database_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_multiple"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_index_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_index_configure_zone_discard"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_named_range_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_named_range_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_discard"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_named_range_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_multiple"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_add_check_udf(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_udf"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_add_check_unvalidated(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_unvalidated"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_add_check_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_vanilla"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_add_check_with_seq_and_udt(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_with_seq_and_udt"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_add_foreign_key(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_foreign_key"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_add_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_add_primary_key_drop_rowid_with_secondary_idx(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid_with_secondary_idx"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_add_unique_without_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_unique_without_index"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_alter_column_drop_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_drop_default"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_alter_column_set_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_default"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_alter_column_set_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_not_null"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_alter_column_type_general(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_alter_column_type_general_expr(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general_expr"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_alter_column_type_noop(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_noop"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_alter_column_type_trivial(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_trivial"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_alter_column_type_validation(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_validation"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_alter_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_drop_rowid"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_alter_primary_key_using_hash(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_using_hash"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_alter_primary_key_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_vanilla"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_discard"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_multiple"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_drop_add_same_col_implicit(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_add_same_col_implicit"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_drop_constraint_check(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_check"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_drop_constraint_fk(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_fk"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_drop_constraint_uwi(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_uwi"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_multiple_commands(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_multiple_commands"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_alter_table_validate_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_validate_constraint"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_composite"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_enum"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_create_complex(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_complex"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_create_database(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_create_database_drop_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database_drop_database_separate_statements"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_create_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_create_function_calling_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_calling_function"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_create_function_in_txn(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_in_txn"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_create_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_create_index_create_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_database_separate_statements"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_create_index_create_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_schema_separate_statements"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_create_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_create_schema_drop_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema_drop_schema_separate_statements"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_create_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_create_sequence_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_add_column"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_create_sequence_drop_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_drop_sequence"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_create_temp_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_temp_sequence"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_column_basic(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_basic"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_column_computed_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_computed_index"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_column_create_index_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_create_index_separate_statements"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_column_sequence_owner(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_sequence_owner"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_column_unique_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_unique_index"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_column_with_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_index"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_column_with_null_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_null_constraint"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_column_with_partial_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_partial_index"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_column_with_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_udf_default"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_composite"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_enum"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_function"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_index_hash_sharded_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_hash_sharded_index"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_index_partial_expression_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_partial_expression_index"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_index_vanilla_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_vanilla_index"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_index_with_fks(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_fks"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_index_with_materialized_view_dep(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_materialized_view_dep"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_multiple_columns_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_multiple_columns_separate_statements"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_schema"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_table(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestPauseMixedVersion_drop_table_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table_udf_default"
	sctest.PauseMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_add_column_default_seq(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_seq"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_add_column_default_unique(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_add_column_default_unique_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique_not_null"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_add_column_no_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_no_default"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_add_column_serial_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_rowid"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_add_column_serial_simple_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_add_column_serial_simple_sequence_cached(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_add_column_serial_simple_sequence_cached_node(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached_node"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_add_column_serial_simple_sequence_virtual(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_virtual"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_add_column_serial_unordered_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_unordered_rowid"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_add_column_virtual_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_virtual_not_null"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_add_column_with_stored(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_add_column_with_stored_family(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored_family"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_database_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_database_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_discard"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_database_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_multiple"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_index_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_index_configure_zone_discard"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_named_range_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_named_range_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_discard"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_named_range_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_multiple"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_add_check_udf(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_udf"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_add_check_unvalidated(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_unvalidated"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_add_check_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_vanilla"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_add_check_with_seq_and_udt(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_with_seq_and_udt"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_add_foreign_key(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_foreign_key"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_add_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_add_primary_key_drop_rowid_with_secondary_idx(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid_with_secondary_idx"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_add_unique_without_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_unique_without_index"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_alter_column_drop_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_drop_default"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_alter_column_set_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_default"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_alter_column_set_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_not_null"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_alter_column_type_general(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_alter_column_type_general_expr(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general_expr"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_alter_column_type_noop(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_noop"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_alter_column_type_trivial(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_trivial"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_alter_column_type_validation(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_validation"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_alter_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_drop_rowid"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_alter_primary_key_using_hash(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_using_hash"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_alter_primary_key_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_vanilla"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_discard"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_multiple"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_drop_add_same_col_implicit(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_add_same_col_implicit"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_drop_constraint_check(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_check"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_drop_constraint_fk(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_fk"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_drop_constraint_uwi(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_uwi"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_multiple_commands(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_multiple_commands"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_alter_table_validate_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_validate_constraint"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_composite"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_enum"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_create_complex(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_complex"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_create_database(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_create_database_drop_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database_drop_database_separate_statements"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_create_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_create_function_calling_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_calling_function"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_create_function_in_txn(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_in_txn"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_create_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_create_index_create_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_database_separate_statements"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_create_index_create_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_schema_separate_statements"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_create_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_create_schema_drop_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema_drop_schema_separate_statements"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_create_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_create_sequence_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_add_column"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_create_sequence_drop_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_drop_sequence"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_create_temp_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_temp_sequence"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_column_basic(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_basic"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_column_computed_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_computed_index"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_column_create_index_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_create_index_separate_statements"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_column_sequence_owner(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_sequence_owner"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_column_unique_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_unique_index"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_column_with_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_index"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_column_with_null_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_null_constraint"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_column_with_partial_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_partial_index"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_column_with_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_udf_default"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_composite"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_enum"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_function"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_index_hash_sharded_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_hash_sharded_index"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_index_partial_expression_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_partial_expression_index"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_index_vanilla_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_vanilla_index"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_index_with_fks(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_fks"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_index_with_materialized_view_dep(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_materialized_view_dep"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_multiple_columns_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_multiple_columns_separate_statements"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_schema"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_table(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestRollback_drop_table_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table_udf_default"
	sctest.Rollback(t, path, sctest.SingleNodeTestClusterFactory{})
}
